Ext.onReady(function() {

	Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

	var tools = [ {
		id : 'refresh',
		handler : function(event, toolEl, panel) {
			var id = 'portal-iframe-' + panel.portalId;
			document.getElementById(id).contentWindow.location.reload();
		}
	} ];
	var items1 = [];
	var items2 = [];

	var tmp;
	if (mainPortalArray) {
		for ( var i = 0, j = mainPortalArray.length; i < j; i++) {
			tmp = {
				title : mainPortalArray[i].title,
				portalId : mainPortalArray[i].portalId,
				x : mainPortalArray[i].x,
				y : mainPortalArray[i].y,
				collapsed : mainPortalArray[i].collapsed,
				style : 'x-real-panel',
				layout : 'fit',
				height : 300,
				tools : tools,
				html : '',
				tempHtml : '<iframe id="portal-iframe-'
						+ mainPortalArray[i].portalId + '" src="'
						+ mainPortalArray[i].url
						+ '" height="270" width="100%"'
						+ ' scrolling="no" frameborder="0" style="overflow:hidden"></iframe>',
				listeners : {
					'beforerender' : function() {
						this.html = this.tempHtml;
					}
				}
			};			
			if (mainPortalArray[i].x == 1) {
				items1.push(tmp);
			} else {
				items2.push(tmp);
			}
		}
	}

	function getOriginPortal(portalId) {
		for ( var i = 0, j = items1.length; i < j; i++) {
			if (items1[i].portalId == portalId) {
				return items1[i];
			}
		}
		for ( var i = 0, j = items2.length; i < j; i++) {
			if (items2[i].portalId == portalId) {
				return items2[i];
			}
		}
	}

	var updateButton = {
		xtype : 'button',
		text : saveLayoutText,
		iconCls : 'x-tbar-save',
		handler : function() {
			var mainPortal = Ext.getCmp('main-Portal');
			var param = [];
			var cmp, tmpItem, tmpCmp;

			for ( var x = 0, len = mainPortal.items.length; x < len; x++) {
				cmp = mainPortal.items.get(x).items;
				for ( var i = 0, j = cmp.length; i < j; i++) {
					tmpCmp = cmp.get(i);
					tmpItem = getOriginPortal(tmpCmp.portalId);
					if (tmpItem) {
						if (tmpItem.x != (x + 1) || tmpItem.y != i + 1
								|| tmpItem.collapsed != tmpCmp.collapsed) {
							param.push(tmpCmp.portalId + '-' + (x + 1) + '-'
									+ (i + 1) + '-' + tmpCmp.collapsed);
						}
					}
				}
			}
			LegoTag.Msg.wait();
			if (param.length > 0) {
				LegoTag.Ajax.request( {
					url : WEB_ROOT_ABS_PATH + '/cbb/custom/editPortal.do',
					params : {
						ids : param
					},
					success : function(response) {
						if (response.responseText == 'success') {
							LegoTag.Msg.succeed(MSG_SUC, function() {
								location.reload();
							});
						}
					}
				});

			} else {
				LegoTag.Msg.succeed(MSG_SUC);
			}
		}
	};
	if (mainPortalArray && mainPortalArray.length == 0) {
		new Ext.Viewport( {
			layout : 'fit',
			items : [ {
				layout : 'fit',
				bodyStyle:'overflow-x:hidden',
				tbar : [ {
					xtype : 'button',
					text : selectCompText,
					iconCls : 'x-tbar-setting2',
					handler : popListWin
				} ],
				items : [ {
					bodyStyle : '',
					html : welcomeHTML
				} ]
			} ]
		});
	}else{
		if (document.documentMode == 10 || document.documentMode == 9) {
			var _width = (document.body.offsetWidth - 17) / 2;
			wid = _width - 3 - _width % 1;
			new Ext.Viewport(
					{
						layout : 'fit',
						items : [ {
						layout : 'fit',
						bodyStyle : 'overflow-x:hidden',
						tbar : [ {
							xtype : 'button',
							text : selectCompText,
							iconCls : 'x-tbar-setting2',
							handler : popListWin
						}, '-', updateButton ],
						items : [ {
								xtype : 'portal',
								border : false,
								bodyStyle : 'overflow-x:hidden',
								id : 'main-Portal',
								items : [
										{
											style : 'padding:0px 2px 5px 1px;background:#49494c; width:'
													+ wid + 'px;',
											items : items1
										},
										{
											style : 'padding:0px 2px 5px 1px;background:#49494c; width:'
													+ wid + 'px;',
											items : items2
										} ]
							} ]
						} ]
					});
		} else {
			new Ext.Viewport(
					{
						layout : 'fit',
						items : [ {
							layout : 'fit',
							bodyStyle : 'overflow-x:hidden',
							tbar : [ {
								xtype : 'button',
								text : selectCompText,
								iconCls : 'x-tbar-setting2',
								handler : popListWin
							}, '-', updateButton ],
							items : [ {
								xtype : 'portal',
								border : false,
								bodyStyle : 'overflow-x:hidden',
								id : 'main-Portal',
								items : [
										{
											columnWidth : .5,
											style : 'padding:0px 2px 5px 1px;background:#49494c;',
											items : items1
										},
										{
											columnWidth : .5,
											style : 'padding:0px 2px 5px 1px;background:#49494c;',
											items : items2
										} ]
							} ]
						} ]
					});
		}
	}
	$('.x-tool.x-tool-toggle').remove();
});