var packname="/cbb/res/";
function getSnmpDetail()
{
   var templateId;
   if(preCombDisplay=="SNMPv1")
	{	
		templateId = LegoTag.getCombValue("snmpTemplateCombv1");
	}
	else if(preCombDisplay=="SNMPv2c")
	{
		templateId = LegoTag.getCombValue("snmpTemplateCombv2");
	}
	else if(preCombDisplay=="SNMPv3")
	{
		templateId = LegoTag.getCombValue("snmpTemplateCombv3");
	}
   if( -1 == templateId)
   {
   	  return ;
   }
   
   var url = WEB_ROOT_ABS_PATH + packname + "getSnmpTemplateDetail.do";
            
   LegoTag.Ajax.request({
		url : url,
		method : 'post',
		params : {
			templateId : templateId							
		},
		success : function(response, options) {
			var snmpTemplateInfo = Ext.util.JSON.decode(response.responseText);
                  refreshSnmpDetail(snmpTemplateInfo);
		}
	});
}
function refreshSnmpDetail( snmpTemplateInfo )
{
   var version =  snmpTemplateInfo[0].version;
   if( version == 0 )
   {
	   document.getElementById("v1retries").value = snmpTemplateInfo[0].retries;
	   document.getElementById("v1port").value = snmpTemplateInfo[0].port;
	   document.getElementById("v1readComm").value = snmpTemplateInfo[0].readComm;
	   document.getElementById("v1writeComm").value = snmpTemplateInfo[0].writeComm;
	   document.getElementById("v1timeout").value =  snmpTemplateInfo[0].timeout;
	   document.getElementById("snmpTemplateCombv1").focus();
   }
   if( version == 1 )
   {
	   document.getElementById("v2retries").value = snmpTemplateInfo[0].retries;
	   document.getElementById("v2port").value = snmpTemplateInfo[0].port;
	   document.getElementById("v2readComm").value = snmpTemplateInfo[0].readComm;
	   document.getElementById("v2writeComm").value = snmpTemplateInfo[0].writeComm;
	   document.getElementById("v2timeout").value =  snmpTemplateInfo[0].timeout;	
	   document.getElementById("snmpTemplateCombv2").focus();		        
   }
   if( version == 3 )
   {
	   document.getElementById("v3retries").value = snmpTemplateInfo[0].retries;
	   document.getElementById("v3port").value = snmpTemplateInfo[0].port;
	   document.getElementById("v3timeout").value =  snmpTemplateInfo[0].timeout;
	   document.getElementById("v3securityName").value =  snmpTemplateInfo[0].securityName;
	   document.getElementById("v3contextName").value =  snmpTemplateInfo[0].contextName;
	   document.getElementById("v3contextEngineId").value =  snmpTemplateInfo[0].contextEngineId;
	   document.getElementById("v3encryptProtocol").value =  snmpTemplateInfo[0].encryptProtocol;
	   document.getElementById("v3encryptPwd").value =  snmpTemplateInfo[0].encryptPwd;
	   document.getElementById("v3authProtocol").value =  snmpTemplateInfo[0].authProtocol;
	   document.getElementById("v3authPwd").value =  snmpTemplateInfo[0].authPwd;
	   checkIn();
	   checkInput();	        
	   document.getElementById("snmpTemplateCombv3").focus();
   }
}

var preComboVal=3;
var preCombDisplay="SNMPv3";
var preComboTelVal=2;
var preComboDisplay="STELNET";

function optTelnet()
{
	alert("optTelnet called!");
	userPrivateKey = "";
	var isOptTelnet = LegoTag.getChecked("isOptTelnet");
	if(isOptTelnet === true)
	{
		LegoTag.setCombDisabled("combTelnetType",false);
		LegoTag.setCombDisabled("telnetTemplateComb",false);
		LegoTag.setCombDisabled("combsTelnetType",false);
		LegoTag.setCombDisabled("stelnetTemplateComb",false);
		LegoTag.setDisabled("loginTimeout", false);
		LegoTag.setDisabled("responseTimeout", false);
		LegoTag.setCombDisabled("authModeSelect", false);
		
		LegoTag.setRequired("port", true);
		LegoTag.setRequired("loginTimeout", true);
		LegoTag.setRequired("responseTimeout", true);
	
		var comboVal = LegoTag.getCombValue("authModeSelect");
		if(comboVal === "0")
		{
			LegoTag.setDisabled("loginUser", true);
			LegoTag.setDisabled("loginPwd", true);
		}
		else if(comboVal === "1")
		{
			LegoTag.setDisabled("loginUser", false);
			LegoTag.setDisabled("loginPwd", false);
			LegoTag.setRequired("loginUser", true);
			LegoTag.setRequired("loginPwd", true);
			Ext.get("loginUser_label").setStyle("color","#464646");
			Ext.get("loginPwd_label").setStyle("color","#464646");
		}
		else
		{
			LegoTag.setDisabled("loginUser", true);
			LegoTag.setDisabled("loginPwd", false);
			LegoTag.setRequired("loginUser", false);
			LegoTag.setRequired("loginPwd", true);
			Ext.get("loginPwd_label").setStyle("color","#464646");
		}
		LegoTag.setDisabled("port", false);
		LegoTag.setDisabled("isEnable", false);
		var isEnableChild = Ext.get("isEnable").child(".x-item-disabled");
		if(isEnableChild)
		{
			isEnableChild.removeClass("x-item-disabled");
			isEnableChild.first().removeClass("x-item-disabled");
		}
		Ext.get("combTelnetType_label").setStyle("color","#464646");
		Ext.get("telnetTemplateComb_label").setStyle("color","#464646");
		Ext.get("loginTimeout_label").setStyle("color","#464646");
		Ext.get("responseTimeout_label").setStyle("color","#464646");
		Ext.get("authModeSelect_label").setStyle("color","#464646");
		Ext.get("port_label").setStyle("color","#464646");
		
		LegoTag.setDisabled("sloginTimeout", false);
		LegoTag.setDisabled("sresponseTimeout", false);
		LegoTag.setCombDisabled("sauthModeSelect", false);
		LegoTag.setDisabled("sport_label", false);
		LegoTag.setDisabled("sport", false);
		
		LegoTag.setRequired("sport", true);
		LegoTag.setRequired("sloginUser", true);
		LegoTag.setRequired("sloginPwd", true);
		LegoTag.setRequired("sloginTimeout", true);
		LegoTag.setRequired("sresponseTimeout", true);
		
		var comboVal = LegoTag.getCombValue("sauthModeSelect");
		if(comboVal === "0")
		{
			LegoTag.setDisabled("sloginUser", false);
			LegoTag.setDisabled("sloginPwd", false);
			LegoTag.setInputFileDisabled("privateKeyFile", true);
			LegoTag.setDisabled("privateKeyPwd", true);

			LegoTag.setRequired("sloginUser", true);
			LegoTag.setRequired("sloginPwd", true);
			LegoTag.setRequired("privateKeyFile", false);
			LegoTag.setRequired("privateKeyPwd", false);

			Ext.get("privateKeyFile_label").setStyle("color","gray");
			Ext.get("privateKeyPwd_label").setStyle("color","gray");

			Ext.get("sloginUser_label").setStyle("color","#464646");
			Ext.get("sloginPwd_label").setStyle("color","#464646");
		}
		else if(comboVal === "1")
		{
			LegoTag.setDisabled("sloginUser", false);
			LegoTag.setDisabled("sloginPwd", true);
			LegoTag.setInputFileDisabled("privateKeyFile", false);
			LegoTag.setDisabled("privateKeyPwd", false);
			
			LegoTag.setRequired("sloginPwd", false);
			if (userPrivateKey !== null && userPrivateKey !== "")
			{
				LegoTag.setRequired("privateKeyFile", false);
			}
			else
			{
				LegoTag.setRequired("privateKeyFile", true);
			}
			LegoTag.setRequired("privateKeyPwd", false);
			
			Ext.get("sloginUser_label").setStyle("color","#464646");
			Ext.get("sloginPwd_label").setStyle("color","gray");
			Ext.get("privateKeyFile_label").setStyle("color","#464646");
			Ext.get("privateKeyPwd_label").setStyle("color","#464646");
		}
		else
		{
			LegoTag.setDisabled("sloginUser", true);
			LegoTag.setDisabled("sloginPwd", false);
			LegoTag.setInputFileDisabled("privateKeyFile", false);
			Ext.get("sloginPwd_label").setStyle("color","#464646");


			Ext.get("privateKeyFile_label").setStyle("color","#464646");

		}
		
		LegoTag.setDisabled("sisEnable", false);
		var sisEnableChild = Ext.get("sisEnable").child(".x-item-disabled");
		if(sisEnableChild)
		{
			sisEnableChild.removeClass("x-item-disabled");
			sisEnableChild.first().removeClass("x-item-disabled");
		}
		Ext.get("scombTelnetType_label").setStyle("color","#464646");
		Ext.get("stelnetTemplateComb_label").setStyle("color","#464646");
		Ext.get("sloginTimeout_label").setStyle("color","#464646");
		Ext.get("sresponseTimeout_label").setStyle("color","#464646");
		Ext.get("sauthModeSelect_label").setStyle("color","#464646");
		Ext.get("sport_label").setStyle("color","#464646");
	}
	else
	{
		LegoTag.setCombDisabled("combTelnetType", true);
		LegoTag.setCombDisabled("telnetTemplateComb", true);
		LegoTag.setCombDisabled("combsTelnetType",true);
		LegoTag.setCombDisabled("stelnetTemplateComb",true);
		LegoTag.setDisabled("loginTimeout", true);
		LegoTag.setDisabled("responseTimeout", true);
		LegoTag.setCombDisabled("authModeSelect", true);
		LegoTag.setDisabled("loginUser", true);
		LegoTag.setDisabled("loginPwd", true);
		LegoTag.setDisabled("port", true);
		LegoTag.setDisabled("isEnable", true);
		LegoTag.setCombDisabled("privilegeLevel", true);
		LegoTag.setDisabled("privilegePwd", true);
		
		LegoTag.setRequired("port", false);
		LegoTag.setRequired("loginUser", false);
		LegoTag.setRequired("loginPwd", false);
		LegoTag.setRequired("loginTimeout", false);
		LegoTag.setRequired("responseTimeout", false);
		LegoTag.setRequired("privilegeLevel", false);
		LegoTag.setRequired("privilegePwd", false);
		
		
		Ext.get("combTelnetType_label").setStyle("color","gray");
		Ext.get("telnetTemplateComb_label").setStyle("color","gray");
		Ext.get("loginTimeout_label").setStyle("color","gray");
		Ext.get("responseTimeout_label").setStyle("color","gray");
		Ext.get("authModeSelect_label").setStyle("color","gray");
		Ext.get("loginUser_label").setStyle("color","gray");
		Ext.get("loginPwd_label").setStyle("color","gray");
		Ext.get("port_label").setStyle("color","gray");
		Ext.get("privilegeLevel_label").setStyle("color","gray");
		Ext.get("privilegePwd_label").setStyle("color","gray");
		
		LegoTag.setDisabled("sloginTimeout", true);
		LegoTag.setDisabled("sresponseTimeout", true);
		LegoTag.setCombDisabled("sauthModeSelect", true);
		
		LegoTag.setDisabled("sloginUser", true);
		LegoTag.setDisabled("sloginPwd", true);
		LegoTag.setInputFileDisabled("privateKeyFile", true);
		LegoTag.setDisabled("privateKeyPwd", true);
		LegoTag.setDisabled("sport", true);
		LegoTag.setDisabled("sisEnable", true);
		
		LegoTag.setRequired("sport", false);
		LegoTag.setRequired("sloginUser", false);
		LegoTag.setRequired("sloginPwd", false);
		LegoTag.setRequired("privateKeyFile", false);
		LegoTag.setRequired("sloginTimeout", false);
		LegoTag.setRequired("sresponseTimeout", false);
		LegoTag.setRequired("sprivilegeLevel", false);
		LegoTag.setRequired("sprivilegePwd", false);
		
		LegoTag.setCombDisabled("sprivilegeLevel", true);
		LegoTag.setDisabled("sprivilegePwd", true);
		Ext.get("scombTelnetType_label").setStyle("color","gray");
		Ext.get("stelnetTemplateComb_label").setStyle("color","gray");
		Ext.get("sloginTimeout_label").setStyle("color","gray");
		Ext.get("sresponseTimeout_label").setStyle("color","gray");
		Ext.get("sauthModeSelect_label").setStyle("color","gray");
		Ext.get("sloginUser_label").setStyle("color","gray");
		Ext.get("sloginPwd_label").setStyle("color","gray");
		Ext.get("sport_label").setStyle("color","gray");
		Ext.get("privateKeyFile_label").setStyle("color","gray");
		Ext.get("privateKeyPwd_label").setStyle("color","gray");
		Ext.get("sprivilegeLevel_label").setStyle("color","gray");
		Ext.get("sprivilegePwd_label").setStyle("color","gray");
	}
}

function onSelectCombTelnetType(type)
{
	userPrivateKey = "";
	var comboVal = type;
	if(comboVal === preComboDisplay)
	{
		if(comboVal === "Telnet")
		{
			document.getElementById("combTelnetType").focus();
		}
		else if(comboVal === "STELNET")
		{
			document.getElementById("combsTelnetType").focus();
		}
		return;
	}
	var stel = document.getElementById("sTelnet");
	var tel = document.getElementById("Telnet");
	var arr_v1 = [UNSYNC_WITH_TEL, "", ""];
	if(comboVal === "Telnet")
	{
		LegoTag.Msg.warning(arr_v1, function(btn)
		{
			if(btn == 'yes')
			{
				preComboTelVal=1;
				preComboDisplay="Telnet";
			 	stel.style.display="none";
			 	tel.style.display="";
			 	LegoTag.setCombValue("combTelnetType", 1, "Telnet");
			 	document.getElementById("combTelnetType").focus();
			}
			else
		    {
				preComboTelVal=2;
				preComboDisplay="STELNET";
			 	stel.style.display="";
			 	tel.style.display="none";
			 	LegoTag.setCombValue("combsTelnetType", 2, "STELNET");
			 	Ext.get("sprivilegeLevel_label").setStyle("color","gray");
			 	Ext.get("sprivilegePwd_label").setStyle("color","gray");
			 	document.getElementById("combsTelnetType").focus();
		    }
		});
	}
	else if(comboVal === "STELNET")
	{
		preComboTelVal=2;
		preComboDisplay="STELNET";
	 	stel.style.display="";
	 	tel.style.display="none";
	 	LegoTag.setCombValue("combsTelnetType", 2, "STELNET");
	 	Ext.get("sprivilegeLevel_label").setStyle("color","gray");
	 	Ext.get("sprivilegePwd_label").setStyle("color","gray");
	 	document.getElementById("combsTelnetType").focus();
	}
	else
	{
	 	return false;
	}
}
function selectSNMP(verStr)
{
	var comboVal = verStr;
	if(comboVal === preCombDisplay)
	{
		if(comboVal=="SNMPv1")
		{
			document.getElementById("cobSNMPVerv1").focus();
		}
		else if(comboVal=="SNMPv2c")
		{
			document.getElementById("cobSNMPVerv2").focus();
		}
		else if(comboVal=="SNMPv3")
		{
			document.getElementById("cobSNMPVerv3").focus();
		}
		return false;
	}
	
	var v2b = document.getElementById("snmpv2");
	var v3b = document.getElementById("snmpv3");
	var v1b = document.getElementById("snmpv1");
	
	var arr_v1 = [UNSYNC_WITH_V1, "", ""];
	var arr_v2 = [UNSYNC_WITH_V2, "", ""];
	if(comboVal=="SNMPv1")
	{	
		LegoTag.Msg.warning(arr_v1, function(btn)
		{
			if(btn == 'yes')
			{
				preComboVal=1;
				preCombDisplay = "SNMPv1"
			 	LegoTag.setCombValue("cobSNMPVerv1", 1, "SNMPv1");
			 	v1b.style.display="";
			 	v2b.style.display="none";
			 	v3b.style.display="none";
			 	document.getElementById("cobSNMPVerv1").focus();
			}
			else
			{
				if(preComboVal == 2)
				{
					preCombDisplay = "SNMPv2c"
					LegoTag.setCombValue("cobSNMPVerv2", 1, "SNMPv2");
				 	v1b.style.display="none";
					v2b.style.display="";
				 	v3b.style.display="none";
				 	document.getElementById("cobSNMPVerv2").focus();
				}
				else if(preComboVal == 3)
				{
					preCombDisplay = "SNMPv3"
					LegoTag.setCombValue("cobSNMPVerv3", 1, "SNMPv3");
				 	v1b.style.display="none";
					v2b.style.display="none";
				 	v3b.style.display="";
				 	document.getElementById("cobSNMPVerv3").focus();
				}
			}
		});
	}
	else if(comboVal=="SNMPv2c")
	{
		LegoTag.Msg.warning(arr_v2, function(btn)
		{
			if(btn == 'yes')
			{
				preComboVal=2;
				preCombDisplay = "SNMPv2c"
				LegoTag.setCombValue("cobSNMPVerv2", 2, "SNMPv2c");
				v2b.style.display="";
				v3b.style.display="none";
				v1b.style.display="none";
				document.getElementById("cobSNMPVerv2").focus();
			}
			else
			{
				if(preComboVal == 1)
				{
					preCombDisplay = "SNMPv1"
				 	LegoTag.setCombValue("cobSNMPVerv1", 1, "SNMPv1");
				 	v1b.style.display="";
				 	v2b.style.display="none";
				 	v3b.style.display="none";
				 	document.getElementById("cobSNMPVerv1").focus();
				}
				else if(preComboVal == 3)
				{
					preCombDisplay = "SNMPv3"
					LegoTag.setCombValue("cobSNMPVerv3", 1, "SNMPv3");
				 	v1b.style.display="none";
					v2b.style.display="none";
				 	v3b.style.display="";
				 	document.getElementById("cobSNMPVerv3").focus();
				}
			}
		});
	}
	else if(comboVal=="SNMPv3")
	{
		preComboVal=3;
		preCombDisplay = "SNMPv3"
		LegoTag.setCombValue("cobSNMPVerv3", 3, "SNMPv3");
		v2b.style.display="none";
		v1b.style.display="none";
		v3b.style.display="";
		document.getElementById("cobSNMPVerv3").focus();
	}
	else
	{
		return false;
	}
}
function checkIn() 
{
    var deviceType= LegoTag.getCombValue("deviceTypeCombobox");
    var v3authProtocol = LegoTag.getCombDisplay("v3authProtocol");
    var arr_hmacmd5 = [UNSYNC_WITH_HMACMD5, "", ""];
    var arr_empty = [UNSYNC_WITH_EMPTY, "", ""];
    
    if (deviceType == 6)
    {
    	if ("HMACMD5" == v3authProtocol)
    	{
    		LegoTag.Msg.warning(arr_hmacmd5, function(btn)
    		{
    			if(btn == 'yes')
    			{
    				Ext.get("v3authPwd_label").setStyle("color","#464646");
    	    		Ext.get("v3encryptProtocol_label").setStyle("color","#464646");
    	    		Ext.get("v3encryptPwd").setStyle("color","#464646");
    	    		LegoTag.setCombDisabled("v3encryptProtocol", false);
    	    		LegoTag.setDisabled("v3authPwd", false);
    	    		LegoTag.setRequired("v3authPwd", false);
    	    		if(LegoTag.getCombDisplay("v3encryptProtocol") == "")
    	    		{
    	    			Ext.get("v3encryptPwd_label").setStyle("color","gray");
    	    			LegoTag.setDisabled("v3encryptPwd", true);
    	    			LegoTag.setRequired("v3encryptPwd", false);
    	    		}
    	    		else
    	    		{
    	    			Ext.get("v3encryptPwd_label").setStyle("color","#464646");
    	    			LegoTag.setDisabled("v3encryptPwd", false);
    	    			LegoTag.setRequired("v3encryptPwd", false);
    	    		}
    			}
    			else
    			{
    				document.getElementById("v3authProtocol").value = "";
    				Ext.get("v3authPwd_label").setStyle("color","gray");
    	    		Ext.get("v3encryptProtocol_label").setStyle("color","gray");
    	    		Ext.get("v3encryptPwd_label").setStyle("color","gray");
    	    		Ext.get("v3encryptPwd").setStyle("color","gray");
    	    		LegoTag.setDisabled("v3encryptPwd", true);
    	    		LegoTag.setRequired("v3encryptPwd", false);
    	    		LegoTag.setCombDisabled("v3encryptProtocol", true);
    	    		LegoTag.setDisabled("v3authPwd", true);
    	    		LegoTag.setRequired("v3authPwd", false);
    			}
    		});
    	}
    	else if ("" == v3authProtocol)
    	{
    		LegoTag.Msg.warning(arr_empty, function(btn)
    		{
    			if(btn == 'yes')
    			{
    				Ext.get("v3authPwd_label").setStyle("color","gray");
    	    		Ext.get("v3encryptProtocol_label").setStyle("color","gray");
    	    		Ext.get("v3encryptPwd_label").setStyle("color","gray");
    	    		Ext.get("v3encryptPwd").setStyle("color","gray");
    	    		LegoTag.setDisabled("v3encryptPwd", true);
    	    		LegoTag.setRequired("v3encryptPwd", false);
    	    		LegoTag.setCombDisabled("v3encryptProtocol", true);
    	    		LegoTag.setDisabled("v3authPwd", true);
    	    		LegoTag.setRequired("v3authPwd", false);
    			}
    			else
				{
    				Ext.get("v3authPwd_label").setStyle("color","gray");
    	    		Ext.get("v3encryptProtocol_label").setStyle("color","gray");
    	    		Ext.get("v3encryptPwd_label").setStyle("color","gray");
    	    		Ext.get("v3encryptPwd").setStyle("color","gray");
    	    		LegoTag.setDisabled("v3encryptPwd", true);
    	    		LegoTag.setRequired("v3encryptPwd", false);
    	    		LegoTag.setCombDisabled("v3encryptProtocol", true);
    	    		LegoTag.setDisabled("v3authPwd", true);
    	    		LegoTag.setRequired("v3authPwd", false);
				}
    		});
    	}
    	else
    	{
    		Ext.get("v3authPwd_label").setStyle("color","#464646");
    		Ext.get("v3encryptProtocol_label").setStyle("color","#464646");
    		Ext.get("v3encryptPwd").setStyle("color","#464646");
    		LegoTag.setCombDisabled("v3encryptProtocol", false);
    		LegoTag.setDisabled("v3authPwd", false);
    		LegoTag.setRequired("v3authPwd", false);
    		if(LegoTag.getCombDisplay("v3encryptProtocol") == "")
    		{
    			Ext.get("v3encryptPwd_label").setStyle("color","gray");
    			LegoTag.setDisabled("v3encryptPwd", true);
    			LegoTag.setRequired("v3encryptPwd", false);
    		}
    		else
    		{
    			Ext.get("v3encryptPwd_label").setStyle("color","#464646");
    			LegoTag.setDisabled("v3encryptPwd", false);
    			LegoTag.setRequired("v3encryptPwd", false);
    		}
    	}	
    }
    else
    {
    	if ("HMACMD5" == v3authProtocol)
    	{
    		LegoTag.Msg.warning(arr_hmacmd5, function(btn)
    		{
    			if(btn == 'yes')
    			{
    				Ext.get("v3authPwd_label").setStyle("color","#464646");
    	    		Ext.get("v3encryptProtocol_label").setStyle("color","#464646");
    	    		Ext.get("v3encryptPwd").setStyle("color","#464646");
    	    		LegoTag.setCombDisabled("v3encryptProtocol", false);
    	    		LegoTag.setDisabled("v3authPwd", false);
    	    		LegoTag.setRequired("v3authPwd", true);
    	    		if(LegoTag.getCombDisplay("v3encryptProtocol") == "")
    	    		{
    	    			Ext.get("v3encryptPwd_label").setStyle("color","gray");
    	    			LegoTag.setDisabled("v3encryptPwd", true);
    	    			LegoTag.setRequired("v3encryptPwd", false);
    	    		}
    	    		else
    	    		{
    	    			Ext.get("v3encryptPwd_label").setStyle("color","#464646");
    	    			LegoTag.setDisabled("v3encryptPwd", false);
    	    			LegoTag.setRequired("v3encryptPwd", true);
    	    		}
    			}
    			else
				{
    				document.getElementById("v3authProtocol").value = "";
    				Ext.get("v3authPwd_label").setStyle("color","gray");
    	    		Ext.get("v3encryptProtocol_label").setStyle("color","gray");
    	    		Ext.get("v3encryptPwd_label").setStyle("color","gray");
    	    		Ext.get("v3encryptPwd").setStyle("color","gray");
    	    		LegoTag.setDisabled("v3encryptPwd", true);
    	    		LegoTag.setRequired("v3encryptPwd", false);
    	    		LegoTag.setCombDisabled("v3encryptProtocol", true);
    	    		LegoTag.setDisabled("v3authPwd", true);
    	    		LegoTag.setRequired("v3authPwd", false);
				}
    		});
    	}
    	else if ("" == v3authProtocol)
    	{
    		LegoTag.Msg.warning(arr_empty, function(btn)
    		{
    			if (btn == 'yes')
    			{
    				Ext.get("v3authPwd_label").setStyle("color","gray");
    	    		Ext.get("v3encryptProtocol_label").setStyle("color","gray");
    	    		Ext.get("v3encryptPwd_label").setStyle("color","gray");
    	    		Ext.get("v3encryptPwd").setStyle("color","gray");
    	    		LegoTag.setDisabled("v3encryptPwd", true);
    	    		LegoTag.setRequired("v3encryptPwd", false);
    	    		LegoTag.setCombDisabled("v3encryptProtocol", true);
    	    		LegoTag.setDisabled("v3authPwd", true);
    	    		LegoTag.setRequired("v3authPwd", false);
    			}
    			else
				{
    				Ext.get("v3authPwd_label").setStyle("color","gray");
    	    		Ext.get("v3encryptProtocol_label").setStyle("color","gray");
    	    		Ext.get("v3encryptPwd_label").setStyle("color","gray");
    	    		Ext.get("v3encryptPwd").setStyle("color","gray");
    	    		LegoTag.setDisabled("v3encryptPwd", true);
    	    		LegoTag.setRequired("v3encryptPwd", false);
    	    		LegoTag.setCombDisabled("v3encryptProtocol", true);
    	    		LegoTag.setDisabled("v3authPwd", true);
    	    		LegoTag.setRequired("v3authPwd", false);
				}
    		});
    	}
    	else
		{
    		Ext.get("v3authPwd_label").setStyle("color","#464646");
    		Ext.get("v3encryptProtocol_label").setStyle("color","#464646");
    		Ext.get("v3encryptPwd").setStyle("color","#464646");
    		LegoTag.setCombDisabled("v3encryptProtocol", false);
    		LegoTag.setDisabled("v3authPwd", false);
    		LegoTag.setRequired("v3authPwd", true);
    		if(LegoTag.getCombDisplay("v3encryptProtocol") == ""){
    			Ext.get("v3encryptPwd_label").setStyle("color","gray");
    			LegoTag.setDisabled("v3encryptPwd", true);
    			LegoTag.setRequired("v3encryptPwd", false);
    		}else{
    			Ext.get("v3encryptPwd_label").setStyle("color","#464646");
    			LegoTag.setDisabled("v3encryptPwd", false);
    			LegoTag.setRequired("v3encryptPwd", true);
    		}
		}
    }
}
function checkInput() 
{
    var deviceType= LegoTag.getCombValue("deviceTypeCombobox");
    var v3encryptProtocol = LegoTag.getCombDisplay("v3encryptProtocol");
    var arr_des = [UNSYNC_WITH_DES, "", ""];
    var arr_empty = [UNSYNC_WITH_EMPTY, "", ""];
    
    if (deviceType == 6)
    {
    	if("DES" == v3encryptProtocol)
    	{
    		LegoTag.Msg.warning(arr_des, function(btn)
    		{
    			if(btn == 'yes')
    			{
    				Ext.get("v3encryptPwd_label").setStyle("color","#464646");
    				LegoTag.setDisabled("v3encryptPwd", false);
    				LegoTag.setRequired("v3encryptPwd", false);
    			}
    			else
    			{
    				document.getElementById("v3encryptProtocol").value =  "";
    				Ext.get("v3encryptPwd_label").setStyle("color","gray");
    				LegoTag.setDisabled("v3encryptPwd", true);
    				LegoTag.setRequired("v3encryptPwd", false);
    			}
    		});
    	}
    	else if("" == v3encryptProtocol)
    	{
    		LegoTag.Msg.warning(arr_empty, function(btn)
    		{
    			if(btn == 'yes')
    			{
    				Ext.get("v3encryptPwd_label").setStyle("color","gray");
        			LegoTag.setDisabled("v3encryptPwd", true);
        			LegoTag.setRequired("v3encryptPwd", false);
    			}
    			else
    			{
    				Ext.get("v3encryptPwd_label").setStyle("color","gray");
        			LegoTag.setDisabled("v3encryptPwd", true);
        			LegoTag.setRequired("v3encryptPwd", false);
    			}
    		});
    	}
    	else 
    	{
			Ext.get("v3encryptPwd_label").setStyle("color","#464646");
			LegoTag.setDisabled("v3encryptPwd", false);
			LegoTag.setRequired("v3encryptPwd", false);
		}
    }
    else
    {
    	if("DES" == v3encryptProtocol)
    	{
    		LegoTag.Msg.warning(arr_des, function(btn)
    		{
    			if(btn == 'yes')
    			{
    				Ext.get("v3encryptPwd_label").setStyle("color","#464646");
    				LegoTag.setDisabled("v3encryptPwd", false);
    				LegoTag.setRequired("v3encryptPwd", true);
    			}
    			else
    			{
    				document.getElementById("v3encryptProtocol").value =  "";
    				Ext.get("v3encryptPwd_label").setStyle("color","gray");
    				LegoTag.setDisabled("v3encryptPwd", true);
    				LegoTag.setRequired("v3encryptPwd", false);
    			}
    		});
    	}
    	else if("" == v3encryptProtocol)
    	{
    		LegoTag.Msg.warning(arr_empty, function(btn)
    		{
    			if(btn == 'yes')
    			{
    				Ext.get("v3encryptPwd_label").setStyle("color","gray");
        			LegoTag.setDisabled("v3encryptPwd", true);
        			LegoTag.setRequired("v3encryptPwd", false);
    			}
    			else
				{
    				Ext.get("v3encryptPwd_label").setStyle("color","gray");
        			LegoTag.setDisabled("v3encryptPwd", true);
        			LegoTag.setRequired("v3encryptPwd", false);
				}
    		});
    	}
    	else 
    	{
			Ext.get("v3encryptPwd_label").setStyle("color","#464646");
			LegoTag.setDisabled("v3encryptPwd", false);
			LegoTag.setRequired("v3encryptPwd", true);
    	}
    }

}
function selecteAuthModel2() 
{
	var temp = LegoTag.getCombValue("authModeSelect");
	var authMode = document.getElementById("authMode");
	if (temp == "0") 
	{
		Ext.get("loginUser_label").setStyle("color","gray");
		Ext.get("loginPwd_label").setStyle("color","gray");
		LegoTag.setDisabled("loginUser", true);
		LegoTag.setRequired("loginUser", false);
		LegoTag.setDisabled("loginPwd", true);
		LegoTag.setRequired("loginPwd", false);
		authMode.value="0";
	}
	else if(temp=="1")
	{					
		Ext.get("loginPwd_label").setStyle("color","#464646");
		LegoTag.setDisabled("loginPwd", false);
		LegoTag.setRequired("loginPwd", true);
		Ext.get("loginUser_label").setStyle("color","#464646");
		LegoTag.setDisabled("loginUser", false);
		LegoTag.setRequired("loginUser", true);
		authMode.value="1";
	}
	else
	{
		Ext.get("loginPwd_label").setStyle("color","#464646");
		LegoTag.setDisabled("loginPwd", false);
		LegoTag.setRequired("loginPwd", true);
		Ext.get("loginUser_label").setStyle("color","gray");
		LegoTag.setDisabled("loginUser", true);
		LegoTag.setRequired("loginUser", false);
		authMode.value="2";				
	}
	document.getElementById("authModeSelect").focus();
}
function selecteAuthModel3() {
	var temp = LegoTag.getCombValue("sauthModeSelect");
	var authMode = document.getElementById("sauthMode");
	if (temp == "0") 
	{
		authMode.value = "0";
		
		LegoTag.setDisableds( [ "sloginUser", "sloginPwd" ], false);
		LegoTag.setDisableds( [ "privateKeyPwd" ], true);
		LegoTag.setInputFileDisabled("privateKeyFile", true);
		
		LegoTag.setRequired("sloginUser", true);
		LegoTag.setRequired("sloginPwd", true);
		LegoTag.setRequired("privateKeyFile", false);
		LegoTag.setRequired("privateKeyPwd", false);
		
		Ext.get("sloginUser_label").setStyle("color","#464646");
		Ext.get("sloginPwd_label").setStyle("color","#464646");
		Ext.get("privateKeyFile_label").setStyle("color","gray");
		Ext.get("privateKeyPwd_label").setStyle("color","gray");
	}
	if (temp == "1") 
	{
		authMode.value = "1";
		
		LegoTag.setDisableds( [ "sloginUser", "privateKeyPwd" ], false);
		LegoTag.setInputFileDisabled("privateKeyFile", false);
		LegoTag.setDisableds( [ "sloginPwd" ], true);
		
		LegoTag.setRequired("sloginUser", true);
		LegoTag.setRequired("sloginPwd", false);
		if (userPrivateKey !== null && userPrivateKey !== "")
		{
			LegoTag.setRequired("privateKeyFile", false);
		}
		else
		{
			LegoTag.setRequired("privateKeyFile", true);
		}
		LegoTag.setRequired("privateKeyPwd", false);
		
		Ext.get("sloginUser_label").setStyle("color","#464646");
		Ext.get("sloginPwd_label").setStyle("color","gray");
		Ext.get("privateKeyFile_label").setStyle("color","#464646");
		Ext.get("privateKeyPwd_label").setStyle("color","#464646");
		
	}
	if (temp == "2") {
	
		authMode.value = "2";
		Ext.get("privateKeyFile_label").setStyle("color","#464646");
		LegoTag.setDisabled("sloginUser", true);
		LegoTag.setDisabled("sloginPwd", false);
		LegoTag.setRequired("sloginUser", false);
		LegoTag.setRequired("sloginPwd", true);
		Ext.get("sloginPwd_label").setStyle("color","#464646");
		Ext.get("sloginUser_label").setStyle("color","gray");
		
		
	}
	document.getElementById("sauthModeSelect").focus();
}

function selectLevel()
{
	if(document.getElementById("Telnet").style.display == "")
	{
		document.getElementById("privilegeLevel").focus();
	}
	else if(document.getElementById("sTelnet").style.display == "")
	{
		document.getElementById("sprivilegeLevel").focus();
	}
}

function refreshTelnetDetail( telnetTemplate )
{
	var prototolType =  telnetTemplate[0].prototolType;
	var authMode = telnetTemplate[0].authMode;   
	userPrivateKey = "";
   if( 0 == prototolType ) 
   {
		if( 0 == authMode )
		{
		    LegoTag.setCombValue("authModeSelect",authMode,AUTH_NO);
		}
		if( 1 == authMode )
		{
		    LegoTag.setCombValue("authModeSelect",authMode,AUTH_USER);
		}                                                                          
		if( 2 == authMode )
		{
		    LegoTag.setCombValue("authModeSelect",authMode,AUTH_PWD);
		}
	   	document.getElementById("loginTimeout").value = telnetTemplate[0].loginTimeout;
		document.getElementById("responseTimeout").value = telnetTemplate[0].responseTimeout;
   		document.getElementById("loginUser").value = telnetTemplate[0].loginUser;
   		document.getElementById("loginPwd").value = telnetTemplate[0].loginPwd;
   		document.getElementById("port").value = telnetTemplate[0].port;
   		LegoTag.setCheck("isEnable",telnetTemplate[0].enable);
   		if( true == telnetTemplate[0].enable )
   		{
			document.getElementById("privilegeLevel").value = telnetTemplate[0].privilegeLevel;
			document.getElementById("privilegePwd").value = telnetTemplate[0].privilegePwd;
   		}
	   else
	   {
	   	  document.getElementById("privilegeLevel").value = "";
	      document.getElementById("privilegePwd").value = "";
	   }
	   selecteAuthModel2();
   }
   if( 1 == prototolType )
   {
        if( 0 == authMode )
	    {
	       LegoTag.setCombValue("sauthModeSelect",authMode,AUTH_PWD);
	    }
	    if( 1 == authMode )
	    {
	       LegoTag.setCombValue("sauthModeSelect",authMode,SAUTH_RSA);
	    }
	    if( 2 == authMode )
	    {
	       LegoTag.setCombValue("sauthModeSelect",authMode,SAUTH_RSAPWD);
	    }
	   document.getElementById("sloginTimeout").value = telnetTemplate[0].loginTimeout;
	   document.getElementById("sresponseTimeout").value = telnetTemplate[0].responseTimeout;
	   
	   document.getElementById("sloginUser").value = telnetTemplate[0].loginUser;
	   document.getElementById("sloginPwd").value = telnetTemplate[0].loginPwd;
	   document.getElementById("sport").value = telnetTemplate[0].port;
	   LegoTag.setCheck("sisEnable",telnetTemplate[0].enable);
	   if( true == telnetTemplate[0].enable )
	   {
	   	  document.getElementById("sprivilegeLevel").value = telnetTemplate[0].privilegeLevel;
	      document.getElementById("sprivilegePwd").value = telnetTemplate[0].privilegePwd;
	   }
	   else
	   {
	   	  document.getElementById("sprivilegeLevel").value = "";
	      document.getElementById("sprivilegePwd").value = "";
	   }
	   document.getElementById("privateKeyPwd").value = telnetTemplate[0].privateKeyPwd;
	   userPrivateKey = telnetTemplate[0].userPrivateKey.replace(/<wooham><wooham>/gi, "\n");
	   userPrivateKey = userPrivateKey.replace(/<wooham>/gi, "\n");
	   document.getElementById("userPrivateKey").value = userPrivateKey;
	   selecteAuthModel3();
   }
}			
function getTelnetDetail()
{
	var templateId = "";
	if(preComboDisplay === "Telnet")
	{
	   templateId = LegoTag.getCombValue("telnetTemplateComb");
	}
	else
	{
		templateId = LegoTag.getCombValue("stelnetTemplateComb");
	}
   
   if( -1 == templateId)
   {
   	  return ;
   }
   var url = WEB_ROOT_ABS_PATH + packname + 'getTelnetTemplateDetail.do';
            LegoTag.Ajax.request({
		url : url,
		method : 'post',
		params : {
			templateId : templateId							
		},
		success : function(response, options) {
		    var info = response.responseText;
		    var telnetTemplate ;
		    try{
		    	info = info.replace(/[\r\n]/gi, '<wooham>');
		        telnetTemplate = Ext.util.JSON.decode(info);
            }
            catch(e)
            {
               alert(e);
            }
            refreshTelnetDetail(telnetTemplate);
            
            if(preComboDisplay === "Telnet")
			{
			   document.getElementById("telnetTemplateComb").focus();
			}
			else
			{
				document.getElementById("stelnetTemplateComb").focus();
			}
		}
	});
}
function compareIp(aclbegin,aclend)
{
	var beginArr = aclbegin.split(".");
	var endArr = aclend.split(".");
	var ibegin =0 ;
	var iend=0;
	if(parseInt(endArr[0])>parseInt(beginArr[0]))
	{
		return false;
	}
	if(parseInt(endArr[0])<parseInt(beginArr[0]))
	{
		return true;
	}		
	if(parseInt(endArr[1])>parseInt(beginArr[1]))
	{
		return false;
	}
	if(parseInt(endArr[1])<parseInt(beginArr[1]))
	{
		return true;
	}		
	if(parseInt(endArr[2])>parseInt(beginArr[2]))
	{
		return false;
	}	
	if(parseInt(endArr[2])<parseInt(beginArr[2]))
	{
		return true;
	}		
	if(parseInt(endArr[3])>parseInt(beginArr[3]))
	{
		return false;
	}	
	if(parseInt(endArr[3])<parseInt(beginArr[3]))
	{
		return true;
	}		
	return true;
}
function isInRange(ipbegin,ipend)
{
	var crang = 10;
	var beginArr = ipbegin.split(".");
	var endArr = ipend.split(".");
	if(parseInt(endArr[0])>parseInt(beginArr[0]))
	{
		return true;
	}	
	if(parseInt(endArr[1])>parseInt(beginArr[1]))
	{
		return true;
	}
	if((parseInt(endArr[2])-parseInt(beginArr[2]))==crang && (parseInt(endArr[3])>=parseInt(beginArr[3])))
	{
		return true;
	}
	if((parseInt(endArr[2])-parseInt(beginArr[2]))>crang)
	{
		return true;
	}
	return false;
}
function deleteIP(ipbegin,ipend)
{
	var arr = [MSG_INFO_DELIP, "", ""];
	LegoTag.Msg.warning(arr, function(btn)
	{
		if(btn == 'yes')
		{
			var recordAll = LegoTag.getGridAllData("r1");
			
			for (var j =0,len=recordAll.length;j<len;j++)
			{
				if((ipbegin == recordAll[j].sStartIp) && (ipend == recordAll[j].sEndIp))
				{
					LegoTag.delGridItemForIndex("r1",j)
					break;
				}
			}
		}
	});
}
function setSnmpDisable(version)
{
	if(version == 1)
	{
		setDisableState("v3",false);
		setDisableState("v2",false);
	}
	else if(version == 2)
	{
		setDisableState("v3",false);
		setDisableState("v1",false);
	}
	else if(version == 3)
	{
		setDisableState("v1",false);
		setDisableState("v2",false);
	}
}
function setTelDisable(version)
{
	if(version == "STELNET")
	{
		setDisableState("Telnet",false);
	}
	else if(version == "Telnet")
	{
		setDisableState("sTelnet",false);
	}
	else
	{
		setDisableState("Telnet",false);
		setDisableState("sTelnet",false);
	}
}
function setDisableState(type,state)
{
 	var elements = Ext.query("*[id^="+type+"]");
	for(var i=0; i<elements.length ; i++) {
		try
		{
			Ext.get(elements[i]).setDisabled(state);
		}
		catch (ex){}
	}
}

function saveDdosDevice(deviceId, flag)
{
	var addUrl = WEB_ROOT_ABS_PATH + "/VSM-SecNE-UI/saveDdosDevice.do";
	var form = document.getElementById("ddosDeviceForm");
	
	LegoTag.Msg.wait();
    LegoTag.Ajax.request(
    {
        timeout:600000,
        url:addUrl, 
        form:form,
        params:{
            "xxx" : 1
        }, 
        success:function (action) 
        {
            LegoTag.Msg.hide();
            if (action.responseText == "success") 
            {
            	LegoTag.Msg.succeed("保存成功",function(){
                    LegoTag.getSelfWindow().close();
                });
            }
        } 
    });
}