
function addDnsStatisticItem(rows)
{
	LegoTag.delAllGridItem('dnsStatisticItemGrid');
	for(var i = 0 ;i<rows.length;i++)
	{
		LegoTag.addGridItem('dnsStatisticItemGrid',rows[i]);
		
	}
	
}

function htmlEncode(text)
{
    if (text != "")
    {

        text = text.replace(/&/g, "&amp;");
        text = text.replace(/</g, "&lt;");
        text = text.replace(/>/g, "&gt;");
        text = text.replace(/\"/g, "&quot;");
        text = text.replace(/\'/g, "&#39;");
    }
    return text;
}

function addDnsRow(Grid){
	var GridList = LegoTag.getGridAllData(Grid);
	var INFO = MESSAGE_INFO;
	
    if (Grid=="dnsDomainDefendGrid"){
        var domain = document.getElementById("dnsDomain").value;
        var alertRate= document.getElementById("dnsDomainLimit").value;
		var msg = addDnsRowParams.dnsDomain+' '+addDnsRowParams.dnsDomainLimit+' '+addDnsRowParams.notnull;	
				
       if ((domain=="")||(alertRate=="")){
        	LegoTag.Msg.alert(MESSAGE_INFO,msg);
        	return;
        }
        
        var dnsDomainPanel = document.getElementById("dnsDomainPanel");
			var validInfo = LegoTag.validFormResult(dnsDomainPanel, true, true, INFO);
			if (validInfo) {
			    return;
			}
        var dnsDomainDefendCount = 0;
		var dnsDomainDefendGrid = LegoTag.getGridAllData("dnsDomainDefendGrid");
		for (var i = 0; dnsDomainDefendGrid[i]; i++) {
			dnsDomainDefendCount = dnsDomainDefendCount+1;
		}
		if(dnsDomainDefendCount > 3)
		{
			LegoTag.Msg.alert(INFO, addDnsRowParams.dnsDomainCountWrong);
			return;
		}
        
        var msg = addDnsRowParams.dnsDomain+"："+domain+addDnsRowParams.valueisalready;
		for (i=0;i<GridList.length;i++)
		{
			if (domain == GridList[i].domain )
			{
				LegoTag.Msg.alert(MESSAGE_INFO,msg);
				return;
			}
		}
		domain = htmlEncode(domain);
		alertRate = htmlEncode(alertRate);
		var operator="";
		var picUrl = addDnsRowParams.picUrl;
		var Delete = addDnsRowParams.Delete;
		var deleteUrl="<a href='javascript:delSelDnsDomainItem(" +"\""+ domain+ "\"" + "," + "\"" +alertRate+ "\"" + ")'>"+"<img	src= "+picUrl+" title="+Delete+ "> </a>";
		
		var rows=[{
			name:"id",
			hidden:true
		},{
			name:"domain",
			value:domain,
			body:"<div>"+domain+"</div>"
		},{
			name:"alertRate",
			value:alertRate,
			body:"<div>"+alertRate+"</div>"
		},{
			value:operator,
			body: deleteUrl
		}];
		 if (GridList.length>=10){
        	LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.numberOutOfRange);
        	return;
        }
        
		LegoTag.addGridItem(Grid,rows);	
		
		document.getElementById("dnsDomain").value = "";
		document.getElementById("dnsDomainLimit").value = "";
		
			
	}else if (Grid=="dnsDomainCacheGrid"){ 
       var domain = document.getElementById("dnsCacheDomain").value;
       var ipAddress= LegoTag.getIpValue("dnsCacheIPAddress");
       var dnsCacheTtl = document.getElementById("dnsCacheTtl").value;
       
       var err = LegoTag.validFormResult("dnsCacheDomainIp",true,true);
	   if (err!=null){
	   	    return;
	   } 
        if (GridList.length>9){
        	LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.cachenumberOutOfRange);
        	return;
        }
        
        var dnsDomainCacheTable = document.getElementById("dnsDomainCacheTable");
			var validInfo = LegoTag.validFormResult(dnsDomainCacheTable, true, true, INFO);
			if (validInfo) {
			    return;
			}

       if (domain=="")
       {
        	LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.dnsDomain+addDnsRowParams.notnull);
        	return;
       }
       var domainObj = document.getElementById("dnsCacheDomain");
       var domainValidRes = LegoTag.getValidResult(domainObj);
       if (domainValidRes)
	   {
    	   LegoTag.Msg.alert(MESSAGE_INFO,DOMAIN_INVALID);
    	   return;
	   }
       if(ipAddress=="")
       {
        	LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.ipAddress+addDnsRowParams.notnull);
        	return;
       }
       var ipObj = document.getElementById("dnsCacheIPAddress");
       var ipValidRes = LegoTag.getValidResult(ipObj);
       if (ipValidRes)
	   {
    	   LegoTag.Msg.alert(MESSAGE_INFO,IP_INVALID);
    	   return;
	   }
       if(dnsCacheTtl=="")
       {
    	   LegoTag.Msg.alert(MESSAGE_INFO,"TTL"+addDnsRowParams.notnull);
    	   return;
       }
       var ttlObj = document.getElementById("dnsCacheTtl");
       var ttlValidRes = LegoTag.getValidResult(ttlObj);
       if (ttlValidRes)
	   {
    	   LegoTag.Msg.alert(MESSAGE_INFO,TTL_INVALID);
    	   return;
	   }
       
		for (i=0;i<GridList.length;i++){
			if (domain.toLowerCase()==GridList[i].domain.toLowerCase()){
				LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.dnsDomain+"："+"<br>"+GridList[i].domain+"<br>"+addDnsRowParams.alreadyhas);
				return;
			}
		}
		domain = htmlEncode(domain);
		ipAddress = htmlEncode(ipAddress);
		dnsCacheTtl = htmlEncode(dnsCacheTtl);
		var operator="";
		var picUrl = addDnsRowParams.picUrl;
		var Delete = addDnsRowParams.Delete;
		var deleteUrl="<a href='javascript:delSelDnsCacheItem(" +"\""+ domain+ "\"" + "," + "\"" +ipAddress+ "\"" + ")'>"+"<img	src= "+picUrl+ " title="+Delete+ "> </a>";
		
		
		var rows=[{
			name:"id",
			hidden:true
		},{
			name:"domain",
			value:domain,
			title:domain,
			body:"<div>"+domain+"</div>"
		},{
			name:"ipAddress",
			value:ipAddress,
			body:"<div>"+ipAddress+"</div>"
		},{
			name:"dnsCacheTtl",
			value:dnsCacheTtl,
			body:"<div>"+dnsCacheTtl+"</div>"
		},{
			value:operator,
			body: deleteUrl
		}];
			
		LegoTag.addGridItem(Grid,rows);
		document.getElementById("dnsCacheDomain").value = "";
		document.getElementById("dnsCacheTtl").value = "86400";
		LegoTag.setIpValue("dnsCacheIPAddress","");
		
	}
}

function getdnsDomainCacheArray(){
	var record = LegoTag.getGridAllData("dnsDomainCacheGrid");
	var result=new Array(record.length);
	if (record<1){
		return null;
	}
	for (var i=0;i<record.length;i++){
		result[i]=record[i].domain+";"+record[i].ipAddress+";"+record[i].dnsCacheTtl;
	}
	return result;
}

function dnsBlockPanel_onclick(){
	var dnsDefend = "dnsDefendEnable";
	var dnsLimit = "limitEnable";
	
	var checked = LegoTag.getChecked('dnsCutEnable');
	
	if (checked){
		LegoTag.setCheck(dnsDefend,false);
		LegoTag.setCheck(dnsLimit,false);
		LegoTag.setCheck("zoneTemplateForm.dnsDefendPolicyForm.limitEnable",false);
		LegoTag.setCheck("dnsTopnStatisticCheckId",false);
		LegoTag.setCheck("dnsStatisticCheckId",false);
		dnsRecoveryPanel_onclick();
		dnsLimitPanel_onclick();
		topnStatisticDoman_onclick();
		dnsStatisticEnable_onclick();
	}
}



function checkDns() {
	var dnsGroup = ['dnsLowerLimit', 'dnsLowerLimitRange','dnsUpperLimit','dnsRange','dnsUpperLimitRange'];
	var checked = LegoTag.getChecked("dnsEnable");
    if(checked)
    { 
       LegoTag.setDisableds(dnsGroup, false);
       LegoTag.setCheck('dnsEnable', true); 
    }
    else
    {
       LegoTag.setDisableds(dnsGroup, true);
    }
}

function checkDns2()
{
	var dnsGroup = ['dnsLowerLimit2','dnsLowerLimitRange2','dnsUpperLimit2','dnsRange2','dnsUpperLimitRange2'];
    var checked = LegoTag.getChecked("dnsEnable2");
    if(checked)
    {
       LegoTag.setDisableds(dnsGroup, false);
       LegoTag.setCheck('dnsEnable2', true); 
    }
    else
    {
       LegoTag.setDisableds(dnsGroup, true);
    }

}

function dnsRecoveryPanel_onclick()
{
	var dnsDefend="dnsDefendEnable";
	var dnsBlock="dnsCutEnable";
	if (!LegoTag.getChecked(dnsDefend))
	{
		document.getElementById("dnsDefencePanel").style.display="none";
		LegoTag.setCheck('dnsCacheServerEnable',false);
		LegoTag.setCheck('dnsAuthServerEnable',false);
		LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.replyFloodEnable',false);
		LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.noSuchNameCheckEnable',false);
		LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.formatCheckEnable',false);
		LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.cachePoisoningEnable',false);
		LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.appointSourceIpRequestMessageEnable',false);
		LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.appointSourceIpResponseMessageEnable',false);
		LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.dnsDomainCacheEnable',false);
		LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.dnsRequestMessageLenLimitEnable',false);
		LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.requestTtlCheckEnable',false);
		LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.dnsReponseMessageLenLimitEnable',false);
		LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.replyTtlCheckEnable',false);
	}
	else
	{
		LegoTag.setCheck('dnsCutEnable',false);
		document.getElementById("dnsDefencePanel").style.display="block";
		LegoTag.setCheck(dnsBlock,!LegoTag.getChecked(dnsDefend));
	}
	turnonDnsCacheServerEnable();
	turnonDnsAuthServerEnable();
	replyFloodEnable_onclick(false);
	dnsCheckEnable_onclick();
	noSuchNameCheckEnable_onclick();
	dnsFormatClick();
	appointSourceIpRequestMessagePanel_onclick();
	appointSourceIpResponseMessagePanel_onclick();
	dnsDomainCachePanel_onclick();
	dnsRequestMessageLenLimitEnableOnclick();
	requestMessageTTLPanel_onclick();
	dnsReponseMessageLenLimitEnableOnclick();
	replyMessageTTLPanel_onclick();
}

function dnsDomainCachePanel_onclick(){
	if (!LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.dnsDomainCacheEnable")){
		document.getElementById("dnsDomainCachePanel").style.display="none";
		LegoTag.setDisabled("dnsDomainCachePanel",true);
	}else{
		document.getElementById("dnsDomainCachePanel").style.display="block";
		LegoTag.setDisabled("dnsDomainCachePanel",false);
	}
}


function dnsLimitPanel_onclick(){
	var dnsLimit ="limitEnable";
	var dnsBlock="dnsCutEnable";
	if(!LegoTag.getChecked(dnsLimit)){
	    document.getElementById("dnsLimitPanel").style.display="none";
	    LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.srcipReqLimitEnable',false);
		LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.srcipRespLimitEnable',false);
	}else{
	    LegoTag.setCheck('dnsCutEnable',false);
		document.getElementById("dnsLimitPanel").style.display="block";
		LegoTag.setCheck(dnsBlock,!LegoTag.getChecked(dnsLimit));
	}
	srcipReqLimitEnableOnclick();
	srcipRespLimitEnableOnclick();
}


function dnsStatisticEnable_onclick(){
	if (!LegoTag.getChecked("dnsStatisticCheckId")){
		document.getElementById("dnsStatisticItemPanel").style.display="none";
	}else{
		LegoTag.setCheck('dnsCutEnable',false);
		document.getElementById("dnsStatisticItemPanel").style.display="block";
	}
}

function topnStatisticDoman_onclick(){
		
	if (!LegoTag.getChecked("dnsTopnStatisticCheckId")){
		LegoTag.setCheck("zoneTemplateForm.dnsDefendPolicyForm.topnStatisticDomanEnable",false);
		LegoTag.setCheck("zoneTemplateForm.dnsDefendPolicyForm.topnStatisticSourceIpEnable",false);
		
		document.getElementById("dnsTopnStatisticDomanPanel").style.display="none";
	}else{
		LegoTag.setCheck('dnsCutEnable',false);
		document.getElementById("dnsTopnStatisticDomanPanel").style.display="block";
	}
	LegoTag.setDisabled("zoneTemplateForm.dnsDefendPolicyForm.topnStatisticDomanEnable",!LegoTag.getChecked("dnsTopnStatisticCheckId"));
	LegoTag.setDisabled("zoneTemplateForm.dnsDefendPolicyForm.topnStatisticSourceIpEnable",!LegoTag.getChecked("dnsTopnStatisticCheckId"));
		
	topnStatisticDomanEnable_onclick();
	topnStatisticSourceIpEnable_onclick();
}

function topnStatisticDomanEnable_onclick(){
	if (!LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.topnStatisticDomanEnable")){
		LegoTag.setCheck("zoneTemplateForm.dnsDefendPolicyForm.topnCacheEnable",false);
		LegoTag.setDisableds(['zoneTemplateForm.dnsDefendPolicyForm.topnCacheEnable','learnNumberUnit'],true);
	}else{
		LegoTag.setDisableds(['zoneTemplateForm.dnsDefendPolicyForm.topnCacheEnable','learnNumberUnit'],false);
	}
	
	var DomanCheck = LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.topnStatisticDomanEnable");
	var SourceIpCheck = LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.topnStatisticSourceIpEnable");
	LegoTag.setDisableds(addDnsRowParams.sampleRate,!(DomanCheck || SourceIpCheck));
	topnCach_onclick();
}

function topnStatisticSourceIpEnable_onclick(){
	var DomanCheck = LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.topnStatisticDomanEnable");
	var SourceIpCheck = LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.topnStatisticSourceIpEnable");
	LegoTag.setDisableds(addDnsRowParams.sampleRate,!(DomanCheck || SourceIpCheck));
	topnCach_onclick();
}

function topnCach_onclick()
{
	
	LegoTag.setDisableds(['zoneTemplateForm.dnsDefendPolicyForm.learnNumber'
				,'learnNumberParaRange'],!LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.topnCacheEnable'));
}


function getdnsStatisticArray(){
	var record = LegoTag.getGridAllData("dnsStatisticItemGrid");
	var result=new Array(record.length);
	if (record.length<1){
		return null;
	}
	for (var i=0;i<record.length;i++){
		result[i]=record[i].stasticTypeCode+":"+record[i].dnsItemName;
	}
	return result;
}
function browseDnsStatisticItem()
{
	var record = LegoTag.getGridAllData("dnsStatisticItemGrid");
	var result=new Array(record.length);
	for (var i=0;i<record.length;i++){
		result[i]=record[i].stasticTypeCode;
	}
	var EDIT_POLICY_TITLE =browseDnsStatisticItemParams.editpanelname;
	var actionPath = browseDnsStatisticItemParams.actionPath;
	LegoTag.frameWindow(actionPath+'?selectDnsStatesticItem='+result,"browseDnsStatisticWindow", 'title='+EDIT_POLICY_TITLE+',height=400,width=800', false);
}				
function setDnsComponentStatus(Components,status){
	for (var i=0;i<Components.length;i++){
		LegoTag.setDisabled(Components[i],status);
	}

}

 function appointSourceIpResponseMessagePanel_onclick()
 {
    var dnsDomainPanel="strAppointSourceIpResponseMessagePanel";
    
    if (!LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.appointSourceIpResponseMessageEnable")){
		document.getElementById("strAppointSourceIpResponseMessagePanel").style.display="none";
		LegoTag.setDisabled("strAppointSourceIpResponseMessagePanel",true);
	}else{
		document.getElementById("strAppointSourceIpResponseMessagePanel").style.display="block";
		LegoTag.setDisabled("strAppointSourceIpResponseMessagePanel",false);
	}
 }
 
 function appointSourceIpRequestMessagePanel_onclick()
 {
 	var dnsDomainPanel="appointSourceIpRequestMessagePanel";
    
    if (!LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.appointSourceIpRequestMessageEnable")){
		document.getElementById("appointSourceIpRequestMessagePanel").style.display="none";
		LegoTag.setDisabled("appointSourceIpRequestMessagePanel",true);
	}else{
		document.getElementById("appointSourceIpRequestMessagePanel").style.display="block";
		LegoTag.setDisabled("appointSourceIpRequestMessagePanel",false);
	}
 }

function dnsRequestStaticFingerMarkFilterPanel_onclick()
{
    var dnsDomainPanel="dnsRequestStaticFingerMarkFilterPanel";
    
    if (!LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.dnsRequestStaticFingerMarkFilterEnable")){
		document.getElementById("dnsRequestStaticFingerMarkFilterPanel").style.display="none";
		LegoTag.setDisabled("dnsRequestStaticFingerMarkFilterPanel",true);
	}else{
		document.getElementById("dnsRequestStaticFingerMarkFilterPanel").style.display="block";
		LegoTag.setDisabled("dnsRequestStaticFingerMarkFilterPanel",false);
	}
}

function dnsResponseStaticFingerMarkFilterPanel_onclick()
{
	var dnsDomainPanel="dnsResponseStaticFingerMarkFilterPanel";
    
    if (!LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.dnsResponseStaticFingerMarkFilterEnable")){
		document.getElementById("dnsResponseStaticFingerMarkFilterPanel").style.display="none";
		LegoTag.setDisabled("dnsResponseStaticFingerMarkFilterPanel",true);
	}else{
		document.getElementById("dnsResponseStaticFingerMarkFilterPanel").style.display="block";
		LegoTag.setDisabled("dnsResponseStaticFingerMarkFilterPanel",false);
	}
}

function supportPartResponseDomainPanel_onclick()
{
    var dnsDomainPanel="supportPartResponseDomainPanel";
    
    if (!LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.supportPartResponseDomainEnable")){
		document.getElementById("supportPartResponseDomainPanel").style.display="none";
		LegoTag.setDisabled("supportPartResponseDomainPanel",true);
	}else{
		document.getElementById("supportPartResponseDomainPanel").style.display="block";
		LegoTag.setDisabled("supportPartResponseDomainPanel",false);
	}
}

function supportPartRequestDomainPanel_onclick()
{
    var dnsDomainPanel="supportPartRequestDomainPanel";
    
    if (!LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.supportPartRequestDomainEnable")){
		document.getElementById("supportPartRequestDomainPanel").style.display="none";
		LegoTag.setDisabled("supportPartRequestDomainPanel",true);
	}else{
		document.getElementById("supportPartRequestDomainPanel").style.display="block";
		LegoTag.setDisabled("supportPartRequestDomainPanel",false);
	}
}

function realSourceIpResponseMessagePanel_onclick()
{
	var dnsDomainPanel="realSourceIpResponseMessagePanel";
    
    if (!LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.realSourceIpResponseMessageEnable")){
		document.getElementById("realSourceIpResponseMessagePanel").style.display="none";
		LegoTag.setDisabled("realSourceIpResponseMessagePanel",true);
	}else{
		document.getElementById("realSourceIpResponseMessagePanel").style.display="block";
		LegoTag.setDisabled("realSourceIpResponseMessagePanel",false);
	}
}

function realSourceIpRequestMessagePanel_onclick()
{
    var dnsDomainPanel="realSourceIpRequestMessagePanel";
    
    if (!LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.realSourceIpRequestMessageEnable")){
		document.getElementById("realSourceIpRequestMessagePanel").style.display="none";
		LegoTag.setDisabled("realSourceIpRequestMessagePanel",true);
	}else{
		document.getElementById("realSourceIpRequestMessagePanel").style.display="block";
		LegoTag.setDisabled("realSourceIpRequestMessagePanel",false);
	}
}


function addAppintDnsRow(Grid)
{   
	var GridList = LegoTag.getGridAllData(Grid);
	if( Grid=="dnsAppointSourceIpResponseMessageGrid" )
	{
	  	var ipObj = document.getElementById("dnsAppointSourceIpResponseMessage");
		var ipObjValue = ipObj.value;
		if (ipObjValue == "")
		{
			LegoTag.Msg.alert(MESSAGE_INFO, IP_NOT_NULL_RESPONSE);
			return;
		}
		
		var ipValidResult = LegoTag.getValidResult(ipObj);
		if (ipValidResult)
		{
		    LegoTag.Msg.alert(MESSAGE_INFO, ipValidResult);
		    return;
		}
		
		var rateObj = document.getElementById("dnsAppointSourceIpResponseMessageLimit");
		var rateObjValue = rateObj.value;
		if (rateObjValue == "")
		{
			LegoTag.Msg.alert(MESSAGE_INFO, RATE_NOT_NULL_RESPONSE);			
			return;
		}
		var rateValidResult = LegoTag.getValidResult(rateObj);
		if (rateValidResult)
		{
			LegoTag.Msg.alert(MESSAGE_INFO, rateValidResult);
			return;
		}
	  
        var sourceIp =	LegoTag.getIpValue("dnsAppointSourceIpResponseMessage")	;
        var alertRate= document.getElementById("dnsAppointSourceIpResponseMessageLimit").value;
        var srcipRespNum= document.getElementById("srcipRespNum").value;
        
        msg = addAppintDnsRowParams.sourceIp+"：" +"<br>" +sourceIp +"<br>" +addAppintDnsRowParams.valueisalready;
	    for (i=0;i<GridList.length;i++)
	    {
			if ( sourceIp==GridList[i].sourceIp ){
				LegoTag.Msg.alert(MESSAGE_INFO,msg);
				return;
			}
		}
		
		var dnsPanel = document.getElementById("strAppointSourceIpResponseMessagePanel");
		var validInfo = LegoTag.validFormResult(dnsPanel, true, true, addAppintDnsRowParams.info);
		if (validInfo) {
			    return;
		}
		
		if (GridList.length > srcipRespNum - 1){
        	LegoTag.Msg.alert(MESSAGE_INFO, " "+addAppintDnsRowParams.Response_sourceIp_num_wrong);
        	return;
        }
		sourceIp = htmlEncode(sourceIp);
		alertRate = htmlEncode(alertRate);
	
	    var operator="";
	    var picUrl = addDnsRowParams.picUrl;
		var Delete = addDnsRowParams.Delete;
		var deleteUrl="<a href='javascript:delSelDnsSourceIpResponseMessageItem(" +"\""+ sourceIp+ "\"" + "," + "\"" +alertRate+ "\"" + ")'>"+"<img	src= "+picUrl+" title="+Delete+ "> </a>";
	    	 
		var rows=[{
			name:"id",
			hidden:true
		},{
			name : "sourceIp",
			value : sourceIp,
			body : "<div>"+sourceIp+"</div>"
		},{
			name:"alertRate",
			value:alertRate,
			body:"<div>"+alertRate+"</div>"
		},{
			value:operator,
			body: deleteUrl
		}];
		
		LegoTag.addGridItem(Grid,rows);	
		
		LegoTag.setIpValue("dnsAppointSourceIpResponseMessage","");
		document.getElementById("dnsAppointSourceIpResponseMessageLimit").value = "";
	} 
	else if( Grid=="dnsAppointSourceIpRequestMessageGrid" )
	{
	  	var ipObj = document.getElementById("dnsAppointSourceIpRequestMessage");
		var ipObjValue = ipObj.value;
		if (ipObjValue == "")
		{
			LegoTag.Msg.alert(MESSAGE_INFO, IP_NOT_NULL_REQUEST);
			return;
		}
		
		var ipValidResult = LegoTag.getValidResult(ipObj);
		if (ipValidResult)
		{
		    LegoTag.Msg.alert(MESSAGE_INFO, ipValidResult);
		    return;
		}
		
		var rateObj = document.getElementById("dnsAppointSourceIpRequestMessageLimit");
		var rateObjValue = rateObj.value;
		if (rateObjValue == "")
		{
			LegoTag.Msg.alert(MESSAGE_INFO, RATE_NOT_NULL_REQUEST);
			return;
		}
		var rateValidResult = LegoTag.getValidResult(rateObj);
		if (rateValidResult)
		{
			LegoTag.Msg.alert(MESSAGE_INFO, rateValidResult);
			return;
		}
		
        var sourceIp = LegoTag.getIpValue("dnsAppointSourceIpRequestMessage")	;
	    var alertRate= document.getElementById("dnsAppointSourceIpRequestMessageLimit").value;
	    var srcipReqNum= document.getElementById("srcipReqNum").value;
        
        msg = addAppintDnsRowParams.sourceIp+"：" +sourceIp + " "+addAppintDnsRowParams.valueisalready;
	    for (i=0;i<GridList.length;i++)
	    {
			if ( sourceIp == GridList[i].sourceIp){
				LegoTag.Msg.alert(MESSAGE_INFO,msg);
				return;
			}
		}
		var dnsPanel = document.getElementById("appointSourceIpRequestMessagePanel");
		var validInfo = LegoTag.validFormResult(dnsPanel, true, true, addAppintDnsRowParams.info);
		if (validInfo) {
			    return;
		}
	
	    var operator="";
	    
	    if (GridList.length > srcipReqNum - 1){
        	LegoTag.Msg.alert(MESSAGE_INFO, addAppintDnsRowParams.Request_sourceIp_num_wrong );
        	return;
        }
	    
	    sourceIp = htmlEncode(sourceIp);
		alertRate = htmlEncode(alertRate);
	    var picUrl = addDnsRowParams.picUrl;
		var Delete = addDnsRowParams.Delete;
		var deleteUrl="<a href='javascript:delSelDnsSourceIpResquestMessageItem(" +"\""+ sourceIp+ "\"" + "," + "\"" +alertRate+ "\"" + ")'>"+"<img	src= "+picUrl+ " title="+Delete+"> </a>";
	    
		var rows=[{
			name:"id",
			hidden:true
		},{
			name:"sourceIp",
			value: sourceIp,
			body:"<div>"+sourceIp+"</div>"
		},{
			name:"alertRate",
			value:alertRate,
			body:"<div>"+alertRate+"</div>"
		},{
			value:operator,
			body: deleteUrl
		}];
		
		LegoTag.addGridItem(Grid,rows);	
		
		LegoTag.setIpValue("dnsAppointSourceIpRequestMessage","");
		document.getElementById("dnsAppointSourceIpRequestMessageLimit").value = "";
	}
	else if( Grid=="dnsRequestStaticFingerMarkGrid" )
	{	 
       var content = document.getElementById("dnsResquestStaticFingerMark").value;
       var offset= document.getElementById("dnsResquestStaticFingerMarkOffsetSize").value;
       var operator="";
       
       if (content.length%2!=0){
        	LegoTag.Msg.alert(MESSAGE_INFO, addAppintDnsRowParams.fingerInvalidFormat );
        	return;
       }
       
       if ((content=="")||(offset=="")){
        	LegoTag.Msg.alert(MESSAGE_INFO, addAppintDnsRowParams.fingerContent +addAppintDnsRowParams.dnsOffset +addAppintDnsRowParams.notnull );
        	return;
        }
        
       var dnsUserFingerPanel = document.getElementById("dnsRequestStaticFingerMarkFilterPanel");
       var validInfo = LegoTag.validFormResult(dnsUserFingerPanel, true, true, MESSAGE_INFO);
		if (validInfo) {
		    return;
		}
        
        for (i=0;i<GridList.length;i++){
			if (content==GridList[i].content && parseInt(offset,10)==parseInt(GridList[i].offset,10)){
				LegoTag.Msg.alert(MESSAGE_INFO, addAppintDnsRowParams.fingerContent +content+ addAppintDnsRowParams.valueisalready );
				return;
			}
		}
        
        if (GridList.length == 10){
        	LegoTag.Msg.alert(MESSAGE_INFO,  addAppintDnsRowParams.fingerNumRangewrong );
        	return;
        }
        var picUrl = addDnsRowParams.picUrl;
		var Delete = addDnsRowParams.Delete;
		var deleteUrl="<a href='javascript:delSelDnsRequStaticFingerMarkFilterItem(" +"\""+ content+ "\"" + "," + "\"" +offset+ "\"" + ")'>"+"<img	src= "+picUrl+ " title="+Delete+"> </a>";
        
        var rows=[{
			name:"id",
			hidden:true
		},{
			name:"content",
			value:content,
			body:"<div>"+content+"</div>"
		},{
			name:"offset",
			value:offset,
			body:"<div>"+offset+"</div>"
		},{
			value:operator,
			body: deleteUrl
		}];
		
               
		LegoTag.addGridItem(Grid,rows);	
		
		document.getElementById("dnsResquestStaticFingerMark").value = "";
		document.getElementById("dnsResquestStaticFingerMarkOffsetSize").value = "";
	}
  else if( Grid=="dnsResponseStaticFingerMarkGrid" )
	{  
       var content = document.getElementById("dnsResponseStaticFingerMark").value;
       var offset= document.getElementById("dnsResponseStaticFingerMarkOffsetSize").value;
       var operator="";
       
       if (content.length%2!=0){
        	LegoTag.Msg.alert(MESSAGE_INFO, addAppintDnsRowParams.fingerInvalidFormat );
        	return;
       }
       
       if ((content=="")||(offset=="")){
        	LegoTag.Msg.alert(MESSAGE_INFO,  addAppintDnsRowParams.fingerContent + addAppintDnsRowParams.dnsOffset + addAppintDnsRowParams.notnull);
        	return;
        }
        
        var dnsUserFingerPanel = document.getElementById("dnsResponseStaticFingerMarkFilterPanel");
		var validInfo = LegoTag.validFormResult(dnsUserFingerPanel, true, true, MESSAGE_INFO);
		if (validInfo) {
		    return;
		}
       
       	for (i=0;i<GridList.length;i++){
			if (content==GridList[i].content && parseInt(offset,10)==parseInt(GridList[i].offset,10)){
				LegoTag.Msg.alert(MESSAGE_INFO, addAppintDnsRowParams.fingerContent +content + addAppintDnsRowParams.valueisalready );
				return;
			}
		}
		
		if (GridList.length == 10){
        	LegoTag.Msg.alert(MESSAGE_INFO, addAppintDnsRowParams.fingerNumRangewrong );
        	return;
        }
		var picUrl = addDnsRowParams.picUrl;
		var Delete = addDnsRowParams.Delete;
		var deleteUrl="<a href='javascript:delSelDnsRespStaticFingerMarkFilterItem(" +"\""+ content+ "\"" + "," + "\"" +offset+ "\"" + ")'>"+"<img	src= "+picUrl+ " title="+Delete+"> </a>";
				
		var rows=[{
			name:"id",
			hidden:true
		},{
			name:"content",
			value:content,
			body:"<div>"+content+"</div>"
		},{
			name:"offset",
			value:offset,
			body:"<div>"+offset+"</div>"
		},{
			value:operator,
			body: deleteUrl
		}];
				
		LegoTag.addGridItem(Grid,rows);	
		
		document.getElementById("dnsResponseStaticFingerMark").value = "";
		document.getElementById("dnsResponseStaticFingerMarkOffsetSize").value = "";
	}	
}

function getSourceIpResponseArray()
{
 	var record = LegoTag.getGridAllData("dnsAppointSourceIpResponseMessageGrid");
    var result=new Array(record.length);
	if (record<1){
		return null;
	}
	for (var i=0;i<record.length;i++){
		result[i]=record[i].sourceIp+";"+record[i].alertRate;
	}	
	return result;   
}

function getSourceIpRequestArray()
{
    var record = LegoTag.getGridAllData("dnsAppointSourceIpRequestMessageGrid");
    var result=new Array(record.length);
	if (record<1){
		return null;
	}
	for (var i=0;i<record.length;i++){
		result[i]=record[i].sourceIp+";"+record[i].alertRate;
	}
	return result;   
}

function getDnsRequestStaticFingerArray()
{
    var record = LegoTag.getGridAllData("dnsRequestStaticFingerMarkGrid");
    var result=new Array(record.length);
	if (record<1){
		return null;
	}
	for (var i=0;i<record.length;i++){
		result[i]=record[i].content+":"+record[i].offset;
	}
	return result;   
}

function getDnsResponseStaticFingerArray()
{
    var record = LegoTag.getGridAllData("dnsResponseStaticFingerMarkGrid");
    var result=new Array(record.length);
	if (record<1){
		return null;
	}
	for (var i=0;i<record.length;i++){
		result[i]=record[i].content+":"+record[i].offset;
	}
	return result;   
}

function delSelDnsDomainItem( domain , alertRate )
{
	var list = LegoTag.getGridAllData("dnsDomainDefendGrid");
		
	for (var i = 0; list[i]; i++) {
	 if (domain == list[i].domain 
	    	&& parseInt(alertRate,10) == parseInt(list[i].alertRate,10)) {
	        LegoTag.delGridItemForIndex("dnsDomainDefendGrid", i);
	        
	        return;
	    } 
	}
}

function delSelDnsCacheItem(domain , ipAddress )
{
	var list = LegoTag.getGridAllData("dnsDomainCacheGrid");
		
	for (var i = 0; list[i]; i++) {	
	 if (domain == list[i].domain 
	    	&& ipAddress == list[i].ipAddress ) {
	        LegoTag.delGridItemForIndex("dnsDomainCacheGrid", i);
		        
	        	return;
	    } 
	}
}

function delSelDnsSourceIpResponseMessageItem( sourceIp , alertRate  )
{
	var list = LegoTag.getGridAllData("dnsAppointSourceIpResponseMessageGrid");
		
	for (var i = 0; list[i]; i++) {
	 if (sourceIp == list[i].sourceIp 
	    	&&  parseInt(alertRate,10) == parseInt(list[i].alertRate,10) ) {	    	
	        LegoTag.delGridItemForIndex("dnsAppointSourceIpResponseMessageGrid", i);
	       
	        return;
	    } 
	}
}
function delSelDnsSourceIpResquestMessageItem( sourceIp , alertRate  )
{
	var list = LegoTag.getGridAllData("dnsAppointSourceIpRequestMessageGrid");
		
	for (var i = 0; list[i]; i++) {
	 if (sourceIp == list[i].sourceIp 
	    	&&  parseInt(alertRate,10) == parseInt(list[i].alertRate,10) ) {	    	
	        LegoTag.delGridItemForIndex("dnsAppointSourceIpRequestMessageGrid", i);
	          
	        return;
	    } 
	}
}

function delSelDnsRequStaticFingerMarkFilterItem( content , offset )
{
	var list = LegoTag.getGridAllData("dnsRequestStaticFingerMarkGrid");
		
	for (var i = 0; list[i]; i++) {
	 if (content == list[i].content 
	    	&&  parseInt(offset,10) == parseInt(list[i].offset,10) ) {	    	
	        LegoTag.delGridItemForIndex("dnsRequestStaticFingerMarkGrid", i);
	        
	        return;
	    } 
	}
}

function delSelDnsRespStaticFingerMarkFilterItem( content , offset )
{
	var list = LegoTag.getGridAllData("dnsResponseStaticFingerMarkGrid");
		
	for (var i = 0; list[i]; i++) {
	 if (content == list[i].content 
	    	&&  parseInt(offset,10) == parseInt(list[i].offset,10) ) {	    	
	        LegoTag.delGridItemForIndex("dnsResponseStaticFingerMarkGrid", i);
	        
	        return;
	    } 
	}
}

function delSelDnsStatisticItem(stasticTypeCode , dnsItemName)
{
	var list = LegoTag.getGridAllData("dnsStatisticItemGrid");
		
	for (var i = 0; list[i]; i++) {
	 if (stasticTypeCode == list[i].stasticTypeCode 
	    	&&  dnsItemName == list[i].dnsItemName  ) {	    	
	        LegoTag.delGridItemForIndex("dnsStatisticItemGrid", i);
	        
	        return;
	    } 
	}
}

function onLoadJsp()
{

	setDnsComponentStatus(['zoneTemplateForm.dnsDefendPolicyForm.alertRate','dnsFloodDefendModeList','udpPacketLengthLearnLabel','udpPacketLengthLearnColon'
			,'dnsAlertRateLabel','dnsAlertRateUnit','dnsAlertRateColon','dnsAlertRateParaRange'],onLoadJspParams.dnsFloodEnable);
	
	setDnsComponentStatus(['zoneTemplateForm.dnsDefendPolicyForm.replyFloodAlertRate','dnsReplyFloodAlertRateLabel','dnsReplyFloodAlertRateUnit'
			,'dnsReplyFloodAlertRateColon','dnsReplyFloodAlertRateParaRange'],onLoadJspParams.replyFloodEnable);
	setDnsComponentStatus(['zoneTemplateForm.dnsDefendPolicyForm.srcipReqAlertRate','dnsSrcipReqAlertRateLabel','dnsSrcipReqAlertRateUnit'
			,'dnsSrcipReqAlertRateColon','dnsSrcipReqAlertRateParaRange'],onLoadJspParams.srcipReqLimitEnable);
	setDnsComponentStatus(['zoneTemplateForm.dnsDefendPolicyForm.srcipRespAlertRate','dnsSrcipRespAlertRateLabel','dnsSrcipRespAlertRateUnit'
			,'dnsSrcipRespAlertRateColon','dnsSrcipRespAlertRateParaRange'],onLoadJspParams.srcipRespLimitEnable);
	setDnsComponentStatus(['zoneTemplateForm.dnsDefendPolicyForm.domainReqAlertRate','dnsDomainReqAlertRateLabel','dnsDomainReqAlertRateUnit'
			,'dnsDomainReqAlertRateColon','dnsDomainReqAlertRateParaRange'],onLoadJspParams.domainReqLimitEnable);
	setDnsComponentStatus(['zoneTemplateForm.dnsDefendPolicyForm.responseDomainAlertRate','dnsResponseDomainAlertRateLabel','dnsResponseDomainAlertRateUnit'
			,'dnsResponseDomainAlertRateColon','dnsResponseDomainAlertRateParaRange'],onLoadJspParams.responseDomainEnable);
		
	setDnsComponentStatus(['zoneTemplateForm.dnsDefendPolicyForm.dnsRequestMessageLen','dnsRequestMessageLenLabel','dnsRequestMessageLenUnit'
			,'dnsRequestMessageLenColon','dnsRequestMessageLenParaRange'],onLoadJspParams.dnsRequestMessageLenLimitEnable);
	setDnsComponentStatus(['zoneTemplateForm.dnsDefendPolicyForm.dnsResponseMessageLen','dnsResponseMessageLenLabel','dnsResponseMessageLenUnit'
			,'dnsResponseMessageLenColon','dnsResponseMessageLenParaRange'],onLoadJspParams.dnsReponseMessageLenLimitEnable);

	setDnsComponentStatus(['zoneTemplateForm.dnsDefendPolicyForm.dnsReflectAlertRate','dnsReflectAlertRateLabel','dnsReflectAlertRateUnit'
			,'dnsReflectAlertRateColon','dnsReflectAlertRateParaRange'],onLoadJspParams.dnsReflectAttackDefencdEnable);
	

	dnsBlockPanel_onclick();
	dnsRecoveryPanel_onclick();
	dnsDomainCachePanel_onclick();
	dnsUserFingerPanel_onclick();
	dnsLimitPanel_onclick();	
	dnsStatisticEnable_onclick();
	
	dnsAppointResponseDomainPanel_onclick();
	dnsAppointRequestDomainPanel_onclick();
	appointSourceIpResponseMessagePanel_onclick();
	appointSourceIpRequestMessagePanel_onclick();
	dnsRequestStaticFingerMarkFilterPanel_onclick();
	dnsResponseStaticFingerMarkFilterPanel_onclick();
	requestMessageTTLPanel_onclick();
}

		function lowCase(obj) {
			if(obj.value==obj.value.toLowerCase())
			{
				return true;
			}
			else
			{
				obj.value = obj.value.toLowerCase();
			}
		}
		
		
		function requestMessageTTLPanel_onclick()
		{
			var mode = LegoTag.getRdiCheckedValue("requestTtlMode").value;
			if(LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.requestTtlCheckEnable'))
			{
				LegoTag.setDisableds(['requestTtlAlertRate','requestTtlMode'],false);
				document.getElementById('requestMessageTTLPanel').style.display='block';
				if (mode == 1)
				{
					LegoTag.setDisableds(['requestTtlAlertRate'],false);
					document.getElementById("dnsRequestTtlTable").style.display = "block";
					document.getElementById("requestMessageRangeTTLPanel").style.display = "none";
				}
				else
				{
					LegoTag.setDisableds(['requestTtlAlertRate'],true);
					document.getElementById("dnsRequestTtlTable").style.display = "none";
					document.getElementById("requestMessageRangeTTLPanel").style.display = "block";
				}
			}
			else
			{
				LegoTag.setDisableds(['requestTtlAlertRate','requestTtlMode'],true);
				document.getElementById('requestMessageTTLPanel').style.display='none';
				LegoTag.setDisableds(['requestTtlAlertRate'],true);
			}		
		}
		function replyMessageTTLPanel_onclick()
		{
			var mode = LegoTag.getRdiCheckedValue("replyTtlMode").value;
			if(LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.replyTtlCheckEnable'))
			{
				LegoTag.setDisableds(['replyTtlAlertRate','replyTtlMode'],false);
				document.getElementById('replyMessageTTLPanel').style.display='block';
				if (mode == 1)
				{
					LegoTag.setDisableds(['replyTtlAlertRate'],false);
					document.getElementById("dnsReplyTtlTable").style.display = "block";
					document.getElementById("replyMessageRangeTTLPanel").style.display = "none";
				}
				else
				{
					LegoTag.setDisableds(['replyTtlAlertRate'],true);
					document.getElementById("dnsReplyTtlTable").style.display = "none";
					document.getElementById("replyMessageRangeTTLPanel").style.display = "block";
				}
			}
			else
			{
				LegoTag.setDisableds(['replyTtlAlertRate','replyTtlMode'],true);
				document.getElementById('replyMessageTTLPanel').style.display='none';
				LegoTag.setDisableds(['replyTtlAlertRate'],true);
			}		
		
		}
		
		
		function changeTabForTLL(arg1,arg2,textId)
		{
			if(LegoTag.getRdiCheckedValue(arg1).value==1)
			{
				LegoTag.setDisableds(textId,false);
				document.getElementById(textId).value='';
				document.getElementById(arg2).style.display='block';
				document.getElementById(arg2+'All').style.display='none';
			}
			else
			{
				LegoTag.setDisableds(textId,true);
				document.getElementById(textId).value='';
				document.getElementById(arg2).style.display='none';
				document.getElementById(arg2+'All').style.display='block';
			}
		}
		
		
		function addNewRow(Grid,type)
		{
			
		}
		
		function delTtlRow(gridId,beginValue,endValue)
		{
			
			var list = LegoTag.getGridAllData(gridId);				
			for (var i = 0; list[i]; i++) 
			{
				 if (beginValue == list[i].number1&&  endValue == list[i].number2  ) 
			     {	    	
			        LegoTag.delGridItemForIndex(gridId, i);			        
			        return;
			     } 
			}
		}
		
		
	 	function dnsCheckEnable_onclick()
		{
			var dnsCheckEnable = LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.replyFloodSrcDectectEnable");
			var dnsLowCheckEnable = LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.replyFloodSessCheckEnable");
			LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.replyFloodSrcDectectEnable',true);
		    LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.replyFloodSessCheckEnable',false);
			LegoTag.setDisableds(addDnsRowParams.dnsReplyFloodAlertRate,!dnsCheckEnable);
		}
		
		function replyFloodEnable_onclick(un800e)
		{
		    var dnsCheckEnable = LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.replyFloodEnable');
			if (dnsCheckEnable)
			{
			 	LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.replyFloodSrcDectectEnable',true);
		        LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.replyFloodSessCheckEnable',false);
		        LegoTag.setDisableds(addDnsRowParams.dnsReplyFloodAlertRate,!dnsCheckEnable);
			}
			else
			{
				LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.replyFloodSrcDectectEnable',false);
				LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.replyFloodSessCheckEnable',false);
				LegoTag.setDisableds(addDnsRowParams.dnsReplyFloodAlertRate,!dnsCheckEnable);
			}
			setDnsComponentStatus('zoneTemplateForm.dnsDefendPolicyForm.replyFloodSrcDectectEnable',!LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.replyFloodEnable'));
			setDnsComponentStatus('zoneTemplateForm.dnsDefendPolicyForm.replyFloodSessCheckEnable',!LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.replyFloodEnable'));
			if(un800e&&LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.replyFloodEnable'))
			{
				LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.replyFloodSrcDectectEnable',true);
			}
		}
		
		function addRequestMessageRangeTTL()
		{
			var num1 = document.getElementById("requestMessageRangeTTLnum1").value;
			var num2 = document.getElementById("requestMessageRangeTTLnum2").value;
			
			var Panel = document.getElementById("requestMessageRangeTTLPanel");
			var validInfo = LegoTag.validFormResult(Panel, true, true, addAppintDnsRowParams.info);
			if (validInfo) {
				    return;
			}
			
			var list = LegoTag.getGridAllData("requestMessageRangeTTLList");	
			if(list.length>3)
			{
				LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.REQUEST_TTL_OVERNUMBER);
				return;
			}	
			
			if(num1==''||num2=='')
			{
				LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.TTL_NULL);
				return;
			}
			
			if(parseInt(num1)>parseInt(num2))
			{
				LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.TTL_BEGIN_OVER_END);
				return;
			}
			
			for (var i = 0; i < list.length; i++)
			{
				if (parseInt(list[i].number1) == parseInt(num1) && parseInt(list[i].number2) == parseInt(num2))
				{
					LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.REQUEST_TTL_CROSSNUMBER);
					return;
				}
				if (parseInt(list[i].number1) == parseInt(list[i].number2))
				{
					if (!(parseInt(list[i].number1) < parseInt(num1) || parseInt(list[i].number1) > parseInt(num2)))
					{
						LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.REQUEST_TTL_CROSSNUMBER);
						return;
					}
				}
				else
				{
					if (parseInt(num1) == parseInt(num2))
					{
						if (!(parseInt(list[i].number1) > parseInt(num1) || parseInt(list[i].number2) < parseInt(num1)))
						{
							LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.REQUEST_TTL_CROSSNUMBER);
							return;
						}
					}
					else
					{
						if ((parseInt(list[i].number1) < parseInt(num1) && parseInt(list[i].number2) > parseInt(num1))
							|| (parseInt(list[i].number1) < parseInt(num2) && parseInt(list[i].number2) > parseInt(num2))
							|| (parseInt(num1) < parseInt(list[i].number1) && parseInt(num2) > parseInt(list[i].number1))
							|| (parseInt(num1) < parseInt(list[i].number2) && parseInt(num2) > parseInt(list[i].number2)))
						{
							LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.REQUEST_TTL_CROSSNUMBER);
							return;
						}
					}
				}
			}
			num1 = htmlEncode(num1);
			num2 = htmlEncode(num2);
			var picUrl = addDnsRowParams.picUrl;
			var Delete = addDnsRowParams.Delete;
			var deleteUrl="<a href='javascript:delTtlRow(\""+"requestMessageRangeTTLList"+"\",\""+ num1+ "\"" + "," + "\"" +num2+ "\"" + ")'>"+"<img	src= "+picUrl+ " title="+Delete+"> </a>";
					
			var rows=[{
				name:"number1",
				value:num1,
				body:"<div>"+num1+"</div>"
			},{
				name:"number2",
				value:num2,
				body:"<div>"+num2+"</div>"
			},{
				value:"",
				body: deleteUrl
			}];
					
			LegoTag.addGridItem("requestMessageRangeTTLList",rows);	
			
			document.getElementById("requestMessageRangeTTLnum1").value = "";
			document.getElementById("requestMessageRangeTTLnum2").value = "";
		}
		
		function getRequestMessageRangeTTLList()
		{
			var record = LegoTag.getGridAllData("requestMessageRangeTTLList");
			var result=new Array(record.length);
			if (record<1){
				return null;
			}
			
			for (var i=0;i<record.length;i++){
				result[i]=record[i].number1+"-"+record[i].number2;
			}
			return result;
		}
		
		function changeRequestTtlMode()
		{
			var mode = LegoTag.getRdiCheckedValue("requestTtlMode").value;
			
			if(LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.requestTtlCheckEnable'))
			{
				if (mode == 1)
				{
					LegoTag.setDisableds(['requestTtlAlertRate'],false);
					document.getElementById("dnsRequestTtlTable").style.display = "block";
					document.getElementById("requestMessageRangeTTLPanel").style.display = "none";
				}
				else
				{
					LegoTag.setDisableds(['requestTtlAlertRate'],true);
					document.getElementById("dnsRequestTtlTable").style.display = "none";
					document.getElementById("requestMessageRangeTTLPanel").style.display = "block";
				}
			}
		}
		
		function addReplyMessageRangeTTL()
		{
			var num1 = document.getElementById("replyMessageRangeTTLnum1").value;
			var num2 = document.getElementById("replyMessageRangeTTLnum2").value;
			
			var Panel = document.getElementById("replyMessageRangeTTLPanel");
			var validInfo = LegoTag.validFormResult(Panel, true, true, addAppintDnsRowParams.info);
			if (validInfo) {
				    return;
			}
			
			var list = LegoTag.getGridAllData("replyMessageRangeTTLList");	
			if(list.length>3)
			{
				LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.REPLY_TTL_OVERNUMBER);
				return;
			}	
			
			if(num1==''||num2=='')
			{
				LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.TTL_NULL);
				return;
			}
			
			if(parseInt(num1)>parseInt(num2))
			{
				
				LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.TTL_BEGIN_OVER_END);
				return;
			}
			for (var i = 0; i < list.length; i++)
			{
				if (parseInt(list[i].number1) == parseInt(num1) && parseInt(list[i].number2) == parseInt(num2))
				{
					LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.REPLY_TTL_CROSSNUMBER);
					return;
				}
				if (parseInt(list[i].number1) == parseInt(list[i].number2))
				{
					if (!(parseInt(list[i].number1) < parseInt(num1) || parseInt(list[i].number1) > parseInt(num2)))
					{
						LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.REPLY_TTL_CROSSNUMBER);
						return;
					}
				}
				else
				{
					if (parseInt(num1) == parseInt(num2))
					{
						if (!(parseInt(list[i].number1) > parseInt(num1) || parseInt(list[i].number2) < parseInt(num1)))
						{
							LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.REPLY_TTL_CROSSNUMBER);
							return;
						}
					}
					else
					{
						if ((parseInt(list[i].number1) < parseInt(num1) && parseInt(list[i].number2) > parseInt(num1))
							|| (parseInt(list[i].number1) < parseInt(num2) && parseInt(list[i].number2) > parseInt(num2))
							|| (parseInt(num1) < parseInt(list[i].number1) && parseInt(num2) > parseInt(list[i].number1))
							|| (parseInt(num1) < parseInt(list[i].number2) && parseInt(num2) > parseInt(list[i].number2)))
						{
							LegoTag.Msg.alert(MESSAGE_INFO,addDnsRowParams.REPLY_TTL_CROSSNUMBER);
							return;
						}
					}
				}
			}
			num1 = htmlEncode(num1);
			num2 = htmlEncode(num2);
			var picUrl = addDnsRowParams.picUrl;
			var Delete = addDnsRowParams.Delete;
			var deleteUrl="<a href='javascript:delTtlRow(\""+"replyMessageRangeTTLList"+"\",\""+ num1+ "\"" + "," + "\"" +num2+ "\"" + ")'>"+"<img	src= "+picUrl+ " title="+Delete+"> </a>";
					
			var rows=[{
				name:"number1",
				value:num1,
				body:"<div>"+num1+"</div>"
			},{
				name:"number2",
				value:num2,
				body:"<div>"+num2+"</div>"
			},{
				value:"",
				body: deleteUrl
			}];
					
			LegoTag.addGridItem("replyMessageRangeTTLList",rows);	
			
			document.getElementById("replyMessageRangeTTLnum1").value = "";
			document.getElementById("replyMessageRangeTTLnum2").value = "";
		}
		
		function getReplyMessageRangeTTLList()
		{
			var record = LegoTag.getGridAllData("replyMessageRangeTTLList");
			var result=new Array(record.length);
			if (record<1){
				return null;
			}
			
			for (var i=0;i<record.length;i++){
				result[i]=record[i].number1+"-"+record[i].number2;
			}
			return result;
		}
		
		function changeReplyTtlMode()
		{
			var mode = LegoTag.getRdiCheckedValue("replyTtlMode").value;
			
			if(LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.replyTtlCheckEnable'))
			{
				if (mode == 1)
				{
					LegoTag.setDisableds(['replyTtlAlertRate'],false);
					document.getElementById("dnsReplyTtlTable").style.display = "block";
					document.getElementById("replyMessageRangeTTLPanel").style.display = "none";
				}
				else
				{
					LegoTag.setDisableds(['replyTtlAlertRate'],true);
					document.getElementById("dnsReplyTtlTable").style.display = "none";
					document.getElementById("replyMessageRangeTTLPanel").style.display = "block";
				}
			}
		}
		
		function dnsFormatClick()
		{
			var check = LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.formatCheckEnable");
			LegoTag.setDisableds(addDnsRowParams.dnsFormatCheck,!check);
		}
		
		function noSuchNameCheckEnable_onclick()
		{
			var check = LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.noSuchNameCheckEnable");
			
			if (check)
			{
				LegoTag.setDisableds(addDnsRowParams.noSuchNameCheckAlertRatio,false);
			}
			else
			{
				LegoTag.setDisableds(addDnsRowParams.noSuchNameCheckAlertRatio,true);
			}
		}
		// 缓存服务器
		function turnonDnsCacheServerEnable()
		{
			var check = LegoTag.getChecked("dnsCacheServerEnable");
			if (check)
			{
				LegoTag.setDisableds(['zoneTemplateForm.dnsDefendPolicyForm.dnsFloodEnable','zoneTemplateForm.dnsDefendPolicyForm.cachePoisoningEnable'],!check);
				LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.dnsFloodEnable', true);
				var dnsFloodcheck = LegoTag.getChecked("zoneTemplateForm.dnsDefendPolicyForm.dnsFloodEnable");
				LegoTag.setDisableds(addDnsRowParams.dnsFloodDefendMode,!dnsFloodcheck);
				LegoTag.setDisableds(addDnsRowParams.dnsAlertRate,!dnsFloodcheck);
				LegoTag.setCheck('dnsAuthServerEnable',false);
				var dnsFloodDefendMode = LegoTag.getRdiCheckedValue("dnsFloodDefendModeList").value;
				LegoTag.setDisableds(['dnsEnable', 'dnsLowerLimit', 'dnsLowerLimitRange','dnsUpperLimit', 'dnsRange','dnsUpperLimitRange'],false);
				// 授权服务器
				turnonDnsAuthServerEnable();
			}
			else
			{
				LegoTag.setDisableds(addDnsRowParams.dnsFloodDefendMode,true);
				LegoTag.setDisableds(addDnsRowParams.dnsAlertRate,true);
				LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.dnsFloodEnable',false);
								LegoTag.setDisableds(['zoneTemplateForm.dnsDefendPolicyForm.dnsFloodEnable','zoneTemplateForm.dnsDefendPolicyForm.cachePoisoningEnable'],!check);
				LegoTag.setCheck('zoneTemplateForm.dnsDefendPolicyForm.cachePoisoningEnable',false);
				LegoTag.setCheck('dnsEnable',false);
				LegoTag.setDisableds(['dnsEnable', 'dnsLowerLimit', 'dnsLowerLimitRange','dnsUpperLimit', 'dnsRange','dnsUpperLimitRange'],true);
			}
			
		}
		
		//授权服务器
		function turnonDnsAuthServerEnable()
		{
			var check = LegoTag.getChecked("dnsAuthServerEnable");
			
			if (check)
			{
				LegoTag.setDisableds(['dnsServerFloodEnable'],!check);
				LegoTag.setCheck('dnsServerFloodEnable',true);
				var dnsFloodcheck = LegoTag.getChecked("dnsServerFloodEnable");
				dnsServerFloodEnableOnclick();
				LegoTag.setCheck('dnsCacheServerEnable',false);	
				turnonDnsCacheServerEnable();
			}
			else
			{
				LegoTag.setCheck('dnsServerFloodEnable',false);
				LegoTag.setDisableds(['dnsServerFloodEnable'],!check);
				dnsServerFloodEnableOnclick();
				LegoTag.setCheck('dnsEnable2',false);
				LegoTag.setDisableds(['dnsEnable2', 'dnsLowerLimit2', 'dnsLowerLimitRange2','dnsUpperLimit2', 'dnsRange2','dnsUpperLimitRange2'],!check);
			}
			
		}
		
		function checkIp()
		{
			return true;
		}
		
		function dnsFloodEnableOnclick()
		{
			var check = LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.dnsFloodEnable');
			setDnsComponentStatus(addDnsRowParams.dnsFloodDefendMode,!check);
			setDnsComponentStatus(addDnsRowParams.dnsAlertRate,!check);
			LegoTag.setCheck('dnsCacheServerEnable',check);
			LegoTag.setDisableds(['zoneTemplateForm.dnsDefendPolicyForm.dnsFloodEnable'], !check);
		}
		
		function dnsServerFloodEnableOnclick()
		{
			var check = LegoTag.getChecked('dnsServerFloodEnable');
			var dnsFloodServerDefendMode = LegoTag.getRdiCheckedValue("dnsFloodServerDefendModeList").value;
			LegoTag.setDisableds(['dnsEnable2', 'dnsLowerLimit2', 'dnsLowerLimitRange2','dnsUpperLimit2', 'dnsRange2','dnsUpperLimitRange2'],false);
			setDnsComponentStatus(addDnsRowParams.dnsFloodServerDefendMode,!check);
			setDnsComponentStatus(addDnsRowParams.dnsServerAlertRate,!check);
			LegoTag.setCheck('dnsAuthServerEnable',check);
			LegoTag.setDisableds(['dnsServerFloodEnable'], !check);
		}
		
		function srcipReqLimitEnableOnclick()
		{
		    setDnsComponentStatus(addDnsRowParams.dnsFloodSrcipOtherReqMode,!LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.srcipReqLimitEnable'));
			setDnsComponentStatus(addDnsRowParams.dnsSrcipReqAlertRate,!LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.srcipReqLimitEnable'));
		}
		
		function srcipRespLimitEnableOnclick()
		{
			setDnsComponentStatus(addDnsRowParams.dnsFloodSrcipOtherRespMode,!LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.srcipRespLimitEnable'));
			setDnsComponentStatus(addDnsRowParams.dnsSrcipRespAlertRate,!LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.srcipRespLimitEnable'));
		}
		
		function dnsRequestMessageLenLimitEnableOnclick()
		{
			setDnsComponentStatus(addDnsRowParams.dnsRequestMessageLen,!LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.dnsRequestMessageLenLimitEnable'));
		}
		
		function dnsReponseMessageLenLimitEnableOnclick()
		{
			setDnsComponentStatus(addDnsRowParams.dnsResponseMessageLen,!LegoTag.getChecked('zoneTemplateForm.dnsDefendPolicyForm.dnsReponseMessageLenLimitEnable'));
		}
