Ext.menu.DateTimeMenu = function(config) {
	Ext.menu.DateTimeMenu.superclass.constructor.call(this, config);
	this.plain = true;
	var di = new Ext.menu.DateTimeItem(config);
	this.add(di);
	this.picker=di.picker;
	this.relayEvents(di, ["select"]);
	this.on('beforeshow', function() {
		if (this.picker) {
			this.picker.hideMonthPicker(true);
		}
	}, this);
};
Ext.extend(Ext.menu.DateTimeMenu, Ext.menu.Menu, {
	cls : 'x-date-menu'
});

Ext.menu.DateTimeItem = function(config) {
	Ext.menu.DateTimeItem.superclass.constructor.call(this,
			new Ext.DateTimePicker(config), config);

	this.picker = this.component;
	this.addEvents('select');

	this.picker.on("render", function(picker) {
		picker.getEl().swallowEvent("click");
		picker.container.addClass("x-menu-date-item");
	});
	this.picker.on("select", this.onSelect, this);
};

Ext.extend(Ext.menu.DateTimeItem, Ext.menu.Adapter, {
	onSelect : function(picker, date) {
		var ndate=picker.activeDate;
		if( picker.activeDate.format("H:i:s") != date.format("H:i:s") ){
			var oldHour = picker.activeDate.format("H");
			var oldMinute = picker.activeDate.format("i");
			var oldSecend = picker.activeDate.format("s");
			
			ndate = picker.activeDate.add(Date.HOUR,-(oldHour*1.0)).add(Date.MINUTE,-(oldMinute*1.0)).add(Date.SECOND,-(oldSecend*1.0));
			ndate = ndate.add(Date.HOUR,date.format("H")).add(Date.MINUTE,date.format("i")).add(Date.SECOND,date.format("s"));
		}
		picker.activeDate = ndate;
		date = ndate;
		
		this.fireEvent("select", this, date, picker);
		Ext.menu.DateTimeItem.superclass.handleClick.call(this);
	}
});

Ext.DateTimePicker = Ext.extend(Ext.Component, {
	todayText : tag_common.core_date_todayText,
	okText : tag_common.core_date_okText,
	cancelText : tag_common.core_date_cancelText,
	todayTip : "{0}",
	minDate : null,
	maxDate : null,
	minText : tag_common.core_date_minText,
	maxText : tag_common.core_date_maxText,
	format : "Y-m-d H:i:s",
	disabledDays : null,
	disabledDaysText : "",
	disabledDatesRE : null,
	disabledDatesText : "",
	constrainToViewport : true,
	monthNames : Date.monthNames,
	dayNames : Date.dayNames,
	nextText : tag_common.core_date_nextText,
	prevText : tag_common.core_date_prevText,
	prevTimeText : tag_common.core_time_prevText,
	nextTimeText : tag_common.core_time_nextText,
	nextYearText : tag_common.core_year_nextText,
	prevYearText : tag_common.core_year_prevText,	
	monthYearText : tag_common.core_date_monthYearText,
	clearDateText : tag_common.core_clear_date_text,
	timeText : tag_common.time_text,
	hourel : null,
	minuteel : null,
	secondel : null,
	currentTimeType : 0,
	timeFocusFlag : false,
	maxYear :2099,
	minYear :1950,
	showTime :true ,
	startDay : 0,
	inputFormat:"",

	initComponent : function() {
		Ext.DateTimePicker.superclass.initComponent.call(this);
		var tempElement = null;
		if (Ext.isIE) {
			try {
				tempElement = document
						.createElement("<INPUT type='text' size='2' maxLength='2' style='font-size:12px'   />");
				this.hourel = tempElement;
				this.minuteel = document
						.createElement("<INPUT type='text' size='2' maxLength='2' style='font-size:12px'   />");
				this.secondel = document
						.createElement("<INPUT type='text' size='2' maxLength='2' style='font-size:12px'   />");
			} catch (e) {
				tempElement = null;
			}
		}
		
		if (tempElement == null)
		{
			this.hourel = document.createElement("INPUT");
			this.hourel.type = "text";
			this.hourel.size = 2;
			this.hourel.maxLength = 2;
			this.hourel.style.fontSize = 12;
			this.hourel.style.width = 25;

			this.minuteel = document.createElement("INPUT");
			this.minuteel.type = "text";
			this.minuteel.size = 2;
			this.minuteel.maxLength = 2;
			this.minuteel.style.fontSize = 12;
			this.minuteel.style.width = 25;

			this.secondel = document.createElement("INPUT");
			this.secondel.type = "text";
			this.secondel.size = 2;
			this.secondel.maxLength = 2;
			this.secondel.style.fontSize = 12;
			this.secondel.style.width = 25;
		}
		Ext.get(this.hourel).on("dblclick", this.selectText, this);
		Ext.get(this.minuteel).on("dblclick", this.selectText, this);
		Ext.get(this.secondel).on("dblclick", this.selectText, this);
		Ext.get(this.hourel).on("mouseover", this.mouseoverEvent, this);
		Ext.get(this.minuteel).on("mouseover", this.mouseoverEvent, this);
		Ext.get(this.secondel).on("mouseover", this.mouseoverEvent, this);		
		Ext.get(this.hourel).on("mouseout", this.mouseoutEvent, this);
		Ext.get(this.minuteel).on("mouseout", this.mouseoutEvent, this);
		Ext.get(this.secondel).on("mouseout", this.mouseoutEvent, this);		
		this.value = this.value ? this.value.clearTime() : new Date()
				.clearTime();
		this.addEvents('select');
		if (this.handler) {
			this.on("select", this.handler, this.scope || this);
		}
		this.initDisabledDays();
	},
    selectText: function(e){
		var target = e.getTarget();
		target.select();		
	},
	mouseoverEvent:function(e){
		var target = e.getTarget();
		Ext.get(target).setStyle("border","1px solid #FC6B09");
	},
	mouseoutEvent:function(e){
		var target = e.getTarget();
		Ext.get(target).setStyle("border","1px solid #BCBCC2");
	},
	initDisabledDays : function() {
		if (!this.disabledDatesRE && this.disabledDates) {
			var dd = this.disabledDates;
			var re = "(?:";
			for (var i = 0; i < dd.length; i++) {
				re += dd[i];
				if (i != dd.length - 1)
					re += "|";
			}
			this.disabledDatesRE = new RegExp(re + ")");
		}
	},

	setValue : function(value) {
		var old = this.value;

		var hour = value.getHours();
		var minute = value.getMinutes();
		var second = value.getSeconds();
		this.hourel.value = hour > 9 ? hour : "0" + hour;
		this.minuteel.value = minute > 9 ? minute : "0" + minute;
		this.secondel.value = second > 9 ? second : "0" + second;
		this.value = value;
		if (this.el) {
			this.update(this.value);
		}
	},

	getValue : function() {
		return this.value;
	},

	focus : function() {
		if (!this.timeFocusFlag && this.el) {
			this.update(this.activeDate);
		}
	},

	onRender : function(container, position) {
		var m = [
				'<table cellspacing="0">',
				'<tr><td class="x-date-left"><a href="#" title="',
				this.prevText,
				'">&#160;</a></td><td class="x-date-middle" align="center" title="'+ this.monthYearText +'"></td><td class="x-date-right"><a href="#" title="',
				this.nextText, '">&#160;</a></td></tr>',
				'<tr><td colspan="3"><table class="x-date-inner" cellspacing="0"><thead><tr>'];
		var dn = this.dayNames;
		for (var i = 0; i < 7; i++) {
			var d = this.startDay + i;
			if (d > 6) {
				d = d - 7;
			}
			m.push("<th><span>", dn[d].substr(0, 1), "</span></th>");
		}
		m[m.length] = "</tr></thead><tbody><tr>";
		for (var i = 0; i < 42; i++) {
			if (i % 7 == 0 && i != 0) {
				m[m.length] = "</tr><tr>";
			}
			if(Ext.isIE){
			m[m.length] = '<td><a href="#" hidefocus="on" class="x-date-date" tabIndex="1"><em><span></span></em></a></td>';
			}else{
			m[m.length] = '<td><a          hidefocus="on" class="x-date-date" tabIndex="1"><em><span></span></em></a></td>';	
			}
		}
		m[m.length] = '</tr></tbody></table></td></tr>';
		
		m[m.length] = '<tr><td colspan="3" class="x-date-time " align="left" style="font-size:15px;-moz-user-select:-moz-none;padding-left: 10px;">';
		if(this.showTime){
		m[m.length] = '<div style="float:left;margin-top:10px;"><table style="float:left;margin-top:2px;"><tr><td>'+this.timeText+'</td></tr></table><table style="float:left;" cellspacing="0" class="date_time_wraper"><tr><td class="x-date-hour-td" ></td><td>:</td><td class="x-date-minute-td"></td><td>:</td><td class="x-date-second-td"></td>'
				+ '<td style="padding-left:3px"><table cellspacing="0">'
				+ '<tr><td class="add-time-td" valign="top" height="10px" title="'+this.prevTimeText+'"><img style="cursor:pointer" class="timeInc" src="'+WEB_ROOT_ABS_PATH+'/struts/ext/resources/images/shared/s.gif"></td></tr>'
				+ '<tr><td class="decrease-time-td" valign="bottom" height="10px" title="'+this.nextTimeText+'"><img style="cursor:pointer"  class="timeDec" src="'+WEB_ROOT_ABS_PATH+'/struts/ext/resources/images/shared/s.gif"></td></tr></table>'
				+ '</td></tr></table></div>';
		}
		m[m.length] = '<div class="btn_today_extend" style="float:right;margin-top:10px;margin-right:10px;"></div>';
		m[m.length] = '</td></tr>';
		m[m.length] = '<tr><td class="x-date-bottom" colspan="3" align="center"><table><tr><td  class="x-date-bottom-left" align="center"></td><td class="x-date-bottom-right" align="center"></td></tr></table></td></tr></table><div class="x-date-mp"></div>';

		var el = document.createElement("div");
		el.className = "x-date-picker";
		el.innerHTML = m.join("");
		container.dom.insertBefore(el, position);

		this.el = Ext.get(el);
		this.eventEl = Ext.get(el.firstChild);

		new Ext.util.ClickRepeater(this.el.child("td.x-date-left a"), {
			handler : this.showPrevMonth,
			scope : this,
			preventDefault : true,
			stopDefault : true
		});

		new Ext.util.ClickRepeater(this.el.child("td.x-date-right a"), {
			handler : this.showNextMonth,
			scope : this,
			preventDefault : true,
			stopDefault : true
		});

		this.eventEl.on("mousewheel", this.handleMouseWheel, this);

		this.monthPicker = this.el.down('div.x-date-mp');
		this.monthPicker.enableDisplayMode('block');

		var kn = new Ext.KeyNav(this.eventEl, {
			"left" : function(e) {
			var target = e.getTarget();
			 e.ctrlKey ? this.showPrevMonth() : (target.tagName.toLowerCase()=="input"?(Ext.get(target).parent().prev()!=null?Ext.get(target).parent().prev().prev().select("input").focus():null):null);
			 if(target.tagName.toLowerCase()!="input"){
				 if(parseInt(this.activeDate.format("Y-m-d").split("-")[0],10) > 2099){
					 this.update(this.activeDate.add("d",-1));
					 return;
				 }
				 if(parseInt(this.activeDate.format("Y-m-d").split("-")[0],10) < 1950){
					 this.update(this.activeDate.add("d",1));
					 return;
				 }

			 }
				if(target.tagName.toLowerCase()=="input" && Ext.get(target).parent().prev()!=null){
					target= Ext.get(target).parent().prev().prev();
					if(Ext.get(target).hasClass("x-date-hour-td")){
						this.currentTimeType = 0 ;
					}else if(Ext.get(target).hasClass("x-date-minute-td")){
						this.currentTimeType = 1 ;
					}else{
						this.currentTimeType = 2 ;
					}
			    }
			},

			"right" : function(e) {
				var target = e.getTarget();
				e.ctrlKey ? this.showNextMonth() : (target.tagName.toLowerCase()=="input"?(Ext.get(target).parent().next().next()!=null?Ext.get(target).parent().next().next().select("input").focus():null):null);
				 if(target.tagName.toLowerCase()!="input"){
				  if(parseInt(this.activeDate.format("Y-m-d").split("-")[0],10) > 2099){
						 this.update(this.activeDate.add("d",-1));
						 return;
					}
				  if(parseInt(this.activeDate.format("Y-m-d").split("-")[0],10) < 1950){
						 this.update(this.activeDate.add("d",1));
						 return;
					}

				 }
				if(target.tagName.toLowerCase()=="input" && Ext.get(target).parent().next().next()!=null){
					target= Ext.get(target).parent().next().next();
					if(Ext.get(target).hasClass("x-date-hour-td")){
						this.currentTimeType = 0 ;
					}else if(Ext.get(target).hasClass("x-date-minute-td")){
						this.currentTimeType = 1 ;
					}else{
						this.currentTimeType = 2 ;
					}
			    }
			},

			"up" : function(e) {
				if(e.ctrlKey){
					this.showPrevYear();
				}else if(parseInt(this.activeDate.format("Y-m-d").split("-")[0],10) > 2099){
					this.update(this.activeDate.add("d", -7));
					return;
				}else if(parseInt(this.activeDate.format("Y-m-d").split("-")[0],10) < 1950){
					this.update(this.activeDate.add("d", 7));
					return;					
				}else{
					this.update(this.activeDate.add("d", -7));
				}
			},

			"down" : function(e) {
				if(e.ctrlKey){
					this.showNextYear();
				}else if(parseInt(this.activeDate.format("Y-m-d").split("-")[0],10) > 2099){
					this.update(this.activeDate.add("d", -7));
					return;
				}else if(parseInt(this.activeDate.format("Y-m-d").split("-")[0],10) < 1950){
					this.update(this.activeDate.add("d", 7));
					return;					
				}else{
					this.update(this.activeDate.add("d", 7));
				}
			},

			"pageUp" : function(e) {
				this.showNextMonth();
			},

			"pageDown" : function(e) {
				this.showPrevMonth();
			},

			"enter" : function(e) {
				e.stopPropagation();
				return true;
			},

			scope : this
		});

		this.eventEl.on("click", this.handleDateClick, this, {
			delegate : "a.x-date-date"
		});
		this.eventEl.on("dblclick", this.handleDateClick, this, {
			delegate : "a.x-date-date"
		});

		this.eventEl.addKeyListener(Ext.EventObject.SPACE, this.selectToday,
				this);
		if(Ext.isIE)
		{
		   this.el.unselectable();
		}

		this.el.select(".x-date-inner").unselectable();

		this.cells = this.el.select("table.x-date-inner tbody td");
		this.textNodes = this.el.query("table.x-date-inner tbody span");
		if(this.showTime){
		var tdhourel = this.el.child("td.x-date-hour-td");
		tdhourel.appendChild(this.hourel);

		var tdminuteel = this.el.child("td.x-date-minute-td");
		tdminuteel.appendChild(this.minuteel);

		var tdsecondel = this.el.child("td.x-date-second-td");
		tdsecondel.appendChild(this.secondel);
		
		if(!this.inputFormat.match(/[gh]/gi)){
			this.hourel.disabled = "true";
			this.hourel.style.display = "none";
			
		}
		if(!this.inputFormat.match(/[i]/)){
			this.minuteel.disabled = "true";
			this.minuteel.style.display = "none";
			this.minuteel.parentNode.previousSibling.style.display = "none";
		}
		if(!this.inputFormat.match(/[s]/)){
			this.secondel.disabled = "true";
			this.secondel.style.display = "none";
			this.secondel.parentNode.previousSibling.style.display = "none";
		}				
		
		this.eventEl.on("click", this.handleHourClick, this, {
			delegate : "td.x-date-hour-td"
		});
		this.eventEl.on("click", this.handleMinuteClick, this, {
			delegate : "td.x-date-minute-td"
		});
		this.eventEl.on("click", this.handleSecondClick, this, {
			delegate : "td.x-date-second-td"
		});
		this.eventEl.on("keyup", this.handleHourKeyUp, this, {
			delegate : "td.x-date-hour-td"
		});
		this.eventEl.on("keyup", this.handleMinuteKeyUp, this, {
			delegate : "td.x-date-minute-td"
		});
		this.eventEl.on("keyup", this.handleSecondKeyUp, this, {
			delegate : "td.x-date-second-td"
		});

		this.eventEl.on("click", this.handleAddTime, this, {
			delegate : "td.add-time-td"
		});
		this.eventEl.on("click", this.handleDecreaseTime, this, {
			delegate : "td.decrease-time-td"
		});
		this.eventEl.on("click", this.handleStopFocus, this, {
			delegate : "td.x-date-time"
		});
		this.eventEl.on("keyup", this.handleStartFocus, this, {
			delegate : "td.x-date-time"
		});
		}

		this.mbtn = new Ext.Button({
			text : "&#160;",
			renderTo : this.el.child("td.x-date-middle", true)
		});

		this.mbtn.on('click', this.showMonthPicker, this);
		this.mbtn.el.child(this.mbtn.menuClassTarget)
				.addClass("x-btn-with-menu");
				
		var today = (new Date()).dateFormat(this.format);
		var todayBtn = new Ext.Button({
			renderTo : this.el.child(".btn_today_extend", true),
			text : String.format(this.todayText, today),
			handler : this.selectToday,
			scope : this
		});
		
		
		if (Ext.isIE && this.showTime) {

			tdsecondel.select("select").applyStyles({
				visibility : 'visible'
			});
			tdminuteel.select("select").applyStyles({
				visibility : 'visible'
			});
			this.el.repaint();
		}
		this.update(this.value);
	},

	createMonthPicker : function() {
		if (!this.monthPicker.dom.firstChild) {
			var buf = ['<table border="0" cellspacing="0" class="popData">'];
			for (var i = 0; i < 6; i++) {
				buf
						.push(
								'<tr><td class="x-date-mp-month" ><a href="#">',
								this.monthNames[i].substr(0, 3),
								'</a></td>',
								'<td class="x-date-mp-month x-date-mp-sep" ><a href="#">',
								"十一月" == this.monthNames[i + 6].substr(0, 3)
										? "十一"
										: ("十二月" == this.monthNames[i + 6]
												.substr(0, 3)
												? "十二"
												: this.monthNames[i + 6]
														.substr(0, 3)),
								'</a></td>',
								i == 0
										? '<td class="x-date-mp-ybtn" align="center" title="'+this.prevYearText+'"><a class="x-date-mp-prev" ></a></td><td class="x-date-mp-ybtn" align="center" title="'+this.nextYearText+'"><a class="x-date-mp-next" ></a></td></tr>'
										: '<td class="x-date-mp-year"><a href="#"></a></td><td class="x-date-mp-year"><a href="#"></a></td></tr>');
			}
			buf
					.push(
							'<tr class="x-date-mp-btns"><td colspan="2" class="line"><table class="x-btn-wrap x-btn" align="right" cellspacing="0" cellpadding="0" border="0" style="width: 75px;" ><tr><td class="x-btn-left"><i> </i></td><td class="x-btn-center" ><button type="button" class="x-date-mp-ok">',
							this.okText,
							'</button></td><td class="x-btn-right"><i> </i></td></tr></table></td><td  colspan="2" class="line"><table class="x-btn-wrap x-btn" cellspacing="0" cellpadding="0" border="0" style="width: 75px;"  ><tr><td class="x-btn-left"><i> </i></td><td class="x-btn-center"><em unselectable="on"><button type="button" class="x-date-mp-cancel">',
							this.cancelText, 
							'</button></em></td><td class="x-btn-right"><i> </i></td></tr></table></td></tr>', '</table>');
			this.monthPicker.update(buf.join(''));
			this.monthPicker.on('click', this.onMonthClick, this);
			this.monthPicker.on('dblclick', this.onMonthDblClick, this);

			this.mpMonths = this.monthPicker.select('td.x-date-mp-month');
			this.mpYears = this.monthPicker.select('td.x-date-mp-year');

			this.mpMonths.each(function(m, a, i) {
				i += 1;
				if ((i % 2) == 0) {
					m.dom.xmonth = 5 + Math.round(i * .5);
				} else {
					m.dom.xmonth = Math.round((i - 1) * .5);
				}
			});
		}
	},

	showMonthPicker : function() {
		this.createMonthPicker();
		var size = this.el.getSize();
		this.monthPicker.setSize(size);
		this.monthPicker.child('table').setSize(size);

		this.mpSelMonth = (this.activeDate || this.value).getMonth();
		this.updateMPMonth(this.mpSelMonth);
		this.mpSelYear = (this.activeDate || this.value).getFullYear();
		this.updateMPYear(this.mpSelYear);

		this.monthPicker.slideIn('t', {
			duration : .2
		});
	},

	updateMPYear : function(y) {
		this.mpyear = y;
		var loopCount =  10 ; 
		var ys = this.mpYears.elements;
		for (var i = 1; i <= loopCount; i++) {
			var td = ys[i - 1], y2;
			if ((i % 2) == 0) {
				y2 = y + Math.round(i * .5);
			} else {
				y2 = y - (5 - Math.round(i * .5));
			}
			if(y2 < this.minYear || y2 > this.maxYear){
				td.firstChild.style.display = "none";
				td.firstChild.innerHTML = "";
			}else{
				td.firstChild.style.display = "block";
				td.firstChild.innerHTML = y2;
				td.xyear = y2;
			}
			this.mpYears.item(i - 1)[y2 == this.mpSelYear
					? 'addClass'
					: 'removeClass']('x-date-mp-sel');
		}
	},

	updateMPMonth : function(sm) {
		this.mpMonths.each(function(m, a, i) {
			m[m.dom.xmonth == sm ? 'addClass' : 'removeClass']('x-date-mp-sel');
		});
	},

	selectMPMonth : function(m) {

	},

	onMonthClick : function(e, t) {
		e.stopEvent();
		var el = new Ext.Element(t), pn;
		var flagYear  = false;
		var containerPopData = Ext.select(".popData a")
		for(var k = 0 ; k < 10 ; k ++){
			if(!containerPopData.item(k).isVisible()){
				flagYear = true ;
				break;
			}
		}

		if (el.is('button.x-date-mp-cancel')) {
			this.hideMonthPicker();
		} else if (el.is('button.x-date-mp-ok')) {
			this.update(new Date(this.mpSelYear, this.mpSelMonth,
					(this.activeDate || this.value).getDate()));
			this.hideMonthPicker();

		} else if (pn = el.up('td.x-date-mp-month', 2)) {
			this.mpMonths.removeClass('x-date-mp-sel');
			pn.addClass('x-date-mp-sel');
			this.mpSelMonth = pn.dom.xmonth;
		} else if (pn = el.up('td.x-date-mp-year', 2)) {
			this.mpYears.removeClass('x-date-mp-sel');
			pn.addClass('x-date-mp-sel');
			this.mpSelYear = pn.dom.xyear;
		} else if (el.is('a.x-date-mp-prev')) {
			if((this.mpyear < this.minYear+10) && flagYear){
				return ;
			}
			this.updateMPYear(this.mpyear - 10);
		} else if (el.is('a.x-date-mp-next')) {
			if((this.mpyear > this.maxYear-10) && flagYear){
				return ;
			}
			this.updateMPYear(this.mpyear + 10);
		}
	},

	onMonthDblClick : function(e, t) {
		e.stopEvent();
		var el = new Ext.Element(t), pn;
		if (pn = el.up('td.x-date-mp-month', 2)) {
			this.update(new Date(this.mpSelYear, pn.dom.xmonth,
					(this.activeDate || this.value).getDate()));
			this.hideMonthPicker();
		} else if (pn = el.up('td.x-date-mp-year', 2)) {
			this.update(new Date(pn.dom.xyear, this.mpSelMonth,
					(this.activeDate || this.value).getDate()));
			this.hideMonthPicker();
		}
	},

	hideMonthPicker : function(disableAnim) {
		if (this.monthPicker) {
			if (disableAnim === true) {
				this.monthPicker.hide();
			} else {
				this.monthPicker.slideOut('t', {
					duration : .2
				});
			}
		}
	},
	
	formatActiveDate :function(d){
		return d.format("Y-m-d").split("-")[0];
	},
	formatActiveMouth :function(d){
		return d.format("Y-m-d").split("-")[1];
	},
	showPrevMonth : function(e) {
		if(parseInt(this.formatActiveDate(this.activeDate),10) < this.minYear || this.formatActiveMouth(this.activeDate) == 1 && parseInt(this.formatActiveDate(this.activeDate),10) == this.minYear){
			return;
		}	
		this.update(this.activeDate.add("mo", -1));
	},

	showNextMonth : function(e) {
		if(parseInt(this.formatActiveDate(this.activeDate),10) > this.maxYear ||this.formatActiveMouth(this.activeDate) == 12 && parseInt(this.formatActiveDate(this.activeDate),10) == this.maxYear){
			return;
		}
		this.update(this.activeDate.add("mo", 1));
	},

	showPrevYear : function() {
		if(parseInt(this.formatActiveDate(this.activeDate),10) < this.minYear){
			return;
		}
		this.update(this.activeDate.add("y", -1));
	},

	showNextYear : function() {
		if(parseInt(this.formatActiveDate(this.activeDate),10) > this.maxYear){
			return;
		}
		this.update(this.activeDate.add("y", 1));
	},

	handleMouseWheel : function(e) {
		var delta = e.getWheelDelta();
		if (delta > 0) {
			this.showPrevMonth();
			e.stopEvent();
		} else if (delta < 0) {
			this.showNextMonth();
			e.stopEvent();
		}
	},
	handleStopFocus : function(e, t) {
		this.timeFocusFlag = true;
		e.stopEvent();
	},
	handleStartFocus : function(e, t) {
		var keyCode = e.getKey();
		if (Ext.EventObject.LEFT == keyCode || Ext.EventObject.RIGHT == keyCode || Ext.EventObject.UP == keyCode || Ext.EventObject.DOWN == keyCode	|| Ext.EventObject.PAGEUP == keyCode || Ext.EventObject.PAGEDOWN == keyCode) {
			this.timeFocusFlag = false;

		}
	},

	handleHourClick : function(e, t) {
		this.currentTimeType = 0;

		this.getEl().select("td.x-date-hour-td").item(0).first().focus();
		this.getEl().select("td.x-date-minute-td").item(0).first().dom.style.backgroundColor = "";
		this.getEl().select("td.x-date-second-td").item(0).first().dom.style.backgroundColor = "";
		
	},
	handleMinuteClick : function(e, t) {
		this.currentTimeType = 1;
		this.getEl().select("td.x-date-hour-td").item(0).first().dom.style.backgroundColor = "";

		this.getEl().select("td.x-date-minute-td").item(0).first().focus();
		this.getEl().select("td.x-date-second-td").item(0).first().dom.style.backgroundColor = "";
	},
	handleSecondClick : function(e, t) {
		this.currentTimeType = 2;
		this.getEl().select("td.x-date-hour-td").item(0).first().dom.style.backgroundColor = "";
		this.getEl().select("td.x-date-minute-td").item(0).first().dom.style.backgroundColor = "";

		this.getEl().select("td.x-date-second-td").item(0).first().focus();
	},
	handleHourKeyUp : function(e, t) {
		var current = t.firstChild.value * 1.0;
		if (isNaN(current) || current < 0 || current > 23)
			t.firstChild.value = "00";		
	},
	handleMinuteKeyUp : function(e, t) {
		var current = t.firstChild.value * 1.0;
		if (isNaN(current) || current < 0 || current > 59)
			t.firstChild.value = "00";
	},
	handleSecondKeyUp : function(e, t) {
		var current = t.firstChild.value * 1.0;
		if (isNaN(current) || current < 0 || current > 59)
			t.firstChild.value = "00";
	},
	handleAddTime : function(e, t) {
		var element, current;
		if (2 == this.currentTimeType) {
			element = this.getEl().select("td.x-date-second-td").item(0)
					.first();
			current = element.dom.value * 1.0;
			current = isNaN(current) ? 0 : current;
			if (current >= 59)
				element.dom.value = "00";
			else
				element.dom.value = ++current < 10 ? ("0" + current) : current;
		} else if (1 == this.currentTimeType) {
			element = this.getEl().select("td.x-date-minute-td").item(0)
					.first();
			current = element.dom.value * 1.0;
			current = isNaN(current) ? 0 : current;
			if (current >= 59)
				element.dom.value = "00";
			else
				element.dom.value = ++current < 10 ? ("0" + current) : current;
		} else {
			element = this.getEl().select("td.x-date-hour-td").item(0).first();
			current = element.dom.value * 1.0;
			current = isNaN(current) ? 0 : current;
			if (current >= 23)
				element.dom.value = "00";
			else
				element.dom.value = ++current < 10 ? ("0" + current) : current;
		}
	},
	handleDecreaseTime : function(e, t) {
		var element, current;
		if (2 == this.currentTimeType) {
			element = this.getEl().select("td.x-date-second-td").item(0)
					.first();
			current = element.dom.value * 1.0;
			current = isNaN(current) ? 0 : current;
			if (current <= 0)
				element.dom.value = "59";
			else
				element.dom.value = --current < 10 ? ("0" + current) : current;
		} else if (1 == this.currentTimeType) {
			element = this.getEl().select("td.x-date-minute-td").item(0)
					.first();
			current = element.dom.value * 1.0;
			current = isNaN(current) ? 0 : current;
			if (current <= 0)
				element.dom.value = "59";
			else
				element.dom.value = --current < 10 ? ("0" + current) : current;
		} else {
			element = this.getEl().select("td.x-date-hour-td").item(0).first();
			current = element.dom.value * 1.0;
			current = isNaN(current) ? 0 : current;
			if (current <= 0)
				element.dom.value = "23";
			else
				element.dom.value = --current < 10 ? ("0" + current) : current;
		}
	},

	handleDateClick : function(e, t) {

		e.stopEvent();
		if(e.type=='click'){
			if (t.dateValue && !Ext.fly(t.parentNode).hasClass("x-date-disabled")) {
				var dt = new Date(t.dateValue);
				var reg = /^\d{1,2}$/;
				if(!reg.test(this.hourel.value)){
					this.hourel.value =  new Date().getHours();
					return ;
				}
				if(!reg.test(this.minuteel.value)){
					this.minuteel.value = new Date().getMinutes();
					return;
				}
				if(!reg.test(this.secondel.value)){
					this.secondel.value = new Date().getSeconds();
					return ;
				}
				dt.setHours(this.hourel.value);
				dt.setMinutes(this.minuteel.value);
				dt.setSeconds(this.secondel.value);
				var yearString = dt.getFullYear();
				if(yearString > this.maxYear || yearString < this.minYear){
					return;
				}
				this.setValue(dt);

			}
		}else{
			if (t.dateValue && !Ext.fly(t.parentNode).hasClass("x-date-disabled")) {
				var dt = new Date(t.dateValue);
				var reg = /^\d{1,2}$/;
				if(!reg.test(this.hourel.value)){
					this.hourel.value =  new Date().getHours();
					return ;
				}
				if(!reg.test(this.minuteel.value)){
					this.minuteel.value = new Date().getMinutes();
					return;
				}
				if(!reg.test(this.secondel.value)){
					this.secondel.value = new Date().getSeconds();
					return ;
				}
				dt.setHours(this.hourel.value);
				dt.setMinutes(this.minuteel.value);
				dt.setSeconds(this.secondel.value);
				var yearString = dt.getFullYear();
				if(yearString > this.maxYear || yearString < this.minYear){
					return;
				}
				this.setValue(dt);
			}
			this.fireEvent("select", this, this.value);
		}
	},

	selectToday : function() {
		var reg = /^\d{1,2}$/;
		if(!reg.test(this.hourel.value)){
			this.hourel.value =  new Date().getHours();
			return ;
		}
		if(!reg.test(this.minuteel.value)){
			this.minuteel.value = new Date().getMinutes();
			return;
		}
		if(!reg.test(this.secondel.value)){
			this.secondel.value = new Date().getSeconds();
			return ;
		}
		this.value.setHours(this.hourel.value);
		this.value.setMinutes(this.minuteel.value);
		this.value.setSeconds(this.secondel.value);
		this.fireEvent("select", this, this.value);
	},
    clearDate : function() {
		this.fireEvent("select", this, this.value);
		LegoTag.clearDate();
	}, 
	update : function(date) {
		var vd = this.activeDate;
		this.activeDate = date;
		if (vd && this.el) {
			var t = new Date(date).clearTime().getTime();
			if (vd.getMonth() == date.getMonth()
					&& vd.getFullYear() == date.getFullYear()) {
				this.cells.removeClass("x-date-selected");
				this.cells.each(function(c) {
					if (c.dom.firstChild.dateValue == t) {
						c.addClass("x-date-selected");
						setTimeout(function() {
							try {
								c.dom.firstChild.focus();
							} catch (e) {
							}
						}, 50);
						return false;
					}
				});
				return;
			}
		}
		var days = date.getDaysInMonth();
		var firstOfMonth = date.getFirstDateOfMonth();
		var startingPos = firstOfMonth.getDay() - this.startDay;

		if (startingPos <= this.startDay) {
			startingPos += 7;
		}

		var pm = date.add("mo", -1);
		var prevStart = pm.getDaysInMonth() - startingPos;

		var cells = this.cells.elements;
		var textEls = this.textNodes;
		days += startingPos;

		var day = 86400000;
		var d = (new Date(pm.getFullYear(), pm.getMonth(), prevStart))
				.clearTime();
		var today = new Date().getTime();
		var tToday = new Date().clearTime().getTime();
		var sel = date.getTime();
		var tSel = new Date(date).clearTime().getTime();
		var min = this.minDate ? this.minDate : Number.NEGATIVE_INFINITY;
		var max = this.maxDate ? this.maxDate : Number.POSITIVE_INFINITY;
		var ddMatch = this.disabledDatesRE;
		var ddText = this.disabledDatesText;
		var ddays = this.disabledDays ? this.disabledDays.join("") : false;
		var ddaysText = this.disabledDaysText;
		var format = this.format;

		var setCellClass = function(cal, cell) {

			var t = d.getTime();
			cell.firstChild.dateValue = t;

			if (t == tToday) {
				cell.className += " x-date-today";

			}
			if (t == tSel) {
				cell.className += " x-date-selected";
				setTimeout(function() {
					try {
						cell.firstChild.focus();
					} catch (e) {
					}
				}, 50);
			}
		};

		var i = 0;
		for (; i < startingPos; i++) {
			textEls[i].innerHTML = (++prevStart);
			d.setDate(d.getDate() + 1);
			cells[i].className = "x-date-prevday";
			setCellClass(this, cells[i]);
			cells[0].className ="weekEnd";
		}
		for (; i < days; i++) {
			intDay = i - startingPos + 1;
			textEls[i].innerHTML = (intDay);
			d.setDate(d.getDate() + 1);
			cells[i].className = "x-date-active";
			setCellClass(this, cells[i]);
			if(i%7==0){
				cells[i].className ="weekEnd";
			}
		}
		var extraDays = 0;
		for (; i < 42; i++) {
			textEls[i].innerHTML = (++extraDays);
			d.setDate(d.getDate() + 1);
			cells[i].className = "x-date-nextday";
			setCellClass(this, cells[i]);
			if(i%7==0){
				cells[i].className ="weekEnd";
			}
		}

		this.mbtn.setText(this.monthNames[date.getMonth()] + " "
				+ date.getFullYear());

		if (!this.internalRender) {
			var main = this.el.dom.firstChild;
			var w = main.offsetWidth;
			this.el.setWidth(w + this.el.getBorderWidth("lr"));
			Ext.fly(main).setWidth(w);
			this.internalRender = true;

			if (Ext.isOpera && !this.secondPass) {
				main.rows[0].cells[1].style.width = (w - (main.rows[0].cells[0].offsetWidth + main.rows[0].cells[2].offsetWidth))
						+ "px";
				this.secondPass = true;
				this.update.defer(10, this, [date]);
			}
		}
		
	}
	
});
Ext.reg('datetimepicker', Ext.DateTimePicker);
