PageToolBarText = {
	pageGo : "Go",
	emptyMsg : 'No data to display',
	displayMsg : 'Displaying {0} - {1} of {2}',
	beforePageText : "Page",
	afterPageText : "of {0}",
	pageSizeFirst: '',
	pageSizeLast:  'Records'
}
var TAG_COMB_ITEMS_HEIGHT = 15;
var asynGrid = [];
var synGrids=[];
var tableGrids=[];
Ext.onReady(function() {
	var StarTime = new Date();
	initExtTag();
});
function delSynGItem(grid){
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var selItems = grid.select('.x-grid3-row-selected');
 	for(var i=0,count=selItems.getCount();i<count;i++){
		var item=selItems.item(i);
		item.remove();
 	}
 	setGridSelecteds(grid);
}
function cancelSelGridItemForIndex(grid,index){
	if (index.indexOf("-") != -1) {
		return;
	}
	index = index.split(",");
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var items = grid.select('.x-grid3-row');
	for(var i=0; i<items.getCount(); i++) {
		if(index.indexOf(i+"") != -1){
			items.item(i).removeClass("x-grid3-row-selected");
		}
	}
}
function selGridItemForIndex(grid,index){
	if (index.indexOf("-") != -1) {
		return;
	}
	index = index.split(",");
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var items = grid.select('.x-grid3-row');
	for(var i=0; i<items.getCount(); i++) {
		if(index.indexOf(i+"") != -1){
			items.item(i).addClass("x-grid3-row-selected");
		}
	}
}
function cancelSelGridItemForObj(grid,conditions){
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var condStr = "";
	for(con in conditions){
		condStr += "div[header="+con+"][value="+conditions[con]+"]" +","
	}
	if(condStr){
		condStr = condStr.substring(0,condStr.length-1);
	}
	var items = grid.select('.x-grid3-row');
	for(var i=0; i<items.getCount(); i++) {
		var cellItem = items.item(i).child(condStr);
		if(cellItem){
			items.item(i).removeClass("x-grid3-row-selected");
		}
	}
}
function selGridItemForObj(grid,conditions){
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var condStr = "";
	for(con in conditions){
		condStr += "div[header="+con+"][value="+conditions[con]+"]" +","
	}
	if(condStr){
		condStr = condStr.substring(0,condStr.length-1);
	}
	var items = grid.select('.x-grid3-row');
	for(var i=0; i<items.getCount(); i++) {
		var cellItem = items.item(i).child(condStr);
		if(cellItem){
			items.item(i).addClass("x-grid3-row-selected");
		}
	}
}
function delGridItemForObj(grid,conditions,isAllRemove){
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var condStr = "";
	for(con in conditions){
		condStr += "div[header="+con+"][value="+conditions[con]+"]" +","
	}
	if(condStr){
		condStr = condStr.substring(0,condStr.length-1);
	}
	var items = grid.select('.x-grid3-row');
	for(var i=0; i<items.getCount(); i++) {
		var cellItem = items.item(i).child(condStr);
		if(cellItem){
			items.item(i).remove();
			if (!isAllRemove) {
				break;
			}
		}
	}
}
function delGridItemForObjAnd(grid,conditions,isAllRemove){
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var items = grid.select('.x-grid3-row');
	for(var i=0; i<items.getCount(); i++) {
		var isChild;
		for(con in conditions){
			var matchStr = "div[header="+con+"][value="+conditions[con]+"]";
			isChild = items.item(i).child(matchStr);
			if (!isChild) {
				break;
			}
		}
		if (!isChild) {
			continue;
		}
		items.item(i).remove();
		if (!isAllRemove) {
			return;
		}
	}
}
function delGridItemForIndex(grid,index){
	if (index.indexOf("-") != -1) {
		return;
	}
	index = index.split(",");
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var items = grid.select('.x-grid3-row');
	for(var i=0; i<items.getCount(); i++) {
		if(index.indexOf(i+"") != -1){
			items.item(i).remove();
		}
	}
}
function delAllGridItem(grid){
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var items = grid.select('.x-grid3-row');
	for(var i=0; i<items.getCount(); i++) {
		items.item(i).remove();
	}
}
function refreshGridForList(grid,listJson){
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	if(typeof(listJson) == "string"){
		listJson = eval(listJson);
	}
	delAllGridItem(grid);
	var item = grid.child(".x-grid3-body");
	var gridWidth = item.dom.getAttribute("gridWidth");
	var headStr = item.dom.getAttribute("headers").replace(/[\n\t\r]/g,"");
	var headers = eval(headStr);
	for(var i=0; i<listJson.length; i++) {
		addSynGItem(grid,listJson[i])
	}
}
function updateGridItemForObj(grid,conditions,o){
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var condStr = "";
	for(con in conditions){
		condStr += "div[header="+con+"][value="+conditions[con]+"]" +","
	}
	if(condStr){
		condStr = condStr.substring(0,condStr.length-1);
	}
	var items = grid.select('.x-grid3-row');
	for(var i=0; i<items.getCount(); i++) {
		var cellItem = items.item(i).child(condStr);
		if(cellItem){
			var item = grid.child(".x-grid3-body");
			var gridWidth = item.dom.getAttribute("gridWidth");
			var headStr = item.dom.getAttribute("headers").replace(/[\n\t\r]/g,"");
			var headers = eval(headStr);
			var trItem = items.item(i);
			var tdItems = trItem.select("td");
			
			for(j=0;j<headers.length;j++){
				var tdIndex = j+1;
				var header = headers[j];
				var headerName = header.name?header.name:'';
				var tdItem = tdItems.item(tdIndex);
				var tdInner = tdItem.first();
				var orgiValue = tdInner.dom.getAttribute("value");
				var currValue;
				if (o.get) {
					currValue = o.get(header.name)
				} else {
					currValue = o[header.name]
				}
				if (currValue == null || currValue == undefined) {
					currValue = orgiValue;
				}
				var cellValue;
				if (header.allValue) {
					var allValue = header.allValue.split(";;");
					var templates = header.templates.split(";;");
					cellValue = currValue;
					for(var k=0; k<allValue.length; k++) {
						var val = allValue[k];
						if (val == currValue+"") {
							cellValue = templates[k];
							cellValue = cellValue.replace(/\{value\}/g,currValue);
						}
					}
				}else if(header.template){
					cellValue = header.template;
					cellValue = cellValue.replace(/\{value\}/g,currValue);
				}else{
					cellValue = currValue;
				}
				if (header.paras) {
					var paras = header.paras.split(";");
					for(var k=0; k<paras.length; k++) {
						
						var regex1 = eval("/\\{"+k+"\\}/g");
						var parasValue;
						if (o.get) {
							parasValue = o.get(paras[k]);
						} else {
							parasValue = o[paras[k]]
						}
						cellValue = cellValue.replace(regex1,parasValue);
					}
				}
				if(header.alt){
					tdInner.dom.setAttribute("qtip",cellValue);
				}
				tdInner.dom.setAttribute("value",currValue);
				tdInner.update(cellValue);
			}
			break;
		}
	}
}
function gridAlignItem(grid){
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var scrollEl = grid.child(".x-grid3-scroller");
	var headerOffset = grid.child(".x-grid3-header-offset");
	var flag = scrollEl.isScrollable();
	if(flag && headerOffset.dom.style.width=="100%"){
		var styleStr = Ext.isIE?"margin-right":"overflow-y";
		var valueStr = Ext.isIE?"18px":"scroll";
		
	}else{
		var styleStr = Ext.isIE?"margin-right":"overflow-y";
		var valueStr = Ext.isIE?"":"auto";
	}
	headerOffset.setStyle(styleStr,valueStr);
}
function addSynGItem(grid,o){
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	
	var item = grid.child(".x-grid3-body");
	var bodyItem = grid.child(".x-grid3-row-table");
	var tbodyItem = bodyItem.first();
	if(!tbodyItem){
		tbodyItem = bodyItem.createChild({tag:'tbody'});
	}
	var firstTr;
	if(Ext.isIE && !tbodyItem.first()){
		firstTr = document.createElement("tr");
		tbodyItem.dom.appendChild(firstTr);
	}
	var gridWidth = item.dom.getAttribute("gridWidth");
	var headStr = item.dom.getAttribute("headers").replace(/[\n\t\r]/g,"");
	var headers = eval(headStr);
	var bodyTabWidth = '';
	var htLen = headers.length
	for (var indexHt = 0; indexHt < htLen; indexHt++) {
		if (headers[indexHt].hidden) {
			htLen--;
		}
	}
	var htPara = htLen<8?8:htLen;
	if(gridWidth){
		bodyTabWidth = 'width: '+parseInt(gridWidth)*(htPara/8) + 'px;';
	}else{
		bodyTabWidth = 'width: 100%;';
	}
	var trItem = tbodyItem.createChild({tag:'tr',cls:'x-grid3-row'
		,style:bodyTabWidth,onmouseover:'gridSynOver(this,event)'
		,onmousedown:'gridSynDown(this,event)',onmouseout:'gridSynOut(this,event)',onclick:'gridSynClick(this,event,\''+grid.dom.id+'\')'
		,html:'<td></td>'});
	var ckItem = trItem.createChild({tag:'td',tabindex:0,width:20
		,cls:'x-grid3-col x-grid3-cell x-grid3-td-checker x-grid3-cell-first'
		,onmousedown:'gridCheckSelect(this,event)'
		,html:'<div class="x-grid3-cell-inner x-grid3-col-checker">' +
				'<div class="x-grid3-row-checker">&#160;</div></div>'});
	ckItem.setStyle('display','none');
	var selectMode = grid.dom.getAttribute("selectMode");
	if(selectMode){
		ckItem.setStyle('display','');
	}
	for(j=0;j<headers.length;j++){
		var header = headers[j];
		var headerName = header.name?header.name:'';
		var currValue;
		if (o.get) {
			currValue = o.get(header.name)
		} else {
			currValue = o[header.name]
		}
		var cellValue;
		if (header.allValue) {
			var allValue = header.allValue.split(";;");
			var templates = header.templates.split(";;");
			cellValue = currValue;
			for(var k=0; k<allValue.length; k++) {
				var val = allValue[k];
				if (val == currValue+"") {
					cellValue = templates[k];
					cellValue = cellValue.replace(/\{value\}/g,currValue);
					cellValue = cellValue.replace(/`/g,"'");
				}
			}
		}else if(header.template){
			cellValue = header.template;
			cellValue = cellValue.replace(/\{value\}/g,currValue);
			cellValue = cellValue.replace(/`/g,"'");
		}else{
			cellValue = currValue;
		}
		if (header.paras) {
			var paras = header.paras.split(";");
			for(var k=0; k<paras.length; k++) {
				
				var regex1 = eval("/\\{"+k+"\\}/g");
				var parasValue;
				if (o.get) {
					parasValue = o.get(paras[k]);
				} else {
					parasValue = o[paras[k]]
				}
				cellValue = cellValue.replace(regex1,parasValue);
			}
		} 
		var tdHtml = '<div class="x-grid3-cell-inner x-grid3-record" header="'+headerName+'" value="'+currValue+'"';
		if(header.alt){
			tdHtml += ' title=\''+ currValue +'\'';
		}
		tdHtml += '>'+ cellValue +'</div>';
		var display = 'display:'+header.hidden?'none':'none';
		var tdItem = trItem.createChild({tag:'td',tabindex:0,width:header.width,style:'display:'+(header.hidden?'none':'')
			,cls:'x-grid3-col x-grid3-cell x-grid3-td-'+j+' x-grid3-cell-first'
			,html:tdHtml});
	}
	trItem.first().remove();
	if (firstTr) {
		tbodyItem.dom.removeChild(firstTr);
	}
}
function initExtTag(){
	if(Ext.isIE && document.body.firstChild && document.body.firstChild.nodeName == "#text")
	{
		var firstEl = Ext.getBody().first();
		if (firstEl) {
			firstEl.insertHtml("beforeBegin","<label></label>");
		}else{
			Ext.getBody().createChild({tag:"label"})
		}
		
	}
	Ext.QuickTips.init();
	Ext.EventManager.onWindowResize(winResize);
	if(asynGrid.length>0){
		initGridpanel(asynGrid);
	}
	winResize();
}
function winResize(x,y){
	setFitSize(synGrids,'.x-grid3-scroller',".x-page-toolbar-syn");
	setFitSize(tableGrids,'.x-grid3-body',".x-page-toolbar-table",true);
}
function setFitSize(grids,bodyCls,pageCls){
	for(var j=0;j<grids.length;j++){
		var gridBody=Ext.get(grids[j]).child(bodyCls);
		gridBody.prev().first().dom.scrollLeft=gridBody.dom.scrollLeft;
		var grid_El = Ext.get(grids[j]);
		var gridPage = grid_El.parent().child(pageCls);
		var parentWidth;
		if (gridBody.dom.noHeight || !gridBody.dom.style.height){
			var sizes = getFitHeight(grid_El,bodyCls);
			var bodyHeight = sizes[0];
			parentWidth = sizes[1];
			var page = grid_El.child(pageCls);
			if (page) {
				bodyHeight -= 2;
				bodyHeight -= page.getHeight();
				if (page.first().dom.style.borderBottomWidth=="") {
					bodyHeight -= 2;
				}
			}
			gridBody.setHeight(bodyHeight);
			gridBody.dom.noHeight = true;
		}
	}
}
function getFitHeight(grid,bodyCls){
 	var parentObj = grid.parent(".x-real-panel") || grid.parent(".x-tab-panel") || grid.parent(".x-formpanel") || grid.parent(".x-fieldset");
	var para = 0;
	
	var gridBrother = grid.parent().first();
	while(gridBrother){
		if (gridBrother != grid && gridBrother.dom.tagName.toLowerCase() != "script") {
			para += gridBrother.getHeight();
		}
		gridBrother = gridBrother.next();
	}
	var bodyEl = grid.child(bodyCls);
	var bodyBrother = bodyEl.parent().first();
	while(bodyBrother){
		if (bodyBrother != bodyEl) {
			para += bodyBrother.getHeight();
		}
		bodyBrother = bodyBrother.next();
	}
	if (parentObj) {
		if (parentObj.hasClass("x-tab-panel")) {
 			var titleHeight = parentObj.child(".x-tab-panel-header").dom.clientHeight;
			heightPara += titleHeight+1;
 		} else if(parentObj.hasClass("x-formpanel")){
 			heightPara += (Ext.isIE?53:34);
 		} else if(parentObj.hasClass("x-panel") && parentObj.child(".x-panel-header-text")){
 			var titleHeight = parentObj.child(".x-panel-header").dom.clientHeight;
 			heightPara += titleHeight+1;
 		} else if(parentObj.hasClass("x-fieldset")){
 			heightPara += 23;
 		}
	}else{
		parentObj = grid.parent();
	}
	parentObj.setStyle("overflow-y","hidden");
	var parentHeight = parentObj.dom.clientHeight;
	return [parentHeight-para,parentObj.getWidth()];
 }
function getHeiPara(grid){
 	var parentObj = grid.parent(".x-tab-panel") || grid.parent(".x-formpanel") || grid.parent(".x-real-panel") || grid.parent(".x-fieldset");
 	var gTHeight = 0;
	var heightPara = 26;
	if(grid.prev() && grid.prev().hasClass("x-bar-toolbar")){
		var toolHeight = 26;
		gTHeight +=toolHeight;
	}
	var pgEl = Ext.get("ptb_" + grid.dom.id);
	if(pgEl){
		var pgHeight = 26;
		gTHeight +=pgHeight;
	}
	
	if (parentObj) {
		if (parentObj.hasClass("x-tab-panel")) {
 			var titleHeight = parentObj.child(".x-tab-panel-header").dom.clientHeight;
			heightPara += titleHeight+1;
 		} else if(parentObj.hasClass("x-formpanel")){
 			heightPara += (Ext.isIE?53:34);
 		} else if(parentObj.hasClass("x-panel") && parentObj.child(".x-panel-header-text")){
 			var titleHeight = parentObj.child(".x-panel-header").dom.clientHeight;
 			heightPara += titleHeight+1;
 		} else if(parentObj.hasClass("x-fieldset")){
 			heightPara += 23;
 		}
	}else{
		parentObj = grid.parent();
	}
	parentObj.setStyle("overflow","hidden");
	gTHeight += heightPara;
	return parentObj.dom.clientHeight-gTHeight;
 }
function setDisabled(target,disabled){
	if(typeof(target) == 'string'){
		target = Ext.get(target);
	}
	var t= target;
	if(t.hasClass("x-btn")){
		setBtnDisabled(t,disabled);
		return;
	}
	if(t.hasClass("x-combobox")){
		setCombDisabled(t,disabled);
		return;
	}
	
	var prevTaget=t.prev();
	var nextTaget=t.next();
	var parentTaget = t.parent();
	if(disabled){
		t.dom.disabled = "disabled";
		t.addClass("x-item-disabled");
		if(t.dom.type=="checkbox"||t.dom.type=="radio"){
			parentTaget.addClass("x-item-disabled");
			prevTaget.addClass("x-item-disabled")
			parentTaget = parentTaget.parent();
			parentTaget.addClass("x-item-disabled");
		}else if(t.dom.type=="text"||t.dom.type=="textarea"){
			clearInvalid(t);
		}
	}else{
		t.dom.disabled = "";
		t.removeClass("x-item-disabled");
		if(t.dom.type=="checkbox"||t.dom.type=="radio"){
			parentTaget.removeClass("x-item-disabled");
			prevTaget.removeClass("x-item-disabled")
			parentTaget = parentTaget.parent();
			parentTaget.removeClass("x-item-disabled");
		}else if(t.dom.type=="text"||t.dom.type=="textarea"){
			validEvent(t);
		}	
	}
}
function setCombDisabled(comb,disabled){
	if ((typeof(comb) == "string")) {
 		comb = Ext.get(comb);
 	}
 	if (disabled) {
 		comb.addClass("x-item-disabled");
 		comb.dom.disabled = "disabled";
 		comb.prev().dom.disabled = "disabled";
 		comb.next().addClass("x-item-disabled");
 		comb.parent().addClass("x-item-disabled");
 		clearInvalid(comb);
 	} else {
 		comb.removeClass("x-item-disabled");
 		comb.dom.disabled = "";
 		comb.prev().dom.disabled = "";
 		comb.next().removeClass("x-item-disabled");
 		comb.parent().removeClass("x-item-disabled");
 	}
}
function setBtnDisabled(btn,disabled){
 	if ((typeof(btn) == "string")) {
 		btn = Ext.get(btn);
 	}
 	if (disabled) {
 		btn.addClass("x-item-disabled");
 		btn.child(".x-btn-text").dom.disabled = "disabled";
 		btn.removeClass("x-btn-over");
 		if (Ext.isIE) {
 			btn.dom.disabled = "disabled";
 			return;
 		}
 		btn.dom.setAttribute("onclick","if(!Ext.isIE)return false;"+btn.dom.getAttribute("onclick"));
 		
 	} else {
 		btn.removeClass("x-item-disabled");
 		btn.child(".x-btn-text").dom.disabled = "";
 		if (Ext.isIE) {
 			btn.dom.disabled = "";
 			return;
 		}
 		var onclickStr = btn.dom.getAttribute("onclick");
 		if(onclickStr.indexOf("if(!Ext.isIE)return false;") != -1){
 			onclickStr = onclickStr.replace(/if\(\!Ext\.isIE\)return false;/g,"");
 			btn.dom.setAttribute("onclick",onclickStr)
 		}
 	}
 }
function setDisableds(targets,disabled){
	for(var i=0;i<targets.length;i++){
		var target = targets[i];
		setDisabled(target,disabled)
	}
}	
function refreshCheckState(scope){
	if(!scope){
		scope = Ext.getBody();
	}
	if (typeof(scope) == "string") {
		scope = Ext.get(scope);
	}
	var element=scope.select(".x-form-checkbox,.x-radiogroup-radio");
	for(var i=0,count=element.getCount();i<count;i++){
		var item=element.item(i);
		var parentTaget = item.findParent(".x-form-check-wrap",null,true);
		var childDivClass = '.x-form-check-wrap-inner';
		var childImgClass = '.x-form-check';
		var childInputClass = '.x-form-checkbox';
		if(!parentTaget){
			parentTaget = item.findParent(".x-form-radio-wrap",null,true);
			var childDivClass = '.x-form-radio-wrap-inner';
			var childImgClass = '.x-radiogroup-img';
			var childInputClass = '.x-radiogroup-radio';
		}
		if(item.dom.checked){
			parentTaget.addClass("x-form-check-checked");
			
		}else{
			parentTaget.removeClass("x-form-check-checked");
		}
	}
}
function validationForm(form){
	
	if (typeof(form) == "string") {
		form = Ext.get(form);
	}
	return validationText(form);
}
function validationText(form){
	var isValid = true;
	if(!form){
		form = Ext.getBody();
	}
	var elements = form.select('input[allowBlank=allowBlank],textarea[allowBlank=allowBlank]' +
			',input[regex],textarea[regex],input[minValue],input[maxValue],input[validator]');
	for(var i=0; i<elements.getCount(); i++) {
		var item=elements.item(i);
		var validTxt = validEvent(item);
		isValid = isValid && validTxt;
	}
	return isValid;
}

function validRegex(txt) {
	if(!txt){
		return true;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return true;
 	}
 	var txtValue = txtEl.getValue();
 	var txtRegex = eval(txtEl.dom.getAttribute("regex"));
 	var flag = txtValue && !txtRegex.test(txtValue);
 	var errorDesc = txtEl.dom.getAttribute("regexText")?txtEl.dom.getAttribute("regexText"):"The value in this field is invalid";
 	return exeValid(flag,txtEl,errorDesc)
 }
function numTxtBlur(src,ev){
	if(isNaN(src.value)){
 		src.value = "";
 		return;
 	}
 	if (src.value) {
	 	src.value=parseFloat(src.value);
 	}
}
function validNumber(txt) {
	if(!txt){
		return true;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return true;
 	}
 	var txtValue = txtEl.getValue();
 	var minValue = parseFloat(txtEl.dom.getAttribute("minValue"));
 	var maxValue = parseFloat(txtEl.dom.getAttribute("maxValue"));
 	var isValid = true;
 	var errorDesc = "";
 	if (!isNaN(txtEl.dom.getAttribute("minValue")) && minValue > parseFloat(txtValue)) {
 		isValid = false;
 		errorDesc += "The mininum value for this field is " + minValue +";";
 	}
 	if (!isNaN(txtEl.dom.getAttribute("maxValue")) && maxValue < parseFloat(txtValue)) {
 		isValid = false;
 		errorDesc += "The maxinum value for this field is " + maxValue +";";
 	}
 	errorDesc = txtEl.dom.getAttribute("numErrText")?txtEl.dom.getAttribute("numErrText"):errorDesc;
 	var flag = txtValue && !isValid;
 	return exeValid(flag,txtEl,errorDesc);
 }
function validAreaLen(txt) {
	if(!txt){
		return true;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return true;
 	}
 	var txtValue = txtEl.getValue();
 	var maxlength = parseInt(txtEl.dom.getAttribute("maxlengthExt"));
 	var isValid = true;
 	var errorDesc = "";
 	if (maxlength && maxlength>0 && maxlength<txtValue.length) {
 		isValid = false;
 		errorDesc += "The maxinum length for this field is " + maxlength +";";
 	}
 	errorDesc = txtEl.dom.getAttribute("maxLenErrTxt")?txtEl.dom.getAttribute("maxLenErrTxt"):errorDesc;
 	var flag = txtValue && !isValid;
 	return exeValid(flag,txtEl,errorDesc);
 }
function exeValid(flag,txtEl,errorDesc){
 	if(flag){
 		txtEl.addClass("x-form-invalid");
 		if (txtEl.dom.getAttribute("validField")) {
 			var txtLabel = document.getElementById(txtEl.dom.id + "_label");
 			var txtLabelStr = (txtLabel?txtLabel.innerHTML.replace(/:/g,""):"");
 			if(errorDesc.indexOf("{0}") != -1){
 				errorDesc = errorDesc.replace(/\{0\}/g,txtLabelStr);
 			}else{
	 			errorDesc = txtLabelStr + errorDesc;
 			}
 		}
 		if (txtEl.dom.getAttribute("qtipMode")) {
 			txtEl.dom.qtip = errorDesc;
 			txtEl.dom.qclass = 'x-form-invalid-tip';
 			return false;
 		}
		var errorIcon = Ext.get(txtEl.dom.id+"_valid");
 		if(!errorIcon){
			errorIcon = txtEl.parent().createChild({cls:'x-form-invalid-icon',id: txtEl.dom.id+"_valid"});
 		}
 		errorIcon.alignTo(txtEl.hasClass("x-comboarrow")?txtEl.next():txtEl, 'tl-tr', [2, 0]);
 		errorIcon.dom.qtip = errorDesc;
 		errorIcon.dom.qclass = 'x-form-invalid-tip';
 		errorIcon.show();
 		return false;
 	}else{
 		txtEl.removeClass("x-form-invalid");
 		if (txtEl.dom.getAttribute("qtipMode")) {
 			txtEl.dom.qtip = "";
 			txtEl.dom.qclass = "";
 			return true;
 		}
 		var errorIcon = Ext.get(txtEl.dom.id+"_valid");
 		if(errorIcon){
	 		errorIcon.dom.qtip = "";
	 		errorIcon.hide();
 		}
 		return true;
 	}
}
function clearInvalid(el){
	var ele = el;
	if (typeof(ele) == "string") {
		ele = Ext.get(el);
	}
	var errorIcon =  Ext.get(ele.dom.id+"_valid");
	if(ele){
		ele.dom.qtip="";
		ele.removeClass("x-form-invalid")
	}
	if(errorIcon){
		errorIcon.remove();
	}
}
function validEvent(src,ev){
	var target = Ext.fly(src);
	if (target.dom.getAttribute("allowBlank")) {
		if (!validBlank(target)) {
			return false
		}
	}
	if (target.dom.getAttribute("regex")) {
		if (!validRegex(target)) {
			return false;
		}
	}
	if (target.dom.getAttribute("maxlenExtMode") && target.dom.getAttribute("maxlengthExt")) {
		if (!validAreaLen(target)) {
			return false;
		}
	}
	if (target.dom.getAttribute("validator")) {
		var validator = target.dom.getAttribute("validator");
		validator = validator.replace(/\(.*\)/g,"");
		var validMsg = eval(validator+".call(this,target.dom)");
		var flag = (typeof(validMsg) == "string");
		exeValid(flag,target,validMsg);
		if (flag) {
			return false;
		}
	}
	if (target.dom.getAttribute("minValue") || target.dom.getAttribute("maxValue")) {
		if (!validNumber(target)) {
			return false;
		}
	}
	return true;
}
function validBlank(txt) {
	if(!txt){
		return true;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return true;
 	}
 	var txtValue = txtEl.getValue().replace(/^\s+|\s+$/g,"");
 	var flag = (txtValue.length == 0 && txtEl.isVisible(true));
 	var errorDesc = txtEl.dom.getAttribute("blankText")?txtEl.dom.getAttribute("blankText"):"This field is required";
 	return exeValid(flag,txtEl,errorDesc)
 }
function removeClsEv(src,e1,cls,pcls,pclsId){
	var target = Ext.fly(src);
	if(target.hasClass("x-item-disabled")){
		return;
	}
	target.removeClass(cls);
	if (pcls) {
		target.findParent(pclsId,null,true).removeClass(pcls);
	}
}
function addClsEv(src,e1,cls,pcls,pclsId){
	var target = Ext.fly(src);
	if(target.hasClass("x-item-disabled")){
		return;
	}
	target.addClass(cls);
	if (pcls) {
		target.findParent(pclsId,null,true).addClass(pcls);
	}
}
function clickCheckboxEvent(src,e1,cls,hcls){
	var e = e1 || event;
	Ext.lib.Event.preventDefault(e);
	var target = Ext.fly(src);
	if(target.hasClass("x-item-disabled")){
		return;
	}
	if(target.hasClass(cls)){
		target.child(hcls).dom.checked = ""
		target.removeClass(cls);
	}else{
		target.child(hcls).dom.checked = "checked"
		target.addClass(cls);
	}
}
function clickRadioEvent(src,e1){
	var cls = 'x-form-check-checked';
	var hcls = '.x-radiogroup-radio';
	var parentCls = ".x-form-radio-wrap";
	var e = e1 || event;
	Ext.lib.Event.preventDefault(e);
	var target = Ext.fly(src);
	if(target.hasClass("x-item-disabled")){
		return;
	}
	var checkTarget = target.child(hcls);
	checkTarget.dom.checked = "checked"
	target.addClass(cls);
	
	var parentEl = checkTarget.up('form') || Ext.getBody();
	var els = parentEl.select('input[name='+checkTarget.dom.name+'][type=radio]');
	els.each(function(e2){
		if(e2.dom.id != checkTarget.id){
			var otherTaget = e2.findParent(parentCls,null,true);
			otherTaget.removeClass(cls);
		}
	}, checkTarget);
}
function resetFormState(src,ev){
	var btn = Ext.fly(src);
	if(btn.hasClass("x-item-disabled")){
		return;
	}
	var panelBwrap = btn.parent(".x-panel-bwrap");
	var form = panelBwrap.child("form");
	resetForm(form.dom,true);
}
function clickDateField(src,ev){
	var target = Ext.fly(src);
	if(target.hasClass("x-item-disabled")){
		return;
	}
	var inputEl = target.prev();
    var dateMenu = target.dom.dateMenu;
    if(dateMenu == null){
    	if(src.getAttribute('hasTime')){
	    	dateMenu = new Ext.menu.DateTimeMenu();
    	}else{
	    	dateMenu = new Ext.menu.DateMenu();
    	}
		target.dom.dateMenu = dateMenu;
    }
    var inputFormat = getDateFormat(inputEl);
    var date = Date.parseDate(inputEl.dom.value, inputFormat);
    dateMenu.picker.setValue(date || new Date());
    var selectDate = function(m, d){
    	var txtEl = Ext.fly(src).prev();
    	var format = getDateFormat(txtEl);
    	txtEl.dom.value = d.dateFormat(format);
    }
    dateMenu.on('select', selectDate);
    dateMenu.show(target.prev(), "tl-bl?");
}
function getDateFormat(field){
	var format = field.dom.getAttribute('dateFormat') || "Y-m-d";
	format = format.replace(/MM/g,"m").replace(/yyyy/g,"Y").replace(/dd/g,"d");
	format = format.replace(/HH/g,"H").replace(/mm/g,"i").replace(/ss/g,"s");

	return format;
}
function clickFieldSetEvent(src,ev){
	var isExistClass = "x-panel-collapsed";
 	var parentCls = ".x-fieldset";
	var element=Ext.fly(src);
	var target = element.findParent(parentCls,null,true);
	var bodyTarget = target.child(".x-fieldset-body");
	var collapseDisabled = target.getAttributeNS("collapseDisabled","collapseDisabled");
	var checkboxToggle = target.getAttributeNS("checkboxToggle","checkboxToggle");
	var isChecked = element.getAttributeNS("checked","checked") || target.hasClass("x-panel-collapsed");
	if(isChecked){
		target.removeClass(isExistClass);
		if(collapseDisabled=='true'&& checkboxToggle=='true'){
			isDisabled(bodyTarget,"")
		}
	}else{
		target.addClass(isExistClass);
		if(collapseDisabled=='true'&& checkboxToggle=='true'){
			isDisabled(bodyTarget,"disabled")
		}
	}
}
function expandAllFs(parentObj){
	if (typeof(parentObj) == "string") {
		parentObj = Ext.get(parentObj);
	}
	if(!parentObj){
		parentObj = Ext.getBody();
	}
	var fieldsets = parentObj.select(".x-fieldset");
	var isExistClass = "x-panel-collapsed";
	for(var i=0,count=fieldsets.getCount();i<count;i++){
		var fieldset = fieldsets.item(i);	
		fieldset.removeClass(isExistClass)
	}
}
function collapseAllFs(parentObj){
	if (typeof(parentObj) == "string") {
		parentObj = Ext.get(parentObj);
	}
	if(!parentObj){
		parentObj = Ext.getBody();
	}
	var fieldsets = parentObj.select(".x-fieldset");
	var isExistClass = "x-panel-collapsed";
	for(var i=0,count=fieldsets.getCount();i<count;i++){
		var fieldset = fieldsets.item(i);	
		fieldset.addClass(isExistClass)
	}
}
function isDisabled(target,disabled){
	var childs = target.select("input,select,textarea,button");
		for(var i=0,count=childs.getCount();i<count;i++){	
			var item = childs.item(i);
			item.dom.disabled=disabled;
		}
}

function blurComboExtend(src,ev){
	var target = Ext.fly(src);
	var imgEl = target.next();
	if(target.dom.isMouseover || imgEl.hasClass('x-form-trigger-over')){
		return false;
	}
	var listId = "x-combo-list-" + target.dom.id;
	var list = document.getElementById(listId)
	if(list){
		list.style.visibility = "hidden";
	}
}
function delCombItem(txtEl,value,label){
	if (typeof(txtEl) == "string") {
		txtEl = Ext.get(txtEl);
	}
	if(txtEl.hasClass("x-item-disabled")){
		return;
	}
	var tag_comb_items_height = parseInt(txtEl.dom.getAttribute("itemsHeight"));
	var itemsHeight = tag_comb_items_height?tag_comb_items_height:TAG_COMB_ITEMS_HEIGHT;
	
	var listId = "x-combo-list-" + txtEl.dom.id;
	var initListEl = Ext.get(listId);
	if (!initListEl) {
		clickCombo(txtEl.next(),null,true);
		list = document.getElementById(listId);
		list.style.visibility = "hidden";
		initListEl = Ext.get(listId);
	}
	var initListInnerEl = initListEl.first();
	var items = initListInnerEl.select(".x-combo-list-item");
	var len = items.getCount();
	for(var i=0; i<items.getCount(); i++) {
		var cmbItem = items.item(i);
		if(cmbItem.dom.cmbValue == value || cmbItem.dom.innerHTML == label){
			cmbItem.remove();
			if (len <= itemsHeight) {
				var listHeight = initListEl.getHeight();
				initListEl.setHeight(listHeight-21);
				initListInnerEl.setHeight(listHeight-21);
			}
			txtEl.dom.value = "";
			txtEl.prev().dom.value = "";
			break;
		}
	}
}
function addCombItem(txtEl,value,label){
	if (label == null) {
		label = value;
	}
	if (typeof(txtEl) == "string") {
		txtEl = Ext.get(txtEl);
	}
	if(txtEl.hasClass("x-item-disabled")){
		return;
	}
	var tag_comb_items_height = parseInt(txtEl.dom.getAttribute("itemsHeight"));
	var itemsHeight = tag_comb_items_height?tag_comb_items_height:TAG_COMB_ITEMS_HEIGHT;
	
	var listId = "x-combo-list-" + txtEl.dom.id;
	var list = document.getElementById(listId);
	var initListEl = Ext.get(listId);
	if (!initListEl) {
		clickCombo(txtEl.next(),null,true);
		list = document.getElementById(listId);
		list.style.visibility = "hidden";
		initListEl = Ext.get(listId);
	}
	var listInner = initListEl.first().dom;
	var initListInnerEl = Ext.get(listInner.id);
	var listHeight = initListEl.getHeight();
	var maxHeight = itemsHeight*21;
	if(maxHeight>listHeight+21){
		listHeight += 21;
	}
    initListEl.setHeight(listHeight);
    initListInnerEl.setHeight(listHeight);
    
    addCmbUiItem(listInner,txtEl,value,label);
}
function keyLoadComb(src,ev){
	window.setTimeout("clickCombo('"+src+"',null,false,true)","300");
}
function selectCombo(src,e1,img){
	var e = e1 || event;
	var k = e.keyCode;
	var textEl = Ext.fly(src);
	var textId = textEl.dom.id;
	var listId = "x-combo-list-" + textId;
	var list = document.getElementById(listId);
	if (k == Ext.EventObject.UP && list) {
		var listInner = Ext.get("x-combo-list-inner-" + textId);
		var prevItem = listInner.child(".x-combo-selected").prev();
		setCombBg(prevItem);
	}
	if (k == Ext.EventObject.DOWN) {
		if(!list || list.style.visibility == "hidden"){
			clickCombo(img,null);
		}else{
			var listInner = Ext.get("x-combo-list-inner-" + textId);
			var nextItem = listInner.child(".x-combo-selected").next();
			setCombBg(nextItem);
		}
	}
	if (k == Ext.EventObject.ENTER && list && list.style.visibility == "visible") {
		Ext.lib.Event.stopEvent(e);
		var listInner = Ext.get("x-combo-list-inner-" + textId);
		var currItem = listInner.child(".x-combo-selected");
		selectCmbItem(currItem);
	}
}
function clickCombo(src,ev,isFocus,isKeyup){
	var target = Ext.fly(src);
	if(target.hasClass("x-item-disabled")){
		return;
	}
	var textEl = target.prev();
	if(isKeyup){
	    var orgiValue = textEl.dom.orgiValue;
	    if(orgiValue == null){
	    	orgiValue = "";
	    }
	    var keyLoadParas = textEl.dom.getAttribute('keyLoadParas');
	    if((textEl.dom.value == orgiValue) || !keyLoadParas){
	    	return;
	    }
	    textEl.dom.orgiValue = textEl.dom.value;
	}
	var tag_comb_items_height = parseInt(textEl.dom.getAttribute("itemsHeight"));
	var itemsHeight = tag_comb_items_height?tag_comb_items_height:TAG_COMB_ITEMS_HEIGHT;
	
	var listId = "x-combo-list-" + textEl.id;
	
	var listEl = Ext.get(listId);
	var defaultState = "load";
	var loadState = textEl.getAttributeNS("loadState","loadState");
	var loadForKeyUp = textEl.getAttributeNS("loadForKeyUp","loadForKeyUp");
	var store;
	if(loadState!=defaultState && listEl){
		listEl.remove();
	}
	if(loadForKeyUp && isKeyup && listEl){
		listEl.remove();
	}
	var listWidth,listHeight
	var list = document.getElementById(listId);
	if(!list){
		list = document.createElement("div");
		list.id = "x-combo-list-" + textEl.id;
		document.body.appendChild(list);
		var listX,listY;
		listX = textEl.getX();
		listY = textEl.getY()+textEl.getHeight();
		var listStyle = {position: "absolute", "z-index": "11000",visibility: "hidden"};
		var initListEl = Ext.get(list.id);
		initListEl.addClass("x-layer");
		initListEl.addClass("x-combo-list");
		initListEl.setStyle(listStyle);
		initListEl.alignTo(Ext.get(textEl.dom.id), 'tl-bl?');
		
		var listInner = document.createElement("div");
		listInner.id = "x-combo-list-inner-" + textEl.id;
		listInner.cmbId = textEl.id
		list.appendChild(listInner);
		var initListInnerEl = Ext.get(listInner.id);
		initListInnerEl.addClass("x-combo-list-inner");
		var listInnerStyle = {overflow: "auto"};
		initListInnerEl.setStyle(listInnerStyle);
		
		initListInnerEl.addListener("mouseover",function(e2){
			var itemTarget = e2.getTarget(null,null,true);
			if(itemTarget.dom.cmbId)
				document.getElementById(itemTarget.dom.cmbId).isMouseover = true;
		});
		initListInnerEl.addListener("mouseout",function(e2){
			var itemTarget = e2.getTarget(null,null,true);
			if(itemTarget.dom.cmbId)
				document.getElementById(itemTarget.dom.cmbId).isMouseover = false;
		});
		initListInnerEl.addListener("scroll",function(e2){
			var itemTarget = e2.getTarget(null,null,true);
			document.getElementById(itemTarget.dom.cmbId).focus();
		});
		
		var displayField,valueField,initDate='1/1/2008';
		if(textEl.hasClass('x-timefield')){
	        var min = new Date(initDate).clearTime();
	        var max = new Date(initDate).clearTime().add('mi', (24 * 60) - 1);
	        var times = [];
	        while(min <= max){
	            times.push([min.dateFormat("g:i A"),min.dateFormat("g:i")]);
	            min = min.add('mi', 15);
	        }
	        store = new Ext.data.SimpleStore({
	            fields: ['label','value'],
	            data : times
	        });
	        displayField = 'label';
	        valueField = 'value';
		    if(store.getCount() > itemsHeight){
		    	listHeight = itemsHeight*21;
		    }else{
		    	listHeight = store.getCount()*21;
		    }
		    initListEl.setHeight(listHeight);
		    initListInnerEl.setHeight(listHeight);
		    store.each(function(record){
		    	var label = record.get(displayField);
		    	var value = record.get(valueField);
		    	addCmbUiItem(listInner,textEl,value,label);
			});
			if (store.getCount()) {
			    Ext.fly(listInner).child(".x-combo-list-item").addClass("x-combo-selected");
		    }
	    }else{
	    	displayField = textEl.dom.getAttribute("displayField");
		   	valueField = textEl.dom.getAttribute("valueField");
		   	var simpleData = textEl.dom.getAttribute("simpleData");
		   	if (simpleData) {
		   		var simpleObj = eval(simpleData);
		   		store = new Ext.data.SimpleStore({fields:[valueField,displayField],data:simpleObj});
		   		loadCmbData(textEl,store);
		   	}else{
				var dataUrl = textEl.dom.getAttribute("dataUrl");
				if (!dataUrl) {
					return;
				}
				var loadForKeyUp = textEl.dom.getAttribute('loadForKeyUp');
				var keyLoadParas = textEl.dom.getAttribute('keyLoadParas');
				var dataUrlParas = {};
				if(loadForKeyUp && keyLoadParas){
					dataUrlParas[keyLoadParas] = textEl.dom.value;
				}
				var superMenuId = textEl.dom.getAttribute('superMenuId');
				var paraName = textEl.dom.getAttribute('paraName');
				if(superMenuId&&paraName){
					var superMenu = Ext.get(superMenuId);
					var supMenuValue = superMenu.prev().getValue(); 
					if(supMenuValue){
						if(dataUrl.indexOf("?")!=-1){
							dataUrl = dataUrl+"&"+paraName+"="+supMenuValue;
						}else{
							dataUrl = dataUrl+"?"+paraName+"="+supMenuValue;
						}
					}
				}
		    	var dataLoading = document.createElement("div");
		    	dataLoading.innerHTML = '<div class="loading-indicator">loading...</div>';
		    	
		    	var totalPropStr = textEl.dom.getAttribute("totalProp");
		    	var dataRootStr = textEl.dom.getAttribute("dataRoot");
		    	var totalProp = totalPropStr?totalPropStr:'total';
		    	var dataRoot = dataRootStr?dataRootStr:'data';
		    	store = new Ext.data.Store({
					 proxy:new Ext.data.HttpProxy({url:dataUrl,method:'post'}), 
					 reader:new Ext.data.JsonReader({
						root:dataRoot, 
						totalProperty:totalProp}, 
						[{name:displayField},{name:valueField}]),
						listeners : {
							beforeload : {
								fn : function(store, options) {
									listInner.appendChild(dataLoading);
								}
							},
							load : {
								fn : function(store, records, opt) {
									var txtEl = Ext.get(opt.txtId);
									listInner.removeChild(listInner.lastChild);
									loadCmbData(txtEl,store);
								}
							}
						}				
				});
			    store.load({params:dataUrlParas,txtId:textEl.dom.id});
		   	}
	    }
		
	}
	listWidth = textEl.getWidth()+textEl.next().getWidth();
	Ext.get(list.id).setWidth(listWidth);
	Ext.get("x-combo-list-inner-" + textEl.id).setWidth(listWidth);
	if(list.style.visibility == "hidden" && list.childNodes[0].childNodes.length){
		var listX = textEl.getX();
		var listY = textEl.getY()+textEl.getHeight();
		var initListEl = Ext.get(list.id);
		initListEl.alignTo(Ext.get(textEl.dom.id), 'tl-bl?');
		list.style.visibility = "visible";
	}else{
		list.style.visibility = "hidden";
	}
	if (!isFocus) {
		textEl.dom.focus();
	} 
}

function loadCmbData(txtEl,store){
	
	var tag_comb_items_height = parseInt(txtEl.dom.getAttribute("itemsHeight"));
	var itemsHeight = tag_comb_items_height?tag_comb_items_height:TAG_COMB_ITEMS_HEIGHT;
	
	var listId = "x-combo-list-" + txtEl.dom.id
	var list = document.getElementById(listId)
	var initListEl = Ext.get(listId);
	var listInner = initListEl.first().dom;
	var initListInnerEl = Ext.get(listInner.id);
	
    if(store.getCount() > itemsHeight){
    	listHeight = itemsHeight*21;
    }else{
    	listHeight = store.getCount()*21;
    }
    initListEl.setHeight(listHeight);
    initListInnerEl.setHeight(listHeight);
    store.each(function(record){
    	var displayField = txtEl.dom.getAttribute("displayField");
		var valueField = txtEl.dom.getAttribute("valueField");
		var value = record.get(valueField);
		var label = record.get(displayField);
    	addCmbUiItem(listInner,txtEl,value,label);
    });
    if (store.getCount()) {
	    Ext.fly(listInner).child(".x-combo-list-item").addClass("x-combo-selected");
    }
}
function addCmbUiItem(listInner, txtEl, value, label) {
	if (label == null) {
		label = value;
	}
	var listItem1 = document.createElement("div");
	listItem1.cmbId = txtEl.dom.id;
	listInner.appendChild(listItem1);
	var initListItem1 = Ext.Element.fly(listItem1);
	var lineHeight = Ext.isIE ? 20 : 12;
	if (label == "") {
		initListItem1.setStyle("height", lineHeight);
	}
	initListItem1.addClass("x-combo-list-item");

	initListItem1.addListener("mouseover", function(e2) {
		var itemTarget = e2.getTarget(null, null, true);
		setCombBg(itemTarget);
	});
	initListItem1.addListener("click", function(e2) {
		var itemTarget = e2.getTarget(null, null, true);
		selectCmbItem(itemTarget);
	});

	listItem1.innerHTML = label;
	listItem1.cmbValue = value;
	listItem1.title = label;
}
function setCombBg(itemTarget){
	if (!itemTarget) {
		return;
	}
	var targetParent = itemTarget.parent();
	var selectItem = targetParent.child(".x-combo-selected");
	while (selectItem) {
		selectItem.removeClass("x-combo-selected");
		selectItem = targetParent.child(".x-combo-selected");
	}
	itemTarget.addClass("x-combo-selected");
}
function selectCmbItem(itemTarget) {
	if (!itemTarget) {
		return;
	}
	var txtEl = Ext.get(itemTarget.dom.cmbId);
	document.getElementById("x-combo-list-" + itemTarget.dom.cmbId).style.visibility = "hidden";
	var cmboTextHtml = document.getElementById(itemTarget.dom.cmbId);
	cmboTextHtml.value = itemTarget.dom.innerHTML;

	var oidHiddenVlaue = txtEl.prev().getValue();

	var cmbHidden = Ext.get(itemTarget.dom.cmbId).prev().dom;
	cmbHidden.value = itemTarget.dom.cmbValue;

	if (cmbHidden.value != oidHiddenVlaue) {
		var childEl = Ext.select('input[superMenuId="' + txtEl.dom.id + '"]');
		for (var i = 0, count = childEl.getCount(); i < count; i++) {
			var children = childEl.item(i);
			children.dom.setAttribute("loadState", "reload");
			children.dom.value = "";
		}
	}

	var oncmbselect = cmbHidden.getAttribute('oncmbselect');
	if (oncmbselect) {
		oncmbselect = oncmbselect.replace(/\(.*\)/g, "");
		eval(oncmbselect + "('" + cmboTextHtml.value + "','" + cmbHidden.value
				+"','"+itemTarget.dom.cmbId+ "')");
	}
	txtEl.dom.orgiValue = txtEl.dom.value;
	cmboTextHtml.focus();
	validEvent(cmboTextHtml);
}
 function clickPanelEvent(src,ev){
 	var isExistClass = "x-panel-collapsed";
 	var parentCls = ".x-panel";
	var element=Ext.fly(src);
	var target = element.findParent(parentCls,null,true);
	if(target.hasClass(isExistClass)){
		target.removeClass(isExistClass);
		target.child('.x-panel-bwrap').setStyle('display','block');
	}else{
		target.addClass(isExistClass);
		target.child('.x-panel-bwrap').setStyle('display','none');
	}
}

function keypreNumFldEvent(src,e1){
	var target=Ext.fly(src);
	var allowed = "0123456789-";
	if(src.getAttribute("point")){
		allowed += ".";
	}
    var e = e1 || event;
    var k = e.keyCode;
    var isSpecialKey = (e.type == 'keypress' && e.ctrlKey) || k == 9 || k == 13  || k == 40 || k == 27 ||
		(k == 16) || (k == 17) ||(k >= 18 && k <= 20) ||
		(k >= 33 && k <= 35) ||(k >= 36 && k <= 39) ||(k >= 44 && k <= 45);
    if(!Ext.isIE && (isSpecialKey || k == 8 || k == 46)){
        return;
    }
    var c = e.charCode||e.keyCode;
    if(allowed.indexOf(String.fromCharCode(c)) === -1){
		Ext.lib.Event.stopEvent(e);
    }
}
function loadingHandler(isLoading,store,opt){
	var maskParent = Ext.get(opt.owner.ownerId);
	var ownerMask = maskParent.child(".ext-el-mask");
	var ownerMaskMsg = maskParent.child(".ext-el-mask-msg");
	if (isLoading) {
		ownerMask.setStyle("display","");
		var gpage = Ext.get("ptb_" + opt.owner.ownerId);
		if(gpage){
			var mskHeight = gpage.getY()-maskParent.getY()+25;
			ownerMask.setHeight(mskHeight);
		}
		ownerMask.setLeft(maskParent.getLeft(true));
		ownerMask.setTop(maskParent.getTop(true)+25);
		ownerMaskMsg.setStyle("display","");
		ownerMaskMsg.setLeft(maskParent.getX() + (maskParent.getWidth()-ownerMaskMsg.getWidth())/2);
		ownerMaskMsg.setTop(maskParent.getY() + maskParent.getHeight()/2);
	} else {
		ownerMask.setStyle("display","none");
		ownerMaskMsg.setStyle("display","none");
	}
}
function doLoad(start,limit,store,owner){
 	var o = {}, pn = {start: 'start', limit: 'limit'};
    o[pn.start] = start;
    o[pn.limit] = limit;
	store.load({params:o,owner:owner});
 }
 function initPageStore(store){
	var page = Ext.get("ptb_" + store.lastOptions.owner.ownerId);
	var o = {}, pn = {start: 'start', limit: 'limit'};
    o[pn.start] = 0;
    o[pn.limit] = page.dom.getAttribute("pageSize");
    store.load({params:o,owner:store.lastOptions.owner});
 }
 function refreshPTBState(pageToolBar,store, records, opt){
 	pageToolBar.dom.cursor = opt.params ? opt.params['start'] : 0;
 	
 	var cursor = pageToolBar.dom.cursor;
 	var pageSize = parseInt(pageToolBar.dom.getAttribute("pageSize"));
	
	var numText = pageToolBar.child(".x-tbar-page-number");
	var pageSizeText = pageToolBar.child(".x-tbar-page-pagesize-number");
	
	var total = store.getTotalCount();
    var pageData = {
            total : total,
            activePage : Math.ceil((cursor+pageSize)/pageSize),
            pages :  total < pageSize ? 1 : Math.ceil(total/pageSize)
        }
	var d = pageData, ap = d.activePage, ps = d.pages;
	pageSizeText.dom.value = pageSize;
	numText.dom.value = ap;
	var first = pageToolBar.child(".x-tbar-btn-first");
	var prev = pageToolBar.child(".x-tbar-btn-prev");
	var next = pageToolBar.child(".x-tbar-btn-next");
	var last = pageToolBar.child(".x-tbar-btn-last");
	setBtnDisabled(first,ap == 1);
	setBtnDisabled(prev,ap == 1);
	setBtnDisabled(next,ap == ps);
	setBtnDisabled(last,ap == ps);
	updatePageInfo(pageToolBar,cursor,store,pageData.pages);
 	
 }
 function updatePageInfo(pageToolBar,cursor,store,pages){
 	var pageInfo = PageToolBarText;
 	
 	pageToolBar.child(".before-page-text").update(pageInfo.beforePageText);
 	pageToolBar.child(".after-page-text").update(String.format(pageInfo.afterPageText,pages));
 	pageToolBar.child(".pagesize-first").update(pageInfo.pageSizeFirst);
 	pageToolBar.child(".pagesize-last").update(pageInfo.pageSizeLast);
 	var displayEl = pageToolBar.child(".x-paging-info");
 	
    if(displayEl){
        var count = store.getCount();
        var msg = count == 0 ?
            pageInfo.emptyMsg :
            String.format(
                pageInfo.displayMsg,
                cursor+1, cursor+count, store.getTotalCount()
            );
        displayEl.update(msg);
    }
 }
 
 function gridBodyScroll(ele){
	var itemTarget = Ext.fly(ele);;
	var headerItem = itemTarget.prev().first();
	headerItem.dom.scrollLeft = itemTarget.dom.scrollLeft;
}
 function gridSynOver(e2){
	var rowTarget = Ext.fly(e2);
	if (rowTarget) {
		rowTarget.addClass("x-grid3-row-over");
	}
 }
 function gridSynOut(e2){
	var rowTarget = Ext.fly(e2);
	rowTarget = rowTarget.findParent(".x-grid3-row",null,true);
	rowTarget.removeClass("x-grid3-row-over");
}
function gridSynDown(e2,e1){
	var e = e1 || event;
	var rowTarget = Ext.fly(e2);
	rowTarget.addClass("x-grid3-row-selected");
	var grid = rowTarget.findParent(".x-grid-panel",null,true);
	if(!e.ctrlKey || grid.hasClass("x-grid-radio-tag")){
		var nextItem = rowTarget;
		var prevItem = rowTarget;
		while(nextItem=nextItem.next()){
			nextItem.removeClass("x-grid3-row-selected");
		}
		while(prevItem=prevItem.prev()){
			prevItem.removeClass("x-grid3-row-selected");
		}
	}
	setGridSelecteds(grid);
}
function gridSynClick(e2,e1,gridId){
	var e = e1 || event;
	var rowTarget = Ext.fly(e2);
	var grid = rowTarget.findParent(".x-grid-panel",null,true);
	if(!grid){
		grid = Ext.get(gridId);
	}
	var dataAuths = grid.dom.getAttribute("dataAuths")
	if (dataAuths) {
		dataAuths = eval("["+dataAuths+"]");
	}
	if(!grid.dom.onselect){
 		return;
 	}
	if (Ext.isIE) {
		eval(grid.dom.onselect)
	} else {
		grid.dom.onselect.call()
	}
}
 function gridCheckSelect(e2,e1){
 	var e = e1 || event;
	Ext.lib.Event.stopEvent(e);
 	var target = Ext.fly(e2);
    var grid = target.findParent(".x-grid-panel",null,true);
    var row = target.findParent(".x-grid3-row",null,true);
    if(row.hasClass("x-grid3-row-selected") && !grid.hasClass("x-grid-radio-tag")){
		row.removeClass("x-grid3-row-selected");
    }else{
		row.addClass("x-grid3-row-selected");
    }
    if(grid.hasClass("x-grid-radio-tag")){
    	var nextItem = row;
		var prevItem = row;
		while(nextItem=nextItem.next()){
			nextItem.removeClass("x-grid3-row-selected");
		}
		while(prevItem=prevItem.prev()){
			prevItem.removeClass("x-grid3-row-selected");
		}
    }
	setGridSelecteds(grid);
}
 function gridCheckSel(e,t){
	if(e.button === 0 && t.className == 'x-grid3-row-checker'){
		e.stopEvent();
        var grid = e.getTarget(".x-grid-panel",null,true);
        var row = e.getTarget(".x-grid3-row",null,true);
        if(row.hasClass("x-grid3-row-selected") && !grid.hasClass("x-grid-radio-tag")){
			row.removeClass("x-grid3-row-selected");
        }else{
			row.addClass("x-grid3-row-selected");
        }
        if(grid.hasClass("x-grid-radio-tag")){
        	var nextItem = row;
			var prevItem = row;
			while(nextItem=nextItem.next()){
				nextItem.removeClass("x-grid3-row-selected");
			}
			while(prevItem=prevItem.prev()){
				prevItem.removeClass("x-grid3-row-selected");
			}
        }
		setGridSelecteds(grid);
    }
}
 function synPageBtn(btn,e2){
	var target = Ext.fly(btn);
	if (target.hasClass("x-item-disabled")) {
		return false;
	}
	var pageTb = target.findParent(".x-page-toolbar-table",null,true) || target.findParent(".x-page-toolbar-syn",null,true);
	var startName = pageTb.dom.getAttribute("startName") + "=";
	var pageSizeName = pageTb.dom.getAttribute("pageSizeName") + "=";
	var startIndex=0;
	var start = parseInt(pageTb.dom.getAttribute("start"));
	var pageSize = parseInt(pageTb.dom.getAttribute("pageSize"));
	var total = parseInt(pageTb.dom.getAttribute("total"));
	if (target.dom.className.indexOf("first") != -1) {
		startIndex = 0;
	}
	else if (target.dom.className.indexOf("prev") != -1) {
		startIndex = Math.max(0, start-pageSize);
	}
	else if (target.dom.className.indexOf("next") != -1) {
		startIndex=start+pageSize;
		if(startIndex >= total){
			startIndex = start;
		}
	}
	else if (target.dom.className.indexOf("last") != -1) {
		
		var extra = total % pageSize;
		var lastStart = extra ? (total - extra) : total-pageSize;
		startIndex = lastStart;
	}
	else if (target.dom.className.indexOf("loading") != -1) {
		startIndex = start;
	}
	else if (target.dom.className.indexOf("go") != -1) {
		
		var pageSizeValue = pageTb.child(".x-tbar-page-pagesize-number").dom.value;
		var parsePageSize;
		if (pageSizeValue && !isNaN(parsePageSize=parseInt(pageSizeValue)) && parsePageSize != pageSize) {
			pageSize = parsePageSize;
			startIndex = 0;
		}else{
			var numText = pageTb.child(".x-tbar-page-number");
			var numValue = numText.dom.value, parseNum;
			var pageData = {
	            total : total,
	            activePage : Math.ceil((start+pageSize)/pageSize),
	            pages :  total < pageSize ? 1 : Math.ceil(total/pageSize)
	        }
			if (!numValue || isNaN(parseNum = parseInt(numValue, 10))) {
				numText.dom.value = pageData.activePage;
				return false;
			}
			parseNum = Math.min(Math.max(1, parseNum), pageData.pages) - 1;
			startIndex = parseNum*pageSize;
		}
		
	}
	else{
		return;
	}
	var urlPara = window.location.search;
	var pageClick = pageTb.dom.getAttribute("onpageclick");
	if (urlPara== "" && !pageClick) {
		window.location = "?" + startName + startIndex + "&"+pageSizeName+pageSize;
		return;
	}
	var newSearch = "?";
	var paras = urlPara.substring(1).split("&");
	for(var i=0;i<paras.length;i++){
		var para = paras[i];
		if (para.indexOf(startName) == -1 && para.indexOf(pageSizeName) == -1) {
			newSearch+=para+"&";
		}
	}
	if (pageClick) {
		pageClick = pageClick.replace(/\(.*\)/g, "");
		eval(pageClick + "(" + startIndex + "," + pageSize+ ")");;
	}else{
		window.location = newSearch + startName + startIndex + "&"+pageSizeName+pageSize;
	}
 }
function pageBtnHandler(src,ev){
	var e = ev || event;
	Ext.lib.Event.preventDefault(e);
	var target =Ext.fly(src);
	var item = target.findParent(".x-page-toolbar",null,true);
	if(!item.dom.cursor){
		item.dom.cursor = 0;
	}
	var ownerShow = Ext.get(item.dom.id.substring(4));
	var store = ownerShow.dom.store;
	var owner={ownerId:ownerShow.dom.id};
	
	var start;
	var pageSize = parseInt(item.dom.getAttribute("pageSize"));
	
	if (target.dom.className.indexOf("first") != -1) {
		start = 0;
	}
	else if (target.dom.className.indexOf("prev") != -1) {
		start = Math.max(0, item.dom.cursor-pageSize);
	}
	else if (target.dom.className.indexOf("next") != -1) {
		start = item.dom.cursor+pageSize;
		if(start >= store.getTotalCount()){
			start = item.dom.cursor;
		}
	}
	else if (target.dom.className.indexOf("last") != -1) {
		var total = store.getTotalCount();
		var extra = total % pageSize;
		var lastStart = extra ? (total - extra) : total-pageSize;
		start = lastStart;
	}
	else if (target.dom.className.indexOf("loading") != -1) {
		start = item.dom.cursor;
	}
	else if (target.dom.className.indexOf("go") != -1) {
		
		var pageSizeValue = item.child(".x-tbar-page-pagesize-number").dom.value;
		var parsePageSize;
		if (pageSizeValue && !isNaN(parsePageSize=parseInt(pageSizeValue)) && parsePageSize != pageSize) {
			pageSize = parsePageSize;
			item.dom.setAttribute("pageSize",pageSize);
			doLoad(0,pageSize,store,owner);
			return;
		}
		
		var total = store.getTotalCount();
		var numText = item.child(".x-tbar-page-number");
		var numValue = numText.dom.value, parseNum;
		var pageData = {
            total : total,
            activePage : Math.ceil((item.dom.cursor+pageSize)/pageSize),
            pages :  total < pageSize ? 1 : Math.ceil(total/pageSize)
        }
		if (!numValue || isNaN(parseNum = parseInt(numValue, 10))) {
			numText.dom.value = pageData.activePage;
			return false;
		}
		parseNum = Math.min(Math.max(1, parseNum), pageData.pages) - 1;
		start = parseNum*pageSize;
	}
	else{
		return;
	}
	
	doLoad(start,pageSize,store,owner);
}
 function initGridpanel(grids) {
 	gridLoadEvent(grids);
 }
 function gridLoadEvent(grids){
 	gridHeadLoad(true,grids);
 	gridBodyLoad(true,grids);
 }
 function gridAllSelect(t){
    var hd = Ext.fly(t.parentNode);
    var isChecked = hd.hasClass('x-grid3-hd-checker-on');
    var headClass = "x-grid3-hd-checker-on";
    var itemClass = "x-grid3-row-selected";
    var checkDao;
    if(isChecked){
        checkDao = "removeClass";
    }else{
    	checkDao = "addClass"
    }
    eval("hd."+ checkDao +"(headClass)");
    var gridHeaderEl = hd.findParent(".x-grid3-header",null,true);
    var gridBodyScrollEL = gridHeaderEl.next();
    var checkItems=gridBodyScrollEL.select('.x-grid3-row');
	for(var k=0;k<checkItems.getCount();k++){
		var row=checkItems.item(k);
		eval("row."+ checkDao +"(itemClass)");
	}
	var grid = hd.findParent(".x-grid-panel",null,true);
	setGridSelecteds(grid);
}
 function gridAllSel(e,t){
    if(t.className == 'x-grid3-hd-checker'){
        e.stopEvent();
        var hd = Ext.fly(t.parentNode);
        var isChecked = hd.hasClass('x-grid3-hd-checker-on');
        var headClass = "x-grid3-hd-checker-on";
        var itemClass = "x-grid3-row-selected";
        var checkDao;
        if(isChecked){
            checkDao = "removeClass";
        }else{
        	checkDao = "addClass"
        }
        eval("hd."+ checkDao +"(headClass)");
        var gridHeaderEl = e.getTarget(".x-grid3-header",null,true);
        var gridBodyScrollEL = gridHeaderEl.next();
        var checkItems=gridBodyScrollEL.select('.x-grid3-row');
		for(var k=0;k<checkItems.getCount();k++){
			var row=checkItems.item(k);
			eval("row."+ checkDao +"(itemClass)");
		}
		var grid = e.getTarget(".x-grid-panel",null,true);
		setGridSelecteds(grid);
    }
}
 function gridMouOver(e2){
	e2.preventDefault();
	var rowTarget = e2.getTarget(".x-grid3-row",null,true);
	if (rowTarget) {
		rowTarget.addClass("x-grid3-row-over");
	}
 }
 function gridMouOut(e2){
	e2.preventDefault();
	var rowTarget = e2.getTarget(null,null,true);
	rowTarget = rowTarget.findParent(".x-grid3-row",null,true);
	rowTarget.removeClass("x-grid3-row-over");
}
function gridMouDown(e2){
	if(e2.button !== 0){
		return;
	}
	e2.preventDefault();
	var rowTarget = e2.getTarget(null,null,true);
	rowTarget = rowTarget.findParent(".x-grid3-row",null,true);
	rowTarget.addClass("x-grid3-row-selected");
	
	var grid = e2.getTarget(".x-grid-panel",null,true);
	if(!e2.ctrlKey || grid.hasClass("x-grid-radio-tag")){
		var nextItem = rowTarget;
		var prevItem = rowTarget;
		while(nextItem=nextItem.next()){
			nextItem.removeClass("x-grid3-row-selected");
		}
		while(prevItem=prevItem.prev()){
			prevItem.removeClass("x-grid3-row-selected");
		}
	}
	setGridSelecteds(grid);
}
 function getGridData(ele){
 	var grid;
 	if (typeof(ele) == "string") {
		grid = Ext.get(ele);
	}else{
		grid = ele;
	}
 	var datas = [];
 	var selItems = grid.select('.x-grid3-row');
 	for(var i=0,count=selItems.getCount();i<count;i++){
		var item=selItems.item(i);
		if(grid.dom.store){
			grid.dom.store.each(function(record){
				if(record.get("grid-row-id") == item.dom.rowId){
					datas = datas.concat(record);
				}
			});
		}else{
			var record = {};
			var headStr = grid.dom.getAttribute("headers").replace(/[\n\t\r]/g,"");
			var headers = eval(headStr);
			var rowItems = item.select(".x-grid3-record");
			for(j=0;j<headers.length;j++){
				var colName = headers[j].name;
				if(colName){
					record[colName] = rowItems.item(j).dom.getAttribute("value");
				}
			}
			datas = datas.concat(record);
		}
 	}
 	return datas;
 }
 function setGridSelecteds(ele){
 	var grid;
 	if (typeof(ele) == "string") {
		grid = Ext.get(ele);
	}else{
		grid = ele;
	}
 	var selections = [];
 	var selItems = grid.select('.x-grid3-row-selected');
 	for(var i=0,count=selItems.getCount();i<count;i++){
		var item=selItems.item(i);
		if(grid.dom.store){
			grid.dom.store.each(function(record){
				if(record.get("grid-row-id") == item.dom.rowId){
					selections = selections.concat(record);
				}
			});
		}else{
			var record = {};
			var headStr = grid.dom.getAttribute("headers").replace(/[\n\t\r]/g,"");
			var headers = eval(headStr);
			var rowItems = item.select(".x-grid3-record");
			for(j=0;j<headers.length;j++){
				var colName = headers[j].name;
				if(colName){
					record[colName] = rowItems.item(j).dom.getAttribute("value");
				}
			}
			selections = selections.concat(record);
		}
 	}
 	grid.dom.selModels = selections;
 }
 function getGridSelecteds(ele){
 	var grid;
 	if (typeof(ele) == "string") {
		grid = Ext.get(ele);
	}else{
		grid = ele;
	}
 	var selections = [];
 	var selItems = grid.select('.x-grid3-row-selected');
 	for(var i=0,count=selItems.getCount();i<count;i++){
		var item=selItems.item(i);
		if(grid.dom.store){
			grid.dom.store.each(function(record){
				if(record.get("grid-row-id") == item.dom.rowId){
					selections = selections.concat(record);
				}
			});
		}else{
			var record = {};
			var headStr = grid.dom.getAttribute("headers").replace(/[\n\t\r]/g,"");
			var headers = eval(headStr);
			var rowItems = item.select(".x-grid3-record");
			for(j=0;j<headers.length;j++){
				var colName = headers[j].name;
				if(colName){
					record[colName] = rowItems.item(j).dom.getAttribute("value");
				}
			}
			selections = selections.concat(record);
		}
 	}
 	return selections;
 }
 function gridHeadLoad(isFisrt,grids){
 	
	for(var i=0,count=grids.length;i<count;i++){
		var item=Ext.get(asynGrid[i]).child('.x-grid3-hd-row-asyn');
		var gridEl = item.findParent(".x-grid-panel",null,true);
		
		var parentWrap = gridEl.findParent(".x-panel-bwrap",null,true);
		if(parentWrap){
			var gridWrap = gridEl.child(".x-panel-body");
			gridWrap.setStyle("border-left-width","0px");
			gridWrap.setStyle("border-right-width","0px");
			gridWrap.setStyle("border-top-width","0px");
			
			var gridPage = Ext.get("ptb_" + gridEl.dom.id);
			if(gridPage){
				gridPage.removeClass("x-panel-bbar");
				gridPage.first().setStyle("border-bottom-width","0px");
			}
		}
		
		var selectMode = gridEl.dom.getAttribute("selectMode");
		if(selectMode == "radio"){
			gridEl.addClass("x-grid-radio-tag");
		}
		var gridTabHead = item.findParent(".x-grid3-header-offset",null,true);
		var headers = eval(item.dom.getAttribute("headers"));
		var gridWidth = gridTabHead.dom.getAttribute("gridWidth");
		
		var ckItem = item.createChild({tag:'td',cls:'x-grid3-hd x-grid3-cell x-grid3-td-checker',width:20
				,html:'<div class="x-grid3-hd-inner x-grid3-hd-checker"><div class="x-grid3-hd-checker">&#160;</div></div>'});
				
		ckItem.setStyle('display','none');
		if(selectMode){
			ckItem.setStyle('display','');
			if(selectMode != "radio"){
				ckItem.addListener("mousedown",gridAllSel);
			}
		}
		var j=0;
		for(;j<headers.length;j++){
			var header = headers[j];
			item.createChild({tag:'td',cls:'x-grid3-hd x-grid3-cell x-grid3-td-0',width:header.width
				,html:'<div class="x-grid3-hd-inner x-grid3-hd-0">'+ header.header +'</div>'}
			)
		}
		if(isFisrt){
			item.first().remove();
		}
		
		if(gridWidth){
			var htPara = headers.length<8?8:headers.length
			gridTabHead.setStyle("width",parseInt(gridWidth)*(htPara/8) + "px");
		}else{
			gridTabHead.setStyle("width","100%");
		}
	}
 }
 function gridBodyLoad(isFisrt,grids){
	for(var i=0,count=grids.length;i<count;i++){
		var item=Ext.get(asynGrid[i]).child('.x-grid3-body-asyn');
		
		if(!item.dom.getAttribute("gridWidth")){
	 		item.setStyle("overflow-x","hidden")
	 	}
		gridLoadDate(item);
	}
 }
 function gridLoadDate(itemBody){
	var headers = eval(itemBody.dom.getAttribute("headers"));
	var dataUrl = itemBody.dom.getAttribute("dataUrl");
	var store = new Ext.data.Store({
		 proxy:new Ext.data.HttpProxy({url:dataUrl}), 
		 reader:new Ext.data.JsonReader({
			root:'data', 
			totalProperty:'total'}, 
			headers.concat({name:"grid-row-id"})),
			listeners : {
				beforeload : {
					fn : function(store, options) {
						if(options.params && options.owner){
							loadingHandler(true,store, options);
							return;
						}
						if(store.lastOptions){
							var page = Ext.get("ptb_" + store.lastOptions.owner.ownerId);
							if (page) {
								var o = {}, pn = {start: 'start', limit: 'limit'};
							    o[pn.start] = 0;
							    o[pn.limit] = page.dom.getAttribute("pageSize");
							    options.params = options.params?options.params:o;
							}
							options.owner = options.owner?options.owner:store.lastOptions.owner;
						}
						loadingHandler(true,store, options);
					}
				},
				load : {
					fn : function(store, records, opt) {
						var item = Ext.get(opt.owner.ownerId).child(".x-grid3-body");
						
						loadingHandler(false,store, opt);
						var orgDivs = item.select('.x-grid3-row');
						for(var k=0;k<orgDivs.getCount();k++){
							orgDivs.item(k).remove();
						}
						var gridWidth = item.dom.getAttribute("gridWidth");
						var bodyTabWidth = '';
						var htPara = headers.length<8?8:headers.length
						if(gridWidth){
							bodyTabWidth = 'width: '+parseInt(gridWidth)*(htPara/8) + 'px;';
						}else{
							bodyTabWidth = 'width: 100%;';
						}
						var rid = -1;
						store.each(function(record){
							var divHtml = '<table cellspacing="0" cellpadding="0" border="0" style="width: 100%;" class="x-grid3-row-table">';
							divHtml += '<tr class="x-grid3-tr"><td></td></tr></table>';
							var divItem = item.createChild({tag:'div',cls:'x-grid3-row'
								,style:bodyTabWidth
								,html:divHtml});
								
							record.set("grid-row-id",++rid);
							divItem.dom.rowId = rid;
							
							var trItem = divItem.child("tr");
							var ckItem = trItem.createChild({tag:'td',tabindex:0,width:20
								,cls:'x-grid3-col x-grid3-cell x-grid3-td-checker x-grid3-cell-first'
								,html:'<div class="x-grid3-cell-inner x-grid3-col-checker">' +
										'<div class="x-grid3-row-checker">&#160;</div></div>'});
							ckItem.setStyle('display','none');
							var grid = item.findParent(".x-grid-panel",null,true);
							var selectMode = grid.dom.getAttribute("selectMode");
							if(selectMode){
								ckItem.setStyle('display','');
							}
							ckItem.addListener("mousedown",gridCheckSel);
							
							for(j=0;j<headers.length;j++){
								var header = headers[j];
								var tdItem = trItem.createChild({tag:'td',tabindex:0,width:header.width
									,cls:'x-grid3-col x-grid3-cell x-grid3-td-'+j+' x-grid3-cell-first'
									,html:'<div class="x-grid3-cell-inner x-grid3-col-0">'+ record.get(header.name) +'</div>'});
							}
							trItem.first().remove();
							
							divItem.addListener("mouseover",gridMouOver);
							divItem.addListener("mouseout",gridMouOut);
							divItem.addListener("mousedown",gridMouDown);
							
						});
						var scrollItem = item.parent();
						scrollItem.addListener("scroll",function(e2){
							var itemTarget = e2.getTarget(null,null,true);
							var headerItem = itemTarget.prev().first();
							headerItem.dom.scrollLeft = itemTarget.dom.scrollLeft;
						});
						
						var gridTopEl = item.findParent(".x-grid-panel",null,true);
						gridTopEl.dom.store = store;
						
						var gridTopEl = item.findParent(".x-grid-panel",null,true);
						var pageToolBar = Ext.get("ptb_" + gridTopEl.dom.id);
						if (Ext.get(pageToolBar)) {
							refreshPTBState(pageToolBar,store, records, opt)
						}
						setGridSelecteds(gridTopEl);
						
						var gridScroll = item.parent();
					 	if (!gridScroll.dom.style.height) {
					 		var grid = item.findParent(".x-grid-panel",null,true);
					 		if(!Ext.isIE){
					 			grid.child(".x-panel-body").setStyle("margin-left","-2px");
					 		}
					 		var gridTHeight1 = getHeiPara(grid);
					 		if (gridTHeight1>0) {
								gridScroll.setHeight(gridTHeight1);
								gridScroll.dom.noHeight = true;
					 		} 
					 	} 
					}
				}
			}			
	});
	
	var gridTopEl = itemBody.findParent(".x-grid-panel",null,true);
	var pageToolBar = Ext.get("ptb_" + gridTopEl.dom.id);
	var owner = {};
	owner.ownerId = gridTopEl.dom.id;
	if (pageToolBar) {
		pageToolBar.child(".x-tbar-go").update(PageToolBarText.pageGo);
		var gridTableEl = gridTopEl.child(".grid-header-table");
		var gridWidth = parseInt(gridTableEl.dom.getAttribute("gridWidth"));
		if(gridWidth){
			pageToolBar.setWidth(gridWidth + (Ext.isIE?25:27))
		}
		var pageSize = pageToolBar.dom.getAttribute("pageSize");
		doLoad(0,pageSize,store,owner);
	} else {
	    store.load({owner:owner});
	}

 }
 function activeTabEvent(src,ev){
 	var targetHeader = Ext.fly(src);
 	var tabPanel = targetHeader.findParent(".x-tab-panel",null,true);
 	var headParent = targetHeader.parent();
 	if(targetHeader.hasClass("x-tab-strip-active")){
 		return;
 	}
 	if(!tabPanel.dom.activeTab){
 		tabPanel.dom.activeTab = 0;
 	}
 	var headerEls = headParent.select(".x-tab-header");
 	headerEls.item(tabPanel.dom.activeTab).removeClass("x-tab-strip-active");
 	
 	targetHeader.addClass("x-tab-strip-active");
 	
 	var index = parseInt(targetHeader.dom.getAttribute("index"));
 	var currTabItem = Ext.get(tabPanel.dom.id + index);
 	var orgiTabItem = Ext.get(tabPanel.dom.id + tabPanel.dom.activeTab);
 	currTabItem.removeClass("x-hide-display");
 	orgiTabItem.addClass("x-hide-display");
 	tabPanel.dom.activeTab = index;
 	
 	var onActiveTab = tabPanel.dom.getAttribute('onActiveTab');
	if(onActiveTab){
		onActiveTab = onActiveTab.replace(/\(.*\)/g,"");
		eval(onActiveTab + "('" +index+"')");
	}
 }
 function activeTabIndx(src,indexItem){
 	var tabPanel = src;
 	if (typeof(src) == "string") {
		tabPanel = Ext.get(src);
	}
 	var headParent = tabPanel.child(".x-tab-strip-top");
 	if(!tabPanel.dom.activeTab){
 		tabPanel.dom.activeTab = 0;
 	}
 	var activeT = tabPanel.dom.activeTab;
 	var headerEls = headParent.select(".x-tab-header");
 	
 	var targetHeader = headerEls.item(indexItem);
 	var orgiHeader = headerEls.elements[activeT];
 	if(targetHeader.hasClass("x-tab-strip-active")){
 		return;
 	}
 	targetHeader.addClass("x-tab-strip-active");
 	Ext.fly(orgiHeader).removeClass("x-tab-strip-active");
 	var index = parseInt(targetHeader.dom.getAttribute("index"));
 	var currTabItem = Ext.get(tabPanel.dom.id + index);
 	var orgiTabItem = Ext.get(tabPanel.dom.id + activeT);
 	currTabItem.removeClass("x-hide-display");
 	orgiTabItem.addClass("x-hide-display");
 	tabPanel.dom.activeTab = index;
 	
 	var onActiveTab = tabPanel.dom.getAttribute('onActiveTab');
	if(onActiveTab){
		onActiveTab = onActiveTab.replace(/\(.*\)/g,"");
		eval(onActiveTab + "('" +index+"')");
	}
 }
 function scrollTabs(src,direction){
 	src.scrollFlag = 0;
 	var panelHeader = Ext.fly(src).parent();
 	var stripWrap = panelHeader.child(".x-tab-strip-wrap");
 	
 	var tabUl = stripWrap.child(".x-tab-strip-top");
 	var edge = tabUl.child(".x-tab-edge");
 	var pos = stripWrap.dom.scrollLeft;
 	var scrollWidth = edge.getOffsetsTo(stripWrap)[0] + pos;
 	var scrollArea = stripWrap.dom.clientWidth;
 	if (!Ext.isIE) {
 		scrollArea -= 36;
 	}
 	var tw = panelHeader.dom.clientWidth;
 	var lis = tabUl.select('li');
 	
	var scrollIndex = stripWrap.dom.scrollIndex || 0;
	var paraIndex = scrollIndex;
	var sw = scrollWidth-scrollArea;
	var tabsCount = lis.getCount()-1;
	
    if (direction < 0) {
    	paraIndex = Math.max(0,scrollIndex-2);
    	s = pos - (stripWrap.dom.lastTab || 0);
    }else{
		var scrollIncrement = lis.item(paraIndex).getWidth() + 4;
    	s = Math.max(0,Math.min(sw, pos + scrollIncrement));
    }
    if(s != pos){
        stripWrap.scrollTo('left', s, {duration:.35,callback:updateScrollButtons,scope:src});
	    scrollIndex += direction;
	    scrollIndex = Math.max(0,Math.min(tabsCount-1,scrollIndex));
	    stripWrap.dom.scrollIndex = scrollIndex;
	    if (direction > 0) {
	    	stripWrap.dom.lastTab = s - pos;
	    }else{
	    	stripWrap.dom.lastTab = lis.item(paraIndex).getWidth() + 4;
	    }
    }
 }
 function updateScrollButtons(stripWrap){
 	var tabUl = stripWrap.child(".x-tab-strip-top");
 	var edge = tabUl.child(".x-tab-edge");
 	var pos = stripWrap.dom.scrollLeft;
 	var scrollWidth = edge.getOffsetsTo(stripWrap)[0] + pos;
 	var scrollArea = stripWrap.dom.clientWidth;
 	if (!Ext.isIE) {
 		scrollArea -= 36;
 	}
 	var scroLeft = stripWrap.prev();
 	var scroRight = scroLeft.prev();
	scroLeft[pos == 0 ? 'addClass' : 'removeClass']('x-tab-scroller-left-disabled');
	scroRight[pos >= (scrollWidth-scrollArea) ? 'addClass' : 'removeClass']('x-tab-scroller-right-disabled');
 	
	var src = this;
	var direction = (this.className.indexOf("right")!=-1)?1:-1;
	setTimeout(function(){
		if (src.scrollFlag) {
			return;
		}
		scrollTabs(src,direction);
	},100)
 }
 function setThisValue(src,value){
 	src.scrollFlag = value;
 }
 function hideTabIndx(src,indexItem,state){
 	var tabPanel = src;
 	if (typeof(src) == "string") {
		tabPanel = Ext.get(src);
	}
 	var headParent = tabPanel.child(".f1");
 	if(!tabPanel.dom.activeTab){
 		tabPanel.dom.activeTab = 0;
 	}
 	var activeT = tabPanel.dom.activeTab;
 	var headerEls = headParent.select(".bc_tabitem_head");
 	
 	var targetHeader = headerEls.item(indexItem);
 	if (state) {
 		targetHeader.setStyle("display","");
 	}else{
 		targetHeader.setStyle("display","none");
 	}
 }
 function getChildValues(ele,isUrl){
 	var fs = serializeEle(ele)
 	if(isUrl === true){
        return fs;
    }
   return Ext.urlDecode(fs);
 }
 function serializeEle(ele) {
    if(typeof ele == 'string') {
        ele = Ext.get(ele);
    }
    var el, name, val, disabled, data = '', hasSubmit = false;
    var allEles = ele.select('input,select,textarea');
    for (var i = 0; i < allEles.getCount(); i++) {
        el = allEles.item(i).dom;
        disabled = allEles.item(i).dom.disabled;
        name = allEles.item(i).dom.name;
        val = allEles.item(i).dom.value;

        if (!disabled && name){
            switch (el.type)
                    {
                case 'select-one':
                case 'select-multiple':
                    for (var j = 0; j < el.options.length; j++) {
                        if (el.options[j].selected) {
                            if (Ext.isIE) {
                                data += encodeURIComponent(name) + '=' + encodeURIComponent(el.options[j].attributes['value'].specified ? el.options[j].value : el.options[j].text) + '&';
                            }
                            else {
                                data += encodeURIComponent(name) + '=' + encodeURIComponent(el.options[j].hasAttribute('value') ? el.options[j].value : el.options[j].text) + '&';
                            }
                        }
                    }
                    break;
                case 'radio':
                case 'checkbox':
                    if (el.checked) {
                        data += encodeURIComponent(name) + '=' + encodeURIComponent(val) + '&';
                    }
                    break;
                case 'file':

                case undefined:

                case 'reset':

                case 'button':

                    break;
                case 'submit':
                    if(hasSubmit == false) {
                        data += encodeURIComponent(name) + '=' + encodeURIComponent(val) + '&';
                        hasSubmit = true;
                    }
                    break;
                default:
                    data += encodeURIComponent(name) + '=' + encodeURIComponent(val) + '&';
                    break;
            }
        }
    }
    data = data.substr(0, data.length - 1);
    return data;
}
function setBtnName(target,btnName){
	if(!target){
		return;
	}
	if(typeof(target) == "string"){
	 	target = Ext.fly(target);
	}else{
		target = Ext.get(target);
	}
	target.child("button").dom.innerHTML = btnName;
}
function resetForm(form,hasCheckbox){
	if(typeof(form) == "string"){
	 	form = document.getElementById(form);
	}
	if(form){
		form.reset();
		var fields = form.elements;
		for(var i=0;i<fields.length;i++){
			if(fields[i].id){
				if(fields[i].id == "")continue;
				clearInvalid(fields[i].id);
			}
		}
	}
	if(hasCheckbox === true){
		refreshCheckState(Ext.fly(form));
	}
}
function getDocument(frameName,winObj) {
	var target = winObj || top;
	if (Ext.isIE) {
		return target.frames[frameName].document;
	} else {
		return target.document.getElementById(frameName).contentDocument;
	}
}
function getWindow(frameName,winObj) {
	var target = winObj || top;
	if (Ext.isIE) {
		return target.frames[frameName].window;
	} else {
		return target.document.getElementById(frameName).contentWindow;
	}
}
function scrollHeader(obj){
	Ext.fly(obj).prev().first().dom.style.left = -1*(obj.scrollLeft);	
}
function gridSelectAll(t){
    var hd = Ext.fly(t.parentNode);
    var isChecked = hd.hasClass('x-grid3-hd-checker-on');
    var headClass = "x-grid3-hd-checker-on";
    var itemClass = "x-grid3-row-selected";
    var checkDao;
    if(isChecked){
        checkDao = "removeClass";
    }else{
    	checkDao = "addClass"
    }
    eval("hd."+ checkDao +"(headClass)");
    var gridHeaderEl = hd.findParent(".x-grid3-header",null,true);
    var gridBodyScrollEL = gridHeaderEl.next();
    var checkItems=gridBodyScrollEL.select('.x-grid3-row');
	for(var k=0;k<checkItems.getCount();k++){
		var row=checkItems.item(k);
		eval("row."+ checkDao +"(itemClass)");
	}
}
function gridSelect(e2,e1,gridId){
	var e = e1 || event;
	var rowTarget = Ext.fly(e2);
	var grid = Ext.get(gridId);
	if(!grid.dom.onselect){
 		return;
 	}
	if (Ext.isIE) {
		eval(grid.dom.onselect)
	} else {
		grid.dom.onselect.call()
	}
}
function gridDown(e2,e1){
	var e = e1 || event;
	var rowTarget = Ext.fly(e2);
	rowTarget.addClass("x-grid3-row-selected");
	var grid = rowTarget.findParent(".x-grid3-table",null,true);
	if(!e.ctrlKey || grid.hasClass("x-grid-radio-tag")){
		var nextItem = rowTarget;
		var prevItem = rowTarget;
		while(nextItem=nextItem.next()){
			nextItem.removeClass("x-grid3-row-selected");
		}
		while(prevItem=prevItem.prev()){
			prevItem.removeClass("x-grid3-row-selected");
		}
	}
}
function gridSelectCheck(e2,e1){
 	var e = e1 || event;
	Ext.lib.Event.stopEvent(e);
 	var target = Ext.fly(e2);
    var grid = target.findParent(".x-grid3-table",null,true);
    var row = target.findParent(".x-grid3-row",null,true);
    if(row.hasClass("x-grid3-row-selected") && !grid.hasClass("x-grid-radio-tag")){
		row.removeClass("x-grid3-row-selected");
    }else{
		row.addClass("x-grid3-row-selected");
    }
    if(grid.hasClass("x-grid-radio-tag")){
    	var nextItem = row;
		var prevItem = row;
		while(nextItem=nextItem.next()){
			nextItem.removeClass("x-grid3-row-selected");
		}
		while(prevItem=prevItem.prev()){
			prevItem.removeClass("x-grid3-row-selected");
		}
    }
}
 function getGridAllData(ele){
 	var grid;
 	if (typeof(ele) == "string") {
		grid = Ext.get(ele);
	}else{
		grid = ele;
	}
 	var selections = [];
 	var selItems = grid.select('.x-grid3-row');
 	for(var i=0,count=selItems.getCount();i<count;i++){
		var item=selItems.item(i);
		var record = {};
		var cellItem = item.child(".x-grid3-table-cell");
		while(cellItem){
			var colName = cellItem.dom.getAttribute("headerText");
			if(colName){
				record[colName] = cellItem.dom.getAttribute("value");
			}
			cellItem = cellItem.next();
		}
		selections = selections.concat(record);
 	}
 	return selections;
 }
 function getGridSelectedData(ele){
 	var grid;
 	if (typeof(ele) == "string") {
		grid = Ext.get(ele);
	}else{
		grid = ele;
	}
 	var selections = [];
 	var selItems = grid.select('.x-grid3-row-selected');
 	for(var i=0,count=selItems.getCount();i<count;i++){
		var item=selItems.item(i);
		var record = {};
		var cellItem = item.child(".x-grid3-table-cell");
		while(cellItem){
			var colName = cellItem.dom.getAttribute("headerText");
			if(colName){
				record[colName] = cellItem.dom.getAttribute("value");
			}
			cellItem = cellItem.next();
		}
		selections = selections.concat(record);
 	}
 	return selections;
 }
 function addGridItem(grid,o){
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	
	var item = grid.child(".x-grid3-body");
	var bodyItem = grid.child(".tbodytable");
	var tbodyItem = bodyItem.first();
	if(!tbodyItem){
		tbodyItem = bodyItem.createChild({tag:'tbody'});
	}
	var firstTr;
	if(Ext.isIE && !tbodyItem.first()){
		firstTr = document.createElement("tr");
		tbodyItem.dom.appendChild(firstTr);
	}
	var gridWidth = item.dom.getAttribute("gridWidth");
	var columnsStr = grid.dom.getAttribute("columnsInfo");
	var columns = eval(columnsStr);
	var bodyTabWidth = '';
	var htLen = headers.length
	for (var indexHt = 0; indexHt < htLen; indexHt++) {
		if (headers[indexHt].hidden) {
			htLen--;
		}
	}
	var htPara = htLen<8?8:htLen;
	if(gridWidth){
		bodyTabWidth = 'width: '+parseInt(gridWidth)*(htPara/8) + 'px;';
	}else{
		bodyTabWidth = 'width: 100%;';
	}
	var trItem = tbodyItem.createChild({tag:'tr',cls:'x-grid3-row'
		,style:bodyTabWidth,onmouseover:'gridSynOver(this,event)'
		,onmousedown:'gridSynDown(this,event)',onmouseout:'gridSynOut(this,event)',onclick:'gridSynClick(this,event,\''+grid.dom.id+'\')'
		,html:'<td></td>'});
	var ckItem = trItem.createChild({tag:'td',tabindex:0,width:20
		,cls:'x-grid3-col x-grid3-cell x-grid3-td-checker x-grid3-cell-first'
		,onmousedown:'gridCheckSelect(this,event)'
		,html:'<div class="x-grid3-cell-inner x-grid3-col-checker">' +
				'<div class="x-grid3-row-checker">&#160;</div></div>'});
	ckItem.setStyle('display','none');
	var selectMode = grid.dom.getAttribute("selectMode");
	if(selectMode){
		ckItem.setStyle('display','');
	}
	for(j=0;j<headers.length;j++){
		var header = headers[j];
		var headerName = header.name?header.name:'';
		var currValue;
		if (o.get) {
			currValue = o.get(header.name)
		} else {
			currValue = o[header.name]
		}
		var cellValue;
		if (header.allValue) {
			var allValue = header.allValue.split(";;");
			var templates = header.templates.split(";;");
			cellValue = currValue;
			for(var k=0; k<allValue.length; k++) {
				var val = allValue[k];
				if (val == currValue+"") {
					cellValue = templates[k];
					cellValue = cellValue.replace(/\{value\}/g,currValue);
					cellValue = cellValue.replace(/`/g,"'");
				}
			}
		}else if(header.template){
			cellValue = header.template;
			cellValue = cellValue.replace(/\{value\}/g,currValue);
			cellValue = cellValue.replace(/`/g,"'");
		}else{
			cellValue = currValue;
		}
		if (header.paras) {
			var paras = header.paras.split(";");
			for(var k=0; k<paras.length; k++) {
				
				var regex1 = eval("/\\{"+k+"\\}/g");
				var parasValue;
				if (o.get) {
					parasValue = o.get(paras[k]);
				} else {
					parasValue = o[paras[k]]
				}
				cellValue = cellValue.replace(regex1,parasValue);
			}
		} 
		var tdHtml = '<div class="x-grid3-cell-inner x-grid3-record" header="'+headerName+'" value="'+currValue+'"';
		if(header.alt){
			tdHtml += ' title=\''+ currValue +'\'';
		}
		tdHtml += '>'+ cellValue +'</div>';
		var display = 'display:'+header.hidden?'none':'none';
		var tdItem = trItem.createChild({tag:'td',tabindex:0,width:header.width,style:'display:'+(header.hidden?'none':'')
			,cls:'x-grid3-col x-grid3-cell x-grid3-td-'+j+' x-grid3-cell-first'
			,html:tdHtml});
	}
	trItem.first().remove();
	if (firstTr) {
		tbodyItem.dom.removeChild(firstTr);
	}
}