LegoTag.clickCheckboxEvent = function (src,e1){
	var e = e1 || event;
	Ext.lib.Event.preventDefault(e);
	return LegoTag.clickCheck (src);
}
LegoTag.keydownCheckboxEvent = function (src,e1){
	var e = e1 || event;
	if(e.keyCode==32){
		Ext.lib.Event.preventDefault(e);
		return LegoTag.clickCheck (src);
	}
}
LegoTag.clickCheck = function (src){
	var target = Ext.fly(src);
	target = target.findParent(".x-form-check-wrap",null,true);
	var cls = 'x-form-check-checked';
	var hcls = '.x-form-checkbox';
	if(target.hasClass("x-item-disabled")){
		return true;
	}
	if(target.hasClass(cls)){
		target.child(hcls).dom.checked = ""
		target.removeClass(cls);
	}else{
		target.child(hcls).dom.checked = "checked"
		target.addClass(cls);
	}
}



LegoTag.getCheckedOfKey = function (src,key){
	var item = Ext.fly(src);
	var itemId = item.dom.id;
	var itemInputs = item.select("input");
	var itemName = itemInputs.item(0).dom.name;
	for (var i = 0; i < itemInputs.getCount(); i++) {
		var itemInput = itemInputs.item(i);
		if (itemInput.dom.id == itemName + "-" + key) {
			return itemInput.dom.checked;
		}
	}
	return false;
}
LegoTag.getCheckedOfIndex = function (src,index){
	var item = Ext.fly(src);
	var itemInputs = item.select("input");
	return itemInputs.item(index).dom.checked || false;
}
LegoTag.getChecked = function (src){
	var item = Ext.fly(src);
	var itemInput = item.child("input");
	return itemInput.dom.checked;
}
LegoTag.setCheck = function (src,checked){
	var target = Ext.fly(src);
	if (!target) {
		return;
	}
	target = target.findParent(".x-form-check-wrap",null,true);
	var cls = 'x-form-check-checked';
	var hcls = '.x-form-checkbox';
	if(target.hasClass("x-item-disabled")){
		return;
	}
	if(checked == true){
		target.child(hcls).dom.checked = "checked"
		target.addClass(cls);
	}else{
		target.child(hcls).dom.checked = ""
		target.removeClass(cls);
	}
	return checked == true;
}
LegoTag.setCheckOfName = function (name,index,checked){
	var checks = document.getElementsByName(name);
	var indexes = (""+index).split(",");
	for (var i = 0; i < indexes.length; i++) {
		LegoTag.setCheck(checks[indexes[i]],checked);
	}
}
LegoTag.setCheckOfId = function (id,index,checked){
	var chkgroup = Ext.get(id);
	var checks = chkgroup.select(".x-form-check-wrap");
	var chkItem = checks.item(index);
	var indexes = (""+index).split(",");
	for (var i = 0; i < indexes.length; i++) {
		LegoTag.setCheck(checks.item(indexes[i]),checked);
	}
}
LegoTag.selectAllCheckOfId = function (id,checked){
	var chkgroup = Ext.get(id);
	var checks = chkgroup.select(".x-form-check-wrap");
	for (var i = 0; i < checks.getCount(); i++) {
		LegoTag.setCheck(checks.item(i),checked);
	}
}
LegoTag.selectAllCheckOfName = function (name,checked){
	var checks = document.getElementsByName(name);
	for (var i = 0; i < checks.length; i++) {
		LegoTag.setCheck(checks[i],checked);
	}
}
LegoTag.clickRadioEvent = function (src,e1){
	var e = e1 || event;
	Ext.lib.Event.preventDefault(e);
	LegoTag.setRadioCheck(src)
}
LegoTag.keydownRadioEvent = function (src,e1){
	var e = e1 || event;
	if(e.keyCode==32){
		Ext.lib.Event.preventDefault(e);
		LegoTag.setRadioCheck(src)
	}
}

LegoTag.setRadioCheck = function (src){
	var target = Ext.fly(src);
	var parentCls = ".x-form-radio-wrap";
	target = target.findParent(parentCls,null,true);
	if(target.hasClass("x-item-disabled")){
		return;
	}
	var cls = 'x-form-check-checked';
	var hcls = '.x-radiogroup-radio';
	var checkTarget = target.child(hcls);
	checkTarget.dom.checked = "checked"
	target.addClass(cls);
	
	var parentEl = checkTarget.up('form') || Ext.getBody();
	var els = parentEl.select('input[name='+checkTarget.dom.name+'][type=radio]');
	els.each(function(e2){
		if(e2.dom.id != checkTarget.id){
			var otherTaget = e2.findParent(parentCls,null,true);
			otherTaget.removeClass(cls);
		}
	}, checkTarget);
}
LegoTag.setRdiChkOfId = function (id,index){
	var radiogroup = Ext.get(id);
	var radios = radiogroup.select(".x-form-radio-wrap");
	var radioItem = radios.item(index);
	if (radioItem) {
		LegoTag.setRadioCheck(radioItem);
	}
}
LegoTag.setRdiChkOfName = function (name,index){
	var radios = document.getElementsByName(name);
	if (radios[index]) {
		LegoTag.setRadioCheck(radios[index])
	}
}

LegoTag.refreshCheckState = function (scope){
	if(!scope){
		scope = Ext.getBody();
	}
	if (typeof(scope) == "string") {
		scope = Ext.get(scope);
	}
	var element=scope.select(".x-form-checkbox,.x-radiogroup-radio");
	for(var i=0,count=element.getCount();i<count;i++){
		var item=element.item(i);
		var parentTaget = item.findParent(".x-form-check-wrap",null,true);
		var childDivClass = '.x-form-check-wrap-inner';
		var childImgClass = '.x-form-check';
		var childInputClass = '.x-form-checkbox';
		if(!parentTaget){
			parentTaget = item.findParent(".x-form-radio-wrap",null,true);
			var childDivClass = '.x-form-radio-wrap-inner';
			var childImgClass = '.x-radiogroup-img';
			var childInputClass = '.x-radiogroup-radio';
		}
		if(item.dom.checked){
			parentTaget.addClass("x-form-check-checked");
			
		}else{
			parentTaget.removeClass("x-form-check-checked");
		}
	}
}

LegoTag.getRdiCheckedValue = function (src){
	var rdiGroup = Ext.fly(src);
	var itemInputs = rdiGroup.select("input");
	for (var i = 0; i < itemInputs.getCount(); i++) {
		var itemInput = itemInputs.item(i);
		if (itemInput.dom.checked) {
			var o = {};
			o.index = i;
			o.value = itemInput.dom.value;
			o.label = itemInput.next("label").dom.innerHTML.trim();
			return o;
		}
	}
	return null;
}
LegoTag.getCheckedValues = function (src){
	var arr = [];
	var checkGroup = Ext.fly(src);
	var itemInputs = checkGroup.select("input");
	for (var i = 0; i < itemInputs.getCount(); i++) {
		var itemInput = itemInputs.item(i);
		if (itemInput.dom.checked) {
			var o = {};
			o.index = i;
			o.value = itemInput.dom.value;
			o.label = itemInput.next("label").dom.innerHTML.trim();
			arr.push(o);
		}
	}
	return arr;
}