LegoTag.tableGrids=[];

LegoTag.winResize = function (x,y){
	var treeGrid  = Ext.select(".x-grid3-tree-grid").item(0);
	if(treeGrid){
	LegoTag.treeGridAutoResize(treeGrid.dom.id);
  }
}
LegoTag.setFitSize = function (grids,bodyCls,pageCls){
	for(var j=0;j<grids.length;j++){
		var gridBody=Ext.get(grids[j]).child(bodyCls);
		gridBody.prev().first().dom.scrollLeft=gridBody.dom.scrollLeft;
		var grid_El = Ext.get(grids[j]);
		var gridPage = grid_El.parent().child(pageCls);
		var parentWidth = 0;
		if (gridBody.dom.noHeight || !gridBody.dom.style.height){
			var sizes = LegoTag.getFitHeight(grid_El,bodyCls);
			var bodyHeight = sizes[0];
			parentWidth = sizes[1];
			gridBody.setHeight(bodyHeight);
			gridBody.dom.noHeight = true;
		}
		if (gridBody.dom.noWidth || grid_El.dom.style.width == "100%"){
			parentWidth = parentWidth || LegoTag.getFitHeight(grid_El,bodyCls)[1];
			parentWidth -= 3;
			var gridHeader = grid_El.child(".x-grid3-header");
			if(Ext.isIE){
				var currentExplorerWidth=top.Ext.getBody().getWidth();
				var table = gridHeader.child("table");
				var width = table.getWidth();
				if(LegoTag.lastGridExplorerWidth){
					width = width-(LegoTag.lastGridExplorerWidth-currentExplorerWidth);
				}
				LegoTag.lastGridExplorerWidth=top.Ext.getBody().getWidth();
				
				if(parentWidth!=LegoTag.lastGridParentWidth){
					parentWidth=width;
				}
				LegoTag.lastGridParentWidth=parentWidth;
			}
			
			grid_El.setWidth(parentWidth+3);
			
			LegoTag.setGridDataWidth(gridHeader,gridBody,parentWidth);
			
			gridBody.setWidth(parentWidth);
			gridHeader.setWidth(parentWidth);
			if (!gridBody.dom.noWidth) {
				LegoTag.setGridBodyWidth(grid_El,parentWidth);
			}
			gridBody.dom.noWidth = true;
			if (Ext.isIE) {
				var tbodyTable = grid_El.child(".tbodytable");
				var theaderTable = grid_El.child(".theader").first();
				theaderTable.dom.style.left = -1*(tbodyTable.parent().dom.scrollLeft);
			}
		}
	}
}

LegoTag.setGridDataWidth = function(gridHeader, gridBody, dataWidth) {
	var table = gridHeader.child("table");
	var widthRate = dataWidth / table.getWidth();
	var tds = gridHeader.select("td");
	var td = tds.item(0);
	var width = td.getWidth();
	if (td.child('.x-grid3-hd-checker') && width > 0) {
		widthRate = (dataWidth - width) / (table.getWidth() - width);
	}

	var elWidth = [];
	for ( var i = 1, len = tds.elements.length; i < len; i++) {
		td = tds.item(i);
		width = td.getWidth();
		width = Math.round(width * widthRate);
		elWidth.push(width);
	}

	table.setWidth(dataWidth);
	for ( var i = 0, len = elWidth.length; i < len; i++) {
		if (elWidth[i] > 0) {
			tds.item(i + 1).setWidth(elWidth[i]);
		}
	}
	table = gridBody.child("table");
	if(table && table.child("tr")){
		tds = table.child("tr").select("td");

		table.setWidth(dataWidth);
		for ( var i = 0, len = elWidth.length; i < len; i++) {
			if (elWidth[i] > 0) {
				tds.item(i + 1).setWidth(elWidth[i]);
			}
		}
	}
}
LegoTag.setGridBodyWidth = function (grid,width){
	var tbodyTable = grid.child(".tbodytable");
	var theaderTable = grid.child(".theader").first();
	var bodyWidth = grid.dom.getAttribute("bodyWidth");
	if (!bodyWidth || bodyWidth.indexOf("100%") != -1) {
		tbodyTable.setWidth(width-18);
		theaderTable.setWidth(width-18);
	}
}
LegoTag.getFitHeight = function (grid,bodyCls){
	var parentObj = grid.parent(".x-real-panel") || grid.parent(".x-tab-panel") || grid.parent(".x-formpanel") || grid.parent(".x-fieldset");
	var para = 0;
	
	var gridBrother = grid.parent().first();
	while(gridBrother){
		if (gridBrother != grid && gridBrother.dom.tagName.toLowerCase() != "script") {
			if(Ext.isIE && gridBrother.dom.tagName.toLowerCase() == "form"){
				if(gridBrother.dom.children.length>0){
					para += gridBrother.getHeight();
				}
			}else{
				para += gridBrother.getHeight();
			}
		}
		gridBrother = gridBrother.next();
	}
	var bodyEl = grid.child(bodyCls);
	var bodyBrother = bodyEl.parent().first();
	while(bodyBrother){
		if (bodyBrother != bodyEl) {
			para += bodyBrother.getHeight();
		}
		bodyBrother = bodyBrother.next();
	}
	if (parentObj) {
		if (parentObj.hasClass("x-tab-panel")) {
			var titleHeight = parentObj.child(".x-tab-panel-header").dom.clientHeight;
			para += titleHeight+1;
		} else if(parentObj.hasClass("x-formpanel")){
			para += (Ext.isIE?53:34);
		} else if(parentObj.hasClass("x-panel") && parentObj.child(".x-panel-header-text")){
			var titleHeight = parentObj.child(".x-panel-header").dom.clientHeight;
			para += titleHeight+1;
		} else if(parentObj.hasClass("x-fieldset")){
			para += 23;
		}
		para += 2;
	}else{
		parentObj = grid.parent();
	}
	parentObj.setStyle("overflow","hidden");
	var parentHeight = parentObj.dom.clientHeight;
	return [parentHeight-para,parentObj.getWidth()];
}

LegoTag.gridOver = function (e2){
	var rowTarget = Ext.fly(e2);
	if (rowTarget) {
		if (rowTarget.hasClass("x-item-disabled")) {
			return false;
		}
		rowTarget.addClass("x-grid3-row-over");
	}
 }
LegoTag.gridOut = function (e2){
	var rowTarget = Ext.fly(e2);
	if (rowTarget.hasClass("x-item-disabled")) {
		return false;
	}
	rowTarget.removeClass("x-grid3-row-over");
	
}


LegoTag.scrollHeader = function (obj){
	Ext.fly(obj).prev().first().dom.style.left = -1*(obj.scrollLeft);	
}
LegoTag.gridSelectAll = function (t){
    var hd = Ext.fly(t.parentNode);
    if(!hd.findParent(".x-grid3-tree-grid",null,true)){
    var isChecked = hd.hasClass('x-grid3-hd-checker-on');
    var headClass = "x-grid3-hd-checker-on";
    var itemClass = "x-grid3-row-selected";
    var checkDao;
    if(isChecked){
        checkDao = "removeClass";
    }else{
    	checkDao = "addClass"
    }
    eval("hd."+ checkDao +"(headClass)");
    var rowItem=hd.findParent(".x-grid3-table",null,true).child('.x-grid3-row')
    while(rowItem){
    	if (!rowItem.hasClass("x-item-disabled")) {
			eval("rowItem."+ checkDao +"(itemClass)");
		}
		rowItem = rowItem.next();
	}
    var grid = hd.findParent(".x-grid3-table",null,true);
    if(grid.dom.getAttribute("onselect")){
		if (Ext.isIE) {
			if(Ext.isIEOld){
				eval(grid.dom.onselect)
			}else{
				grid.dom.onselect.call();
			}
		} else if(Ext.isGecko){
			grid.dom.onselect.call();
		}else{
			eval(grid.dom.getAttribute("onselect"));
		}
 	} 
  }else{
	  LegoTag.treeGridSelectAll(t);
  }
}
LegoTag.gridSelect = function (row,e1,gridId){
	var e = e1 || event;
	var rowTarget = Ext.fly(row);
	if (rowTarget.hasClass("x-item-disabled")) {
		Ext.lib.Event.stopEvent(e);
		return false;
	}
	var grid = rowTarget.findParent(".x-grid3-table",null,true);
	if(grid.dom.getAttribute("onselect")){
		if (Ext.isIE) {
			eval(grid.dom.onselect)
		} else if(Ext.isGecko){
			grid.dom.onselect.call();
		}else{
			eval(grid.dom.getAttribute("onselect"));
		}
 	} 
}
var gridSelectRowInxArr = [];
LegoTag.gridDown = function (e2,e1){
	var e = e1 || event;
	var rowTarget = Ext.fly(e2);
	if (rowTarget.hasClass("x-item-disabled")) {
		Ext.lib.Event.stopEvent(e);
		return false;
	}
	gridSelectRowInxArr.push(rowTarget.dom.getAttribute("rowIndex"));
	if(gridSelectRowInxArr.length > 2){
		gridSelectRowInxArr.shift();
	}
	var tag=(Ext.isIE)?e.srcElement:e.target;
	if(tag && tag.tagName){
		if("|INPUT|SELECT|TEXTAREA|BUTTON|IMG|A|".indexOf("|" + tag.tagName.toUpperCase() + "|") >= 0){
			return false;
		}
	}
	var grid = rowTarget.findParent(".x-grid3-table",null,true);
	if(rowTarget.findParent(".x-grid3-tree-grid",null,true)){
		grid = rowTarget.findParent(".x-grid3-tree-grid",null,true);
	}
	if(grid.hasClass("x-grid-radio-tag")){
		if(!rowTarget.hasClass("x-grid3-row-selected")){
    		rowTarget.addClass("x-grid3-row-selected");
    	}
    	var nextItem = rowTarget;
		var prevItem = rowTarget;
		while(nextItem=nextItem.next()){
			nextItem.removeClass("x-grid3-row-selected");
		}
		while(prevItem=prevItem.prev()){
			prevItem.removeClass("x-grid3-row-selected");
		}
    }else
    {
    	if(rowTarget.hasClass("x-grid3-row-selected")){
    		rowTarget.removeClass("x-grid3-row-selected");
    	}else{
    		rowTarget.addClass("x-grid3-row-selected");
    	}
    	var rowChecker = grid.select('.x-grid3-row');
    	var len = rowChecker.elements.length;
    	if(len>0){
    		var rowFlag=true;
    		for(var i=0;i<len;i++){
    			if (rowChecker.item(i).hasClass("x-item-disabled")) {
    				continue;
    			}
    			if(!rowChecker.item(i).hasClass('x-grid3-row-selected')){
    				rowFlag=false;
    				break;
    			}
    		}
    		if(grid.child('.x-grid3-hd-checker')){
    		var headChecker = grid.child('.x-grid3-hd-checker').parent();
	    	    if(rowFlag){
	    			headChecker.addClass('x-grid3-hd-checker-on');
	    		}else {
	    			headChecker.removeClass('x-grid3-hd-checker-on');
	    		}
    	  }
    		else{
    			var oldSelectIndex = gridSelectRowInxArr.length > 1 ?gridSelectRowInxArr[0]:null;
    			if(e.shiftKey && oldSelectIndex){
    				var newSelectIndex = rowTarget.dom.getAttribute("rowIndex");
    				if(newSelectIndex > oldSelectIndex){
    					var temp = oldSelectIndex ; 
    					oldSelectIndex = newSelectIndex ; 
    					newSelectIndex = temp;
    				}
    				grid.select(".x-grid3-row-selected").removeClass("x-grid3-row-selected");
    				for(var m = newSelectIndex; m < oldSelectIndex || m == oldSelectIndex; m++ ){
    					var targetTrEle = grid.select(".x-grid3-row").item(m);
    					if(targetTrEle){
    						if(!targetTrEle.hasClass("x-grid3-row-selected"))
    					     targetTrEle.addClass("x-grid3-row-selected");
    					}
					}
    				return ;
    			}
    			if(e.ctrlKey){
    				return ;
    			}
    			if(!rowTarget.hasClass("x-grid3-row-selected")){
    	    		rowTarget.addClass("x-grid3-row-selected");
    	    	}
    	    	var nextItem = rowTarget;
    			var prevItem = rowTarget;
    			while(nextItem=nextItem.next()){
    				nextItem.removeClass("x-grid3-row-selected");
    			}
    			while(prevItem=prevItem.prev()){
    				prevItem.removeClass("x-grid3-row-selected");
    			}
     	   }
    	}
    }
	if(grid.dom.getAttribute("onselect")){
		if (Ext.isIE) {
			if(Ext.isIEOld){
				eval(grid.dom.onselect)
			}else{
				grid.dom.onselect.call();
			}
		} else if(Ext.isGecko){
			grid.dom.onselect.call();
		}else{
			eval(grid.dom.getAttribute("onselect"));
		}
 	} 
}
LegoTag.gridSelectCheck = function (e2,e1){
 	var e = e1 || event;
	Ext.lib.Event.stopEvent(e);
 	var target = Ext.fly(e2);
    var grid = target.findParent(".x-grid3-table",null,true);
    var row = target.findParent(".x-grid3-row",null,true);
    if (row.hasClass("x-item-disabled")) {
		return false;
	}
    if(row.hasClass("x-grid3-row-selected") && !grid.hasClass("x-grid-radio-tag")){
		row.removeClass("x-grid3-row-selected");
    }else{
		row.addClass("x-grid3-row-selected");
    }
    if(grid.hasClass("x-grid-radio-tag")){
    	var nextItem = row;
		var prevItem = row;
		while(nextItem=nextItem.next()){
			nextItem.removeClass("x-grid3-row-selected");
		}
		while(prevItem=prevItem.prev()){
			prevItem.removeClass("x-grid3-row-selected");
		}
    }else{
    	if(target.findParent(".x-grid3-tree-grid",null,true)){
    	}else{	  
    	var rowChecker = grid.select('.x-grid3-row');
    	var len = rowChecker.elements.length;
    	if(len>0){
    		var rowFlag=true;
    		for(var i=0;i<len;i++){
    			if (rowChecker.item(i).hasClass("x-item-disabled")) {
    				continue;
    			}
    			if(!rowChecker.item(i).hasClass('x-grid3-row-selected')){
    				rowFlag=false;
    				break;
    			}
    		}
    		var headChecker = grid.child('.x-grid3-hd-checker').parent();
    		if(rowFlag){
    			headChecker.addClass('x-grid3-hd-checker-on');
    		}else {
    			headChecker.removeClass('x-grid3-hd-checker-on');
    		}
    	}
      }
    }
    if(grid.dom.getAttribute("onselect")){
		if (Ext.isIE) {
			if(Ext.isIEOld){
				eval(grid.dom.onselect)
			}else{
				grid.dom.onselect.call();
			}
		} else if(Ext.isGecko){
			grid.dom.onselect.call();
		}else{
			eval(grid.dom.getAttribute("onselect"));
		}
 	} 
}
LegoTag.getGridAllData = function (ele){
 	var grid;
 	var selections = [];
 	if (typeof(ele) == "string") {
		grid = Ext.get(ele);
	}else{
		grid = ele;
	}
 	if(grid.hasClass("x-grid3-tree-grid")){
 		var tables = grid.select("table.x-grid3-table");
 		for(var i = 0 ; i < tables.getCount(); i ++){
 			var item = tables.item(i).child('.x-grid3-row');
 			while(item){
 				var td = item.child('.x-grid3-table-cell');
 				var data={};
 				while(td){
 					var name = td.dom.getAttribute("name");
 					if(name){
 						data[name]=td.dom.getAttribute("value");
 					}
 					td = td.next();
 				}
 				selections = selections.concat(data);
 				item = item.next();
 		 	}
 		}
 	}else{	
 	var item = grid.child('.x-grid3-row');
	while(item){
		var td = item.child('.x-grid3-table-cell');
		var data={};
		while(td){
			var name = td.dom.getAttribute("name");
			if(name){
				data[name]=td.dom.getAttribute("value");
			}
			td = td.next();
		}
		selections = selections.concat(data);
		item = item.next();
 	 }
 	}
	return selections;
 }
LegoTag.getGridSelectedData = function (ele){
 	var grid;
 	if (typeof(ele) == "string") {
		grid = Ext.get(ele);
	}else{
		grid = ele;
	}
 	var selections = [];
 	if(grid.hasClass("x-grid3-tree-grid")){
 		var tables = grid.select("table.x-grid3-table");
 		for(var i = 0 ; i < tables.getCount(); i ++){
 		 var item = tables.item(i).child('.x-grid3-row-selected');
 		while(item){
 			var td = item.child('.x-grid3-table-cell');
 			var data={};
 			while(td){
 				var name = td.dom.getAttribute("name");
 				if(name){
 					data[name]=td.dom.getAttribute("value");
 				}
 				td = td.next();
 			}
 			selections = selections.concat(data);
 			item = item.next(".x-grid3-row-selected");
 	 	 }
 		}
 	}else{		
 	var item = grid.child('.x-grid3-row-selected');
	while(item){
		var td = item.child('.x-grid3-table-cell');
		var data={};
		while(td){
			var name = td.dom.getAttribute("name");
			if(name){
				data[name]=td.dom.getAttribute("value");
			}
			td = td.next();
		}
		selections = selections.concat(data);
		item = item.next(".x-grid3-row-selected");
 	 }
 	}	
 	return selections;
 }
LegoTag.delGridSelect = function (gridId){
	if (typeof(gridId) == "string") {
		grid = Ext.get(gridId);
	}
	var item = grid.child('.x-grid3-row-selected');
	while(item){
		var delItem = item;
		item = item.next(".x-grid3-row-selected");
		delItem.remove();
	}
	var recordAll = LegoTag.getGridAllData(gridId);
	if(recordAll.length < 1){
		if(Ext.get(gridId).next()){
		Ext.get(gridId).next().dom.style.display="block";	
		}
		var gridItem = grid.child('.x-grid3-hd-checker-on');
		if(gridItem){
		   gridItem.removeClass("x-grid3-hd-checker-on");
		}
	}
}
LegoTag.gridIndexDao = function (grid,index,dao,arg){
	var gridId=grid;
	index = index+"";
	if (index.indexOf("-") != -1) {
		return;
	}
	index = index.split(",");
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var itemIndex = 0;
	var item = grid.child('.x-grid3-row');
	while(item){
		if(index.indexOf(itemIndex+"") != -1){
			item[dao](arg);
		}
		item = item.next();
		itemIndex++;
	}
	var recordAll = LegoTag.getGridAllData(gridId);
	if(recordAll.length < 1){
		if(Ext.get(gridId).next()){
		Ext.get(gridId).next().dom.style.display="block";	
		}
		var gridItem = grid.child('.x-grid3-hd-checker-on');
		if(gridItem){
		   gridItem.removeClass("x-grid3-hd-checker-on");
		}
	}
}
LegoTag.setDisabledGItem = function (grid,index,disabled){
	var cls = disabled?"addClass":"removeClass";
	LegoTag.gridIndexDao(grid,index,cls,"x-item-disabled");
	LegoTag.gridIndexDao(grid,index,'removeClass',"x-grid3-row-selected");
}
LegoTag.cancelGridItemForIndex = function (grid,index){
	LegoTag.gridIndexDao(grid,index,'removeClass',"x-grid3-row-selected");
}
LegoTag.selGridItemForIndex = function (grid,index){
	LegoTag.gridIndexDao(grid,index,'addClass',"x-grid3-row-selected");
}
LegoTag.delGridItemForIndex = function (grid,index){
	LegoTag.gridIndexDao(grid,index,'remove');
}
LegoTag.delAllGridItem = function (grid){
	var gridId = grid;
	if (typeof(grid) == "string") {
		grid = Ext.get(grid);
	}
	var item = grid.child('.x-grid3-row');
	while(item){
		var delItem = item;
		item = item.next();
		delItem.remove();
	}
	var recordAll = LegoTag.getGridAllData(gridId);
	if(recordAll.length < 1){
		if(Ext.get(gridId).next()){
		Ext.get(gridId).next().dom.style.display="block";	
		}
		var gridItem = grid.child('.x-grid3-hd-checker-on');
		if(gridItem){
		   gridItem.removeClass("x-grid3-hd-checker-on");
		}
	}
}

LegoTag.addGridItems = function (grid,arr){
	for (var i = 0; i < arr.length; i++) {
		LegoTag.addGridItem(grid,arr[i]);
	}
}
LegoTag.addGridItem = function (gridId,o){
	grid = Ext.fly(gridId);
	var bodyItem = grid;
	var tbodyItem = bodyItem.first();
	if(!tbodyItem){
		tbodyItem = bodyItem.createChild({tag:'tbody'});
	}
	var firstTr;
	if(Ext.isIE && !tbodyItem.first()){
		firstTr = document.createElement("tr");
		tbodyItem.dom.appendChild(firstTr);
	}
	var rowCls = 'x-grid3-row';
	var rowCount = grid.select('.x-grid3-row').getCount();
	if (rowCount % 2 == 0) {
		rowCls += ' x-grid3-row-alt';
	}
	var trItem = tbodyItem.createChild({tag:'tr',cls:rowCls
		,onmouseover:'LegoTag.gridOver(this,event)'
		,onmousedown:'LegoTag.gridDown(this,event)',onmouseout:'LegoTag.gridOut(this,event)'
		,html:'<td></td>'});
	if(grid.dom.getAttribute("checkbox")!="none"){
		trItem.createChild({tag:'td',tabindex:0,width:20,
			cls:'x-grid3-td-checker',width: '20px',
			html:'<div class="x-grid3-row-checker" onmousedown="LegoTag.gridSelectCheck(this,event)">&#160;</div>'});
	}
	var rows= o;
	for(var i=0;i<rows.length;i++){
		var row = rows[i];
		var cfg = {
				tag:'td',
				cls:'x-grid3-table-cell'
			};
		if(row.name){
			cfg.name=row.name;
		}
		if(row.width){
			cfg.width=row.width;
		}
		if(row.hidden){
			cfg.style={display:'none'};
		}
		if(row.title){
			cfg.title=row.title;
		}
		if(row.value){
			cfg.value=row.value;
		}
		if(row.body){
			cfg.html=row.body;
		}else{
			cfg.html='&nbsp';
		}
		if(row.align){
			cfg.align=row.align;
		}
		trItem.createChild(cfg);
	}
	trItem.first().remove();
	if (firstTr) {
		tbodyItem.dom.removeChild(firstTr);
	}
	if(Ext.get(gridId).parent().next()){
		Ext.get(gridId).parent().next().dom.style.display="none";
	}
}
LegoTag.insertGridItem = function (grid,index,o){
	if(index<1){
		return;
	}
	grid = Ext.fly(grid);
	var rowCount = grid.select('.x-grid3-row').getCount();
	if(index > rowCount){
		LegoTag.addGridItem(grid,o);
		return;
	}
	
	var bodyItem = grid;
	var tbodyItem = bodyItem.first();
	if(!tbodyItem){
		tbodyItem = bodyItem.createChild({tag:'tbody'});
	}
	
	var rowCls = 'x-grid3-row';
	if (index % 2 == 0) {
		rowCls += ' x-grid3-row-alt';
	}
	var insertRow = grid.select('.x-grid3-row').item(index-1);
	
	var trItem =Ext.DomHelper.insertBefore(insertRow, {tag:'tr',cls:rowCls
			,onmouseover:'LegoTag.gridOver(this,event)'
				,onmousedown:'LegoTag.gridDown(this,event)',onmouseout:'LegoTag.gridOut(this,event)'
				,html:'<td></td>'});
	 
	trItem = Ext.fly(trItem);
	if(grid.dom.getAttribute("checkbox")!="none"){
		trItem.createChild({tag:'td',tabindex:0,width:20,
			cls:'x-grid3-td-checker',width: '20px',
			html:'<div class="x-grid3-row-checker" onmousedown="LegoTag.gridSelectCheck(this,event)">&#160;</div>'});
	}
	var rows= o;
	for(var i=0;i<rows.length;i++){
		var row = rows[i];
		var cfg = {
				tag:'td',
				cls:'x-grid3-table-cell'
			};
		if(row.name){
			cfg.name=row.name;
		}
		if(row.width){
			cfg.width=row.width;
		}
		if(row.hidden){
			cfg.style={display:'none'};
		}
		if(row.title){
			cfg.title=row.title;
		}
		if(row.value){
			cfg.value=row.value;
		}
		if(row.body){
			cfg.html=row.body;
		}else{
			cfg.html='&nbsp';
		}
		
		trItem.createChild(cfg);
	}
	trItem.first().remove();
	var rows = grid.select('.x-grid3-row')
}

LegoTag.updateGridItem = function (grid,index,o){
	if(index>0){
		index--;
	}
	grid = Ext.fly(grid);
	var trs = grid.select('.x-grid3-row');
	var rows= o;
	if(index < trs.getCount()){
		var tr = trs.item(index);
		var tds = tr.select('.x-grid3-table-cell');
		var len = tds.getCount();
		if(rows.length < len){
			len = rows.length;
		}
		for(var i=0;i<len;i++){
			var td = tds.item(i).dom;
			if(rows[i].name){
				td.setAttribute("name",rows[i].name);
			}
			else
			{
				td.setAttribute("name","");
			}
			if(rows[i].value){
				td.setAttribute("value",rows[i].value);
			}
			else
			{
				td.setAttribute("value","");
			}
			if(rows[i].width){
				td.setAttribute("width",rows[i].width);
			}
			if(rows[i].hidden != undefined){
				td.setAttribute("style","display:"+(rows[i].hidden?'none':''));
			}
			if(rows[i].title){
				td.setAttribute("title",rows[i].title);
			}
			else
			{
				td.setAttribute("title","");
			}
			if(rows[i].body){
				td.innerHTML = rows[i].body;
			}
			else
			{
				td.innerHTML = "";
			}
		}
	}
}
LegoTag.isUpdateCol = function(column,o){
	for (colName in o) {
		if (colName == column.name) {
			return true;
		}
	}
	return false;
}
LegoTag.sortGridByColumn = function(hd,gridId)
{
  if(!sortFlag){
	var sortField = hd.getAttribute("sortfield");
	if (!sortField) {
		return;
	}
	var sortPostForm = hd.getAttribute("sortForm");
	var sortType = hd.getAttribute("sortType");
	if (sortType == "asc") {
		sortType = "desc";
	}else{
		sortType= "asc";
	}
	var currUrl = window.location + "";
	var urlPara = window.location.search;
	var urlObj = {};
	if (urlPara) {
		urlObj = Ext.urlDecode(urlPara.substring(1),true);
	}
	if(urlObj.start){
		delete urlObj.start;
	}
	urlObj["sortField"] = sortField;
	urlObj["sortType"] = sortType;
	var reslutUrl = "?" + Ext.urlEncode(urlObj);
	if (!sortPostForm) {
		window.location = reslutUrl;
	} else {
		var submitForm = document.getElementById(sortPostForm);
		if (!submitForm) {
			submitForm = document.createElement("form");
			document.body.appendChild(submitForm);
		}
		submitForm.action = reslutUrl;
		submitForm.method = "post";
		submitForm.submit();
	}
  }
  sortFlag=false;
}

LegoTag.popGridDownList  = function(hd){	
  var canHiddenColumnCls = "cell-spliter";
  var selectCls = "x-combo-selected";
  var wrap = ".row-downlist li";
  var allCanHiddenColumn = Ext.get(hd).next().select("."+canHiddenColumnCls);
  if(Ext.select("ul.row-downlist")){
	  Ext.select("ul.row-downlist").remove();
  }
  var donwList = document.createElement("ul");
  donwList.id = "x-grid-lego-downListId"; 
  donwList.className ="row-downlist"  ;
  for(var k = 0 ; k < allCanHiddenColumn.getCount() ;){
	  var flag  = !allCanHiddenColumn.item(k).dom.getAttribute("style") || allCanHiddenColumn.item(k).dom.getAttribute("style") && allCanHiddenColumn.item(k).dom.style.display!="none";	
	  if(flag){
		 var li =  document.createElement("li");
		  li.id = "li" + k ;
		  if(allCanHiddenColumn.item(k).hasClass("x-hide-display")){
		  li.innerHTML = "<label for='downList-input"+k+"'><input type='checkbox'  id='downList-input"+k+"' />"+ allCanHiddenColumn.item(k).last("",true).innerHTML+"</label>";  
		  }else{
		  li.innerHTML = "<label for='downList-input"+k+"' class='"+selectCls+"'><input type='checkbox' checked='true' id='downList-input"+k+"' />"+ allCanHiddenColumn.item(k).last("",true).innerHTML+"</label>";
		  }
		  Ext.get(donwList).appendChild(li);
	  } 	
	  k++ ;
  }
  
   document.body.appendChild(donwList);
   var ulObj = Ext.get(donwList.id);
   ulObj.setX(Ext.get(hd).getX()-110);
   ulObj.setY(Ext.get(hd).getY()+ 20);
   
   Ext.select(wrap).on("mouseover", 
		 function(e){
	      Ext.get(e.getTarget()).findParent("li",null ,true).addClass(selectCls);	     
   }, this);
   
   Ext.select(wrap).on("mouseout", 
		 function(e){
	      Ext.get(e.getTarget()).findParent("ul",null ,true).select("li."+selectCls).removeClass(selectCls);	      
   }, this);
   
   Ext.select(wrap).on("click", 
	  function(e){       
	   if(e.getTarget().tagName.toLowerCase()=="input"){
		   var input = e.getTarget();
		   if(input.checked){
			   Ext.get(e.getTarget()).findParent("label",null ,true).addClass(selectCls);
		   }else{
			   Ext.get(e.getTarget()).findParent("li",null ,true).select("label."+selectCls).removeClass(selectCls); 
		   }
	   }
	   LegoTag.hideColumnHandle(gridId);
	   e.stopPropagation();
	       
   }, this);
   
   var gridObj = Ext.get(hd).next().dom;
   var gridId = gridObj.id ;
   
  var currentWindow = window ; 
  do{
    currentWindow.Ext.getDoc().on("click",function(e){LegoTag.hideGridDownList(e,donwList.id)},this);
    currentWindow = currentWindow.parent ;
  	}while(currentWindow != window.top)
	  top.Ext.getDoc().on("click",function(e){LegoTag.hideGridDownList(e,donwList.id)},this);
}
LegoTag.hideGridDownList = function(e,id){
	   var num = 0 ;
	   if(e.target.id == id || Ext.get(e.target).hasClass("x-grid-trigger-over")){ 
		   num ++;
	   }
	   if(num != 0){
		   return;
	   }else{
		   var list = document.getElementById(id)
			if(list){
				Ext.get(id).setVisible(false);
			}
	   }			
}
LegoTag.hideColumnHandle = function(tableId){
	var downListId = "x-grid-lego-downListId";
	var indexArr = LegoTag.getSelectedDownListInx(downListId); 
	var tableObj = Ext.get(tableId);
	var pageTb = tableObj.next(".x-page-toolbar-table",null,true);
	if(pageTb){
		pageTb.dom.setAttribute("hideIndex",indexArr);
	}
	LegoTag.hideColumnByIndex(tableId,indexArr);
}
LegoTag.hideColumnByIndex = function(tableId ,indexArr){
	var tableObj = Ext.get(tableId);
    var hideCls = "x-hide-display" ,rowcCellCls="cell-spliter", bodyCellCls="x-grid3-table-cell";
	var length = indexArr.length;	
	tableObj.select("."+hideCls).removeClass(hideCls);
	var targetsHead = tableObj.query("."+rowcCellCls);
	for(var k = 0 ;k < length ; k++){
	targetsHead[indexArr[k]].className = rowcCellCls+" "+hideCls ;	
	var rowsLength = tableObj.select(".x-grid3-row").getCount()+1;
	 for(var z = 1 ; z < rowsLength ; z++){
		var tempTr = tableObj.select("tr");
		tempTr.item(z).query("."+bodyCellCls)[indexArr[k]].className = bodyCellCls+" "+hideCls ;
	 }
	}	
}
LegoTag.getSelectedDownListInx = function(downListId){
	var arr=[];
	var inputsEl = Ext.get(downListId).select("li input");
	for(var m = 0 ; m <inputsEl.getCount(); m++){
		if(!inputsEl.item(m).dom.checked){
			var inputsElId = inputsEl.item(m).dom.id.substring(14);
			arr.push(inputsElId);
		}
	}
	return arr;
}

LegoTag.setTreeGridWrap = function(src){
	var hiddenCls = "x-hide-display";
	var tableTarget = Ext.get(src).findParent("div",null,true).next();
	if(tableTarget.hasClass(hiddenCls)){
		tableTarget.removeClass(hiddenCls);
		Ext.get(src).removeClass("wrap-icon-on").addClass("wrap-icon");
	}else{
		tableTarget.addClass(hiddenCls);
		Ext.get(src).addClass("wrap-icon-on").removeClass("wrap-icon");
	}
	
}

LegoTag.treeGridOver = function (e2,ev){
	var e = window.event||ev;
	var rowTarget = Ext.fly(e2);
	if (rowTarget) {
		if (rowTarget.hasClass("x-item-disabled")) {
			return false;
		}
		rowTarget.addClass("x-grid3-row-over");
	}
 }
LegoTag.treeGridOut = function (e2,ev){
	var e = window.event||ev;
	var rowTarget = Ext.fly(e2);
	if (rowTarget.hasClass("x-item-disabled")) {
		return false;
	}
	rowTarget.removeClass("x-grid3-row-over");
}

LegoTag.treeGridSelectAll = function(t){
	 var hd = Ext.fly(t).findParent(".x-grid3-treehd-row",null,true); 
	 var isChecked = hd.hasClass('x-grid3-hd-checker-on');
	 var headClass = "x-grid3-hd-checker-on";
	 var checkDao;
	 if(isChecked){
	        checkDao = "removeClass";
	  }else{
	    	checkDao = "addClass"
	  }
	  eval("hd."+ checkDao +"(headClass)");
	    var gridsWraper = hd.next().select(".x-treegrid-headline");
	    for(var i = 0 ; i < gridsWraper.getCount(); i++){
	    	var rowItem = 	gridsWraper.item(i);
		    while(rowItem){
					eval("rowItem."+ checkDao +"(headClass)");
				rowItem = rowItem.next();
		}
	 }
	    if(t.onselect){
			if (Ext.isIE) {
				eval(t.onselect)
			} else {
				t.onselect.call()
			}
	  }	    
}

LegoTag.treeGridSelectCheck = function(e2,e1) {
	var checkOnCls = "x-grid3-hd-checker-on";
	var mainTarget = Ext.fly(e2);
	var grid = mainTarget.findParent(".x-grid3-tree-grid-warp",null,true);
	var rowChecker = grid.select(".x-treegrid-headline");
	var len = rowChecker.getCount();
	if(mainTarget.parent().hasClass(checkOnCls)){
		mainTarget.parent().removeClass(checkOnCls);
	}else{
		mainTarget.parent().addClass(checkOnCls);
	}
	if(len>0) {
		var rowFlag=true;
		for(var i=0;i<len;i++){

			if(!rowChecker.item(i).hasClass(checkOnCls)){
				rowFlag=false;
				break;
			}
		}
		var headChecker = grid.parent().prev();
		if(rowFlag){
			headChecker.addClass(checkOnCls);
		}else {
			headChecker.removeClass(checkOnCls);
		}
	}
	if(mainTarget.dom.onselect){
		if (Ext.isIE) {
			eval(mainTarget.dom.onselect)
		} else {
			mainTarget.dom.onselect.call()
		}
 	}
}

LegoTag.treeGridMutex = function(target){
	var hiddenCls = "x-hide-display";
	var target = Ext.fly(target);
	var topContainer = target.findParent(".x-grid3-tree-grid-warp",null,true);
	var tableTarget = target.findParent("div",null,true).next();	
		var childss = topContainer.select("table.x-grid3-table");
		for(var k = 0 ; k < childss.getCount(); k++){
			if(childss.item(k).dom.id != tableTarget.dom.id){
				childss.item(k).addClass(hiddenCls);
				childss.item(k).prev().select("span.wrap-icon").removeClass("wrap-icon").addClass("wrap-icon-on");
			}		
		}	
}
LegoTag.treeGridAutoResize = function(obj){
  var widthArr = [];
  var hiddenCls = "x-hide-display";
  var mainTreeGrid = Ext.get(obj);
  if(!mainTreeGrid){
	  return;
  }
  var hiddenAllTables = true; 
  var hiddenCls = "x-hide-display";
  var hds = mainTreeGrid.select(".x-grid3-treehd-row .cell-spliter");
  var tdParent = mainTreeGrid.select("table.x-grid3-table").item(0);
  if(!tdParent){
	  return ;
  }
  if(mainTreeGrid.select("table.x-grid3-table").getCount() == mainTreeGrid.select("table.x-hide-display").getCount()){
	  hiddenAllTables = false ;
  }
  if(!tdParent.select(".x-grid3-row").item(0)){
	  return;
  }
  var tds = tdParent.select(".x-grid3-row").item(0).select(".x-grid3-table-cell");
  for(var z =0  ; z<tds.getCount(); z++){
	  if(tds.item(z).dom.className.indexOf("x-grid3-table-cell-hidden")!=-1){  
		  continue ;		 
	  }else{
		  widthArr.push(z)		  
	  }	  
  }
  for(var m = hds.getCount()-1 ; m >0; m --){
	  var index = widthArr.length ;
	  if(hiddenAllTables){
		  hds.item(m).setWidth(tds.item(widthArr[widthArr.length-1]).getWidth());
		  widthArr.pop();
	  }else{
		  hds.item(m).setWidth("auto");
	  }

  } 
}
LegoTag.treeGridCollapsed = function(obj){
	  var mainTreeGrid = Ext.get(obj);
	  var hiddenCls = "x-hide-display";
	  if(mainTreeGrid.dom.getAttribute("collapsed") && mainTreeGrid.dom.getAttribute("collapsed")=="true"){	  
	  mainTreeGrid.select(".x-grid3-tree-grid-warp table.x-grid3-table").addClass(hiddenCls);
	  mainTreeGrid.select("span.wrap-icon").removeClass("wrap-icon").addClass("wrap-icon-on");
	  }	
}
LegoTag.getTreeGridAllDate = function(src){
	var arr = {};
	var titles = Ext.fly(src).select(".x-treegrid-headline .x-grid-headline");
	if(titles){
	for(var m = 0 ; m < titles.getCount();m++){
		var title = titles.item(m).dom.getAttribute("title");
		var value = titles.item(m).first("",true).value;
		arr[value] = title;
	}
  }
	return arr;
}

LegoTag.getTreeGridSelectedData = function(src){
	var json = {}
	var titlesFarther = Ext.fly(src).select(".x-treegrid-headline");
	for(var k = 0 ; k < titlesFarther.getCount(); k ++){
		if(titlesFarther.item(k).hasClass("x-grid3-hd-checker-on")){
			var childObj = titlesFarther.item(k).select(".x-grid-headline");
			var title = childObj.item(0).dom.getAttribute("title");;
			var value = childObj.item(0).first("",true).value;
			json[value] = title;
		}
	}
	return json;
}

LegoTag.getTreeGridTitle = function(src){
	var title ;
    if(Ext.fly(src).prev("",true)){
    title = Ext.fly(src).prev("",true).getAttribute("title");
   }
  return  title;
}

LegoTag.setTreeGridTitle = function(src,title){
    if(Ext.fly(src).prev("",true)){
    Ext.fly(src).prev("",true).setAttribute("title",title);
   }
}
var startLen=0;
var endLen=0;
var oBject="";
var minLength=45;
var sortFlag=false;
var parentLength=0;
LegoTag.mouseMove = function(src, e1) {
	sortFlag=true;
	var tableObj = Ext.get(src).parent().prev();
	while(tableObj!=null && tableObj.getStyle('display') == 'none'){
		tableObj=tableObj.prev();
	}
	if (tableObj !=null && tableObj.hasClass('cell-spliter')) {
		
		oBject = tableObj;
		var parentTable = Ext.get(src).findParent("table",null,true) ;
		var gridHeight = parentTable.getComputedHeight();
		parentTable.select(".x-grid3-hd-row").unselectable(); 
		var gridTop = parentTable.getY();

		var e = e1 || event;
		var x = e.x || e.pageX;
		startLen = x;
		endLen = x;
		var movingBar = document.createElement('div');
		document.body.appendChild(movingBar);
		movingBar.id = "movingBar";
		with (movingBar.style) {
			position = 'absolute';
			left = x + 'px';
			top = gridTop + 'px';
			width = 2;
			height = gridHeight + 'px';
			backgroundColor = '#aaaaaa';
			zIndex = 999;
			cursor = 'col-resize';
		}
		document.onmousemove = moveGrid;
		document.onmouseup = endGrid;
	}
}

function moveGrid(e1) {

	var e = e1 || event;
	var x = e.pageX || e.x;
	Ext.lib.Event.stopEvent(e);
	var movingBar = document.getElementById('movingBar');
	movingBar.style.left = x;
	endLen = x;
}
function endGrid() {
	
	document.onmousemove = null;
	document.onmouseup = null;
	var moveLength = endLen - startLen;
	var nextObject = oBject;
	repeatGrid(nextObject, moveLength);
	var movingBar = document.getElementById('movingBar');
	document.body.removeChild(movingBar);
}

function repeatGrid(nextObject, moveLength) {
	var nextDisPlayLength=0;
	if (nextObject != null) {
		if (oBject.getWidth() + moveLength < minLength) {
			var nextDisplay=oBject.next();
			
			while(nextDisplay != null && nextDisplay.getStyle('display') == 'none'){
				
				nextDisplay=nextDisplay.next();
			}
			nextDisplay.setWidth(
					nextDisplay.getWidth() + oBject.getWidth()
							- minLength);
			oBject.setWidth(minLength);
		} else if (moveLength > 0) {
			var nextDisplay=nextObject.next();
			while(nextDisplay != null && nextDisplay.getStyle('display') == 'none'){
				nextDisplay=nextDisplay.next();
			}
			if (moveLength > nextDisplay.getWidth() - minLength) {
				var middleObject = nextDisplay.next();
				while(middleObject != null && middleObject.getStyle('display') == 'none'){
					middleObject=middleObject.next();
				}
			    if(middleObject !=null){
			        moveLength=moveLength-nextDisplay.getWidth()
						+ minLength;
			        oBject.setWidth(oBject.getWidth() + nextDisplay.getWidth()
						- minLength);
			        nextDisplay.setWidth(minLength);
					repeatGrid(nextDisplay, moveLength);
			    }else{
				oBject.setWidth(oBject.getWidth() + nextDisplay.getWidth()
						- minLength );
				nextDisplay.setWidth(minLength);

               }
			} else {
				var nextDisPlayLength=oBject.getWidth();
				nextDisplay.setWidth(nextDisplay.getWidth() -moveLength);
				oBject.setWidth(nextDisPlayLength + moveLength);
			}
		} else {
			var nextDisplay=oBject.next();
			while(nextDisplay != null && nextDisplay.getStyle('display') == 'none'){
				nextDisplay=nextDisplay.next();
			}
			nextDisPlayLength=nextDisplay.getWidth();
			oBject.setWidth(oBject.getWidth() + moveLength);
			nextDisplay.setWidth(nextDisPlayLength - moveLength);
		}
	}
}
