var flag1 = false;
LegoTag.checkIpv4 = function(str) {
	var regex = /^((22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[0-9]\d|[0-9]))?$/;
	return regex.test(str);
}

LegoTag.checkIpv6 = function(str) {
	var Ipv6text = /:/.test(str) && str.match(/:/g).length < 8 && /::/.test(str) 
	             ? (str.match(/::/g).length == 1 && /^::$|^(::)?([\da-f]{1,4}(:|::))*[\da-f]{1,4}(::)?$/i.test(str))
			     : /^([\da-f]{1,4}:){7}[\da-f]{1,4}$/i.test(str);
	return Ipv6text;
}
LegoTag.isIpv4 = function(src ,exceptMask) {
    if(!src){
		return false;
	}
	var str = src;
	if(typeof(src) == "string"){
	    str = Ext.get(src);
	}
	if(!str || str.dom.disabled){
	    return false;
	}
	str = str.getValue();
	if(exceptMask && exceptMask == true)
	{
	  var idx = str.indexOf("/");
	  if(idx > -1){
	    str = str.substr(0 , idx);
	  }
	}
	return LegoTag.checkIpv4(str);
}
LegoTag.isIpv6 = function(src ,exceptMask) {
    if(!src){
		return false;
	}
	var str = src;
	if(typeof(src) == "string"){
	    str = Ext.get(src);
	}
	if(!str || str.dom.disabled){
	    return false;
	}
	str = str.getValue();
	if(exceptMask && exceptMask == true)
	{
	  var idx = str.indexOf("/");
	  if(idx > -1){
	    str = str.substr(0 , idx);
	  }
	}
	return LegoTag.checkIpv6(str);
}
LegoTag.getSubnetRange = function( ipAddr, subnetMask) {
	 var numReg = /^[1-9]\d*$/;
	 var type , hostAddr ,subnetAddr ,subMask ,broadCastAddr;
	 var ipv4Reg = /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/i;
	 
	 if(ipv4Reg.test(ipAddr)){
	 
	    type = "ipv4";
	    hostAddr = LegoTag.ip2Binary(ipAddr);
	 
	  }else if(LegoTag.checkIpv6(ipAddr)){
	 
	    type = "ipv6";
	    ipAddr = LegoTag.convert2CompleteIpV6(ipAddr);
	    hostAddr = LegoTag.ip2Binary(ipAddr);

	  }else{
	  
	    return " ip format error,it is neither ipv4 address nor ipv6 address.";
	 }
	 
	
	 if(numReg.test(subnetMask))
	 {  
	 
	   if(type == "ipv4" && subnetMask > 32 )
	    {
	       return "ipv4地址与掩码无可用ip地址匹配。["+ipAddr+"/"+subnetMask+"]";
	    }
	    else if(type == "ipv4" && subnetMask > 128 )
	    {
	      return "ipv6地址与掩码无可用ip地址匹配。["+ipAddr+"/"+subnetMask+"]";
	    }
	    subMask = LegoTag.getSubnetMaskBinary(subnetMask , type);
	 }
	 else
	 {
	   if(ipv4Reg.test(subnetMask)){
	   
	   
	   }else if(LegoTag.checkIpv6(subnetMask)){
	   
	     return "IPv6 掩码不支持字符串，只支持数字格式。";
	   
	   }else{
	   
	     return "IPv4掩码支持数字、字符串格式，IPv6掩码只支持数字格式。";
	   
	   }
	 }
	 subnetAddr = LegoTag.getSubnetAddrByIPAndMask(hostAddr , subMask , type);
	 broadCastAddr = LegoTag.getBroadCastAddrByIPAndMask(subnetAddr , subMask , type);
	 var firstIP = "" ,lastIP = "" , ipSegment;
	 
	if(type == "ipv4"){
	      
	  for(var i = 0; i < 4; i++ ){
	      ipSegment = parseInt(subnetAddr.substr(8*i,8),2);
	      if(i == 3){
	      }else{
	         ipSegment += ".";
	      }
	      firstIP += ipSegment;
	    }
	    
	   for(var i = 0; i < 4; i++ ){
	      ipSegment = parseInt(broadCastAddr.substr(8*i,8),2);
	      if(i == 3){
	      }else{
	         ipSegment += "."
	      }
	      lastIP += ipSegment;
	    }
    
    }else if(type == "ipv6"){
       var c;
       for(var i = 0; i < 8; i++ ){
          c = subnetAddr.substr(16*i,16);
	      if(i == 7){
	         ipSegment = parseInt(c,2);
	         ipSegment = ipSegment.toString(16);  
	         
	      }else{
	         ipSegment = parseInt(c,2);
	         ipSegment = ipSegment.toString(16);
	         ipSegment += ":";
	      }
	      firstIP += ipSegment;
	    }
	    
	   for(var i = 0; i < 8; i++ ){
	      c = broadCastAddr.substr(16*i,16);
	      if(i == 7){
	         ipSegment = parseInt(c,2);
	         ipSegment = ipSegment.toString(16);
	         
	      }else{
	         ipSegment = parseInt(c,2);
	         ipSegment = ipSegment.toString(16);
	         ipSegment += ":"
	      }
	      lastIP += ipSegment;
	    }
      
    }

    var retArray = new Array(2);
    retArray[0] = LegoTag.compressIPv6(firstIP);
    retArray[1] = LegoTag.compressIPv6(lastIP);
    
    return retArray;
}

LegoTag.compressIPv6 = function(ip){
    if(!LegoTag.checkIpv6(ip)){
       return ip;
    }
    
    ip = LegoTag.convert2CompleteIpV6(ip);
    
    var t;
    var ipArray = ip.split(":");
    for(var i = 0; i < ipArray.length ; i++){
      t = parseInt(ipArray[i] , 16);
      ipArray[i] = t.toString(16);
    }
    ip = ipArray.join(':');
    
    var s;
	var pt = -1;
	var cn = 0;
	var map = new LegoTag.SimpleMap();
	for(var i = 0; i< ipArray.length; i++){
		s = ipArray[i];
	    if("0" == s){
	        if(cn == 0){
	           pt = i;
	           map.put(pt , 0);
	         }
	         cn ++;	
		  }else{
		    if(cn > 0){
		        map.put(pt, cn);
		      }
		      if(i != ipArray.length - 1){
		        pt = -1;
		        cn = 0;
			   }
			}
		if( i == ipArray.length - 1){
				if(map.containsKey(pt)){
					map.put(pt, cn);
				}
			}
		}
		var outArray = new Array(map.size());
		var keys  = map.keys();
		var values = map.values();
		for(var i = 0;  i< map.size(); i++){
		   outArray[i] = new Array(keys[i],values[i]);
		}
		outArray.sort(function(x , y){
		   return y[1] - x[1];
		});
		for(var i = 0;  i< outArray.length; i++){
		   var ar = outArray[i]
		   var key = ar[0];
		   var value = ar[1];
		   if(value == 1){
		     continue;
		   }
		   var adx = 0;
		   var bdx = 0;
		   for(var i = 0 ; i< key ; i++){
				adx += ipArray[i].length;
				adx += 1;
			}
			bdx = adx + 2*value;
			
			
			
			if(key + value  == 8 &&  key == 0){
				ip = "::";
			}else if(key == 0){
				ip = "::"+ ip.substring(bdx);
			}else if(key + value  == 8){
				ip = ip.substring(0 , adx)+":";
			}else{
				var a = ip.substring(0 , adx);
				var b = ip.substring(bdx);
				ip = a + ":" + b;
			}
			
			break;
		}
		return ip;

}
LegoTag.getSubnetAvailableRange = function(ipAddr, subnetMask) {
   var sr = LegoTag.getSubnetRange( ipAddr, subnetMask);
   if(typeof sr == "string"){
      return sr;
   }
   else if(typeof sr == "object")
   {
     var subnetAddr_b = LegoTag.ip2Binary(sr[0]);
     var  broadCastAddr_b = LegoTag.ip2Binary(sr[1]);
     var type ,firstAvailableIP = "" ,lastAvailableIP = "" , ipSegment;
     
     var ipv4Reg = /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/i;
     if(ipv4Reg.test(ipAddr)){
	   for(var i = 0; i < 4; i++ ){
	      ipSegment = parseInt(subnetAddr_b.substr(8*i,8),2);
	      if(i == 3){
	         ipSegment += 1;
	      }else{
	         ipSegment += ".";
	      }
	      firstAvailableIP += ipSegment;
	    }
	    
	   for(var i = 0; i < 4; i++ ){
	      ipSegment = parseInt(broadCastAddr_b.substr(8*i,8),2);
	      if(i == 3){
	         ipSegment -= 1;
	      }else{
	         ipSegment += "."
	      }
	      lastAvailableIP += ipSegment;
	    }
	    
	  }else if(LegoTag.checkIpv6(ipAddr)){
		 var c;
	     for(var i = 0; i < 8; i++ ){
	          c = subnetAddr_b.substr(16*i,16);
		      if(i == 7){
		         ipSegment = parseInt(c,2);
		         ipSegment += 1;
		         ipSegment = ipSegment.toString(16);  
		      }else{
		         ipSegment = parseInt(c,2);
		         ipSegment = ipSegment.toString(16);
		         ipSegment += ":";
		      }
		      firstAvailableIP += ipSegment;
		    }
		    
		   for(var i = 0; i < 8; i++ ){
		      c = broadCastAddr_b.substr(16*i,16);
		      if(i == 7){
		         ipSegment = parseInt(c,2);
		         ipSegment -= 1;
		         ipSegment = ipSegment.toString(16)  
		      }else{
		         ipSegment = parseInt(c,2);
		         ipSegment = ipSegment.toString(16);
		         ipSegment += ":"
		      }
		      lastAvailableIP += ipSegment;
		    }
	  }else{
	    return  "ip format error.["+ipAddr+"/"+subnetMask+"]";	  
	  }
		
      var retArray = new Array(2);
      retArray[0] = LegoTag.compressIPv6(firstIP);
      retArray[1] = LegoTag.compressIPv6(lastIP);
    
	  return retArray;
	  
   }
   else
   {
     return "LegoTag.getSubnetAvailableRange function return error.";
   }
}
LegoTag.getNetworkSegment  = function (startip, endip){
     var resArray = new Array();
     var ipv4Reg = /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/i;
     var type;
     if(ipv4Reg.test(startip) && ipv4Reg.test(endip))
     {
       type = "ipv4"
     }
     else if(LegoTag.checkIpv6(startip) && LegoTag.checkIpv6(endip))
     {
       type = "ipv6"
     }
     else
     {
       return  "network segment format error.["+startip+" - "+endip+"]";
     }
     
     var startip_b = LegoTag.ip2Binary(startip);
     var endip_b   = LegoTag.ip2Binary(endip);
     
     var i = 0 , limit = 0 ,netMaskNum = 0 ,netMask = "",maskFlag = false;
	 if(type == "ipv4"){
	    limit = 32
	 }else if(type == "ipv6"){
	    limit = 128
	 }
    while(i != limit)
    {
       if(startip_b.substr(i,1) == endip_b.substr(i,1))
       {
          if(!maskFlag)
          {
             netMask += "1";
             netMaskNum++;
          }
          else
          {
             netMask += "0";
          }
       }
       else
       {
          maskFlag = true;
          netMask += "0";
       }
       i=i+1;
     }
     alert("startip_b: "+startip_b+"\nendip_b:  "+endip_b+"\nnetMask: "+netMask+"\netMaskNum: "+netMaskNum);
     
     var subnet = LegoTag.getSubnetRange(startip,netMaskNum);
     if(typeof subnet == 'string')
     {
        return subnet;
     }
     alert(subnet[1]);
     var res = LegoTag.compareTo(subnet[1],endip);
     alert("inner res: "+res);
     
     if(res == 0)
     {
        resArray.push(startip + "/" + netMaskNum );
        return resArray;
     }
     else if(res = 1)
     {
        resArray.push(startip + "/" + netMaskNum + 1);
        
        var nextMask = 0;
        for(var i = 1; i < limit - netMaskNum ; i++)
        {
           nextMask = netMaskNum + i;
           var ips = LegoTag.getSubnetRange(startip,nextMask);
           resArray.push(ips[0]+ "/" + nextMask )
        }
     }
     return resArray;
     
     
}
LegoTag.compareTo  = function (startip, endip){
     var ipv4Reg = /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/i;
     var type;
     if(ipv4Reg.test(startip) && ipv4Reg.test(endip))
     {
       type = "ipv4"
     }
     else if(LegoTag.checkIpv6(startip) && LegoTag.checkIpv6(endip))
     {
       type = "ipv6"
     }
     else
     {
       return  "network segment format error.["+startip+" - "+endip+"]";
     }
     
     var startip_b = LegoTag.ip2Binary(startip);
     var endip_b   = LegoTag.ip2Binary(endip);
     
     var i = 0 , a , b ;
	 if(type == "ipv4"){
	    limit = 32
	 }else if(type == "ipv6"){
	    limit = 128
	 }
    while(i != limit)
    {
       a = startip_b.substr(i,1);
       b = endip_b.substr(i,1);
       if(a > b)
       {
         return 1;
       }
       else if(a < b)
       {
         return -1;       
       }
       if(i == (limit - 1))
       {
          if(a == b)
          {
           return 0;
          }
       }
       i=i+1;
     }
}

LegoTag.getNextIP  = function (ip){
     var ipv4Reg = /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/i;
     var ip_b = LegoTag.ip2Binary(ip);
     var result = "" , ipSegment;
     if(ipv4Reg.test(ip))
     {
	    for(var i = 0; i < 4; i++ ){
	      ipSegment = parseInt(ip_b.substr(8*i,8),2);
	      if(i == 3){
		     if(ipSegment < 255)
		     {
		      ipSegment += 1;
		     }
	      }else{
	         ipSegment += ".";
	      }
	      result += ipSegment;
	    }
     }
     else if(LegoTag.checkIpv6(ip))
     {
        var c;
	    for(var i = 0; i < 8; i++ ){
          c = ip_b.substr(16*i,16);
	      if(i == 7){
	         ipSegment = parseInt(c,2);
	         ipSegment += 1;
	         ipSegment = ipSegment.toString(16);  
	      }else{
	         ipSegment = parseInt(c,2);
	         ipSegment = ipSegment.toString(16);
	         ipSegment += ":";
	      }
	      result += ipSegment;
	    }
	    result = LegoTag.compressIPv6(result); 
     }
     else
     {
       return  "network segment format error.["+ip+"]";
     }
     
     return result;
     

 }
LegoTag.binaryToHex = function (binary){
  if(!binary){
    return;
  }
  var c = parseInt(binary , 2);
  var retVal;
  switch(c){
    case 10:
       retVal = 'A';
       break;
    case 11 :
       retVal = 'B';
       break;
    case 12 :
       retVal = 'C';
       break;
    case 13 :
       retVal = 'D';
       break;
    case 14 :
       retVal = 'E';
       break;
    case 15 :
       retVal = 'F';
       break;
    default:
       retVal = c.toString();
       break;
  }
  return retVal;
}
LegoTag.getSubnetMaskBinary = function(num , type) {
    var mask="";
    var i = 0 , limit = 0;
    if(type == "ipv4"){
      limit = 32;
    }else if(type == "ipv6"){
      limit = 128;
    }
    while(mask.length != num)
    {
        i++;
        mask = "1" + mask;
    }
   
   while(mask.length != limit)
    {
        mask += "0";
    }
    return mask;
}
LegoTag.getSubnetAddrByIPAndMask = function(hostAddr , subnetMask , type) {
    var i = 0 , limit = 0 ,subnetAddr = "";
    if(type == "ipv4"){
      limit = 32;
    }else if(type == "ipv6"){
      limit = 128;
    }
    while(i != limit)
    {
       if(hostAddr.substr(i,1)=="1" && hostAddr.substr(i,1) == subnetMask.substr(i,1))
       {
          subnetAddr += "1";
       }
       else
       {
          subnetAddr += "0";
       }
       
       i=i+1;
       }
   return subnetAddr;
}
LegoTag.getBroadCastAddrByIPAndMask = function(hostAddr , subnetMask , type) {
    var i = 0 , limit = 0 ,broadCastAddr = "";
    if(type == "ipv4"){
      limit = 32
    }else if(type == "ipv6"){
      limit = 128
    }
    while(i != limit)
    {
       if(hostAddr.substr(i,1) == subnetMask.substr(i,1))
       {
          broadCastAddr += "1";
       }
       else
       {
          broadCastAddr += "0";
       }
       
       i=i+1;
     }
   return broadCastAddr;
}
LegoTag.ip2Binary = function(ip) {
	 var ipv4Reg = /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/i;
	 var ipArray , result = "";
	 if(ipv4Reg.test(ip)){
		  ipArray = new Array(4);
		  ipArray = ip.split(".");
		  for(var i = 0; i < ipArray.length ; i++){
		    ipArray[i] = Number(ipArray[i]);
		    result += LegoTag.left0(ipArray[i].toString(2) , 8);
		  }
	 }else if(LegoTag.checkIpv6(ip)){
	      ipArray = new Array(8);
	      ip = LegoTag.convert2CompleteIpV6(ip);
		  ipArray = ip.split(":");
		  for(var i = 0; i < ipArray.length ; i++){
		    ipArray[i] = Number("0x" + ipArray[i]);
		    result += LegoTag.left0(ipArray[i].toString(2) , 16);
		  }
	 }
	 return result;
}
LegoTag.left0 = function(num ,len) {
     if(!len){
       return "";
     }
     while(num.length != len)
        {
            num = "0" + num;
        }
        return num;
}
LegoTag.convert2CompleteIpV6 = function(ip){
        var ipV6 = ip;
        var index = ip.indexOf("::");
        if(index > 0){
            var s = ip.split(":");
	        var len = 0;
	        for(var i = 0 ; i< s.length; i++){
	        	if('' == s[i]){
	        	  continue;
	        	}
	        	++len;
	        }
	        var size = 8-len;
	        var tmp = "";
	        for(var i = 0; i<size; i++){
	          tmp += ":0";
	        }
	        if(ip.length - 2 != index){
	           tmp += ":";
	         }
	         ipV6 = ip.replace("::",tmp);
        }else if(index == 0){
           if(ip.length == 2){
              ipV6 = ip.replace("::","0:0:0:0:0:0:0:0");
           }else{
           
            var s = ip.split(":");
        	var len = 0;
        	for(var m in s){
        		if(m == ''){
        		  continue;
        		}
        		++len;
        	}
        	var size = 8-len;
        	var tmp = "";
            for(var i = 0; i<size; i++){
                tmp += "0:";
            }
            ipV6 = ip.replace("::","0:0:0:0:0:0:0:");
           }
        }
        return ipV6;
    }
LegoTag.setIpHidden = function(src,ev){	 
	var arr = new Array(4) ;
	var selector = Ext.fly(src).parent().query('input');
	arr[0] = selector[0].value;
	arr[1] = selector[1].value;
	arr[2] = selector[2].value;
	arr[3] = selector[3].value;	
	var lastObj  = selector[4];
	lastObj.value  = arr.join(".");
	if(lastObj.value=="..."){
		lastObj.value= "";		
	}
}

LegoTag.keyupIpEvent = function (src,ev){
	    var target = Ext.fly(src);
		var allowed = "0123456789";
		var e = ev || event;
		var k = e.keyCode;
		var isSpecialKey = (e.type == 'keydown' && e.ctrlKey) || k == 9 || k == 13
				|| k == 40 || k == 27 || (k == 16) || (k == 17)
				|| (k >= 18 && k <= 20) || (k >= 33 && k <= 35)
				|| (k >= 36 && k <= 39) || (k >= 44 && k <= 45);
		if (isSpecialKey || k == 8 || k == 46) {
		 	 if( k== 37 || k == 38){
		 	 		if((src.value=="" ||LegoTag.getCursorPosition(src).end ==0) && Ext.fly(src).prev()){
		 	 		  LegoTag.setCursorPosition(target.prev().dom,target.prev().dom.value.length);
		 	 		  Ext.lib.Event.stopEvent(e);
		 	 		 }else{
		 	 			target.focus(); 
		 	 		 } 
		 	 }
		 	 if(k == 8){
		 		if((src.value=="" ||LegoTag.getCursorPosition(src).end ==0) && Ext.fly(src).prev()){
		 	 		  LegoTag.setCursorPosition(target.prev().dom,target.prev().dom.value.length);
		 	 		 }else{
		 	 			target.focus(); 
		 	 		 }  
		 	 }
		 	 if(k == 39 || k == 40)
		 	 {
		 		 if(target.next()&& target.next().dom.type!="hidden"){
		 			 if(LegoTag.getCursorPosition(src).end >2 ||(src.value.length == LegoTag.getCursorPosition(src).end)){
		 				if (document.selection) {
		 					target.next().focus();
		 				 }else{
		 					target.next().dom.focus();
		 					flag1=true;
		 				 }
		 				Ext.lib.Event.stopEvent(e);
		 			 }	
		 		 }else{
		 			target.focus(); 
		 		 }
		 	 }
			return;
		}
		if (!((k>=48 && k<=57) || (k>=96 && k<=105))) {
			Ext.lib.Event.stopEvent(e);
		}
}

LegoTag.keypreIpEvent = function (src,ev){
	 var target = Ext.fly(src);
	 var validator = target.dom.getAttribute("validator");
	var k = ev.keyCode;	
	if(k == 86){
	  if(isNaN(src.value)){
		if(target.prev()){  
		    src.value = "0";
		} else{
			src.value = "1";	
		}
		return;
    }
	}
	 if( k == 9)
	 {
		 if(target && target.dom.type!="hidden"){
			 target.dom.select();
		 }
	 }
	 if( k == 190 || k == 110)
	 {
		 if(target.next()&& target.next().dom.type!="hidden" && 
				 src.value != "" && LegoTag.getCursorPosition(src).end !=0 
				 && LegoTag.getCursorPosition(src).start ==LegoTag.getCursorPosition(src).end ){
			target.next().dom.select();
		 }else{
			target.focus();  
		 }
	 }

	if((k == 39 || k == 40) && flag1)
	 {
			target.dom.selectionStart = 0;
			target.dom.selectionEnd = 0;
			flag1=false;
	 }
	 
	 if(src.value.length > 1 && src.value.indexOf("0")==0){
		src.value = src.value/1; 
	 }
	 if(!validator){
	 if(target.prev() && src.value > 255){
		src.value=255;
	 }
	 	 if(target.prev() == null && src.value > 223 && target.dom.getAttribute("maxValue") == 223){
	 		src.value=223; 
	 	 }else if(target.prev() == null && src.value > 255 && target.dom.getAttribute("maxValue") == 255){
	 		src.value=255; 
	 	 }
	 }else{
		 if(src.value > 255){
	 	  src.value = 255; 
	 	}
		 var parent = Ext.get(src.id).findParent(".x-form-ipfield",null,true);
		 var ips = parent.select("input.x-form-field");
		 for(var m = 0 ; m < 4; m++){
			 if(ips.item(m).dom.id){
			LegoTag.clearInvalid(ips.item(m).dom.id);
			 }
		 }
	 } 
	 if((k >= 48 && k <= 57) || (k >= 96 && k <= 105)){
	    if(target.next() && target.next().dom.type!="hidden" && LegoTag.getCursorPosition(src).end >2){
	    	target.next().dom.select();
	 }
	 }
	this.setIpHidden(src,ev);
}
LegoTag.setIpTextFocus = function(src,ev){
	src.select();	
}

LegoTag.getIpValue  = function(id){
   var ipObj = document.getElementById(id);
   if(ipObj){
     if(ipObj.getAttribute("isipv6")){
       return ipObj.value;
     }else{
       if(ipObj.getAttribute("displayAsText")){
         return ipObj.value;
       }else{
         return document.getElementById(id+"-hidden").value;
       }
     }
   }

}
LegoTag.setIpValue  = function(id,value){
	var ipObj = document.getElementById(id);
	if(ipObj.getAttribute("displayAsText") || ipObj.getAttribute("isipv6")){ 
	   ipObj.value = value ;
	 }else{	
		var newValue = value.split(".");
		document.getElementById(id+"_1").value = newValue[0];
		document.getElementById(id+"_2").value = newValue[1];
		document.getElementById(id+"_3").value = newValue[2];
		document.getElementById(id+"_4").value = newValue[3];	
		document.getElementById(id+"-hidden").value = value;
	} 
}

LegoTag.setIpDisabled = function(id,disabled){
	var parentContainer  =  Ext.fly(id);
	var dao = disabled?"addClass":"removeClass"; 
	if(parentContainer.dom.getAttribute("displayAsText") || parentContainer.dom.getAttribute("isipv6")){
		parentContainer.dom.disabled  = disabled ; 
		if(disabled){
		    LegoTag.clearInvalid(id);	 
		  var nextTaget = parentContainer.next();
			if(nextTaget && nextTaget.hasClass("rendar-star")){
				nextTaget.addClass("rendar-star-disabled");
			}
		 }else{
		   LegoTag.validEvent(id);	 
			var nextTaget = parentContainer.next();
			if(nextTaget && nextTaget.hasClass("rendar-star")){
				nextTaget.removeClass("rendar-star-disabled");
			}		 
		 }
	}else{
		document.getElementById(id+"_1").disabled  = disabled ; 
		document.getElementById(id+"_2").disabled  = disabled ; 
		document.getElementById(id+"_3").disabled  = disabled ; 
		document.getElementById(id+"_4").disabled  = disabled ; 
		document.getElementById(id+"-hidden").disabled  = disabled ; 
		LegoTag.clearInvalid(id+"_1");
		LegoTag.clearInvalid(id+"_2");
		LegoTag.clearInvalid(id+"_3");
		LegoTag.clearInvalid(id+"_4");
	}
	parentContainer[dao]("x-item-disabled");
}
LegoTag.keypreTextIpEvent = function(target , e){

    var ev = e || window.event;
    if(ev){
	    var keyCode = ev.keyCode;
		if (Ext.EventObject.LEFT == keyCode || Ext.EventObject.RIGHT == keyCode 
		    || Ext.EventObject.UP == keyCode || Ext.EventObject.DOWN == keyCode	|| Ext.EventObject.PAGEUP == keyCode || Ext.EventObject.PAGEDOWN == keyCode) {
				 return;
		}
    }
	var value =  target.dom.value;
	if(!value){
		return ;
	}
	var arr = value.split(".");
	var newArr = [];
	var flag = true;
	for(var k = 0 ; k <arr.length ; k++){
		var src = arr[k];
		 if(src.length > 1 && src.indexOf("0")==0){
		    src = src*1;
		 }
		 var ismask = target.dom.getAttribute("isMask");
		 if(!ismask){
			 var validator = target.dom.getAttribute("validator");
			 if(validator){
				 if(k == 0 && src > 255){
					 flag = false;
					 src = 255; 
				 }
			 }else{
				 if(k == 0 && src > 223){
					 flag = false;
					 src = 223;
				 } 
				 if((k == 0)&& src <1 && src!=""){
					 flag = false;
					 src = 1; 
				 }
				 if((k == 3)&& src <0 && src!=""){
					 flag = false;
					 src = 0; 
				 }
			 }
		 }
		 if(src > 255){
			 flag = false;
			 src = 255;
		 }
		 newArr.push(src);
	}
	if(!flag)
	{
		target.dom.value = newArr.join(".");
	}
}
LegoTag.keypreTextIpv4Event = function(target, e){

    var ev = e || window.event;
    if(ev){
	    var keyCode = ev.keyCode;
		if (Ext.EventObject.LEFT == keyCode || Ext.EventObject.RIGHT == keyCode 
		    || Ext.EventObject.UP == keyCode || Ext.EventObject.DOWN == keyCode	|| Ext.EventObject.PAGEUP == keyCode || Ext.EventObject.PAGEDOWN == keyCode) {
				 return;
		}
    }
    
	var value =  target.dom.value;
	if(!value){
		return ;
	}
	var arr;
	if(Ext.isIE){
	  arr = value.split(".");
	  var x;
	  for(var i = 0; i< arr.length; i++){
		   x = arr[i].split("/");
		   if(x.length == 2){
		     arr.splice(i,2,x[0],x[1]);
		   }
		}
	}else{
	   arr = value.split(/\.|\//);
	}
	var newArr = [];
	var flag = true;
	var result = "";
	for(var k = 0 ; k <arr.length ; k++){
		var src = arr[k];
		 if(src.length > 1 && src.indexOf("0")==0){
		    src = src*1;
		 }
		 var maskrequired = target.dom.getAttribute("maskrequired");
		 var validator = target.dom.getAttribute("validator");
		 if(validator){
			 if(k == 0 && src > 255){
				 src = 255; 
				 flag = false;
			 }
		 }else{
			 if(k == 0 && src > 223){
				 flag = false;
				 src = 223;
			 } 
			 if((k == 0)&& src <1 && src!=""){
				 flag = false;
				 src = 1; 
			 }
			 if((k == 3)&& src <0 && src!=""){
				 flag = false;
				 src = 0; 
			 }
			 if(maskrequired){
			   if((k == 4) && src != ""){
			     if(src < 1 ){
			    	 flag = false;
			       src = 1;
			     }
			     if(src > 32){
			    	 flag = false;
			       src = 32;
			     }
			   }
			 }
		 }
		 if(k <= 3 && src > 255){
			 flag = false;
		   src = 255;
		 }
		 if(k <= 3){
		  newArr.push(src);
		  if(k == 3){
		   result += newArr.join(".");
		  }
		 }
		 if(k == 4){
		    if(maskrequired && arr.length > 4){
		      result += "/" + src;
		    }
		 }
	}
	if(!flag)
	{
		target.dom.value = result;
	}
}
LegoTag.keypreTextIpv6Event = function(target , e){
    
    var ev = e || window.event;
    if(ev){
	    var keyCode = ev.keyCode;
		if (Ext.EventObject.LEFT == keyCode || Ext.EventObject.RIGHT == keyCode 
		    || Ext.EventObject.UP == keyCode || Ext.EventObject.DOWN == keyCode	|| Ext.EventObject.PAGEUP == keyCode || Ext.EventObject.PAGEDOWN == keyCode) {
				 return;
		}
    }
    
	var value =  target.dom.value;
	if(!value){
		return ;
	}
	var arr;
	if(Ext.isIE){
	  arr = value.split(":");
	  var x;
	  for(var i = 0; i< arr.length; i++){
		   x = arr[i].split("/");
		   if(x.length == 2){
		     arr.splice(i,2,x[0],x[1]);
		   }
		}
	}else{
	   arr = value.split(/\:|\//);
	}
	var tm = value.split(/\//);
	var newArr = [];
	var flag = false;
	var result = "";
	for(var k = 0 ; k <arr.length ; k++){
		 var src = arr[k];
		 var t = parseInt(src , 16);
		 var maskrequired = target.dom.getAttribute("maskrequired");
		 var validator = target.dom.getAttribute("validator");
		 if(validator){
		 }else{
			 if(!isNaN(t) && t > 65535){
			   src = 'ffff';
			 }
			 if(maskrequired && tm.length == 2){
			   if((k == arr.length - 1) && src != ""){
			     if(src < 1 ){
			       src = 1;
			     }
			     if(src > 128){
			       src = 128;
			     }
			   }
			 }
		 }
		 if(k <= arr.length -2 && !isNaN(t) && t > 65535){
		 }
		 if(maskrequired && tm.length == 2)
		 {
			 if(k <= arr.length - 2){
			  newArr.push(src);
			  if(k == arr.length - 2){
			   result += newArr.join(":");
			  }
			 }
		 }
		 else
		 {
			 if(k <= arr.length - 1){
			  newArr.push(src);
			  if(k == arr.length - 1){
			   result += newArr.join(":");
			  }
			 }
		 }

		 if(k == arr.length -1){
		    if(maskrequired && tm.length == 2){
		      result += "/" + src;
		    }
		 }
	}
	if(!flag)
	{
		target.dom.value = result;
	}
}
LegoTag.setCursorPosition = function(textarea,num){
	 if (document.selection) {
		 textarea.focus();
		 var oTextRange = textarea.createTextRange(); 
		 oTextRange.moveStart('character', num); 
		 oTextRange.moveEnd('character', num); 
		 oTextRange.select(); 
	 }else{
		 textarea.focus();
		 textarea.selectionStart = num;
		 textarea.selectionEnd = num;
	 }
}
LegoTag.getCursorPosition = function(textarea){
	var rangeData = {text: "", start: 0, end: 0 };
	if (document.selection) {
		textarea.focus();
		var i,
			oS = document.selection.createRange(),
			oR = document.body.createTextRange();
		oR.moveToElementText(textarea);
		
		rangeData.text = oS.text;
		rangeData.bookmark = oS.getBookmark();
		for (i = 0; oS.moveStart("character", -1) !== 0; i ++) {
			if (textarea.value.charAt(i) == '\r' ) {
				i ++;
			}
		}
		rangeData.start = i;
		rangeData.end = rangeData.text.length + rangeData.start;
	}else{
		textarea.focus();
		rangeData.start= textarea.selectionStart;
		rangeData.end = textarea.selectionEnd;
		rangeData.text = (rangeData.start != rangeData.end) ? textarea.value.substring(rangeData.start, rangeData.end): "";
	}
	return rangeData;
}

LegoTag.SimpleMap = function() {

	this.elements = new Array();
	this.size = function() {
		return this.elements.length;
	}
	this.isEmpty = function() {
		return (this.elements.length < 1);
	}
	this.clear = function() {
		this.elements = new Array();
	}
    this.put = function(_key, _value) {
		if(this.containsKey(_key)){
		  for (i = 0; i < this.elements.length; i++) {
				if (this.elements[i].key == _key) {
					this.elements[i].value = _value;
					break;
				}
		   }
		}else{
		  this.elements.push({key:_key, value:_value});
		}
	}
	this.remove = function(_key) {
		var bln = false;
		try {
			for (i = 0; i < this.elements.length; i++) {
				if (this.elements[i].key == _key) {
					this.elements.splice(i, 1);
					return true;
				}
			}
		} catch(e) {
			bln = false;
		}
		return bln;
	}
	this.get = function(_key) {
		try{ 
			for (i = 0; i < this.elements.length; i++) {
				if (this.elements[i].key == _key) {
					return this.elements[i].value;
				}
			}
		}catch(e) {
			return null;
		}
	}
	this.element = function(_index) {
		if (_index < 0 || _index >= this.elements.length) {
			return null;
		}
		return this.elements[_index];
	}
	this.containsKey = function(_key) {
		var bln = false;
		try {
			for (i = 0; i < this.elements.length; i++) {
				if (this.elements[i].key == _key) {
					bln = true;
				}
			}
		}catch(e) {
			bln = false;
		}
		return bln;
	}
	this.containsValue = function(_value) {
		var bln = false;
		try {
			for (i = 0; i < this.elements.length; i++) {
				if (this.elements[i].value == _value){
					bln = true;
				}
			}
		} catch(e) {
			bln = false;
		}
		return bln;
	}
	this.values = function() {
		var arr = new Array();
		for (i = 0; i < this.elements.length; i++) {
			arr.push(this.elements[i].value);
		}
		return arr;
	}
	this.keys = function() {
		var arr = new Array();
		for (i = 0; i < this.elements.length; i++) {
			arr.push(this.elements[i].key);
		}
		return arr;
	}
} 