if (top.Ext.Msg) {
	LegoTag.Msg = function() {
		var ExtMsg = top.Ext.Msg;
		var waitWin, waitMsg, progressBar;
		var initWaitWin = function() {
			var existWin = top.Ext.getCmp("legoMsgWinId");
			if(existWin){
				return existWin;
			}
			var win = new top.Ext.Window( {
				resizable : false,
				modal : true,
				id:'legoMsgWinId',
				cls : 'legoMsgWin',
				autoDestroy :true,
				border : false,
				shadow : false,
				closable : false,
				destroy : function() {
					this.hide();					
				},
				close : function() {
					this.hide();
				}
			});
			win.render(top.document.body);
			win.body.createChild( {
				cls : 'legoMsgCtl'
			});
			var container = win.body.createChild( {
				cls : 'legoMsgCt'
			});
			win.body.createChild( {
				cls : 'legoMsgCtr'
			});
			waitMsg = container.createChild( {
				cls : 'legoMsgText'
			});
			var barCt = container.createChild({
				cls :'legoProgressBar'
			});
			progressBar = new top.Ext.ProgressBar( {
				renderTo : barCt,
				id :"legoProgressBarId"
			});
			return win;
		};

		return {
			getDialog : function(titleText) {
				this.setExtMsgProps();
				return ExtMsg.getDialog(titleText);
			},

			updateText : function(text) {
				this.setExtMsgProps();
				return ExtMsg.updateText(text);
			},

			updateProgress : function(value, progressText, msg) {
				this.setExtMsgProps();
				return ExtMsg.updateProgress(value, progressText, msg);
			},

			isVisible : function() {
				this.setExtMsgProps();
				return this.waitIsVisible() || ExtMsg.isVisible();
			},

			waitIsVisible : function() {
				return waitWin && waitWin.isVisible();
			},

			hide : function() {
				if (this.waitIsVisible()) {
					waitWin.hide();
					progressBar.reset();
					return this;
				}
				this.setExtMsgProps();
				return ExtMsg.hide();
			},
			show : function(options) {
			
				var tmp = "<div id='popwin_msg' class='popwin_msg'>"
					+ options.msg + "</div>";
			if (options.checkbox) {
				tmp = tmp
						+ "<tr><td height='20'><input type='checkbox' id='lego-msg-danger-chk' onclick='LegoTag.Msg.dangerChecked(this)'><label for='lego-msg-danger-chk'> "
						+ LegoTagI18N.Msg.level.dangerMsg + "</label></td></tr>"
			}
			if(options.auth) {
				tmp = tmp + "<div><label>" + LegoTagI18N.Msg.level.authMsg + "</label></div>"
						 + "<div><input type='password' id='lego-auth-pwd' class='x-form-text x-form-field' style='width:150px;' onkeyup='LegoTag.Msg.authInput(this)' /></div>";
			}
			options.msg = tmp + "</table>";
			if (this.waitIsVisible()) {
				waitWin.hide();
				progressBar.reset();
			}
			this.setExtMsgProps();
			return ExtMsg.show(options);
			},

			setIcon : function(icon) {
				this.setExtMsgProps();
				return ExtMsg.setIcon(icon);
			},

			progress : function(title, msg, progressText) {
				if (this.waitIsVisible()) {
					waitWin.hide();
					progressBar.reset();
				}
				this.setExtMsgProps();
				return ExtMsg.progress(title, msg, progressText);
			},
			
			wait : function(msg, title, config) {
				if (msg === undefined) {
					msg = LegoTagI18N.Msg.level.loadingMsg;
				}
				if (ExtMsg.isVisible()) {
					ExtMsg.hide();
				}
				if (!waitWin) {
					waitWin = initWaitWin();
				}
				if(!waitMsg){
					waitMsg = top.Ext.select(".legoMsgText").item(0) ;
				}	
				waitMsg.update(msg);
				if(!progressBar){
					progressBar = top.Ext.getCmp("legoProgressBarId");
				}
				progressBar.wait(config);
				waitWin.show();
				return this;
			},

			alert : function(title, msg, fn, scope, icon) {
				if (this.waitIsVisible()) {
					waitWin.hide();
					progressBar.reset();
				}
				this.setExtMsgProps();
				this.show( {
					title : title,
					msg : msg,
					buttons : this.OK,
					fn : fn,
					scope : scope,
					icon : (icon) ? icon : this.INFO
				});
				if (!top.LegoTag.Msg.alertListener) {
					top.LegoTag.Msg.addAlertListener();
				}
				return this;
			},
			addAlertListener: function() {
				var d = this.getDialog();
				var km = d.getKeyMap();
				km.enable();
				var buttons = d.buttons[0];
				km.on(9, function(button, event) {
					event.stopEvent();
					buttons.focus();
				}, this);
				buttons.getEl().dom.onselectstart = function() {
					return false;
				}
				this.alertListener = true;
			},
			succeed : function(msg, fn, title, scope) {
				if (title === undefined) {
					title = LegoTagI18N.Msg.result.succeed;
				}
				return this.alert(title, msg, fn, scope, "lego-msg-succeed");
			},
			failed : function(msg, fn, title, scope) {
				if (title === undefined) {
					title = LegoTagI18N.Msg.result.failed;
				}
				return this.alert(title, msg, fn, scope, "ext-mb-error");
			},

			confirm : function(title, msg, fn, scope, icon, checkbox) {
				if (this.waitIsVisible()) {
					waitWin.hide();
					progressBar.reset();
				}
				this.setExtMsgProps();

				if (Ext.isArray(msg)) {
					msg = String.format(LegoTagI18N.Msg.level.msg, msg[0], msg[1],
							msg[2]);
				}
				this.show( {
					title : title,
					msg : msg,
					buttons : this.YESNO,
					fn : fn,
					scope : scope,
					icon : (icon) ? icon : this.QUESTION,
					checkbox : checkbox
				});
				if (!top.LegoTag.Msg.confirmListener) {
					top.LegoTag.Msg.addConfirmListener();
				}
				if(checkbox){
					var d = this.getDialog();
					d.buttons[1].setDisabled(true);
					var dlg = this.getDialog();
					dlg.focusEl = d.buttons[2];
					dlg.focus();
				} else {
					var dlg = this.getDialog();
					dlg.buttons[1].setDisabled(false);
					dlg.focusEl = dlg.buttons[2];
					dlg.focus();
				}
				return this;
			},
			addConfirmListener: function() {
				var d = this.getDialog();
				var km = d.getKeyMap();
				km.enable();
				buttonYes = d.buttons[1];
				buttonNo = d.buttons[2];
				km.on(9, function(key, e) {
					e.stopEvent();
					 try{
						 if (e.target.textContent === buttonYes.text) {
							buttonNo.focus();
						 } else {
							buttonYes.focus();
						 }
					    }catch(e){
							
						}

				}, this);
				this.confirmListener = true;
			},
			danger : function(msg, fn, title, scope) {
				if (title === undefined) {
					title = LegoTagI18N.Msg.level.danger;
				}
				return this.confirm(title, msg, fn, scope,
						"lego-msg-danger", true);
			},
			dangerChecked : function(checkbox) {
				var dlg = this.getDialog();
				var buttonYes = dlg.buttons[1];
				var buttonNo = dlg.buttons[2];
				if (checkbox.checked) {
					buttonYes.setDisabled(false);
					buttonYes.focus();
				} else {
					buttonYes.setDisabled(true);
					buttonNo.focus();
				}
			},
			warning : function(msg, fn, title, scope) {
				if (title === undefined) {
					title = LegoTagI18N.Msg.level.warning;
				}
				return this.confirm(title, msg, fn, scope, "ext-mb-warning");
			},
			info : function(msg, fn, title, scope) {
				if (title === undefined) {
					title = LegoTagI18N.Msg.level.info;
				}
				return this.confirm(title, msg, fn, scope, "ext-mb-info");
			},

			prompt : function(title, msg, fn, scope, multiline, value) {
				this.show( {
					title : title,
					msg : msg,
					buttons : this.OKCANCEL,
					fn : fn,
					minWidth : 300,
					scope : scope,
					prompt : true,
					multiline : multiline,
					value : value
				});
				var text = this.getDialog().body.child(".ext-mb-input")
						.setWidth(360);
				text.next().setWidth(360);
				return this;
			},
			
			auth : function(fn, msg, scope, title) {
				if(title === undefined) {
					title = LegoTagI18N.Msg.level.auth;
				}
				if(msg === undefined) {
					msg = '';
				}
				this.show({
					title : title,
					msg : msg,
					fn : fn,
					buttons : this.YESNO,
					scope : scope,
					auth : true,
					icon : this.WARNING
				});
				this.getDialog().buttons[1].setDisabled(true);
				return this;
			},
			authInput : function(password) {
				var dlg = this.getDialog();
				var buttonYes = dlg.buttons[1];
				var buttonNo = dlg.buttons[2];
				var input = password.value;
				if (input == null || input == "") {
					buttonYes.setDisabled(true);
				}
				else {
					buttonYes.setDisabled(false);
				}
			},
			setExtMsgProps : function() {
				ExtMsg.OK = this.OK;
				ExtMsg.CANCEL = this.CANCEL;
				ExtMsg.OKCANCEL = this.OKCANCEL;
				ExtMsg.YESNO = this.YESNO;
				ExtMsg.YESNOCANCEL = this.YESNOCANCEL;
				ExtMsg.INFO = this.INFO;
				ExtMsg.WARNING = this.WARNING;
				ExtMsg.QUESTION = this.QUESTION;
				ExtMsg.ERROR = this.ERROR;
				ExtMsg.defaultTextHeight = this.defaultTextHeight;
				ExtMsg.maxWidth = this.maxWidth;
				ExtMsg.minWidth = this.minWidth;
				ExtMsg.minProgressWidth = this.minProgressWidth;
			},
			OK : {
				ok : true
			},
			CANCEL : {
				cancel : true
			},
			OKCANCEL : {
				ok : true,
				cancel : true
			},
			YESNO : {
				yes : true,
				no : true
			},
			YESNOCANCEL : {
				yes : true,
				no : true,
				cancel : true
			},
			INFO : 'ext-mb-info',
			WARNING : 'ext-mb-warning',
			QUESTION : 'ext-mb-question',
			ERROR : 'ext-mb-error',
			defaultTextHeight : 75,
			maxWidth : 380,
			minWidth : 350,
			minProgressWidth : 250,
			buttonText : {
				ok : "OK",
				cancel : "Cancel",
				yes : "Yes",
				no : "No"
			}
		}

	}();
	
	LegoTag.MessageBox = LegoTag.Msg;
	LegoTag.MessageBox.minProgressWidth = 380;
}
