LegoTag.activeTabItem = function (tabPanel,targetHeader){

    if(!tabPanel)
    {
        return; 
    }
	var tabPDom = tabPanel.dom;
	var tabPDomId = tabPanel.dom.id;
	var headParent = targetHeader.parent();
	if(targetHeader.hasClass("selected")){
		return;
	}
	var activeTab_index = tabPDom.getAttribute("activeTab") || 0;
	var index = parseInt(targetHeader.dom.getAttribute("index"));
	var headerEls = headParent.select(".bc_tabitem_head");
	headerEls.item(activeTab_index).removeClass("selected");
	
	targetHeader.addClass("selected");
	tabPDom.setAttribute("activeTab" ,index);
	
	var orgiTabItem = Ext.get(tabPDomId +"_tabitem_body_" + activeTab_index);
	if(orgiTabItem && orgiTabItem.hasClass("selected"))
	{
	  orgiTabItem.removeClass("selected");
	}
	
	var currTabItem = Ext.get(tabPDomId +"_tabitem_body_" + index);
	if(currTabItem)
	{
	   currTabItem.addClass("selected");
	}
	
	var onActiveTab = tabPanel.dom.getAttribute('onActiveTab');
	if(onActiveTab){
		onActiveTab = onActiveTab.replace(/\(.*\)/g,"");
		eval(onActiveTab + "('" +index+"')");
	}
	
	var currTabItem = Ext.get(tabPanel.dom.id + index);
	if(currTabItem.select("input,textarea")){
		var elems = currTabItem.select("input,textarea");
		for(var g = 0 ; g <elems.getCount(); g++){
			if(elems.item(g).isVisible()){
				if(elems.item(g).dom.disabled){
					continue;
				}else{
					elems.item(g).focus();
					break;
				}
			}
		}
	}
}
LegoTag.activeTabEvent = function (src,ev){
	var targetHeader = Ext.fly(src);
	var tabPanel = targetHeader.findParent(".bc_tab" , null , true);
	LegoTag.activeTabItem(tabPanel,targetHeader);

}


LegoTag.activeTabIndx = function (src,indexItem){
	var tabPanel = src;
	if (typeof(src) == "string") {
		tabPanel = Ext.get(src);
	}
	var headParent = tabPanel.child(".bc_tabitems");
	var headerEls = headParent.select(".bc_tabitem_head");
	
	var targetHeader = headerEls.item(indexItem);
	LegoTag.activeTabItem(tabPanel,targetHeader);
}
LegoTag.scrollTabs = function (src,direction){
	src.scrollFlag = 0;
	var panelHeader = Ext.fly(src).parent();
	var stripWrap = panelHeader.child(".x-tab-strip-wrap");
	
	var tabUl = stripWrap.child(".x-tab-strip-top");
	var edge = tabUl.child(".x-tab-edge");
	var pos = stripWrap.dom.scrollLeft;
	var scrollWidth = edge.getOffsetsTo(stripWrap)[0] + pos;
	var scrollArea = stripWrap.dom.clientWidth;
	if (!Ext.isIE) {
		scrollArea -= 36;
	}
	var tw = panelHeader.dom.clientWidth;
	var lis = tabUl.select('li');
	
	var scrollIndex = stripWrap.dom.scrollIndex || 0;
	var paraIndex = scrollIndex;
	var sw = scrollWidth-scrollArea;
	var tabsCount = lis.getCount()-1;
	var s;
   if (direction < 0) {
   	paraIndex = Math.max(0,scrollIndex-2);
   	s = pos - (stripWrap.dom.lastTab || 0);
   }else{
		var scrollIncrement = lis.item(paraIndex).getWidth() + 4;
   	s = Math.max(0,Math.min(sw, pos + scrollIncrement));
   }
   if(s != pos){
       stripWrap.scrollTo('left', s, {duration:.35,callback:LegoTag.updateScrollButtons,scope:src});
	    scrollIndex += direction;
	    scrollIndex = Math.max(0,Math.min(tabsCount-1,scrollIndex));
	    stripWrap.dom.scrollIndex = scrollIndex;
	    if (direction > 0) {
	    	stripWrap.dom.lastTab = s - pos;
	    }else{
	    	stripWrap.dom.lastTab = lis.item(paraIndex).getWidth() + 4;
	    }
   }
}
LegoTag.updateScrollButtons = function (stripWrap){
	var tabUl = stripWrap.child(".x-tab-strip-top");
	var edge = tabUl.child(".x-tab-edge");
	var pos = stripWrap.dom.scrollLeft;
	var scrollWidth = edge.getOffsetsTo(stripWrap)[0] + pos;
	var scrollArea = stripWrap.dom.clientWidth;
	if (!Ext.isIE) {
		scrollArea -= 36;
	}
	var scroLeft = stripWrap.prev();
	var scroRight = scroLeft.prev();
	scroLeft[pos == 0 ? 'addClass' : 'removeClass']('x-tab-scroller-left-disabled');
	scroRight[pos >= (scrollWidth-scrollArea) ? 'addClass' : 'removeClass']('x-tab-scroller-right-disabled');
	
	var src = this;
	var direction = (this.className.indexOf("right")!=-1)?1:-1;
	setTimeout(function(){
		if (src.scrollFlag) {
			return;
		}
		LegoTag.scrollTabs(src,direction);
	},100)
}
LegoTag.setThisValue = function (src,value){
	src.scrollFlag = value;
}
LegoTag.hideTabIndx = function (src,indexItem,state){
	var tabPanel = src;
	if (typeof(src) == "string") {
		tabPanel = Ext.get(src);
	}
	var headParent = tabPanel.child(".f1");
	var headerEls = headParent.select(".bc_tabitem_head");
	
	var targetHeader = headerEls.item(indexItem);
	if (state) {
		targetHeader.setStyle("display","");
	}else{
		targetHeader.setStyle("display","none");
	}
}

LegoTag.setToolbarDisplay = function(){
	var elements = Ext.query(".x-toolbar td[width]");
	var length = elements.length;
	for(var m = 0 ; m < length ; m++){
		if(elements[m].innerHTML.trim() == ""){
			elements[m].style.width="0";
		}
	}
}