var textSrcLength=0;

LegoTag.validationText = function (form){
	var isValid = true;
	form = form || Ext.getBody();
	if(form.dom.innerHTML === ""){
		form = form.parent();
	}
	var elements = form.select('input[isRequired=true],input[numberfield="true"],textarea[isRequired=true]' +
			',input[regex],textarea[regex],input[minValue],input[maxValue],input[validator],input[isIp],input[isipv6],textarea[maxlengthExt]');
	for(var i=0; i<elements.getCount(); i++) {
		var item=elements.item(i);
		var validTxt = LegoTag.validEvent(item);
		isValid = isValid && validTxt;
	}
	return isValid;
}
LegoTag.validTextResult = function (form){
	var isValid = true;
	var result = null
	form = form || Ext.getBody();
	if(form.dom.innerHTML === ""){
		form = form.parent();
	}
	var elements = form.select('input[regexText],input[isRequired=true],textarea[isRequired=true]' +
			',input[regex],textarea[regex],input[minValue],input[maxValue],input[validator],input[isIp],input[isipv6],textarea[maxlengthExt],ul[isRequired=true]');
	if(form.dom && form.dom.elements){
		var allElem = form.dom.elements;
		for(var i=0; i<allElem.length; i++){
			var elem = allElem[i];
			if(elements.contains(elem)){
				for(var j=0; j<elements.getCount(); j++) {
					var item=elements.item(j);
					if(elem === item.dom){
						var validTxt = LegoTag.getValidResult(item);
						if (validTxt) {
							result = result || [validTxt,item.dom];
						}
						break;
					}
				}
			}
		}
	}
	return result;
}

LegoTag.validationForm = function (form){
	form = Ext.fly(form);	
	var result = LegoTag.validationText(form);
	return result;
}
LegoTag.validFormResult = function (form,isAlert,isFocus,alertTitle){
	form = Ext.fly(form);
	var result = LegoTag.validTextResult(form);
	if (result && isAlert) {
		var title = alertTitle || "";
		LegoTag.Msg.failed(result[0],function(){
			if (isFocus) {
			   if(!result[1].disabled && (result[1].style.display !="none" || result[1].style.visibility !="hidden")){
				result[1].focus();
			   }
			}
		});
	}
	return result;
}

LegoTag.validRegex = function (txt) {
	if(!txt){
		return false;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return false;
 	}
 	var txtValue = txtEl.getValue();
 	var txtRegex = eval(txtEl.dom.getAttribute("regex"));
 	var flag = txtValue && !txtRegex.test(txtValue);
 	var errorDesc = txtEl.dom.getAttribute("regexText")?txtEl.dom.getAttribute("regexText"):"The value in this field is invalid";
 	return LegoTag.exeValid(flag,txtEl,errorDesc)
 }

LegoTag.valididNum = function (txt) {
	if(!txt){
		return false;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return false;
 	}	
	var txtValue = txtEl.getValue();
	var isValid = true;
 	var errorDesc = "";
 	var numberReg = /^0$/;
 	var zjy= /^(([0-9]+\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\.[0-9]+)|([0-9]*[1-9][0-9]*))$/i;
 	var fjy= /^(-(([0-9]+\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\.[0-9]+)|([0-9]*[1-9][0-9]*)))$/i;
	if(isNaN(parseFloat(txtValue)) || (!zjy.test(txtValue) && !fjy.test(txtValue) && !numberReg.test(txtValue)))
	{
		isValid = false;
		errorDesc += txtEl.dom.getAttribute("numErrText")?txtEl.dom.getAttribute("numErrText"):" cannot input non-number.";
 	}
 	var flag = txtValue && !isValid;
 	return LegoTag.exeValid(flag,txtEl,errorDesc);
}

LegoTag.validMask = function (txt, event) {
	if(!txt){
		return false;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return false;
 	}
 	var  idList = txtEl.dom.id.split("_");
 	var id ="";
 	for(var i=0; i<idList.length; i++) {
		var item=idList[i];
		if(i<idList.length-2){
			id =id+ idList[i]+"_"
		}else if(i == idList.length-2){
			id =id+idList[i];
		}
	}
	var isValid = true;
 	var errorDesc = "";
	if(txtEl.dom.getAttribute("displayAsText")){
	LegoTag.keypreTextIpEvent(txtEl, event);
	var textValue = txtEl.dom.value.replace(/\s/ig,"");
	if(textValue!=txtEl.dom.value)
	{
		txtEl.dom.value	= textValue;
	}
	var maskReg= /^(0.0.0.0|128.0.0.0|192.0.0.0|224.0.0.0|240.0.0.0|248.0.0.0|252.0.0.0|254.0.0.0|255.0.0.0|255.128.0.0|255.192.0.0|255.224.0.0|255.240.0.0|255.248.0.0|255.252.0.0|255.254.0.0|255.255.0.0|255.255.128.0|255.255.192.0|255.255.224.0|255.255.240.0|255.255.248.0|255.255.252.0|255.255.254.0|255.255.255.0|255.255.255.128|255.255.255.192|255.255.255.224|255.255.255.240|255.255.255.248|255.255.255.252|255.255.255.254|255.255.255.255)$/;
	var maskRegNull = /^(0.0.0.0|128.0.0.0|192.0.0.0|224.0.0.0|240.0.0.0|248.0.0.0|252.0.0.0|254.0.0.0|255.0.0.0|255.128.0.0|255.192.0.0|255.224.0.0|255.240.0.0|255.248.0.0|255.252.0.0|255.254.0.0|255.255.0.0|255.255.128.0|255.255.192.0|255.255.224.0|255.255.240.0|255.255.248.0|255.255.252.0|255.255.254.0|255.255.255.0|255.255.255.128|255.255.255.192|255.255.255.224|255.255.255.240|255.255.255.248|255.255.255.252|255.255.255.254|255.255.255.255)?$/;
	 if(txtEl.dom.getAttribute("isRequired") && txtEl.dom.getAttribute("isRequired")== "true"){	
		 if(textValue.length == 0){
		  isValid = false;
		  errorDesc += txtEl.dom.getAttribute("blankText")?txtEl.dom.getAttribute("blankText"):"This field is required";
		 }else if(!maskReg.test(textValue)){
		  isValid = false;
		  errorDesc = txtEl.dom.getAttribute("numErrText")?txtEl.dom.getAttribute("numErrText"):errorDesc;		  
		 }
	 }else{
		 if(!maskRegNull.test(textValue)){
		  isValid = false;
		  errorDesc = txtEl.dom.getAttribute("numErrText")?txtEl.dom.getAttribute("numErrText"):errorDesc;				 
		 }
	 }		
	}
	else{
 	var ipValue = document.getElementById(id + "-hidden");	
 	var zjy= /^(|...|0.0.0.0|128.0.0.0|192.0.0.0|224.0.0.0|240.0.0.0|248.0.0.0|252.0.0.0|254.0.0.0|255.0.0.0|255.128.0.0|255.192.0.0|255.224.0.0|255.240.0.0|255.248.0.0|255.252.0.0|255.254.0.0|255.255.0.0|255.255.128.0|255.255.192.0|255.255.224.0|255.255.240.0|255.255.248.0|255.255.252.0|255.255.254.0|255.255.255.0|255.255.255.128|255.255.255.192|255.255.255.224|255.255.255.240|255.255.255.248|255.255.255.252|255.255.255.254|255.255.255.255)$/;
	if(!zjy.test(ipValue.value)){
		isValid = false;
		 errorDesc = txtEl.dom.getAttribute("numErrText")?txtEl.dom.getAttribute("numErrText"):errorDesc;	
 	}
  }
 	var flag =!isValid;
 	return LegoTag.exeValid(flag,txtEl,errorDesc);
}

LegoTag.validIP = function (txt , event) {
	if(!txt){
		return false;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return false;
 	}
 	var  idList = txtEl.dom.id.split("_");
 	var id ="";
 	for(var i=0; i<idList.length; i++) {
		var item=idList[i];
		if(i<idList.length-2){
			id =id+ idList[i]+"_"
		}else if(i == idList.length-2){
			id =id+idList[i];
		}
	}
 	var isValid = true;
 	var errorDesc = "";
 	var regex = /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[0-9]\d|[0-9])$/;
	if(txtEl.dom.getAttribute("displayAsText")){
	var textValue = txtEl.dom.value.replace(/\s/ig,"");
	if(textValue!=txtEl.dom.value)
	{
		txtEl.dom.value	= textValue;
	}
	var textIpRex = /^((22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[0-9]\d|[0-9]))?$/;
	 LegoTag.keypreTextIpEvent(txtEl , event);
	if(txtEl.dom.getAttribute("validator")){
		regex = /^(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[0-9]\d|\d)$/;
		textIpRex = /^((25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[0-9]\d|\d))?$/;
	}else 
	if(txtEl.dom.getAttribute("allowMask")){
		regex = /^(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[0-9]\d|\d)(\/\d{1,3})?$/;	
		textIpRex = /^((25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[0-9]\d|\d)(\/\d{1,3})?)?$/;
		txtEl.dom.setAttribute("maxlength","19");
	}
	if(txtEl.dom.getAttribute("isRequired") && txtEl.dom.getAttribute("isRequired")== "true"){
		 if(textValue.length == 0){
		 isValid = false;
		 errorDesc += txtEl.dom.getAttribute("blankText")?txtEl.dom.getAttribute("blankText"):"This field is required";
		 }else if(!regex.test(textValue)){
		 isValid = false;
		  errorDesc = txtEl.dom.getAttribute("numErrText")?txtEl.dom.getAttribute("numErrText"):errorDesc;	
		 }else if(textValue.split(".")[0]=="127" && !txtEl.dom.getAttribute("validator")){
		  isValid = false;
		  errorDesc = txtEl.dom.getAttribute("numErrText")?txtEl.dom.getAttribute("numErrText"):errorDesc;				 
		 }
	 }else{
		 if(!textIpRex.test(textValue)){
		  isValid = false;
		  errorDesc = txtEl.dom.getAttribute("numErrText")?txtEl.dom.getAttribute("numErrText"):errorDesc;				 
		 }else if(textValue.split(".")[0]=="127" && !txtEl.dom.getAttribute("validator")){
		  isValid = false;
		  errorDesc = txtEl.dom.getAttribute("numErrText")?txtEl.dom.getAttribute("numErrText"):errorDesc;	 			 
		}
	 }

  }
	else{
		
 	var ipValue = document.getElementById(id + "-hidden"); 	
	var regex127 = /^(127)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])$/;
 	if(txtEl.dom.getAttribute("validator")){
 		regex = /^(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[0-9])$/;
 	}
	if(ipValue.value != "" && ipValue.value != "..." && (!regex.test(ipValue.value) || !txtEl.dom.getAttribute("validator")&& regex127.test(ipValue.value)))
	{
		isValid = false;
		errorDesc += txtEl.dom.getAttribute("numErrText");
	}
   }	
 	var flag =!isValid;
 	return LegoTag.exeValid(flag,txtEl,errorDesc);
}

LegoTag.validIPx = function (txt , event) {
	if(!txt){
		return false;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return false;
 	}
 	var textValue = txtEl.dom.value.replace(/\s/ig,"");
	if(textValue != txtEl.dom.value)
	{
		txtEl.dom.value	= textValue;
	}
	var sum = 0 , c , dotNum = 0, colonNum = 0 ,obliqueLineNum = 0, isValid = true , errorDesc = "", idx = -1;
	for (var i=0; i< textValue.length; i++)
	{
	  c = textValue.charAt(i);
	  if(c == "."){
	    dotNum ++;
	  }else if(c == ":"){
	    colonNum ++;
	  }else if( c == "/"){
	    obliqueLineNum ++;
	  }
	}
	var maskRequired;
	var isRequired = txtEl.dom.getAttribute("isRequired");
	if(textValue.length == 0){
	 if(isRequired && isRequired == 'true' )
	 {
	     isValid = false;
		 errorDesc += txtEl.dom.getAttribute("blankText") ? txtEl.dom.getAttribute("blankText") : "This field is required" ;
		 return LegoTag.exeValid(!isValid,txtEl,errorDesc);
	 }
	 else
	 {
	     return LegoTag.exeValid(false,txtEl);
	 }
	}
	if(!((dotNum == 3 && colonNum == 0) || (dotNum == 0 && colonNum >= 2 ))){
	
	  isValid = false;
	  errorDesc += txtEl.dom.getAttribute("numErrText") ? txtEl.dom.getAttribute("numErrText") : ", the ip separator in this field is invalid.";
	}
	else
	{
	  maskRequired = txtEl.dom.getAttribute("maskRequired");
	  if(maskRequired){
	      if(obliqueLineNum == 1)
	      {
	      	  var mask;
			  idx = textValue.indexOf("/");
			  if(idx > -1)
			   {
			     mask = textValue.substr(idx + 1);
			     var maskRegex = /^[0-9]\d*$/;
			     if(!maskRegex.test(mask))
			     {
			       isValid = false;
			       errorDesc += txtEl.dom.getAttribute("maskErrText") ? txtEl.dom.getAttribute("maskErrText") : ", the ip mask in this field is not number type.";
			       
			     }
			   }
	      }
	      else
	      {
	        isValid = false;
			errorDesc += txtEl.dom.getAttribute("maskErrText") ? txtEl.dom.getAttribute("maskErrText") : ", the ip mask separator in this field is less than one oblique.";
	      }
	  }
	  else
	  {
	     if(obliqueLineNum > 0)
		  {
			  isValid = false;
			  errorDesc += txtEl.dom.getAttribute("numErrText") ? txtEl.dom.getAttribute("numErrText") : ", the ip mask separator of oblique in this field is forbidden .";
		  }
	  }
	  if(!isValid)
	  {
	    return LegoTag.exeValid(true,txtEl,errorDesc);
	  }
	  

	   if(dotNum == 3 && colonNum == 0)
	   {
	      LegoTag.keypreTextIpv4Event(txtEl , event);
	      LegoTag.clearInvalid(txtEl);
	      var isIpv4 = LegoTag.isIpv4(txtEl , true);
	      if(isIpv4)
	      {
	        if(textValue.split(".")[0] == "127" && !txtEl.dom.getAttribute("validator")){
	           isValid = false;
		       errorDesc += txtEl.dom.getAttribute("regexV4Text")?txtEl.dom.getAttribute("regexV4Text"):", incorrect IPv4 mask format, 127.*.*.* is forbidden.";
	        }
	        else
	        {
	            textValue = txtEl.dom.value.replace(/\s/ig,"");
	            idx = textValue.indexOf("/");
			    if(idx > -1)
			    {
			     mask = textValue.substr(idx + 1);
			    }
		        if(maskRequired && idx > -1 && (mask < 1 || mask > 32))
		        {
		          isValid = false;
		          errorDesc += txtEl.dom.getAttribute("maskErrText")?txtEl.dom.getAttribute("maskErrText"):", incorrect IPv4 mask format.";
		        }
	        }
	      }
	      else
	      {
	        isValid = false;
	        errorDesc += txtEl.dom.getAttribute("regexV4Text")?txtEl.dom.getAttribute("regexV4Text"):", incorrect IPv4 address format.";
	      }
	   }
	   else if((dotNum == 0 && colonNum >= 2)) 
	   {
	     LegoTag.keypreTextIpv6Event(txtEl , event);
	     LegoTag.clearInvalid(txtEl);
	     var isIpv6 = LegoTag.isIpv6(txtEl , true);
	     if(isIpv6)
	     {
	       var t = textValue;
	       if(maskRequired){
	         t = textValue.split("/")[0];
	       }
	       if("::" == LegoTag.compressIPv6(t))
	       {
	          isValid = false;
		      errorDesc += txtEl.dom.getAttribute("regexV6Text")?txtEl.dom.getAttribute("regexV6Text"):", incorrect IPv6 mask format, all zero is forbidden.";
	       }
	       else
	       {
	         textValue = txtEl.dom.value.replace(/\s/ig,"");
	         idx = textValue.indexOf("/");
			 if(idx > -1)
			 {
			    mask = textValue.substr(idx + 1);
			 }
		     if(maskRequired && idx > -1 && (mask < 1 || mask > 128))
		      {
		         isValid = false;
		         errorDesc += txtEl.dom.getAttribute("maskErrText")?txtEl.dom.getAttribute("maskErrText"):", incorrect IPv6 mask format.";
		     }
	       }
	     }
	     else
	     {
	       isValid = false;
	       errorDesc += txtEl.dom.getAttribute("regexV6Text")?txtEl.dom.getAttribute("regexV6Text"):", incorrect IPv6 address format.";
	     }
	   }
	}
	var flag =!isValid;
 	return LegoTag.exeValid(flag,txtEl,errorDesc);
}


LegoTag.validNumber = function (txt) {
	if(!txt){
		return false;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return false;
 	}
 	var txtValue = txtEl.getValue();
 	var minValue = parseFloat(txtEl.dom.getAttribute("minValue"));
 	var maxValue = parseFloat(txtEl.dom.getAttribute("maxValue"));
 	var isValid = true;
 	var errorDesc = "";
 	if (!isNaN(txtEl.dom.getAttribute("minValue")) && minValue > parseFloat(txtValue)) {
 		isValid = false;
 		errorDesc += txtEl.dom.getAttribute("minText")?txtEl.dom.getAttribute("minText"):"The mininum value for this field is " + minValue +";";
 	}

 	if (!isNaN(txtEl.dom.getAttribute("maxValue")) && maxValue < parseFloat(txtValue)) {
 		isValid = false;
 		errorDesc += txtEl.dom.getAttribute("maxText")?txtEl.dom.getAttribute("maxText"):"The maxinum value for this field is " + maxValue +";";
 	}
 	if(!txtEl.dom.getAttribute("decimal")&& (txtValue.indexOf("0")==0 && txtValue.length >1||txtValue.indexOf(".")!=-1)){
 		txtValue.value = "";
 		isValid = false;
 	}
 	errorDesc = txtEl.dom.getAttribute("numErrText")?txtEl.dom.getAttribute("numErrText"):errorDesc;
 	var flag = txtValue && !isValid;
 	return LegoTag.exeValid(flag,txtEl,errorDesc);
 }
LegoTag.validDecimal = function(txt){
	if(!txt){
		return false;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return false;
 	}
 	var txtValue = txtEl.getValue();
 	var isValid = true;
 	var errorDesc = "";
 	var decimalLen = parseFloat(txtEl.dom.getAttribute("decimal"));
 	if(txtValue.indexOf(".")>=0)
 	{
 		var nowLen = txtValue.length - txtValue.indexOf(".") - 1;
 		if(nowLen > decimalLen)
 		{
 			isValid = false;
 			errorDesc += txtEl.dom.getAttribute("decimalText")?txtEl.dom.getAttribute("decimalText"):"The maxinum decimal length for this field is " + txtValue +".";
 		}
 	}
 	var flag = txtValue && !isValid;
 	return LegoTag.exeValid(flag,txtEl,errorDesc);	
 }
LegoTag.validAreaLen = function (txt) {
	if(!txt){
		return false;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return false;
 	}
 	var txtValue = txtEl.getValue();
 	var maxlength = parseInt(txtEl.dom.getAttribute("maxlengthExt"));
 	var isValid = true;
 	var errorDesc = "";
 	if (maxlength && maxlength>0 && maxlength<txtValue.length) {
 		txtEl.dom.value = txtValue.substring(0,maxlength);
 		isValid = false;
 		errorDesc += "The maxinum length for this field is " + maxlength +";";
 	}
 	errorDesc = txtEl.dom.getAttribute("maxLengthText")?txtEl.dom.getAttribute("maxLengthText"):errorDesc;
 	var flag = txtValue && !isValid;
 	return LegoTag.exeValid(flag,txtEl,errorDesc);
 }
 
LegoTag.validAreaMinLen = function (txt) {
	if(!txt){
		return false;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return false;
 	}
 	var txtValue = txtEl.getValue();
 	var minlength = parseInt(txtEl.dom.getAttribute("minlengthExt"));
 	var isValid = true;
 	var errorDesc = "";
 	if (minlength && minlength>0 && minlength>txtValue.length) {
 		isValid = false;
 		errorDesc += "The minimal length for this field is " + minlength +";";
 	}
 	errorDesc = txtEl.dom.getAttribute("minLengthText")?txtEl.dom.getAttribute("minLengthText"):errorDesc;
 	var flag = txtValue && !isValid;
 	return LegoTag.exeValid(flag,txtEl,errorDesc);
 } 
LegoTag.exeValid = function (flag,txtEl,errorDesc){
 	if(flag){
 		txtEl.addClass("x-form-invalid");
 		var parentDiv = txtEl.parent(".bc_input");
 		if(parentDiv)
 		{
 		   parentDiv.addClass("bc-input-invalid");
 		}
 		
 		if (txtEl.dom.getAttribute("validField")) {
 			var txtLabel = document.getElementById(txtEl.dom.id + "_label");
 			if(!txtLabel){
 			  var cid = txtEl.dom.id;
 			  var tid = cid.substr(0,cid.indexOf("_t"));
 			  if(document.getElementById(tid+ "_label")){
 			     txtLabel = document.getElementById(tid+ "_label");
 			  }
 			}
 			var txtLabelStr = (txtLabel?txtLabel.innerHTML.replace(/:/g,""):"").trim();
 			if(errorDesc.indexOf("{0}") != -1){
 				errorDesc = errorDesc.replace(/\{0\}/g,txtLabelStr);
 			}else{
	 			errorDesc = txtLabelStr + errorDesc;
 			}
 		}
 		if (txtEl.dom.getAttribute("qtipMode")) {
 			txtEl.dom.qtip = errorDesc;
 			txtEl.dom.qclass = 'x-form-invalid-tip';
 			return errorDesc;
 		}
		var errorIcon = Ext.get(txtEl.dom.id+"_valid");
 		if(!errorIcon){
			errorIcon = txtEl.parent().createChild({cls:'x-form-invalid-icon',id: txtEl.dom.id+"_valid"});
 		}
 		errorIcon.alignTo(txtEl.hasClass("x-comboarrow")?txtEl.next():txtEl, 'tl-tr', [2, 0]);
 		errorIcon.dom.qtip = errorDesc;
 		errorIcon.dom.qclass = 'x-form-invalid-tip';
 		errorIcon.show();
 		return errorDesc;
 	}else{
 		txtEl.removeClass("x-form-invalid");
 		var parentDiv = txtEl.parent(".bc_input");
 		if(parentDiv)
 		{
 		   parentDiv.removeClass("bc-input-invalid");
 		}
 		if (txtEl.dom.getAttribute("qtipMode")) {
 			txtEl.dom.qtip = "";
 			txtEl.dom.qclass = "";
 			return null;
 		}
 		var errorIcon = Ext.get(txtEl.dom.id+"_valid");
 		if(errorIcon){
	 		errorIcon.dom.qtip = "";
	 		errorIcon.hide();
 		}
 		return null;
 	}
}
LegoTag.clearInvalid = function (el){
	var ele = el;
	if (typeof(ele) == "string") {
		ele = Ext.get(el);
	}
	var errorIcon =  Ext.get(ele.dom.id+"_valid");
	if(ele){
		ele.dom.qtip="";
		ele.removeClass("x-form-invalid")
	}
	if(errorIcon){
		errorIcon.remove();
	}
}
LegoTag.validEvent = function (src,ev){
	var target = Ext.fly(src);
	if (!src || target.dom.disabled) {
		return true;
	}
	if(target.dom.getAttribute("type")== "text" && target.dom.getAttribute("regexText")&& !target.dom.getAttribute("regex")){
		var result = LegoTag.validSpecialChar(target);
		if (result) {
			return false;
		}
	}
	if (target.dom.getAttribute("isRequired") && target.dom.getAttribute("isRequired") == "true") {
		var result = LegoTag.validBlank(target);
		if (result) {
			return false;
		}
	}
	if (target.dom.getAttribute("numberfield")){
		var result = LegoTag.valididNum(target);
		if(result){
			return false;
		}
	}
	if (target.dom.getAttribute("maxlenExtMode") && target.dom.getAttribute("maxlengthExt")) {
		var result = LegoTag.validAreaLen(target);
		if (result) {
			return false;
		}
	}
	if(target.hasClass("x-datefield")){
	    var result = LegoTag.validDateField(target);
	    if (result) {
			return false;
		}
	}
	if (target.dom.getAttribute("regex")) {
		var result = LegoTag.validRegex(target);
		if (result) {
			return false;
		}
	}
	if (target.dom.getAttribute("minlengthExt")) {
		var result = LegoTag.validAreaMinLen(target);
		if (result) {
			return false;
		}
	}
	if (target.dom.getAttribute("validator")) {
		var validator = target.dom.getAttribute("validator");
		validator = validator.replace(/\(.*\)/g,"");
		var validMsg = eval(validator+".call(this,target.dom)");
		var flag = (typeof(validMsg) == "string");
		LegoTag.exeValid(flag,target,validMsg);
		if (flag) {
			return false;
		}
	}
	if (target.dom.getAttribute("minValue") || target.dom.getAttribute("maxValue")) {
		var result = LegoTag.validNumber(target);
		if (result) {
			return false;
		}
	}
	if (target.dom.getAttribute("decimal")){
		var result = LegoTag.validDecimal(target);
		if(result){
			return false;
		}
	}	
	if (target.dom.getAttribute("isMask")){
		var result = LegoTag.validMask(target , ev);
		if(result){
			return false;
		}
	} else if (target.dom.getAttribute("isIp")){
		var result = LegoTag.validIP(target , ev);
		if(result){
			return false;
		}
    }
    if (target.dom.getAttribute("isIPV6")){
		var result = LegoTag.validIPx(target, ev);
		if(result){
			return false;
		}
	}
	return true;
}
LegoTag.getValidResult = function (src,ev){
	var target = Ext.fly(src);
	if (!src || target.dom.disabled) {
		return null;
	}
	
	if(target.dom.getAttribute("type")== "text" && target.dom.getAttribute("regexText")&& !target.dom.getAttribute("regex")){
		var result = LegoTag.validSpecialChar(target);
		if (result) {
			return result;
		}
	}
	if (target.dom.getAttribute("isRequired") && target.dom.getAttribute("isRequired")== "true") {
		var result = LegoTag.validBlank(target);
		if (result) {
			return result;
		}
	}
	if (target.dom.getAttribute("numberfield")){
		var result = LegoTag.valididNum(target);
		if(result){
			return result;
		}
	}
	if (target.dom.getAttribute("maxlenExtMode") && target.dom.getAttribute("maxlengthExt")) {
		var result = LegoTag.validAreaLen(target);
		if (result) {
			return result;
		}
	}
	if(target.hasClass("x-datefield")){
	    var result = LegoTag.validDateField(target);
	    if (result) {
			return result;
		}
	}
	if (target.dom.getAttribute("regex")) {
		var result = LegoTag.validRegex(target);
		if (result) {
			return result;
		}
	}
	if (target.dom.getAttribute("minlengthExt")) {
		var result = LegoTag.validAreaMinLen(target);
		if (result) {
			return result;
		}
	}
	if (target.dom.getAttribute("validator")) {
		var validator = target.dom.getAttribute("validator");
		validator = validator.replace(/\(.*\)/g,"");
		var validMsg = eval(validator+".call(this,target.dom)");
		var flag = (typeof(validMsg) == "string");
		var result = LegoTag.exeValid(flag,target,validMsg);
		if (flag) {
			return result;
		}
	}
	if (target.dom.getAttribute("minValue") || target.dom.getAttribute("maxValue")) {
		var result = LegoTag.validNumber(target);
		if (result) {
			return result;
		}
	}
	if (target.dom.getAttribute("decimal")){
		var result = LegoTag.validDecimal(target);
		if(result){
			return result;
		}
	}
	if (target.dom.getAttribute("isMask")){
		var result = LegoTag.validMask(target);
		if(result){
			return result;
		}
	} else if (target.dom.getAttribute("isIp")){
		var result = LegoTag.validIP(target);
		if(result){
			return result;
		}
	}
	
	if (target.dom.getAttribute("isIPV6")){
		var result = LegoTag.validIPx(target);
		if(result){
			return result;
		}
	}
	return null;
}
LegoTag.validBlank = function (txt) {
	if(!txt){
		return false;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return false;
 	}
 	var txtValue = txtEl.getValue();     
 	if(txtValue){
 	var flag = (txtValue.length == 0) ;  
 	var errorDesc = txtEl.dom.getAttribute("blankText")?txtEl.dom.getAttribute("blankText"):"This field is required";
 	 return LegoTag.exeValid(flag,txtEl,errorDesc);
 	}else{
 	 return	LegoTag.validSelectBox(txt)
 	}
 }

LegoTag.validText = function(src,flag,ev){
	var target = Ext.fly(src); 
	if(target.dom.getAttribute("maxlength")){
	var maxlength = target.dom.getAttribute("maxlength") ;
	var errorDesc = src.getAttribute("maxLengthText")?src.getAttribute("maxLengthText"):"the maxlength for this field is"+ maxlength;
	if(target.dom.getAttribute("validZh_CN") && src.getAttribute("validZh_CN") === "true"){
		var zh_cn = false;
		var input = src.value;
        var inputLength = 0 ;
        var chars = input.split(""); 
		for(var i=0;i<chars.length;i++) 
		{
			if(chars[i].charCodeAt(0)<299) 
			{ 
				inputLength++; 
			} 
			else 
			{ 
				inputLength += 2;
				zh_cn = true;
			} 
		}
		if(zh_cn === true){
		  textSrcLength = inputLength;
		  
		  if(maxlength < textSrcLength  && (flag == 1 || flag == 2)){
			var e=ev||event;
			var k = e.keyCode;
			if((k>=65 && k <=90) || (k>=48 && k <=57) ||(k>=96 && k <=111 && k!=108) || (k>=186 && k <=192) ||(k>=219 && k <=222)|| k==32){
		     var curValue = src.value;
		     var curLen = 0;
		     for(var i=0; i<=maxlength; i++){
		       curValue = curValue.substr(0,maxlength-i);
		       curLen = LegoTag.getTextLength(curValue);
		       if(curLen <= maxlength){
		         break;
		       }
		    }
		    src.value = curValue;
			    return LegoTag.exeValid(true,target,errorDesc);
			}else{
				return null;
			}
		 }else if(flag == 3 || (flag == 2 && maxlength >= textSrcLength)){
			 return LegoTag.exeValid(false,target,errorDesc);
		 }else{
			 return null;
		 }
		 
		}else{
			if(maxlength == textSrcLength && !target.hasClass("x-form-invalid") && (flag == 1 || flag == 2) && maxlength==src.value.length){
				var e=ev||event;
				var k = e.keyCode;
				if((k>=65 && k <=90) || (k>=48 && k <=57) ||(k>=96 && k <=111 && k!=108) || (k>=186 && k <=192) ||(k>=219 && k <=222)|| k==32){
				    return LegoTag.exeValid(true,target,errorDesc);
				}else{
					return null;
				}
			 }else if(flag == 3 || (flag == 2 && maxlength != src.value.length)){
				 return LegoTag.exeValid(false,target,errorDesc);
			 }else{
				 return null;
			 }
		}
	}else{
	   if(maxlength == textSrcLength && !target.hasClass("x-form-invalid") && (flag == 1 || flag == 2) && maxlength==src.value.length){
			var e=ev||event;
			var k = e.keyCode;
			if((k>=65 && k <=90) || (k>=48 && k <=57) ||(k>=96 && k <=111 && k!=108) || (k>=186 && k <=192) ||(k>=219 && k <=222)|| k==32){
			    return LegoTag.exeValid(true,target,errorDesc);
			}else{
				return null;
			}
		 }else if(flag == 3 || (flag == 2 && maxlength != src.value.length)){
			 return LegoTag.exeValid(false,target,errorDesc);
		 }else{
			 return null;
		 }
	   }
	}
}
LegoTag.getTextLength = function(objVal){
    var currentLength = 0;
    var chars = objVal.split(""); 
	for(var i=0;i<chars.length;i++) 
	{
		if(chars[i].charCodeAt(0)<299) 
		{ 
			currentLength++; 
		} 
		else 
		{ 
			currentLength += 2; 
		} 
	} 
	return currentLength;
}
LegoTag.validSelectBox = function(src){
	if(!src){
		return false;
	}
	var txtEl = src;
	if(typeof(src) == "string"){
	 	txtEl = Ext.get(src);
	}
 	if(!txtEl || txtEl.hasClass("x-item-disabled")){
 		return false;
 	}
 	var listFlag = !txtEl.dom.getAttribute("isMultySelect")&& !txtEl.first("",true);
 	var mutyFlag = txtEl.dom.getAttribute("isMultySelect")=="true" && txtEl.select(".x-form-list-checked").getCount() == 0 ;
 	var flag = (listFlag || mutyFlag) ; 
 	var errorDesc = txtEl.dom.getAttribute("blankText")?txtEl.dom.getAttribute("blankText"):"This field is required";
 	return LegoTag.exeValid(flag,txtEl,errorDesc);
}

LegoTag.space = function(src,ev){
	var target = Ext.fly(src); 
	var regexp = /^[a-zA-Z_\u4e00-\u9fa5]{1}[\u4e00-\u9fa5\w-]*$/;
	var regexp2 = /^[a-zA-Z_]{1}[\w-]*$/;
	var regexp3 = /^[a-zA-Z_.]{1}[\w-.]*$/;
	if(target.dom.type=="text" && target.dom.getAttribute("regex") && (target.dom.getAttribute("regex")==regexp || target.dom.getAttribute("regex")==regexp2 ||target.dom.getAttribute("regex")==regexp3)){
		var k = ev.keyCode;	
		var e = ev || event;
		if (k == 32) {
			Ext.lib.Event.stopEvent(e);
		}
	}
    if(target.dom.getAttribute("validZh_CN") && src.getAttribute("validZh_CN") === "true"){
        var input = src.value;
        var inputLength = 0 ;
        var chars = input.split(""); 
		for(var i=0;i<chars.length;i++) 
		{
			if(chars[i].charCodeAt(0)<299) 
			{ 
				inputLength++; 
			} 
			else 
			{ 
				inputLength += 2; 
			} 
		} 
		textSrcLength = inputLength;
	}else{
	   textSrcLength =src.value.length;
	}
}

LegoTag.validSpecialChar = function(txt){
	if(!txt){
		return false;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return false;
 	}
 	if(txtEl.getValue()){
	   var flag = (txtEl.getValue().indexOf("'") != -1 || txtEl.getValue().indexOf('"')!=-1 || txtEl.getValue().indexOf("<")!=-1 || txtEl.getValue().indexOf(">")!=-1  || txtEl.getValue().indexOf("#")!=-1 || txtEl.getValue().indexOf("&")!=-1) ; 
	   var errorDesc = txtEl.dom.getAttribute("regexText")?txtEl.dom.getAttribute("regexText"):"Cannot enter special characters such as quotes, <, >, #, &.";
	   return LegoTag.exeValid(flag,txtEl,errorDesc);
 	}
}
LegoTag.CopyPasswordInput = function(ev,target){
	var ev = ev ||window.event || arguments.callee.caller.arguments[0];
	var key;
    var isCtrl;
	  if(window.event)
	   {
		  key = window.event.keyCode;
		if(window.event.ctrlKey)
		  isCtrl = true;
		else
		  isCtrl = false;
		}
		else
		{
		   key = ev.which;
		   if(ev.ctrlKey)
		      isCtrl = true;
		   else
		      isCtrl = false;
		}
	if(ev.keyCode == 67 || ev.keyCode == 86)
	{
		if(isCtrl)
		{
			Ext.lib.Event.stopEvent(ev);
		}
	}
}
LegoTag.substrByValid = function(comp ,maxlength)
{
	var curValue = comp.value;
	var curLen = 0;
	 for(var i=0; i<=maxlength; i++){
	   curValue = curValue.substr(0,maxlength-i);
	   curLen = LegoTag.getTextLength(curValue);
	   if(curLen <= maxlength){
	     break;
	   }
	}
	comp.value = curValue;
}
LegoTag.setZhTextValue = function(regText , id )
{
	  var comp = document.getElementById(id);
	  if(!comp){
	    return false;
	  }
	  var type = comp.type;
	  comp.value = regText;
	  textSrcLength = comp.value.length;
	  if(type ==="text" || type === "textarea"){
	     var target = Ext.fly(comp); 
	     var maxlength = comp.getAttribute("maxlength") ;
		 if(maxlength){
		  var errorDesc = comp.getAttribute("maxLengthText")?comp.getAttribute("maxLengthText"):"the maxlength for this field is"+ maxlength;
	       if(comp.getAttribute("validZh_CN") && comp.getAttribute("validZh_CN") === "true"){
			var zh_cn = false;
			var input = comp.value;
	        var inputLength = 0 ;
	        var chars = input.split(""); 
			for(var i=0;i<chars.length;i++) 
			{
				if(chars[i].charCodeAt(0)<299) 
				{ 
					inputLength++; 
				} 
				else 
				{ 
					inputLength += 2;
					zh_cn = true;
				} 
			}
			textSrcLength = inputLength;
			if(zh_cn == true){
			  if(maxlength < textSrcLength ){
			    LegoTag.substrByValid(comp ,maxlength);
				return LegoTag.exeValid(true,target,errorDesc);
			 }else{
				 return LegoTag.exeValid(false,target,errorDesc);
			 }
			 
			}else{
				if(maxlength < textSrcLength ){
				    LegoTag.substrByValid(comp ,maxlength);
					return LegoTag.exeValid(true,target,errorDesc);
				 }else{
					return LegoTag.exeValid(false,target,errorDesc);
				 }
			}
	       }else{
			   if(maxlength < textSrcLength ){
			      LegoTag.substrByValid(comp ,maxlength);
			      return LegoTag.exeValid(true,target,errorDesc);	
			   }else{
					 return LegoTag.exeValid(false,target,errorDesc);
			   }
	       }
		}
	     
	  }else{
	    alert("the compoment provided is invalid.at present,just support text and textarea.");
	    return false;
	  }
}
LegoTag.validDateField = function (txt) {
	if(!txt){
		return false;
	}
	var txtEl = txt;
	if(typeof(txt) == "string"){
	 	txtEl = Ext.get(txt);
	}
 	if(!txtEl || txtEl.dom.disabled){
 		return false;
 	}
 	var txtValue = txtEl.getValue();
 	if(txtValue){
 	  var dateFormat = LegoTag.getDateFormat(txtEl);
 	  var errorDesc = txtEl.dom.getAttribute("valueText")?txtEl.dom.getAttribute("valueText"):"This valueText is not null";
      var retDate = Date.parseDate(txtValue, dateFormat);
      if(retDate && retDate.format(dateFormat)!=txtValue)
      {
        return LegoTag.exeValid(true,txtEl,errorDesc);
      }
      return null;
 	}
 }

