<%@ page language="java" pageEncoding="UTF-8"%>
<%@ taglib uri="/struts-tags" prefix="s"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="/lego-tags" prefix="lego"%>
<%@ page import="java.util.List,java.util.ArrayList" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<%
    List<String> exeportList = (List<String>)request.getAttribute("exeportList") ;
    final String[] exportType = new String[]{"pdf" , "excel" , "html" , "rtf"} ;
    if(null == exeportList)
    {
    	exeportList = new ArrayList<String>() ;
    }
    String theme = (String)request.getAttribute("mailTheme") ;
    if(null == theme)
    {
    	theme = "" ;
    }
    String type = (String)request.getAttribute("type") ;
    Long sessionId = (Long)request.getAttribute("sessionId") ;
%>
<html>
	<head>
		<lego:head extend="all"></lego:head>
		<link href="<s:url value='/iReport/styles/public.css' includeParams='none' />" type=text/css	rel=stylesheet>
		<link rel="stylesheet" type="text/css" href="<s:url value='/iReport/styles/searchui/public.css'  includeParams='none' />" />
		<script type="text/javascript"	src="<s:url value='/iReport/scripts/jquery.js'  includeParams='none' />"></script>
		<script type="text/javascript"	src="<s:url value='/iReport/scripts/WaitBar.js'  includeParams='none' />"></script>
		<style type="text/css">
			.LEGO_text_style {
			    color: #464646;
			    font-family: Arial;
			    font-size: 12px;
			    font-weight: bold;
			    margin-left: 20px;
			}
		</style>
		<script type="text/javascript">
			var exportTypeConstant = ["pdf" , "excel" , "html" , "rtf"] ;
			
			function hasSameElement(str, c) {
				var tempArr = str.split(c);
				var tempArr2 = new Array();
				var count = 0;
				for (var i = 0; i < tempArr.length; i++) {
					var j = i + 1;
					for (j; j < tempArr.length; j++) {
						if (tempArr[j] == tempArr[i]) {
							var existAready = false;;
							for (var k = 0; k < count; k++) {
								if (tempArr[j] == tempArr2[k]) {
									existAready = true;
									break;
								}
							}
							if (!existAready)
								tempArr2[count++] = tempArr[i];
						}
					}
				}
				return tempArr2.toString();
			}
			
			function okBtnClick()
			{
				if(!checkContentField()){
					return false;
				}
				if(!checkEmpty())
				{
					return false ;
				}
				if(!checkEmailAddress("addressee"))
				{
					return false ;
				}
				if(!checkEmailAddress("ccAddressee"))
				{
					return false ;
				}
				var params = getSendMailMessage() ;
				WaitBar.show();
				LegoTag.Ajax.request({
					method:'post',
	                url:'exportAndSendEmail.do',
	                params: params,
	                sync:true,
					timeout:1800000,
	                success:function(response, options)
	                {
	                    var responseText = response.responseText;
	                	if (responseText == "success") 
	                    {
	    					LegoTag.Msg.succeed('<s:text name="report.common.operator.success" />', function(){
	                        	WaitBar.close();
		                        LegoTag.getSelfWindow().close(); 
							});                    
	                    } 
	                    else if(null != responseText && "" != responseText)
	                    {
	                    	LegoTag.Msg.failed(responseText , function(){
	                        	WaitBar.close();
		                        LegoTag.getSelfWindow().close(); 
	                        });
	                    }
	                    else
	                    {
	                    	 LegoTag.Msg.failed('<s:text name="report.common.operator.fail" />' , function(){
	                        	WaitBar.close();
		                        LegoTag.getSelfWindow().close(); 
	                        });
	                    }
	               	},
					failure : function(action) {
						LegoTag.Msg.failed('<s:text name="report.common.operator.fail" />' , function(){
                        	WaitBar.close();
	                        LegoTag.getSelfWindow().close(); 
                        });
					} 
            	});
			}
			
			function checkEmpty()
			{
				var addressee = jQuery("#addressee").val().trim();  
				if("" == addressee)
				{
					LegoTag.Msg.alert("<s:text name='alert.msg.title'/>" , "<s:text name='report.sendmail.addressee.notEmpty'/>");
               		return false; 
				}
				var exportTypes = getExportTypes() ;
				if("" == exportTypes.trim())
				{
					LegoTag.Msg.alert("<s:text name='alert.msg.title'/>" , "<s:text name='report.sendmail.attachment.notEmpty'/>");
               		return false; 
				}
				var theme = jQuery("#theme").val().trim() ;
				if("" == theme)
				{
					LegoTag.Msg.alert("<s:text name='alert.msg.title'/>" , "<s:text name='report.sendmail.theme.notEmpty'/>");
               		return false; 
				}
				return true ;
			}
			
			function checkEmailAddress(addressee){
	         
	         var email = jQuery("#" + addressee);      
	         var emailRegex = /^\w+([-\.]\w+)*@\w+([-\.]\w+)*\.\w+([-\.]\w+)*$/;
        	 var emailArray = new Array(); 
	          
	         if(email.val().trim() != ""){
	        	 emailArray = email.val().trim().split(";"); 
        		 for (i=0; i < emailArray.length; i++ )   
        	     {   
        			if(!emailRegex.test(emailArray[i])) {
        	        	LegoTag.Msg.failed("<s:text name='report.reporttask.valInput.emial'/>");
        	        	return false;
        	        }
        	     }
	            
		         var emailTemp = hasSameElement(email.val().trim(),";");
		         if(emailTemp != ""){
		             LegoTag.Msg.failed("<s:text name='report.system.valInput.checkSameEmail'><s:param>" + emailTemp + "</s:param></s:text>");
		             return false;              
		         }
	         }
        	 return true;         
     		}
			function checkEmailCCAddressee()
			{
				
		         var email = jQuery("#ccAddressee");      
		         var emailRegex = /^\w+([-\.]\w+)*@\w+([-\.]\w+)*\.\w+([-\.]\w+)*$/;
	        	 var emailArray = new Array(); 
		         
		         if(email.val().trim() != "")
		         {
		        	emailArray = email.val().trim().split(";"); 
	        		for (i=0; i < emailArray.length; i++ )   
	        	    {   
	        			if(!emailRegex.test(emailArray[i])) 
	        			{
	        				var ts = "<s:text name="report.common.email.regexText"/>";
	    					return ts;
	        	        }
	        	    }
		         }
      	 		return true;
		    }
			function checkEmailAddressee()
			{
				
		         var email = jQuery("#addressee");      
		         var emailRegex = /^\w+([-\.]\w+)*@\w+([-\.]\w+)*\.\w+([-\.]\w+)*$/;
	        	 var emailArray = new Array(); 
		        
		         if(email.val().trim() != "")
		         {
		        	emailArray = email.val().trim().split(";"); 
	        		for (i=0; i < emailArray.length; i++ )   
	        	    {   
	        			if(!emailRegex.test(emailArray[i])) 
	        			{
	        				var ts = "<s:text name="report.common.email.regexText"/>";
	    					return ts;
	        	        }
	        	    }
		         }
     	 		return true;
		    }
			function getSendMailMessage()
			{
				var type = jQuery("#type").val().trim();
				var sessionId = jQuery("#sessionId").val().trim();
				var addressee = jQuery("#addressee").val().trim();
				var ccAddressee = jQuery("#ccAddressee").val().trim();
				var exportTypes = getExportTypes();
				var theme = jQuery("#theme").val().trim();
				var content = jQuery("#content").val().trim();
				var keyValue = {
					"type":type,
					"sessionId":sessionId,
					"mainAddressees":addressee,
					"ccAddressee":ccAddressee,
					"exportTypes":exportTypes,
					"theme":theme,
					"content":content,
					"type":"email"
				} ;
				return keyValue ;
			}
			
			function getExportTypes()
			{
				var exportTypes = [];
				for(var index = 0 ; index < exportTypeConstant.length ; index ++)
				{	
					if(null != document.getElementById(exportTypeConstant[index]) && LegoTag.getChecked(exportTypeConstant[index]))
					{
						exportTypes.push(exportTypeConstant[index]) ;
					}
				}
				return exportTypes.join() ;
			}
			function checkContent() {
				
		         var content = document.getElementById('content').value.trim();         
		         var emailRegex = /^(?!\s*null$)(?![\s\S]*[\s]+null$)(?!\s*null\s{1}[\s\S]*$)(?![\s\S]*[\s]+null[\s]+[\s\S]*$)[\u4e00-\u9fa5。，：；！？、《》“”‘’￥（）【】\… \w!:;?.,#@$\-\r\n]*$/ig;
		         
		         if(content != "")
		         {
	        			if(!emailRegex.test(content)) 
	        			{
	        				var ts ='<s:text name="atic.report.sendEmail.contentRegex.white"/>';
	        				return ts;
	        	        }
	        	    
		         }
		         return true;
			}
			function checkContentField()
			{
				
		         var content = document.getElementById('content').value.trim();       
		         var emailRegex = /^(?!\s*null$)(?![\s\S]*[\s]+null$)(?!\s*null\s{1}[\s\S]*$)(?![\s\S]*[\s]+null[\s]+[\s\S]*$)[\u4e00-\u9fa5。，：；！？、《》“”‘’￥（）【】\… \w!:;?.,#@$\-\r\n]*$/ig;
		         
		         if(content != "")
		         {
	        			if(!emailRegex.test(content)) 
	        			{
	        				LegoTag.Msg.failed('<s:text name="atic.report.sendEmail.contentRegex.white"/>');
	        				return false;
	        	        }
	        	    
		         }
		         return true;
		    }
		</script>
	</head>

	<body>
		<lego:window>
			<lego:panel id="LegoPanel">
				<form id="taskPlanForm" method="post">
					<input type="hidden" id="type" name="type" value="<%=type %>" />
					<input type="hidden" id="sessionId" name="sessionId" value="<%=sessionId %>"/>
					<table width="100%" cellspacing="0" style="margin-top: 14px;" height="200px">
						
						<tr>
							<td width="10px;"></td>
							<td nowrap="nowrap" style="text-align: left;">
								<label class="LEGO_text_style">
									<s:text name="report.sendmail.addressee" /><s:text name="report.public.punctuation.colon" />
								</label>
							</td>
							<td width="15px;"></td>
							<td>
								<table>
									<tr>
										<td>
											<lego:textfield name="addressee" id="addressee" width="250px;" validator="checkEmailAddressee()" required="true" blankText="%{getText('report.sendmail.addressee.notEmpty')}" maxlength="1024" maxLengthText="%{getText('common.collector.name.email.maxlength')}"></lego:textfield>
										</td>
										
										<td>
											<label>
												<span> 
													<img title="<s:text name='report.report.reporttask.muchemail'/>" src="<s:url value='/iReport/images/online_help.gif' includeParams='none' />" style="vertical-align: middle;" /> 
												</span>
											</label>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr height="5px;"></tr>

						
						<tr>
							<td width="10px;"></td>
							<td nowrap="nowrap" style="text-align: left;">
								<label class="LEGO_text_style">
									<s:text name="report.sendmail.ccAddressee" /><s:text name="report.public.punctuation.colon" />
								</label>
							</td>
							<td width="15px;"></td>
							<td>
								<table>
									<tr>
										<td>
											<lego:textfield name="ccAddressee" id="ccAddressee" width="250px;" validator="checkEmailCCAddressee()" maxlength="1024" maxLengthText="%{getText('common.collector.name.email.maxlength')}"></lego:textfield>
										</td>
										
										<td>
											<label>
												<span> <img title="<s:text name='report.report.reporttask.muchemail'/>" src="<s:url value='/iReport/images/online_help.gif' includeParams='none' />" style="vertical-align: middle;" />
												</span>
											</label>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr height="5px;"></tr>

						
						<tr>
							<td width="10px;">
							</td>
							<td nowrap="nowrap" style="vertical-align: top; text-align: left;" align="right">
								<label class="LEGO_text_style">
									<s:text name="report.sendmail.attachment" /><s:text name="report.public.punctuation.colon" /><font color="red">*&nbsp;</font>
								</label>
							</td>
							<td width="15px;"></td>
							<td>
								<table>
									<tr>
										
										<%
											boolean isFirst = true ;
											for(int index = 0 , num = exportType.length ; index < num ; index ++)
											{
												if(exeportList.contains(exportType[index]))
												{
										%>
													<td>
														<%
															if(isFirst)
															{
																isFirst = false ;
														%>
																<lego:checkbox id="<%=exportType[index] %>" name="<%=exportType[index] %>" checked="true"></lego:checkbox>
														<%
															}
															else
															{
														 %>
														 		<lego:checkbox id="<%=exportType[index] %>" name="<%=exportType[index] %>"></lego:checkbox>
														 <%
														 	}
														  %>
														
													</td>
													<td>
														<label>
															<%=exportType[index].toUpperCase() %>
														</label>
													</td>
													<td width="15px;"></td>
										<%
												}
											}
										 %>
									</tr>
								</table>
							</td>
						</tr>
						<tr height="5px;"></tr>
						
						<tr>
							<td width="10px;"></td>
							<td nowrap="nowrap" style="text-align: left;">
								<label class="LEGO_text_style">
									<s:text name="report.sendmail.theme" /><s:text name="report.public.punctuation.colon" />
								</label>
							</td>
							<td width="15px;"></td>
							<td>
								<table>
									<tr>
										<td>
											<lego:textfield name="theme" id="theme" width="250px;" maxlength="500" required="true" 
											regex="/^(?!null$)[\u4E00-\u9FA5\。\，\：\；\！\？\、\《\》\“\”\‘\’\￥\（\）\【\】\…\ \w\!\:\;\?\.\,\-\(\)]*$/im" 
									        regexText="%{getText('atic.report.sendEmail.themeRegex.white')}" blankText="%{getText('report.sendmail.theme.notEmpty')}" value="%{mailTheme}"></lego:textfield>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr height="5px;"></tr>
						
						<tr>
							<td width="10px;">
							</td>
							<td nowrap="nowrap"
								style="vertical-align: top; text-align: left;" align="right">
								<label class="LEGO_text_style">
									<s:text name="report.sendmail.content" /><s:text name="report.public.punctuation.colon" />
								</label>
							</td>
							<td width="15px;">
							</td>
							<td style="padding-left: 2px;">
								<lego:textarea id="content" name="content" maxlength="5000" cols="60" rows="5" width="500px" validator="checkContent()"></lego:textarea>
							</td>
						</tr>
					</table>
					</div>
			</lego:panel>
			
			<lego:buttonArea>
				<lego:button id="commitBtn" value="%{getText('report.common.cofirm')}" onclick="okBtnClick()" />
				<lego:button id="cacelBtn" value="%{getText('report.common.cancel')}" onclick="LegoTag.getSelfWindow().close();" />
			</lego:buttonArea>
		</lego:window>
	</body>
</html>
