var sort_null_src = WEB_ROOT_ABS_PATH + "/elog/images/sort_null.gif";
var sort_ascend_src = WEB_ROOT_ABS_PATH + "/elog/images/sort_ascend.gif";
var sort_descend_src = WEB_ROOT_ABS_PATH + "/elog/images/sort_descend.gif";
var sort_null_img = "<img src='" + WEB_ROOT_ABS_PATH + "/elog/images/sort_null.gif'>";

function initImg(tblId, doc) 
{
   if (doc == undefined){
       doc = document;
    }
}

function initOtherColImg(tblId, colIndex, doc) 
{
   if (doc == undefined){
       doc = document;
    }    
	var tdArr = doc.getElementById(tblId).rows[0].cells;
	for (var i = 0 ; i < tdArr.length ; i++) {
		if (tdArr[i].onclick && i != parseInt(colIndex)) 
		{
			tdArr[i].className = "cell-spliter";
		}
	}
}

function resetSortImg(tblId, doc) {
   if (doc == undefined){
       doc = document;
    }    
    var tdArr = doc.getElementById(tblId).rows[0].cells;
    for (var i = 0; i < tdArr.length ; i++) 
    {
    	tdArr[i].className = "cell-spliter";	
    }
}

function convert(value, dataType) 
{
	if(value==null || value=="")
	{
		value = " ";
	}
	switch (dataType) 
	{
	  case "int":
		return parseInt(value);
	  case "date":
		return Date.parse(value);
	  case "ip":
	  	return value.split(':');
	  default:
		return value.toString();
	}
}


function generateComparator(colIndex, dataType) 
{
	return function compareTrs(tr1, tr2) 
	{
		var value1, value2;
		if (tr1.cells[colIndex].getAttribute("value")) 
		{
			value1 = convert(tr1.cells[colIndex].getAttribute("value"), dataType);
			value2 = convert(tr2.cells[colIndex].getAttribute("value"), dataType);
		} 
		else 
		{
			value1 = convert(tr1.cells[colIndex].firstChild.nodeValue, dataType);
			value2 = convert(tr2.cells[colIndex].firstChild.nodeValue, dataType);
		}
		if(dataType=="ip")
		{
			var v1 = value1[0].split('.');
			var v2 = value2[0].split('.');
			if(parseInt(v1[0])>parseInt(v2[0]))
			{
				return 1;
			}
			else if(parseInt(v1[0])<parseInt(v2[0]))
			{
				return -1;
			}
			if(parseInt(v1[1])>parseInt(v2[1]))
			{
				return 1;
			}
			else if(parseInt(v1[1])<parseInt(v2[1]))
			{
				return -1;
			}
			if(parseInt(v1[2])>parseInt(v2[2]))
			{
				return 1;
			}
			else if(parseInt(v1[2])<parseInt(v2[2]))
			{
				return -1;
			}
			if(parseInt(v1[3])>parseInt(v2[3]))
			{
				return 1;
			}
			else if(parseInt(v1[3])<parseInt(v2[3]))
			{
				return -1;
			}
			
			if(value1.length==2)
			{
				if(parseInt(value1[1])>parseInt(value2[1]))
				{
					return 1;
				}
				else if(parseInt(value1[1])<parseInt(value2[1]))
				{
					return -1;
				}
			}
			return 0;
		}
		else if(dataType == "int" || dataType == "date")
		{
			return value1 > value2 ? 1 : ((value1 < value2) ? -1 : 0);
		}
		else
		{
			var n1 = value1.length, n2 = value2.length;
			for(var i1 = 0,i2 = 0;i1 < n1 && i2 < n2; i1++,i2++)
			{
				var c1 = value1.charAt(i1);
				var c2 = value2.charAt(i2);
				if (c1 != c2) {
                    c1 = c1.toLocaleUpperCase();
                    c2 = c2.toLocaleUpperCase();
                    if (c1 != c2) {
                        c1 = c1.toLocaleLowerCase();
                        c2 = c2.toLocaleLowerCase();
                        if (c1 != c2) {
                            return c1 > c2 ? 1 : (c1 < c2 ? -1 : 0);
                        }
                    }
                }
			}
			return n1 - n2;
			
		}
	};
}	    

function sortTable(tblId, colIndex,flag,unmodifyColIndex,dataType) {
	var table = document.getElementById(tblId);
	var tbody = table.tBodies[0];
	var rows = tbody.rows;
	if (rows.length < 3) {
		return;
	}
	initOtherColImg(tblId, colIndex);
	var firstRow = rows[0];
	var rowArray = new Array;
	var td = firstRow.cells[colIndex];
	for (var i = 0, len = rows.length - 1; i < len; i++) {
		rowArray[i] = rows[i + 1];
	}
	if (table.sortCol == colIndex) {
		rowArray.reverse();
		
		if(td.className.indexOf('sort-asc') != -1)
		{
			td.className = "cell-spliter sort-desc";
		}
		else
		{
			if(td.className.indexOf('sort-desc') != -1)
			{
				td.className = "cell-spliter sort-asc";
			}
		}
		
	} else {
		rowArray.sort(generateComparator(colIndex, dataType));
		td.className = "cell-spliter sort-asc";
	}
	
	var fragment = document.createDocumentFragment();
	fragment.appendChild(firstRow);
	for (var i = 0, len = rowArray.length; i < len; i++) {
		if(flag!=null && flag!="")
		{
		  rowArray[i].cells[parseInt(flag)].firstChild.nodeValue = i + 1;
		}
		else
		{
		  rowArray[i].cells[0].firstChild.nodeValue = i + 1;
		}
		
		fragment.appendChild(rowArray[i]);
	}
	tbody.appendChild(fragment);
	table.sortCol = colIndex;
	
}


