	var $ = jQuery;
	var dataRangeObj = ConditionMgr.get("dateRange");	
	$("#btn_values").bind("click", function(e){
	    var dataRange = ConditionMgr.get("dateRange").getValueWithText();
	    if (dataRange){
	        if (dataRange){
	        	var startTimeStr = dataRange[0].text;
	        	var endTimeStr = dataRange[1].text;
	        	if(isCorrectFormat("yyyy-MM-dd HH:mm:ss",startTimeStr) && validateDateFormat("dateRange_startTimeId")
	        		&& isCorrectFormat("yyyy-MM-dd HH:mm:ss",endTimeStr) && validateDateFormat("dateRange_endTimeId"))
	        	{
	        		var hid = $("#h_currentDataRangeValue", parent.document);
                	if (!$("#h_currentDataRangeValue", parent.document).val())
                	{
                    	hid = $("<input id='h_currentDataRangeValue' type='hidden'/>", parent.document);
                    	hid.appendTo($(parent.document.body));
                	}
	        		hid.val(JSON.stringify(dataRange));
	        	}
	        }
	    }
	});
	
	var dataRangerValue = $("#h_currentDataRangeValue", parent.document).val();
	if (dataRangeObj && dataRangerValue)
	{
	    dataRangeObj.setValue(JSON.parse(dataRangerValue));
	    setTimeGraDisplay();
	}
	function setTimeGraDisplay() {		
		var dataRangeStr = ConditionMgr.get("dateRange").getValueWithText();	
		var startTimeStr = dataRangeStr[0].text;
		var startTime = getLongTimeByFmt(startTimeStr);
		var endTimeStr = dataRangeStr[1].text;
		var endTime = getLongTimeByFmt(endTimeStr);		
		var span = endTime - startTime;
		if(startTime >  endTime) {			
			document.getElementById('lbl_dateRange').innerHTML = "";
		}
		else if (span < 24 * 3600 && span >= 0) {
			document.getElementById('lbl_dateRange').innerHTML = window.parent.FIVE_MINUTE;
       	}
        else if (span < 7 * 24 * 3600 && span >= 24 * 3600) {
       		document.getElementById('lbl_dateRange').innerHTML = window.parent.ONE_HOUR;
        }
       	else if (span < 365 * 24 * 3600 && span >= 7 * 24 * 3600) {
        	document.getElementById('lbl_dateRange').innerHTML = window.parent.ONE_DAY;
        }
        else {
        	document.getElementById('lbl_dateRange').innerHTML = "";
        }
	}
	function validateDateFormat(dataId)
	{
	    var elDateTime=document.getElementById(dataId);
	  	var dateVal = elDateTime.value;
	  	var dateFormat = LegoTag.getDateFormat(Ext.get(elDateTime));
	    var retDate = Date.parseDate(dateVal, dateFormat);
	    
	    if(retDate && retDate.format(dateFormat)!=dateVal)
	    {
	    	return false;
	    }
	    if(retDate)
	    {
	    	return true;
	    }
	    
	    return false;
  	}