
function gv(id) {
	return ConditionMgr.get(id).getSimpleValue();
}
PluginMgr.add("switchOption", {
	initPlugin:function() {
		
	var isSupportOutbound = window.parent.isSupportOutbound;
	if (isSupportOutbound)
	{
		document.getElementById('subGroup_0_flowCompare_wrap').style.display ="block"; 
	}
	else
	{
		document.getElementById('subGroup_0_flowCompare_wrap').style.display ="none"; 
	}
	
	document.getElementById('lbl_dateRange').innerHTML = window.parent.FIVE_MINUTE;
		
	var direction_combobox = ConditionMgr.get("direction_combobox");
	direction_combobox.registEvent(direction_combobox, "onValueChange", function (event) {
		setSwitchOption();
	});
	
	var oDevice = ConditionMgr.get("netDevice_combobox");
	oDevice.registEvent(oDevice, "onValueChange", function (event) {
		jQuery.ajax({url:"AnalysisAction!getDeviceTypeByCombId.do?deviceId=" + this.getSimpleValue(), dataType:"json", success:function (result, textStatus) {
			ConditionMgr.get("netDevice_type").setValue({"value":result.data});
			setSwitchOption();
		}, async:false,cache:false});

	});
	var oIp = ConditionMgr.get("zone_ip");
	oIp.registEvent(oIp, "onValueChange", function (event) {
		jQuery.ajax({url:"AnalysisAction!getProtocolByBisId.do?bisId=" + gv("bis_combobox") + "&zoneId=" + gv("zone_combobox").value+ "&displayZoneIp=" + gv("zone_ip")+ "&deviceId=" + gv("netDevice_combobox"), dataType:"json", success:function (result, textStatus) {
			ConditionMgr.get("protocol_combobox").changeOptions(result.data);
		}, error:function (XMLHttpRequest, textStatus, errorThrown) {
		}, complete:function (XMLHttpRequest, textStatus) {
		}, async:true});
	});
	var protocol_combobox = ConditionMgr.get("protocol_combobox");
	protocol_combobox.registEvent(protocol_combobox, "onValueChange", function (event) {
		setSwitchOption();
	});
	
	var oUnit = ConditionMgr.get("unit");
	oUnit.registEvent(oUnit, "onValueChange", function (event) {
		setSwitchOption();
	});
	var isChange = false;
	var oProtocol = ConditionMgr.get("protocol_combobox");
	oProtocol.registEvent(oProtocol, "onValueChange", function (event) {
	    var oPro = gv("protocol_combobox");
	    var isV1Protocl = (oPro == 7 || oPro == 8 || oPro == 9 || oPro == 10);
		if(isV1Protocl)
		{
			jQuery.ajax({url:"AnalysisAction!getUnit2FlowCompare.do?isV1Protocl="+isV1Protocl, dataType:"json", success:function (result, textStatus) {
			ConditionMgr.get("unit").changeOptions(result.data);
			}, error:function (XMLHttpRequest, textStatus, errorThrown) {
			}, complete:function (XMLHttpRequest, textStatus) {
			}, async:true});
			isChange = true;
		}
		if(!isV1Protocl && isChange)
		{
			jQuery.ajax({url:"AnalysisAction!getUnit2FlowCompare.do?isV1Protocl="+isV1Protocl, dataType:"json", success:function (result, textStatus) {
			ConditionMgr.get("unit").changeOptions(result.data);
			}, error:function (XMLHttpRequest, textStatus, errorThrown) {
			}, complete:function (XMLHttpRequest, textStatus) {
			}, async:true});
			isChange = false;
		}
		LegoTag.dateEventTrigger = function(val ,time){
		    if (time == "dateRange_endTimeId")
		    {	    		
				setTimeGraDisplay();
		   	}
		   	if (time == "dateRange_startTimeId")
		    {	    		
				setTimeGraDisplay();
		   	}
		};	
	});
     
    var dataRange = ConditionMgr.get("dateRange").getValueWithText();
	var oStartTime = dataRange[0].text;
	var oEndTime = dataRange[1].text;
	var dr = ConditionMgr.get("dateRange");
	dr.startTime_txt.bind("blur", setTimeGraDisplay);
	dr.endTime_txt.bind("blur", setTimeGraDisplay);
	var aDevice = new Array("clean", "detect");
	var aTimeType = new Array("less1day", "morethan1day");
	var aUnit = new Array("kbps", "pps");
	
	function setSwitchOption() {
		var oDeviceType = ConditionMgr.get("netDevice_type").getSimpleValue();
		var direction = ConditionMgr.get("direction_combobox").getSimpleValue();
		var oSwitchOptionValue = aDevice[oDeviceType] + "_" + aTimeType[1] + "_" + aUnit[gv("unit")];
		if(aDevice[oDeviceType]=="clean" && aTimeType[1]=="less1day")
		{
	    	var oPro = gv("protocol_combobox");
	    	if(oPro == 0 || oPro == 1 || oPro == 2 || oPro == 7 || oPro == 8)
	    	{
				if ("1" == direction || "0" == direction)
				{
					oSwitchOptionValue = aDevice[oDeviceType] + "_" + aTimeType[1] + "_rebound_" + aUnit[gv("unit")];
				}
	    	}
		}
		if ("0" == direction)
		{
			oSwitchOptionValue = "all_direct_" + oSwitchOptionValue;
		}
		ConditionMgr.get("switchOption").setValue({"value":oSwitchOptionValue});
	}
	
	function setTimeGraDisplay() {		
		var dataRangeStr = ConditionMgr.get("dateRange").getValueWithText();	
		var startTimeStr = dataRangeStr[0].text;
		var startTime = getLongTimeByFmt(startTimeStr);
		var endTimeStr = dataRangeStr[1].text;
		var endTime = getLongTimeByFmt(endTimeStr);		
		var span = endTime - startTime;
		if(startTime >  endTime) {			
			document.getElementById('lbl_dateRange').innerHTML = "";
		}
		else if (span < 24 * 3600 && span >= 0) {
			document.getElementById('lbl_dateRange').innerHTML = window.parent.FIVE_MINUTE;
       	}
        else if (span < 7 * 24 * 3600 && span >= 24 * 3600) {
       		document.getElementById('lbl_dateRange').innerHTML = window.parent.ONE_HOUR;
        }
       	else if (span < 365 * 24 * 3600 && span >= 7 * 24 * 3600) {
        	document.getElementById('lbl_dateRange').innerHTML = window.parent.ONE_DAY;
        }
        else {
        	document.getElementById('lbl_dateRange').innerHTML = "";
        }
	}
	function getTimeType(start, end) {
		var oTimeSpan = getLongTimeByFmt(end) - getLongTimeByFmt(start);
		if (oTimeSpan < 24 * 3600) {
			return 0;
		} else {
			return 1;
		}
	}
		ConditionMgr.get("dateRange").checkDataInterface=function(){
			var dataRange = ConditionMgr.get("dateRange").getValueWithText();
			var oStartTime = dataRange[0].text;
			var oEndTime = dataRange[1].text;
			var oTimeSpan = getLongTimeByFmt(oEndTime) - getLongTimeByFmt(oStartTime);
			if (oTimeSpan >= 365 * 24 * 3600) 
			{
				var resultObj = {success : false,msg : window.parent.DataRangeWrongTip};
				return resultObj;
			} 
			else
			{
				var resultObj = {success : true,msg : ""};
				return resultObj;
			}
		}	
		ConditionMgr.get("zone_combobox").registEvent(ConditionMgr.get("zone_combobox"),"afterListenerChanged", function(event){
			var oSelectList = ConditionMgr.get("zone_combobox");
			oSelectList.setValue({value:"0",text: window.parent.CommonTotalTip});
		});
	}
});

$(document).ready(
function()
{
	$("#btn_values").bind("click", function(e){
		var _device = ConditionMgr.get("netDevice_combobox");
		var _zone = ConditionMgr.get("zone_combobox");
    	var deviceValue = _device.getValueWithText();
     	var zoneValue = _zone.getValueWithText();
     	if (deviceValue){
            var hid = $("#h_currentDeviceValues", parent.document);
            if (!$("#h_currentDeviceValues", parent.document).val()){
                hid = $("<input id='h_currentDeviceValues' type='hidden'/>", parent.document);
                hid.appendTo($(parent.document.body));
            }
        	hid.val(JSON.stringify(deviceValue));
        }
        if (zoneValue){
            var hid = $("#h_currentZoneValues", parent.document);
            if (!$("#h_currentZoneValues", parent.document).val()){
                hid = $("<input id='h_currentZoneValues' type='hidden'/>", parent.document);
                hid.appendTo($(parent.document.body));
            }
        	hid.val(JSON.stringify(zoneValue));
        }
	});
}
);	

jQuery(ConditionDataLoadChain).bind("afterAllConditionLoaded", function(ev)
{
	function dropZoneValue(zoneValue)
	{
		var lastIndex = zoneValue.length-1;
		if(zoneValue.indexOf('[') == 0 && zoneValue.indexOf(']')==lastIndex)
		{
			returnStr=zoneValue.substring(1, lastIndex);
		}
		else
		{
			returnStr=zoneValue;
		}
		return returnStr;
	}
	function setReportDeviceType()
	{
		var _device = ConditionMgr.get("netDevice_combobox");
		var deviceValue = $("#h_currentDeviceValues", parent.document).val();
		if (_device && deviceValue)
		{
			
			var aDevice = new Array("clean", "detect");
			var deviceId = JSON.parse(deviceValue).value;
			jQuery.ajax({url:"AnalysisAction!getDeviceTypeByCombId.do?deviceId=" + deviceId, dataType:"json", success:function (result, textStatus) {
				ConditionMgr.get("netDevice_type").setValue({"value":result.data});
				var oDeviceValue = $("#h_currentDeviceValues", parent.document).val();
				var deviceInfo = JSON.parse(deviceValue);
				var cbxDevice = ConditionMgr.get("netDevice_combobox");
				cbxDevice.setValue({value:deviceInfo.value,text:deviceInfo.text});
				cbxDevice.publishEvent("onValueChange");
			}, async:false,cache:false});
			
			var _zone = ConditionMgr.get("zone_combobox");
			var zoneValue = $("#h_currentZoneValues", parent.document).val();
			if (_zone && zoneValue)
			{
				var returnStr = dropZoneValue(zoneValue);
			    var returnValue = JSON.parse(returnStr).value;
			    var returnText = JSON.parse(returnStr).text;
			    if(returnValue > 0)
			    {
					_zone.setValue({value:returnValue,text:returnText});
				}
			}
		}
	}
	setReportDeviceType();
	
	jQuery.getScript("reportPlugins/aticCommon/setDataRangeDefaultValue.js");
	
	jQuery.getScript("reportPlugins/aticCommon/setIpDefaultValue.js");
});