PluginMgr.add("switchOption", {
	_loadData : function(url,param,id){
		var that = ConditionMgr.get(id);
			jQuery.ajax({
			url : url,
			data : param,
			type : "POST",
			dataType : "json",
			success : function(result, textStatus) {
				that.changeOptions(result.data);
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
			},
			complete : function(XMLHttpRequest, textStatus) {
			},
			async:false,cache:false
		});
	},
	initPlugin:function() {
		document.getElementById('lbl_dateRange').innerHTML = window.parent.FIVE_MINUTE;
		
		ConditionMgr.get("unit").registEvent(ConditionMgr.get("unit"),"onValueChange", function(event){
			var unit = ConditionMgr.get("unit");
			var switchOption = ConditionMgr.get("switchOption");
			if (unit.getSimpleValue() == "1") {
				switchOption.setValue({"value":"1"});
			}
			else if (unit.getSimpleValue() == "0") {
				switchOption.setValue({"value":"2"});
			}
		});
		
		ConditionMgr.addRelation("unit","switchOption");
		ConditionMgr.get("zone_combobox").registEvent(ConditionMgr.get("zone_combobox"),"afterListenerChanged", function(event){
			var oSelectList = ConditionMgr.get("zone_combobox");
			oSelectList.setValue({value:"0",text: window.parent.CommonTotalTip});
		});
		
		ConditionMgr.get("dateRange").checkDataInterface=function(){
			var dataRange = ConditionMgr.get("dateRange").getValueWithText();
			var oStartTime = dataRange[0].text;
			var oEndTime = dataRange[1].text;
			var oTimeSpan = getLongTimeByFmt(oEndTime) - getLongTimeByFmt(oStartTime);
			if (oTimeSpan >= 365 * 24 * 3600) 
			{
				var resultObj = {success : false,msg : window.parent.DataRangeWrongTip};
				return resultObj;
			} 
			else
			{
				var resultObj = {success : true,msg : ""};
				return resultObj;
			}
		}
	}
});
$(document).ready(
function()
{
	$("#btn_values").bind("click", function(e){
		var _device = ConditionMgr.get("netDevice_combobox");
		var _zone = ConditionMgr.get("zone_combobox");
    	var deviceValue = _device.getValueWithText();
     	var zoneValue = _zone.getValueWithText();
     	if (deviceValue){
            var hid = $("#h_currentDeviceValues", parent.document);
            if (!$("#h_currentDeviceValues", parent.document).val()){
                hid = $("<input id='h_currentDeviceValues' type='hidden'/>", parent.document);
                hid.appendTo($(parent.document.body));
            }
        	hid.val(JSON.stringify(deviceValue));
        }
        if (zoneValue){
            var hid = $("#h_currentZoneValues", parent.document);
            if (!$("#h_currentZoneValues", parent.document).val()){
                hid = $("<input id='h_currentZoneValues' type='hidden'/>", parent.document);
                hid.appendTo($(parent.document.body));
            }
        	hid.val(JSON.stringify(zoneValue));
        }
	});
}
);
jQuery(ConditionDataLoadChain).bind("afterAllConditionLoaded", function(ev){
	function dropZoneValue(zoneValue)
	{
		var lastIndex = zoneValue.length-1;
		if(zoneValue.indexOf('[') == 0 && zoneValue.indexOf(']')==lastIndex)
		{
			returnStr=zoneValue.substring(1, lastIndex);
		}
		else
		{
			returnStr=zoneValue;
		}
		return returnStr;
	}
	function setReportDeviceType()
	{
		var _device = ConditionMgr.get("netDevice_combobox");
		var deviceValue = $("#h_currentDeviceValues", parent.document).val();
		if (_device && deviceValue)
		{
			var currentDeviceId=JSON.parse(deviceValue).value;
			if(currentDeviceId.split('_')[2] && currentDeviceId.split('_')[2] ==2)
			{
			}
			else
			{
				_device.setValue(JSON.parse(deviceValue));
				_device.publishEvent("onValueChange");
				
				var _zone = ConditionMgr.get("zone_combobox");
				var zoneValue = $("#h_currentZoneValues", parent.document).val();
				if (_zone && zoneValue)
				{
					var returnStr = dropZoneValue(zoneValue);
				    var returnValue = JSON.parse(returnStr).value;
				    var returnText = JSON.parse(returnStr).text;
				    if(returnValue > 0)
				    {
						_zone.setValue({value:returnValue,text:returnText});
					}
				}
			}
		}
	}
	setReportDeviceType();
	
	jQuery.getScript("reportPlugins/aticCommon/aticTimeGraCommon.js");
	jQuery.getScript("reportPlugins/aticCommon/setDeviceAndZoneDefaultValue.js", function(){
		setReportDeviceType("unSig","ipLocationFlow");
	});
	jQuery.getScript("reportPlugins/aticCommon/setDataRangeDefaultValue.js");
});
