 var WaitBar = {
    IS_IE: true,
    target: null,
    c : null,
    minTime: 500,
    startTime : 0,
    bgOverlay : null,
    infoDiv : null,
    waitInfo : "",
    waitObj : null,
    
    waitTitle : "",
    executeAfterCloseSingle : true,
    afterClose : function() {},
    show : function(cfgObj) {
    	this.waitObj = LegoTag;
    	
    	this.waitObj.Msg.wait();
    	
        this.parseCfgObj(cfgObj)
        
        
        if(this.c && this.c.callback) {
            var waitBar = this;
            setTimeout(function() {
                if(waitBar.c.scope) {
                    waitBar.c.callback.call(waitBar.c.scope);
                } else {
                    waitBar.c.callback.call(window);
                }
            },this.c.delay)
        }
        this.startTime = new Date().getTime();
    },
    
    resize : function() {
        if(this.target) {
            var absPs = this.getAbsPosition(this.target);
            var _w = this.target.offsetWidth;
            var _h = this.target.offsetHeight;
            
            this.bgOverlay.style.top = absPs.y;
            this.bgOverlay.style.left = absPs.x;
            
            this.bgOverlay.style.width = _w;
            this.bgOverlay.style.height = _h;
        }
    },
    
    close : function(config) {
    	if(WaitBar.waitObj)
    	{
    	   if(WaitBar.waitObj.Msg.isVisible()) {
	            var curTime = new Date().getTime();
	            if (curTime - this.startTime > this.minTime) {
	            	WaitBar.waitObj.Msg.hide();	
	                if(config && config.callback) {
	                    var args = config.args?config.args:[];
	                    var scope = config.scope?config.scope:window;
	                    config.callback.apply(scope,args);
	                } else {
	                    this.afterClose();
	                    if(this.executeAfterCloseSingle) {
	                        this.afterClose = function(){};
	                    }
	                }
	            } else {
	                var wb = this;
	                setTimeout(function(){ wb.close(config)},this.minTime - (curTime - this.startTime))
	            }
	        }
    	}
    },
    isShow : function() {
        if(this.bgOverlay == null) {
            return false;
        }
        if(this.bgOverlay.style.display == 'none') {
            return false;
        }
        return true;
    },
    createInfoDiv : function() {
        var _html = '' ;
        var _info_div = document.createElement('div');
        _info_div.className='ext-el-mask-msg x-mask-loading';
        if(!this.c.infoDom) {
            _info_div.innerHTML += '<table border="0" cellpadding="0" cellspacing="0">' +
                '<tr>' +
                	'<td class="loading-left">'+'</td>'+
                    '<td class="loading-middle"><div>' + this.waitInfo +
                    '</div></td>' +
                    '<td class="loading-right">'+	
                    '</td>' +
                '</tr>' +
            '</table>'
        } else {
            if(typeof this.c.infoDom == 'string') {
                _info_div.innerHTML = this.c.infoDom;
            } else {
                _info_div.appendChild(this.c.infoDom);
            }
        }
        
        return _info_div;
    },
    parseCfgObj : function(cfgObj) {
        var co = cfgObj;
        if(!co) {
            co = {};
        }
        if(co.minTime) {
            if(co.minTime < 500) {
                co.minTime = 500;
            }
        } else {
            co.minTime = 500;
        }
        if(!co.delay || co.delay < 100) {
            co.delay = 100;
        } 
        
        if(co.target) {
            var absPs = this.getAbsPosition(co.target)
            co.size = {
                width : co.target.offsetWidth,
                height : co.target.offsetHeight
            }
            co.pO = absPs;
            this.target = co.target;
            
        } else {
            co.target = document.body;
            this.target = co.target;
            
            var _bodyHeight = document.body.clientHeight;
            var _bodyWidth = document.body.clientWidth;
            
            if(co.size) {
                if(!co.size.width || co.size.width < _bodyWidth) {
                    co.size.width = _bodyWidth;
                }
                if(!co.size.height || co.size.height < _bodyHeight) {
                    co.size.height = _bodyHeight;
                }
            }  else {
                co.size = {
                    width: _bodyWidth,
                    height: _bodyHeight
                }
            }
        
            if (!co.pO) {
				co.pO = {
					x : document.body.scrollLeft,
					y : document.body.scrollTop
				}
			}
        }

        this.minTime = co.minTime;
        this.c = co;
    },
    getAbsPosition : function(el) {
        var SL = 0, ST = 0;
        var is_div = /^div$/i.test(el.tagName);
        if (is_div && el.scrollLeft)
            SL = el.scrollLeft;
        if (is_div && el.scrollTop)
            ST = el.scrollTop;
        var r = {
            x : el.offsetLeft - SL,
            y : el.offsetTop - ST
        };
        if (el.offsetParent) {
            var tmp = this.getAbsolutePos(el.offsetParent);
            r.x += tmp.x;
            r.y += tmp.y;
        }
        return r;
    },
    addEvent: function (obj, eventType, fn) {
        if (this.IS_IE) { 
            obj.attachEvent("on" + eventType, fn);
        } else {
            obj.addEventListener(eventType, fn, false);
        }
    }
};

 function showWaitBar() {
    WaitBar.show()
 }
 
 function closeWaitBar() {
    WaitBar.close();
 }
 