function IReport_CBB_Grid (container, config) {
   this.DataUtil = {
       tempData : [],
       getData : function(){
           var that = this;
           var arr = [];
           $.each(that.tempData, function(i, d){
                if (d){
                    arr.push(d);
                }
            });
            return arr;
        },
        containsData : function(_obj){
            var that = this;
            var flag = false;
            $.each(that.tempData, function(i, d){
                if (d && _obj.toString() == d.toString()){
                    flag = true;
                    return false;
                }
            });
            return flag;
        },
        appendData : function(_obj){
            var that = this;
            if (_obj)that.tempData.push(_obj);
            return this;
        },
        removeData : function(_obj){
            if (_obj){
                var that = this;
                $.each(that.tempData, function(i, d){
                    if (d && _obj.toString() == d.toString()){
                        that.tempData.splice(i, 1);
                        return false;
                    }
                });
            }
            return this;
        },
        empty:function(){
            this.tempData.splice(0, this.tempData.length);
            return this;
        }
   };
    this.jContainer = typeof container == "string"?$("#" + container) : $(container);
    this._doc = this.jContainer.get(0).ownerDocument;
    
    if(!IReport_CBB_Grid.prototype._initialized) {
        var p =  IReport_CBB_Grid.prototype;
        p.dataType2Align = {
            number : "center",
            string : "center"
        }
        p.ID_SEED = new Date().getTime();
        
        p.initProperties = function(config) {
            
            this.c = $.extend({
                 height: 300, 
                 width: 'auto', 
                 striped: true, 
                 minwidth: 40, 
                 url: false,
                 method: 'POST',
                 dataType: 'json', 
                 errormsg: 'Connection Error',     
                 pager: false,
                 nowrap: true, 
                 title: false,
                 snWidth:20,
                 nomsg: 'No items',
                 colDefaultWidth: 70,
                 recordsSeletor: true,
                 headerTextAlign: "center",
                 autoLoad: true
              }, config);
              $.extend(this, this.c);
              
              if(!this.id) this.id = "IReport_CBB_Grid_" + this.ID_SEED;
        }
        
        p.initContainers =function() {
            var thisObj = this;
            
            this.jContainer.empty();
            this.jTContainer = $("<div/>", this._doc).addClass("cbb-grid-title cbb-grid-title-empty").appendTo(this.jContainer);        
            this.jHContainer = $("<div/>", this._doc).addClass("cbb-grid-header").appendTo(this.jContainer);            
            this.jBContainer = $("<div/>", this._doc).addClass("cbb-grid-body").appendTo(this.jContainer);         
    
            this.jContainer.addClass("cbb-grid").width((parseInt(this.width)+10) + "px").attr("id", this.id+"_cbb_grid");
            
            if ($.browser.msie)
                this.jContainer.addClass('ie');
                
            this.jBContainer.css({ height: (this.height=='auto') ? 'auto' : this.height+"px",
                width : (parseInt(jQuery(container).css("width"))) + "px"
            }).scroll(function (e) {
                thisObj.scroll();
            });
        }
        
       
        p.createThead = function() {
            this.jHTable = $("<table/>", this._doc).attr({cellPadding: 0, cellSpacing: 0, border: 0});
            var jThead = $("<thead/>", this._doc).appendTo(this.jHTable);
            
            
            if(this.sn == true || this.sn == "true") {
                this.columnModels.unshift({
                    width:28,
                    hCellClass: "cbb-grid-hcell-sn",
                    rCellClass: "cbb-grid-cell-sn",
                    text:"NO.",
                    render: function(el, cIndex, rIndex) {
                        $(el).empty().text(rIndex + 1);
                    }
                });
            }
            
            this.createHeadThs();
            this.jHContainer.append($("<div/>", this._doc).addClass("cbb-grid-h-box").append(this.jHTable));
        };
        
        p.createHeadThs = function() {
            var thisObj = this;
            var jThead = this.jHTable.find("thead").empty();
            if (this.columnModels) {                
                var jTr = $("<tr/>", this._doc).appendTo(jThead);
                $.each(this.columnModels, function(i, cm){
                    jTr.append(thisObj.createHeadTh(i,cm));
                })
            } 
        };
        
        p.createHeadTh = function(i,cm) {
            var jTh,jThDiv;
            jTh = $("<th/>", this._doc).addClass("cbb-grid-hcell").removeAttr('width');
            var w = cm.width?cm.width:70;
            w = parseInt(w);
            cm.width = w;
            cm.colIndex = i;           
            
            jThDiv = $("<div/>", this._doc).addClass("cbb-grid-hcell-text").width(w + "px").appendTo(jTh);
            
            jTh.data("model", cm);     
            if(cm.hCellClass) {
                jTh.addClass(cm.hCellClass);
            }
            jThDiv.html(cm.text);
            
            var align = this.headerTextAlign;
            align = align?align:cm.align;
            
            jTh.attr("align", align);       
            jThDiv.css({textAlign:'center'});
                
            if (cm.hide == true) jTh.hide();
            jTh.empty().append(jThDiv).removeAttr('width');
            
            jTh.hover(function(){
                $(this).addClass("cbb-grid-hcell-over");
            }, function(){
                $(this).removeClass("cbb-grid-hcell-over");
            });
            
            return jTh;
        }
        
        p.createGridTable = function() {
            this.jGridTable =  $("<table/>", this._doc).attr({cellPadding: 0, cellSpacing: 0, border: 0}).appendTo(this.jBContainer);
            if(this.height == "auto") {
                this.jGridTable.addClass('autoht');
            }
        }
        
        p.addOneRow = function(data) {
            var thisObj = this;
            
            if(this.preProcess) {
                this.preProcess(data);
            }
            data.toString = function(){
                return JSON.stringify(this);
            };
            var jTr = $("<tr/>", this._doc).appendTo(this.jGridTable);
            jTr.data("data", data);
            jTr.addClass("cbb-grid-row");
            
            var rIndex = parseInt(jTr.attr("rowIndex"));
            
            if (rIndex % 2 && this.striped) {
                jTr.addClass('cbb-grid-row-alt');      
            }
            
            jTr.attr("id", "grid-"+ this.id +"-r-" + rIndex);           
            
            var jTd,jTdDiv;
            this.jHTable.find("th").each(function (index,th){
              
                var cm = $(th).data("model");
                
                jTd = $("<td/>", thisObj._doc).addClass("cbb-grid-cell").appendTo(jTr);
                jTdDiv = $("<div/>", thisObj._doc).addClass("cbb-grid-cell-text").css({width: cm.width + "px", overflow:"hidden"});
                
                if(cm.align) {
                    jTd.attr("align", "center");
                    jTdDiv.css({textAlign:cm.align});
                } else {
                    var dt = cm.dataType?cm.dataType:"string";
                    cm.dataType = dt;
                    
                    var align = thisObj.dataType2Align[dt];
                    jTd.attr("align", "center");
                    jTdDiv.css({textAlign:'center'});
                }
                if(cm.hide == true) jTd.hide();

                jTdDiv.text(data[cm.name]);
                
                if(cm.rCellClass) {
                    jTd.addClass(cm.rCellClass);
                }
                
                if(this.nowrap == false) jTdDiv.css('white-space','normal');
                if (cm.render)  cm.render(jTdDiv.get(0),index,rIndex);
                
                jTd.empty().append(jTdDiv).removeAttr('width');
            }); 
            
            jTr.hover(
                function () { $(this).addClass('cbb-grid-row-hover'); },
                function () { $(this).removeClass('cbb-grid-row-hover'); }
            );
            if(thisObj.DataUtil.containsData(data)){
                var _gtb = thisObj.jGridTable;
                jTr.addClass("cbb-grid-row-selected");
                if (thisObj.selector == "radio"){
                    var _rd = jTr.find("img.cbb-grid-radio").removeClass("unchecked unchecked-hover").addClass("checked");
                    thisObj._ckRd = _rd.get(0);
                    jTr.addClass("cbb-grid-row-selected");
                }else{
                     jTr.find("img.cbb-grid-checkbox").removeClass("unchecked").addClass("checked");
                    var l1 = _gtb.find("img.checked[name=grid_cb_"+ thisObj.id +"]").length;
                    var l2 =  _gtb.find("img.cbb-grid-checkbox[name=grid_cb_"+ thisObj.id +"]").length;
                    if(l1 == l2) {
                        $("#allSelectCb_" + thisObj.id, thisObj._doc).removeClass("unchecked unchecked-hover").addClass("checked");
                    }
                }
            }
        }
    
        p.dataPreProcess = function(data) {
            return data;
        }
        
        p.beforAddData = function(data) {
            
        }
        
        p.afterAddData = function() {
            
        }
        
        p.addData = function(rows) {
            if(!rows) return false;
            
            this.beforAddData(rows);
            rows = this.dataPreProcess(rows);
            
            var thisObj = this;
            this.jGridTable.find("tr").unbind();
            this.jGridTable.empty();
            
            $.each(rows, function(i,r) {
                thisObj.addOneRow(r);
            });
            this.afterAddData();

            this.jHContainer.attr("scrollLeft", this.jBContainer.attr("scrollLeft"));
        }
        
        p.showLoadingMask = function() {
            if(!this.loadMask) {
                this.loadMask = new CBB_Mask({
                    target : this.jContainer,
                    msg: $RRs.grid_loading,
                    loadingMode: true
                })
            } 
            this.loadMask.show();
        }
        
        p.destory = function() {
            this.jContainer.remove();
            if(this.loadMask) {
                this.loadMask.destory();
            }
        }
        
        p.closeLoadingMask = function() {
            this.loadMask.hide();
        }
        
        p.load = function() {
            var thisObj = this;
            
            $(this).trigger("onBeforeLoadData",[thisObj]);
            
            this.showLoadingMask();
            
            if(!this.url) return ;
            $.ajax({
                url : this.url,
                type : "POST",
                data : this.getParams(),
                dataType : "json",
                success : function(result, textStatus) {
                    if(!result || !result.data) {
                        result = {
                            data:  {
                                total : 0,
                                rows: []
                            }
                        }
                    }
                    thisObj.addData(result.data.rows);
                    thisObj.loadComplete();
                    $.each(thisObj.plugins, function(i, p) {
                        if(p.active && p.onGridLoadComplete) {
                            p.onGridLoadComplete(result.data);
                        }
                    })
                    $(thisObj).trigger("onAfterLoadData", {result:true, grid: thisObj});
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    $(thisObj).trigger("onAfterLoadData", {result:false, grid: thisObj});
                },
                complete : function(XMLHttpRequest, textStatus) {
                    thisObj.closeLoadingMask();
                },
                async : true
            });
        },
        
        p.reset = function(b) {
            $(this).trigger("onReset", [this]);
            if(b == true) {
                this.isReload = true;
            }
        };
        
        p.getParams = function() {
            var params = this.getBasicParams();
            $.extend(params, this.getPluginParams());
            
            return params;
        },
        p.getBasicParams = function() {
            return {};
        },
        p.getPluginParams = function() {
            var p = {};
            $.each(this.plugins, function(i, plugin) {
                if(plugin.getLoadParams && plugin.active) {
                    $.extend(p,plugin.getLoadParams())
                }
            })
            return p;
        },
        p.loadComplete = function() {
            
        },
        p.initDoms = function() {
            this.createThead();
            this.createGridTable();
            this.createTitle();
        }
        
        p.createTitle = function() {
            if(this.title) {
                this.jTContainer.removeClass("cbb-grid-title-empty")
                $("<span/>", this._doc).addClass("cbb-grid-title-text").appendTo(this.jTContainer).text(this.title);
            }
        }
        
        p.scroll = function() {
            this.jHContainer.attr("scrollLeft", this.jBContainer.attr("scrollLeft"));
        };
        
        p.loadPlugins = function() {
            var thisObj = this;
            $.each(this.plugins, function(i, plugin) {
                plugin.load(thisObj);
            })
        }
        
        IReport_CBB_Grid.prototype._initialized = true;
    }
    
    this.initProperties(config);
    this.initContainers();
    this.initDoms();
    
    this.loadPlugins();
    
    if(this.autoLoad) {
        this.load();
    }
}

IReport_CBB_Grid.prototype.plugins = [];

IReport_CBB_Grid.prototype.plugins.push({

    grid: null,
    jCt: null,
    jInCt : null,
    _doc : null,
    
    active: false,
    
    recordsSeletor: true,  
    
    records: 10, 
    recordsOptions: [10,15,20,25,40],
    page: 1,
    pages: 1,
    
    loadParams : {},
    
    pagetext: 'Page',
    pagestat: 'Displaying {from} to {to} of {total} items',
    outof: 'of',
    findtext: 'Find',
    procmsg: 'Processing, please wait ...',
    
    load: function(grid) {
        if(!grid) return false;
        var thisObj = this;
        this.grid = grid;
        this._doc = this.grid._doc?this.grid._doc:document;
        
        if(this.grid.pager != true && this.grid.pager != "true")  return false;
        
        this.createPagebar();
        
        this.active = true;
        
        $(this.grid).bind("onReset", function() {
            thisObj.page = "1";
        });
    },
    
    getLoadParams : function() {
        if(this.grid.loadTrigger != "grid-pager") {
            this.page = 1;
        }
        
        return  {       
            records: this.records.toString(),
            page:this.page.toString()
        };
    },
    
    goPage : function(type) {
        var p = {       
            records: 0,
            page:1
        };
        
        switch (type) {
            case 'first' :
                p.page = 1;
                break;
            case 'prev' :
                if (this.page > 1)
                    p.page = this.page - 1;
                else return false;
                break;
            case 'next' :
                if (this.page < this.pages) {
                    p.page = this.page + 1;
                }
                else {
                    p.page = this.pages;    
                }
                break;
            case 'last' :
                p.page = this.pages;
                break;
            case 'input' :
                var jel = $('div.grid-pbar-page:first', this.jInCt).find("input");
                var nv = parseInt(jel.val());
                if (isNaN(nv))
                    nv = 1;
                if (nv < 1)
                    nv = 1;
                else if (nv > this.pages)
                    nv = this.pages;
                jel.val(nv);
                p.page = nv;
                break;
        }
        if (p.page == this.page)        
            return false;
        this.page = p.page;
        p.records = this.records.toString();
        p.page = this.page.toString();
        
        this.loadParams = p;
        
        this.reload();
    },

    reload : function() {
        this.grid.loadTrigger = "grid-pager";
        this.grid.load();       
        this.grid.loadTrigger = ""; 
    },
    
    createPagebar : function() {
        var thisObj = this;
        
        this.jCt = this.grid.jPContainer = $("<div/>", this._doc).attr("id", this.grid.id + "_cbb_pager").addClass("grid-pager").insertAfter(this.grid.jBContainer);
        
        var _html = '<table cellspacing="0" cellpadding="0">' +
            '<tr>' +
                '<td class="grid-pbar-btn"><div class="grid-pbar-first"></div></td>' +
                '<td class="grid-pbar-btn"><div class="grid-pbar-pre"></div></td>' +
                '<td><div class="grid-pbar-separator"></div></td>' +
                '<td><div class="grid-pbar-text">'+$RRs.comm_the+'</div></td>' +
                '<td><div class="grid-pbar-page"><input type="text" value="1" size="3"/></div></td>' +
                '<td><div class="grid-pbar-text"></div></td>' +
                '<td><div class="grid-pbar-separator"></div></td>' +
                '<td><div class="grid-pbar-text">'+$RRs.comm_erevy_page_record+'</div></td>' +
                '<td><div class="grid-pbar-page"><input id="' +this.grid.id+"_count"+ '" size="3" value="10"/><span style="font-size:12px;vertical-align:middle;">'+$RRs.comm_item+'</span></div></td>' +
                '<td><div class="grid-pbar-separator"></div></td>' +
                '<td class="grid-pbar-btn"><div class="grid-pbar-next"></div></td>' +
                '<td class="grid-pbar-btn"><div class="grid-pbar-last"></div></td>' +
                '<td><div class="grid-pbar-separator"></div></td>' +
                '<td class="grid-pbar-btn"><div class="grid-pbar-fresh"></div></td>' +
                '<td><div class="grid-pbar-separator"></div></td>' +
                '<td align="right"><div class="grid-pbar-text" style="font-size:12px"></div></td>' +
            '</tr>' +
        '</table>';
        
        this.jInCt = $("<div/>", this._doc).addClass("grid-pager-bar").html(_html);
                        
        $('div.grid-pbar-fresh',this.jInCt).click(function(){thisObj.reload()});
        $('div.grid-pbar-first',this.jInCt).click(function(){thisObj.goPage('first')});
        $('div.grid-pbar-pre',this.jInCt).click(function(){thisObj.goPage('prev')});
        $('div.grid-pbar-next',this.jInCt).click(function(){thisObj.goPage('next')});
        $('div.grid-pbar-last',this.jInCt).click(function(){thisObj.goPage('last')});
        
        $('div.grid-pbar-page:first', this.jInCt).find("input").bind("keydown" ,function(e){
            if(e.keyCode==13) thisObj.goPage('input');
        });
        
        $('.grid-pbar-btn',this.jInCt).hover(function(){
            $(this).addClass('grid-pbar-btn-over');
            return false;
        }, function(){
            $(this).removeClass('grid-pbar-btn-over');
            return false;
        });
        
        
        this.jInCt.find("#" + this.grid.id+"_count").bind({
            "blur" : function(event) {
                thisObj.records = this.value;
                thisObj.page = 1;
                thisObj.grid.load();
            },
            "keydown keyup" : function(event){
                if (event.keyCode == 13){
                    var num = parseInt(this.value);
                    if (isNaN(num)){
                        this.value = 10;
                    }else if(num < 1){
                        this.value = 10;
                    }else if (num > 100){
                        this.value = 100;
                    }
                    thisObj.records = this.value;
                    thisObj.page = 1;
                    thisObj.grid.load();
                }
            }
        });
        
        this.jCt.append(this.jInCt);
    },
    
    onGridLoadComplete: function(data) {
        if(!this.active) return false;
        
        this.pages = Math.ceil(data.total/this.records);
        if(this.pages == 0) this.pages = 1;
        this.jInCt.find("td:eq(5) div").text(ConditionUtils.buildResourse($RRs.comm_pages, [this.pages]));
        this.jInCt.find(".grid-pbar-page:first").find("input").val(this.page);
        
        var end = parseInt((this.page - 1) * this.records) + parseInt( this.records);
        if (end > data.total){
            end = data.total;
        }
        var ar = [(this.page - 1)*this.records + 1, end, data.total];
        var text = $RRs.comm_record_detail;
        this.jInCt.find("td:last div").text(ConditionUtils.buildResourse(text, ar));
        $("td.grid-pbar-btn", this.jInCt).removeClass("grid-pbar-btn-disabled");
        
        if(this.page == this.pages) {   
            $('div.grid-pbar-last',this.jInCt).parent("td").addClass("grid-pbar-btn-disabled");
            $('div.grid-pbar-next',this.jInCt).parent("td").addClass("grid-pbar-btn-disabled");
        }
        if(this.page == 1){
            $('div.grid-pbar-first',this.jInCt).parent("td").addClass("grid-pbar-btn-disabled");
            $('div.grid-pbar-pre',this.jInCt).parent("td").addClass("grid-pbar-btn-disabled");
        }
    }
});

IReport_CBB_Grid.prototype.plugins.push({
    
    jCt: null,
    active : false,                
    grid: null,
    jFieldsCb: null,
    jSText: null,
    jSBtn: null,
    _doc: null,
    expandReturnVal:null,       
    expandPlugin:null,         
    expandPlugin_tree:null,    
    
    searchName: "",
    searchValue: "",
    searchExpand:"",          
    
    emptyText: $RRs.grid_empty_text,
    emptyOption: {
        value: "",
        text: $RRs.grid_empty_option
    },
    
    load: function(grid) {
        
        if(!grid) return false;
        
        if(!grid.searcher) {
            return false;
        }
        this.active = true;
        this.grid = grid;
        this._doc = this.grid._doc?this.grid._doc:document;
        
        this.createSeacherbar();
    },

    createSeacherbar : function() {
        var thisObj = this;
        this.jCt = $("<div/>", this._doc).attr("id",this.grid.id + "_seacherBar").addClass("cbb-grid-toolbar").insertAfter(this.grid.jTContainer);
        $(this.tDiv).append("<div style='clear:both'></div>");
        var expand = thisObj.grid.expand;   
        if(expand)
        {
            thisObj.searchExpand = "";
            thisObj.expandPlugin_tree = ConditionMgr.get(expand);  
            thisObj.expandPlugin_tree.reset();
            jQuery("<label style='width: 40px;'>"+thisObj.expandPlugin_tree.label+"： </label>").appendTo(this.jCt).addClass("x-form-item-label");
            thisObj.expandPlugin = jQuery("<input type='text' readonly class='x-form-text x-form-field' style='vertical-align:top'/>").appendTo(this.jCt);
            thisObj.expandPlugin.blur(function() 
            {
                $(this).removeClass("x-form-focus");
            }).focus(function() 
            {
                $(this).addClass("x-form-focus");
            })
            var expandPluginImg =  jQuery("<div />").appendTo(this.jCt).addClass("grid-pbar-expand-field-wrap");
            expandPluginImg.bind('click',function()
            {
                thisObj.expandPlugin_tree.showWinTree();
            });
            thisObj.expandPlugin_tree.clickOkBotton = function() 
            {
                thisObj.expandReturnVal = thisObj.expandPlugin_tree.getValueWithText();
                var returnVal = new Array();
                var returnText = new Array();
                for(var i=0;i<thisObj.expandReturnVal.length;i++)
                {
                    returnText.push(thisObj.expandReturnVal[i].text);
                }
                thisObj.expandPlugin.val(returnText.join(";"));
            };
        }
        this.jCt.append($("<label/>", this._doc).text("查询条件 ：　"));
        this.jFieldsCb = $("<select/>", this._doc).addClass("simpleSelect").css({
            "width": "80px",
            "height" : "22px"
        }).appendTo(this.jCt).change(function(){
            if(this.value == thisObj.emptyOption.value) {
                thisObj.jSText.attr("disabled", true);
                thisObj.jSText.val(thisObj.emptyText);
            } else {
                thisObj.jSText.attr("disabled", false);
                thisObj.jSText.val(thisObj.emptyText);
            }
        });
        var op = $("<option/>",this._doc).appendTo(thisObj.jFieldsCb);
        op.attr("value", this.emptyOption.value);
        op.attr("text", this.emptyOption.text);
        
        var searchFields;
        if(this.grid.searcher && !ConditionUtils.isTrue(this.grid.searcher)) {
            searchFields = this.grid.searcher.split(",");  
            var tp = [];
            
            $.each(thisObj.grid.columnModels, function(i,cm) {  
                if(ConditionUtils.isTrue(cm.searchable)) {
                    tp.push({v: cm.name, t:cm.text});
                    return true;
                }
                $.each(searchFields, function(i, f){
                    if(cm.name && cm.name == f) {
                        cm.searchable = true;
                        tp.push({v: f, t:cm.text});
                        return false;
                    }
                })
            })
            $.each(tp, function(i,f) {  
                op = $("<option/>", thisObj._doc).appendTo(thisObj.jFieldsCb);
                op.attr("value", f.v);
                op.attr("text", f.t);
            })
        } 
        else { 
            $.each(this.grid.columnModels, function(i,cm) {
                if(cm.name) {
                    op = $("<option/>", thisObj._doc).appendTo(thisObj.jFieldsCb);
                    op.attr("value", cm.name);
                    op.attr("text", cm.text);
                }
            })
        }
        thisObj.jFieldsCb.parent().css({
            "padding" : "2px"
        });
        if(this.grid.searcher && (this.grid.searcher == false || this.grid.searcher == "false"))
        {
            $(this.jCt).hide();
        }
        this.jSText = $("<input type='text' class='x-form-text x-form-field' style='vertical-align:top'/>", this._doc).blur(function() {
            $(this).removeClass("x-form-focus");
            if(this.value == "") {
                this.value = thisObj.emptyText ;
            }
        }).focus(function() {
            $(this).addClass("x-form-focus");
            if(this.value == thisObj.emptyText) {
                this.value = "";
            }
        }).keydown(function(e){
            if(e.keyCode == 13) {
                thisObj.doSearch();
            }
        });
        this.jCt.append(this.jSText);
        this.jSText.val(this.emptyText);
        this.jSText.attr("disabled", true);
        var span = $("<span style='cursor:pointer;vertical-align:bottom'/>", this._doc).bind("click", function(event){
            thisObj.doSearch();
        });
         this.jsBtn = $("<img src='" +ConditionUtils.getPath()+"/iReport/images/window/search.gif'/>", this._doc).attr({id:"img_" + this.grid.ID_SEED});
        span.append(this.jsBtn).append("查询").appendTo(this.jCt);
    },
    
    doSearch : function() {
        var flag = 0;
        if(this.expandPlugin != null && this.expandPlugin.val().length!=0)
        {
            flag = flag+1;
            var returnVal = new Array();
            for(var i=0;i<this.expandReturnVal.length;i++)
            {
                returnVal.push(this.expandReturnVal[i].value);
            }
            this.searchExpand = returnVal.join(";");
        }
        if(this.jSText.val() == this.emptyText) 
        {
            if(this.jFieldsCb.val() == this.emptyOption.value) 
            {
                flag = flag+1;
                this.searchName = "";
                this.searchValue = "";
            }
        }
        else 
        {
            flag = flag+1;
            this.searchName = this.jFieldsCb.val();
            this.searchValue = this.jSText.val();
        }
        if(flag == 0)
        {
            return false;
        }
        this.grid.load();
    },
    
    getLoadParams : function() {
        if(this.expandPlugin == null  || this.expandPlugin.val().length == 0)
        {
            if(this.jFieldsCb.val() == this.emptyOption.value) 
            {
            return {};
            }
        }
        return {
            searchName:this.searchName, 
            searchValue: this.searchValue, 
            searchExpand : this.searchExpand 
        };
    },
    
    onGridReset: function() {
        this.jFieldsCb.val(this.emptyOption.value);
        this.jSText.val(this.emptyText);
        if(this.grid.expand)
        {
            this.expandPlugin.val("");
            this.searchExpand = "";
        }       
        this.searchName = "";
        this.searchValue =  "";
    },
    
    onGridLoadComplete: function() {
    }
})

IReport_CBB_Grid.prototype.plugins.push({

    grid: null,
    _doc: null,
    
    jAllCb: null,
    
    load: function(grid) {
        var thisObj = this;
        if(!grid) return false;
        if(!grid.selector) {
            return false;
        }
        this.grid = grid;
        this._doc = this.grid._doc?this.grid._doc:document;
        
        if(this.grid.selector == "checkbox" || this.grid.selector == "true") {
            this.selectModel = "checkbox";
            this.initCheckBoxSelector();
            this.initDoms4CheckBoxModel();
            this.initRowClickForCheckbox();
        }
        else if(this.grid.selector == "radio") {
            this.selectModel = "radio";
            this.initRadioSelector();
            this.initDoms4RadioModel();
            this.initRowClickForRadio();
        }
        
        this.active = true;
        return true;
    },
    
    initRowClickForRadio: function() {
        var thisObj = this;
        this.grid.jGridTable.bind("click", function(e){
            var jTr = $(e.target).parents("tr.cbb-grid-row:first")
            if(jTr) {
                if(!jTr.hasClass("cbb-grid-row-selected")) {
                    $(thisObj._ckRd).removeClass("cbb-grid-radio-checked cbb-grid-radio-checked-hover").addClass("cbb-grid-radio-unchecked");
                    var _tr = thisObj.grid.jGridTable.find("tr.cbb-grid-row-selected").not(jTr);
                    _tr.find("img.cbb-grid-radio").removeClass("cbb-grid-radio-checked");
                    _tr.removeClass("cbb-grid-row-selected");
                    var _rd = jTr.find("img.cbb-grid-radio").removeClass("cbb-grid-radio-unchecked cbb-grid-radio-unchecked-hover").addClass("cbb-grid-radio-checked");
                    thisObj._ckRd = _rd.get(0);
                    jTr.addClass("cbb-grid-row-selected");
                    thisObj.grid.DataUtil.empty().appendData(jTr.data("data"));
                }
            }
            return false;
        })
    },
    
    initRadioSelector : function() {
        var thisObj = this;
        this.grid.getSelectedRecords = function() {
            return this.DataUtil.getData();
        }
        this.grid.columnModels.unshift({
            text:"&nbsp",
            width: 25,
            hCellClass: "cbb-grid-hcell",
            rCellClass: "cbb-grid-cell cbb-grid-cell-radio",
            render: function(el,cIndex,rIndex) {
                var jRd = $("<img src='" +ConditionUtils.getPath()+"/iReport/resourecs/ext/images/default/s.gif' class='cbb-grid-radio cbb-grid-radio-unchecked' name='grid_rd_" + thisObj.grid.id + "' id='cb_" + cIndex + "_" + rIndex + "'/>", thisObj._doc);
                $(el).append(jRd);
            }
        });
        
        var jTh = this.grid.createHeadTh(0, this.grid.columnModels[0]);
        this.grid.jHTable.find("tr").prepend(jTh);
        
    },
    
    initDoms4RadioModel : function() {
        var thisObj = this;
        
    },
    
    initRowClickForCheckbox: function() {
        var thisObj = this;
        
        this.grid.jGridTable.bind("click", function(e){
            var _gtb = thisObj.grid.jGridTable;
            var jTr = $(e.target).parents("tr.cbb-grid-row:first")
            if(jTr) {
                if(jTr.hasClass("cbb-grid-row-selected")) {
                    jTr.removeClass("cbb-grid-row-selected")
                    jTr.find("img.cbb-grid-checkbox").removeClass("cbb-grid-checkbox-checked").addClass("cbb-grid-checkbox-unchecked");
                    $("#allSelectCb_" + thisObj.grid.id, thisObj._doc).removeClass("cbb-grid-checkbox-checked cbb-grid-checkbox-checked-hover").addClass("cbb-grid-checkbox-unchecked");
                    
                    thisObj.grid.DataUtil.removeData(jTr.data("data"));
                }
                else {
                    jTr.addClass("cbb-grid-row-selected")
                    jTr.find("img.cbb-grid-checkbox").removeClass("cbb-grid-checkbox-unchecked").addClass("cbb-grid-checkbox-checked");
                    thisObj.grid.DataUtil.appendData(jTr.data("data"));
                    var l1 = _gtb.find("img.checked[name=grid_cb_"+ thisObj.grid.id +"]").length;
                    var l2 =  _gtb.find("img.cbb-grid-checkbox[name=grid_cb_"+ thisObj.grid.id +"]").length;
                    if(l1 == l2) {
                        $("#allSelectCb_" + thisObj.grid.id, thisObj._doc).removeClass("cbb-grid-checkbox-unchecked cbb-grid-checkbox-unchecked-hover").addClass("cbb-grid-checkbox-checked");
                    }
                }
            }
            return false;
        })
    },
    
    snatchSelectedRecords: function() {
        var rs = [];
        this.grid.jGridTable.find("tr.cbb-grid-row-selected").each(function(i,tr) {
            rs.push($(tr).data("data"));
        })
        return rs;
    },
    
    initCheckBoxSelector : function() {
        var thisObj = this;
        
        var tempRecords = [];
        
        this.grid.getSelectedRecords = function() {
            return this.DataUtil.getData();
        }
        
        $(this.grid).bind("onBeforeLoadData", function(e,grid) {
            tempRecords = tempRecords.concat(thisObj.snatchSelectedRecords());
        })
        
        this.grid.columnModels.unshift({
            text:"<img src='" +ConditionUtils.getPath()+"/iReport/resourecs/ext/images/default/s.gif' id='allSelectCb_"+ thisObj.grid.id +"' class='cbb-grid-checkbox cbb-grid-checkbox-unchecked'/>",
            width: 25,
            hCellClass: "cbb-grid-hcell",
            rCellClass: "cbb-grid-cell cbb-grid-cell-checkbox",
            render: function(el,cIndex,rIndex) {
                var jCb = $("<img src='" +ConditionUtils.getPath()+"/iReport/resourecs/ext/images/default/s.gif' class='cbb-grid-checkbox cbb-grid-checkbox-unchecked' name='grid_cb_" + thisObj.grid.id + "' id='cb_" + cIndex + "_" + rIndex + "'/>", thisObj._doc);
                $(el).append(jCb);
            }
        });
        
        var jTh = this.grid.createHeadTh(0, this.grid.columnModels[0]);
        this.grid.jHTable.find("tr").prepend(jTh);
        
    },
    
    initDoms4CheckBoxModel : function() {
        var thisObj = this;
        this.jAllCb = $("#allSelectCb_" + this.grid.id , this._doc);
        
        this.grid.jContainer.find("img.cbb-grid-checkbox").live("click", function() {
                var _ptb = thisObj.grid.jGridTable;
                if(this.id == "allSelectCb_" + thisObj.grid.id) {
                    if($(this).hasClass("cbb-grid-checkbox-unchecked")) {     
                        var jCb = _ptb.find("img.cbb-grid-checkbox-unchecked[name=grid_cb_"+ thisObj.grid.id +"]");
                        jCb.removeClass("cbb-grid-checkbox-unchecked cbb-grid-checkbox-unchecked-hover");
                        jCb.addClass("cbb-grid-checkbox-checked");
                        jCb.parents("tr.cbb-grid-row").addClass("cbb-grid-row-selected");
                        $.each(jCb.parents("tr.cbb-grid-row"), function(i, _r){
                            thisObj.grid.DataUtil.appendData($(_r).data("data"));
                        });
                        $(this).removeClass("cbb-grid-checkbox-unchecked cbb-grid-checkbox-unchecked-hover").addClass("cbb-grid-checkbox-checked");
                    } else {
                        var jCb = _ptb.find("img.cbb-grid-checkbox-checked[name=grid_cb_"+ thisObj.grid.id +"]");
                        jCb.removeClass("cbb-grid-checkbox-checked cbb-grid-checkbox-checked-hover");
                        jCb.addClass("cbb-grid-checkbox-unchecked");
                        jCb.parents("tr.cbb-grid-row").removeClass("cbb-grid-row-selected");
                        $.each(jCb.parents("tr.cbb-grid-row"), function(i, _r){
                                thisObj.grid.DataUtil.removeData($(_r).data("data"));
                        });
                        $(this).removeClass("cbb-grid-checkbox-checked cbb-grid-checkbox-checked-hover").addClass("cbb-grid-checkbox-unchecked");
                    }
                }
                else {
                    if($(this).hasClass("cbb-grid-checkbox-unchecked")) {     
                        $(this).parents("tr.cbb-grid-row").addClass("cbb-grid-row-selected");
                        $(this).removeClass("cbb-grid-checkbox-unchecked cbb-grid-checkbox-unchecked-hover").addClass("cbb-grid-checkbox-checked");
                        
                        var l1 = _ptb.find("img.cbb-grid-checkbox-checked[name=grid_cb_"+ thisObj.grid.id +"]").length;
                        var l2 =  _ptb.find("img.cbb-grid-checkbox[name=grid_cb_"+ thisObj.grid.id +"]").length;
                        if(l1 == l2) {
                            $("#allSelectCb_" + thisObj.grid.id, thisObj._doc).removeClass("unchecked unchecked-hover").addClass("checked");
                        }
                        
                    } else {
                        $(this).parents("tr.cbb-grid-row").removeClass("cbb-grid-row-selected");
                        $(this).removeClass("cbb-grid-checkbox-checked cbb-grid-checkbox-checked-hover").addClass("cbb-grid-checkbox-unchecked cbb-grid-checkbox-unchecked-hover");
                        $("#allSelectCb_" + thisObj.grid.id, thisObj._doc).removeClass("cbb-grid-checkbox-checked cbb-grid-checkbox-checked-hover").addClass("cbb-grid-checkbox-unchecked");
                    }
                }
                return false;
            })
    },
    
    onGridLoadComplete: function() {
        if(!this.active) return false;
        if(this.selectModel == "checkbox") {
            $("#allSelectCb_" + this.grid.id, this._doc).removeClass("cbb-grid-checkbox-checked cbb-grid-checkbox-checked-hover").addClass("cbb-grid-checkbox-unchecked");
        } else if(this.selectModel == "radio") {
        }
    }
})

IReport_CBB_Grid.prototype.plugins.push({
    asceClass : "sasc",
    descClass:"sdesc",
    grid: null,
    
    sortName: "",
    sortOrder: "",
    
    active: false,
    
    sortTypes : {
        number : {
            getValue: function(td) {
                var v = $(td).find("div").text();
                if(!v || isNaN(v)) return 0;
                return parseInt(v);
            },
            fn: function(d1, d2) {
                if (Number(d1.value) < Number(d2.value)) { return -1; }
                if (Number(d1.value) > Number(d2.value)) { return 1; }
                return 0;
            }
        },
        string: {
            getValue: function(td) {
                var v = $(td).find("div").text();
                return v;
            },
            fn: function(s1,s2) {
                if (s1.value < s2.value) { return -1; }
                if (s1.value > s2.value) { return 1; }
                return 0;
            }
        }
    },
    
    load: function(grid) {
        if(!grid) return false;
        if(!grid.sorter || $C.isFalse(grid.sorter))  return false;
        this.grid = grid;
        this.grid.sortIndex = -1;
        
        var sortAll = $C.isTrue(grid.sorter);
        var sortFields = this.grid.sorter.split(",");
        
        var jTh = this.grid.jHTable.find("th:gt(0)");
        var thisObj = this;
        jTh.each(function(i, th) {
            var cm = $(th).data("model");
            if(sortAll || $.inArray(cm.name,sortFields) != -1 || $C.isTrue(cm.sortable)) {
                cm.sortable = true;
                $(th).bind("click", {
                    plugin: thisObj,
                    th: th
                }, thisObj.thClick)
            }
        })
        
        $(this.grid).bind("onReset", function(e, grid){
            if(grid.sortIndex != -1) {
                grid.jHTable.find("th").eq(grid.sortIndex).find("div").removeClass(thisObj.asceClass + " " + thisObj.descClass);
            }
            this.sortName = "";
            this.sortOrder = "";
        });
        
        this.active = true;
    },
    
    thClick : function(e) {
        var plugin = e.data.plugin;
        plugin.sort(e.data.th);
    },

    getClickIndex : function(th) {
        var index = -1;
        this.grid.jHTable.find("th").each(function(i, _th) {
            if(th == _th) {
                index = i;
                return false;
            }
        })
        return index;
    },
    sort: function(th) {
        var thisObj = this;
        
        var cm = $(th).data("model");
        var dataType = cm.dataType;
        
        var sortType = this.sortTypes[dataType];
        if(!sortType) {
            sortType = this.sortTypes["string"];
        }
        
        var cmIndex = this.getClickIndex(th);
        
        var cache = [];
        this.grid.jGridTable.find("tr").each(function(){
            cache.push({
                value: sortType.getValue(this.cells[cmIndex]),
                tr: this
            });         
        });
        
        if(cmIndex == this.grid.sortIndex) { 
            var textDiv = $(th).find("div");
            cache.reverse();
            if(textDiv.hasClass(this.asceClass)) {
                textDiv.removeClass(this.asceClass).addClass(this.descClass);
                this.sortOrder = "desc"
            } else {
                textDiv.removeClass(this.descClass).addClass(this.asceClass);
                this.sortOrder = "asc"
            }
        } else {    
            cache.sort(sortType.fn);
            
            this.sortOrder = "asc"
            this.srotName = cm.name;
            
            if(this.grid.sortIndex != -1) {
                this.grid.jHTable.find("th").eq(this.grid.sortIndex).find("div").removeClass(this.asceClass + " " + this.descClass);
            }
            $(th).find("div").addClass(this.asceClass);
            this.grid.sortIndex = cmIndex;
        }

        this.grid.jGridTable.remove("tr");  
        var sn = this.grid.sn;
        $.each(cache, function(i, d) {     
            if(sn === true || sn === "true") {
                $(d.tr).find("td.cbb-grid-cell-sn div").text(i+1);
            }
            thisObj.grid.jGridTable.append(d.tr);
            d.value = null
            d.tr = null
            d = null
        })
    },
    
    getLoadParams : function() {
        return {
            sortName: this.sortName,
            sortOrder: this.sortOrder
        };
    },
    onGridLoadComplete: function() {
        
    }
});