IReport_CBB_Grid.prototype.plugins.push({

	grid: null,
	jCt: null,
	jInCt : null,
	_doc : null,
	
	active: false,
	
	recordsSeletor: true,  
	
	records: 10, 
	recordsOptions: [10,15,20,25,40],
	page: 1,
	pages: 1,
	
	loadParams : {},
	
	pagetext: 'Page',
	pagestat: 'Displaying {from} to {to} of {total} items',
 	outof: 'of',
 	findtext: 'Find',
 	procmsg: 'Processing, please wait ...',
 	
	load: function(grid) {
		if(!grid) return false;
		var thisObj = this;
		this.grid = grid;
		this._doc = this.grid._doc?this.grid._doc:document;
		
		if(this.grid.pager != true && this.grid.pager != "true")  return false;
		
		this.createPagebar();
		
		this.active = true;
		
		$(this.grid).bind("onReset", function() {
			thisObj.page = "1";
		});
	},
	
	getLoadParams : function() {
		if(this.grid.loadTrigger != "grid-pager") {
			this.page = 1;
		}
		
		return  {		
			records: this.records.toString(),
			page:this.page.toString()
		};
	},
	
	goPage : function(type) {
		var p = {		
			records: 0,
			page:1
		};
		
		switch (type) {
			case 'first' :
				p.page = 1;
				break;
			case 'prev' :
				if (this.page > 1)
					p.page = this.page - 1;
				else return false;
				break;
			case 'next' :
				if (this.page < this.pages) {
					p.page = this.page + 1;
				}
				else {
					p.page = this.pages;	
				}
				break;
			case 'last' :
				p.page = this.pages;
				break;
			case 'input' :
				var jel = $('div.grid-pbar-page input', this.jInCt);
				var nv = parseInt(jel.val());
				if (isNaN(nv))
					nv = 1;
				if (nv < 1)
					nv = 1;
				else if (nv > this.pages)
					nv = this.pages;
				jel.val(nv);
				p.page = nv;
				break;
		}
		if (p.page == this.page)		
			return false;
		this.page = p.page;
		p.records = this.records.toString();
		p.page = this.page.toString();
		
		this.loadParams = p;
		
		this.reload();
	},

	reload : function() {
		this.grid.loadTrigger = "grid-pager";
		this.grid.load();		
		this.grid.loadTrigger = ""; 
	},
	
	createPagebar : function() {
		var thisObj = this;
		
		this.jCt = this.grid.jPContainer = $("<div/>", this._doc).attr("id", this.grid.id + "_cbb_pager").addClass("grid-pager").insertAfter(this.grid.jBContainer);
		
		var _html = '<table cellspacing="0" cellpadding="0">' +
			'<tr>' +
				'<td><div class="grid-pbar-text">'+$RRs.comm_erevy_page_record+'</div></td>' +
				'<td><div class="grid-pbar-cb"></div></td>' +
				'<td><div class="grid-pbar-separator"></div></td>' +
				'<td class="grid-pbar-btn"><div class="grid-pbar-first"></div></td>' +
				'<td class="grid-pbar-btn"><div class="grid-pbar-pre"></div></td>' +
				'<td><div class="grid-pbar-separator"></div></td>' +
				'<td><div class="grid-pbar-text">'+$RRs.comm_the+'</div></td>' +
				'<td><div class="grid-pbar-page"><input type="text" value="1" size="3"/></div></td>' +
				'<td><div class="grid-pbar-text">/10'+$RRs.comm_page+'</div></td>' +
				'<td><div class="grid-pbar-separator"></div></td>' +
				'<td class="grid-pbar-btn"><div class="grid-pbar-next"></div></td>' +
				'<td class="grid-pbar-btn"><div class="grid-pbar-last"></div></td>' +
				'<td><div class="grid-pbar-separator"></div></td>' +
				'<td class="grid-pbar-btn"><div class="grid-pbar-fresh"></div></td>' +
			'</tr>' +
		'</table>';
		
		this.jInCt = $("<div/>", this._doc).addClass("grid-pager-bar").html(_html);
						
		$('div.grid-pbar-fresh',this.jInCt).click(function(){thisObj.reload()});
		$('div.grid-pbar-first',this.jInCt).click(function(){thisObj.goPage('first')});
		$('div.grid-pbar-pre',this.jInCt).click(function(){thisObj.goPage('prev')});
		$('div.grid-pbar-next',this.jInCt).click(function(){thisObj.goPage('next')});
		$('div.grid-pbar-last',this.jInCt).click(function(){thisObj.goPage('last')});
		
		$('div.grid-pbar-page input',this.jInCt).bind("keydown" ,function(e){
			if(e.keyCode==13) thisObj.goPage('input');
		});
		
		$('.grid-pbar-btn',this.jInCt).hover(function(){
			$(this).addClass('grid-pbar-btn-over');
			return false;
		}, function(){
			$(this).removeClass('grid-pbar-btn-over');
			return false;
		});
			
		if (this.grid.recordsSeletor) {
			var opt = "";
			var jCb = $("<select/>", this._doc)
			$.each(this.recordsOptions, function(i, v) {
				var opt = $("<option/>", thisObj._doc).appendTo(jCb);
				opt.attr("value", v);
				opt.attr("text",v);
			})
			this.jInCt.find("div.grid-pbar-cb").append(jCb);
			jCb.change(function() {
				thisObj.records = this.value;
				thisObj.page = 1;
				thisObj.grid.load();
			});
		}
		
		this.jCt.append(this.jInCt);
	},
	
	onGridLoadComplete: function(data) {
		if(!this.active) return false;
		
		this.pages = Math.ceil(data.total/this.records);
		if(this.pages == 0) this.pages = 1;
		this.jInCt.find("td:eq(8)").text("/" + this.pages + $RRs.comm_page);
		this.jInCt.find(".grid-pbar-page  input").val(this.page);
		
		$("td.grid-pbar-btn", this.jInCt).removeClass("grid-pbar-btn-disabled");
		
		if(this.page == this.pages) {	
			$('div.grid-pbar-last',this.jInCt).parent("td").addClass("grid-pbar-btn-disabled");
			$('div.grid-pbar-next',this.jInCt).parent("td").addClass("grid-pbar-btn-disabled");
		}
		if(this.page == 1){
			$('div.grid-pbar-first',this.jInCt).parent("td").addClass("grid-pbar-btn-disabled");
			$('div.grid-pbar-pre',this.jInCt).parent("td").addClass("grid-pbar-btn-disabled");
		}
	}
})
