IReport_CBB_Grid.prototype.plugins.push({
	
	jCt: null,
	active : false,					
	grid: null,
	jFieldsCb: null,
	jSText: null,
	jSBtn: null,
	_doc: null,
	
	searchName: "",
	searchValue: "",
	
	emptyText: "--请输入查询条件--",
	emptyOption: {
		value: "",
		text: "所有"
	},
	
	load: function(grid) {
		
		if(!grid) return false;
		
		if(!grid.searcher) {
			return false;
		}
		this.active = true;
		this.grid = grid;
		this._doc = this.grid._doc?this.grid._doc:document;
		
		this.createSeacherbar();
	},

	createSeacherbar : function() {
		var thisObj = this;
		this.jCt = $("<div/>", this._doc).attr("id",this.grid.id + "_seacherBar").addClass("cbb-grid-toolbar").insertAfter(this.grid.jTContainer);
		$(this.tDiv).append("<div style='clear:both'></div>");

		this.jFieldsCb = $("<select/>", this._doc).appendTo(this.jCt).change(function(){
			if(this.value == thisObj.emptyOption.value)	{
				thisObj.jSText.attr("disabled", true);
				thisObj.jSText.val(thisObj.emptyText);
			} else {
				thisObj.jSText.attr("disabled", false);
				thisObj.jSText.val(thisObj.emptyText);
			}
		});
		var op = $("<option/>",this._doc).appendTo(thisObj.jFieldsCb);
		op.attr("value", this.emptyOption.value);
		op.attr("text", this.emptyOption.text);
		
		var searchFields;
		if(this.grid.searcher && !ConditionUtils.isTrue(this.grid.searcher)) {
			searchFields = this.grid.searcher.split(",");	
			var tp = [];
			
			$.each(thisObj.grid.columnModels, function(i,cm) {	
				if(ConditionUtils.isTrue(cm.searchable)) {
					tp.push({v: cm.name, t:cm.text});
					return true;
				}
				$.each(searchFields, function(i, f){
					if(cm.name && cm.name == f) {
						cm.searchable = true;
						tp.push({v: f, t:cm.text});
						return false;
					}
				})
			})
			$.each(tp, function(i,f) {	
				op = $("<option/>", thisObj._doc).appendTo(thisObj.jFieldsCb);
				op.attr("value", f.v);
				op.attr("text", f.t);
			})
		} 
		else {	
			$.each(this.grid.columnModels, function(i,cm) {
				if(cm.name) {
					op = $("<option/>", thisObj._doc).appendTo(thisObj.jFieldsCb);
					op.attr("value", cm.name);
					op.attr("text", cm.text);
				}
			})
		}
		if(this.grid.searcher && (this.grid.searcher == false || this.grid.searcher == "false"))
		{
			$(this.jCt).hide();
		}
		this.jSText = $("<input type='text'/>", this._doc).appendTo(this.jCt).blur(function() {
			if(this.value == "") {
				this.value = thisObj.emptyText ;
			}
		}).focus(function() {
			if(this.value == thisObj.emptyText) {
				this.value = "";
			}
		}).keydown(function(e){
			if(e.keyCode == 13) {
				thisObj.doSearch();
			}
		});
		
		this.jSText.val(this.emptyText);
		this.jSText.attr("disabled", true);
		
		this.jSBtn = $("<input type='button' value='"+$RRs.comm_query+"'/>", this._doc).appendTo(this.jCt).click(function() {
			thisObj.doSearch();
		});
	},
	
	doSearch : function() {
		if(this.jSText.val() == this.emptyText) {
			if(this.jFieldsCb.val() == this.emptyOption.value) {
				this.searchName = "";
				this.searchValue = "";
			}else return false;
		} else {
			this.searchName = this.jFieldsCb.val();
			this.searchValue = this.jSText.val();
		}
		this.grid.load();
	},
	
	getLoadParams : function() {
		if(this.jFieldsCb.val() == this.emptyOption.value) {
			return {};
		}
		return {
			searchName:this.searchName,  
			searchValue: this.searchValue 
		};
	},
	
	onGridReset: function() {
		this.jFieldsCb.val(this.emptyOption.value);
		this.jSText.val(this.emptyText);
		this.searchName = "";
		this.searchValue =  "";
	},
	
	onGridLoadComplete: function() {
	}
})
