IReport_CBB_Grid.prototype.plugins.push({

	grid: null,
	_doc: null,
	
	jAllCb: null,
	
	load: function(grid) {
		var thisObj = this;
		if(!grid) return false;
		if(!grid.selector) {
			return false;
		}
		this.grid = grid;
		this._doc = this.grid._doc?this.grid._doc:document;
		
		if(this.grid.selector == "checkbox" || this.grid.selector == "true") {
			this.selectModel = "checkbox";
			this.initCheckBoxSelector();
			this.initDoms4CheckBoxModel();
			this.initRowClickForCheckbox();
		}
		else if(this.grid.selector == "radio") {
			this.selectModel = "radio";
			this.initRadioSelector();
			this.initDoms4RadioModel();
			this.initRowClickForRadio();
		}
		
		this.active = true;
		return true;
	},
	
	initRowClickForRadio: function() {
		var thisObj = this;
		this.grid.jGridTable.bind("click", function(e){
			var jTr = $(e.target).parents("tr.cbb-grid-row:first")
			if(jTr) {
				if(!jTr.hasClass("cbb-grid-row-selected")) {
					if(thisObj._ckRd) {
						$(thisObj._ckRd).removeClass("radio-checked radio-checked-hover").addClass("radio-unchecked");
						$(thisObj._ckRd).parents("tr.cbb-grid-row").removeClass("cbb-grid-row-selected");
					}
					var _rd = jTr.find("div.cbb-grid-radio").removeClass("radio-unchecked radio-unchecked-hover").addClass("radio-checked");
					thisObj._ckRd = _rd.get(0);
					jTr.addClass("cbb-grid-row-selected");
				}
			}
			return false;
		})
	},
	
	initRadioSelector : function() {
		var thisObj = this;
		this.grid.getSelectedRecords = function() {
			var records = [];
			this.jGridTable.find("tr.cbb-grid-row-selected").each(function(i,tr) {
				records.push($(tr).data("data"));
			})
			return records;
		}
		this.grid.columnModels.unshift({
			text:"&nbsp",
			width: 16,
			hCellClass: "cbb-grid-hcell",
			rCellClass: "cbb-grid-cell cbb-grid-cell-radio",
			render: function(el,cIndex,rIndex) {
				var jRd = $("<div class='cbb-grid-radio radio-unchecked' name='grid_rd_" + thisObj.grid.id + "' id='cb_" + cIndex + "_" + rIndex + "'/>", thisObj._doc);
				$(el).append(jRd);
			}
		});
		
		var jTh = this.grid.createHeadTh(0, this.grid.columnModels[0]);
		this.grid.jHTable.find("tr").prepend(jTh);
		
	},
	
	initDoms4RadioModel : function() {
		var thisObj = this;
		
		this.grid.jContainer.find("div.cbb-grid-radio").live("mouseover", function() {
				if($(this).hasClass("radio-unchecked")) {
					$(this).addClass("radio-unchecked-hover");
				} else {
					$(this).addClass("radio-checked-hover");
				}
			}).live("mouseout", function() {
				if($(this).hasClass("radio-unchecked-hover")) {
					$(this).removeClass("radio-unchecked-hover");
				} else {
					$(this).removeClass("radio-checked-hover");
				}
			})
	},
	
	initRowClickForCheckbox: function() {
		var thisObj = this;
		
		this.grid.jGridTable.bind("click", function(e){
			var _gtb = thisObj.grid.jGridTable;
			var jTr = $(e.target).parents("tr.cbb-grid-row:first")
			if(jTr) {
				if(jTr.hasClass("cbb-grid-row-selected")) {
					jTr.removeClass("cbb-grid-row-selected")
					jTr.find("div.cbb-grid-checkbox").removeClass("checked").addClass("unchecked");
					$("#allSelectCb_" + thisObj.grid.id, thisObj._doc).removeClass("checked checked-hover").addClass("unchecked");
				}
				else {
					jTr.addClass("cbb-grid-row-selected")
					jTr.find("div.cbb-grid-checkbox").removeClass("unchecked").addClass("checked");
					var l1 = _gtb.find("div.checked[name=grid_cb_"+ thisObj.grid.id +"]").length;
					var l2 =  _gtb.find("div.cbb-grid-checkbox[name=grid_cb_"+ thisObj.grid.id +"]").length;
					if(l1 == l2) {
						$("#allSelectCb_" + thisObj.grid.id, thisObj._doc).removeClass("unchecked unchecked-hover").addClass("checked");
					}
				}
			}
			return false;
		})
	},
	
	snatchSelectedRecords: function() {
		var rs = [];
		this.grid.jGridTable.find("tr.cbb-grid-row-selected").each(function(i,tr) {
			rs.push($(tr).data("data"));
		})
		return rs;
	},
	
	initCheckBoxSelector : function() {
		var thisObj = this;
		
		var tempRecords = [];
		
		this.grid.getSelectedRecords = function() {
			tempRecords = tempRecords.concat(thisObj.snatchSelectedRecords());
			var temp = thisObj.snatchSelectedRecords();
			tempRecords = [];
			this.reset();
			return temp;
		}
		
		$(this.grid).bind("onBeforeLoadData", function(e,grid) {
			tempRecords = tempRecords.concat(thisObj.snatchSelectedRecords());
		})
		
		this.grid.columnModels.unshift({
			text:"<div id='allSelectCb_"+ thisObj.grid.id +"' class='cbb-grid-checkbox unchecked'/>",
			width: 22,
			hCellClass: "cbb-grid-hcell",
			rCellClass: "cbb-grid-cell cbb-grid-cell-checkbox",
			render: function(el,cIndex,rIndex) {
				var jCb = $("<div class='cbb-grid-checkbox unchecked' name='grid_cb_" + thisObj.grid.id + "' id='cb_" + cIndex + "_" + rIndex + "'/>", thisObj._doc);
				$(el).append(jCb);
			}
		});
		
		var jTh = this.grid.createHeadTh(0, this.grid.columnModels[0]);
		this.grid.jHTable.find("tr").prepend(jTh);
		
	},
	
	initDoms4CheckBoxModel : function() {
		var thisObj = this;
		this.jAllCb = $("#allSelectCb_" + this.grid.id , this._doc);
		
		this.grid.jContainer.find("div.cbb-grid-checkbox").live("mouseover", function() {
				if($(this).hasClass("unchecked")) {
					$(this).addClass("unchecked-hover");
				} else {
					$(this).addClass("checked-hover");
				}
			}).live("mouseout", function() {
				if($(this).hasClass("unchecked-hover")) {
					$(this).removeClass("unchecked-hover");
				} else {
					$(this).removeClass("checked-hover");
				}
			}).live("click", function() {
				var _ptb = thisObj.grid.jGridTable;
				if(this.id == "allSelectCb_" + thisObj.grid.id) {
					if($(this).hasClass("unchecked")) {		
						var jCb = _ptb.find("div.unchecked[name=grid_cb_"+ thisObj.grid.id +"]");
						jCb.removeClass("unchecked unchecked-hover");
						jCb.addClass("checked");
						jCb.parents("tr.cbb-grid-row").addClass("cbb-grid-row-selected");
						
						$(this).removeClass("unchecked unchecked-hover").addClass("checked");
					} else {
						var jCb = _ptb.find("div.checked[name=grid_cb_"+ thisObj.grid.id +"]");
						jCb.removeClass("checked checked-hover");
						jCb.addClass("unchecked");
						jCb.parents("tr.cbb-grid-row").removeClass("cbb-grid-row-selected");
						
						$(this).removeClass("checked checked-hover").addClass("unchecked");
					}
				}
				else {
					if($(this).hasClass("unchecked")) {		
						$(this).parents("tr.cbb-grid-row").addClass("cbb-grid-row-selected");
						$(this).removeClass("unchecked unchecked-hover").addClass("checked");
						
						var l1 = _ptb.find("div.checked[name=grid_cb_"+ thisObj.grid.id +"]").length;
						var l2 =  _ptb.find("div.cbb-grid-checkbox[name=grid_cb_"+ thisObj.grid.id +"]").length;
						if(l1 == l2) {
							$("#allSelectCb_" + thisObj.grid.id, thisObj._doc).removeClass("unchecked unchecked-hover").addClass("checked");
						}
						
					} else {
						$(this).parents("tr.cbb-grid-row").removeClass("cbb-grid-row-selected");
						$(this).removeClass("checked checked-hover").addClass("unchecked unchecked-hover");
						$("#allSelectCb_" + thisObj.grid.id, thisObj._doc).removeClass("checked checked-hover").addClass("unchecked");
					}
				}
				return false;
			})
	},
	
	onGridLoadComplete: function() {
		if(!this.active) return false;
		var thisObj = this;
		if(this.selectModel == "checkbox") {
			$("#allSelectCb_" + thisObj.grid.id, this._doc).removeClass("checked checked-hover").addClass("unchecked");
		} else if(this.selectModel == "radio") {
		}
	}
})
