IReport_CBB_Grid.prototype.plugins.push({
	asceClass : "sasc",
	descClass:"sdesc",
	grid: null,
	
	sortName: "",
	sortOrder: "",
	
	active: false,
	
	sortTypes : {
		number : {
			getValue: function(td) {
				var v = $(td).find("div").text();
				if(!v || isNaN(v)) return 0;
				return parseInt(v);
			},
			fn: function(d1, d2) {
				if (Number(d1.value) < Number(d2.value)) { return -1; }
				if (Number(d1.value) > Number(d2.value)) { return 1; }
				return 0;
			}
		},
		string: {
			getValue: function(td) {
				var v = $(td).find("div").text();
				return v;
			},
			fn: function(s1,s2) {
				if (s1.value < s2.value) { return -1; }
				if (s1.value > s2.value) { return 1; }
				return 0;
			}
		}
	},
	
	load: function(grid) {
		if(!grid) return false;
		if(!grid.sorter || $C.isFalse(grid.sorter))  return false;
		this.grid = grid;
		this.grid.sortIndex = -1;
		
		var sortAll = $C.isTrue(grid.sorter);
		var sortFields = this.grid.sorter.split(",");
		
		var jTh = this.grid.jHTable.find("th");
		var thisObj = this;
		jTh.each(function(i, th) {
			var cm = $(th).data("model");
			if(sortAll || $.inArray(cm.name,sortFields) != -1 || $C.isTrue(cm.sortable)) {
				cm.sortable = true;
				$(th).bind("click", {
					plugin: thisObj,
					th: th
				}, thisObj.thClick)
			}
		})
		
		$(this.grid).bind("onReset", function(e, grid){
			if(grid.sortIndex != -1) {
				grid.jHTable.find("th").eq(grid.sortIndex).find("div").removeClass(thisObj.asceClass + " " + thisObj.descClass);
			}
			this.sortName = "";
			this.sortOrder = "";
		});
		
		this.active = true;
	},
	
	thClick : function(e) {
		var plugin = e.data.plugin;
		plugin.sort(e.data.th);
	},
	getClickIndex : function(th) {
		var index = -1;
		this.grid.jHTable.find("th").each(function(i, _th) {
			if(th == _th) {
				index = i;
				return false;
			}
		})
		return index;
	},
	sort: function(th) {
		var thisObj = this;
		
		var cm = $(th).data("model");
		var dataType = cm.dataType;
		
		var sortType = this.sortTypes[dataType];
		if(!sortType) {
			sortType = this.sortTypes["string"];
		}
		
		var cmIndex = this.getClickIndex(th);
		
		var cache = [];
		this.grid.jGridTable.find("tr").each(function(){
			cache.push({
				value: sortType.getValue(this.cells[cmIndex]),
				tr: this
			});			
		});
		
		if(cmIndex == this.grid.sortIndex) { 
			var textDiv = $(th).find("div");
			cache.reverse();
			if(textDiv.hasClass(this.asceClass)) {
				textDiv.removeClass(this.asceClass).addClass(this.descClass);
				this.sortOrder = "desc"
			} else {
				textDiv.removeClass(this.descClass).addClass(this.asceClass);
				this.sortOrder = "asc"
			}
		} else {	
			cache.sort(sortType.fn);
			
			this.sortOrder = "asc"
			this.srotName = cm.name;
			
			if(this.grid.sortIndex != -1) {
				this.grid.jHTable.find("th").eq(this.grid.sortIndex).find("div").removeClass(this.asceClass + " " + this.descClass);
			}
			$(th).find("div").addClass(this.asceClass);
			this.grid.sortIndex = cmIndex;
		}

		this.grid.jGridTable.remove("tr");	
		var sn = this.grid.sn;
		$.each(cache, function(i, d) {		
			if(sn === true || sn === "true") {
				$(d.tr).find("td.cbb-grid-cell-sn div").text(i+1);
			}
			thisObj.grid.jGridTable.append(d.tr);
			d.value = null
			d.tr = null
			d = null
		})
	},
	
	getLoadParams : function() {
		return {
			sortName: this.sortName,
			sortOrder: this.sortOrder
		};
	},
	onGridLoadComplete: function() {
		
	}
})
