var PluginMgr = PluginMgr ? PluginMgr : {
	plugins : {},
	add : function(id, obj) {
		this.plugins[id] = obj;
	},
	get : function(id) {
		return this.plugins[id];
	}
};
function ConditionEntity(configParams) {
	this.c = configParams;
	this.isEnable = false;
	this.isVisible = false;
    this.showInfo = true;
	this.autoLoad = "true"; 

	this.loadUrl = WEB_ROOT_ABS_PATH+"/conditionAjaxAction!getAjaxData.do?cfNameHF="+cfNameHF;
	
	this.conditionWrapId = this.c.id + "_condition_wrap";

	this.events = ["afterListenerChanged,onValueChange,onInitComplete,onBeforeLoadData,onLoadData,onAfterLoadData,onBeforeShowData,onShowData,onAfterShowData,transactionRelation"];

	this.resultData = {};

	this.listenObjs = [];

	this._initialized = false;

	this.listenEventsHandler = {};

	this.loadDataListenEvents = [];

	this.loadDataParamsSource = [];

	this.preLoadDataChain = []; 
	this.nextLoadDataChain = []; 

	this.initComponent = function() {

		this.initProperties();

		this.initDoms();
		if (PluginMgr.get(this.id) && PluginMgr.get(this.id).initPlugin) {
			PluginMgr.get(this.id).initPlugin();
		}
		this.afterInitDoms();
		if (this.visible) {
			this.display(this.isTrue(this.visible));
		}
		this.initEvents();
		this._buildLoadDataContext();
		this.initComplete();
	};
	this.afterInitDoms = function(){};
	this.initProperties = function() {
	};
	this.initDoms = function() {
	};
	this.initEvents = function() {
	};

    this.getCheckParam = function(){};
    this.checkDataInterface = function(arg){
        return {success:true};
    };
    
	this.isUseable = function() {
		return this.isEnable && this.isVisible;
	};

	this._buildLoadDataContext = function() {
		if (this.loadListenEvents) {
			var loadListenEvents = this.loadListenEvents;

			delete(this.loadListenEvents);

			var eDefineArr = loadListenEvents.split(";");
			var eDefine = "";
			var conditionId, eName;
			var tempArr;

			this.loadDataListenEvents = [];

			for (var i = 0; i < eDefineArr.length; i++) {
				eDefine = eDefineArr[i];
				tempArr = eDefine.split("#");
				conditionId = tempArr[0];
				eName = tempArr[1];
				eName = ConditionUtils.df(eName, "onValueChange");

				var listenObj = ConditionMgr.get(conditionId);

				if (!listenObj) {
					continue;
				}

				this.listenObjs.push(listenObj);
				this.loadDataListenEvents.push({
					listenObj : listenObj,
					eName : eName
				});
			}
		}

		if (!this.loadParamsSource) {
			this.loadDataParamsSource = this.listenObjs;
		} else {
			var loadParamsSource = this.loadParamsSource;
			var loadParamsSourceArr = loadParamsSource.split(",");

			delete(this.loadParamsSource);

			this.loadDataParamsSource = [];

			for (var i = 0; i < loadParamsSourceArr.length; i++) {
				var listenObj = ConditionMgr.get(loadParamsSourceArr[i]);
				if (listenObj) {
					this.loadDataParamsSource.push(listenObj);
				}
			}
		}

		if (!this.loadChain) {
			for (var i = 0; i < this.listenObjs.length; i++) {
				this.preLoadDataChain.push(this.listenObjs[i]);
				this.listenObjs[i].nextLoadDataChain.push(this);
			}
		} else {
			var loadChain = this.loadChain;
			var loadChainArr = loadChain.split(",");

			delete(this.loadChain);

			for (var i = 0; i < loadChainArr.length; i++) {
				var listenObj = ConditionMgr.get(loadChainArr[i]);
				if (listenObj && listenObj.type != "radioGroup" && listenObj.type != "select") {
					listenObj.nextLoadDataChain.push(this);
					this.preLoadDataChain.push(listenObj);
				}
			}
		}
	};

	this._bindLoadDataEvents = function() {
		var self = this;
		var listenObj;
		for (var i = 0; i < this.loadDataListenEvents.length; i++) {
			listenObj = this.loadDataListenEvents[i];
			this.registEvent(listenObj.listenObj, listenObj.eName, function() {
				if (self.ajaxDataSource && self.isTrue(self.autoLoad)) 
				{
					self._loadAjaxData();
				}else
				{
					self.publishEvent("afterListenerChanged");
				}
			});
		}
	};

	this._loadAjaxData = function() {
		if (this.ajaxDataSource && this.isTrue(this.autoLoad)) {
			this.loadAjaxData();
		}
		
	}

	this._beforeLoadData = function(params) {
		var result = this.beforeLoadData(params);
		if (result) {
			this.publishEvent("onBeforeLoadData");
		}
		return result;
	}
	this._afterLoadData = function() {
		this.afterLoadData();
		this.publishEvent("onAfterLoadData")
		this.publishEvent("afterListenerChanged");
		if (this.ajaxDataSource && this.resultData.success) {
			this._beforeShowResultData();
			this._showResultData();
			this._afterShowResultData();
		} else {
			LegoTag.Msg.info(this.resultData.msg);
		}
	}
	this._beforeShowResultData = function() {
		this.beforeShowData();
		this.publishEvent("onBeforeShowData");
	}

	this._afterShowResultData = function() {
		this.afterShowData();
		this.publishEvent("onAfterShowData");
	};

	this.loadAjaxData = function(param) {
		var params = jQuery.extend(this.getParams(), param);
		if (!this._beforeLoadData(params)) { 
			return;
		}
		this.getAjaxData(params);
	};

	this._showResultData = function() {

		this.resultData = $CUtils.df(this.resultData, {});
		this.resultData.data = $CUtils.df(this.resultData.data, []);

		this.showData();
		this.publishEvent("onShowData");
	};

	this.beforeLoadData = function(params) {
		return true;
	};
	this.afterLoadData = function() {
	};
	this.beforeShowData = function() {
	};
	this.showData = function() {
	};
	this.afterShowData = function() {
	};
	this.initComplete = function() {
		this.beforeInitComplete();
		this.publishEvent("onInitComplete");
		this.afterInitComplete();
		this._initialized = true;
        ConditionMgr.loadTriggerConfig();
	}, this.beforeInitComplete = function() {
	}, this.afterInitComplete = function() {
	},

	this.registEvent = function(obj, ename, fn, argObj) {
		jQuery(obj).bind(ename, argObj, fn);
	};

	this.publishEvent = function(ename) {
		jQuery(this).trigger(ename, this);
	}

	this.setValue = function(v) {
	};
	this.getValue = function() {
		return this.getConditionValue();
	}

	this.getConditionValue = function() {
		var result = {
            showInfo :  this.showInfo,
			id : this.id,
			label : this.label,
			value : this.getValueWithText(),
			subLabel : this.subLabel
		};
        
        if (this.c.type == "trigger"){
            if (this.c.type != "winGrid" && this.c.type != "winTree"){
                if (this.getActivesObject()){
	                result["type"] = this.getActivesObject()["type"];
	                result["id"] = this.getActivesObject()["id"];
                }
                if (result["type"] == "winGrid"){
		            result["displayField"] = this.getActivesObject().displayField;
		            if (this.getActivesObject().valueField){
		                result["valueField"] = this.getActivesObject().valueField.split(",")[0];
		            }
		        }
            }
            result["showInfo"] = this.getActivesObject()["showInfo"];
        }else{
            result["type"] = this.c.type;
        }
		return result;
	};

	this.getValueWithText = function() {
	};

	this.getSimpleValue = function() {
		var cdtValue = this.getValue();
		var params = [];
		if (cdtValue && cdtValue.value && cdtValue.value.length > 0) {
			for (var i = 0; i < cdtValue.value.length; i++) {
				params.push(cdtValue.value[0].value);
			}
		}
		return params.join(",");
	}

	this.isNeedLoadAjaxData = function() {

		return this.ajaxDataSource && this.isTrue(this.autoLoad) 
            && this.type != "checkboxGroup" && this.type != "radioGroup" && this.type != "select";
	}

	this.checkData = function() {
	};

	this.getValueWithKey = function() {
	};

	this.disable = function(b) {
	};

	this.display = function(b) {
		if (b)
			jQuery("#" + this.id + "_condition_wrap").show();
		else
			jQuery("#" + this.id + "_condition_wrap").hide();
		this.isVisible = b;
	},

	this.reset = function() {
	};

	this.clear = function() {
	};

	this.getValueDesc = function() {
	}

	this.getCommonParams = function() {
		return {
			conditionGroupId : this.groupId,
			subConditionGroupId : this.subGroupId,
			conditionId : this.id
		};
	}

	this.getParams = function() {
		var params = this.getCommonParams();
		var invokerParams = [];

		if (this.loadDataParamsSource) {
			for (var i = 0; i < this.loadDataParamsSource.length; i++) {
				invokerParams.push(this.loadDataParamsSource[i]
						.getSimpleValue());
			}
		}
		params['invokerParamString'] = JSON.stringify(invokerParams);
		return params
	}

	this.getAjaxData = function(params) {
		var thisObj = this;
		params["cdtType"] = thisObj.type
		LegoTag.Ajax.request({
        	url:"conditionAjaxAction.do",
        	params : {
        		invokerParamString: params['invokerParamString'],
        		cdtType:thisObj.type,
        		conditionGroupId:this.groupId,
        		conditionId:this.id,
        		subConditionGroupId:this.subGroupId
        	},
        	error:function()
        	{
            },
        	success:function(response)
        	{
        		thisObj.resultData = JSON.parse(response.responseText);
                thisObj._afterLoadData();
        	}
   		});
	}

	this.isTrue = function(v) {
		return v === "true" || v === true;
	}

	this.destory = function() {
	};

	if (PluginMgr.get(configParams.id)) {
		jQuery.extend(configParams, PluginMgr.get(configParams.id));
	}
	jQuery.extend(this, configParams);

	this.initComponent();
	
	this.isEnable = ConditionUtils.isFalse(this.disabled) || this.disabled == undefined;
	this.isVisible = !ConditionUtils.isFalse(this.visible) || this.disabled == undefined;
};

var SubConditionGroup = function(configParams) {
	this.isEnable = true;
	this.isVisible = true;
	
	this.subConditionArr = [];
	this.subConditionMap = {};
	
	for (var m in configParams) {
		this[m] = configParams[m];
	}

	this.isUseable = function() {
		return this.isEnable && this.isVisible;
	};
	
	this.currentStatus;
	
	this.setStatus = function(status, op) {
		var that = this;
		if (!op){
			op = this["switch"];
		}
		if (status == "off") {
			if (op == "hide") {
				jQuery("#" + that.groupContainerId).hide();
				jQuery.each(that.subConditionArr, function(i, c) {
						c.display(false);
				});
				that.currentStatus = "hide";
				that.isVisible = false;
			} else if (op == "disable") {
				jQuery.each(that.subConditionArr, function(i, c) {
						c.disable(true);
				});
				this.currentStatus = "disable";
				that.isEnable = false;
			}
		} else if (status == "on") {
			if (that.currentStatus == "hide") {
				jQuery.each(that.subConditionArr, function(i, c) {
						c.display(true);
                        if (jQuery.inArray(c.id, ConditionMgr._allRelationIds) != -1 && c.isUseable()){
                            c.publishEvent("onValueChange");
                        }
				});
				jQuery("#" + that.groupContainerId).show();
				that.isVisible = true;
			}
			if (that.currentStatus == "disable") {
				jQuery.each(that.subConditionArr, function(i, c) {
						c.disable(false);
                        if (jQuery.inArray(c.id, ConditionMgr._allRelationIds) != -1 && c.isUseable()){
                            c.publishEvent("onValueChange");
                        }
				});
				that.isEnable = true;
			}

			for (var i = 0; i < ConditionMgr._controlIdArr.length; ++i) {
				this.getCondition(ConditionMgr._controlIdArr[i])
						.publishEvent("onValueChange");
			}
		}
	};

	this.displaySelf = function(flag) {
		var _elId = this.id + "_wrap";
		if (flag) {
			jQuery("#" + _elId).show();
			this.setStatus("on", "hide");
		} else {
			jQuery("#" + _elId).hide();
			this.setStatus("off", "hide");
		}
	};
	
	this.reset = function(){
		jQuery.each(this.subConditionArr, function(i, cond){
			if (cond.reset)
				cond.reset();
		});
	};

	this.getCondition = function(id) {
		return this.subConditionMap[id];
	}

	this.addCondition = function(c) {
		this.subConditionArr.push(c);
		this.subConditionMap[c.id] = c;
	}

	this.removeCondition = function(c) {
		if (this.subConditionMap[c.id]) {
			this.subConditionArr.remove(c);
			this.subConditionMap[c.id] = null;
			delete this.subConditionMap[c.id];
		}
	};

	var thisObj = this;
	if (this["switch"]) {
		this.jSwitch = jQuery("#" + this.switchId);
		this.jSwitch.show();
		this.jSwitch.bind("click", function(e) {
			thisObj.setStatus(e.target.checked ? "on" : "off");
		})
	}
}

var ConditionMgr = {
    triggerConfig :{},
	functions : {},
	relation : {},
	_allRelationIds : [],
	_controlIdArr : [],
    addTriggerConfig : function(triggerId, elementId){
        if (this.triggerConfig[triggerId]){
            var ids = this.triggerConfig["ids"];
            if (ids){
                ids.push(elementId);
            }
        }else{
            this.triggerConfig[triggerId] = {
                ids : [elementId]
            };
        }
    },
    loadTriggerConfig : function(){
        for (var p in this.triggerConfig){
            var trigger = this.get(p);
            if (trigger){
                var ids = this.triggerConfig[p]["ids"];
                if (ids){
                    for (var i = 0; i < ids.length; i++){
                        trigger.addRelationId(ids[i]);
                    }
                }
            }
        }
    },
	addRelation : function(controlId, ids) {
		this.relation[controlId] = ids;
		this._controlIdArr.push(controlId);
		this._allRelationIds.push(controlId);
		this._allRelationIds.push(ids.split(","));
	},
	conditionEntityArr : [],
	conditionEntityMap : {},
	subGroupArr : [],
	subGroupMap : {},
	add : function(obj) {
		this.conditionEntityArr.push(obj);
		this.conditionEntityMap[obj.id] = obj;
		this.subGroupMap[obj.subGroupId].addCondition(obj);
	},
	get : function(id) {
		return this.conditionEntityMap[id];
	},
	getSubGroup : function(id) {
		return this.subGroupMap[id];
	},
	addSubGroup : function(subGroup) {
		this.subGroupArr.push(subGroup);
		this.subGroupMap[subGroup.id] = subGroup;
	},
	removeSubGroup : function(subGroup) {
		this.subGroupArr.remove(subGroup);
		this.subGroupMap[subGroup.id] = null;
		delete this.subGroupMap[subGroup.id];
	},
	destory : function() {
		jQuery.each(this.conditionEntityArr, function(i, c) {
			if (c.destory) {
				c.destory();
			}
		})
	},
	remove : function(c) {
		if (this.conditionEntityMap[c.id]) {
			this.subGroupMap[c.subGroupId].removeCondition(c);
			this.conditionEntityArr.remove(c);
			this.conditionEntityMap[c.id] = null;
			delete this.conditionEntityMap[c.id];
		}
	},
	checkData : function() {
		var resObj = {
			success : true,
			msg : ""
		};
		var flag = true;
		jQuery.each(this.subGroupArr, function(i, sub){
			if (sub.isUseable() && flag === true){
				for (var j = 0; j < sub.subConditionArr.length; j++){
                    var cmp = sub.subConditionArr[j];
					var ckRes = cmp.checkData();
                    if (cmp.type != "winGrid" && cmp.type != "winTree"){
						if (cmp.isUseable()){
                            if (ckRes.success !== true){
                                jQuery.extend(resObj, ckRes);
                                if(null == resObj.isRequiredFailed || !resObj.isRequiredFailed){
                                	flag = false;
                                	return false;
                                }
                            }else{
                                var tmp = cmp.checkDataInterface(cmp.getCheckParam());
                                if (tmp.success !== true){
	                                jQuery.extend(resObj, tmp);
	                                flag = false;
	                                return false;
                                }
                            }
						}
                    }
				}
			}else{
                return false;
            }
		});
		return resObj;
	},
	resetAll : function() {
		jQuery.each(this.subGroupArr, function(i, sub){
			sub.reset();
		});
	},
	getValues : function() {
		var checkResult = this.checkData();
		if (checkResult && checkResult.success === true) {
			var values = [];
			jQuery.each(this.subGroupArr, function(k, sub){
				if (sub.isUseable()){
					for (var i = 0; i < sub.subConditionArr.length; i++){
                        if (sub.subConditionArr[i].type != "winGrid" && sub.subConditionArr[i].type != "winTree"){
							if (sub.subConditionArr[i].isUseable()){
								values.push(jQuery.extend(sub.subConditionArr[i].getValue(), {
									subGroupId : sub.id,
									subGroupLabel : sub.label,
									groupOrder: k ,
									subLabel : sub.subLabel
								}));
							}
                        }
					}
				}
			});
			return values;
		} else {
			if(null == checkResult.isRequiredFailed || !checkResult.isRequiredFailed){
                LegoTag.Msg.failed(checkResult.msg); 
             }else{
             	LegoTag.Msg.info(checkResult.msg); 
             }
			return;
		}
	},
	setValues : function(values) {
		var that = this;
		jQuery.each(values, function(i, v) {
			var _obj = that.getValueById(v.id);
			if (_obj){
                _obj.setValue(v.value);
            }
		});
	},
	getValueById : function(id) {
		if (this.conditionEntityMap[id]){
			return this.conditionEntityMap[id];
		}
		return null;
	},
	showErrorMsg : function() {

	}
};

jQuery(window).bind("unload", function() {
	ConditionMgr.destory();
});

var ConditionGroupMgr = {
	groupInfoMap : {},
	groupArr : [],
	add : function(groupInfo) {
		this.groupInfoMap[groupInfo["id"]] = groupInfo;
		this.groupArr.push(groupInfo);
	},
	get : function(groupId) {
		return this.groupInfoMap[groupId];
	}
};

var ConditionDataLoadChain = {
	loadedConditionArr : [], 
	loadedConditionMap : {}, 

	_afterAllConditionLoaded : function() {
		this.removeListener();
		jQuery(this).trigger("bindLoadDataEvents");
		jQuery(this).trigger("afterAllConditionLoaded");
	},
	doAfterShowData: function(event) {
		var cdt = event.data;
		var thisObj = ConditionDataLoadChain;
		thisObj.loadedConditionArr.push(cdt);
		thisObj.loadedConditionMap[cdt.id] = cdt;

		var nextLoadDataChain = event.data.nextLoadDataChain;
		var preLoadDataChain;
		var nextCdt, preCdt, allPreConditionLoaded = true;

		if (nextLoadDataChain.length > 0) {
			for (var i = 0; i < nextLoadDataChain.length; i++) {
				nextCdt = nextLoadDataChain[i];
				preLoadDataChain = nextCdt.preLoadDataChain;

				if (preLoadDataChain.length > 0) {
					for (var k = 0; k < preLoadDataChain.length; k++) {
						preCdt = preLoadDataChain[k];
						if (!thisObj.isLoaded(preCdt)) {
							allPreConditionLoaded = false;
							break;
						}
					}
				}
				if (allPreConditionLoaded) {
					if (nextCdt.isNeedLoadAjaxData()) 
					{
						nextCdt._loadAjaxData();
					}else{
						thisObj.loadedConditionArr.push(nextCdt);
						thisObj.loadedConditionMap[nextCdt.id] = nextCdt;
					}
				}
			}
		}

		if (thisObj.isLoadAllCondition()) {
			thisObj._afterAllConditionLoaded();
		}
	},

	load : function() {
		var cdtArr = ConditionMgr.conditionEntityArr;
		var cdt;

		this.addAfterShowDataListener();

		for (var i = 0; i < cdtArr.length; i++) {
			cdt = cdtArr[i];
			if (cdt.preLoadDataChain.length > 0) 
			{
				continue;
			}
			if (cdt.isNeedLoadAjaxData()) 
			{
				cdt._loadAjaxData();
			} else {
				cdt.publishEvent("transactionRelation");
				this.loadedConditionArr.push(cdt);
				this.loadedConditionMap[cdt.id] = cdt;
			}
			
		}

		if (this.isLoadAllCondition()) 
		{
			this._afterAllConditionLoaded();
		}
	},
	isLoadAllCondition : function() {
		if (this.loadedConditionArr.length == ConditionMgr.conditionEntityArr.length) {
			return true;
		}
		return false;
	},
	addAfterShowDataListener : function() {
		var cdtArr = ConditionMgr.conditionEntityArr;
		for (var i = 0; i < cdtArr.length; i++) {
			cdt = cdtArr[i];
			jQuery(cdt).bind("onAfterShowData", cdt, this.doAfterShowData);
		}
	},
	removeListener : function() {
		var cdtArr = ConditionMgr.conditionEntityArr;
		for (var i = 0; i < cdtArr.length; i++) {
			cdt = cdtArr[i];
			jQuery(cdt).unbind("onAfterShowData", this.doAfterShowData);
		}
	},

	isLoaded : function(cdt) {
		if (cdt.isNeedLoadAjaxData()) {
			var cdt = this.loadedConditionMap[cdt.id];
			if (cdt) {
				return true;
			}
			return false;
		} else {
			return true;
		}
	}
}