ConditionMgr.functions["checkboxGroup"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
        this.labelContainerId = this.id + "_label";
        this.columns = ConditionUtils.df(this.columns, 4);
        this.displayField = ConditionUtils.df(this.displayField, "value");
        this.valueField = ConditionUtils.df(this.valueField, "key");
        this.boxName = this.id + "_ckb";
        this.containerId = this.id + "_container";
        this.allLinkerId = this.id + "_all_link";
        this.checkedAllFlag = this.checkedItems === "all" ? true : false;
        this.linkShow = this.linkShow;
        jQuery("#" + this.allLinkerId).text(this.checkedItems === "all"? "["+$RRs.cbg_clearAll+"]": "["+$RRs.cbg_selectAll+"]");
        this.cutNum = this.cutNum;
        this.maxNum = isNaN(this.maxNum) ? -1 : this.maxNum;
    },

    initDoms : function() {
        if (!this.container){
            this.container = jQuery("#" + this.containerId);
        }
        
        var h = this.groupHeight;
        h = parseInt(h);
        h = isNaN(h)?false:h;
        var w = this.groupWidth;
        w = isNaN(w)?false : w;
        if (w){
            this.container.css({
                overflowX: "scroll",
                width : w + "px"
            });
        }
        var totalNum = this.getBoxes().size();
        var rows = parseInt(totalNum/this.columns);
        if(totalNum % this.columns > 0){
        	rows += 1;
        }
        if(h && rows*16 > h) {
            this.container.addClass("cbb-cbgroup-ct").css({
                overflowY:"scroll"
            });
            this.container.css("height", h + "px");
        }
        
        this.allLinker = jQuery("#" + this.id + "_all_link");
        var that = this;
        if (that.allLinker) {
            that.allLinker.bind("click",{target:that}, this._checkAllEvent);
        }
        if(this.linkShow=='false'){
         $("a").remove();
        }else{
        }
        this._addEvent();
    },
    _addEvent : function()
    {
        var that = this;
        this.getBoxes().find(".x-form-check-wrap-inner").bind('click',function(){
            var parentDiv = jQuery(this).parent('div');
            if (parentDiv.hasClass('x-form-check-checked')){
                parentDiv.removeClass('x-form-check-checked');
            }else{
                parentDiv.addClass('x-form-check-checked');
            }
            that.publishEvent("onValueChange");
        });
    },
    _checkAllEvent : function(event) {
        var that = event.data.target;
        that.checkedAll(!that.checkedAllFlag);
        jQuery("#" + that.allLinkerId).text(that.checkedAllFlag === true? "["+$RRs.cbg_clearAll+"]": "["+$RRs.cbg_selectAll+"]");
    },
    beforeShowData : function() {
        this.clear();
        jQuery("#" + this.containerId).hide();
    },
    changeOptions : function(_data){
        this.clear();
        this._init(_data);
    },
    isLoaded : function(){
        return true;
    },
    _init : function(_data){
        var that = this;
        ConditionUtils.createChooseObjGroup({
            containerId : this.containerId,
            name : this.boxName,
            data : _data,
            cutNum : this.cutNum,
            valueField : this.valueField,
            displayField : this.displayField,
            columns : this.columns
        });
        this._addEvent();
    },
    showData : function() {
        this._init(this.resultData.data);
    },
    afterShowData : function() {
        this.checkItems();
        jQuery("#" + this.containerId).show();
    },
    checkItems : function() {
        if (this.getBoxes().size() > this.columns) {
            jQuery(this.allLinker).show();
        }
        if (this.getBoxes().size() > 0) {
            if (this.isTrue(this.disabled)){
                this.disable(true);
            }
            if (this.checkedItems){
                if (this.checkedItems === "all") {
                    this.checkedAll(true);
                } else {
                    this.checkedAll(false);
                    this.checkedByValue(this.checkedItems);
                }
            }else{
                this.checkedAll(false);
                this.getBoxes().first().find(".x-form-check-wrap-inner").trigger('click');;
            }
            this.disableItems(this.disabledItems, true);

            this.checkedAllFlag = this.checkedItems === "all" ? true : false;
            jQuery("#" + this.allLinkerId).text(this.checkedItems === "all"
                    ? "["+$RRs.cbg_clearAll+"]"
                    : "["+$RRs.cbg_selectAll+"]");
        }
    },

    beforeInitComplete : function() {
        this.checkItems();
    },

    clear : function() {
        jQuery("#" + this.containerId).empty();
    },
    reset : function(){
        jQuery.each(this.getBoxes(),function(){
           jQuery(this).removeClass('x-form-check-checked');
        });
        this.checkItems();
        this.publishEvent("onValueChange");
    },
    getValueWithText : function() {
        return this.getBoxes({flag:'checked'}).map(function(index,n) {
            var inputElt = jQuery(this).find(":input[type='checkbox']");
            var title = inputElt.next().attr('title');
            var v = inputElt.attr("value");
            var t = inputElt.data("text");
            if(!t){
                t = jQuery.trim(inputElt.next().attr('title'));
            }
            
            return {
                value : v,
                text : t
            };
        }).get();

    },
    getSimpleValue : function() {
        return this.getBoxes({flag:"checked"}).map(function() {
            return jQuery(this).find(":input[type='checkbox']").attr('value');
        }).get().join(",");
    },
    getBoxes : function(param) {
        var allCheckBox = jQuery("#" + this.containerId + ">table").find(".x-form-check-wrap");
        if (param){
	        if (param.flag && param.flag == 'disabled'){
	            return allCheckBox.filter(".x-item-disabled");
	        }else if (param.flag && param.flag == 'checked'){
	            return allCheckBox.filter(".x-form-check-checked");
	        }else if (param.flag && param.flag == 'enabled'){
	            return allCheckBox.not(jQuery(".x-item-disabled"));
	        }
        }
        
        return allCheckBox;
    },
    getObjByValue : function(v) {
        return jQuery("#" + this.containerId).find(":checkbox[name=" + this.boxName
                + "][value=" + v + "]");
    },
    setValue : function(values) {
        jQuery.each(this.getBoxes(),function(){
           jQuery(this).removeClass('x-form-check-checked');
        });
        
        var ids = jQuery(values).map(function(){
            return this["value"];
        }).get().join(",");
        
        this.checkedByValue(ids, true);
    },
    checkedByValue : function(values, b) {
        var that = this;
        b = b == undefined ? true : b;
        if (values) {
            var arr = values.split(",");
            jQuery.each(arr, function(i, v) {
               that.getObjByValue(v).parent("div")
                                    .parent("div").addClass("x-form-check-checked");
            });
            that.publishEvent("onValueChange");
        }
    },
    checkedAll : function(bn) {
        jQuery.each(this.getBoxes({flag:'enabled'}), function(){
            if (bn == true){
                if (!jQuery(this).hasClass('x-form-check-checked')){
                    jQuery(this).addClass('x-form-check-checked');
                }
            }else{
                if (jQuery(this).hasClass('x-form-check-checked')){
                    jQuery(this).removeClass('x-form-check-checked');
                }
            }
        });
        
        this.publishEvent("onValueChange");
        this.checkedAllFlag = bn;
    },
    disableItems : function(ids, b) {
        var that = this;
        var arrIds;
        if (!ids) {
            return;
        }
        else if (ids == "all"){
            var allBoxes = this.getBoxes();
            if (b){
               jQuery.each(allBoxes, function(i, v) {
                      jQuery("#" + that.id+"_ckb_"+i).parent('div').unbind()
	                               .parent('div').addClass('x-item-disabled'); 
               });
            }else{
                jQuery.each(allBoxes, function(i, v) {
	                jQuery(this).find(".x-form-check-wrap-inner")
	                                     .removeClass('x-item-disabled');
               });
            }
        }else{
            arrIds = ids.split(",");
            if (b){
               jQuery.each(arrIds, function(i, _id){
	                that.getObjByValue(_id).parent('div').unbind()
	                             .parent('div').addClass('x-item-disabled');
               }); 
            }else{
               jQuery.each(arrIds, function(i, _id){
	                that.getObjByValue(_id).parent('div').bind('click',function(){
	                    var parentDiv = jQuery(this).parent("div");
			            if (parentDiv.hasClass('x-form-check-checked')){
			                parentDiv.removeClass('x-form-check-checked');
			            }else{
			                parentDiv.addClass('x-form-check-checked');
			            }
			            that.publishEvent("onValueChange");
	                }).parent('div').removeClass('x-item-disabled');
               });
            }
        }
    },
    disable : function(b){
        this.disableItems("all", b);
        this.isEnable=!b;
    },
    checkData : function() {
        var values = this.getValueWithText();
        var resultObj = {success : true,msg : "",isRequiredFailed : false};
        
        if (this.maxNum !== -1 && values.length > this.maxNum){
            resultObj.success=false;
            resultObj.msg=this.maxNumText?this.maxNumText:$RRs.checkbox_maxnumtext_isempty + this.maxNum + $RRs.checkbox_maxnumitemtext;
            return resultObj; 
        }
        
        
        if (this.isTrue(this.required)
                && this.getSimpleValue().length == 0) {
            resultObj.success=false;
            resultObj.msg=this.blankValidateText;
            resultObj.isRequiredFailed = true ;
        }
        
        return resultObj;
    },
    afterComplete : function(){
        this.checkItems();
    }
})));
};
