ConditionMgr.functions["ComboButton"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
    this.jid="#"+this.id;
    this.descId = "lbl_" + this.id;
    this.containerId = this.id + "_container";
    this.initialized=false;
	},
    onInitComplete:function()
    {
    	this.initialized=true;
    },
	initDoms : function() {
	 var that = this;
	 var params={value:"item1", text:"item1"};
	 this.container = jQuery("#" + this.containerId);
	 this.comboid = jQuery("#" + this.id + "-div");
	 if(this.defaultValue)
     {
     	var kv=this.defaultValue.split(",");
     	if(kv[0] == -1)
     	{
     		return ;
     	}
     	else if(kv.length==2)
     	{
     		params={value:kv[0], text:kv[1]};
     	}
     	else
     	{
     		params={value:kv[0], text:kv[0]};
     	}
     }
	 if(this.required == "true"){
	 	$(this.comboid).find("span").html("");
		$(this.comboid).find("span").append("<span id='"+that.id+"-star'>*</span>"+that.desc).removeClass("rendar-star").attr("title", that.desc);
		$("#"+that.id+"-star").css({color:"red", "padding-right":"5px"});
	 } else if(this.required == "false"){
	  	$(this.comboid).find("span").html("");
	  	$(this.comboid).find("span").append("<span id='"+that.id+"-star'></span>"+that.desc).removeClass("rendar-star").attr("title", that.desc);
	    $("#"+that.id+"-star").css("padding-right","3px");
	 }
    this.setValue(params);
	},
	beforeShowData : function() {
	},
	showData : function() {
	},
	afterShowData : function() {
		var that = this;
		this.checkItems();
	},
	checkItems : function() {
		if (this.isTrue(this.disabled)){
            this.disable(this.isTrue(this.disabled));
        }
	},
	beforeInitComplete : function() {
		this.checkItems();
	},
	clear : function() {
	},
	reset : function(){
	},
	getValueWithText : function() {
		var retVals=new Array();
		var text = $(this.jid).val().trim();
		var value = $(this.jid+"-hidden").val().trim();
		if(text!='')
		{
			retVals[0]={value : value,text : text};
		}
		return retVals;
	},
	getSimpleValue : function() {
		var text = $(this.jid).val().trim();
		var value = $(this.jid+"-hidden").val().trim();
		return {value : value,text : text};
	},
	setValue : function(values) {
		if (values != undefined) {
			$(this.jid).val(values["text"]);
			$(this.jid+"-hidden").val(values["value"]);
			if(this.initialized)
			{
				$(this).trigger("onValueChange", this);
			}
		}
	},
	setNoValueChangeValue : function(values) {
		if (values != undefined) {
			$(this.jid).val(values["text"]);
			$(this.jid+"-hidden").val(values["value"]);
		}
	},
	disable : function(bn) {
	  $(this.jid).attr("disabled", bn);
	  LegoTag.setDisableds([this.id], bn);
      this.isEnable=!bn;
	},
	_check:function(obj)
	{
		var text = $(this.jid).val().trim();
		var value = $(this.jid+"-hidden").val().trim();
		if(text==''&& value=='')
		{
			return false;
		}
		
		return true;
	},
	checkData : function() {
			var rstObj = {
					success : true,
					msg : '' ,
					isRequiredFailed : false
				};
			var items=this.getValueWithText();
			if (this.required && items.length==0) {
				rstObj.success = false;
				rstObj.msg = this.blankValidateText;
				rstObj.isRequiredFailed = true ;
			} else if (!this._check(this)) {
				rstObj.success = false;
				rstObj.msg = this.invalidText ? this.invalidText : this.blankValidateText;
			}
			return rstObj;
	}
	
	
    })));
};