ConditionMgr.functions["comboDate"] = function(configParams){
ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
	initProperties : function() {
	    this.radioCheck=1;
		this.fieldId = "txt_" + this.id;						
		this.fieldName = this.id + "_n";						
		this.containerId = this.id + "_container";				
		this.descId = "lbl_" + this.id;
		this.startTimeLong = 0;                                  
		this.endTimeLong = 0;									 
		this.dayType = "POINT"	;
		this.dateFmtStyle =  "{dateFmt:\'"+"yyyy-MM-dd HH:mm:ss"+"\'}";		
		this.date_type = dateType;								
		this.date_quarter = dateQuarter;						
		this.date_month =  dateMonth;							
		this.data_week = data52Week; 							
		this.dataLevelKinds = this.dataLevelKind;
		this.data_hide = this.dataLevelHide;
		
		if(this.dataLevelKind==undefined)
		{
		  this.dataLevelKinds = "0,1,2,3";
		}
		if(this.dataLevelHide==undefined)
		{
		  this.data_hide="false";
		}
		
		var myDataLevel= [];
		var subDataLevel= [];
		var item ="";         
	      subDataLevel=this.dataLevelKinds.split(",");          
	      for (var i=0;i<subDataLevel.length;i++)       
	      {    
			   	var array = [];
	       		if(subDataLevel[i]<dataLevel.length){
	       		item = subDataLevel[i];
	       		}
			    array[0] = dataLevel[item][0];
			    array[1] = dataLevel[item][1];
			   	myDataLevel.push(array);   	
	      } 
	    this.data_level=myDataLevel;                            
		this.dateConfig = getDateConfig(this);					
		
		if(this.dateConfig === "")
		{
			this.dateConfig = "dateFmt:'"+Date_const.defaultDateFmt+"'";
			this.dateFmt = Date_const.defaultDateFmt;
		}       
		this.date = new Date();
	},
	initDoms : function() {
		this.container = $("#" + this.containerId);
		var that = this;
		
		
		var tab = $("<table>",{cellspacing:'0',cellpadding:'0',width:'100%'}).appendTo(that.container);  
		var timeLevel_tr =$("<tr height='27'></tr>").appendTo(tab);	
		var timeRange_tr =$("<tr height='27'></tr>").appendTo(tab);	
		var dataLevel_tr =$("<tr height='27'></tr>").appendTo(tab);	
		var timeLevel_td1= $("<td align='left' width='4%'></td>").appendTo(timeLevel_tr);
		var timeLevel_td2= $("<td align='left' width='16%'></td>").appendTo(timeLevel_tr);
		var timeLevel_td3= $("<td width='30%'></td>").appendTo(timeLevel_tr);
		var timeLevel_td4= $("<td width='54%'></td>").appendTo(timeLevel_tr);
		var timeRange_td1= $("<td align='left'></td>").appendTo(timeRange_tr);
		var timeRange_td2= $("<td></td>").appendTo(timeRange_tr);
		var timeRange_td3= $("<td></td>").appendTo(timeRange_tr);
		var timeRange_td4= $("<td></td>").appendTo(timeRange_tr);
		var dataLevel_td1= $("<td></td>").appendTo(dataLevel_tr);
		var dataLevel_td2= $("<td></td>").appendTo(dataLevel_tr);
		var dataLevel_td3= $("<td></td>").appendTo(dataLevel_tr);
		var dataLevel_td4= $("<td></td>").appendTo(dataLevel_tr);
		
		var tabInner=$("<table>",{cellspacing:'0',cellpadding:'0'}).appendTo(timeLevel_td4);
		var trInner =$("<tr></tr>").appendTo(tabInner);
		var tdInner1= $("<td></td>").appendTo(trInner);
		var tdInner2= $("<td></td>").appendTo(trInner);
		var tdInner3= $("<td></td>").appendTo(trInner);
		var tdInner4= $("<td></td>").appendTo(trInner);
		var tdInner5= $("<td></td>").appendTo(trInner);	
		
		that.radio1 = jQuery("<input type='radio' id='rd_"+this.id+"_0' name='radio_'"+this.id+" checked='checked'/>").appendTo(timeLevel_td1);
		jQuery("<label>"+$RRs.cbd_timeGranularity+":</label>").appendTo(timeLevel_td2);
		that.radio2 = jQuery("<input type='radio' id='rd_"+this.id+"_1' name='radio_'"+this.id+"/>").appendTo(timeRange_td1);
		jQuery("<label>"+$RRs.cbd_timeRange+":</label>").appendTo(timeRange_td2);
		if(this.data_hide==="false"){
		jQuery("<label>"+$RRs.cbd_dataGranularity+":</label>").appendTo(dataLevel_td2);
		}else{
		
		}
		
		that.dateSelectType_div =$("<div id='dateSelectType_div_"+ this.id+"'></div>").appendTo(timeLevel_td3);
		that.dateText_div =$("<div id='dateText_div_"+ this.id +"' ></div>").appendTo(tdInner1);
		that.year_div =$("<div id='year_div_"+ this.id +"'  ></div>").appendTo(tdInner2);
		that.month_div =$("<div id='month_div_"+ this.id +"' ></div>").appendTo(tdInner3);
		that.quarter_div =$("<div id='quarter_div_"+ this.id +"' ></div>").appendTo(tdInner4);
		that.week_div =$("<div id='week_div_"+ this.id +"'></div>").appendTo(tdInner5);
		that.dataLevel_div = $("<div id='dateLevel_div_"+ this.id +"'></div>").appendTo(dataLevel_td3);
		that.week_div.hide();
		that.month_div.hide();
		that.year_div.hide();
		that.quarter_div.hide();

		that.dateText = $("<input class='Wdate' type='text' onClick=\"WdatePicker({"+this.dateConfig+"})\"/>")
		.bind('focus',function(){
		    jQuery(this).css("border","1px solid #7EADD9");
		})
		.bind('blur',function(){
		    if(this.value==''||this.value==null){
		       jQuery(this).css("border","1px solid #DD7870");
		    }else{
		    	jQuery(this).css("border","1px solid #B5B8C8");
		    }
		 })
		.attr({
			name:that.fieldName
		});
		that.dateText.val(toStringByPattern(that.date,that.dateFmt)).appendTo(that.dateText_div);   								

		that.dateSelectType_sel = createSelectDoms("dateSelectType_div_"+ this.id,"dateSelectType_id_"+this.id,"dateSelectType_n"+this.id,that.date_type,'1');   
		that.week_sel = createSelectDoms("week_div_"+ that.id,"week_select_id_"+that.id,"week_select_name"+that.id,that.data_week,that.initWeek());  				
		that.month_sel = createSelectDoms("month_div_"+ that.id,"month_select_id_"+that.id,"month_select_name"+that.id,that.date_month,that.initMonth());			
		that.quarter_sel = createSelectDoms("quarter_div_"+ that.id,"quarter_select_id_"+that.id,"quarter_select_name"+that.id,that.date_quarter,that.initQuarter());	
		that.year_sel = createSelectDoms("year_div_"+ that.id,"year_select_id_"+that.id,"year_select_name"+that.id,that.initYears(),that.date.getFullYear()+'');				
		
		if(this.data_hide==="false"){ 
		that.date_sel = createSelectDoms("dateLevel_div_"+ this.id,"dateLevel_select_id_"+this.id,"dateLevel_select_name"+this.id,that.data_level,'0',this.readOnly);				
		}else{
		that.date_sel = "";
		}
		
		that.dateSelectType_div.append(that.dateSelectType_sel);
		that.week_div.append(that.week_sel);
		that.month_div.append(that.month_sel);
		that.quarter_div.append(that.quarter_sel);
		that.year_div.append(that.year_sel);
		
		that.startTime_txt = jQuery("<input  class='Wdate' type='text' onClick=\"WdatePicker("+ this.dateFmtStyle +")\"/>")
		.bind('focus',function(){
		    jQuery(this).css("border","1px solid #7EADD9");
		})
		.bind('blur',function(){
		    if(this.value==''||this.value==null){
		       jQuery(this).css("border","1px solid #DD7870");
		    }else{
		    	jQuery(this).css("border","1px solid #B5B8C8");
		    }
		 })
		.attr({
			id:"dateRangeStart",
			name:that.fieldName
		});
		that.endTime_txt = jQuery("<input  class='Wdate' type='text' onClick=\"WdatePicker("+ this.dateFmtStyle +")\"/>")
		.bind('focus',function(){
		    jQuery(this).css("border","1px solid #7EADD9");
		})
		.bind('blur',function(){
		    if(this.value==''||this.value==null){
		       jQuery(this).css("border","1px solid #DD7870");
		    }else{
		    	jQuery(this).css("border","1px solid #B5B8C8");
		    }
		 })
		.attr({
			id:"dateRangeEnd",
			name:that.fieldName
		});
		that.startTime_txt.val(toStringByPattern(that.date,"yyyy-MM-dd")+" 00:00:00").appendTo(timeRange_td3).attr("disabled","disabled");
		that.endTime_txt.val(toStringByPattern(that.date,"yyyy-MM-dd HH:mm:ss")).appendTo(timeRange_td4).attr("disabled","disabled");
		that.dayChange();
	},
	
	disableRadio1:function(flag)
	{
		var that = this;
		if((!flag)&&(that.radioCheck == 2))
		{
			return ;
		}
		if(flag)
		{
			that.dateSelectType_sel.attr("disabled", true);
			that.week_sel.attr("disabled", true);
			that.month_sel.attr("disabled", true);
			that.quarter_sel.attr("disabled", true);
			that.year_sel.attr("disabled", true);
			that.dateText.attr("disabled","disabled");
			if(that.dateText.val()==null || that.dateText.val()==''){
			    that.dateText.val(toStringByPattern(new Date(),"yyyy-MM-dd"));
			}
			this.dateText.attr("blur",function(){
		    	jQuery(this).css("border","1px solid #B5B8C8");
		    	
			});
		}
		else
		{
			that.dateSelectType_sel.removeAttr("disabled");
			that.week_sel.removeAttr("disabled");
			that.month_sel.removeAttr("disabled");
			that.quarter_sel.removeAttr("disabled");
			that.year_sel.removeAttr("disabled");
			that.dateText.removeAttr("disabled");
		}
	},
	
	radio1Check:function(){
		var that = this;
		that.radioCheck =1;
		
		that.disableRadio1(false);
		that.disableRadio2(true);
		
		if(that.dateSelectType_sel.val()==="1")
		{
			that.dayChange();
		}
		else
		{
			that.yearChange();
		}
	},
	
	disableRadio2:function(flag)
	{
		if((!flag)&&(this.radioCheck == 1))
		{
			return ;
		}
		if(flag)
		{
			if(this.startTime_txt.val()==null||this.startTime_txt.val()==''){
		      this.startTime_txt.val(toStringByPattern(new Date(),"yyyy-MM-dd HH:mm:ss"));
		    }
		    if(this.endTime_txt.val()==null||this.endTime_txt.val()==''){
		      this.endTime_txt.val(toStringByPattern(new Date(),"yyyy-MM-dd HH:mm:ss"));
		    }
		    
			this.startTime_txt.attr("blur",function(){
		    	jQuery(this).css("border","1px solid #B5B8C8");
			});
			this.startTime_txt.attr("disabled",'disabled');
			this.endTime_txt.attr("blur",function(){
		    	jQuery(this).css("border","1px solid #B5B8C8");
		    	
			});
			this.endTime_txt.attr("disabled",'disabled');
		}
		else
		{
			this.startTime_txt.removeAttr("disabled");
			this.endTime_txt.removeAttr("disabled");
		}
	
	},
	
	
	radio2Check:function(){
		var that = this;
		that.radioCheck =2;
		$(that.radio2).attr("checked","checked");
		
		that.disableRadio1(true);
		that.disableRadio2(false);
		
		that.startTime_txt.focusout();
		that.endTime_txt.focusout();
	},
	
	initEvents : function() {
		var that = this;
		that.radio1.bind('click',function(){
			that.radio1Check();
		});
		that.radio2.bind('click',function(){
			that.radio2Check();
		});
		that.dateSelectType_sel.bind('change',function(){
			that.dateSelectTypeChange();
		});
		that.week_sel.bind('change',function(){
			that.weekChange();
		});
		that.month_sel.bind('change',function(){
			that.monthChange();
		});
		that.quarter_sel.bind('change',function(){
			that.quarterChange();
		});
		that.year_sel.bind('change',function(){
			that.yearChange();
		});
	},

	beforeShowData : function() {
		this.clear();
	},

	showData : function() {},

	afterShowData : function() {
		var that = this;
		$("#" + that.fieldId).bind("change", function(event){
			var target = event.target;
			if (target.value != ""){
				$("#" + that.descId).text(target.value).attr("title", target.value);
			}
		});
		this.checkItems();
	},
	checkItems : function() {
		this.disable(this.disabled);
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		$("#" + this.containerId).empty();
	},

	getValueWithText : function() {
	    if(!this.isTrue(this.required))
		{
			this.setTimeByText();
		}
	    return this.getSimpleValue();
	},
	getSimpleValue : function() {
		var that = this;
		var startTime = toStringByPattern(new Date(this.startTimeLong*1000),"yyyy-MM-dd HH:mm:ss");
		var endTime = toStringByPattern(new Date(this.endTimeLong*1000),"yyyy-MM-dd HH:mm:ss");
		var tx = jQuery("#dateLevel_select_id_" + this.id + ">option:selected").text();
		
		if(that.radioCheck==1)
		{
			var type = that.dateSelectType_sel.val();
			var timeVal="";
			switch (type)
			{
				case "1":
				{
					timeVal = that.dateText.val();
					break;
				}
				case "2":
				{
					timeVal = that.year_sel.val()+"-"+that.week_sel.val();
					break;
				}
				case "3":
				{
					timeVal = that.year_sel.val()+"-"+that.month_sel.val();
					break;
				}
				case "4":
				{
					timeVal = that.year_sel.val()+"-"+that.quarter_sel.val();
					break;
				}
			}
			if(this.data_hide==="false"){
			return [{value: ""+this.startTimeLong , text: startTime},{value: ""+this.endTimeLong ,text:endTime},{value:this.date_sel.val(),text:tx},{value:type,text:timeVal}];
		    }else{
		    return [{value: ""+this.startTimeLong , text: startTime},{value: ""+this.endTimeLong ,text:endTime},{value:type,text:timeVal}];
		    }
		}
		else
		{
			 if(this.data_hide==="false"){
			return [{value: ""+this.startTimeLong , text: startTime},{value: ""+this.endTimeLong ,text:endTime},{value:this.date_sel.val(),text:tx}];
		    }else{
		    return [{value: ""+this.startTimeLong , text: startTime},{value: ""+this.endTimeLong ,text:endTime}];
		    }
		}
	},

	setValue : function(v) {
		var that = this;
		if (null != v && v != undefined){
			if (v.length==4)
			{
				var type=v[3].value;
				var timeVal = v[3].text.split("-");
				
					that.year_div.hide();
					that.quarter_div.hide();
					that.month_div.hide();
					that.week_div.hide();
					that.dateText_div.hide();
				switch (type)
				{
					case "1":
					{
						timeVal = v[2].text.split("&");
						that.dateText.val(timeVal);
						that.dateSelectType_sel.val("1");
						that.dateText_div.show();
						break;
					}
					case "2":
					{
						that.dateSelectType_sel.val("2");
						that.year_sel.val(timeVal[0]);
						that.week_sel.val(timeVal[1]);
						that.year_div.show();
						that.week_div.show();
						break;
					}
					case "3":
					{
						that.dateSelectType_sel.val("3");
						that.year_sel.val(timeVal[0]);
						that.month_sel.val(timeVal[1]);
						that.year_div.show();
						that.month_div.show();
						break;
					}
					case "4":
					{
						that.dateSelectType_sel.val("4");
						that.year_sel.val(timeVal[0]);
						that.quarter_sel.val(timeVal[1]);
						that.year_div.show();
						that.quarter_div.show();
						break;
					}
				}
			}
			if (v.length==3)
			{
				that.radio2Check();
				that.startTime_txt.val(v[0].text);
				that.endTime_txt.val(v[1].text);
			}
			that.startTimeLong=getLongTimeByFmt(v[0].text);
			that.endTimeLong=getLongTimeByFmt(v[1].text);
			that.date_sel.val(v[2].value);
		}
	},
	
	disable : function(b) {
		var bn = b ? true : false;
		this.disableRadio2(b);
		this.disableRadio1(b);
		if(b)
		{
			if(this.data_hide==="false"){
			this.date_sel.attr("disabled", true);
			}else{
			
			}
		}
		else
		{
			if(this.data_hide==="false"){
			this.date_sel.removeAttr("disabled");
			}else{
			
			}
		}
		this.radio1.attr("disabled",b);
		this.radio2.attr("disabled",b);
		this.isEnable=!bn;
	},
	checkData : function() {
		var that = this;
		that.setTimeByText();
		var rstObj = 
		{
			success : true,
			msg : '',
			isRequiredFailed : false
		};
		if(this.required != undefined && this.isTrue(this.required))
		{
			if(this.getSimpleValue() == '')
			{
				rstObj.success = false;
				rstObj.msg = $RRs.comm_vail_date;
				rstObj.isRequiredFailed = true ;
				return rstObj;
			}
			if(this.radioCheck==1)
			{
				var type = that.dateSelectType_sel.val();
				var timeVal="";
				if (type=="1")   
				{
					if(!isCorrectFormat(this.dateFmt,this.dateText.val()))
					{
						rstObj.success = false;
						rstObj.msg = $RRs.comm_vail_date_format;
						return rstObj;
					}
				}
			}
			else   
			{
				if(!isCorrectFormat("yyyy-MM-dd hh:mm:ss",this.startTime_txt.val()))
				{
					rstObj.success = false;
					rstObj.msg = $RRs.comm_vail_date_format;
					return rstObj;
				}
				if(!isCorrectFormat("yyyy-MM-dd hh:mm:ss",this.endTime_txt.val()))
				{
					rstObj.success = false;
					rstObj.msg = $RRs.comm_vail_date_format;
					return rstObj;
				}
			}
			if (!this.checkStartAndEndTime()) 
			{
				rstObj.success = false;
				rstObj.msg = $RRs.comm_vail_date_error;
				return rstObj;
			}
		}
		return rstObj;
	},
	
	checkStartAndEndTime:function()
	{
		var that = this;
		if(that.startTimeLong>that.endTimeLong)
		{
			return false;
		}
		return true
	},
	
	dateSelectTypeChange:function(){
		var that = this;
		var type = that.dateSelectType_sel.val();
		switch (type)
		{
			case "1":
			{
				that.year_div.hide();
				that.quarter_div.hide();
				that.month_div.hide();
				that.week_div.hide();
				that.dateText_div.show();
				break;
			}
			case "2":
			{
				that.dateText_div.hide();
				that.quarter_div.hide();
				that.month_div.hide();
				that.year_div.show();
				that.week_div.show();
				that.weekChange();
				break;
			}
			case "3":
			{
				that.dateText_div.hide();
				that.quarter_div.hide();
				that.week_div.hide();
				that.year_div.show();
				that.month_div.show();
				that.monthChange();
				break;
			}
			case "4":
			{
				that.dateText_div.hide();
				that.month_div.hide();
				that.week_div.hide();
				that.year_div.show();
				that.quarter_div.show();
				that.quarterChange();
				break;
			}
		}
	},
	
	dayChange:function(){
		var that = this;
		var date_txt = that.dateText.val();
		that.startTimeLong = getLongTimeByFmt(date_txt);
		that.endTimeLong = that.startTimeLong+86400-1;
	},
	
	day1Change:function(){
		var that = this;
		var date_txt = that.day1.val();
		that.startTimeLong = getLongTimeByFmt(date_txt);
	},
	
	day2Change:function(){
		var that = this;
		var date_txt = that.day2.val();
		that.endTimeLong =  getLongTimeByFmt(date_txt);
	},
	
	weekChange:function(){
		var that = this;
		var yearVal = new Number(that.year_sel.val());
		var weekVal = that.week_sel.val();
		var date = new Date(yearVal,0,1,0,0,0);
		var weekOfYear = getWeekOfYear(date);
		var dayOfWeek = date.getDay();
		if(1!=weekOfYear)
		{
			date = new Date(yearVal,0,(8-dayOfWeek));
		}
		else
		{
			date = new Date(date.getTime() - 86400000 * dayOfWeek);
		}
		var secondsOfWeek = 604800;
		that.startTimeLong = date.getTime()/1000 + (weekVal-1)*secondsOfWeek;
		that.endTimeLong = that.startTimeLong + (secondsOfWeek-1);
	},
	
	monthChange:function(){
		var that = this;
		var yearVal = new Number(that.year_sel.val());
		var monthVal = that.month_sel.val();
		that.startTimeLong = new Date(yearVal,monthVal-1,1,0,0,0).getTime()/1000;
		that.endTimeLong = new Date(monthVal==12?1+yearVal:yearVal,monthVal==12?0:monthVal).getTime()/1000-1;
	},
	
	quarterChange:function(){
		var that = this;
		var yearVal = new Number(that.year_sel.val());
		var quarterVal = that.quarter_sel.val();
		var startMonth = (quarterVal-1)*3;
		var endMonth = quarterVal*3;
		that.startTimeLong = new Date(yearVal,startMonth,1,0,0,0).getTime()/1000;
		that.endTimeLong = new Date(endMonth==12?1+yearVal:yearVal,endMonth==12?0:endMonth).getTime()/1000-1;
	},
	
	yearChange:function(){
	    var that = this;
		var type = that.dateSelectType_sel.val();
		switch (type)
		{
			case "2":
			{
				that.weekChange();
				break;
			}
			case "3":
			{
				that.monthChange();
				break;
			}
			case "4":
			{
				that.quarterChange();
				break;
			}
		}
	},
	
	initYears:function(){
		if(this.minDate===undefined || new Number(this.minDate)<Date_const.minDate)
		{
			this.minDate = Date_const.minDate;
		}
		if(this.maxDate===undefined || new Number(this.maxDate)<Date_const.maxDate)
		{
			this.maxDate = Date_const.maxDate;
		}
		minDate = new Number(this.minDate);
		maxDate = new Number(this.maxDate);
		var lengths = maxDate-minDate+1;
		var date_year = new Array(lengths);
		for(var i=0;i<lengths;i++)
		{
			var temp_Array = new Array(2);
			temp_Array[0] = minDate+i+'';
			temp_Array[1] = minDate+i+'';
			date_year[i] = temp_Array;
		}
		return date_year;
	},
	
	initQuarter:function(){
		switch(this.date.getMonth())
		{
			case 0 :
			case 1 :
			case 2 :
			{
				return '1';
				break;
			}
			case 3 :
			case 4 :
			case 5 :
			{
				return '2';
				break;
			}
			case 6 :
			case 7 :
			case 8 :
			{
				return '3';
				break;
			}
			case 9 :
			case 10 :
			case 11 :
			{
				return '4';
				break;
			}
		}
	},
	
	initMonth:function(){
		return (this.date.getMonth()+1)+'';
	},
	
	initWeek:function(){
	    var week = getWeekOfYear(this.date);
		if(week>52)
		{
			return 52;
		}
		else
		{
			return ''+week;
		}
	},
	setTimeByText:function()
	{
		if(this.radioCheck==1)
		{
			var type = this.dateSelectType_sel.val();
			if(type == 1)
			{
				this.dayChange();
			}
		}
		else
		{
			this.startTimeLong = getLongTimeByFmt(this.startTime_txt.val());
			this.endTimeLong = getLongTimeByFmt(this.endTime_txt.val());
		}
	}
})));
};

