ConditionMgr.functions["combobox"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
    	this.prefix = "x-combo-list-inner-";
        this.labelContainerId = this.id + "_label";
        this.containerId = this.id + "_container";
        this.cmbObj = null;
        this._keyF = ((this.valueField == 'key') || (this.valueField == 'value')) ? this.valueField : "key";
        this._valueF = ((this.displayField == 'key')||(this.displayField == 'value')) ? this.displayField : "value";
        this.initV;
        this.containerHelpId = this.id + "_help";       
        this.descId = "lbl_" + this.id;
        this.autoLoad = this.isTrue(this.autoLoad);
        this._labelDescText();
        this.containerComboListId = this.prefix + this.id + "_container" ;
        this.listId = "x-combo-list-" + this.containerId;
    },
    isLoaded : function(){
        return true;
    },
    initDoms : function(){
    	$("#"+this.containerId).css("height","26px"); 
        this.clear();
        this._initRequest();
    },
	_initRequest:function()
	{
		var strItems = this.data;
		itemsData=[];
		if(!this.autoLoad)
	  	{
			if(typeof strItems!="undefined"&&strItems)
			{
			  strItems = strItems.substring(1,strItems.length-1);
			  var items=strItems.split(",");
				if(items.length%2==0)
				{
						for (var index=0,len=items.length,i=0;index<len;index=index+2,i++)   
						{
							itemsData[i]={};
							itemsData[i].key=items[index];    
							itemsData[i].value=items[index+1];
						}		
				}
				
				this._initData(itemsData);
			}

		}
	},
    fillComboData: function(combData){
       if( combData == null)
       {
       		_log("info","combData param is null");
       		return
       }
        for (var i = 0; i < combData.length; i++){
        	
            LegoTag.addCombItem(this.containerId,combData[i].key,combData[i].value); 
        }
        var _h = 21 * (combData.length);
		if(_h > 210)
		{
			_h = 210;	
		}
		if($.browser.msie && combData.length >0)
		{
		jQuery('#x-combo-list-' + this.containerId).css('height', _h); 
	    jQuery('#x-combo-list-inner-'+ this.containerId).css('height', _h);
		}
		else
		{
		}
    },
    getDataTextByKey : function(data,key){
        if (data){
            for (var i = 0; i < data.length; i++){
                if (data[i][this._keyF] == key){
                    return data[i][this._valueF];
                }
            }
        }
        return "";
    },
    
     _useTitleShow : function(that){
    	var div = document.getElementById(that.containerComboListId) ;
    	var children = div.children ;
    	var selectChild ;
    	if(null != children){
    		for(var i = 0 ; i < children.length ; i ++){
    		if(jQuery(children[i]).hasClass("x-combo-selected")){
    			selectChild = children[i] ;
    			LegoTag.setCombDisplay(that.containerId , selectChild.title) ;
    			break ;
    		}
    	  }
    	}
    } ,
    
    _initEvents : function(){
        var that = this;   	
    	this._beforeValue = LegoTag.getCombValue(this.containerId);   	
    	var div = jQuery("#" + this.prefix + this.containerId);
    	div.bind("click", function(event){
    		var t = event.target;
    		var _curValue = LegoTag.getCombValue(that.containerId);
    		that.publishEvent("onValueChange");
    		that._beforeValue = _curValue;		
			that._useTitleShow(that);
			var list = document.getElementById("x-combo-list-" + that.containerId);
			list.style.visibility = "hidden";

    	}); 
    	var input = jQuery("#"+this.containerId);
    	input.bind("keydown", function(event){
    		var t = event.target;
    		var _curValue = LegoTag.getCombValue(that.containerId);
    		that.publishEvent("onValueChange");
    		that._beforeValue = _curValue;
    		that._useTitleShow(that) ;
    	});    	 	
    },
    _initData :function(combData)
    {
    	var that = this;
	        if (combData.length != 0)
	        {
	            that.fillComboData(combData);
	            var type=typeof that.defaultValue ;
	            var isEmpty = that.defaultValue==undefined || that.defaultValue=="undefined" || that.defaultValue==null || that.defaultValue =="null" || that.defaultValue =="";
	            if (!isEmpty){
	                this.initV = that.getDataTextByKey(combData,that.defaultValue);
	                this.initK = that.defaultValue;
		        }else{
		            if (that.blankOption){
		               this.initV = that.blankOption;
		               this.initK = that.blankOption;
		            }else{
		               this.initV = combData[0].value;
		               this.initK = combData[0].key;
		            }
		        } 
	        }else{
	            this.initV = "";
		        this.initK = "";
	        }
	        this._initEvents();
    },
    _init : function(_data){
        var that = this;
        if (_data){
            that.resultData.data = _data;
        }
        
        if (that.blankOption) {
            var obj = {};
            obj[that._keyF] = "";
            obj[that._valueF] = that.blankOption;
            that.resultData.data.unshift(obj);
        }

        var combData = this.resultData.data;
        this._initData(combData);
    },
    _labelDescText : function(_data){
            var that = this;
	        var descLabel = jQuery("<label/>").attr({
	                id : that.descId
	            });
	        $("#" + this.containerHelpId).append(descLabel);
			var desc = that.desc;	 
	        if(that.desc){
	        	if(that.required == 'true'){
	        		descLabel.text(desc).attr('title',that.desc).css('padding-left','13px');
	        	} else {
	        		descLabel.text(desc).attr('title',that.desc).css('padding-left','5px');
	        	}
	        }
	},      
    changeOptions : function(data){
        this.clear();
        this.fillComboData(data);
        this.initV = data[0].value;
        this.initK = data[0].key;
        this.checkItems();
        this.publishEvent("onValueChange");
        this._beforeValue = LegoTag.getCombValue(this.containerId);
    },
    showData : function() {
        this.clear();
        this._init();
    },
    checkItems : function(){
        var that = this;
        this.setEditable(this.isTrue(this.editable));
        this.disable(this.isTrue(this.disabled));
        this.selectOption(this.initV,this.initK);
    },
    afterShowData : function() {
        this.checkItems();
        this.publishEvent("onValueChange");
        this._beforeValue = LegoTag.getCombValue(this.containerId);
    },
    setEditable : function(b) {
        jQuery("#" + this.containerId).attr('readonly',!b);
    },
    getValueWithText : function() {
        var tv = LegoTag.getCombDisplay(this.containerId);
        var hv = LegoTag.getCombValue(this.containerId);
        if (tv != this.blankOption) {
            hv = hv == '' ? tv : hv;
        }
        return {
            value : hv,
            text : tv
        };
    },

    clear : function() {
        jQuery("#x-combo-list-inner-" + this.containerId).empty();
        jQuery("#x-combo-list-inner-" + this.containerId).css("height","0px");
        jQuery("#x-combo-list-" + this.containerId).css("height","0px");
    },
    reset : function() {
        this.selectOption(this.initV,this.initK);
        this.checkItems();
        this.publishEvent("onValueChange");
        this._beforeValue = LegoTag.getCombValue(this.containerId);
    },
    getSimpleValue : function() {
        var tv = LegoTag.getCombDisplay(this.containerId);
        var hv = LegoTag.getCombValue(this.containerId);
        if (tv != this.blankOption) {
            hv = hv == '' ? tv : hv;
        }

        return hv;
    },
    setValue : function(obj) {
        this.selectOption(obj["text"],obj["value"]);
    },
    selectOption : function(text,key) {
        LegoTag.setCombValue(this.containerId,key,text);
        LegoTag.setCombDisplay(this.containerId,text);
    },
    disable : function(b) {
        LegoTag.setDisabled(this.containerId, b);
        this.isEnable=!b;
    },
    checkData : function() {
        var resObj = {
            success : true,
            msg : '' ,
            isRequiredFailed : false
        };
        var v = this.getSimpleValue();
        var test = this.getValueWithText();
        if (((this.isTrue(this.required) && (v == ''
                        || v == this.blankOption)))) {
            resObj.success = false;
            resObj.msg = this.blankValidateText;
            resObj.isRequiredFailed = true ;
        }
        return resObj;
    }
})));
};