ConditionMgr.functions["dateRange"] = function(configParams){
ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
	initProperties : function() {
		this.fieldId = "txt_" + this.id;						
		this.fieldName = this.id + "_n";						
		this.containerId = this.id + "_container";				
		this.descId = "lbl_" + this.id;  
		this.dateConfig = getDateConfig(this); 
		this.startTimeId = this.id+"_startTimeId";
		this.endTimeId = this.id+"_endTimeId";
		this.startTimeLong = 0;
		this.endTimeLong = 0;
		if(this.dateConfig === "")
		{
			this.dateConfig = "dateFmt:'"+Date_const.defaultDateFmt+"'";
			this.dateFmt = Date_const.defaultDateFmt;
		}
		
		this.containerHelpId = this.id + "_help";				
		this.descId = "lbl_" + this.id;
	},

	initDoms : function() {
		this.container = jQuery("#" + this.containerId);
		var that = this;
		that.startTime_txt = jQuery("#"+this.startTimeId);
		that.endTime_txt = jQuery("#"+this.endTimeId);
		
		that.startTimeLong = getLongTimeByFmt(that.startTime_txt.val());
		var startTimeStr = toStringByPattern(new Date(),"yyyy-MM-dd")+" 00:00:00";
		var endTimeStr = toStringByPattern(new Date(),"yyyy-MM-dd")+" 23:59:59";
		that.startTime_txt.val(startTimeStr.substr(0,that.dateFmt.length));
		
		that.endTime_txt.val(endTimeStr.substr(0,that.dateFmt.length));
		that.startTimeLong = getLongTimeByFmt(that.startTime_txt.val());
		
		var descLabel = jQuery("<label/>").attr({
				id : this.descId
			});
		$("#"+this.containerHelpId).append(descLabel);
		
		if (this.desc){
		   if(that.required == 'true'){
			descLabel.text(that.desc).css("padding-left","8px");
		   }else{
		    descLabel.text(that.desc);
		   }	
		}
		
	},
    getCheckParam : function(){
        var that = this;
        return {
            startTimeLong : that.startTimeLong,
            endTimeLong : that.endTimeLong
        };
    },

	initEvents : function() {
	},
	
	beforeShowData : function() {
		this.clear();
	},

	showData : function() {
	},

	afterShowData : function() {
		var that = this;
		jQuery("#" + that.fieldId).bind("change", function(event){
			var target = event.target;
			if (target.value !== ""){
				jQuery("#" + that.descId).text(target.value).attr("title", target.value);
			}
		});
		this.checkItems();
	},
	checkItems : function() {
		this.disable(this.disabled);
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		jQuery("#" + this.containerId).empty();
	},

	getValueWithText : function() {
		return this.getSimpleValue();
	},
	getSimpleValue : function() {
			this.setTimeByText();  
		var startTime = toStringByPattern(new Date(this.startTimeLong*1000), "yyyy-MM-dd HH:mm:ss");
		var endTime = toStringByPattern(new Date(this.endTimeLong*1000), "yyyy-MM-dd HH:mm:ss");
		var endTimeSec = this.endTimeLong+1*60*60*23+59*60+59;
		if(this.dateFmt.length == 10)
		{
			return [{value: ""+this.startTimeLong, text: startTime.split(" ")[0]}, {value: ""+endTimeSec, text:endTime.split(" ")[0]}];
		}
		else
		{
			return [{value: ""+this.startTimeLong, text: startTime}, {value: ""+this.endTimeLong, text:endTime}];
		}
	},

	setValue : function(v) {
		if (null != v && v != undefined){
			this.startTimeLong=getLongTimeByFmt(v[0].text);
			this.endTimeLong=getLongTimeByFmt(v[1].text);
			this.startTime_txt.val(v[0].text);
			this.endTime_txt.val(v[1].text);
		}
	},
	disable : function(b) {
		var bn = (b === 'true') ? true : false;
		if(bn)
		{
			LegoTag.setDisableds( [this.startTimeId], true);
			LegoTag.setDisableds( [this.endTimeId], true);
		}
		else
		{
			LegoTag.setDisableds( [this.startTimeId], false);
			LegoTag.setDisableds( [this.endTimeId], false);
		}
		this.isEnable=!bn;
	},
	validateStartDate: function (){
    var elDateTime=document.getElementById(this.startTimeId);
  	var dateVal = $.trim(elDateTime.value);
  	var dateFormat = LegoTag.getDateFormat(Ext.get(elDateTime));
    var retDate = Date.parseDate(dateVal, dateFormat);
    
    if(retDate && retDate.format(dateFormat)!=dateVal)
    {
    	return false;
    }
    if(retDate)
    {
    	return true;
    }
    return false;
  },
 validateEndDate: function (){
    var elDateTime=document.getElementById(this.endTimeId);
  	var dateVal = elDateTime.value;
  	var dateFormat = LegoTag.getDateFormat(Ext.get(elDateTime));
  	
    var retDate = Date.parseDate(dateVal, dateFormat);
    if(retDate && retDate.format(dateFormat)!=dateVal)
    {
    	return false;
    }
    if(retDate)
    {
    	return true;
    }
    return false;
  },
	checkData : function() {
	    this.setTimeByText();
		var rstObj = {
			success : true,
			msg : '' ,
			isRequiredFailed : false
		};
		if(this.validateStartDate()!==true)
		{
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
			return rstObj;
		}
		if(this.validateEndDate()!==true)
		{
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
			return rstObj;
		}
		
		if (this.isTrue(this.required) && (this.startTime_txt.val()==''|| this.endTime_txt.val()=='')) {
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date;
			rstObj.isRequiredFailed = true ;
		}else if(!isCorrectFormat(this.dateFmt,this.endTime_txt.val())){
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
		}else if(!isCorrectFormat(this.dateFmt,this.startTime_txt.val())){
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
		}else if (!this.checkStartAndEndTime()) {
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_error;
		}
		return rstObj;
	},
	setTimeByText:function()
	{ 
		this.startTimeLong = getLongTimeByFmt(this.startTime_txt.val());
		this.endTimeLong = getLongTimeByFmt(this.endTime_txt.val());
	},
	
	checkStartAndEndTime:function()
	{
		var that = this;
		if(that.startTimeLong>that.endTimeLong)
		{
			return false;
		}
		return true;
	}
})));
};