ConditionMgr.functions["ipAddress"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
	initProperties : function() {
	    this.ipAddress = new Component.IPAddress(this);
	    this.initialized=false;
	},
 	onInitComplete:function()
    {
    	this.initialized=true;
    },
	initDoms : function() {
		this.ipAddress.create(configParams);
	},
	beforeShowData : function() {
		this.ipAddress.clear();
	},
	showData : function() {
	},
	afterShowData : function() {
		var that = this;
		this.checkItems();
	},
	checkItems : function() {
		if (this.disabled=="true"||this.disabled==true){
			this.disable(this.isTrue(this.disabled));
		}
	},
	beforeInitComplete : function() {
		this.checkItems();
	},
	clear : function() {
		this.ipAddress.clear();
	},
	reset : function(){
		this.ipAddress.reset();
	},
	getValueWithText : function() {
	   return this.ipAddress.getValues();
	},
	getSimpleValue : function() {
	  return this.ipAddress.getValue();
	},
	setValue : function(values) {
	    this.ipAddress.setValue(values);
	    this.triggerChange();
	},
	triggerChange : function()
	{
		if(this.initialized)
		{
			$(this).trigger("onValueChange", this);
		}
	},
	removeOther : function(){
	 	this.ipAddress.removeOthers();
	},
	disable : function(bn) {
		this.ipAddress.disable(bn);
	},
	checkData : function() {
	    return this.ipAddress.validate();
	}
})));
};

  Component.IPAddress=function(_owner)
  {
  	if(_owner){
  		this.parent=_owner;
  	}else
  	{
  		this.parent=null;
  	}
  	this._init();
  };
  
  Component.IPAddress.prototype.log= function () {
		if (this.debug && window.console && window.console.log)
		{
			if(typeof console.log.apply !=undefined)
			{
				console.log.apply('', arguments);
			}
		}
   }
  Component.IPAddress.prototype._init=function()
  {
    this.CanJump=true;
  	this.debug=false;
  	this.id="";
  	this.name="";
  	this.key="";
    this.label="";
  	this.blankValidateText="";
    this.disabled=false;
   	this.required=false;
   	this.maxNum=5;
   	this.add=false;
   	this.hasPort=false;
   	this.ipCount=1;
   	this.container=null;
   	this.fieldName="";
   	this.addLinkId = "";
   	this.labelContainerId= "";
   	this.containerId= "";
   	this.style={};
   	this.MAX_INDEX=1;
   	this.log("ipAddress._init");
  }
  Component.IPAddress.prototype.init=function(configs)
  {
  	this.id=configs.id;
  	this.name=configs.name;
  	this.key=configs.key;
    this.label=configs.label;
  	this.blankValidateText=configs.blankValidateText;
    this.disabled=(configs.disabled=="true"||configs.disabled==true) ? true:false;
   	this.required= (configs.required=="true"||configs.required==true) ? true:false;
   	this.maxNum=parseInt(configs.maxNum);
   	this.add=false;
   	this.hasPort= (configs.hasPort=="true"||configs.hasPort==true)?true:false;
   	this.width="320px";
   	this.height="75px";
   	this.container = this.id + "_container";
   	$("#"+this.container).css("width",this.width);
   	this.addLinkId = this.id+"_add_link";
   	this.labelContainerId=this.id+"_label";
   	this.containerId=this.container;
   	
   	this.fieldName = this.id;
   	this.tableId = this.id+"_condition_wrap";
   	this.log("ipAddress.init");
  }
  
  
  Component.IPAddress.prototype.loadData=function(type)
  {
  	
  }
  
  Component.IPAddress.prototype.create=function()
  {
    
  	var configs = arguments[0];
  	this.init(configs);
  	if(configs!==null)
  	{
  		this.appendixCreate();
  	}
  	if(this.disabled)
  	{
  		this.disable(this.disabled);
  	}	
  	this.bindIpEvents();
  	this.log("ipAddress.create");
  }
  
  Component.IPAddress.prototype.prepareTestData=function()
  {
  return;
  	var values=new Array();
    var obj={};
	
	obj.value="192.168.0.1:8081";
	obj.text="192.168.0.1:8081";
	
	values.push(obj);
	var obj2={}
	
	obj2.value="192.168.0.18:8083";
	obj2.text="192.168.0.18:8083";
	
	values.push(obj2);
	var obj3={};
	
	obj3.value="192.168.0.128:8084";
	obj3.text="192.168.0.128:8084";
	
	values.push(obj3);
	this.setValue(values);
	this.log(this.getValues()[0].value);
	this.log(this.getValues()[0].text);
	this.log(this.validate());
	this.disabled=false;
	this.log("ipAddress.prepareTestData");
  }
  
   
   
  Component.IPAddress.prototype.appendixCreate=function()
  {
     var legoContainerId = "#"+this.id;
	  if(this.hasPort)
	  {
	    var portId = this.id + "_port";
	    var strObj = new StringBuffer();
	   	strObj.append("<div class='ireport-ui-text-ip-panel'>");
		strObj.append("   &nbsp;:");
		strObj.append("  <input type='text' id='"+ portId +"' class='ireport-ui-text-ip-port' value='' maxlength='5' />");
		strObj.append("  <span style='vertical-align: middle'>[1-65535]</span>");
		strObj.append("</div>"); 
		
		var wrapId = this.id+"_wrap";
		$("#"+wrapId).append($(strObj.toString()));	
		this.bindPortEvent(portId);
	   }
	  
	   if(this.required)
	   {
	   	 var strObj = new StringBuffer();
		 strObj.append("<div class='rendar-star rendar-star-combo' style='padding-top:4px'>&nbsp;*</div>");
	   	 var wrapId = this.id+"_wrap";
		 $("#"+wrapId).append($(strObj.toString()));	
	   }
	  var v=this.add;
	  if (v === "true" || v === true){
	  	var _addLink = $("#" + this.addLinkId);
	  	_addLink.show();
	   _addLink.bind("click",{target:this}, this.addEvent);
		}
		$("#"+this.id+"_ul_ip").mouseover(function(){
	      $(this).addClass('ireport-ui-text-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-text-mouseover'); 
	    }); 
		
	}
	
	
	Component.IPAddress.prototype.getFieldIndex = function(obj) {
		var objId = obj.id;
		var len = objId.length;
		return objId.charAt(len - 1);
	}
	
	Component.IPAddress.prototype.getNextField = function(obj) {
		var id=obj.id;
		var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
		var index = this.getFieldIndex(obj);
		
		var nextField = null;
	
		if (index == 1) {
			nextField = document.getElementById(idPrefix + 2);
		} else if (index == 2) {
			nextField = document.getElementById(idPrefix + 3);
		} else if (index == 3){
			nextField = document.getElementById(idPrefix + 4);
		}else if (index == 4){
		    if(this.hasPort)
		    {
				
				nextField = document.getElementById(idPrefix + "port");
			}else
			{
				nextField = document.getElementById(idPrefix + 4);
			}
		}
		return nextField;
	}
	Component.IPAddress.prototype.getPrevField = function(index,obj) {
		var id=obj.id;
		var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
		var retField = null;
		if (index == 1) {
			retField = obj;
		} else if (index == 2) {
			retField = document.getElementById(idPrefix + 1);
		} else if (index == 3){
			retField = document.getElementById(idPrefix + 2);
		}else if (index == 4){
			retField = document.getElementById(idPrefix + 3);
		}
		return retField;
	}
	Component.IPAddress.doPortKeyDown = function(event) {
		
		var self = event.data.self;
		var srcObj = event.target;
		var keyCode = event.keyCode;
		switch(keyCode)
		{
			case 190:
			case 110:
			break;
			case 39:
				break;
			case 40:
			break;
			case 37:
			{
			}
				break;
			case 38:
			break;
			case 8: 
			{
				
				var curPos = getCaret(srcObj);
				if (curPos == 0) {
					var id=srcObj.id;
					var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
					var field = document.getElementById(idPrefix + 4);					
					setCaret(field, 'end');
					self.CanJump=false;
					return event.returnValue = false;
				}
			}				

			break;
			case 13:
			break;
			case 9:
			break;
			default:
			return event.returnValue = true;
			
			
		}
	}
	Component.IPAddress.doKeyDown = function(event) {
		var self = event.data.self;
		var srcObj = event.target;
		var keyCode = event.keyCode;
		var index = event.data.index;
		switch(keyCode)
		{
			case 190:
			case 110:
			{
				var curPos = getCaret(srcObj);
				if (curPos == srcObj.value.length&& srcObj.value != "") {
					var field = self.getNextField(srcObj);
					setCaret(field, 'end');
					self.CanJump=false;
					return event.returnValue = false;
				}
			}
			break;
			case 39:
			{
			}
				break;
			case 40:
			break;
			case 37:
			{
			}
				break;
			case 38:
			break;
			case 8: 
			{
				var curPos = getCaret(srcObj);
				if (curPos == 0) {
					var field = self.getPrevField(index,srcObj);
					setCaret(field, 'end');
					self.CanJump=false;
					return event.returnValue = false;
				}
			}				

			break;
			case 13:
			break;
			case 9:
			break;
			default:
			return event.returnValue = true;
			
			
		}
	}
	Component.IPAddress.doKeyUpPaste = function(event) {
	    var self = event.data.self;
	    var goJump = event.data.jump;
		var _expr = event.data.expr; 
		var value = $(this).val();
		var val = parseInt($(this).val());
		var index = event.data.index;
		var keyCode = event.keyCode;
		if (event.data.expr.test(value)) {
			$(this).val(this.value.replace(_expr, ""));
		}
		if(!isNaN(val))
		{
			if(val<0)
			{
				$(this).val("");
			}else
			{
				$(this).val(val);
			}
			_log("debug",$(this).val());
		}else
		{
			$(this).val("");
		}
				if(index==1)
				{
					if(val>223)
					{
						$(this).val(223);
			        	$(this).focus();
					}
					if(val==127)
					{
						$(this).select();
					}
					if(val==0)
					{
						$(this).val("");
					}
					
					var curPos = getCaret(this);
					if (curPos == value.length) {
					}
					if(self.CanJump&&val>=100&&val!=127)
					{
					
						var nextField = self.getNextField(this);
						if(null != nextField){
							nextField.select();
						}
					}
					
				}else
				{
					if(val>255)
					{
						$(this).val(255);
			        	$(this).focus();
					}
					if(val==0)
					{
						$(this).val("0");
					}
					
					if(self.CanJump&&val>=100)
					{
						var nextField = self.getNextField(this);
						if(null != nextField){
							nextField.select();
						}
					}
				}
			self.CanJump=true;	
	}
	Component.IPAddress.doBlur = function(event)
	{
		var self = event.data.self;
		var _expr = event.data.expr;
		var value = $(this).val();
		var val = parseInt($(this).val());
		var index = event.data.index;
		var keyCode = event.keyCode;
		if (_expr.test(value)) {
			$(this).val(this.value.replace(_expr, ""));
		}
		
		if(!isNaN(val))
		{
			if(val<0)
			{
				$(this).val("");
			}else
			{
				if(index==1&val==0)
			    {
			    	$(this).val("");
			    }else{
				$(this).val(val);
				}
			}
		}else
		{
			$(this).val("");
		}
		var val = self.getValue();
		if(val!=null)
		{
			if(null!=self.parent)
			{
				self.parent.triggerChange();
			}
		}
	
	}
	Component.IPAddress.prototype.bindIpEvents=function(IPAddressId)
	{
	   $("#"+IPAddressId+"_ul_ip").mouseover(function(){
	      $(this).addClass('ireport-ui-ctrl-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-ctrl-mouseover'); 
	    }); 
		   
	    var self = this;
		IPAddressId=(IPAddressId === null||IPAddressId === undefined)?this.id:IPAddressId
		for(var i=1,len=4;i<=len;i++)
		{
			var ip = IPAddressId+"_"+i;
			var jip="#"+ip;		
			var index = i;
			var _expr = /\D/g;
			$(jip).bind("keyup paste",{self:this,expr:_expr,index:index,jump:self.CanJump}, Component.IPAddress.doKeyUpPaste);
			$(jip).bind("keydown",{self:this,expr:_expr,index:index}, Component.IPAddress.doKeyDown);	
			$(jip).bind("blur",{self:this,expr:_expr,index:index}, Component.IPAddress.doBlur);
		}
		
		this.log("ipAddress.bindIpEvents");
	}
		
	Component.IPAddress.prototype.bindPortEvent=function(portId)
	{
		var _expr = /\D/g;
		var jPortId = "#"+portId;
		$(jPortId).bind("keyup paste",{expr:_expr, max:65535, min:1}, function(event) {
						if (event.data.expr.test(this.value)) {
							this.value = this.value.replace(_expr, "");
						}
						
						var val = parseInt($(this).val());
						if(!isNaN(val))
						{
							if(val<0)
							{
								$(this).val("");
							}else
							{
								$(this).val(val);
							}
						}else
						{
							$(this).val("");
						}
						
						if (this.value>event.data.max){
							this.value = event.data.max;
						}
						if (this.value != '' && this.value < event.data.min){
							this.value = event.data.min;
						}
					});
					
			$(jPortId).mouseover(function(){
		      $(this).addClass('ireport-ui-ctrl-mouseover'); 
		    }).mouseout(function(){ 
		      $(this).removeClass('ireport-ui-ctrl-mouseover'); 
		    });
		  $(jPortId).bind("keydown",{self:this}, Component.IPAddress.doPortKeyDown);
		  $(jPortId).bind("blur",{self:this,expr:_expr}, Component.IPAddress.doBlur);   					
	}
	Component.IPAddress.prototype.createIPAddress=function()
	{
		var str="<td class='ireport-ui-control-title'>&nbsp;</td><td class='ireport-ui-control-content'>"+ this.createIPAddressString() +"</td>";
		var strTR ="<tr nowrap='true'>"+str+"</tr>";	
		var tr = $(strTR);	
				
		tr.appendTo($("#"+this.tableId));
		
		this.ipCount++;
		this.MAX_INDEX++;
		var self =this;
		var newId=this.id+this.MAX_INDEX;
		var delButton = "#" + newId+"_del";
		var portPanel = "#" + newId+"_PanelAppendix";
		var fieldPort = newId+"_port";
		this.bindIpEvents(newId);
		$(delButton).bind("click",function()
		{
				if (tr.index() > 0){
					tr.remove();
					self.ipCount--;
				}
				self.log("ipAddressMask.delButton.EVT.click");
		});

		this.bindPortEvent(fieldPort);	
		this.log("ipAddress.createIPAddress");
		
	}
	
	Component.IPAddress.prototype.createIPAddressString = function()
	{
	   var strObj = new StringBuffer();
	   var curIndex=(this.MAX_INDEX+1);
	   var newId = this.id+curIndex;
	   var ulIPId=newId+"_ul_ip";
	   var field1 = newId+"_1";
	   var field2 = newId+"_2";
	   var field3 = newId+"_3";
	   var field4 = newId+"_4";
	  
	   var fieldPort = newId+"_port";
	   var hiddenField = newId+"-hidden";
	   var container=newId+"_container";
	   var delButton = newId+"_del";
	   var portPanel= newId + "_PanelAppendix";
	    strObj.append("<div class='ireport-ui-text-ip-wrap'>");
		strObj.append("					  <div class='ireport-ui-text-ip-panel'>");
		strObj.append("						<ul class='ireport-ui-text-ip' id='"+ulIPId+"'>");
		strObj.append("							<li class='ireport-ui-text-ip-field'>");
		strObj.append("									<input type='text' id='"+field1+"' class='ireport-ui-text-ip-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-field'>");
		strObj.append("								<input type='text' id='"+field2+"' class='ireport-ui-text-ip-input' maxlength='3' />");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-field'>");
		strObj.append("								<input type='text' id='"+field3+"' class='ireport-ui-text-ip-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-field'>");
		strObj.append("								<input type='text' id='"+field4+"' class='ireport-ui-text-ip-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("						</ul>");
		strObj.append("						</div>");

		if(this.hasPort)
		{
			strObj.append("						<div class='ireport-ui-text-ip-panel'>");
			strObj.append("						    	&nbsp;:");
			strObj.append("							    <input type='text' id='"+fieldPort+"' class='ireport-ui-text-ip-port' value='' maxlength='5'/>");
			strObj.append("							    <span style='vertical-align:middle'>[1-65535]</span>");		
			strObj.append("						</div>");
		}
		strObj.append("						<div class='ireport-ui-text-ip-panel'>");
		strObj.append("        <a title=\"删除\" style=\"cursor: pointer;\" id=\""+delButton+"\"><img style='vertical-align:middle' height='16' width='16' src='"+Component._PATH_+"images/delete.png'/>");
  	    strObj.append("						</div>");
		
		strObj.append("					</div>");
		return strObj;
	}
    Component.IPAddress.prototype.addEvent=function(event)
    {
    	var that = event.data.target;
	   	try {
		   	var tbl = $("#" + that.tableId);
		   	
			var i = tbl.find(">tbody>tr").size();
			if (that.maxNum && !isNaN(that.maxNum) && (i + 1) > that.maxNum){
				alert($RRs.ip_alert_before+" "+ that.maxNum +" "+$RRs.ip_alert_after);
				return false;
			}
			
			that.createIPAddress();		
		 }
		 catch(e) {
		   alert("IPAddress create failed: " + e);
		 }
		 finally {
		   that.log("ipAddressMask.addEvent");
		 }   	   	
    }
    Component.IPAddress.prototype.isFullIP=function(fields)
    {
      var self = this;
      var isCorrect=true;
    	$.each(fields, function(j, field){
    		if($.trim($(field).val())=="")
    		{
    			isCorrect= false;
    		}
    	});
    	return isCorrect;
    }
	Component.IPAddress.prototype.getValue=function()
	{
	    var self =this;
		var retVals=new Array(this.ipCount);
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
		$.each(rows, function(j, _row){
		     var inputList = $(_row).find(":input");
		     self.log(inputList);
		     var retVal=self.isFullIP(inputList);
		     self.log(retVal);
		     if(retVal)
		     {
		     	retVals[j]=$.trim(inputList[0].value)+"."+$.trim(inputList[1].value)+"."+$.trim(inputList[2].value)+"."+$.trim(inputList[3].value);
			    if(inputList.length==5)
			    {
			     	retVals[j]+=":"+$.trim(inputList[4].value);
			    }
		     }
		});
		return retVals;
	}
	
	
    Component.IPAddress.prototype.focusIPField=function(fields)
    {
      this.log("focusIPField");
      var self = this;
      var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
	  for(var j=0,jlen=rows.length;j<jlen;j++){
	      var _row=rows[j];
	      var bContinue=true;
		  var fields = $(_row).find(":input");
		  var field =null;
	      for(var i=0,len=fields.length;i<len;i++)
	      {
	      	  field = fields[i];
	      	  if($.trim($(field).val())=="")
		   	  {
		   			field.focus();
		   			bContinue=false;
		   			break;
		   	  }
	      }
	      if(!bContinue)break;
		}
		
    }
   
    Component.IPAddress.prototype.unrequiredValidate=function(fields)
    {
      this.log("unrequiredValidate");
      var self = this;
      var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
	  for(var j=0,jlen=rows.length;j<jlen;j++){
	      var _row=rows[j];
	      var bShowInfo=false;
		  var fields = $(_row).find(":input");
		  var field =null;
		  var validCnt=0;
	      for(var i=0,len=fields.length;i<len;i++)
	      {
	      	  field = fields[i];
	      	  if($.trim($(field).val())!="")
		   	  {
		   			validCnt++;
		   	  }
	      }
	      if(this.hasPort)
	      {
		      if(validCnt!=0&&validCnt!=5)
		      {
		      	return false;
		      }
	      }else
	      {
	      	  if(validCnt!=0&&validCnt!=4)
		      {
		      	return false;
		      }
	      }
		}
		return true;
    }
 
  Component.IPAddress.prototype.validate=function()
  {
    this.log("IPAddress.validate");
  	var retVal = {
			success : true,
			msg : '',
			isRequiredFailed : false
		};
	var v = this.getValues();
	if(this.required)
	{
		if(!this.unrequiredValidate())
		{
			retVal.success = false;
			retVal.msg = $RRs.ip_alert_invalid;
			this.focusIPField();
			return retVal;
		}
		if(v.length ==0 || v.length!=this.ipCount)
		{
			retVal.success = false;
			retVal.msg = this.blankValidateText;
			retVal.isRequiredFailed = true ;
			this.focusIPField();
			return retVal;
		}
	}else
	{
		if(!this.unrequiredValidate())
		{
			retVal.success = false;
			retVal.msg = $RRs.ip_alert_invalid;
			this.focusIPField();
			return retVal;
		}
	}
  	return retVal;
  }
	
	Component.IPAddress.prototype.getValues=function()
	{
	 	this.log("getValues:");
	 	var self =this;
		var retVals=new Array();
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");
		return rows.map(function(){
			 var inputList = $(rows).find(":input");
			 var retVal=self.isFullIP(inputList);
		     var tmpStr="";
		     if(retVal)
		     {
			     tmpStr=$.trim(inputList[0].value)+"."+$.trim(inputList[1].value)+"."+$.trim(inputList[2].value)+"."+$.trim(inputList[3].value);		     
			     if(inputList.length==5)
			     {
			     	tmpStr+=":"+inputList[4].value;
			     }
			     return {value:tmpStr,text:tmpStr};
		     }
		     
		}).get();
	}
	
	Component.IPAddress.prototype.adjustControlNums=function(num)
	{
		if(this.ipCount<num)
		{
			for(var i=0,len=num-this.ipCount;i<len;i++)
			{
				$("#" + this.addLinkId).trigger("click");
			}
		}
	}
	
	
	
	Component.IPAddress.prototype.setValue=function(values)
	{
	    var self = this;
	    if(values === "undefined" || values === null)return;
	    this.adjustControlNums(values.length);
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");
		$.each(rows, function(j, _row){
		     var ipStr = values[j].value;
			 var arr = ipStr.split(":");
			 var ip = arr[0];
			 var port="";
			 if(arr.length==2)
			 {
			 	port=arr[1];
			 }
		     var inputList = $(_row).find(":input");
		     $.each(inputList,function(i,input)
		     {
		        var aryIP = ip.split(".");
		        if(i<4){
		     	inputList[i%4].value=aryIP[i%4];
		     	}
		     	if(i==4)
		     	{
		     	   $(input).val(port);
		     	 
		     	}
		      
		     	
		     });
		});
		this.log("ipAddress.setValue");
	}
	
	Component.IPAddress.prototype.reset=function()
	{
		$("#" + this.tableId + " :text").val("");
		this.removeOthers();
		if(this.disabled){
			this.disable(this.disabled)
		}
	}
	
	Component.IPAddress.prototype.disable = function(b)
	{
	   if(b)
	   {
	   	 this.enable(false)
	   }else
	   {
	   	 this.enable(true);
	   }
	}
	
	
	
	
	
	
	Component.IPAddress.prototype.enable = function(b)
	{
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");
		if(b){
			$.each(rows, function(i, _row){
			     var inputList = $(_row).find(":input");
			     $.each(inputList,function(i,input)
			     {
			     	$(input).removeAttr("disabled");
			     });
			});
			$("#" + this.addLinkId).bind("click",{target:this}, this.addEvent);
			$("#" + this.addLinkId).css("cursor", "pointer");
		}else
		{
			var rows = jQuery("#" + this.tableId).find(">tbody>tr");
			$.each(rows, function(i, _row){
			     var inputList = $(_row).find(":input");
			     $.each(inputList,function(i,input)
			     {			     	
			     	$(input).attr("disabled","true");
			     });			     
			});
			$("#" + this.addLinkId).unbind("click");
			$("#" + this.addLinkId).css("cursor", "default");
		}
		
		
		this.disabled=!b;
	}

	
	Component.IPAddress.prototype._getFields=function() {
		
		var ctrlIP=this.id;
		var fieldArr = new Array(4);
		for (var i = 0; i < 4; i++) {
			fieldArr[i] = $(ctrlIP + (i + 1));
	
		}
		return fieldArr;
	}
	

	
	Component.IPAddress.prototype.removeOthers=function()
	{
		$("#" + this.tableId).find("a>img").parent().trigger("click");
	}	
	
	Component.IPAddress.prototype.clear = function()
	{
		$("#" + this.container).empty();
		this._init();
	
	} 
	
	