ConditionMgr.functions["ipAddressLego"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.labelContainerId = this.id + "_label";
		this.fieldName = this.id + "_n";
		this.containerId = this.id + "_container";
		this.descId = "lbl_" + this.id;
		this.starLabelId ="starlbl_" + this.id;
		this.flag = true;
		this.invalidText = "";
		this.numErrText = gI18nTestIPAddress;
	},
	onInitComplete:function()
    {
    	this.initialized=true;
    },
	initDoms : function() {
		var that = this;
		this.container = jQuery("#" + this.containerId);
		var that = this;
		var _input = jQuery("#"+this.id);
		that.container.append(_input);

        var starLabel = jQuery("<label/>").attr({
				id : that.starLabelId
			});
		that.container.append(starLabel);
		var wrapId = "lbl_" + this.id;
		if(this.required && this.required=='true'){ 
        	starLabel.text("*").css("color","#D60606").css("padding-left","3px").css("vertical-align","middle");  
		}
		
		var descLabel = jQuery("<label/>").attr({
				id : that.descId
			});
		that.container.append(descLabel);
		if (that.desc){
			descLabel.text(that.desc).addClass("ireport-ui-label").attr("title", that.desc);
		}
		
	},
	_check : function(that){
		var jField = jQuery("#" + that.id);
		var textIpRex = /^((22[0-3]|2[0-1][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]))?$/;
		var _expr = new RegExp(textIpRex);
		var iPvalue=jField.val();
		if (!_expr.test(jField.val()) || iPvalue.split(".")[0]=="127") {
			that.flag = false;
		    that.invalidText = that.numErrText;
			LegoTag.Msg.info(that.numErrText);
			return false;
			}
			that.flag = true;
			return true;
	},
	_checkEvent : function(event) {
		var that = event.data.target;
		that._check(that);
	},
	initEvents : function() {
		var that = this;
		var jField = jQuery("#" + that.id);
		var textIpRex = /^((22[0-3]|2[0-1][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]))?$/;
		var _expr = new RegExp(textIpRex);
		var iPvalue=jField.val();
		jQuery("#" + that.id).bind({
				keyup : function(event) {
						that.triggerChange();
				}
			});
		

	},
	_doBlur : function(event) {
		var that = event.data.target;
		that.triggerChange();
	},
	triggerChange : function()
	{
	     $(this).trigger("onValueChange", this);
	},
	
	beforeShowData : function() {
		this.clear();
	},

	showData : function() {
	},

	afterShowData : function() {
		var that = this;
		this.checkItems();
	},
	checkItems : function() {
		if (this.isTrue(this.disabled)){
			this.disable(this.isTrue(this.disabled));
		}
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		jQuery("#" + this.containerId).empty();
	},
	reset : function(){
		this.publishEvent("onValueChange");
	},
	getValueWithText : function() {
	    var jField = jQuery("#" + this.id);
	    var v = jQuery("#" + this.id).val();
	    var textIpRex = /^((22[0-3]|2[0-1][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]))?$/;
		var _expr = new RegExp(textIpRex);
		var iPvalue=jField.val();
		if (!_expr.test(jField.val()) || iPvalue.split(".")[0]=="127") {
		return {
			value : "",
			text : ""
		};
		}else{
		return {
			value : v,
			text : v
		};
		}
	},
	getSimpleValue : function() {
	    var jField = jQuery("#" + this.id);
	    var textIpRex = /^((22[0-3]|2[0-1][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9])\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]|0)\.(25[0-5]|2[0-4][0-9]|[0-1]{1}[0-9]{2}|[1-9]{1}[0-9]{1}|[1-9]))?$/;
		var _expr = new RegExp(textIpRex);
		var iPvalue=jField.val();
		if (!_expr.test(jField.val()) || iPvalue.split(".")[0]=="127") {
		return "";
		}else{
		return jQuery("#" + this.id).val();
		}
	},

	setValue : function(obj) {
		if (obj != undefined) {
			jQuery("#" + this.id).val(obj["value"]);
		}
	},
	disable : function(bn) {
		jQuery("#" + this.id).attr("disabled", bn);
		this.isEnable=!bn;
	},
	checkData : function() {
		var rstObj = {
			success : true,
			msg : '',
			isRequiredFailed : false
		};
		
		if(!this._check(this)){
			rstObj.success = false;
			rstObj.msg = this.invalidText ? this.invalidText : this.blankValidateText;			
		} else if (this.isTrue(this.required) && this.getSimpleValue() == ''){
			rstObj.success = false;
			rstObj.msg = this.blankValidateText;
			rstObj.isRequiredFailed = true ;
		}
		return rstObj;
	}
})));
};