
ConditionMgr.functions["ipAndMask"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
	initProperties : function() {
	    this.ipmask = new Component.IPMask();
	},

	initDoms : function() {
		this.ipmask.create(configParams);
	},
	beforeShowData : function() {
		this.ipmask.clear();
	},
	showData : function() {
	},
	afterShowData : function() {
		var that = this;
		this.checkItems();
	},
	checkItems : function() {
		if (this.disabled=="true"||this.disabled==true){
			this.disable(this.isTrue(this.disabled));
		}
	},
	beforeInitComplete : function() {
		this.checkItems();
	},
	clear : function() {
		this.ipmask.clear();
	},
	reset : function(){
		this.ipmask.reset();
	},
	getValueWithText : function() {
	   return this.ipmask.getValues();
	},
	getSimpleValue : function() {
	  return this.ipmask.getValue();
	},
	setValue : function(values) {
	    this.ipmask.setValue(values);
	},
	
	removeOther : function(){
	 	this.ipmask.removeOthers();
	},
	disable : function(bn) {
		this.ipmask.disable(bn);
	},
	checkData : function() {
	    return this.ipmask.validate();
	}
})));
};

  Component.IPMask=function(_owner)
  {
  	if(_owner){
  		this.parent=_owner;
  	}else
  	{
  		this.parent=null;
  	}
  	this._init();
  };
  
  Component.IPMask.prototype.log= function () {
		if (this.debug && window.console && window.console.log)
		{
			if(typeof console.log.apply !=undefined)
			{
				console.log.apply('', arguments);
			}
		}
   }
  Component.IPMask.prototype._init=function()
  {
  	this.CanJump=true;
  	this.debug=false;
  	this.id="";
  	this.name="";
  	this.key="";
    this.label="";
  	this.blankValidateText="";
    this.disabled=false;
   	this.required=false;
   	this.maxNum=5;
   	this.add=false;
   	this.hasPort=false;
   	this.ipCount=1;
   	this.container=null;
   	this.fieldName="";
   	
   	this.addLinkId = "";
   	this.labelContainerId= "";
   	this.containerId= "";
   	this.style={};
   	this.MAX_INDEX=1;
   	this.log("ipAddressMask._init");
  }
  Component.IPMask.prototype.init=function(configs)
  {
  	this.id=configs.id;
  	this.name=configs.name;
  	this.key=configs.key;
    this.label=configs.label;
  	this.blankValidateText=configs.blankValidateText;
    this.disabled=(configs.disabled=="true"||configs.disabled==true) ? true:false;
   	this.required= (configs.required=="true"||configs.required==true) ? true:false;
   	this.maxNum=parseInt(configs.maxNum);
   	this.add=false;
   	this.hasPort= (configs.hasPort=="true"||configs.hasPort==true)?true:false;
   	this.width="320px";
   	this.height="75px";
   	this.container = this.id + "_container";
   	$("#"+this.container).css("width",this.width);
   	this.addLinkId = this.id+"_add_link";
   	this.labelContainerId=this.id+"_label";
   	this.containerId=this.container;
   	
   	this.fieldName = this.id;
   	this.tableId = this.id+"_condition_wrap";
   	this.log("ipAddressMask.init");
  }
  Component.IPMask.prototype.loadData=function(type)
  {
  	
  }
  
  Component.IPMask.prototype.create=function()
  {
    
  	var configs = arguments[0];
  	this.init(configs);
  	if(configs!==null)
  	{
  		this.appendixCreate();
  	}
  	if(this.disabled)
  	{
  		this.disable(this.disabled);
  	}	
  	this.bindIpEvents();
  	this.log("ipAddressMask.create");
  }
  
  Component.IPMask.prototype.prepareTestData=function()
  {
  	var values=new Array();
    var obj={};
	
	obj.value="192.168.0.1/255.0.0.0:8080";
	obj.text="192.168.0.1/255.0.0.0:8080";
	
	values.push(obj);
	var obj2={}
	
	obj2.value="192.168.0.18/255.255.0.0:8083";
	obj2.text="192.168.0.18/255.255.0.0:8083";
	
	values.push(obj2);
	var obj3={};
	
	obj3.value="192.168.0.128/255.255.255.0:8084";
	obj3.text="192.168.0.128/255.255.255.0:8084";
	
	values.push(obj3);
	this.setValue(values);
	this.log(this.getValues()[0].value);
	this.log(this.getValues()[0].text);
	this.log(this.validate());
	this.disabled=false;
	this.log("ipAddressMask.prepareTestData");
  }
  
    Component.IPMask.prototype.focusInvalidField=function(fields)
    {
      this.log("focusIPField");
      var self = this;
      var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
	  for(var j=0,jlen=rows.length;j<jlen;j++){
	      var _row=rows[j];
	      var bContinue=true;
		  var fields = $(_row).find(":input");
		  var field =null;
	      for(var i=0,len=fields.length;i<len;i++)
	      {
	      	  field = fields[i];
	      	  if($.trim($(field).val())=="")
		   	  {
		   	        if(i<=3)
		   	        {
		   	           
		   	        }else
		   	        {
		   	        }
		   			field.focus();
		   			bContinue=false;
		   			break;
		   	  }
	      }
	      if(!bContinue)break;
		}
		
    }
    Component.IPMask.prototype.unrequiredValidate=function(fields)
    {
      this.log("unrequiredValidate");
      var self = this;
      var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
	  for(var j=0,jlen=rows.length;j<jlen;j++){
	      var _row=rows[j];
	      var bShowInfo=false;
		  var fields = $(_row).find(":input");
		  var field =null;
		  var validCnt=0;
	      for(var i=0,len=fields.length;i<len;i++)
	      {
	      	  field = fields[i];
	      	  if($.trim($(field).val())!="")
		   	  {
		   			validCnt++;
		   	  }
	      }
	      if(this.hasPort)
	      {
		      if(validCnt!=0&&validCnt!=9)
		      {
		      	return false;
		      }
	      }else
	      {
	      	  if(validCnt!=0&&validCnt!=8)
		      {
		      	return false;
		      }
	      }
		}
		return true;
    } 
    
    Component.IPMask.prototype.focusIPField=function(fields)
    {
      this.log("focusIPField");
      var self = this;
      var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
	  for(var j=0,jlen=rows.length;j<jlen;j++){
	      var _row=rows[j];
	      var bContinue=true;
		  var fields = $(_row).find(":input");
		  var field =null;
	      for(var i=0,len=fields.length;i<len;i++)
	      {
	      	  field = fields[i];
	      	  if($.trim($(field).val())=="")
		   	  {
		   			field.focus();
		   			bContinue=false;
		   			break;
		   	  }
	      }
	      if(!bContinue)break;
		}
		
    }    
  Component.IPMask.prototype.validate=function()
  {
  	var retVal = {
			success : true,
			msg : '',
			isRequiredFailed : false
		};
	var v = this.getValues();
	this.log(v);
	if(this.required)
	{
		if(!this.unrequiredValidate())
		{
			retVal.success = false;
			retVal.msg = $RRs.ip_mask_alert_invalid;
			_log("debug","here1");
			this.focusIPField();
			return retVal;
		}
		if((v.length ==0 || v.length!=this.ipCount) )
		{
		    this.log("有错误信息了");
			retVal.success = false;
			retVal.msg = this.blankValidateText;
			retVal.isRequiredFailed = true;
			this.focusInvalidField();
			return retVal;
		}
		
	}else
	{
		if(!this.unrequiredValidate())
		{
			retVal.success = false;
			retVal.msg = $RRs.ip_mask_alert_invalid;
			_log("debug","here2");
			this.focusIPField();
			return retVal;
		}
	}
	
  	if (this.required && v.length == 0){
			retVal.success = false;
			retVal.msg = this.blankValidateText;
		}else if (v.join(";").search("formatError") !== -1){
			retVal.success = false;
			retVal.msg = this.blankValidateText;
		}
  	return retVal;
  }
  Component.IPMask.prototype._check=function()
  {
  
  	return true;
  }
  
  Component.IPMask.prototype.appendixCreate=function()
  {
     var legoContainerId = "#"+this.id;
	  if(this.hasPort)
	  {
	    var portId = this.id + "_port";
	    var strObj = new StringBuffer();
	   	strObj.append("<div class='ireport-ui-text-ip-mask-panel'>");
		strObj.append("   &nbsp;:");
		strObj.append("  <input type='text' id='"+ portId +"' class='ireport-ui-text-ip-mask-port' value='' maxlength='5' />");
		strObj.append("  <span style='vertical-align: middle'>[1-65535]</span>");
		strObj.append("</div>"); 
		var wrapId = this.id+"_wrap";
		$("#"+wrapId).append($(strObj.toString()));		
		this.bindPortEvent(portId);
	   }
	  var v=this.add;
	  if (v === "true" || v === true){
	  	var _addLink = $("#" + this.addLinkId);
	  	_addLink.show();
	   _addLink.bind("click",{target:this}, this.addEvent);
		}
		
		$("#"+this.id+"_ul_ip").mouseover(function(){
	      $(this).addClass('ireport-ui-ctrl-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-ctrl-mouseover'); 
	    }); 
	    $("#"+this.id+"_ul_mask").mouseover(function(){
	      $(this).addClass('ireport-ui-ctrl-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-ctrl-mouseover'); 
	    }); 
	}
	Component.IPMask.prototype.getFieldIndex = function(obj) {
		var objId = obj.id;
		var len = objId.length;
		return objId.charAt(len - 1);
	}
	
	Component.IPMask.prototype.getNextField = function(obj) {
	 	var id=obj.id;
		var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
		this.log(idPrefix);
		var index = this.getFieldIndex(obj);
		var nextField = null;
	
		if (index == 1) {
			nextField = document.getElementById(idPrefix + 2);
		} else if (index == 2) {
			nextField = document.getElementById(idPrefix + 3);
		} else if (index == 3){
			nextField = document.getElementById(idPrefix + 4);
		}else if (index == 4){
		   if( id.indexOf("_mask_")==-1 ){
				nextField = document.getElementById(idPrefix+"mask_" + 1);
			}else{
				if(this.hasPort)
				{
					var ipPrefix = id.substring(0,id.lastIndexOf("_mask_")+1);
					nextField = document.getElementById(ipPrefix+"port");
				}else
				{
					nextField = document.getElementById(idPrefix+ 4);
				}
			}
		}
		return nextField;
	}
	Component.IPMask.prototype.getPrevField = function(index,obj) {
		var id=obj.id;
		var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
		var retField = null;
		if (index == 1) {
			if( id.indexOf("_mask_")!=-1)
		    {
		    	var ipPrefix = id.substring(0,id.lastIndexOf("_mask_")+1);
		    	retField = document.getElementById(ipPrefix + 4);
		    }else{
				retField = obj;
			}
		} else if (index == 2) {
			retField = document.getElementById(idPrefix + 1);
		} else if (index == 3){
			retField = document.getElementById(idPrefix + 2);
		}else if (index == 4){
			retField = document.getElementById(idPrefix + 3);
		}
		return retField;
	}
	Component.IPMask.doKeyDown = function(event) {
		var self = event.data.self;
		var srcObj = event.target;
		var keyCode = event.keyCode;
		var index = event.data.index;
		switch(keyCode)
		{
			case 190: 
			case 110:
			{
				var curPos = getCaret(srcObj);
				if (curPos == srcObj.value.length&& srcObj.value != "") {
					var field = self.getNextField(srcObj);
					setCaret(field, 'end');
					self.CanJump=false;
					return event.returnValue = false;
				}
			}
			break;
			case 39:
			{
			}
				break;
			case 40:
			break;
			case 37:
			{
			}
				break;
			case 38:
			break;
			case 8: 
			{
				var curPos = getCaret(srcObj);
				if (curPos == 0) {
					var field = self.getPrevField(index,srcObj);
					setCaret(field, 'end');
					self.CanJump=false;
					return event.returnValue = false;
				}
			}				

			break;
			case 13:
			break;
			case 9:
			break;
			default:
			return event.returnValue = true;
			
			
		}
	}	
	
	Component.IPMask.doMaskBlur = function(event)
	{
		var self = event.data.self;
		var _expr = event.data.expr;
		var idPrefix = event.data.idPrefix;
		var value = $(this).val();
		var val = parseInt($(this).val());
		var index = event.data.index;
		var keyCode = event.keyCode;
		if (_expr.test(value)) {
			$(this).val(this.value.replace(_expr, ""));
		}
		if(!isNaN(val))
		{
			if(val<0)
			{
				$(this).val("");
			}else
			{
				$(this).val(val);
			}
		}else
		{
			$(this).val("");
		}
		val = parseInt($(this).val());
     	if(!isNaN(val)&&$.inArray(val, Component.IPMask.VALID_MASK)==-1)
		{
			switch(index)
			{
				case 1:
					$(idPrefix+"1").val(255);
				break;
				case 2:
				   var preVal = $.trim($(idPrefix+"1").val());
				   if(preVal!="")
				   {
				   		$(this).val("0");
				   }else
				   {
				   		$(this).val("");
				   }
				   
				break;
				case 3:
					var preVal = $.trim($(idPrefix+"2").val());
				   if(preVal!=""&&preVal=="255")
				   {
				   		$(this).val("0");
				   }
				   if(preVal!=""&&preVal!="255")
				   {
				   		$(this).val("0");
				   }
				break;
				case 4:
					var preVal = $.trim($(idPrefix+"3").val());
				    if(preVal!="")
				    {
				   		$(this).val("0");
				    }
				break;
				default:
				
			}
			$(this).focus();
	    }
		if(!isNaN(val)&&$.inArray(val, Component.IPMask.VALID_MASK)!=-1)
		{
			switch(index)
			{
				case 1:
				break;
				case 2:
				   var preVal = $.trim($(idPrefix+"1").val());
				   if(preVal!=""&&preVal=="255")
				   {
				   }
				   if(preVal!=""&&preVal!="255")
				   {
				   		$(this).val("0");
				   }
				break;
				case 3:
					var preVal = $.trim($(idPrefix+"2").val());
				   if(preVal!=""&&preVal!="255")
				   {
				   		$(this).val("0");
				   }
				break;
				case 4:
					var preVal = $.trim($(idPrefix+"3").val());
				    if(preVal!=""&&preVal!="255")
				    {
				   		$(this).val("0");
				    }
				break;
				default:
				
			}
			
		}
		var val = self.getValue();
		if(val!=null)
		{
			if(null!=self.parent)
			{
				self.parent.triggerChange();
			}
		}
	}
	Component.IPMask.VALID_MASK=[255,254,252,248,240,224,192,128,0];
	Component.IPMask.prototype.bindIpEvents=function(ipMaskId)
	{
	    var self = this;
		ipMaskId=(ipMaskId === null||ipMaskId === undefined)?this.id:ipMaskId
		
		$("#"+ipMaskId+"_ul_ip").mouseover(function(){
	      $(this).addClass('ireport-ui-text-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-text-mouseover'); 
	    }); 
	    $("#"+ipMaskId+"_ul_mask").mouseover(function(){
	      $(this).addClass('ireport-ui-text-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-text-mouseover'); 
	    }); 
		
		var _expr = /\D/g;
		for(var i=1,len=4;i<=len;i++)
		{
			var ip = ipMaskId+"_"+i;
			var jip="#"+ip;
			var jmask = "#"+ipMaskId+"_mask_"+i;
			var maskPrefix=	"#"+ipMaskId+"_mask_";		
			var index = i;
		  $(jip).bind("blur",{self:this,expr:_expr,index:index}, Component.IPMask.doBlur);
		  $(jmask).bind("blur",{self:this,expr:_expr,index:index,idPrefix:maskPrefix}, Component.IPMask.doMaskBlur);
		  
		  $(jmask).bind("keydown",{self:this,expr:_expr,index:index},Component.IPMask.doKeyDown);	
		  $(jmask).bind("keyup paste",{expr:_expr,index:index}, function(event) {						
						var keyCode = event.keyCode;
						var val =$(this).val();
						var index = event.data.index;
						if (event.data.expr.test(val)) {
							$(this).val(val.replace(_expr, ""));
						}
												
						var value = parseInt($(this).val());
						if(!isNaN(value))
						{
							if(value<0)
							{
								$(this).val("");
							}else
							{
								$(this).val(value);
							}
						}else
						{
							$(this).val("");
						}
						if(value>255)
						{
							$(this).val(255);
							$(this).focus();
						}
						if(self.CanJump&&val>=100)
						{
							var nextField = self.getNextField(this);
							nextField.focus();
						}
						self.CanJump=true;
					});					
			$(jip).bind("keydown",{self:this,expr:_expr,index:index},Component.IPMask.doKeyDown);	
			$(jip).bind("keyup paste",{expr:_expr,index:index}, function(event) {
						var keyCode = event.keyCode;
						var val = $(this).val();
						var index = event.data.index;
						if (event.data.expr.test(val)) {
							$(this).val(val.replace(_expr, ""));
						}
						var value = parseInt($(this).val());
						if(!isNaN(value))
						{
							if(value<0)
							{
								$(this).val("");
							}else
							{
								$(this).val(value);
							}
						}else
						{
							$(this).val("");
						}
						if(index==1)
						{
							if(value>233)
							{
								$(this).val(223);
					        	$(this).focus();
							}
							if(value==127)
							{
								$(this).select();
							}
							if(value==0)
							{
								$(this).val("");
							}
							if(self.CanJump&&val>=100)
							{
								var nextField = self.getNextField(this);
								nextField.focus();
							}
						}else
						{
							if(value>255)
							{
								$(this).val(255);
					        	$(this).focus();
							}
							if(value==0)
							{
								$(this).val("0");
							}
							if(self.CanJump&&val>=100)
							{
								var nextField = self.getNextField(this);
								nextField.focus();
							}
						}
						self.CanJump=true;
					});	
		}
		
		this.log("ipAddressMask.bindIpEvents");
	}
	
	Component.IPMask.doPortKeyDown = function(event) {
		
		var self = event.data.self;
		var srcObj = event.target;
		var keyCode = event.keyCode;
		switch(keyCode)
		{
			case 190:
			case 110:
			break;
			case 39:
				break;
			case 40:
			break;
			case 37:
			{
			}
				break;
			case 38:
			break;
			case 8: 
			{
				var curPos = getCaret(srcObj);
				if (curPos == 0) {
					var id=srcObj.id;
					var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
					var lastMaskId = idPrefix+"mask_"+4;
					var field = document.getElementById(lastMaskId);					
					setCaret(field, 'end');
					self.CanJump=false;
					return event.returnValue = false;
				}
			}				

			break;
			case 13:
			break;
			case 9:
			break;
			default:
			return event.returnValue = true;
			
			
		}
	}
	Component.IPMask.doBlur = function(event)
	{
		var self = event.data.self;
		var _expr = event.data.expr;
		var value = $(this).val();
		var val = parseInt($(this).val());
		var index = event.data.index;
		var keyCode = event.keyCode;
		if (_expr.test(value)) {
			$(this).val(this.value.replace(_expr, ""));
		}
		
		if(!isNaN(val))
		{
			if(val<0)
			{
				$(this).val("");
			}else
			{
				if(index==1&val==0)
			    {
			    	$(this).val("");
			    }else{
					$(this).val(val);
				}
			}
		}else
		{
			$(this).val("");
		}
		
		var val = self.getValue();
		if(val!=null)
		{
			if(null!=self.parent)
			{
				self.parent.triggerChange();
			}
		}
		
	}
	Component.IPMask.prototype.bindPortEvent=function(portId)
	{
		var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
		var jPortId = "#"+portId;
		var _expr = /\D/g;
		$(jPortId).bind("keydown keyup paste",{expr:_expr, max:65535, min:1}, function(event) {
						if (event.data.expr.test(this.value)) {
							this.value = this.value.replace(_expr, "");
						}
						var val = parseInt($(this).val());
						if(!isNaN(val))
						{
							if(val<0)
							{
								$(this).val("");
							}else
							{
								$(this).val(val);
							}
						}else
						{
							$(this).val("");
						}
						if (this.value>event.data.max){
							this.value = event.data.max;
						}
						if (this.value != '' && this.value < event.data.min){
							this.value = event.data.min;
						}
					});
		
		$(jPortId).mouseover(function(){
	      $(this).addClass('ireport-ui-text-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-text-mouseover'); 
	    }); 
	    $(jPortId).bind("keydown",{self:this}, Component.IPMask.doPortKeyDown);
	    $(jPortId).bind("blur",{self:this,expr:_expr}, Component.IPMask.doBlur);				
	}
	
	Component.IPMask.prototype.createIPMask=function()
	{
		var str="<td class='ireport-ui-control-title'>&nbsp;</td><td class='ireport-ui-control-content'>"+ this.createIPMaskString() +"</td>";
		var strTR ="<tr nowrap='true'>"+str+"</tr>";	
		var tr = $(strTR);	
				
		tr.appendTo($("#"+this.tableId));
		
		this.ipCount++;
		this.MAX_INDEX++;
		var self =this;
		var newId=this.id+this.MAX_INDEX;
		var maskId=newId+"_mask_";
		var delButton = "#" + newId+"_del";
		var portPanel = "#" + newId+"_PanelAppendix";
		var fieldPort = newId+"_port";
		this.bindIpEvents(newId);
		this.log("绑定删除时间");
		$(delButton).bind("click",function()
		{
				if (tr.index() > 0){
					tr.remove();
					self.ipCount--;
				}
				self.log("ipAddressMask.delButton.EVT.click");
		});
		this.bindPortEvent(fieldPort);	
		this.log("ipAddressMask.createIPMask");
		
	}
	
	Component.IPMask.prototype.createIPMaskString = function()
	{
	   var strObj = new StringBuffer();
	   var curIndex=(this.MAX_INDEX+1);
	   var newId = this.id+curIndex;
	   var ulIPId=newId+"_ul_ip";
	   var ulMaskId=newId+"_ul_mask";
	   
	   var field1 = newId+"_1";
	   var field2 = newId+"_2";
	   var field3 = newId+"_3";
	   var field4 = newId+"_4";
	   var mask1= newId+"_mask_1";
	   var mask2= newId+"_mask_2";
	   var mask3= newId+"_mask_3";
	   var mask4= newId+"_mask_4";
	   var fieldPort = newId+"_port";
	   var hiddenField = newId+"-hidden";
	   var container=newId+"_container";
	   var delButton = newId+"_del";
	   var portPanel= newId + "_PanelAppendix";
	    strObj.append("<div class='ireport-ui-text-ip-mask-wrap'>");
		strObj.append("					  <div class='ireport-ui-text-ip-mask-panel'>");
		strObj.append("						<ul class='ireport-ui-text-ip-mask' id='"+ulIPId+"'>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("									<input type='text' id='"+field1+"' class='ireport-ui-text-ip-mask-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("								<input type='text' id='"+field2+"' class='ireport-ui-text-ip-mask-input' maxlength='3' />");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("								<input type='text' id='"+field3+"' class='ireport-ui-text-ip-mask-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("								<input type='text' id='"+field4+"' class='ireport-ui-text-ip-mask-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("						</ul>");
		strObj.append("						</div>");
		
		strObj.append("<div  class='ireport-ui-text-ip-mask-slash-splitter'>/</div>");
						
		strObj.append("					  <div class='ireport-ui-text-ip-mask-panel'>");
		strObj.append("						<ul class='ireport-ui-text-ip-mask' id='"+ulMaskId+"'>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("								<input type='text' id='"+mask1+"' class='ireport-ui-text-ip-mask-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("								<input type='text' id='"+mask2+"' class='ireport-ui-text-ip-mask-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("									<input type='text' id='"+mask3+"' class='ireport-ui-text-ip-mask-input' maxlength='3' />");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("									<input type='text' id='"+mask4+"' value='' class='ireport-ui-text-ip-mask-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("						</ul>");
		strObj.append("						</div>");
		if(this.hasPort)
		{
			strObj.append("						<div class='ireport-ui-text-ip-mask-panel'>");
			strObj.append("						    	&nbsp;:");
			strObj.append("							    <input type='text' id='"+fieldPort+"' class='ireport-ui-text-ip-mask-port' value='' maxlength='5'/>");
			strObj.append("							    <span style='vertical-align:middle'>[1-65535]</span>");		
			strObj.append("						</div>");
		}
		strObj.append("						<div class='ireport-ui-text-ip-mask-panel'>");
		strObj.append("        <a title='删除' style='cursor: pointer;height:20px' id='"+delButton+"'><img style='vertical-align:middle' height='16' width='16' src='"+Component._PATH_+"images/delete.png'/>");
  	    strObj.append("						</div>");
		
		strObj.append("					</div>");
		this.log("ipAddressMask.createIPMaskString");
		return strObj;
	}
    Component.IPMask.prototype.addEvent=function(event)
    {
    	var that = event.data.target;
	   	try {
		   	var tbl = $("#" + that.tableId);
		   	
			var i = tbl.find(">tbody>tr").size();
			if (that.maxNum && !isNaN(that.maxNum) && (i + 1) > that.maxNum){
				alert($RRs.ip_alert_before+" "+ that.maxNum +" "+$RRs.ip_alert_after);
				return false;
			}
			
			that.createIPMask();		
		 }
		 catch(e) {
		   alert("IPMask create failed: " + e);
		 }
		 finally {
		   that.log("ipAddressMask.addEvent");
		 }   	   	
    }
    
	Component.IPMask.prototype.getValue=function()
	{
	    var self =this;
		var retVals=new Array(this.ipCount);
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
		$.each(rows, function(j, _row){
		     var inputList = $(_row).find(":input");
		     retVals[j]=inputList[0].value+"."+inputList[1].value+"."+inputList[2].value+"."+inputList[3].value+"/";
		     retVals[j]+=inputList[4].value+"."+inputList[5].value+"."+inputList[6].value+"."+inputList[7].value;
		     if(inputList.length==9)
		     {
		     	retVals[j]+=":"+inputList[8].value;
		     }
		});
		return retVals;
	}
    Component.IPMask.prototype.isFullIPMask=function(fields)
    {
      var self = this;
      var isCorrect=true;
    	$.each(fields, function(j, field){
	   		if($.trim($(field).val())=="")
	    	{
	    		isCorrect= false;
	    	}
    	});
    	return isCorrect;
    }
	Component.IPMask.prototype.getValues=function()
	{
	 	var self =this;
		var retVals=new Array();
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
		$.each(rows, function(j, _row){
		     var inputList = $(_row).find(":input");
		     var retVal=self.isFullIPMask(inputList);
		     if(retVal)
		     {
			     var tmpStr=inputList[0].value+"."+inputList[1].value+"."+inputList[2].value+"."+inputList[3].value+"/";
			     tmpStr+=inputList[4].value+"."+inputList[5].value+"."+inputList[6].value+"."+inputList[7].value;
			     if(inputList.length==9)
			     {
			     	tmpStr+=":"+inputList[8].value;
			     }
			     retVals[j] = {value:tmpStr,text:tmpStr};
		     }
		});
		return retVals;
	}
	
	Component.IPMask.prototype.adjustControlNums=function(num)
	{
		if(this.ipCount<num)
		{
			for(var i=0,len=num-this.ipCount;i<len;i++)
			{
				$("#" + this.addLinkId).trigger("click");
			}
		}
	}
	
	Component.IPMask.prototype.setValue=function(values)
	{
	    var self = this;
	    if(values === "undefined" || values === null)return;
	    this.adjustControlNums(values.length);
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");
		$.each(rows, function(j, _row){
		     var ipStr = values[j].value;
			 var arr = ipStr.split(/[\/\:]/);
			
		     var inputList = $(_row).find(":input");
		     $.each(inputList,function(i,input)
		     {
		        var ip=arr[0];
		        var mask=arr[1];
		        var aryIP = ip.split(".");
		        var aryMask=mask.split(".");
		        if(i<4){
		     	inputList[i%4].value=aryIP[i%4];
		     	}
		     	if(i>=4 && i<8)
		     	{
		     		inputList[i%8].value =aryMask[i%4];
		     		
		     	}
		     	if(i==8)
		     	{
		     	   $(input).val(arr[2]);
		     	 
		     	}
		      
		     	
		     });
		});

		this.log("ipAddressMask.setValue");
	}
	
	Component.IPMask.prototype.reset=function()
	{
		$("#" + this.tableId + " :text").val("");
		this.removeOthers();
		if(this.disabled){
			this.disable(this.disabled)
		}
	}
	Component.IPMask.prototype.disable = function(b)
	{
	   if(b)
	   {
	   	 this.enable(false)
	   }else
	   {
	   	 this.enable(true);
	   }
	}
	
	
	
	
	
	Component.IPMask.prototype.enable = function(b)
	{
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");
		if(b){
			$.each(rows, function(i, _row){
			     var inputList = $(_row).find(":input");
			     $.each(inputList,function(i,input)
			     {
			     	$(input).removeAttr("disabled");
			     });
			});
			$("#" + this.addLinkId).bind("click",{target:this}, this.addEvent);
			$("#" + this.addLinkId).css("cursor", "pointer");
		}else
		{
			var rows = jQuery("#" + this.tableId).find(">tbody>tr");
			$.each(rows, function(i, _row){
			     var inputList = $(_row).find(":input");
			     $.each(inputList,function(i,input)
			     {			     	
			     	$(input).attr("disabled","true");
			     });			     
			});
			$("#" + this.addLinkId).unbind("click");
			$("#" + this.addLinkId).css("cursor", "default");
		}
		
		
		this.disabled=!b;
	}

	Component.IPMask.prototype._getFields=function() {
		var ctrlIP=this.id;
		var fieldArr = new Array(4);
		for (var i = 0; i < 4; i++) {
			fieldArr[i] = $(ctrlIP + (i + 1));
	
		}
		return fieldArr;
	}
	

	Component.IPMask.prototype.removeOthers=function()
	{
		$("#" + this.tableId).find("a>img").parent().trigger("click");
	}	
	Component.IPMask.prototype.clear = function()
	{
		$("#" + this.container).empty();
		this._init();
	
	} 
	
	