ConditionMgr.functions["natureDate"] = function(configParams){
ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.fieldId = "txt_" + this.id;							
		this.fieldName = this.id + "_n";						
		this.containerId = this.id + "_container";				
		this.descId = "lbl_" + this.id;
		this.startTimeLong = 0;                                 
		this.endTimeLong = 0;									
		this.dayType = this.dayType?this.dayType:"RANGE";				
		this.date_type = dateType;								
		this.date_quarter = dateQuarter;						
		this.date_month =  dateMonth;							
		this.data_week = data52Week; 							
		this.dateConfig = getDateConfig(this);					
		if(this.dateConfig === "")
		{
			this.dateConfig = "dateFmt:'"+Date_const.defaultDateFmt+"'";
			this.dateFmt = Date_const.defaultDateFmt;
		}
		this.date = new Date();
	},
	
	initDoms : function() {
		this.container = $("#" + this.containerId);
		var that = this;
		
		var tab = $("<table>",{cellspacing:'0',cellpadding:'0'}).appendTo(that.container);  
		var tr =$("<tr id='time_dateRange_tr_"+ this.id+"'></tr>").appendTo(tab);	
		var td = $("<td height='25'></td>").appendTo(tr);
		
		var tabInner=$("<table>",{cellspacing:'0',cellpadding:'0'}).appendTo(td);
		var trInner =$("<tr></tr>").appendTo(tabInner);
		var td1= $("<td></td>").appendTo(trInner);
		var td2= $("<td></td>").appendTo(trInner);
		var td3= $("<td></td>").appendTo(trInner);
		var td4= $("<td></td>").appendTo(trInner);
		var td5= $("<td></td>").appendTo(trInner);	
		var td6= $("<td></td>").appendTo(trInner);
		
		that.dateSelectType_div =$("<div id='dateSelectType_div_"+ this.id+"'></div>").appendTo(td1);
		that.dateText_div =$("<div id='dateText_div_"+ this.id +"' ></div>").appendTo(td2);
		that.year_div =$("<div id='year_div_"+ this.id +"'  ></div>").appendTo(td3);
		that.month_div =$("<div id='month_div_"+ this.id +"'  ></div>").appendTo(td4);
		that.quarter_div =$("<div id='quarter_div_"+ this.id +"'  ></div>").appendTo(td5);
		that.week_div =$("<div id='week_div_"+ this.id +"' ></div>").appendTo(td6);
		that.week_div.hide();
		that.month_div.hide();
		that.quarter_div.hide();
		that.year_div.hide();
		
		if('POINT'==this.dayType.toUpperCase())
		{
			that.dateText = $("<input class='Wdate' type='text' onClick=\"WdatePicker({"+that.dateConfig+"})\"/>")
			.attr({
				name:that.fieldName
			});
			that.dateText.val(toStringByPattern(that.date,that.dateFmt)).appendTo(that.dateText_div);   								
		}
		if('RANGE'==this.dayType.toUpperCase())
		{
			that.day1 = jQuery("<input id='txt_start_day_"+this.id+"' class='Wdate' type='text' onClick=\"WdatePicker({"+this.dateConfig+"})\"/>")
			.bind('focus',function(){
			    jQuery(this).css("border","1px solid #7EADD9");
			})
			.bind('blur',function(){
			    if(this.value==''||this.value==null){
			       jQuery(this).css("border","1px solid #DD7870");
			    }else{
			    	jQuery(this).css("border","1px solid #B5B8C8");
			    }
			 })
			.appendTo(that.dateText_div);
			that.label2 = jQuery("<label>"+$RRs.cbd_to+"</label>").appendTo(that.dateText_div);
			that.day2 = jQuery("<input id='txt_end_day_"+this.id+"' class='Wdate' type='text'  onClick=\"WdatePicker({"+this.dateConfig+"})\"/>")
			.bind('focus',function(){
			    jQuery(this).css("border","1px solid #7EADD9");
			})
			.bind('blur',function(){
			    if(this.value==''||this.value==null){
			       jQuery(this).css("border","1px solid #DD7870");
			    }else{
			    	jQuery(this).css("border","1px solid #B5B8C8");
			    }
			 })
			.appendTo(that.dateText_div);
			
			that.day1.val(toStringByPattern(new Date(that.date.getTime()-86400000),that.dateFmt));
			that.day2.val(toStringByPattern(that.date,that.dateFmt));
			that.day1Change();
			that.day2Change();
		}
		
		that.dateSelectType_sel = createSelectDoms("dateSelectType_div_"+ this.id,"dateSelectType_id_"+this.id,"dateSelectType_n"+this.id,that.date_type,'1');   
		that.week_sel = createSelectDoms("week_div_"+ that.id,"week_select_id_"+that.id,"week_select_name"+that.id,that.data_week,that.initWeek());  			
		that.month_sel = createSelectDoms("month_div_"+ that.id,"month_select_id_"+that.id,"month_select_name"+that.id,that.date_month,that.initMonth());			
		that.quarter_sel = createSelectDoms("quarter_div_"+ that.id,"quarter_select_id_"+that.id,"quarter_select_name"+that.id,that.date_quarter,that.initQuarter());	
		that.year_sel = createSelectDoms("year_div_"+ that.id,"year_select_id_"+that.id,"year_select_name"+that.id,that.initYears(),that.date.getFullYear()+'');			
		that.dateSelectType_div.append(that.dateSelectType_sel);
		that.week_div.append(that.week_sel);
		that.month_div.append(that.month_sel);
		that.quarter_div.append(that.quarter_sel);
		that.year_div.append(that.year_sel);
	},
	
	initEvents : function() {
		var that = this;
		that.dateSelectType_sel.bind('change',function(){
			that.dateSelectTypeChange();
		});
		that.week_sel.bind('change',function(){
			that.weekChange();
		});
		that.month_sel.bind('change',function(){
			that.monthChange();
		});
		that.quarter_sel.bind('change',function(){
			that.quarterChange();
		});
		that.year_sel.bind('change',function(){
			that.yearChange();
		});
	},

	beforeShowData : function() {
		this.clear();
	},

	showData : function() {},

	afterShowData : function() {
		var that = this;
		$("#" + that.fieldId).bind("change", function(event){
			var target = event.target;
			if (target.value !== ""){
				$("#" + that.descId).text(target.value).attr("title", target.value);
			}
		});
		this.checkItems();
	},
	checkItems : function() {
		this.disable(this.disabled);
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		$("#" + this.containerId).empty();
	},

	getValueWithText : function() {
		if(!this.isTrue(this.required))
		{
			this.setTimeByText();
		}
		return this.getSimpleValue();
	},
	getSimpleValue : function() {
		var that = this;
		var startTime = toStringByPattern(new Date(this.startTimeLong*1000),"yyyy-MM-dd HH:mm:ss");
		var endTime = toStringByPattern(new Date(this.endTimeLong*1000),"yyyy-MM-dd HH:mm:ss");
		
		var type = that.dateSelectType_sel.val();
		var timeVal="";
		switch (type)
		{
			case "1":
			{
				if('POINT'==this.dayType.toUpperCase())
				{
					timeVal = that.dateText.val();
				}
				if('RANGE'==this.dayType.toUpperCase())
				{
					timeVal = that.day1.val()+"&"+that.day2.val();
				}
				break;
			}
			case "2":
			{
				timeVal = that.year_sel.val()+"-"+that.week_sel.val();
				break;
			}
			case "3":
			{
				timeVal = that.year_sel.val()+"-"+that.month_sel.val();
				break;
			}
			case "4":
			{
				timeVal = that.year_sel.val()+"-"+that.quarter_sel.val();
				break;
			}
		}
		return [{value: ""+this.startTimeLong , text: startTime},{value: ""+this.endTimeLong ,text:endTime},{value:type,text:timeVal}];
	},

	setValue : function(v) {
		if (null != v && v != undefined){
			var that = this;
			var type=v[2].value;
			var timeVal = v[2].text.split("-");
				that.year_div.hide();
				that.quarter_div.hide();
				that.month_div.hide();
				that.week_div.hide();
				that.dateText_div.hide();
			switch (type)
			{
				case "1":
				{
					timeVal = v[2].text.split("&");
					if('POINT'==this.dayType.toUpperCase())
					{
						that.dateText.val(timeVal);
					}
					if('RANGE'==this.dayType.toUpperCase())
					{
						that.day1.val(timeVal[0]);
						that.day2.val(timeVal[1]);
					}					
					that.dateSelectType_sel.val("1");
					that.dateText_div.show();
					break;
				}
				case "2":
				{
					that.dateSelectType_sel.val("2");
					that.year_sel.val(timeVal[0]);
					that.week_sel.val(timeVal[1]);
					that.year_div.show();
					that.week_div.show();
					break;
				}
				case "3":
				{
					that.dateSelectType_sel.val("3");
					that.year_sel.val(timeVal[0]);
					that.month_sel.val(timeVal[1]);
					that.year_div.show();
					that.month_div.show();
					break;
				}
				case "4":
				{
					that.dateSelectType_sel.val("4");
					that.year_sel.val(timeVal[0]);
					that.quarter_sel.val(timeVal[1]);
					that.year_div.show();
					that.quarter_div.show();
					break;
				}
			}
		}
	},
	disable : function(b) {
		var bn = b ? true : false;
		if(b)
		{
			this.dateSelectType_sel.attr("disabled", true);
			this.week_sel.attr("disabled", true);
			this.month_sel.attr("disabled", true);
			this.quarter_sel.attr("disabled", true);
			this.year_sel.attr("disabled", true);
			if('POINT'==this.dayType.toUpperCase())
			{
				this.dateText.attr("disabled","disabled");
			}
			if('RANGE'==this.dayType.toUpperCase())
			{
				this.day1.attr("disabled","disabled");
				this.day2.attr("disabled","disabled");
			}
		}
		else
		{
			this.dateSelectType_sel.removeAttr("disabled");
			this.week_sel.removeAttr("disabled");
			this.month_sel.removeAttr("disabled");
			this.quarter_sel.removeAttr("disabled");
			this.year_sel.removeAttr("disabled");
			if('POINT'==this.dayType.toUpperCase())
			{
				this.dateText.removeAttr("disabled");
			}
			if('RANGE'==this.dayType.toUpperCase())
			{
				this.day1.removeAttr("disabled");
				this.day2.removeAttr("disabled");
			}
		}
		this.isEnable=!bn;
	},
	checkData : function() {
		this.setTimeByText();
		var rstObj = {success : true,msg : '',isRequiredFailed : false};
		if (this.isTrue(this.required) && ("1"==this.dateSelectType_sel.val()&&((this.day1.val()===''|| this.day2.val()==='')))) 
		{
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date;
			rstObj.isRequiredFailed = true ;
		}else if(!isCorrectFormat(this.dateFmt,this.day1.val())){
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
		}else if(!isCorrectFormat(this.dateFmt,this.day2.val())){
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
		}else if(this.startTimeLong>this.endTimeLong)
		{
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_error;
		}
		return rstObj;
	},
	
	dateSelectTypeChange:function(){
		var that = this;
		var type = that.dateSelectType_sel.val();
		switch (type)
		{
			case "1":
			{
				that.year_div.hide();
				that.quarter_div.hide();
				that.month_div.hide();
				that.week_div.hide();
				that.dateText_div.show();
				break;
			}
			case "2":
			{
				that.dateText_div.hide();
				that.quarter_div.hide();
				that.month_div.hide();
				that.year_div.show();
				that.week_div.show();
				that.weekChange();
				break;
			}
			case "3":
			{
				that.dateText_div.hide();
				that.quarter_div.hide();
				that.week_div.hide();
				that.year_div.show();
				that.month_div.show();
				that.monthChange();
				break;
			}
			case "4":
			{
				that.dateText_div.hide();
				that.month_div.hide();
				that.week_div.hide();
				that.year_div.show();
				that.quarter_div.show();
				that.quarterChange();
				break;
			}
		}
	},
	
	dayChange:function(){
		var that = this;
		var date_txt = that.dateText.val();
		if(date_txt==undefined||date_txt.length<10)
		{
			return;
		}
		var yearVal = date_txt.substr(0,4);
		var monthVal = date_txt.substr(5,2);
		var dayVal = date_txt.substr(8,2);
		that.startTimeLong = new Date(yearVal,monthVal-1,dayVal).getTime()/1000;
		that.endTimeLong = that.startTimeLong+86400-1;
	},
	
	day1Change:function(){
		var that = this;
		var date_txt = that.day1.val();
		if(date_txt==undefined||date_txt.length<10)
		{
			return;
		}
		var yearVal = date_txt.substr(0,4);
		var monthVal = date_txt.substr(5,2);
		var dayVal = date_txt.substr(8,2);
		that.startTimeLong = new Date(yearVal,monthVal-1,dayVal).getTime()/1000;
	},
	
	day2Change:function(){
		var that = this;
		var date_txt = that.day2.val();
		if(date_txt==undefined||date_txt.length<10)
		{
			return;
		}
		var yearVal = date_txt.substr(0,4);
		var monthVal = date_txt.substr(5,2);
		var dayVal = date_txt.substr(8,2);
		that.endTimeLong = new Date(yearVal,monthVal-1,dayVal).getTime()/1000+86400-1;
	},
	
	weekChange:function(){
		var that = this;
		var yearVal = new Number(that.year_sel.val());
		var weekVal = that.week_sel.val();
		var date = new Date(yearVal,0,1,0,0,0);
		var weekOfYear = getWeekOfYear(date);
		var dayOfWeek = date.getDay();
		if(1!=weekOfYear)
		{
			date = new Date(yearVal,0,(8-dayOfWeek));
		}
		else
		{
			date = new Date(date.getTime() - 86400000 * dayOfWeek);
		}
		var secondsOfWeek = 604800;
		that.startTimeLong = date.getTime()/1000 + (weekVal-1)*secondsOfWeek;
		that.endTimeLong = that.startTimeLong + (secondsOfWeek-1);
	},
	
	monthChange:function(){
		var that = this;
		var yearVal = new Number(that.year_sel.val());
		var monthVal = that.month_sel.val();
		that.startTimeLong = new Date(yearVal,monthVal-1,1,0,0,0).getTime()/1000;
		that.endTimeLong = new Date(monthVal==12?1+yearVal:yearVal,monthVal==12?0:monthVal).getTime()/1000-1;
	},
	
	quarterChange:function(){
		var that = this;
		var yearVal = new Number(that.year_sel.val());
		var quarterVal = that.quarter_sel.val();
		var startMonth = (quarterVal-1)*3;
		var endMonth = quarterVal*3;
		that.startTimeLong = new Date(yearVal,startMonth,1,0,0,0).getTime()/1000;
		that.endTimeLong = new Date(endMonth==12?1+yearVal:yearVal,endMonth==12?0:endMonth).getTime()/1000-1;
	},
	
	yearChange:function(){
	    var that = this;
		var type = that.dateSelectType_sel.val();
		switch (type)
		{
			case "2":
			{
				that.weekChange();
				break;
			}
			case "3":
			{
				that.monthChange();
				break;
			}
			case "4":
			{
				that.quarterChange();
				break;
			}
		}
	},
	
	initYears:function(){
		if(this.minDate===undefined || new Number(this.minDate)<Date_const.minDate)
		{
			this.minDate = Date_const.minDate;
		}
		if(this.maxDate===undefined || new Number(this.maxDate)<Date_const.maxDate)
		{
			this.maxDate = Date_const.maxDate;
		}
		minDate = new Number(this.minDate);
		maxDate = new Number(this.maxDate);
		var lengths = maxDate-minDate+1;
		var date_year = new Array(lengths);
		for(var i=0;i<lengths;i++)
		{
			var temp_Array = new Array(2);
			temp_Array[0] = minDate+i+'';
			temp_Array[1] = minDate+i+'';
			date_year[i] = temp_Array;
		}
		return date_year;
	},
	initQuarter:function(){
		switch(this.date.getMonth())
		{
			case 0 :
			case 1 :
			case 2 :
			{
				return '1';
				break;
			}
			case 3 :
			case 4 :
			case 5 :
			{
				return '2';
				break;
			}
			case 6 :
			case 7 :
			case 8 :
			{
				return '3';
				break;
			}
			case 9 :
			case 10 :
			case 11 :
			{
				return '4';
				break;
			}
		}
	},
	
	initMonth:function(){
		return (this.date.getMonth()+1)+'';
	},
	
	initWeek:function(){
	    var week = getWeekOfYear(this.date);
		if(week>52)
		{
			return 52;
		}
		else
		{
			return ''+week;
		}
	},
	setTimeByText:function()
	{
		var type = this.dateSelectType_sel.val();
		if(type == 1)
		{
			if('POINT'==this.dayType.toUpperCase())
			{
				this.dayChange();
			}
			if('RANGE'==this.dayType.toUpperCase())
			{
				this.day1Change();
				this.day2Change();
			}
		}
	}
})));
};