ConditionMgr.functions["radioGroup"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    
    initProperties : function() {
        this.labelContainerId = this.id + "_label";
        this.displayField = ((this.displayField == 'key')||(this.displayField == 'value')) ? this.displayField : "value";
        this.valueField = ((this.valueField == 'key') || (this.valueField == 'value')) ? this.valueField : "key";
        this.columns = ConditionUtils.df(this.columns, 4);
        this.rdName = this.id + "_rds";
        this.containerId = this.id + "_container";
        this.cutNum = this.cutNum;
    },
    _init : function(_data){
        var that = this;
        ConditionUtils.createChooseObjGroup({
            containerId : this.containerId,
            name : this.rdName,
            data : _data,
            cutNum : this.cutNum,
            valueField : this.valueField,
            displayField : this.displayField,
            columns : this.columns,
            type : "radio"
        });
        this._addEvent();
    },
    _addEvent : function(){
        var that = this;
        var radioContain = jQuery("#" + this.containerId + ">table");
        var rdName = this.rdName;
        jQuery.each(this.getRadios().find(".x-form-radio-wrap-inner"),function(index,n){
           jQuery(this).bind('click',function(){
               var currentRadioId = rdName + "_" + index;
               that.clickHandle(jQuery(this), radioContain, currentRadioId);
           });
        });
    },
    changeOptions : function(_data){
        this.clear();
        this._init(_data);
        this.checkItems();
    },
    isLoaded : function(){
        return true;
    },
    initDoms : function() {
        if (!this.container){
            this.container = jQuery("#" + this.containerId);
        }
        var h = this.groupHeight;
        h = parseInt(h);
        h = isNaN(h)?false:h;
        var w = this.groupWidth;
        w = isNaN(w)?false : w;    
        if (w){ 
            this.container.css({
                overflowX: "scroll",
                width : w + "px"
            });
        }
        var totalNum = this.getRadios().size();
        var rows = parseInt(totalNum/this.columns);
        if(totalNum % this.columns > 0){
        	rows += 1;
        }
        if(h && rows*16 > h) {
            this.container.addClass("cbb-cbgroup-ct");
            this.container.css({ 
                overflowY:"scroll"
            });
            this.container.css("height", h + "px");
        }
        this._addEvent();
    },

    initEvents : function() {
        this.events.push("itemClick");
    },

    beforeShowData : function() {
        this.clear();
        jQuery("#" + this.containerId).hide();
    },

    showData : function() {
        this._init(this.resultData.data);
    },

    afterShowData : function() {
        delete this.defaultValue;
        this.checkItems();
        jQuery("#" + this.containerId).show();
    },
    checkItems : function() {
        if (this.getRadios().size() > 0) {
            if (this.isTrue(this.disabled)){
                this.disable(true);
            }
 
            if (this.checkedItems) {
                this.selectRadio(this.checkedItems);
            } else {
                this.getRadios().first().find(".x-form-radio-wrap-inner").trigger('click');;
            }
            
            this.disableItems(this.disabledItems, true);
        }
    },

    beforeInitComplete : function() {
        this.checkItems();
    },
    reset:function(){
        this.checkItems();
        this.publishEvent("onValueChange");
    },
    clear : function() {
        jQuery("#" + this.containerId).empty();
    },
    getRadios : function(param) {
        var allRadio = jQuery("#" + this.containerId + ">table>tbody>tr>td").find('.x-form-radio-wrap');
        if (param){
            if (param.flag && param.flag == 'checked'){
                return allRadio.filter(".x-form-check-checked");
            }else if (param.flag && param.flag == 'enabled'){
                return allRadio.not(jQuery(".x-item-disabled"));
            }
        }
        return allRadio;
    },
    getValueWithText : function() {
        return this.getRadios({flag:'checked'}).map(function() {
            var inputElt = jQuery(this).find(":input[type='radio']");
            var title = inputElt.next().attr('title');
            var v = inputElt.attr('value');
            var t = inputElt.data("text");
            if(!t){
                t = jQuery.trim(inputElt.next().attr('title'));
            }
            
            return {
                value : v,
                text : t
            };
        }).get();
    },
    getSimpleValue : function() {
        return this.getRadios({flag:'checked'}).map(function(){
            return jQuery(this).find(":input[type='radio']").attr("value");
        }).get().join(",");
    },
    setValue : function(values){
        this.getRadios({flag:'checked'}).removeClass('x-form-check-checked');
        
        var that = this;
        jQuery.each(values, function(i, obj){
            that.selectRadio(obj["value"]);
        });
    },
     selectRadio: function(v) {
        this.getRadios({flag:'checked'}).removeClass('x-form-check-checked');
        var that = this;
        if (v) {
            that.getObjByValue(v).parent('div').parent('div').addClass('x-form-check-checked');
            that.getObjByValue(v).parent('div').trigger('click');
        }
    },
    getObjByValue : function(v){
        return jQuery("#" + this.containerId).find(":radio:[name=" + this.rdName
                    + "][value=" + v + "]");
        
        
    },
   	disableItems : function(ids, b) {
        var that = this;
        var arrIds;
        if (!ids) {
            return;
        }
        else if (ids == "all")
        {
            if (b){
                jQuery.each(this.getRadios(), function(index){
                var rd = jQuery(this).find(".x-form-radio-wrap-inner").unbind()
                                     .addClass('x-item-disabled');
                });
            }else{
                var radioContain = jQuery("#" + this.containerId + ">table");
                jQuery.each(this.getRadios({flag:'enabled'}).find(".x-form-radio-wrap-inner"), function(){
                   jQuery(this).bind('click',function(){
		               var currentRadioId = jQuery(this).find(":input[type='radio']").attr("id");
		               that.clickHandle(jQuery(this), radioContain, currentRadioId);		               
                   }).removeClass('x-item-disabled');
                });
            }
        }
        else
        {
            arrIds = ids.split(",");
            if (b){
                jQuery.each(arrIds, function(i, _id){
	                that.getObjByValue(_id).parent('div').unbind()
	                             .parent('div').addClass('x-item-disabled');
                });
            }else{
                var radioContain = jQuery("#" + that.containerId + ">table");
                jQuery.each(arrIds, function(i, _id){
	                   that.getObjByValue(_id).parent('div').bind('click',function(){
			               var currentRadioId = that.getObjByValue(_id).attr("id");
			               that.clickHandle(jQuery(this), radioContain, currentRadioId);
	                }).parent('div').removeClass('x-item-disabled');
                });
            }
        }
    },
    clickHandle : function(curObj, containObj, curRadioId){
        var that = this;
	    var otherRadioId = containObj.find(":input[id!='" + curRadioId + "']").parent('div').parent('div');
	    
        jQuery.each(otherRadioId,function(){
           jQuery(this).removeClass("x-form-check-checked");
        })
        if (!curObj.parent("div").hasClass("x-form-check-checked")){
           curObj.parent("div").addClass("x-form-check-checked");
        }
        that.publishEvent("onValueChange");      
    },
    disable : function(b){
       this.disableItems("all", b);
       this.isEnable=!b;
    },
    checkData : function() {
        if (this.required != undefined && this.isTrue(this.required)
                && this.getSimpleValue().length == 0) {
            return {
                success : false,
                msg : this.blankValidateText ,
                isRequiredFailed : true
            };
        } else {
            return {
                success : true,
                msg : ""
            };
        }
    },
    afterComplete : function(){
        this.checkItems();
    }
})));
};