ConditionMgr.functions["select"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.labelContainerId = this.id + "_label";
		this.containerId = this.id + "_container";
		this.cmbObj = null;
		this._keyF = ((this.valueField == 'key') || (this.valueField == 'value')) ? this.valueField : "key";
		this._valueF = ((this.displayField == 'key')||(this.displayField == 'value')) ? this.displayField : "value";
		this.initV;
        this.starLabelId ="starlbl_" + this.id;
		this.containerHelpId = this.id + "_help";		
		this.descId = "lbl_" + this.id;
	},
	isLoaded : function(){
		return this.cmbObj ? true : false;
	},
	changeOptions : function(_data){
        var that = this;
		this.clear();
		this.cmbObj = this._createCmbobox(_data);
		this.initV = this.getValueWithText().text;
		this.cmbObj.bind("change", function(event){
			that.publishEvent("onValueChange");
		});
		this.publishEvent("onValueChange");
	},
	initDoms : function(){
	    var that = this;
	    var starLabel = jQuery("<label/>").attr({
				id : that.starLabelId
			});
		$("#" + this.containerHelpId).append(starLabel);
		if(this.required){
		    starLabel.text("*").css("color","#D60606").css("padding-left","3px").css("vertical-align","middle");  
		}
		var descLabel = jQuery("<label/>").attr({
				id : that.descId
			});
		$("#" + this.containerHelpId).append(descLabel);
		
		if (that.desc){
		    var desc = that.desc;
            descLabel.text(desc).attr('title',that.desc).css("padding-left","3px"); 
		}
		
		this._init();
	},
	_createCmbobox: function(_data){
		var that = this;
		
        if (_data){
			return ConditionUtils.createSimpleSelect({
				id : that.id,
				container : "#" + that.containerId,
				name : that.id,
				data : _data,
				triggerSelected : true,
				emptyText : that.blankValidateText,
				key : that._keyF,
				value : that._valueF
			});
        }else{
            return jQuery("#"+this.id);
        }
	},
	_init : function(_data){
		var that = this;
		var container = jQuery("#" + this.containerId);
		if (_data){
			that.resultData.data = _data;
        }
        if (that.blankOption) {
	            var obj = {};
	            obj[that._keyF] = "";
	            obj[that._valueF] = that.blankOption;
	            that.resultData.data.unshift(obj);
        }
        this.cmbObj = this._createCmbobox(this.resultData.data);
		this.cmbObj.bind("change", function(event){
			that.publishEvent("onValueChange");
		});
		this.initV = this.getValueWithText().value;

		this.checkItems();
	},
	showData : function() {
		this.clear();
		this._init();
		this.publishEvent("onValueChange");
	},
	checkItems : function(){
		var that = this;
		this.disable(this.isTrue(this.disabled));
		if (this.defaultValue){
			this.cmbObj.val(this.defaultValue);
		}
	},
	afterShowData : function() {
		this.checkItems();
	},
	getValueWithText : function() {
		var tv = jQuery("#" + this.id + ">option:selected").text();
		var hv = this.cmbObj.val();
		if (tv != this.blankOption) {
			hv = hv == '' ? tv : hv;
		}
		return {
			value : hv,
			text : tv
		};
	},

	clear : function() {
		jQuery("#" + this.containerId).empty();
	},
	reset : function() {
		this.setValue(this.initV);
		this.checkItems();
		this.publishEvent("onValueChange");
	},
	getSimpleValue : function() {
		var tv = jQuery("#" + this.id + ">option:selected").text();
		var hv = this.cmbObj.val();
		if (tv != this.blankOption) {
			hv = hv == '' ? tv : hv;
		}
		return hv;
	},
	setValue : function(obj) {
		this.cmbObj.val(obj["value"]);
	},
	disable : function(b) {
		var that = this;
		jQuery("#" + that.id).attr("disabled", b);
		this.isEnable=!b;
	},
	checkData : function() {
		var resObj = {
			success : true,
			msg : '',
			isRequiredFailed : false
		};
		var v = this.getSimpleValue();
		if (!this.cmbObj || (this.cmbObj
				&& (this.isTrue(this.required) && (v == ''
						|| v == this.blankOption)))) {
			resObj.success = false;
			resObj.msg = this.blankValidateText;
			resObj.isRequiredFailed = true ;
		}
		return resObj;
	}
})));
};
