ConditionMgr.functions["SelectList"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
    	this.jid="#"+this.id;
    	this.containerId = this.id + "_container";
    	this.required = this.isTrue(this.required);
    	this.autoLoad = this.isTrue(this.autoLoad);
    	this.disabled = this.isTrue(this.disabled)
    	this.ctrlOptions = {
                add : {active:true, button:"btnAdd_"+this.id},
                remove:{active:true, button:"btnRemove_"+this.id},
                clean:{active:true, button:"btnClean_"+this.id},
                all:{active:true, button:"btnAll_"+this.id}
            };
            this._enable("remove", false);
            this._enable("clean", false);
            
	},
	_getButton : function(name){
                return $("#"+this.ctrlOptions[name].button);
            },
    _getJSelect : function(){
        return $("#" + this.id);
    },
    _enable : function(name, b){
               var oButton = this._getButton(name);
               LegoTag.setDisableds([this.ctrlOptions[name].button],!b);
            },
     _isEnabled : function(name){
         return this.ctrlOptions[name].active;
     },  
     _cleanSelectedEvent:function()
     {
     	this._cleanSelected() ;
     	this.validSelectEvent() ;
     } ,
     _cleanAllEvent:function()
     {
     	this._cleanAll() ;
     	this.validSelectEvent() ;
     },
    _cleanSelected:function(){
        var self = this;
		LegoTag.removeListBoxSelectedItems(this.id);
		SelectList.buttonsStatus(this.id);
    }, 
    _cleanAll:function(){
        LegoTag.removeListBoxAllItems(this.id)
        SelectList.buttonsStatus(this.id);
    }, 
	initDoms : function() {
		this._initRequest();
		this.initRequired();
	},
	initRequired: function()
	{
	},
	_initRequest:function()
	{
		var itemsData = this.data;
		if(!this.autoLoad)
	  	{
			if(typeof itemsData=="undefined" ||itemsData==null)
			{
				var items = this.defaultValue.split(",");
				itemsData=[];
				if(items.length%2==0)
				{
						for (var index=0,len=items.length,i=0;index<len;index=index+2,i++)   
						{
							itemsData[i]={};
							itemsData[i].value=items[index];
							itemsData[i].text=items[index+1];
						}		
				}
			}else
			{
				var items=itemsData;
				itemsData=[];
				if(items.length%2==0)
					{
							for (var index=0,len=items.length,i=0;index<len;index=index+2,i++)   
							{
								itemsData[i]={};
								itemsData[i].value=items[index];
								itemsData[i].text=items[index+1];
							}
					}
			}
			this.fillListData(itemsData);
		}
	},
	
	_existItem:function(optVal)
	{
        var self = this;
        var bExisted=false;
        var rows = LegoTag.getListBoxAllItems(this.id);
        $.each(rows, function(i, opt){
        	if(opt.value==optVal)
        	{
        		bExisted=true;
        	}
        	
        });
		return bExisted;
	},
	selectNodes:function(itemsData,singleAllowed)
	{
		if(singleAllowed)
		{
			this._cleanAll();
		}
		for (var index=0,len=itemsData.length;index<len;index++)   
		{
			    var value=$.trim(itemsData[index].value);
			    var text=$.trim(itemsData[index].text);
			    if(!this._existItem(value))
			    {
			    	this.fillItemData(value,text);
			    }
			}
			SelectList.buttonsStatus(this.id);
	}
	,
	initEvents : function() {
				var self = this;
                this._getButton("remove").bind("click", function(event){
                    if (self._isEnabled("remove")){
                        self._cleanSelectedEvent();
                        self._enable("remove", false);
                    }
                });
                this._getButton("clean").bind("click", function(event){
                    if (self._isEnabled("clean")){
                        self._cleanAllEvent();
                        self._enable("add", true);
                        self._enable("remove", false);
                        self._enable("clean", false);
                    }
                });
                this._getButton("all").bind("click", function(event){
                     if (self._isEnabled("all")){
                        self._enable("add", false);
                        self._enable("remove", false);
                        self._cleanSelectedEvent();
                     }
                });
                    this._getButton("all").hide();
	},
	beforeShowData : function() {
	},
	
	onShowData : function() {
		_log("debug",'showData');
		this.clear();
        this._init();
	},
	_init : function(){
	  _log("debug",'_init');
	  if(this.autoLoad)
	  {
	  		_log("debug",'设置了从Ajax数据源初始化数据');
			var itemsData = this.resultData.data;
			this.fillListData(itemsData);
		}
	        
    },
    fillListData : function(itemsData){
    		for (var index=0,len=itemsData.length;index<len;index++)   {
			    var value=$.trim(itemsData[index].text);
			    var text=$.trim(itemsData[index].value);
			    LegoTag.addListBoxItem(this.id,text,value,"SelectList.buttonsStatus('"+this.id+"');")
			}
    },
    fillItemData : function(value,text){
		LegoTag.addListBoxItem(this.id,text,value,"SelectList.buttonsStatus('"+this.id+"');");
    },
    reload:function(_data)
    {
    	this._cleanAll();
    	var itemsData =_data;
    	this.fillListData(itemsData);
    },
	afterShowData : function() {
		var self = this;
		this.checkItems();
	},
	checkItems : function() {
		if (this.disabled){
			this.disable(this.disabled);
		}
	},
	beforeInitComplete : function() {
		this.checkItems();
	},
	clear : function() {
		this._cleanAll();
		
	},
	reset : function(){
		this.checkItems();
	},
	getValueWithText : function() {
	   var retVals=[];      
       var rows = LegoTag.getListBoxAllItems(this.id);
        $.each(rows, function(i, opt){
        	var tmpVal=opt.value;
			var tmpText=opt.label;
			retVals.push({value:tmpVal,text:tmpText});
        });
		return retVals;
	},
	setValue : function(itemsData,singleAllowed) {
		if(singleAllowed)
		{
			this._cleanAll();
		}
		for (var index=0,len=itemsData.length;index<len;index++)   
		{
			    var value=$.trim(itemsData[index].value);
			    var text=$.trim(itemsData[index].text);
			    if(!this._existItem(value))
			    {
			    	this.fillItemData(value,text);
			    }
			}
			SelectList.buttonsStatus(this.id);
	},
	 validSelectEvent : function(){
	 	if(null != this.required && this.required == true)
	 	{
	 		LegoTag.validEvent(this.id) ;
	 	}
    } ,
	disable : function(b) {
		$(this.jid).attr("disabled", b);
		this.isEnable=!b;
	},
	checkData : function() {
			var resObj = {
				success : true,
				msg : '',
				isRequiredFailed : false
			};
			var v = this.getValueWithText();
			var len=v.length;
			if ((this.required && (len == 0))) {
				resObj.success = false;
				resObj.msg = this.blankValidateText;
				resObj.isRequiredFailed = true ;
			}
		return resObj;
	}
    })));
};
