ConditionMgr.functions["SelectShow"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
    this.jid="#"+this.id;
    this.descId = "lbl_" + this.id;
    this.containerId = this.id + "_container";
    this.textId = this.id+"_text";
    this.initialized=false;
	},
    onInitComplete:function()
    {
    	this.initialized=true;
    },
	initDoms : function() {
	 var that = this;
     this.container = jQuery("#" + this.containerId);
	 this.textId = jQuery("#" + this.text);
	 this.comboid = jQuery("#" + this.id + "-div");
	 if(this.defaultValue)   
     {
     	var kv=this.defaultValue.split(",");
     	if(kv.length==2)
     	{
     		params={value:kv[0], text:kv[1]};
     	}else
     	{
     		params={value:kv[0], text:kv[0]};
     	}
     }
      var descLabel = jQuery("<label/>").attr({
				id : that.descId
		});
	  that.comboid.append(descLabel);
	  if (that.desc){
		 descLabel.text($C.truncationStr(that.desc, labelLength)).addClass("ireport-ui-label").attr("title", that.desc).css("padding-left","5px");
	  }
     this.setValue(params);
	},
	beforeShowData : function() {
	},
	showData : function() { 
	},
	afterShowData : function() {
		var that = this;
		this.checkItems();
	},
	checkItems : function() {
		if (this.isTrue(this.disabled)){
            this.disable(this.isTrue(this.disabled));
        }
	},
	beforeInitComplete : function() {
		this.checkItems();
	},
	clear : function() {
		jQuery("#" + this.containerId).empty();
	},
	reset : function(){
		this.setValue(this.initV);   
		this.checkItems();
		this.publishEvent("onValueChange");
	},
	getValueWithText : function() {
		var retVals=new Array();
		var text = $(this.jid).val().trim();
		var value = $(this.jid).val().trim();  
		if(text!='')
		{
			retVals[0]={value : value,text : text};    	
		}
		return retVals;
	},
	getSimpleValue : function() {
		var text = $(this.jid).val().trim();
		var value = $(this.jid).val().trim();
		return {value : value,text : text};
	},
	setValue : function(values) {
		if (values != undefined) {
			$(this.jid).val(values["text"]);
			$(this.jid).val(values["value"]);
			if(this.initialized)
			{
				$(this).trigger("onValueChange", this);
			}
		}
	},
	setNoValueChangeValue : function(values) {
		if (values != undefined) {
			$(this.jid).val(values["text"]);
			$(this.jid).val(values["value"]);
		}
	},
	disable : function(bn) {
	  $(this.jid).attr("disabled", bn);
	  $(this.jid).removeAttr("onclick").css("cursor","default");
       this.isEnable=!bn;
	},
	_check:function(obj)
	{
		var text = $(this.jid).val().trim();
		var value = $(this.jid).val().trim();
		if(text==''&& value=='')
		{
			return false;
		}
		
		return true;
	},
	checkData : function() {
			var rstObj = {
					success : true,
					msg : '',
					isRequiredFailed : false
				};
			var items=this.getValueWithText();
			if (this.required && items.length==0) {
				rstObj.success = false;
				rstObj.msg = this.blankValidateText;
				rstObj.isRequiredFailed = true ;
			} else if (!this._check(this)) {
				rstObj.success = false;
				rstObj.msg = this.invalidText ? this.invalidText : this.blankValidateText;
			}
			return rstObj;
	}
		
    })));
};