ConditionMgr.functions["simpleDate"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.fieldId = this.id;						
		this.fieldName = this.id + "_n";						
		this.containerId = this.id + "_container";				
		this.descId = "lbl_" + this.id;
		this.dateConfig = getDateConfig(this);
		if(this.dateConfig === "")
		{
			this.dateConfig = "dateFmt:'"+Date_const.defaultDateFmt+"'";
			this.dateFmt = Date_const.defaultDateFmt;
		}
		
		this.containerHelpId = this.id + "_help";				
		this.descId = "lbl_" + this.id;
	},

	initDoms : function() {
		this.container = jQuery("#" + this.id);
		var that = this;

		this.container.val(toStringByPattern(new Date(),that.dateFmt));
		
		
		var descLabel = jQuery("<label/>").attr({
				id : this.descId
			});
		$("#"+this.containerHelpId).append(descLabel);
		
		if (this.desc){
			if(that.required){
				descLabel.text(that.desc).addClass("ireport-ui-label").css("padding-left","10px");
			}else{
			    descLabel.text(that.desc).addClass("ireport-ui-label");
			}	
		}
	},

	initEvents : function() {
	},

	beforeShowData : function() {
		this.clear();
	},

	showData : function() {
	},

	afterShowData : function() {
		var that = this;
		jQuery("#" + that.fieldId).bind("change", function(event){
			var target = event.target;
			if (target.value !== ""){
				jQuery("#" + that.descId).text(target.value).attr("title", target.value);
			}
		});
		this.checkItems();
	},
	checkItems : function() {
		this.disable(this.isTrue(this.disabled));
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		jQuery("#" + this.containerId).empty();
	},

	getValueWithText : function() {
		var v = jQuery("#"+this.fieldId).val();
		return {value:getLongTimeByFmt(v),text:v};
	},
	getSimpleValue : function() {
		var v = jQuery("#"+this.fieldId).val();
		return {value:getLongTimeByFmt(v),text:v};
	},

	setValue : function(v) {
		if (null !== v && v !== undefined){
			jQuery("#" + this.fieldId).val(v.text);
		}
	},
	disable : function(b) {
		var bn = b ? true : false;
		jQuery("#" + this.fieldId).attr("disabled", b);
		this.isEnable=!bn;
	},
	checkData : function() {
		var rstObj = {
			success : true,
			msg : '',
			isRequiredFailed : false
		};
		var v = jQuery("#"+this.fieldId).val();
		if (this.isTrue(this.required) && v == '') {
				rstObj.success = false;
				rstObj.msg = $RRs.comm_vail_date;
				rstObj.isRequiredFailed = true ;
		} 
		else if(!isCorrectFormat(this.dateFmt,v))
		{
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
		}
		else 
		{
				success = true;
				msg = "";
		}
		return rstObj;
	}
})));
};