ConditionMgr.functions["textArea"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.labelContainerId = this.id + "_label";
		this.fieldName = this.id + "_n";
		this.containerId = this.id + "_container";
		this.descId = "lbl_" + this.id;
	},

	initDoms : function() {
		this.jContainer = jQuery("#" + this.containerId);

		var that = this;
		var jTextArea = jQuery("#"+this.id);
		
		
		var len;
		if(this.textLength) {
			len = parseInt(this.textLength);
			len = isNaN (len)?false:len;
		}
		if(len) {
			jTextArea.keydown(function(e){
				if(this.value.length <= len) 
					this.oldText = this.value;
			}).bind("keyup blur", function(){
				if(this.value.length > len) {
					this.value = this.oldText;
				}
			})
		}
		
		var jDesLabel = jQuery("<label/>").addClass("cbb-textarea-destext").attr("id", this.descId).appendTo(this.jContainer);
		if(this.desc) {
            jDesLabel.text($C.truncationStr(this.desc, 10)).attr("title", this.desc);
		}
	},

	initEvents : function() {
	},

	beforeShowData : function() {
		this.clear();
	},

	showData : function() {
	},

	afterShowData : function() {
		this.checkItems();
	},
	checkItems : function() {
		if (this.disabled){
			this.disable(this.isTrue(this.disabled));
		}
		if(this.initValue) {
			jQuery("#"+this.id).val(this.initValue);
		}
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		jQuery("#" + this.containerId).empty();
	},
	reset : function(){
		jQuery("#"+this.id).val("");
		this.checkItems();
	},
	getValueWithText : function() {
		var v = jQuery("#"+this.id).val();
		return {value:v,text:v};
	},
	getSimpleValue : function() {
		return jQuery("#" + this.id).val();
	},

	setValue : function(obj) {
		if (obj != undefined){
			jQuery("#" + this.id).val(obj["value"]);
		}
	},
	disable : function(bn) {
		jQuery("#" + this.id).attr("disabled", bn);
		this.isEnable=!bn;
	},
	checkData : function() {
		if (this.required != undefined && this.isTrue(this.required) && this.getSimpleValue() == '') {
			return {
				success : false,
				msg : this.blankValidateText ,
				isRequiredFailed : true
			};
		} else {
			return {
				success : true,
				msg : ""
			};
		}
	}
})));
};