ConditionMgr.functions["textField"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.labelContainerId = this.id + "_label";
		this.fieldName = this.id + "_n";
		this.containerId = this.id + "_container";
		this.descId = "lbl_" + this.id;
		this.starLabelId ="starlbl_" + this.id;
		this.flag = true;
		this.invalidText = "";
		this.size = this.size ? this.size : '';
		this.initValue = this.initValue ?this.initValue:'';
	},

	initDoms : function() {
		var that = this;
		this.container = jQuery("#" + this.containerId);
		var that = this;
		var _input = jQuery("#"+this.id);
		that.container.append(_input);
		if (that.size && !isNaN(that.size)){
			_input.attr("size", that.size);
		}

        var starLabel = jQuery("<label/>").attr({
				id : that.starLabelId
			});
		that.container.append(starLabel);
		var wrapId = "lbl_" + this.id;
		if(this.required && this.required=='true'){
		    starLabel.text("*").css("color","#D60606").css("padding-left","3px").css("vertical-align","middle");  
		}
		
		var descLabel = jQuery("<label/>").attr({
				id : that.descId
			});
		that.container.append(descLabel);
		if (that.desc){
			descLabel.text(that.desc).addClass("ireport-ui-label").attr("title", that.desc);
		}
		
	},
	_check : function(that){
		var jField = jQuery("#" + that.id);
			if (that.regex || that.minNum || that.maxNum) {
				jField.attr("title", "").css({
							"border-color":"",
							"border-style":""});
				var _expr = new RegExp(that.regex);
				if (!_expr.test(jField.val())) {
					that.flag = false;
					that.invalidText = that.regexText;
					jField.attr("regex", that.regex);
					jField.attr("regexText", that.regexText)
					.css({
							"border-color":"#D60606",
							"border-style":"solid"
							});
					return false;
				}
				if (that.minNum && !isNaN(that.minNum)) {
					var min = parseInt(that.minNum);
					if (min > parseInt(jField.val())) {
						that.flag = false;
						that.invalidText = that.regexText;
						jField.attr("regex", that.regex);
						jField.attr("regexText", that.regexText)
						.css({
							"border-color":"#D60606",
							"border-style":"solid"
							});
						return false;
					}
				}
				if (that.maxNum && !isNaN(that.maxNum)) {
					var max = parseInt(that.maxNum);
					if (max < parseInt(jField.val())) {
						that.flag = false;
						that.invalidText = that.regexText;
						jField.attr("regex", that.regex);
						jField.attr("regexText", that.regexText)
						.css({
							"border-color":"#D60606",
							"border-style":"solid"
							});
						return false;
					}
				}
				if(that.minNum && !isNaN(that.minNum) && that.maxNum && !isNaN(that.maxNum)){
					var max = parseInt(that.maxNum);
					var min = parseInt(that.minNum);
					if(min <=parseInt(jField.val()) && max >= parseInt(jField.val()))
					{
						that.flag = true;
						that.invalidText = that.regexText;
						jField.attr("regex", that.regex);
						jField.attr("regexText", "");
						jField.css({
								"border-color":"",
								"border-style":""});
						return true;
					}	
				}
			}
			that.flag = true;
			return true;
	},
	_checkEvent : function(event) {
		var that = event.data.target;
		that._check(that);
	},
	initEvents : function() {
		var that = this;
		jQuery("#" + that.id).bind("change blur",{target:that}, this._checkEvent);
		
		if (that.filterReg) {
			var _expr = new RegExp(that.filterReg);
			jQuery("#" + that.id).bind({
				keydown : function(event) {
					if (_expr.test(this.value)) {
						this.value = this.value.replace(_expr, "");
					}
				},
				keyup : function(event) {
					if (_expr.test(this.value)) {
						this.value = this.value.replace(_expr, "");
					}
				},
				paste : function(event) {
					var text = ConditionUtils.getClipboardText();
					if (_expr.test(text)) {
						return false;
					}
				}
			});
		}
	},

	beforeShowData : function() {
		this.clear();
	},

	showData : function() {
	},

	afterShowData : function() {
		var that = this;
		this.checkItems();
	},
	checkItems : function() {
		if (this.isTrue(this.disabled)){
			this.disable(this.isTrue(this.disabled));
		}
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		jQuery("#" + this.containerId).empty();
	},
	reset : function(){
		jQuery("#" + this.id).val("");
	},
	getValueWithText : function() {
		var v = jQuery("#" + this.id).val();
		return {
			value : v,
			text : v
		};
	},
	getSimpleValue : function() {
		return jQuery("#" + this.id).val();
	},

	setValue : function(obj) {
		if (obj != undefined) {
			jQuery("#" + this.id).val(obj["value"]);
		}
	},
	disable : function(bn) {
		jQuery("#" + this.id).attr("disabled", bn);
		this.isEnable=!bn;
	},
	checkData : function() {
		var rstObj = {
			success : true,
			msg : '',
			isRequiredFailed : false
		};
		if (this.isTrue(this.required)
				&& this.getSimpleValue() == '') {
			rstObj.success = false;
			rstObj.msg = this.blankValidateText;
			rstObj.isRequiredFailed = true ;
		} else if (!this._check(this)) {
			rstObj.success = false;
			rstObj.msg = this.invalidText ? this.invalidText : this.blankValidateText;
		}
		return rstObj;
	}
})));
};