ConditionMgr.functions["TimeCombina"] = function(configParams){
ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
	initProperties : function() { 
		this.fieldId = "txt_" + this.id;						
		this.fieldName = this.id + "_n";						
		this.containerId = this.id + "_container";				
		this.descId = "lbl_" + this.id;  
		this.dateConfig = getDateConfig(this); 
		this.startTimeId = this.id+"_startTimeId";
		this.endTimeId = this.id+"_endTimeId";
		this.startTimeLong = 0;
		this.endTimeLong = 0;
		if(this.dateConfig === "")
		{
			this.dateConfig = "dateFmt:'"+Date_const.defaultDateFmt+"'";
			this.dateFmt = Date_const.defaultDateFmt;
		}
		
		this.containerHelpId = this.id + "_help";			
		this.descId = "lbl_" + this.id;
	},

	initDoms : function() {
		var columns=this.columns;
		var initValue=this.initValue;
		var options='';						
		var maxNum = this.maxNum;
		var test = new RegExp(/^[0-9]$/).test(this.maxNum);
		if((this.maxNum == null) || (!test) ){   
			maxNum = 3;
		}
				
		for(var i=0;i<columns.split(",").length;i++){	
			options+="<option id='"+i+"' style='font-size:14px;'>"+columns.split(",")[i]+"</option>";
		}
		var html="<tr id='tr_append'>";
			html+="<td><select id='"+this.id+"_Start' name='icon1' class='simpleSelect' name='icon'>";
			html+=options;
			html+="</select></td><td align='center' width='22px' id='to'>-</td>";
			html+="<td><select id='"+this.id+"_End' name='icon2' class='simpleSelect' name='icon' onChange='javascript:revertBn(this, "+maxNum+");'>";
			html+=options;
		    html+="</select></td><td>&nbsp;<input id='_button' class='match' style='background-image: url(" +　"./iReport/images/add.gif" + ");' /></td>";
			html+="</tr>";
			$("#_tbodyInfo").append(html);
			$("select[name='icon1']").val(this.initValue.split(",")[0]);
			$("select[name='icon2']").val(this.initValue.split(",")[1]);				
			
			$("#_button").bind("click",function(){
				var max=$("td[id$=sign]").length;
				if(max < maxNum) {	
					var sign=new Date().getTime();
					var html="";
					if (navigator.userAgent.indexOf("MSIE")>0) { 
						html="<td id='"+sign+"_sign' style='padding-left:37px;'><select id='"+sign+"_Start' name='' class='simpleSelect'>";
					} else { 									 
						html="<td id='"+sign+"_sign' style='padding-left:25px;'><select id='"+sign+"_Start' name='' class='simpleSelect'>";
					}
					html+=options;
					html+="</select></td><td align='center' width='22px' id='"+sign+"'>-</td>";
					html+="<td id='"+sign+"'><select id='"+sign+"_End' name='' class='simpleSelect' onChange='javascript:revertBn(this, "+maxNum+");'>";
					html+=options; 
					html+="</select></td><td id='"+sign+"'>&nbsp;<input id='"+sign+"' class='match' style='background-image: url(" +　"./iReport/images/del.gif" + ");' onclick='javascript:removeTr(this, "+maxNum+");return false;' /></td>";				
					$("#tr_append").append(html);
					var obj = $("select[id$=_End]").get(max); 					    
					var nextTime = $(obj).val();
					$("select[id='"+sign+"_Start']").val(nextTime);
					$("select[id='"+sign+"_End']").val("24");
					this.style.color = "gray";
					this.disabled = true;
					if($("select[id='"+sign+"_End']").val() == 24){
						LegoTag.setDisableds( ["_button"], true);
					} else if($("td[id$=sign]").length == maxNum){
						LegoTag.setDisableds( ["_button"], true);
					}						
				 }
			});
       
		this.container = jQuery("#" + this.containerId);
		var that = this;
		that.startTime_txt = jQuery("#"+this.startTimeId);
		that.endTime_txt = jQuery("#"+this.endTimeId);
		that.startTimeLong = getLongTimeByFmt(that.startTime_txt.val());
		var startTimeStr = toStringByPattern(new Date(),"yyyy-MM-dd")+" 00:00:00";
		var endTimeStr = toStringByPattern(new Date(),"yyyy-MM-dd")+" 23:59:59";
		that.startTime_txt.val(startTimeStr.substr(0,that.dateFmt.length));
		
		that.endTime_txt.val(endTimeStr.substr(0,that.dateFmt.length));
		that.startTimeLong = getLongTimeByFmt(that.startTime_txt.val());  
		
		var descLabel = jQuery("<label/>").attr({
				id : this.descId
			});
		$("#"+this.containerHelpId).append(descLabel);
		
		if (this.desc){
			if(that.required == 'true'){
			descLabel.text(that.desc).css("padding-left","8px").attr('title',this.desc);
		    }else{
		    descLabel.text(that.desc).attr('title',this.desc);
		    }
		}
		if(this.visible === 'false'){
			$("table[id='timeSection']").hide();
		}
	},
    getCheckParam : function(){
        var that = this;
        return {
            startTimeLong : that.startTimeLong,
            endTimeLong : that.endTimeLong
        };
    },

	initEvents : function() {
	},
	
	beforeShowData : function() {
		this.clear();
	},

	showData : function() {
	},

	afterShowData : function() {
		var that = this;
		jQuery("#" + that.fieldId).bind("change", function(event){
			var target = event.target;
			if (target.value !== ""){
				jQuery("#" + that.descId).text(target.value).attr("title", target.value);
			}
		});
		this.checkItems();
	},
	checkItems : function() {
		this.disable(this.disabled);		
		if(this.initValue.split(",")[1] == 24)
		{
			LegoTag.setDisableds( ["_button"], true);
		}
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		jQuery("#" + this.containerId).empty();
	},

	getValueWithText : function() {
		return this.getSimpleValue();
	},
	getSimpleValue : function() {
			this.setTimeByText();  
		var startTime = toStringByPattern(new Date(this.startTimeLong*1000),"yyyy-MM-dd HH:mm:ss");
		var endTime = toStringByPattern(new Date((this.endTimeLong)*1000),"yyyy-MM-dd HH:mm:ss");
		var lastTime = this.endTimeLong+1*60*60*23+59*60+59;
		var result='';
		if($("select").attr("disabled")==false){    
			var num = $("td[id$=sign]").length + 1;	
			for (var i=0; i<num; i++)
			{   
				var first = i * 2;
				var sencond = first + 1;
				var start = $("select:eq(" + first + ")").val() + ",";
				if(sencond == num*2-1){
					var end = $("select:eq(" + sencond + ")").val() + " ";
				}else{
					var end = $("select:eq(" + sencond + ")").val() + "; ";
				}	
				result += (start + end);						
			}
		}
		if(result !=''){
			result=result.substring(0,result.length-1);
		}
		var state = '';
		var today = (new Date()).getDate();
		today = new Date();
		sinceSec = today.getTime()/1000;
		dayMaxSize = (sinceSec - this.startTimeLong)/(1*60*60*24) - 1;
		daySize = (this.endTimeLong - this.startTimeLong)/(1*60*60*24);
		if(dayMaxSize > this.maxSize){
		    state = 'off';
		} else if(daySize > this.size){
			state = 'off';
		} else{
			state = 'on';
		}
		return [{value:""+this.startTimeLong , text: startTime},{value: ""+lastTime ,text:(endTime.split(" ")[0]+" 23:59:59")},{value:""+result,text:""+result},{state: ""+state}];
	},
	setValue : function(v) {
		if (null != v && v != undefined){
			this.startTimeLong=getLongTimeByFmt(v[0].text);
			this.endTimeLong=getLongTimeByFmt(v[1].text);
			this.startTime_txt.val(v[0].text);
			this.endTime_txt.val(v[1].text);
		}
	},
	disable : function(b) {
		var bn = (b === 'true') ? true : false;
		if(bn)
		{          		
			LegoTag.setDisableds( [this.startTimeId], true);
			LegoTag.setDisableds( [this.endTimeId], true);
			LegoTag.setDisableds( ["tr_append"], true);
			$("select").attr("disabled","true");
			LegoTag.setDisableds( ["_button"], true);	
		}
		else
		{
			LegoTag.setDisableds( [this.startTimeId], false);
			LegoTag.setDisableds( [this.endTimeId], false);
			LegoTag.setDisableds( ["tr_append"], false);
			$("select").removeAttr("disabled");
			LegoTag.setDisableds( ["_button"], false);
		}
		this.isEnable=!bn;
	},
	validateStartDate: function (){
    var elDateTime=document.getElementById(this.startTimeId);
  	var dateVal = $.trim(elDateTime.value);
  	var dateFormat = LegoTag.getDateFormat(Ext.get(elDateTime));
    var retDate = Date.parseDate(dateVal, dateFormat);
    
    if(retDate && retDate.format(dateFormat)!=dateVal)
    {
    	return false;
    }
    if(retDate)
    {
    	return true;
    }
    return false;
  },
 validateEndDate: function (){
    var elDateTime=document.getElementById(this.endTimeId);
  	var dateVal = elDateTime.value;
  	var dateFormat = LegoTag.getDateFormat(Ext.get(elDateTime));
  	
    var retDate = Date.parseDate(dateVal, dateFormat);
    if(retDate && retDate.format(dateFormat)!=dateVal)
    {
    	return false;
    }
    if(retDate)
    {
    	return true;
    }
    return false;
  },
	checkData : function() {
	    this.setTimeByText();
		var rstObj = {
			success : true,
			msg : '',
			isRequiredFailed : false
		};
		if(this.validateStartDate()!==true)
		{
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
			return rstObj;
		}
		if(this.validateEndDate()!==true)
		{
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
			return rstObj;
		}
		
		if (this.isTrue(this.required) && (this.startTime_txt.val()==''|| this.endTime_txt.val()=='')) {
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date;
			rstObj.isRequiredFailed = true ;
		}else if(!isCorrectFormat(this.dateFmt,this.endTime_txt.val())){
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
		}else if(!isCorrectFormat(this.dateFmt,this.startTime_txt.val())){
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
		}else if (!this.checkStartAndEndDate()) {
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_dateonly_error;
		}
		else if (!this.checkStartAndEndTime()) {
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_time_error;
		}else if (!this.checkTimeSectionOrder()) {
			rstObj.success = false;
			rstObj.msg = this.subLabel + $RRs.comm_vail_sectionOrder_error;
		}else if (!this.checkTimeSection()) {
			rstObj.success = false;
			rstObj.msg = this.subLabel + $RRs.comm_vail_section_error;
		}
		return rstObj;
	},
	setTimeByText:function()
	{ 
		this.startTimeLong = getLongTimeByFmt(this.startTime_txt.val());
		this.endTimeLong = getLongTimeByFmt(this.endTime_txt.val());
	},
	
	checkStartAndEndDate:function()
	{
		var that = this;
		if(that.startTimeLong > that.endTimeLong)
		{
			return false;
		}
		return true;
	},
	checkEndDate:function()
	{
		var that = this;
		var curTimeLong =new Date().getTime();	
		curTimeLong = curTimeLong/1000;
		if(that.endTimeLong > curTimeLong)
		{
			return false;
		}
		return true;
	},
	checkStartAndEndTime:function()
	{
		for (var i=0; i<$("td[id$=sign]").length+1; i++)
		{   
			var first = i * 2;
			var sencond = first + 1;
			var start = parseInt($("select:eq(" + first + ")").val());
			var end = parseInt($("select:eq(" + sencond + ")").val());
			if(start >= end)
			{
				return false;
			}			
		}
		return true;
	},
	checkTimeSectionOrder:function()
	{
		for (var i=0; i<$("td[id$=sign]").length+1; i++)
		{
			var first = i * 2;
			var start = parseInt($("select:eq(" + first + ")").val());
			for (var j=i+1; j<$("td[id$=sign]").length+1; j++)
			{
				var next = j * 2;
				var startNext = parseInt($("select:eq(" + next + ")").val());
				if(startNext < start)
				{
					return false;
				}
			}
		}
		return true;		
	},
	checkTimeSection:function()
	{
		for (var i=0; i<$("td[id$=sign]").length+1; i++)
		{
			var first = i * 2;
			var sencond = first + 1;
			var start = parseInt($("select:eq(" + first + ")").val());
			var end = parseInt($("select:eq(" + sencond + ")").val());
			for (var j=i+1; j<$("td[id$=sign]").length+1; j++)
			{
				var next = j * 2;
				var startNext = parseInt($("select:eq(" + next + ")").val());
				if((startNext >= start) && (startNext < end))
				{
					return false;
				}
			}
		}
		return true;		
	}
			
})));
};
function removeTr(obj, maxNum){
	$("td[id*='"+obj.id+"']").remove();
	var max = $("td[id$=sign]").length;
	var last = max * 2 + 1;
	var end = $("select:eq(" + last + ")").val();
	if (end == 24){
		LegoTag.setDisableds( ["_button"], true); 
	} else {
 		LegoTag.setDisableds( ["_button"], false);
 	}
}
function revertBn(obj,maxNum){ 	
	var selectedValue = obj.options[obj.selectedIndex].text;
	var max = $("td[id$=sign]").length + 1;		 
	if(selectedValue == 24){
		LegoTag.setDisableds( ["_button"], true); 			
	} else if((selectedValue < 24) && (max < maxNum)){
		LegoTag.setDisableds( ["_button"], false);
	} 
} 
