ConditionMgr.functions["tree"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.labelContainerId = this.id + "_label";
		this.containerId = this.id + "_container";
		this.jTreeObj = null;
		this.data;
	},
	showData : function(){
		if (!this.data){
			this.data = this.resultData.data;
		}
		this._create(this.data);
	},
	selectAllNodes : function(b){
		if (this.jTreeObj){
			jQuery.each(this.jTreeObj.getSelectedNodes(), function(i, _nd){
				_nd.select(b);
			});
		}
	},
	_create : function(_data){
		var that = this;
		ConditionUtils.createTree({
			treeId : that.containerId,
			doc : document,
			minExpandLevel : ConditionUtils.df(that.minExpandLevel, 1),
			data : _data,
			selectMode : that.selectMode == undefined ? "multi-hier" : that.selectMode,
			checkbox : that.showCheckbox == undefined ? true : that.showCheckbox
		});
		this.jTreeObj = jQuery("#" + that.containerId).dynatree("getTree");
	},
	checkItems : function(){
		this.expandAllNode(this.isTrue(this.expandAll));
		if(this.isLoaded()){
			if (this.defaultValue){
				this.selectNodes(this.defaultValue, true);
			}
		}
		this.disable(this.isTrue(this.disabled));
	},
	afterShowData : function(){
		this.checkItems();
	},
	getValueWithText : function() {
		var that = this;
		if (this.jTreeObj){
			return jQuery(this.jTreeObj.getSelectedNodes()).map(function(){
				if (that.isTrue(that.leafNodeValueOnly)){
					if (this.childList === null)
					return {
						value : this.data.key,
						text : this.data.title
					};
				}else{
					return {
						value : this.data.key,
						text : this.data.title
					};
				}
			}).get();
		}else{
			return [];
		}
	},
	getSimpleValue : function() {
		if (this.jTreeObj){
			return jQuery(this.jTreeObj.getSelectedNodes()).map(function(){
				if (that.isTrue(that.leafNodeValueOnly)){
					if (this.childList === null){
						return this.data.key;
					}
				}else{
					return this.data.key;
				}
			}).get().join(",");
		}else{
			return "";
		}
		
	},
	clear : function() {
		jQuery("#"+this.containerId).empty();
	},
	reset : function() {
		this.selectAllNodes(false);
		this.checkItems();
	},
	expandAllNode : function(b){
		if (this.jTreeObj){
			this.jTreeObj.getRoot().visit(function(dtnode){
			    dtnode.expand(b);
			});
		}
	},
	setValue : function(values){
		var that = this;
		this.selectAllNodes(false);
		jQuery.each(values, function(i, obj){
			that.selectNodes(obj["value"], true);
		});
	},
	selectNodes : function(values, flag) {
		flag = flag==undefined ? true : flag;
		var that = this;
		if (this.jTreeObj && values){
			var arrIds = values.split(",");
			jQuery.each(arrIds, function(i, v){
				var _node = that.jTreeObj.selectKey(v, flag);
				if (_node){
					if (flag)_node.activate();
					else _node.deactivate();
				}
			});
		}
	},
	removeAllNodes : function(){
		if (this.jTreeObj){
			this.jTreeObj.getRoot().removeChildren();
		}
	},
	isLoaded : function(){
		return this.jTreeObj?true:false;
	},
	addNodes : function(_data){
		if (this.jTreeObj){
			this.jTreeObj.getRoot().addChild(node);
		}
	},
	getNodeByKey : function(key){
		if (this.jTreeObj){
			return this.jTreeObj.getNodeByKey(key);
		}
		return null;
	},
	removeNodeByKey : function(key){
		if (this.jTreeObj){
			this.jTreeObj.getNodeByKey(key).remove();
		}
	},
	disable : function(b) {
		if (b){
			jQuery("#" + this.containerId).dynatree("disable");
			this.expandAllNode(false);
		}
		else{
			jQuery("#" + this.containerId).dynatree("enable");
			this.expandAllNode(this.isTrue(this.expandAll));
		}
			
		this.isEnable=!b;
	},
	checkData : function() {
		var that = this;
		var len = that.getValueWithText().length;
		var resultObj = {
			success : true,
			msg : len,
			isRequiredFailed : false
		};
		
		if (this.isTrue(that.required) && len === 0){
				resultObj.success = false;
				resultObj.msg = that.blankValidateText;
				resultObj.isRequiredFailed = true;
		}else if (that.maxNum && len > that.maxNum){
			resultObj.success = false;
			resultObj.msg = $RRs.tree_alert_before+" "+ that.maxNum +" "+$RRs.tree_alert_after;
		}
		return resultObj;
	}
})));
};
