ConditionMgr.functions["trigger"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
        this.fieldName = this.id + "_n";
        this.containerId = this.id + "_container";
        this.selectInfoId = "winGridSelectBtn_" + this.id;
        this.containerHelpId = this.id + "_help";				
        this.descId = "lbl_" + this.id;
        this.activesId = null;
        this.activesObj = null;
        this.relationIds = [];
        this.prevId = null;
        var trigger = this;
        this.OptionMgr = {
            options : {
                add : {active:true, button:jQuery("#winGridSelectBtn_" + trigger.id + "-img")},
                remove:{active:true, button:jQuery("#winGridDeleteBtn_" + trigger.id)},
                clean:{active:true, button:jQuery("#winGridClearBtn_" + trigger.id)},
                all:{active:true, button:jQuery("#winGridAllBtn_" + trigger.id)}
            },
            enable : function(name, b){
               var op = this.options[name];
               if (op){
                    if (b){
                        this.options[name].button.removeClass("a-grid-disable").addClass("a-grid-enable");
                    }else{
                        this.options[name].button.removeClass("a-grid-enable").addClass("a-grid-disable");
                   }
                  this.options[name].active = b;
               }
            },
            isEnabled : function(name){
                return this.options[name].active;
            },
            getButton : function(name){
                return this.options[name].button;
            },
            initEvent : function(){
                var that = this;
                var select = trigger.getJSelect();
                this.getButton("remove").bind("click", function(event){
                    if (that.isEnabled("remove")){
                        jQuery.each(select.children(":selected"), function(k, op){
                            trigger.remove(jQuery(op).data("value"));
                        });
                        trigger.change("remove");
                    }
                });
                this.getButton("add").bind("click", function() {
                   if ( that.isEnabled("add") && trigger.getActivesObject() &&  trigger.getActivesObject().show){
                        trigger.getActivesObject().show();
                    }
                });
                this.getButton("clean").bind("click", function(event){
                    if (that.isEnabled("clean")){
                        trigger.cleanSelected();
                        that.enable("add", true);
                        that.enable("remove", true);
                         trigger.change("clean");
                    }
                });
                this.getButton("all").bind("click", function(event){
                     if (that.isEnabled("all")){
                        that.enable("add", false);
                        that.enable("remove", false);
                        trigger.cleanSelected();
                        trigger.change("all");
                        if (trigger.getActivesObject()){
                            var vf = trigger.getActivesObject()["valueField"];
                            var df = trigger.getActivesObject()["displayField"];
                            var d = {};
                            jQuery.each(vf.split(","), function(i, f){
                                d[f] = "-1";
                            });
                            jQuery.each(df.split(","), function(i, f){
                                d[f] = iReport_Resources.comm_all;
                            });
                            trigger.addData([d], df);
                            if (trigger.getActivesObject().addData){
                                trigger.getActivesObject().addData(d);
                            }
                        }
                     }
                });
                if (!trigger.isTrue(trigger.showAllButton)){
                    this.getButton("all").hide();
                }
            }
        };
    },
    showRequired : function(flag){
        flag = flag == undefined ? true : false
        var f = jQuery("#" + this.selectInfoId+"_required");
        if (f.size() > 0){
            if (flag === true){
                f.show();
            }else{
                f.hide();
            }
        }else {
            if (flag === true){
                jQuery("#" + this.selectInfoId + "-div").append('<span id="' + this.selectInfoId + '_required" class="rendar-star">*</span>');
	        }
        }
    },
    change : function(type){
        this.optionType = type;
        this.publishEvent("onValueChange");
    },
    length : function(){
        return this.getValueWithText().length;
    },
    addRelationId:function(id){
        if (jQuery.inArray(id, this.relationIds) == -1){
            this.relationIds.push(id);
        }
    },
    remove:function(_obj){
        var select = this.getJSelect();
        var that = this;
        jQuery.each(select.children(), function(i, op){
            if (JSON.stringify(jQuery(op).data("value")) == JSON.stringify(_obj)){
                jQuery(op).remove();
            }
        });
        if (this.getActivesObject()){
             this.getActivesObject().removeData(_obj);
        }
    },
    cleanSelected:function(){
        var that = this;
        var prevObj = ConditionMgr.get(that.prevId);
        jQuery.each(jQuery("#"+this.selectInfoId).children(), function(i, op){
             that.remove(jQuery(op).data("value"));
             if (prevObj){
                prevObj.removeData(jQuery(op).data("value"));
             }
        });
        jQuery("#"+this.selectInfoId).children().remove();
    },
    getValueWithText:function(){
        if (this.getActivesObject() && this.getActivesObject().getValueWithText){
            return this.getActivesObject().getValueWithText();
        }
        return [];
    },
    getSimpleValue:function(){
         if (this.getActivesObject() && this.getActivesObject().getSimpleValue){
            return this.getActivesObject().getSimpleValue();
        }
        return "";
    },
    getActivesObject:function(){
        if (this.activesObj){
            return this.activesObj;
        }else{
            if (this.activesId){
                return ConditionMgr.get(this.activesId);
            }else if (this.relationIds.length > 0){
                return ConditionMgr.get(this.relationIds[0]);
            }
            this.activesObj = ConditionMgr.get(this.activesId)
            return this.activesObj;
        }
    },
    setActivesId:function(id){
        this.prevId = this.activesId;
        this.activesId = id;
        var obj = ConditionMgr.get(id);
        if (obj && obj.active){
            obj.active();
        }
        this.activesObj = obj;
    },
    initDoms : function() {
        this.OptionMgr.initEvent();
        var select = this.getJSelect();
        $("#" + this.selectInfoId).attr("readonly", true);
		var descLabel = jQuery("<label/>").attr({
				id : this.descId
			});
		$("#"+this.containerHelpId).append(descLabel);		
		if (this.desc && this.required == 'true'){
		    descLabel.text(this.desc).css('padding-left','13px').attr('title',this.desc);	
		} else if(this.desc){
			descLabel.text(this.desc).css('padding-left','5px').attr('title',this.desc);
		}
    },
    initEvents : function() {},
    beforeShowData : function() {},
    getJSelect : function(){
        return jQuery("#" + this.selectInfoId);
    },
    addData:function(arr, displayField, separator){
       separator = separator?separator:";";
       var dataArr = this.getJSelect().children().map(function(){
            return $(this).data("value");
       }).get();
       var that = this;
       if (arr && arr.length > 0){
            var buffer = [];
            var titleBuffer = [];
            var tmpStrArr = [];
           for(var i = 0; i < arr.length;i ++){
                var d = arr[i];
                if (d && displayField && ConditionUtils.inArray(d, dataArr) == -1){
                    buffer.push(d[displayField]);
                    var str = tmpStrArr.join(";");
                    if (str.length > 120){
                        titleBuffer.push(str);
                        tmpStrArr = [];
                    }else{
                        tmpStrArr.push(d[displayField]);
                    }
                }
            }
            titleBuffer.push(tmpStrArr.join(";"));
            var str = buffer.join(separator);
            that.getJSelect().val(str).attr("title", titleBuffer.join("; "));
       }
    },
    showData : function() {},
    afterShowData : function() {},
    checkItems : function() {},
    beforeInitComplete : function() {},
    clear : function() {
        jQuery("#" + this.containerId).empty();
    },
    reset : function(){
        if(this.getActivesObject()){
            this.getActivesObject().reset();
        }
    },
    getValueWithText : function() {
        if(this.getActivesObject()){
            return this.getActivesObject().getValueWithText();
        }
        return [];
    },
    getSimpleValue : function() {
        if(this.getActivesObject()){
            return this.getActivesObject().getValueWithText();
        }
        return "";
    },
    setValue : function(obj) {},
    disable : function(bn){
       this.getJSelect().attr("disabled", bn);
       for (var name in this.OptionMgr.options){
            this.OptionMgr.enable(name, !bn);
       }
        this.isEnable=!b;
    },
    checkData : function() {
        if (this.getActivesObject()){
            return this.getActivesObject().checkData();
        }else{
            return {success:true};
        }
    }

})));
};
