ConditionMgr.functions["winGrid"] = function(configParams){
	var testFlag = true;
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
        
        initProperties : function() {
            this.searchPrefix = "x-combo-list-inner-";
            var thisObj = this;
            this.descId = "lbl_" + this.id;
            this.__gValue = [];
            this.path = WEB_ROOT_ABS_PATH + "/showWinGrid.do";
            this.searchComboId = "serchFieldName";
            this.searchValueInputId = "serchFiledValue";
            this.queryLblId = "lbl_query";
            this.okBtnId = "btn_ok";
            this.cancelBtnId = "btn_cancel";
            this.searchBtnId = "btn_query";
            this.resetBtnId = "btn_reset";
            this.jGridTab = null;
            this.jTabBody = null;
            this.columnConfig = null;
            this.size = 0;
            this.windowIdPrefix = this.groupId + "_" + this.id;
            this.windowId = this.windowIdPrefix + "_Frame";
            this.valueMap = {};
            this.emptyOption = {
		        key: "",
		        value: $RRs.grid_empty_option
		    };
        },
        _getTrigger:function(){
            return ConditionMgr.get(this.triggerID);
        },
        removeData : function(d){
            var that = this;
            jQuery.each(this.__gValue, function(i, v){
                if (JSON.stringify(v) == JSON.stringify(d)){
                    that.__gValue.splice(i, 1);
                }
            });
        },
        addData:function(obj){
          this. __gValue.push(obj);
        },
        changeOptions : function(param){
            if (this.grid && this.grid.columnModels){
                this.grid.columnModels = null;
            }
            if (param["interfaceClass"]){
                $.ajax({
                    url : WEB_ROOT_ABS_PATH+"/conditionAjaxAction!changeGridDataSource.do",
                    type : "POST",
                    data : param,
                    dataType : "json",
                    success : function(result, textStatus) {
                    },
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                    },
                    complete : function(XMLHttpRequest, textStatus) {
                    },
                    async : false
                });
            }
        },
        show:function(){
            
            LegoTag.frameWindow(this.path,
                this.windowIdPrefix,
                "title='" + this.dialogTitle + "',height=550,width=500",
                false, function() {
            });
             this.createGrid();
             testFlag = true;
        },
        getDisplayField : function(){
            var df = this.displayField;
            if(!df) {
                $(this.grid.columnModels, function(i,cm) {
                    if(cm.name) df = cm.name;
                    return false;
                })
            }
            return df;
        },
        showSelectedInfo: function() {
        },
        initDoms: function() {
            var thisObj = this;
            this.disable(this.isTrue(this.disabled));
            this.showRequired();
        },
        getValueWithText : function() {
            if(!this.grid && !this.__gValue) return [];
            var vs = [];
            if(this.valueField) {
                var fs = this.valueField.split(",");
                var vo;
                var df = this.getDisplayField();
                $.each(this.__gValue, function(i,v){
                    if(v){
                        vo = {};
                        $.each(fs, function(j,f){
                            vo[f] = v[f];
                        });
                        vo[df] = v[df];
                        vs.push(vo);
                    }
                })
            } else {
                vs = this.__gValue;
            }
            return vs;
        },
        setValue : function(values){
            this.__gValue = [].concat(values);
            if (this._getTrigger()){
                this._getTrigger().addData(this.__gValue, this.getDisplayField());
            }
            this.showSelectedInfo();
            this.publishEvent("onValueChange");
        },
        getSimpleValue : function() {
            if (this.grid){
                return this.getValueWithText();
            }else{
                return [];
            }
        },
        getColumnModels : function() {
            if(this.gridConfig.columnModels && this.gridConfig.columnModels.length > 0) {       
                return this.gridConfig.columnModels;
            } else {        
                var params = this.getParams(); 
                params["interfaceClassMethod"] = "getGirdColumnModels";     
                params["interfaceClassMethodParamTypes"] = "map";
                params['invokerParamString'] = JSON.stringify([{}]);
                var ops = this.getOtherParams();
                $.extend(params, ops);
                var thisObj = this;
                $.ajax({
                    url : this.loadUrl,
                    type : "POST",
                    data : params,
                    dataType : "json",
                    success : function(result, textStatus) {
                        thisObj.gridConfig["columnModels"] = result.data;
                    },
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                    },
                    complete : function(XMLHttpRequest, textStatus) {
                    },
                    async : false
                });
                
                return thisObj.gridConfig["columnModels"];
            }
        },
        getSearchParams: function(){
            var win = this.getLegoFrameWindow();
            var searchName = win.LegoTag.getCombValue(this.searchComboId);
            var searchValue = $("#" + this.searchValueInputId, win.document).val().trim(); 
            var deviceregex = /^[a-zA-Z_0-9\u4e00-\u9fa5]{1}[\w\-\u4e00-\u9fa5\.]*$/;
            var collectorregex = /^[a-zA-Z_\u4e00-\u9fa5]{1}[\w\-\u4e00-\u9fa5]*$/;
            var rexIp = /^(\d{1,2}|1[013-9]\d|12[0-6]|12[89]|2[0-1]\d|22[0-3])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/;
            if(searchName == "deviceName")
            	{
				if(searchValue.length > 32)
					{					
					searchValue = searchValue.substring(0,32);
					}
            	if( searchValue != "" && deviceregex.test(searchValue)!=true)
            		{
            		LegoTag.Msg.alert(ResourceMgr.get("elog.common.info"),ResourceMgr.get("ireport.lego.ver.discovery.deviceName"));
            		return false;
            		}
            	}
            if(searchName == "collectorName")
        	{
        	if(searchValue != "" && collectorregex.test(searchValue)!=true)
        		{
        		win.LegoTag.Msg.alert(ResourceMgr.get("elog.common.info"),ResourceMgr.get("ireport.lego.ver.discovery.collectorName"));
        		return false;
        		}
        	}
            if(searchName == "ipAddress")
        	{
        	if(searchValue != "" && rexIp.test(searchValue)!=true)
        		{
        		win.LegoTag.Msg.alert(ResourceMgr.get("elog.common.info"),ResourceMgr.get("ireport.lego.ver.discovery.ipaddress"));
        		
        		return false;
        		}
        	}
            var result =  {
	            searchName: searchName,  
	            searchValue: searchValue 
	        }
            return result;
        },
        getOtherParams : function(){},
        getGridConfig : function() {
            var thisObj = this;
            var cfg = $.extend({},this.gridConfig);
            
            if(!cfg.columnModels || cfg.columnModels.length == 0) {
                cfg.columnModels = this.getColumnModels();
            }
            cfg.url = this.loadUrl;
            cfg.autoLoad = true;
            cfg.getParams = function() {            
                var params = thisObj.getCommonParams();
                params["interfaceClassMethod"] = "getGridData";
                params["interfaceClassMethodParamTypes"] = "map";
                var invokParams = {};
                if(thisObj.getSearchParams() == false)
                {
                	return false;
                }
                $.extend(invokParams, thisObj.getSearchParams());
                var ops = thisObj.getOtherParams();
                $.extend(invokParams, ops);
                params['invokerParamString'] = JSON.stringify([invokParams]);
                
                return params;
            }
            
            return cfg;
        },
        getLegoFrameWindow : function(){
            var win = window.parent.parent.document.getElementById(this.windowId).contentWindow;
	        return win;
        },
        buildGridHead : function(_cfg){
        	var that = this;
            if (_cfg && _cfg.columnModels && _cfg.columnModels.length > 0)
            {
                var _spIco = "<span></span>";
                var _spMove ="<span class='spliter-icon' style='cursor:col-resize;width:4;' onmousedown='LegoTag.mouseMove(this,event);'></span>"
                var _head = new StringBuffer();
                _head.append('<tr class="x-grid3-hd-row">')
                .append('<td style="width: 20px; padding: 0px 0px 0px 2px;">')
                .append('<div id="'+this.id+'_allCk" onclick="LegoTag.gridSelect(this,event)" onmousedown="LegoTag.gridSelectAll(this)" class="x-grid3-hd-checker">&nbsp;</div></td>')
                for (var i = 0; i < _cfg.columnModels.length; i++)
                {
                    var _column = _cfg.columnModels[i];
                    _head.append('<td class="cell-spliter" align="center" id="' + _column.name +'"');
                    if(this.isTrue(_column.sortable)){
                        _head.append(" style='cursor:pointer' onclick=sortTable('tab_gridList'," + (i+1) + ") ");
                    }
                    _head.append('>').append(_spMove).append(_spIco).append(_column.text).append('</td>');
                }
                
                _head.append('</tr>');
                 this.jTabBody.append(_head.toString());
                 this.setSelectedNum();
                 this.getLegoFrameWindow().$("#" + this.id + "_allCk").bind("mousedown", function(){
                 	var rows = that.getSelectedRows();
		        	if (rows){
		        		var num = rows.size();
		        		that.getLegoFrameWindow().$("#selectedNum").text(num);
		        	}
                 });
            }
        },
        buildGridRows : function(rowDatas){
            this.valueMap = {};
        	var that = this;
            var _cfg = this.columnConfig;
            var $ = this.getLegoFrameWindow().$;
            if (this.gridConfig.selector == "radio"){
                 this.jGridTab.addClass("x-grid-radio-tag");
                 this.jTabBody.find("tr:first>td:first").empty();
            }
            this.size = rowDatas.length;
            if (rowDatas && rowDatas.length > 0)
            {
                var _tbody =  this.jTabBody;
                var cbxStr = '<td width="20px" class="x-grid3-td-checker"><div name="div_checker" onmousedown="LegoTag.gridSelectCheck(this,event)" class="x-grid3-row-checker"> &nbsp;</div></td>';
                var trs = new StringBuffer();
                for (var i = 0; i < rowDatas.length; i++)
                {
                    var r = rowDatas[i];
                    var id = "tr_" + r[this.valueField];
                    trs.append('<tr class="x-grid3-row" id="' +id+ '" onmousedown="LegoTag.gridDown(this,event)" onmouseout="LegoTag.gridOut(this)" onmouseover="LegoTag.gridOver(this)">');
                    trs.append(cbxStr);
                    for (var j = 0; j < _cfg.columnModels.length; j++)
                    {
                        var cfg = _cfg.columnModels[j];
                        var text = r[cfg["name"]];
                        trs.append('<td align="center" title="')
                        .append(text).append('" class="x-grid3-table-cell">')
                        .append(text.replace(/</g,"&lt;").replace(/>/g,"&gt;")).append('</td>')
                    }
                    trs.append("</tr>");
                    this.valueMap[id] = r;
                }
                
                var eventFn = function(){
                       var rows = that.getSelectedRows();
                       if (rows){
                           var num = rows.size();
                           that.getLegoFrameWindow().$("#selectedNum").text(num);
                       }
                };
                
                _tbody.append(trs.toString());
                _tbody.find("div[name=div_checker]").bind("mousedown", eventFn);
                _tbody.find("tr:gt(0)").bind("mousedown", eventFn);
            }
            $("#totalNum").text(rowDatas.length);
        },
        createGrid : function() {
            var that = this;
            var win = this.getLegoFrameWindow();
            	$(win).load(function(){
                if(testFlag)
                {
	            var _tab = this.$("#tab_gridList");
                that.jGridTab = _tab;
                that.jTabBody = _tab.find("#tb_gridDataList");
                that.columnConfig = that.getGridConfig();
                that.buildGridHead(that.columnConfig);
                that.buildGridRows(that.getAjaxData());
                that.loadSearchComboData();
                that.initSearchComboEvent();
                that.initCommitBtnEvent();
                that.initSearchBtnEvent();
                that.initResetBtnEvent();
                that.fillBack();
                that.i18N();
                this.$("#div_gridTitle").parent().css("overflow","hidden");
                testFlag = false;
            	}});
        },
        showRequired : function(){
            if (this.isTrue(this.required)){
                if (this._getTrigger()){
                    this._getTrigger().showRequired();
                }
            }
        },
        i18N : function(){
            var $ = this.getLegoFrameWindow().$;
            if($("#" + this.queryLblId)){
              $("#" + this.queryLblId).text(ResourceMgr.get("elog.common.condition.title"));
            }
            
            $("#totalNumTitle").text(ResourceMgr.get("elog.device.stat.totle"));
            $("#selectedNumTitle").text(ResourceMgr.get("elog.device.stat.selected"));
        },
        setSelectedNum : function(){
        	var rows = this.getSelectedRows();
    		var num = rows.size();
    		this.getLegoFrameWindow().$("#selectedNum").text(num);
        },
        fillBack : function(){
            if (this.__gValue.length > 0){
                var win = this.getLegoFrameWindow(); 
                if (this.__gValue.length == 1 && this.__gValue[0][this.valueField] == -1){
                    this.jTabBody.find("tr:gt(0)").addClass("x-grid3-row-selected");
                    this.jTabBody.find("tr:first>td").addClass("x-grid3-hd-checker-on");
	            }else{
                    for (var i = 0; i < this.__gValue.length; i++){
	                    var r = this.__gValue[i];
	                    var v = r[this.valueField];
	                    win.$("#tr_" + v).addClass("x-grid3-row-selected");
	                }
	                if (this.__gValue.length == this.size){
	                	this.jTabBody.find("tr:first>td").addClass("x-grid3-hd-checker-on");
	                }
                }
            }
            this.setSelectedNum();
        },
        initResetBtnEvent : function(){
        	var $ = this.getLegoFrameWindow().$;
        	var that = this;
        	var resetBtn = $("#" + this.resetBtnId);
        	resetBtn.bind("click", function(event){
        		$("#" + that.searchValueInputId).val("");
        		that.jTabBody.empty();
                that.buildGridHead(that.columnConfig);
                that.buildGridRows(that.getAjaxData());
                that.fillBack();
        	});
        },
        initSearchBtnEvent : function(){
            var win = this.getLegoFrameWindow(); 
            var searchBtn = win.$("#" + this.searchBtnId);
            var that = this;
            searchBtn.click(function(event){
            	var resultData = that.getAjaxData()+"";
            	if(resultData !="")
            		{
            		if(that.getAjaxData() == false)
            			{
            			return false;
            			}
            		
            		}
                that.jTabBody.empty();
                that.buildGridHead(that.columnConfig);
                that.buildGridRows(that.getAjaxData());
            });
        },
        getSelectedRows : function(){
    		return this.jTabBody.find(">tr.x-grid3-row-selected");
        },
        initCommitBtnEvent : function(){
            var that = this;
            var win = this.getLegoFrameWindow(); 
            var $ = win.$;
            $("#" + that.okBtnId).click(function(event){
               var selectedRows = that.getSelectedRows();
               if (selectedRows.size() > 0){
                    if (!isNaN(that.maxNum) && selectedRows.size() > parseInt(that.maxNum))
                    {
                        win.LegoTag.Msg.alert(ResourceMgr.get("elog.common.info"), that.maxNumText);
                    }else{
                        var values = selectedRows.map(function(){
                          return that.valueMap[this.id];
	                    }).get();
	                   
	                    that.setValue(values);
	                    win.LegoTag.getSelfWindow().close();
                    }
               }else{
                   win.LegoTag.Msg.alert(ResourceMgr.get("elog.common.info"), that.blankValidateText);
               }
            });
        },
        initSearchComboEvent : function(){
            var that = this;
            var win = this.getLegoFrameWindow();
            var $ = win.$;
            var div = $("#" + this.searchPrefix + this.searchComboId);
	        this._beforeValue = win.LegoTag.getCombValue(this.searchComboId);
	        div.bind("click", function(event){
	            var t = event.target;
	            var _curValue = win.LegoTag.getCombValue(that.searchComboId);
	            if (t.tagName.toUpperCase() == "DIV" && $(t).hasClass("x-combo-list-item")){
	                if (_curValue != that._beforeValue){
                        $("#" + that.searchValueInputId).val("");
	                   that._beforeValue = _curValue;
	                }
	            }
	        });
        },
         refreshCombHeight: function(id, optionSize, simpledata)
	    {
            var $ = this.getLegoFrameWindow().$;
            var _h = 20 * optionSize;
            if($.browser.msie){
                _h = 22 * optionSize;
            }
            if(_h > 150)
            {
                _h = 150;
            }
            $('#x-combo-list-'+id).css('height', _h);
            $('#x-combo-list-inner-'+id).css('height', ""); 
            
            if(simpledata != undefined)
            {
                $('#'+id).attr('simpledata', simpledata);
            }
	    },
        loadSearchComboData : function()
        {
            var cfg = this.columnConfig;
            var searchField = cfg.searcher;
            if (searchField)
            {
            	var defaultKey = null;
            	var defaultValue = null;
                var simpleData = [];
                var fieldArr = searchField.split(",");
                for (var i = 0; i < fieldArr.length; i++)
                {
                    var f = fieldArr[i];
                    for (var j = 0; j < cfg.columnModels.length; j++)
                    {
                        if (cfg.columnModels[j]["name"] == f)
                        {
                             var text = cfg.columnModels[j]["text"];
                             this.getLegoFrameWindow().LegoTag.addCombItem(this.searchComboId, f, text); 
                             simpleData.push("[" + f, text + "]");
                             if (defaultKey == null){
                        		defaultKey = f;
                        	 }
                        	 if (defaultValue == null){
                        	 	defaultValue = text;
                        	 }
                             break;
                        }
                    }
                }
                this.getLegoFrameWindow().LegoTag.setCombValue(this.searchComboId, defaultKey, defaultValue);
                this.getLegoFrameWindow().LegoTag.setCombDisplay(this.searchComboId, defaultValue);
                this.refreshCombHeight(this.searchComboId, fieldArr.length, "[" + simpleData + "]");
            }
        },
        getAjaxData : function(){
            var thisObj = this;
            var datas = null;
            $(this).trigger("onBeforeLoadData",[thisObj]);
            
            if(!this.url) return ;
            if(this.getGridConfig().getParams() == false)
            {         	
            	return false;
            }
            $.ajax({
                url : this.loadUrl,
                type : "POST",
                async : false,
                data : this.getGridConfig().getParams(),
                dataType : "json",
                success : function(result, textStatus) {
                    if(!result || !result.data) {
                        result = {data:  {total : 0, rows: []}
                    }
                }
                    datas = result.data.rows;
                    $(thisObj).trigger("onAfterLoadData", {result:true, grid: thisObj});
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    $(thisObj).trigger("onAfterLoadData", {result:false, grid: thisObj});
                },
                complete : function(XMLHttpRequest, textStatus) {
                }
            });
            
            return datas;
        },
        checkData : function(){
            if (this.isTrue(this.required) && ( this.__gValue.length == 0)) {
                return {
                    success : false,
                    msg : this.blankValidateText,
                    isRequiredFailed : true
                };
            } else {
                return {
                    success : true,
                    msg : ""
                };
            }
        },
        reset : function(){
            var that = this;
            if (that.grid){
                this.grid.reset();
            }
        },
        disable : function(b){
            this.isEnable=!b;
        },
        destory : function() {
            if(this.grid && this.grid.destory)
                this.grid.destory();
            if(this.dialog && this.dialog.destory) {
                this.dialog.destory();
            }
        }
    })));
};
