ConditionMgr.functions["winTree"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
        var that = this;
        this.clickerBtnId = this.type + "_btn_" + this.id;
        this.containerId;
        this.jTreeObj=null;
        this.data;
        this.autoLoad = false;
        this.valueField = "value";
        this.displayField = "text";
        this.backFillValue = [];
        this._values = [];
        this.okBtnId = "btn_ok";
        this.cancelBtnId = "btn_cancel";
        this.dialogTitle = this.title;
        this.autoLoad = false;
        this.isCheckLevel = (this.checkLevel == undefined ? false : true);
        this.checkLevelInfo = (this.checkLevelInfo == undefined ? $RRs.winTree_checkLevelInfo : this.checkLevelInfo);
        
        this.path = WEB_ROOT_ABS_PATH + "/showWinTree.do"
        this.windowIdPrefix = this.groupId + "_" + this.id;
        this.windowId = this.windowIdPrefix + "_Frame";
        this.treeContainerId = "div_tree";
        this.leafNodesTotal = 0;
        
        
        this.descId = "lbl_" + this.id;
    },
    _getTrigger:function(){
        return ConditionMgr.get(this.triggerID);
    },
     addWinTreeDataInterface: function(selectValue)
    {
    },
    removeData : function(d){
        var that = this;
        jQuery.each(this._values, function(i, v){
            if (JSON.stringify(v) == JSON.stringify(d)){
                that._values.splice(i, 1);
                jQuery.each(that.backFillValue, function(j, e){
                    if (e == d[that.valueField]){
                        that.backFillValue.splice(j, 1);
                    }
                });
                that.selectNodes(d[that.valueField], false);
            }
        });
    },
    show:function(){
            LegoTag.frameWindow(this.path,
                this.windowIdPrefix,
                "title='" + this.dialogTitle + "',height=400,width=600",
                false, function() {
            });
            
            this.createTree();
            
    },
    getAjaxData : function(params){
        params["cdtType"] = this.type;
        var that = this;
        jQuery.ajax({
            url : "conditionAjaxAction.do?cfNameHF="+cfNameHF,
            type : "POST",
            data : params,
            dataType : "json",
            success : function(result, textStatus) {
                that.resultData = result;
                that._afterLoadData();
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
            },
            complete : function(XMLHttpRequest, textStatus) {
            },
            async : params.async == undefined ? true : params.async
        });
    },
    createTree : function(){
        var that = this;
        var win = this.getLegoFrameWindow();
        $(win).load(function(){
            that.loadAjaxData({async:false});
            var sel = that.selectMode == undefined ? "multi-hier" : that.selectMode;
	        var selMode = {
	            "single" : 1,
	            "multi" : 2,
	            "multi-hier" : 3};
	        win.$("#" + that.treeContainerId).dynatree({
	            checkbox: ConditionUtils.isTrue(that.showCheckbox == undefined ? true : that.showCheckbox),
	            selectMode: selMode[sel],
	            children: that.data,
	            minExpandLevel : ConditionUtils.df(that.minExpandLevel, 1),
	            rootVisible: false,
	            onActivate: function(dtnode){
	            },
	            onSelect: function(flag, dtnode) {
	                if (flag){
	                    dtnode.activate();
	                }
                    var num = that.getSelectValues().length;
                    win.$("#selectedNum").text(num);
                    if (!isNaN(that.maxNum)){
		                if (parseInt(that.maxNum) > that.leafNodesTotal){
		                    win.$("#limitNum").text(that.leafNodesTotal-num);
		                }else{
		                    win.$("#limitNum").text(that.leafNodesTotal-num<0?0:that.leafNodesTotal-num);
		                }
		            }else{
		                win.$("#limitNum").text(that.leafNodesTotal-num);
		            }
                    
	            },
	            onClick: function(dtnode, event) {
	                if( dtnode.getEventTargetType(event) == "title" )
	                    dtnode.toggleSelect(); 
	            },
	            onKeydown: function(dtnode, event) {
	                if( event.which == 32 ) {
	                    dtnode.toggleSelect();
	                    return false;
	                }
	            },
                onDeactivate : function(){
                    var num = that.getSelectValues().length;
                    win.$("#selectedNum").text(num);
                    if (!isNaN(that.maxNum)){
		                if (parseInt(that.maxNum) > that.leafNodesTotal){
		                    win.$("#limitNum").text(that.leafNodesTotal-num);
		                }else{
		                    win.$("#limitNum").text(that.leafNodesTotal-num<0?0:that.leafNodesTotal-num);
		                }
		            }else{
		                win.$("#limitNum").text(that.leafNodesTotal-num);
		            }
                },
	            cookieId: "ui-dynatree-Cb2",
	            idPrefix: "ui-dynatree-Cb2-"
	        });
	        that.jTreeObj = win.$("#"+that.treeContainerId).dynatree("getTree");
	        
	        that.initCommitBtnEvent();
            
            that.i18N();
            that.selectNodes(that.getSimpleValue());
            var selectNum = that.getSelectValues().length ;
            if (!isNaN(that.maxNum)){
                if (parseInt(that.maxNum) > that.leafNodesTotal){
                    win.$("#limitNum").text(that.leafNodesTotal-selectNum);
                }else{
                    win.$("#limitNum").text(that.leafNodesTotal-selectNum);
                }
            }else{
                win.$("#limitNum").text(that.leafNodesTotal-selectNum);
            }
            var selectNum = that.getSelectValues().length ;
            if(that.isTrue(that.selectAll) && (selectNum == 0 ||  selectNum == win.$("#totalNum").text())){
            	that.jTreeObj.getRoot().visit(function(dtnode){
            		dtnode.select(true);
            	});  
            	var num = that.getSelectValues().length;
        		win.$("#selectedNum").text(num);
        		if (!isNaN(that.maxNum)){
	                if (parseInt(that.maxNum) > that.leafNodesTotal){
	                    win.$("#limitNum").text(that.leafNodesTotal-num);
	                }else{
	                    win.$("#limitNum").text(that.leafNodesTotal-num<0?0:that.leafNodesTotal-num);
	                }
		        }else{
		            win.$("#limitNum").text(that.leafNodesTotal-num);
		        }
            }
        });       
    },
    showRequired : function(){
        if (this.isTrue(this.required)){
            if (this._getTrigger()){
                this._getTrigger().showRequired();
            }
        }
    },
    i18N : function(){
        var win = this.getLegoFrameWindow();
        win.$("#totalNumTitle").text($RRs.winTree_total);
        win.$("#selectedNumTitle").text($RRs.winTree_selected);
        win.$("#limitNumTitle").text($RRs.winTree_max_selected);
        win.$("#selectedNum").text(0);
    },
    getLegoFrameWindow : function(){
        var win = window.parent.parent.document.getElementById(this.windowId).contentWindow;
        return win;
    },
    addData:function(obj){
      this. _values.push(obj);
    },
    showWinTree:function(){
        this.show();
    },
    clearSelectedValue : function(){
        this.backFillValue = [];
    },
    initDoms: function() {
        this.showRequired();       
        if(this.initValue){
        	var params={value: "0", text: this.initValue};
        	this.setValue(params);
        }            
        
    },
    checkItems : function(){
        this.expandAllNode(this.isTrue(this.expandAll));
    },
    showData : function() {
        if (!this.data){
            this.data = this.resultData.data;
        }
    },
    initCommitBtnEvent: function(){
        var that = this;
        var win = this.getLegoFrameWindow();
        win.$("#" + this.okBtnId).click(function(){
            var nodes = that.getSelectValues();
            if (nodes.length > 0 || (this.required != 'true' && this.required != true)){
	            if (!isNaN(that.maxNum) && nodes.length > parseInt(that.maxNum) && that.leafNodesTotal !=nodes.length ){
	                win.LegoTag.Msg.alert(ResourceMgr.get("elog.common.info"), $RRs.tree_alert_before+" "+ that.maxNum +" "+$RRs.tree_alert_after);
	            }else{
	            	if((win.$("#selectedNum").text() == win.$("#totalNum").text()) && null != that.initValue && "" != that.initValue)
                   	{
                   		nodes = {
                        value : "0",
                        text : that.initValue,
                        type : that.data.type == null ? "" : that.data.type,
                        toString:function(){return JSON.stringify(this)}
                  		};
                   	}
                   	if(nodes.length == 0)
                   	{
                   		nodes = {};
                   	}
	                if (!that.setValue(nodes)){
	                	win.LegoTag.getSelfWindow().close();
	                } 
	                
	            }
            }else{
                win.LegoTag.Msg.alert(ResourceMgr.get("elog.common.info"), that.blankValidateText);
            }
        });
        this.checkItems();
    },
    afterShowData : function(){
        this.disable(this.isTrue(this.disabled));
        this.checkItems();
    },
    removeAllNodes : function(){
        if (this.jTreeObj){
            this.jTreeObj.getRoot().removeChildren();
        }
    },
    setValue : function(values){
    	var that = this;
        this._values = [].concat(values);
        var obj = this._values[0];
        var flag = false;
        if(typeof obj[0] == "undefined")
        {	
        	flag = obj.value;
        }
        else
        {
        	flag = obj[0].value;
        }
        if ( !flag && (this.required == 'true' || this.required == true)){
        	var win = window.parent.parent.parent.document.getElementById(this.windowId).contentWindow;
        	win.LegoTag.Msg.alert(ResourceMgr.get("elog.common.info"), that.blankValidateText);
        	return true;
        }
        else
        {
        	if (this._getTrigger()){
            	this._getTrigger().addData(this._values, this.displayField);
        	}
         	this.publishEvent("onValueChange");
        }
    },
    setTotal:function(num){
       this.leafNodesTotal = num;
	   this.getLegoFrameWindow().$("#totalNum").text(num);
    },
    selectNodes : function(values, flag) {
        var num = 0;
        flag = flag==undefined ? true : flag;
        var that = this;
        if (this.isLoaded()){
            var arrIds = values.split(",");
            that.jTreeObj.getRoot().visit(function(dtnode){
                if (!dtnode.hasChildren()){
                     num +=  1;
                    if (jQuery.inArray(dtnode.data.key, arrIds) != -1){
	                    dtnode.select(true);
	                    dtnode.activate();
	                }
                }
	        });
        }
        this.setTotal(num);
    },
    isLoaded : function(){
        if (this.jTreeObj) return true;
        return false;
    },
    addNodes : function(node){
        if (this.jTreeObj){
            this.jTreeObj.getRoot().addChild(node);
        }
    },
    getNodeByKey : function(key){
        if (this.jTreeObj){
            return this.jTreeObj.getNodeByKey(key);
        }
        return null;
    },
    removeNodeByKey : function(key){
        if (this.jTreeObj){
            this.jTreeObj.getNodeByKey(key).remove();
        }
    },
    checkData : function(){
        var that = this;
		var len = this._values.length;
		var resultObj = {
			success : true,
			msg : len,
			isRequiredFailed : false
	    };
		
		if (this.isTrue(that.required) && len === 0){
				resultObj.success = false;
				resultObj.msg = that.blankValidateText;
				resultObj.isRequiredFailed = true ;
		}else if (that.maxNum && len > parseInt(that.maxNum) && that.leafNodesTotal != len){
			resultObj.success = false;
			resultObj.msg = $RRs.tree_alert_before+" "+ that.maxNum +" "+$RRs.tree_alert_after;
		}
		return resultObj;
    },
    clear : function() {
        if (this.dialog){
            this.dialog.jBody.empty();
        }
    },
    selectAllNodes : function(b){
        if (this.jTreeObj){
            jQuery.each(this.jTreeObj.getSelectedNodes(), function(i, _nd){
                _nd.select(b);
            });
        }
    },
    reset : function(){
        var that = this;
        this.selectAllNodes(false);
        this.clearSelectedValue();
        this.checkItems();
    },
    expandAllNode : function(b){
    	try{
		       if (this.jTreeObj){
		            this.jTreeObj.getRoot().visit(function(dtnode){
		                dtnode.expand(b);
		            });
		       }
    	}catch(e)
    	{
    	}
    },
    getValueWithText: function(){
        var arr = [];
        jQuery.each(this._values, function(i, v){
            if(v){
                arr.push(v);
            }
        });
        return arr;
    },
    getSelectValues : function() {
        var that = this;
        if (this.jTreeObj){
            return jQuery(this.removeNodeTypeIsAll(this.jTreeObj.getSelectedNodes())).map(function(){
                if (that.isTrue(that.leafNodeValueOnly)){
                if (this.childList === null){
                    return {
                        value : this.data.key,
                        text : this.data.title,
                        type : this.data.type == null ? "" : this.data.type,
                        toString:function(){return JSON.stringify(this)}
                   	};
                 }
                }else{
                   if(this.data.children == null)
                    {
                        return {
                        	value : this.data.key,
                        	text : this.data.title,
                       		type : this.data.type == null ? "" : this.data.type,
                       		toString:function(){return JSON.stringify(this)}
                        };
                    }
                }
            }).get();
        }else if (this._values){
         	   return this._values;
        }
        else{
            return [];
        }
    },
    
    removeNodeTypeIsAll:function(array)
    {
        var returnArr = new Array();
        for(var i=0;i<array.length;i++)
        {
            if(array[i].data.type != "all")
            {
                returnArr.push(array[i]);
            }
        }
        return returnArr;
    },
    
    checkOptionLevel:function(array)
    {
        var returnArr = true;
        var level = 0;
        var length = array.length;
        if(length>0)
        {
            level = array[0].data.level;
        }
        else
        {
            return returnArr;
        }
        for(var i=0;i<length;i++)
        {
            if(level != array[i].data.level)
            {
                returnArr = false;
                return returnArr;
            }
        }
        return returnArr;
    },
    
    getSimpleValue : function() {
        var that = this;
        if (this._values){
            return jQuery(this._values).map(function(){
                return this[that.valueField];
            }).get().join(",");
        }else{
            return "";
        }
    },
    disable : function(b){
        this.isEnable=!b;
    },
    destory : function(){
    }
})));
};
