ConditionMgr.functions["checkboxGroup"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
        this.labelContainerId = this.id + "_label";
        this.columns = ConditionUtils.df(this.columns, 4);
        this.displayField = ConditionUtils.df(this.displayField, "value");
        this.valueField = ConditionUtils.df(this.valueField, "key");
        this.boxName = this.id + "_ckb";
        this.containerId = this.id + "_container";
        this.allLinkerId = this.id + "_all_link";
        this.checkedAllFlag = this.checkedItems === "all" ? true : false;
        jQuery("#" + this.allLinkerId).text(this.checkedItems === "all"? "["+$RRs.cbg_clearAll+"]": "["+$RRs.cbg_selectAll+"]");
        this.cutNum = this.cutNum;
        this.maxNum = isNaN(this.maxNum) ? -1 : this.maxNum;
    },

    initDoms : function() {
        if (!this.container){
            this.container = jQuery("#" + this.containerId);
        }
        
        var h = this.groupHeight;
        h = parseInt(h);
        h = isNaN(h)?false:h;
        var w = this.groupWidth;
        w = isNaN(w)?false : w;
        if (w){
            this.container.css({
                overflowX: "scroll",
                width : w + "px"
            });
        }
        if(h) {
            this.container.addClass("cbb-cbgroup-ct").css({
                overflowY:"scroll"
            });
            this.container.css("height", h + "px");
        }
        
        this.allLinker = jQuery("#" + this.id + "_all_link");
        var that = this;
        if (that.allLinker) {
            that.allLinker.bind("click",{target:that}, this._checkAllEvent);
        }
        this._addEvent();
    },
    _addEvent : function()
    {
        var that = this;
        this.getBoxes().find(".x-form-check-wrap-inner").bind('click',function(){
            var parentDiv = jQuery(this).parent('div');
            if (parentDiv.hasClass('x-form-check-checked')){
                parentDiv.removeClass('x-form-check-checked');
            }else{
                parentDiv.addClass('x-form-check-checked');
            }
            that.publishEvent("onValueChange");
        });
    },
    _checkAllEvent : function(event) {
        var that = event.data.target;
        that.checkedAll(!that.checkedAllFlag);
        jQuery("#" + that.allLinkerId).text(that.checkedAllFlag === true? "["+$RRs.cbg_clearAll+"]": "["+$RRs.cbg_selectAll+"]");
    },
    beforeShowData : function() {
        this.clear();
        jQuery("#" + this.containerId).hide();
    },
    changeOptions : function(_data){
        this.clear();
        this._init(_data);
    },
    isLoaded : function(){
        return true;
    },
    _init : function(_data){
        var that = this;
        ConditionUtils.createChooseObjGroup({
            containerId : this.containerId,
            name : this.boxName,
            data : _data,
            cutNum : this.cutNum,
            valueField : this.valueField,
            displayField : this.displayField,
            columns : this.columns
        });
        this._addEvent();
    },
    showData : function() {
        this._init(this.resultData.data);
    },
    afterShowData : function() {
        this.checkItems();
        jQuery("#" + this.containerId).show();
    },
    checkItems : function() {
        if (this.getBoxes().size() > this.columns) {
            jQuery(this.allLinker).show();
        }
        if (this.getBoxes().size() > 0) {
            if (this.isTrue(this.disabled)){
                this.disable(true);
            }
            if (this.checkedItems){
                if (this.checkedItems === "all") {
                    this.checkedAll(true);
                } else {
                    this.checkedAll(false);
                    this.checkedByValue(this.checkedItems);
                }
            }else{
                this.checkedAll(false);
                this.getBoxes().first().find(".x-form-check-wrap-inner").trigger('click');;
            }
            this.disableItems(this.disabledItems, true);

            this.checkedAllFlag = this.checkedItems === "all" ? true : false;
            jQuery("#" + this.allLinkerId).text(this.checkedItems === "all"
                    ? "["+$RRs.cbg_clearAll+"]"
                    : "["+$RRs.cbg_selectAll+"]");
        }
    },

    beforeInitComplete : function() {
        this.checkItems();
    },

    clear : function() {
        jQuery("#" + this.containerId).empty();
    },
    reset : function(){
        jQuery.each(this.getBoxes(),function(){
           jQuery(this).removeClass('x-form-check-checked');
        });
        this.checkItems();
        this.publishEvent("onValueChange");
    },
    getValueWithText : function() {
        return this.getBoxes({flag:'checked'}).map(function(index,n) {
            var inputElt = jQuery(this).find(":input[type='checkbox']");
            var title = inputElt.next().attr('title');
            var v = inputElt.attr("value");
            var t = inputElt.data("text");
            if(!t){
                t = jQuery.trim(inputElt.next().attr('title'));
            }
            
            return {
                value : v,
                text : t
            };
        }).get();

    },
    getSimpleValue : function() {
        return this.getBoxes({flag:"checked"}).map(function() {
            return jQuery(this).find(":input[type='checkbox']").attr('value');
        }).get().join(",");
    },
    getBoxes : function(param) {
        var allCheckBox = jQuery("#" + this.containerId + ">table").find(".x-form-check-wrap");
        if (param){
	        if (param.flag && param.flag == 'disabled'){
	            return allCheckBox.filter(".x-item-disabled");
	        }else if (param.flag && param.flag == 'checked'){
	            return allCheckBox.filter(".x-form-check-checked");
	        }else if (param.flag && param.flag == 'enabled'){
	            return allCheckBox.not(jQuery(".x-item-disabled"));
	        }
        }
        
        return allCheckBox;
    },
    getObjByValue : function(v) {
        return jQuery("#" + this.containerId).find(":checkbox[name=" + this.boxName
                + "][value=" + v + "]");
    },
    setValue : function(values) {
        jQuery.each(this.getBoxes(),function(){
           jQuery(this).removeClass('x-form-check-checked');
        });
        
        var ids = jQuery(values).map(function(){
            return this["value"];
        }).get().join(",");
        
        this.checkedByValue(ids, true);
    },
    checkedByValue : function(values, b) {
        var that = this;
        b = b == undefined ? true : b;
        if (values) {
            var arr = values.split(",");
            jQuery.each(arr, function(i, v) {
               that.getObjByValue(v).parent("div")
                                    .parent("div").addClass("x-form-check-checked");
            });
            that.publishEvent("onValueChange");
        }
    },
    checkedAll : function(bn) {
        jQuery.each(this.getBoxes({flag:'enabled'}), function(){
            if (bn == true){
                if (!jQuery(this).hasClass('x-form-check-checked')){
                    jQuery(this).addClass('x-form-check-checked');
                }
            }else{
                if (jQuery(this).hasClass('x-form-check-checked')){
                    jQuery(this).removeClass('x-form-check-checked');
                }
            }
        });
        
        this.publishEvent("onValueChange");
        this.checkedAllFlag = bn;
    },
    disableItems : function(ids, b) {
        var that = this;
        var arrIds;
        if (!ids) {
            return;
        }
        else if (ids == "all"){
            var allBoxes = this.getBoxes();
            if (b){
               jQuery.each(allBoxes, function(i, v) {
                      jQuery("#" + that.id+"_ckb_"+i).parent('div').unbind()
	                               .parent('div').addClass('x-item-disabled'); 
               });
            }else{
                jQuery.each(allBoxes, function(i, v) {
	                jQuery(this).find(".x-form-check-wrap-inner")
	                                     .removeClass('x-item-disabled');
               });
            }
        }else{
            arrIds = ids.split(",");
            if (b){
               jQuery.each(arrIds, function(i, _id){
	                that.getObjByValue(_id).parent('div').unbind()
	                             .parent('div').addClass('x-item-disabled');
               }); 
            }else{
               jQuery.each(arrIds, function(i, _id){
	                that.getObjByValue(_id).parent('div').bind('click',function(){
	                    var parentDiv = jQuery(this).parent("div");
			            if (parentDiv.hasClass('x-form-check-checked')){
			                parentDiv.removeClass('x-form-check-checked');
			            }else{
			                parentDiv.addClass('x-form-check-checked');
			            }
			            that.publishEvent("onValueChange");
	                }).parent('div').removeClass('x-item-disabled');
               });
            }
        }
    },
    disable : function(b){
        this.disableItems("all", b);
        this.isEnable=!b;
    },
    checkData : function() {
        var values = this.getValueWithText();
        var resultObj = {success : true,msg : ""};
        
        if (this.maxNum !== -1 && values.length > this.maxNum){
            resultObj.success=false;
            resultObj.msg=this.maxNumText?this.maxNumText:$RRs.checkbox_maxnumtext_isempty + this.maxNum + $RRs.checkbox_maxnumitemtext;
            return resultObj; 
        }
        
        
        if (this.isTrue(this.required)
                && this.getSimpleValue().length == 0) {
            resultObj.success=false;
            resultObj.msg=this.blankValidateText;
        }
        
        return resultObj;
    },
    afterComplete : function(){
        this.checkItems();
    }
})));
};
ConditionMgr.functions["combobox"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
    	this.prefix = "x-combo-list-inner-";
        this.labelContainerId = this.id + "_label";
        this.containerId = this.id + "_container";
        this.cmbObj = null;
        this._keyF = ((this.valueField == 'key') || (this.valueField == 'value')) ? this.valueField : "key";
        this._valueF = ((this.displayField == 'key')||(this.displayField == 'value')) ? this.displayField : "value";
        this.initV;
        this.containerHelpId = this.id + "_help";       
        this.descId = "lbl_" + this.id;
        this.autoLoad = this.isTrue(this.autoLoad);
        this._labelDescText();
    },
    isLoaded : function(){
        return true;
    },
    initDoms : function(){
        this.clear();
        this._initRequest();
    },
	_initRequest:function()
	{
		var strItems = this.data;
		itemsData=[];
		if(!this.autoLoad)
	  	{
			if(typeof strItems!="undefined"&&strItems)
			{
			  strItems = strItems.substring(1,strItems.length-1);
			  var items=strItems.split(",");
				if(items.length%2==0)
				{
						for (var index=0,len=items.length,i=0;index<len;index=index+2,i++)   
						{
							itemsData[i]={};
							itemsData[i].key=items[index];    
							itemsData[i].value=items[index+1];
						}		
				}
				
				this._initData(itemsData);
			}

		}
	},
    fillComboData: function(combData){
       if( combData == null)
       {
       		_log("info","combData param is null");
       		return
       }
        for (var i = 0; i < combData.length; i++){
        	
            LegoTag.addCombItem(this.containerId,combData[i].key,combData[i].value); 
        }
        var _h = 21 * (combData.length);
		if(_h > 200)
		{
			_h = 200;
			
		}
		jQuery('#x-combo-list-' + this.containerId).css('height', _h);
	    jQuery('#x-combo-list-inner-'+ this.containerId).css('height', _h);
    },
    getDataTextByKey : function(data,key){
        if (data){
            for (var i = 0; i < data.length; i++){
                if (data[i][this._keyF] == key){
                    return data[i][this._valueF];
                }
            }
        }
        return "";
    },
    _initEvents : function(){
        var that = this;
    	var div = jQuery("#" + this.prefix + this.containerId);
    	this._beforeValue = LegoTag.getCombValue(this.containerId);
    	div.bind("click", function(event){
    		var t = event.target;
    		var _curValue = LegoTag.getCombValue(that.containerId);
    		if (t.tagName.toUpperCase() == "DIV" && jQuery(t).hasClass("x-combo-list-item")){
    		    if (_curValue != that._beforeValue){
    		       that.publishEvent("onValueChange");
    		       that._beforeValue = _curValue;
    		    }
    		}
    	});
    },
    _initData :function(combData)
    {
    	var that = this;
	        if (combData.length != 0)
	        {
	            that.fillComboData(combData);
	            var type=typeof that.defaultValue ;
	            var isEmpty = that.defaultValue==undefined || that.defaultValue=="undefined" || that.defaultValue==null || that.defaultValue =="null" || that.defaultValue =="";
	            if (!isEmpty){
	                this.initV = that.getDataTextByKey(combData,that.defaultValue);
	                this.initK = that.defaultValue;
		        }else{
		            if (that.blankOption){
		               this.initV = that.blankOption;
		               this.initK = that.blankOption;
		            }else{
		               this.initV = combData[0].value;
		               this.initK = combData[0].key;
		            }
		        } 
	        }else{
	            this.initV = "";
		        this.initK = "";
	        }
	        this._initEvents();
    },
    _init : function(_data){
        var that = this;
        if (_data){
            that.resultData.data = _data;
        }
        
        if (that.blankOption) {
            var obj = {};
            obj[that._keyF] = "";
            obj[that._valueF] = that.blankOption;
            that.resultData.data.unshift(obj);
        }

        var combData = this.resultData.data;
        this._initData(combData);
    },
    _labelDescText : function(_data){
            var that = this;
	        var descLabel = jQuery("<label/>").attr({
	                id : that.descId
	            });
	        $("#" + this.containerHelpId).append(descLabel);
	        if (that.desc){
				var desc = that.desc; 
	            if($.browser.version=='6.0' || $.browser.version=='7.0' || $.browser.version=='8.0'){
	            descLabel.text(desc).attr('title',that.desc);
	            }else{
	            descLabel.text(desc).attr('title',that.desc).css('padding-left','10px');
	            }
	        }
	},      
    changeOptions : function(data){
        this.clear();
        this.fillComboData(data);
        this.initV = data[0].value;
        this.initK = data[0].key;
        this.checkItems();
        this.publishEvent("onValueChange");
        this._beforeValue = LegoTag.getCombValue(this.containerId);
    },
    showData : function() {
        this.clear();
        this._init();
    },
    checkItems : function(){
        var that = this;
        this.setEditable(this.isTrue(this.editable));
        this.disable(this.isTrue(this.disabled));
        this.selectOption(this.initV,this.initK);
    },
    afterShowData : function() {
        this.checkItems();
        this.publishEvent("onValueChange");
        this._beforeValue = LegoTag.getCombValue(this.containerId);
    },
    setEditable : function(b) {
        jQuery("#" + this.containerId).attr('readonly',!b);
    },
    getValueWithText : function() {
        var tv = LegoTag.getCombDisplay(this.containerId);
        var hv = LegoTag.getCombValue(this.containerId);
        if (tv != this.blankOption) {
            hv = hv == '' ? tv : hv;
        }
        return {
            value : hv,
            text : tv
        };
    },

    clear : function() {
        jQuery("#x-combo-list-inner-" + this.containerId).empty();
        jQuery("#x-combo-list-inner-" + this.containerId).css("height","0px");
        jQuery("#x-combo-list-" + this.containerId).css("height","0px");
    },
    reset : function() {
        this.selectOption(this.initV,this.initK);
        this.checkItems();
        this.publishEvent("onValueChange");
        this._beforeValue = LegoTag.getCombValue(this.containerId);
    },
    getSimpleValue : function() {
        var tv = LegoTag.getCombDisplay(this.containerId);
        var hv = LegoTag.getCombValue(this.containerId);
        if (tv != this.blankOption) {
            hv = hv == '' ? tv : hv;
        }

        return hv;
    },
    setValue : function(obj) {
        this.selectOption(obj["text"],obj["value"]);
    },
    selectOption : function(text,key) {
        LegoTag.setCombValue(this.containerId,key,text);
        LegoTag.setCombDisplay(this.containerId,text);
    },
    disable : function(b) {
        LegoTag.setDisabled(this.containerId, b);
        this.isEnable=!b;
    },
    checkData : function() {
        var resObj = {
            success : true,
            msg : ''
        };
        var v = this.getSimpleValue();
        var test = this.getValueWithText();
        if (((this.isTrue(this.required) && (v == ''
                        || v == this.blankOption)))) {
            resObj.success = false;
            resObj.msg = this.blankValidateText;
        }
        return resObj;
    }
})));
};ConditionMgr.functions["comboDate"] = function(configParams){
ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
	initProperties : function() {
	    this.radioCheck=1;
		this.fieldId = "txt_" + this.id;						
		this.fieldName = this.id + "_n";						
		this.containerId = this.id + "_container";				
		this.descId = "lbl_" + this.id;
		this.startTimeLong = 0;                                  
		this.endTimeLong = 0;									 
		this.dayType = "POINT"	;
		this.dateFmtStyle =  "{dateFmt:\'"+"yyyy-MM-dd HH:mm:ss"+"\'}";		
		this.date_type = dateType;								
		this.date_quarter = dateQuarter;						
		this.date_month =  dateMonth;							
		this.data_week = data52Week; 							
		this.dataLevelKinds = this.dataLevelKind;
		this.data_hide = this.dataLevelHide;
		
		if(this.dataLevelKind==undefined)
		{
		  this.dataLevelKinds = "0,1,2,3";
		}
		if(this.dataLevelHide==undefined)
		{
		  this.data_hide="false";
		}
		
		var myDataLevel= [];
		var subDataLevel= [];
		var item ="";         
	      subDataLevel=this.dataLevelKinds.split(",");          
	      for (var i=0;i<subDataLevel.length;i++)       
	      {    
			   	var array = [];
	       		if(subDataLevel[i]<dataLevel.length){
	       		item = subDataLevel[i];
	       		}
			    array[0] = dataLevel[item][0];
			    array[1] = dataLevel[item][1];
			   	myDataLevel.push(array);   	
	      } 
	    this.data_level=myDataLevel;                            
		this.dateConfig = getDateConfig(this);					
		
		if(this.dateConfig === "")
		{
			this.dateConfig = "dateFmt:'"+Date_const.defaultDateFmt+"'";
			this.dateFmt = Date_const.defaultDateFmt;
		}       
		this.date = new Date();
	},
	initDoms : function() {
		this.container = $("#" + this.containerId);
		var that = this;
		
		var tab = $("<table>",{cellspacing:'0',cellpadding:'0',width:'100%'}).appendTo(that.container);  
		var timeLevel_tr =$("<tr height='27'></tr>").appendTo(tab);	
		var timeRange_tr =$("<tr height='27'></tr>").appendTo(tab);	
		var dataLevel_tr =$("<tr height='27'></tr>").appendTo(tab);	
		var timeLevel_td1= $("<td align='left' width='4%'></td>").appendTo(timeLevel_tr);
		var timeLevel_td2= $("<td align='left' width='16%'></td>").appendTo(timeLevel_tr);
		var timeLevel_td3= $("<td width='30%'></td>").appendTo(timeLevel_tr);
		var timeLevel_td4= $("<td width='54%'></td>").appendTo(timeLevel_tr);
		var timeRange_td1= $("<td align='left'></td>").appendTo(timeRange_tr);
		var timeRange_td2= $("<td></td>").appendTo(timeRange_tr);
		var timeRange_td3= $("<td></td>").appendTo(timeRange_tr);
		var timeRange_td4= $("<td></td>").appendTo(timeRange_tr);
		var dataLevel_td1= $("<td></td>").appendTo(dataLevel_tr);
		var dataLevel_td2= $("<td></td>").appendTo(dataLevel_tr);
		var dataLevel_td3= $("<td></td>").appendTo(dataLevel_tr);
		var dataLevel_td4= $("<td></td>").appendTo(dataLevel_tr);
		
		var tabInner=$("<table>",{cellspacing:'0',cellpadding:'0'}).appendTo(timeLevel_td4);
		var trInner =$("<tr></tr>").appendTo(tabInner);
		var tdInner1= $("<td></td>").appendTo(trInner);
		var tdInner2= $("<td></td>").appendTo(trInner);
		var tdInner3= $("<td></td>").appendTo(trInner);
		var tdInner4= $("<td></td>").appendTo(trInner);
		var tdInner5= $("<td></td>").appendTo(trInner);	
		
		that.radio1 = jQuery("<input type='radio' id='rd_"+this.id+"_0' name='radio_'"+this.id+" checked='checked'/>").appendTo(timeLevel_td1);
		jQuery("<label>"+$RRs.cbd_timeGranularity+":</label>").appendTo(timeLevel_td2);
		that.radio2 = jQuery("<input type='radio' id='rd_"+this.id+"_1' name='radio_'"+this.id+"/>").appendTo(timeRange_td1);
		jQuery("<label>"+$RRs.cbd_timeRange+":</label>").appendTo(timeRange_td2);
		if(this.data_hide==="false"){
		jQuery("<label>"+$RRs.cbd_dataGranularity+":</label>").appendTo(dataLevel_td2);
		}else{
		
		}
		
		that.dateSelectType_div =$("<div id='dateSelectType_div_"+ this.id+"'></div>").appendTo(timeLevel_td3);
		that.dateText_div =$("<div id='dateText_div_"+ this.id +"' ></div>").appendTo(tdInner1);
		that.year_div =$("<div id='year_div_"+ this.id +"'  ></div>").appendTo(tdInner2);
		that.month_div =$("<div id='month_div_"+ this.id +"' ></div>").appendTo(tdInner3);
		that.quarter_div =$("<div id='quarter_div_"+ this.id +"' ></div>").appendTo(tdInner4);
		that.week_div =$("<div id='week_div_"+ this.id +"'></div>").appendTo(tdInner5);
		that.dataLevel_div = $("<div id='dateLevel_div_"+ this.id +"'></div>").appendTo(dataLevel_td3);
		that.week_div.hide();
		that.month_div.hide();
		that.year_div.hide();
		that.quarter_div.hide();

		that.dateText = $("<input class='Wdate' type='text' onClick=\"WdatePicker({"+this.dateConfig+"})\"/>")
		.bind('focus',function(){
		    jQuery(this).css("border","1px solid #7EADD9");
		})
		.bind('blur',function(){
		    if(this.value==''||this.value==null){
		       jQuery(this).css("border","1px solid #DD7870");
		    }else{
		    	jQuery(this).css("border","1px solid #B5B8C8");
		    }
		 })
		.attr({
			name:that.fieldName
		});
		that.dateText.val(toStringByPattern(that.date,that.dateFmt)).appendTo(that.dateText_div);   								

		that.dateSelectType_sel = createSelectDoms("dateSelectType_div_"+ this.id,"dateSelectType_id_"+this.id,"dateSelectType_n"+this.id,that.date_type,'1');   
		that.week_sel = createSelectDoms("week_div_"+ that.id,"week_select_id_"+that.id,"week_select_name"+that.id,that.data_week,that.initWeek());  				
		that.month_sel = createSelectDoms("month_div_"+ that.id,"month_select_id_"+that.id,"month_select_name"+that.id,that.date_month,that.initMonth());			
		that.quarter_sel = createSelectDoms("quarter_div_"+ that.id,"quarter_select_id_"+that.id,"quarter_select_name"+that.id,that.date_quarter,that.initQuarter());	
		that.year_sel = createSelectDoms("year_div_"+ that.id,"year_select_id_"+that.id,"year_select_name"+that.id,that.initYears(),that.date.getFullYear()+'');				
		
		if(this.data_hide==="false"){ 
		that.date_sel = createSelectDoms("dateLevel_div_"+ this.id,"dateLevel_select_id_"+this.id,"dateLevel_select_name"+this.id,that.data_level,'0',this.readOnly);				
		}else{
		that.date_sel = "";
		}
		
		that.dateSelectType_div.append(that.dateSelectType_sel);
		that.week_div.append(that.week_sel);
		that.month_div.append(that.month_sel);
		that.quarter_div.append(that.quarter_sel);
		that.year_div.append(that.year_sel);
		
		
		that.startTime_txt = jQuery("<input  class='Wdate' type='text' onClick=\"WdatePicker("+ this.dateFmtStyle +")\"/>")
		.bind('focus',function(){
		    jQuery(this).css("border","1px solid #7EADD9");
		})
		.bind('blur',function(){
		    if(this.value==''||this.value==null){
		       jQuery(this).css("border","1px solid #DD7870");
		    }else{
		    	jQuery(this).css("border","1px solid #B5B8C8");
		    }
		 })
		.attr({
			id:"dateRangeStart",
			name:that.fieldName
		});
		that.endTime_txt = jQuery("<input  class='Wdate' type='text' onClick=\"WdatePicker("+ this.dateFmtStyle +")\"/>")
		.bind('focus',function(){
		    jQuery(this).css("border","1px solid #7EADD9");
		})
		.bind('blur',function(){
		    if(this.value==''||this.value==null){
		       jQuery(this).css("border","1px solid #DD7870");
		    }else{
		    	jQuery(this).css("border","1px solid #B5B8C8");
		    }
		 })
		.attr({
			id:"dateRangeEnd",
			name:that.fieldName
		});
		that.startTime_txt.val(toStringByPattern(that.date,"yyyy-MM-dd")+" 00:00:00").appendTo(timeRange_td3).attr("disabled","disabled");
		that.endTime_txt.val(toStringByPattern(that.date,"yyyy-MM-dd HH:mm:ss")).appendTo(timeRange_td4).attr("disabled","disabled");
		that.dayChange();
	},
	
	disableRadio1:function(flag)
	{
		var that = this;
		if((!flag)&&(that.radioCheck == 2))
		{
			return ;
		}
		if(flag)
		{
			that.dateSelectType_sel.attr("disabled", true);
			that.week_sel.attr("disabled", true);
			that.month_sel.attr("disabled", true);
			that.quarter_sel.attr("disabled", true);
			that.year_sel.attr("disabled", true);
			that.dateText.attr("disabled","disabled");
			if(that.dateText.val()==null || that.dateText.val()==''){
			    that.dateText.val(toStringByPattern(new Date(),"yyyy-MM-dd"));
			}
			this.dateText.attr("blur",function(){
		    	jQuery(this).css("border","1px solid #B5B8C8");
		    	
			});
		}
		else
		{
			that.dateSelectType_sel.removeAttr("disabled");
			that.week_sel.removeAttr("disabled");
			that.month_sel.removeAttr("disabled");
			that.quarter_sel.removeAttr("disabled");
			that.year_sel.removeAttr("disabled");
			that.dateText.removeAttr("disabled");
		}
	},
	
	radio1Check:function(){
		var that = this;
		that.radioCheck =1;
		
		that.disableRadio1(false);
		that.disableRadio2(true);
		
		if(that.dateSelectType_sel.val()==="1")
		{
			that.dayChange();
		}
		else
		{
			that.yearChange();
		}
	},
	
	disableRadio2:function(flag)
	{
		if((!flag)&&(this.radioCheck == 1))
		{
			return ;
		}
		if(flag)
		{
			if(this.startTime_txt.val()==null||this.startTime_txt.val()==''){
		      this.startTime_txt.val(toStringByPattern(new Date(),"yyyy-MM-dd HH:mm:ss"));
		    }
		    if(this.endTime_txt.val()==null||this.endTime_txt.val()==''){
		      this.endTime_txt.val(toStringByPattern(new Date(),"yyyy-MM-dd HH:mm:ss"));
		    }
		    
			this.startTime_txt.attr("blur",function(){
		    	jQuery(this).css("border","1px solid #B5B8C8");
			});
			this.startTime_txt.attr("disabled",'disabled');
			this.endTime_txt.attr("blur",function(){
		    	jQuery(this).css("border","1px solid #B5B8C8");
		    	
			});
			this.endTime_txt.attr("disabled",'disabled');
		}
		else
		{
			this.startTime_txt.removeAttr("disabled");
			this.endTime_txt.removeAttr("disabled");
		}
	
	},
	
	radio2Check:function(){
		var that = this;
		that.radioCheck =2;
		$(that.radio2).attr("checked","checked");
		
		that.disableRadio1(true);
		that.disableRadio2(false);
		
		that.startTime_txt.focusout();
		that.endTime_txt.focusout();
	},
	
	initEvents : function() {
		var that = this;
		that.radio1.bind('click',function(){
			that.radio1Check();
		});
		that.radio2.bind('click',function(){
			that.radio2Check();
		});
		that.dateSelectType_sel.bind('change',function(){
			that.dateSelectTypeChange();
		});
		that.week_sel.bind('change',function(){
			that.weekChange();
		});
		that.month_sel.bind('change',function(){
			that.monthChange();
		});
		that.quarter_sel.bind('change',function(){
			that.quarterChange();
		});
		that.year_sel.bind('change',function(){
			that.yearChange();
		});
	},

	beforeShowData : function() {
		this.clear();
	},

	showData : function() {},

	afterShowData : function() {
		var that = this;
		$("#" + that.fieldId).bind("change", function(event){
			var target = event.target;
			if (target.value != ""){
				$("#" + that.descId).text(target.value).attr("title", target.value);
			}
		});
		this.checkItems();
	},
	checkItems : function() {
		this.disable(this.disabled);
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		$("#" + this.containerId).empty();
	},

	getValueWithText : function() {
	    if(!this.isTrue(this.required))
		{
			this.setTimeByText();
		}
	    return this.getSimpleValue();
	},
	getSimpleValue : function() {
		var that = this;
		var startTime = toStringByPattern(new Date(this.startTimeLong*1000),"yyyy-MM-dd HH:mm:ss");
		var endTime = toStringByPattern(new Date(this.endTimeLong*1000),"yyyy-MM-dd HH:mm:ss");
		var tx = jQuery("#dateLevel_select_id_" + this.id + ">option:selected").text();
		
		if(that.radioCheck==1)
		{
			var type = that.dateSelectType_sel.val();
			var timeVal="";
			switch (type)
			{
				case "1":
				{
					timeVal = that.dateText.val();
					break;
				}
				case "2":
				{
					timeVal = that.year_sel.val()+"-"+that.week_sel.val();
					break;
				}
				case "3":
				{
					timeVal = that.year_sel.val()+"-"+that.month_sel.val();
					break;
				}
				case "4":
				{
					timeVal = that.year_sel.val()+"-"+that.quarter_sel.val();
					break;
				}
			}
			if(this.data_hide==="false"){
			return [{value: ""+this.startTimeLong , text: startTime},{value: ""+this.endTimeLong ,text:endTime},{value:this.date_sel.val(),text:tx},{value:type,text:timeVal}];
		    }else{
		    return [{value: ""+this.startTimeLong , text: startTime},{value: ""+this.endTimeLong ,text:endTime},{value:type,text:timeVal}];
		    }
		}
		else
		{
			 if(this.data_hide==="false"){
			return [{value: ""+this.startTimeLong , text: startTime},{value: ""+this.endTimeLong ,text:endTime},{value:this.date_sel.val(),text:tx}];
		    }else{
		    return [{value: ""+this.startTimeLong , text: startTime},{value: ""+this.endTimeLong ,text:endTime}];
		    }
		}
	},

	setValue : function(v) {
		var that = this;
		if (null != v && v != undefined){
			if (v.length==4)
			{
				var type=v[3].value;
				var timeVal = v[3].text.split("-");
				
					that.year_div.hide();
					that.quarter_div.hide();
					that.month_div.hide();
					that.week_div.hide();
					that.dateText_div.hide();
				switch (type)
				{
					case "1":
					{
						timeVal = v[2].text.split("&");
						that.dateText.val(timeVal);
						that.dateSelectType_sel.val("1");
						that.dateText_div.show();
						break;
					}
					case "2":
					{
						that.dateSelectType_sel.val("2");
						that.year_sel.val(timeVal[0]);
						that.week_sel.val(timeVal[1]);
						that.year_div.show();
						that.week_div.show();
						break;
					}
					case "3":
					{
						that.dateSelectType_sel.val("3");
						that.year_sel.val(timeVal[0]);
						that.month_sel.val(timeVal[1]);
						that.year_div.show();
						that.month_div.show();
						break;
					}
					case "4":
					{
						that.dateSelectType_sel.val("4");
						that.year_sel.val(timeVal[0]);
						that.quarter_sel.val(timeVal[1]);
						that.year_div.show();
						that.quarter_div.show();
						break;
					}
				}
			}
			if (v.length==3)
			{
				that.radio2Check();
				that.startTime_txt.val(v[0].text);
				that.endTime_txt.val(v[1].text);
			}
			that.startTimeLong=getLongTimeByFmt(v[0].text);
			that.endTimeLong=getLongTimeByFmt(v[1].text);
			that.date_sel.val(v[2].value);
		}
	},
	
	disable : function(b) {
		var bn = b ? true : false;
		this.disableRadio2(b);
		this.disableRadio1(b);
		if(b)
		{
			if(this.data_hide==="false"){
			this.date_sel.attr("disabled", true);
			}else{
			
			}
		}
		else
		{
			if(this.data_hide==="false"){
			this.date_sel.removeAttr("disabled");
			}else{
			
			}
		}
		this.radio1.attr("disabled",b);
		this.radio2.attr("disabled",b);
		this.isEnable=!bn;
	},
	checkData : function() {
		var that = this;
		that.setTimeByText();
		var rstObj = 
		{
			success : true,
			msg : ''
		};
		if(this.required != undefined && this.isTrue(this.required))
		{
			if(this.getSimpleValue() == '')
			{
				rstObj.success = false;
				rstObj.msg = $RRs.comm_vail_date;
				return rstObj;
			}
			if(this.radioCheck==1)
			{
				var type = that.dateSelectType_sel.val();
				var timeVal="";
				if (type=="1")   
				{
					if(!isCorrectFormat(this.dateFmt,this.dateText.val()))
					{
						rstObj.success = false;
						rstObj.msg = $RRs.comm_vail_date_format;
						return rstObj;
					}
				}
			}
			else   
			{
				if(!isCorrectFormat("yyyy-MM-dd hh:mm:ss",this.startTime_txt.val()))
				{
					rstObj.success = false;
					rstObj.msg = $RRs.comm_vail_date_format;
					return rstObj;
				}
				if(!isCorrectFormat("yyyy-MM-dd hh:mm:ss",this.endTime_txt.val()))
				{
					rstObj.success = false;
					rstObj.msg = $RRs.comm_vail_date_format;
					return rstObj;
				}
			}
			if (!this.checkStartAndEndTime()) 
			{
				rstObj.success = false;
				rstObj.msg = $RRs.comm_vail_date_error;
				return rstObj;
			}
		}
		return rstObj;
	},
	
	checkStartAndEndTime:function()
	{
		var that = this;
		if(that.startTimeLong>that.endTimeLong)
		{
			return false;
		}
		return true
	},
	
	dateSelectTypeChange:function(){
		var that = this;
		var type = that.dateSelectType_sel.val();
		switch (type)
		{
			case "1":
			{
				that.year_div.hide();
				that.quarter_div.hide();
				that.month_div.hide();
				that.week_div.hide();
				that.dateText_div.show();
				break;
			}
			case "2":
			{
				that.dateText_div.hide();
				that.quarter_div.hide();
				that.month_div.hide();
				that.year_div.show();
				that.week_div.show();
				that.weekChange();
				break;
			}
		
			case "3":
			{
				that.dateText_div.hide();
				that.quarter_div.hide();
				that.week_div.hide();
				that.year_div.show();
				that.month_div.show();
				that.monthChange();
				break;
			}
			
			case "4":
			{
				that.dateText_div.hide();
				that.month_div.hide();
				that.week_div.hide();
				that.year_div.show();
				that.quarter_div.show();
				that.quarterChange();
				break;
			}
		}
	},
	
	
	dayChange:function(){
		var that = this;
		var date_txt = that.dateText.val();
		that.startTimeLong = getLongTimeByFmt(date_txt);
		that.endTimeLong = that.startTimeLong+86400-1;
	},
	
	
	day1Change:function(){
		var that = this;
		var date_txt = that.day1.val();
		that.startTimeLong = getLongTimeByFmt(date_txt);
	},
	
	
	day2Change:function(){
		var that = this;
		var date_txt = that.day2.val();
		that.endTimeLong =  getLongTimeByFmt(date_txt);
	},
	
	
	weekChange:function(){
		var that = this;
		var yearVal = new Number(that.year_sel.val());
		var weekVal = that.week_sel.val();
		var date = new Date(yearVal,0,1,0,0,0);
		var weekOfYear = getWeekOfYear(date);
		var dayOfWeek = date.getDay();
		if(1!=weekOfYear)
		{
			date = new Date(yearVal,0,(8-dayOfWeek));
		}
		else
		{
			date = new Date(date.getTime() - 86400000 * dayOfWeek);
		}
		var secondsOfWeek = 604800;
		that.startTimeLong = date.getTime()/1000 + (weekVal-1)*secondsOfWeek;
		that.endTimeLong = that.startTimeLong + (secondsOfWeek-1);
	},
	
	monthChange:function(){
		var that = this;
		var yearVal = new Number(that.year_sel.val());
		var monthVal = that.month_sel.val();
		that.startTimeLong = new Date(yearVal,monthVal-1,1,0,0,0).getTime()/1000;
		that.endTimeLong = new Date(monthVal==12?1+yearVal:yearVal,monthVal==12?0:monthVal).getTime()/1000-1;
	},
	
	quarterChange:function(){
		var that = this;
		var yearVal = new Number(that.year_sel.val());
		var quarterVal = that.quarter_sel.val();
		var startMonth = (quarterVal-1)*3;
		var endMonth = quarterVal*3;
		that.startTimeLong = new Date(yearVal,startMonth,1,0,0,0).getTime()/1000;
		that.endTimeLong = new Date(endMonth==12?1+yearVal:yearVal,endMonth==12?0:endMonth).getTime()/1000-1;
	},
	
	yearChange:function(){
	    var that = this;
		var type = that.dateSelectType_sel.val();
		switch (type)
		{
			case "2":
			{
				that.weekChange();
				break;
			}
			case "3":
			{
				that.monthChange();
				break;
			}
			case "4":
			{
				that.quarterChange();
				break;
			}
		}
	},
	
	initYears:function(){
		if(this.minDate===undefined || new Number(this.minDate)<Date_const.minDate)
		{
			this.minDate = Date_const.minDate;
		}
		if(this.maxDate===undefined || new Number(this.maxDate)<Date_const.maxDate)
		{
			this.maxDate = Date_const.maxDate;
		}
		minDate = new Number(this.minDate);
		maxDate = new Number(this.maxDate);
		var lengths = maxDate-minDate+1;
		var date_year = new Array(lengths);
		for(var i=0;i<lengths;i++)
		{
			var temp_Array = new Array(2);
			temp_Array[0] = minDate+i+'';
			temp_Array[1] = minDate+i+'';
			date_year[i] = temp_Array;
		}
		return date_year;
	},
	
	initQuarter:function(){
		switch(this.date.getMonth())
		{
			case 0 :
			case 1 :
			case 2 :
			{
				return '1';
				break;
			}
			case 3 :
			case 4 :
			case 5 :
			{
				return '2';
				break;
			}
			case 6 :
			case 7 :
			case 8 :
			{
				return '3';
				break;
			}
			case 9 :
			case 10 :
			case 11 :
			{
				return '4';
				break;
			}
		}
	},
	
	initMonth:function(){
		return (this.date.getMonth()+1)+'';
	},
	
	initWeek:function(){
	    var week = getWeekOfYear(this.date);
		if(week>52)
		{
			return 52;
		}
		else
		{
			return ''+week;
		}
	},
	setTimeByText:function()
	{
		if(this.radioCheck==1)
		{
			var type = this.dateSelectType_sel.val();
			if(type == 1)
			{
				this.dayChange();
			}
		}
		else
		{
			this.startTimeLong = getLongTimeByFmt(this.startTime_txt.val());
			this.endTimeLong = getLongTimeByFmt(this.endTime_txt.val());
		}
	}
})));
};

ConditionMgr.functions["dateRange"] = function(configParams){
ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
	initProperties : function() {
		this.fieldId = "txt_" + this.id;						
		this.fieldName = this.id + "_n";						
		this.containerId = this.id + "_container";				
		this.descId = "lbl_" + this.id;  
		this.dateConfig = getDateConfig(this); 
		this.startTimeId = this.id+"_startTimeId";
		this.endTimeId = this.id+"_endTimeId";
		this.startTimeLong = 0;
		this.endTimeLong = 0;
		if(this.dateConfig === "")
		{
			this.dateConfig = "dateFmt:'"+Date_const.defaultDateFmt+"'";
			this.dateFmt = Date_const.defaultDateFmt;
		}
		
		this.containerHelpId = this.id + "_help";				
		this.descId = "lbl_" + this.id;
	},

	initDoms : function() {
		this.container = jQuery("#" + this.containerId);
		var that = this;
		that.startTime_txt = jQuery("#"+this.startTimeId);
		that.endTime_txt = jQuery("#"+this.endTimeId);
		
		that.startTimeLong = getLongTimeByFmt(that.startTime_txt.val());
		var startTimeStr = toStringByPattern(new Date(),"yyyy-MM-dd")+" 00:00:00";
		var endTimeStr = toStringByPattern(new Date(),"yyyy-MM-dd")+" 23:59:59";
		that.startTime_txt.val(startTimeStr.substr(0,that.dateFmt.length));
		
		that.endTime_txt.val(endTimeStr.substr(0,that.dateFmt.length));
		that.startTimeLong = getLongTimeByFmt(that.startTime_txt.val());
		
		var descLabel = jQuery("<label/>").attr({
				id : this.descId
			});
		$("#"+this.containerHelpId).append(descLabel);
		
		if (this.desc){
		   if(that.required){
			descLabel.text($C.truncationStr(that.desc, labelLength)).css("padding-left","10px");
		   }else{
		    descLabel.text($C.truncationStr(that.desc, labelLength));
		   }	
		}
		
	},
    getCheckParam : function(){
        var that = this;
        return {
            startTimeLong : that.startTimeLong,
            endTimeLong : that.endTimeLong
        };
    },

	initEvents : function() {
	},
	
	beforeShowData : function() {
		this.clear();
	},

	showData : function() {
	},

	afterShowData : function() {
		var that = this;
		jQuery("#" + that.fieldId).bind("change", function(event){
			var target = event.target;
			if (target.value !== ""){
				jQuery("#" + that.descId).text(target.value).attr("title", target.value);
			}
		});
		this.checkItems();
	},
	checkItems : function() {
		this.disable(this.disabled);
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		jQuery("#" + this.containerId).empty();
	},

	getValueWithText : function() {
		return this.getSimpleValue();
	},
	getSimpleValue : function() {
		if(!this.isTrue(this.required))
		{
			this.setTimeByText();
		}
		var startTime = toStringByPattern(new Date(this.startTimeLong*1000),"yyyy-MM-dd HH:mm:ss");
		var endTime = toStringByPattern(new Date(this.endTimeLong*1000),"yyyy-MM-dd HH:mm:ss");
		return [{value:""+this.startTimeLong , text: startTime},{value: ""+this.endTimeLong ,text:endTime}];
	},

	setValue : function(v) {
		if (null != v && v != undefined){
			this.startTimeLong=getLongTimeByFmt(v[0].text);
			this.endTimeLong=getLongTimeByFmt(v[1].text);
			this.startTime_txt.val(v[0].text);
			this.endTime_txt.val(v[1].text);
		}
	},
	disable : function(b) {
		var bn = b ? true : false;
		if(b)
		{
			this.startTime_txt.attr("disabled","disabled");
			this.endTime_txt.attr("disabled",'disabled');
		}
		else
		{
			this.startTime_txt.removeAttr("disabled");
			this.endTime_txt.removeAttr("disabled");
		}
		this.isEnable=!bn;
	},
	validateStartDate: function (){
    var elDateTime=document.getElementById(this.startTimeId);
  	var dateVal = $.trim(elDateTime.value);
  	var dateFormat = LegoTag.getDateFormat(Ext.get(elDateTime));
    var retDate = Date.parseDate(dateVal, dateFormat);
    
    if(retDate && retDate.format(dateFormat)!=dateVal)
    {
    	return false;
    }
    if(retDate)
    {
    	return true;
    }
    return false;
  },
 validateEndDate: function (){
    var elDateTime=document.getElementById(this.endTimeId);
  	var dateVal = elDateTime.value;
  	var dateFormat = LegoTag.getDateFormat(Ext.get(elDateTime));
  	
    var retDate = Date.parseDate(dateVal, dateFormat);
    if(retDate && retDate.format(dateFormat)!=dateVal)
    {
    	return false;
    }
    if(retDate)
    {
    	return true;
    }
    return false;
  },
	checkData : function() {
	    this.setTimeByText();
		var rstObj = {
			success : true,
			msg : ''
		};
		if(this.validateStartDate()!==true)
		{
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
			return rstObj;
		}
		if(this.validateEndDate()!==true)
		{
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
			return rstObj;
		}
		
		if (this.isTrue(this.required) && (this.startTime_txt.val()==''|| this.endTime_txt.val()=='')) {
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date;
		}else if(!isCorrectFormat(this.dateFmt,this.endTime_txt.val())){
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
		}else if(!isCorrectFormat(this.dateFmt,this.startTime_txt.val())){
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
		}else if (!this.checkStartAndEndTime()) {
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_error;
		}
		return rstObj;
	},
	setTimeByText:function()
	{ 
		this.startTimeLong = getLongTimeByFmt(this.startTime_txt.val());
		this.endTimeLong = getLongTimeByFmt(this.endTime_txt.val());
	},
	
	checkStartAndEndTime:function()
	{
		var that = this;
		if(that.startTimeLong>that.endTimeLong)
		{
			return false;
		}
		return true;
	}
})));
};ConditionMgr.functions["hidden"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.fieldName = this.id + "_n";
		this.containerId = this.id + "_container";
	},
	initDoms : function() {},
	initEvents : function() {},
	beforeShowData : function() {
		this.clear();
	},
	showData : function() {
        if (this.resultData.data){
            jQuery("#" + this.id).val(this.resultData.data);
        }
	},
	afterShowData : function() {
		this.checkItems();
	},
	checkItems : function() {
		if (this.disabled){
			this.disable(this.isTrue(this.disabled));
		}
		if(this.defaultValue) {
			jQuery("#"+this.id).val(this.defaultValue);
		}
	},
	beforeInitComplete : function() {
		this.checkItems();
	},
	clear : function() {
		jQuery("#" + this.containerId).empty();
	},
	reset : function(){
		jQuery("#"+this.id).val("");
		this.checkItems();
	},

	getValueWithText : function() {
		var v = jQuery("#"+this.id).val();
		return {value:v,text:v};
	},

	getSimpleValue : function() {
		return jQuery("#" + this.id).val();
	},
	setValue : function(obj) {
		if (obj != undefined){
			jQuery("#" + this.id).val(obj["value"]);
           this.publishEvent("onValueChange");
		}
	},
	disable : function(bn){},
    display:function(){},
	checkData : function() {return {success:true};}
})));
};
ConditionMgr.functions["ipAddress"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
	initProperties : function() {
	    this.ipAddress = new Component.IPAddress(this);
	    this.initialized=false;
	},
 	onInitComplete:function()
    {
    	this.initialized=true;
    },
	initDoms : function() {
		this.ipAddress.create(configParams);
	},
	beforeShowData : function() {
		this.ipAddress.clear();
	},
	showData : function() {
	},
	afterShowData : function() {
		var that = this;
		this.checkItems();
	},
	checkItems : function() {
		if (this.disabled=="true"||this.disabled==true){
		}
	},
	beforeInitComplete : function() {
		this.checkItems();
	},
	clear : function() {
		this.ipAddress.clear();
	},
	reset : function(){
		this.ipAddress.reset();
	},
	getValueWithText : function() {
	   return this.ipAddress.getValues();
	},
	getSimpleValue : function() {
	  return this.ipAddress.getValue();
	},
	setValue : function(values) {
	    this.ipAddress.setValue(values);
	    this.triggerChange();
	},
	triggerChange : function()
	{
		if(this.initialized)
		{
			$(this).trigger("onValueChange", this);
		}
	},
	removeOther : function(){
	 	this.ipAddress.removeOthers();
	},
	disable : function(bn) {
		this.ipAddress.disable(bn);
	},
	checkData : function() {
	    return this.ipAddress.validate();
	}
})));
};

  Component.IPAddress=function(_owner)
  {
  	if(_owner){
  		this.parent=_owner;
  	}else
  	{
  		this.parent=null;
  	}
  	this._init();
  };
  
  Component.IPAddress.prototype.log= function () {
		if (this.debug && window.console && window.console.log)
		{
			if(typeof console.log.apply !=undefined)
			{
				console.log.apply('', arguments);
			}
		}
   }
  Component.IPAddress.prototype._init=function()
  {
    this.CanJump=true;
  	this.debug=false;
  	this.id="";
  	this.name="";
  	this.key="";
    this.label="";
  	this.blankValidateText="";
    this.disabled=false;
   	this.required=false;
   	this.maxNum=5;
   	this.add=false;
   	this.hasPort=false;
   	this.ipCount=1;
   	this.container=null;
   	this.fieldName="";
   	this.addLinkId = "";
   	this.labelContainerId= "";
   	this.containerId= "";
   	this.style={};
   	this.MAX_INDEX=1;
   	this.log("ipAddress._init");
  }
  Component.IPAddress.prototype.init=function(configs)
  {
  	this.id=configs.id;
  	this.name=configs.name;
  	this.key=configs.key;
    this.label=configs.label;
  	this.blankValidateText=configs.blankValidateText;
    this.disabled=(configs.disabled=="true"||configs.disabled==true) ? true:false;
   	this.required= (configs.required=="true"||configs.required==true) ? true:false;
   	this.maxNum=parseInt(configs.maxNum);
   	this.add=false;
   	this.hasPort= (configs.hasPort=="true"||configs.hasPort==true)?true:false;
   	this.width="320px";
   	this.height="75px";
   	this.container = this.id + "_container";
   	$("#"+this.container).css("width",this.width);
   	this.addLinkId = this.id+"_add_link";
   	this.labelContainerId=this.id+"_label";
   	this.containerId=this.container;
   	
   	this.fieldName = this.id;
   	this.tableId = this.id+"_condition_wrap";
   	this.log("ipAddress.init");
  }
  
  
  Component.IPAddress.prototype.loadData=function(type)
  {
  	
  }
  
  Component.IPAddress.prototype.create=function()
  {
    
  	var configs = arguments[0];
  	this.init(configs);
  	if(configs!==null)
  	{
  		this.appendixCreate();
  	}
  	{
  		this.disable(this.disabled);
  	}	
  	this.bindIpEvents();
  	this.log("ipAddress.create");
  }
  
  Component.IPAddress.prototype.prepareTestData=function()
  {
  return;
  	var values=new Array();
    var obj={};
	
	obj.value="192.168.0.1:8081";
	obj.text="192.168.0.1:8081";
	
	values.push(obj);
	var obj2={}
	
	obj2.value="192.168.0.18:8083";
	obj2.text="192.168.0.18:8083";
	
	values.push(obj2);
	var obj3={};
	
	obj3.value="192.168.0.128:8084";
	obj3.text="192.168.0.128:8084";
	
	values.push(obj3);
	this.setValue(values);
	this.log(this.getValues()[0].value);
	this.log(this.getValues()[0].text);
	this.log(this.validate());
	this.disabled=false;
	this.log("ipAddress.prepareTestData");
  }
  
   
   
  Component.IPAddress.prototype.appendixCreate=function()
  {
     var legoContainerId = "#"+this.id;
	  if(this.hasPort)
	  {
	    var portId = this.id + "_port";
	    var strObj = new StringBuffer();
	   	strObj.append("<div class='ireport-ui-text-ip-panel'>");
		strObj.append("   &nbsp;:");
		strObj.append("  <input type='text' id='"+ portId +"' class='ireport-ui-text-ip-port' value='' maxlength='5' />");
		strObj.append("  <span style='vertical-align: middle'>[1-65535]</span>");
		strObj.append("</div>"); 
		
		var wrapId = this.id+"_wrap";
		$("#"+wrapId).append($(strObj.toString()));	
		this.bindPortEvent(portId);
	   }
	  
	   if(this.required)
	   {
	   	 var strObj = new StringBuffer();
		 strObj.append("<div class='rendar-star rendar-star-combo' style='padding-top:4px'>&nbsp;*</div>");
	   	 var wrapId = this.id+"_wrap";
		 $("#"+wrapId).append($(strObj.toString()));	
	   }
	  var v=this.add;
	  if (v === "true" || v === true){
	  	var _addLink = $("#" + this.addLinkId);
	  	_addLink.show();
	   _addLink.bind("click",{target:this}, this.addEvent);
		}
		$("#"+this.id+"_ul_ip").mouseover(function(){
	      $(this).addClass('ireport-ui-text-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-text-mouseover'); 
	    }); 
		
	}
	
	
	Component.IPAddress.prototype.getFieldIndex = function(obj) {
		var objId = obj.id;
		var len = objId.length;
		return objId.charAt(len - 1);
	}
	
	
	Component.IPAddress.prototype.getNextField = function(obj) {
		var id=obj.id;
		var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
		var index = this.getFieldIndex(obj);
		
		var nextField = null;
	
		if (index == 1) {
			nextField = document.getElementById(idPrefix + 2);
		} else if (index == 2) {
			nextField = document.getElementById(idPrefix + 3);
		} else if (index == 3){
			nextField = document.getElementById(idPrefix + 4);
		}else if (index == 4){
		    if(this.hasPort)
		    {
				
				nextField = document.getElementById(idPrefix + "port");
			}else
			{
				nextField = document.getElementById(idPrefix + 4);
			}
		}
		return nextField;
	}
	Component.IPAddress.prototype.getPrevField = function(index,obj) {
		var id=obj.id;
		var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
		var retField = null;
		if (index == 1) {
			retField = obj;
		} else if (index == 2) {
			retField = document.getElementById(idPrefix + 1);
		} else if (index == 3){
			retField = document.getElementById(idPrefix + 2);
		}else if (index == 4){
			retField = document.getElementById(idPrefix + 3);
		}
		return retField;
	}
	Component.IPAddress.doPortKeyDown = function(event) {
		
		var self = event.data.self;
		var srcObj = event.target;
		var keyCode = event.keyCode;
		switch(keyCode)
		{
			case 190:
			case 110: 
			break;
			case 39:
				break;
			case 40:
			break;
			case 37:
			{
			}
				break;
			case 38:
			break;
			case 8: 
			{
				var curPos = getCaret(srcObj);
				if (curPos == 0) {
					var id=srcObj.id;
					var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
					var field = document.getElementById(idPrefix + 4);					
					setCaret(field, 'end');
					self.CanJump=false;
					return event.returnValue = false;
				}
			}				

			break;
			case 13:
			break;
			case 9:
			break;
			default:
			return event.returnValue = true;
			
			
		}
	}
	Component.IPAddress.doKeyDown = function(event) {
		var self = event.data.self;
		var srcObj = event.target;
		var keyCode = event.keyCode;
		var index = event.data.index;
		switch(keyCode)
		{
			case 190:
			case 110:
			{
				var curPos = getCaret(srcObj);
				if (curPos == srcObj.value.length&& srcObj.value != "") {
					var field = self.getNextField(srcObj);
					setCaret(field, 'end');
					self.CanJump=false;
					return event.returnValue = false;
				}
			}
			break;
			case 39:
			{
			}
				break;
			case 40:
			break;
			case 37:
			{
			}
				break;
			case 38:
			break;
			case 8: 
			{
				var curPos = getCaret(srcObj);
				if (curPos == 0) {
					var field = self.getPrevField(index,srcObj);
					setCaret(field, 'end');
					self.CanJump=false;
					return event.returnValue = false;
				}
			}				

			break;
			case 13:
			break;
			case 9:
			break;
			default:
			return event.returnValue = true;
			
			
		}
	}
	Component.IPAddress.doKeyUpPaste = function(event) {
	    var self = event.data.self;
	    var goJump = event.data.jump;
		var _expr = event.data.expr; 
		var value = $(this).val();
		var val = parseInt($(this).val());
		var index = event.data.index;
		var keyCode = event.keyCode;
		if (event.data.expr.test(value)) {
			$(this).val(this.value.replace(_expr, ""));
		}
		if(!isNaN(val))
		{
			if(val<0)
			{
				$(this).val("");
			}else
			{
				$(this).val(val);
			}
			_log("debug",$(this).val());
		}else
		{
			$(this).val("");
		}
				if(index==1)
				{
					if(val>223)
					{
						$(this).val(223);
			        	$(this).focus();
					}
					if(val==127)
					{
						$(this).select();
					}
					if(val==0)
					{
						$(this).val("");
					}
					
					var curPos = getCaret(this);
					if (curPos == value.length) {
					}
					if(self.CanJump&&val>=100&&val!=127)
					{
					
						var nextField = self.getNextField(this);
						if(null != nextField){
							nextField.select();
						}
					}
					
				}else
				{
					if(val>255)
					{
						$(this).val(255);
			        	$(this).focus();
					}
					if(val==0)
					{
						$(this).val("0");
					}
					
					if(self.CanJump&&val>=100)
					{
						var nextField = self.getNextField(this);
						if(null != nextField){
							nextField.select();
						}
					}
				}
			self.CanJump=true;	
	}
	Component.IPAddress.doBlur = function(event)
	{
		var self = event.data.self;
		var _expr = event.data.expr;
		var value = $(this).val();
		var val = parseInt($(this).val());
		var index = event.data.index;
		var keyCode = event.keyCode;
		if (_expr.test(value)) {
			$(this).val(this.value.replace(_expr, ""));
		}
		
		if(!isNaN(val))
		{
			if(val<0)
			{
				$(this).val("");
			}else
			{
				if(index==1&val==0)
			    {
			    	$(this).val("");
			    }else{
				$(this).val(val);
				}
			}
		}else
		{
			$(this).val("");
		}
		var val = self.getValue();
		if(val!=null)
		{
			if(null!=self.parent)
			{
				self.parent.triggerChange();
			}
		}
	
	}
	Component.IPAddress.prototype.bindIpEvents=function(IPAddressId)
	{
	   $("#"+IPAddressId+"_ul_ip").mouseover(function(){
	      $(this).addClass('ireport-ui-ctrl-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-ctrl-mouseover'); 
	    }); 
		   
	    var self = this;
		IPAddressId=(IPAddressId === null||IPAddressId === undefined)?this.id:IPAddressId
		for(var i=1,len=4;i<=len;i++)
		{
			var ip = IPAddressId+"_"+i;
			var jip="#"+ip;		
			var index = i;
			var _expr = /\D/g;
			$(jip).bind("keyup paste",{self:this,expr:_expr,index:index,jump:self.CanJump}, Component.IPAddress.doKeyUpPaste);
			$(jip).bind("keydown",{self:this,expr:_expr,index:index}, Component.IPAddress.doKeyDown);
			$(jip).bind("blur",{self:this,expr:_expr,index:index}, Component.IPAddress.doBlur);
		}
		
		this.log("ipAddress.bindIpEvents");
	}
		
	Component.IPAddress.prototype.bindPortEvent=function(portId)
	{
		var _expr = /\D/g;
		var jPortId = "#"+portId;
		$(jPortId).bind("keyup paste",{expr:_expr, max:65535, min:1}, function(event) {
						if (event.data.expr.test(this.value)) {
							this.value = this.value.replace(_expr, "");
						}
						
						var val = parseInt($(this).val());
						if(!isNaN(val))
						{
							if(val<0)
							{
								$(this).val("");
							}else
							{
								$(this).val(val);
							}
						}else
						{
							$(this).val("");
						}
						
						if (this.value>event.data.max){
							this.value = event.data.max;
						}
						if (this.value != '' && this.value < event.data.min){
							this.value = event.data.min;
						}
					});
					
			$(jPortId).mouseover(function(){
		      $(this).addClass('ireport-ui-ctrl-mouseover'); 
		    }).mouseout(function(){ 
		      $(this).removeClass('ireport-ui-ctrl-mouseover'); 
		    });
		  $(jPortId).bind("keydown",{self:this}, Component.IPAddress.doPortKeyDown);
		  $(jPortId).bind("blur",{self:this,expr:_expr}, Component.IPAddress.doBlur);   					
	}
	Component.IPAddress.prototype.createIPAddress=function()
	{
		var str="<td class='ireport-ui-control-title'>&nbsp;</td><td class='ireport-ui-control-content'>"+ this.createIPAddressString() +"</td>";
		var strTR ="<tr nowrap='true'>"+str+"</tr>";	
		var tr = $(strTR);	
				
		tr.appendTo($("#"+this.tableId));
		
		this.ipCount++;
		this.MAX_INDEX++;
		var self =this;
		var newId=this.id+this.MAX_INDEX;
		var delButton = "#" + newId+"_del";
		var portPanel = "#" + newId+"_PanelAppendix";
		var fieldPort = newId+"_port";
		this.bindIpEvents(newId);
		$(delButton).bind("click",function()
		{
				if (tr.index() > 0){
					tr.remove();
					self.ipCount--;
				}
				self.log("ipAddressMask.delButton.EVT.click");
		});

		this.bindPortEvent(fieldPort);	
		this.log("ipAddress.createIPAddress");
		
	}
	
	Component.IPAddress.prototype.createIPAddressString = function()
	{
	   var strObj = new StringBuffer();
	   var curIndex=(this.MAX_INDEX+1);
	   var newId = this.id+curIndex;
	   var ulIPId=newId+"_ul_ip";
	   var field1 = newId+"_1";
	   var field2 = newId+"_2";
	   var field3 = newId+"_3";
	   var field4 = newId+"_4";
	  
	   var fieldPort = newId+"_port";
	   var hiddenField = newId+"-hidden";
	   var container=newId+"_container";
	   var delButton = newId+"_del";
	   var portPanel= newId + "_PanelAppendix";
	    strObj.append("<div class='ireport-ui-text-ip-wrap'>");
		strObj.append("					  <div class='ireport-ui-text-ip-panel'>");
		strObj.append("						<ul class='ireport-ui-text-ip' id='"+ulIPId+"'>");
		strObj.append("							<li class='ireport-ui-text-ip-field'>");
		strObj.append("									<input type='text' id='"+field1+"' class='ireport-ui-text-ip-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-field'>");
		strObj.append("								<input type='text' id='"+field2+"' class='ireport-ui-text-ip-input' maxlength='3' />");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-field'>");
		strObj.append("								<input type='text' id='"+field3+"' class='ireport-ui-text-ip-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-field'>");
		strObj.append("								<input type='text' id='"+field4+"' class='ireport-ui-text-ip-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("						</ul>");
		strObj.append("						</div>");

		if(this.hasPort)
		{
			strObj.append("						<div class='ireport-ui-text-ip-panel'>");
			strObj.append("						    	&nbsp;:");
			strObj.append("							    <input type='text' id='"+fieldPort+"' class='ireport-ui-text-ip-port' value='' maxlength='5'/>");
			strObj.append("							    <span style='vertical-align:middle'>[1-65535]</span>");		
			strObj.append("						</div>");
		}
		strObj.append("						<div class='ireport-ui-text-ip-panel'>");
		strObj.append("        <a title=\"删除\" style=\"cursor: pointer;\" id=\""+delButton+"\"><img style='vertical-align:middle' height='16' width='16' src='"+Component._PATH_+"images/delete.png'/>");
  	    strObj.append("						</div>");
		
		strObj.append("					</div>");
		return strObj;
	}
    Component.IPAddress.prototype.addEvent=function(event)
    {
    	var that = event.data.target;
	   	try {
		   	var tbl = $("#" + that.tableId);
		   	
			var i = tbl.find(">tbody>tr").size();
			if (that.maxNum && !isNaN(that.maxNum) && (i + 1) > that.maxNum){
				alert($RRs.ip_alert_before+" "+ that.maxNum +" "+$RRs.ip_alert_after);
				return false;
			}
			
			that.createIPAddress();		
		 }
		 catch(e) {
		   alert("IPAddress create failed: " + e);
		 }
		 finally {
		   that.log("ipAddressMask.addEvent");
		 }   	   	
    }
   
    Component.IPAddress.prototype.isFullIP=function(fields)
    {
      var self = this;
      var isCorrect=true;
    	$.each(fields, function(j, field){
    		if($.trim($(field).val())=="")
    		{
    			isCorrect= false;
    		}
    	});
    	return isCorrect;
    }
	Component.IPAddress.prototype.getValue=function()
	{
	    var self =this;
		var retVals=new Array(this.ipCount);
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
		$.each(rows, function(j, _row){
		     var inputList = $(_row).find(":input");
		     self.log(inputList);
		     var retVal=self.isFullIP(inputList);
		     self.log(retVal);
		     if(retVal)
		     {
		     	retVals[j]=$.trim(inputList[0].value)+"."+$.trim(inputList[1].value)+"."+$.trim(inputList[2].value)+"."+$.trim(inputList[3].value);
			    if(inputList.length==5)
			    {
			     	retVals[j]+=":"+$.trim(inputList[4].value);
			    }
		     }
		});
		return retVals;
	}
	
    Component.IPAddress.prototype.focusIPField=function(fields)
    {
      this.log("focusIPField");
      var self = this;
      var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
	  for(var j=0,jlen=rows.length;j<jlen;j++){
	      var _row=rows[j];
	      var bContinue=true;
		  var fields = $(_row).find(":input");
		  var field =null;
	      for(var i=0,len=fields.length;i<len;i++)
	      {
	      	  field = fields[i];
	      	  if($.trim($(field).val())=="")
		   	  {
		   			field.focus();
		   			bContinue=false;
		   			break;
		   	  }
	      }
	      if(!bContinue)break;
		}
		
    }
    Component.IPAddress.prototype.unrequiredValidate=function(fields)
    {
      this.log("unrequiredValidate");
      var self = this;
      var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
	  for(var j=0,jlen=rows.length;j<jlen;j++){
	      var _row=rows[j];
	      var bShowInfo=false;
		  var fields = $(_row).find(":input");
		  var field =null;
		  var validCnt=0;
	      for(var i=0,len=fields.length;i<len;i++)
	      {
	      	  field = fields[i];
	      	  if($.trim($(field).val())!="")
		   	  {
		   			validCnt++;
		   	  }
	      }
	      if(this.hasPort)
	      {
		      if(validCnt!=0&&validCnt!=5)
		      {
		      	return false;
		      }
	      }else
	      {
	      	  if(validCnt!=0&&validCnt!=4)
		      {
		      	return false;
		      }
	      }
		}
		return true;
    }
  Component.IPAddress.prototype.validate=function()
  {
    this.log("IPAddress.validate");
  	var retVal = {
			success : true,
			msg : ''
		};
	var v = this.getValues();
	if(this.required)
	{
		if(!this.unrequiredValidate())
		{
			retVal.success = false;
			retVal.msg = $RRs.ip_alert_invalid;
			this.focusIPField();
			return retVal;
		}
		if(v.length ==0 || v.length!=this.ipCount)
		{
			retVal.success = false;
			retVal.msg = this.blankValidateText;
			this.focusIPField();
			return retVal;
		}
	}else
	{
		if(!this.unrequiredValidate())
		{
			retVal.success = false;
			retVal.msg = $RRs.ip_alert_invalid;
			this.focusIPField();
			return retVal;
		}
	}
  	return retVal;
  }
	Component.IPAddress.prototype.getValues=function()
	{
	 	this.log("getValues:");
	 	var self =this;
		var retVals=new Array();
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");
		return rows.map(function(){
			 var inputList = $(rows).find(":input");
			 var retVal=self.isFullIP(inputList);
		     var tmpStr="";
		     if(retVal)
		     {
			     tmpStr=$.trim(inputList[0].value)+"."+$.trim(inputList[1].value)+"."+$.trim(inputList[2].value)+"."+$.trim(inputList[3].value);		     
			     if(inputList.length==5)
			     {
			     	tmpStr+=":"+inputList[4].value;
			     }
			     return {value:tmpStr,text:tmpStr};
		     }
		     
		}).get();
	}
	
	Component.IPAddress.prototype.adjustControlNums=function(num)
	{
		if(this.ipCount<num)
		{
			for(var i=0,len=num-this.ipCount;i<len;i++)
			{
				$("#" + this.addLinkId).trigger("click");
			}
		}
	}
	
	
	Component.IPAddress.prototype.setValue=function(values)
	{
	    var self = this;
	    if(values === "undefined" || values === null)return;
	    this.adjustControlNums(values.length);
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");
		$.each(rows, function(j, _row){
		     var ipStr = values[j].value;
			 var arr = ipStr.split(":");
			 var ip = arr[0];
			 var port="";
			 if(arr.length==2)
			 {
			 	port=arr[1];
			 }
		     var inputList = $(_row).find(":input");
		     $.each(inputList,function(i,input)
		     {
		        var aryIP = ip.split(".");
		        if(i<4){
		     	inputList[i%4].value=aryIP[i%4];
		     	}
		     	if(i==4)
		     	{
		     	   $(input).val(port);
		     	 
		     	}
		      
		     	
		     });
		});
		this.log("ipAddress.setValue");
	}
	
	Component.IPAddress.prototype.reset=function()
	{
		$("#" + this.tableId + " :text").val("");
		this.removeOthers();
		if(this.disabled){
			this.disable(this.disabled)
		}
	}
	Component.IPAddress.prototype.disable = function(b)
	{
	   if(b)
	   {
	   	 this.enable(false)
	   }else
	   {
	   	 this.enable(true);
	   }
	}
	
	
	
	
	
	Component.IPAddress.prototype.enable = function(b)
	{
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");
		if(b){
			$.each(rows, function(i, _row){
			     var inputList = $(_row).find(":input");
			     $.each(inputList,function(i,input)
			     {
			     	$(input).removeAttr("disabled");
			     });
			});
			$("#" + this.addLinkId).bind("click",{target:this}, this.addEvent);
			$("#" + this.addLinkId).css("cursor", "pointer");
		}else
		{
			var rows = jQuery("#" + this.tableId).find(">tbody>tr");
			$.each(rows, function(i, _row){
			     var inputList = $(_row).find(":input");
			     $.each(inputList,function(i,input)
			     {			     	
			     	$(input).attr("disabled","true");
			     });			     
			});
			$("#" + this.addLinkId).unbind("click");
			$("#" + this.addLinkId).css("cursor", "default");
		}
		
		
		this.disabled=!b;
	}

	Component.IPAddress.prototype._getFields=function() {
		var ctrlIP=this.id;
		var fieldArr = new Array(4);
		for (var i = 0; i < 4; i++) {
			fieldArr[i] = $(ctrlIP + (i + 1));
	
		}
		return fieldArr;
	}
	

	Component.IPAddress.prototype.removeOthers=function()
	{
		$("#" + this.tableId).find("a>img").parent().trigger("click");
	}	
	Component.IPAddress.prototype.clear = function()
	{
		$("#" + this.container).empty();
		this._init();
	
	} 
	
	
ConditionMgr.functions["ipAndMask"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
	initProperties : function() {
	    this.ipmask = new Component.IPMask();
	},

	initDoms : function() {
		this.ipmask.create(configParams);
	},
	beforeShowData : function() {
		this.ipmask.clear();
	},
	showData : function() {
	},
	afterShowData : function() {
		var that = this;
		this.checkItems();
	},
	checkItems : function() {
		if (this.disabled=="true"||this.disabled==true){
			this.disable(this.isTrue(this.disabled));
		}
	},
	beforeInitComplete : function() {
		this.checkItems();
	},
	clear : function() {
		this.ipmask.clear();
	},
	reset : function(){
		this.ipmask.reset();
	},
	getValueWithText : function() {
	   return this.ipmask.getValues();
	},
	getSimpleValue : function() {
	  return this.ipmask.getValue();
	},
	setValue : function(values) {
	    this.ipmask.setValue(values);
	},
	
	removeOther : function(){
	 	this.ipmask.removeOthers();
	},
	disable : function(bn) {
		this.ipmask.disable(bn);
	},
	checkData : function() {
	    return this.ipmask.validate();
	}
})));
};

  Component.IPMask=function(_owner)
  {
  	if(_owner){
  		this.parent=_owner;
  	}else
  	{
  		this.parent=null;
  	}
  	this._init();
  };
  
  Component.IPMask.prototype.log= function () {
		if (this.debug && window.console && window.console.log)
		{
			if(typeof console.log.apply !=undefined)
			{
				console.log.apply('', arguments);
			}
		}
   }
  Component.IPMask.prototype._init=function()
  {
  	this.CanJump=true;
  	this.debug=false;
  	this.id="";
  	this.name="";
  	this.key="";
    this.label="";
  	this.blankValidateText="";
    this.disabled=false;
   	this.required=false;
   	this.maxNum=5;
   	this.add=false;
   	this.hasPort=false;
   	this.ipCount=1;
   	this.container=null;
   	this.fieldName="";
   	this.addLinkId = "";
   	this.labelContainerId= "";
   	this.containerId= "";
   	this.style={};
   	this.MAX_INDEX=1;
   	this.log("ipAddressMask._init");
  }
  Component.IPMask.prototype.init=function(configs)
  {
  	this.id=configs.id;
  	this.name=configs.name;
  	this.key=configs.key;
    this.label=configs.label;
  	this.blankValidateText=configs.blankValidateText;
    this.disabled=(configs.disabled=="true"||configs.disabled==true) ? true:false;
   	this.required= (configs.required=="true"||configs.required==true) ? true:false;
   	this.maxNum=parseInt(configs.maxNum);
   	this.add=false;
   	this.hasPort= (configs.hasPort=="true"||configs.hasPort==true)?true:false;
   	this.width="320px";
   	this.height="75px";
   	this.container = this.id + "_container";
   	$("#"+this.container).css("width",this.width);
   	this.addLinkId = this.id+"_add_link";
   	this.labelContainerId=this.id+"_label";
   	this.containerId=this.container;
   	
   	this.fieldName = this.id;
   	this.tableId = this.id+"_condition_wrap";
   	this.log("ipAddressMask.init");
  }
  Component.IPMask.prototype.loadData=function(type)
  {
  	
  }
  
  Component.IPMask.prototype.create=function()
  {
    
  	var configs = arguments[0];
  	this.init(configs);
  	if(configs!==null)
  	{
  		this.appendixCreate();
  	}
  	if(this.disabled)
  	{
  		this.disable(this.disabled);
  	}	
  	this.bindIpEvents();
  	this.log("ipAddressMask.create");
  }
  
  Component.IPMask.prototype.prepareTestData=function()
  {
  	var values=new Array();
    var obj={};
	
	obj.value="192.168.0.1/255.0.0.0:8080";
	obj.text="192.168.0.1/255.0.0.0:8080";
	
	values.push(obj);
	var obj2={}
	
	obj2.value="192.168.0.18/255.255.0.0:8083";
	obj2.text="192.168.0.18/255.255.0.0:8083";
	
	values.push(obj2);
	var obj3={};
	
	obj3.value="192.168.0.128/255.255.255.0:8084";
	obj3.text="192.168.0.128/255.255.255.0:8084";
	
	values.push(obj3);
	this.setValue(values);
	this.log(this.getValues()[0].value);
	this.log(this.getValues()[0].text);
	this.log(this.validate());
	this.disabled=false;
	this.log("ipAddressMask.prepareTestData");
  }
  
    Component.IPMask.prototype.focusInvalidField=function(fields)
    {
      this.log("focusIPField");
      var self = this;
      var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
	  for(var j=0,jlen=rows.length;j<jlen;j++){
	      var _row=rows[j];
	      var bContinue=true;
		  var fields = $(_row).find(":input");
		  var field =null;
	      for(var i=0,len=fields.length;i<len;i++)
	      {
	      	  field = fields[i];
	      	  if($.trim($(field).val())=="")
		   	  {
		   	        if(i<=3)
		   	        {
		   	           
		   	        }else
		   	        {
		   	        }
		   			field.focus();
		   			bContinue=false;
		   			break;
		   	  }
	      }
	      if(!bContinue)break;
		}
		
    }
    Component.IPMask.prototype.unrequiredValidate=function(fields)
    {
      this.log("unrequiredValidate");
      var self = this;
      var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
	  for(var j=0,jlen=rows.length;j<jlen;j++){
	      var _row=rows[j];
	      var bShowInfo=false;
		  var fields = $(_row).find(":input");
		  var field =null;
		  var validCnt=0;
	      for(var i=0,len=fields.length;i<len;i++)
	      {
	      	  field = fields[i];
	      	  if($.trim($(field).val())!="")
		   	  {
		   			validCnt++;
		   	  }
	      }
	      if(this.hasPort)
	      {
		      if(validCnt!=0&&validCnt!=9)
		      {
		      	return false;
		      }
	      }else
	      {
	      	  if(validCnt!=0&&validCnt!=8)
		      {
		      	return false;
		      }
	      }
		}
		return true;
    } 
    
    Component.IPMask.prototype.focusIPField=function(fields)
    {
      this.log("focusIPField");
      var self = this;
      var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
	  for(var j=0,jlen=rows.length;j<jlen;j++){
	      var _row=rows[j];
	      var bContinue=true;
		  var fields = $(_row).find(":input");
		  var field =null;
	      for(var i=0,len=fields.length;i<len;i++)
	      {
	      	  field = fields[i];
	      	  if($.trim($(field).val())=="")
		   	  {
		   			field.focus();
		   			bContinue=false;
		   			break;
		   	  }
	      }
	      if(!bContinue)break;
		}
		
    }    
  Component.IPMask.prototype.validate=function()
  {
  	var retVal = {
			success : true,
			msg : ''
		};
	var v = this.getValues();
	this.log(v);
	if(this.required)
	{
		if(!this.unrequiredValidate())
		{
			retVal.success = false;
			retVal.msg = $RRs.ip_mask_alert_invalid;
			_log("debug","here1");
			this.focusIPField();
			return retVal;
		}
		if((v.length ==0 || v.length!=this.ipCount) )
		{
		    this.log("有错误信息了");
			retVal.success = false;
			retVal.msg = this.blankValidateText;
			this.focusInvalidField();
			return retVal;
		}
		
	}else
	{
		if(!this.unrequiredValidate())
		{
			retVal.success = false;
			retVal.msg = $RRs.ip_mask_alert_invalid;
			_log("debug","here2");
			this.focusIPField();
			return retVal;
		}
	}
	
  	if (this.required && v.length == 0){
			retVal.success = false;
			retVal.msg = this.blankValidateText;
		}else if (v.join(";").search("formatError") !== -1){
			retVal.success = false;
			retVal.msg = this.blankValidateText;
		}
  	return retVal;
  }
  Component.IPMask.prototype._check=function()
  {
  
  	return true;
  }
  
  Component.IPMask.prototype.appendixCreate=function()
  {
     var legoContainerId = "#"+this.id;
	  if(this.hasPort)
	  {
	    var portId = this.id + "_port";
	    var strObj = new StringBuffer();
	   	strObj.append("<div class='ireport-ui-text-ip-mask-panel'>");
		strObj.append("   &nbsp;:");
		strObj.append("  <input type='text' id='"+ portId +"' class='ireport-ui-text-ip-mask-port' value='' maxlength='5' />");
		strObj.append("  <span style='vertical-align: middle'>[1-65535]</span>");
		strObj.append("</div>"); 
		var wrapId = this.id+"_wrap";
		$("#"+wrapId).append($(strObj.toString()));		
		this.bindPortEvent(portId);
	   }
	  var v=this.add;
	  if (v === "true" || v === true){
	  	var _addLink = $("#" + this.addLinkId);
	  	_addLink.show();
	   _addLink.bind("click",{target:this}, this.addEvent);
		}
		
		$("#"+this.id+"_ul_ip").mouseover(function(){
	      $(this).addClass('ireport-ui-ctrl-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-ctrl-mouseover'); 
	    }); 
	    $("#"+this.id+"_ul_mask").mouseover(function(){
	      $(this).addClass('ireport-ui-ctrl-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-ctrl-mouseover'); 
	    }); 
	}
	Component.IPMask.prototype.getFieldIndex = function(obj) {
		var objId = obj.id;
		var len = objId.length;
		return objId.charAt(len - 1);
	}
	
	Component.IPMask.prototype.getNextField = function(obj) {
	 	var id=obj.id;
		var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
		this.log(idPrefix);
		var index = this.getFieldIndex(obj);
		var nextField = null;
	
		if (index == 1) {
			nextField = document.getElementById(idPrefix + 2);
		} else if (index == 2) {
			nextField = document.getElementById(idPrefix + 3);
		} else if (index == 3){
			nextField = document.getElementById(idPrefix + 4);
		}else if (index == 4){
		   if( id.indexOf("_mask_")==-1 ){
				nextField = document.getElementById(idPrefix+"mask_" + 1);
			}else{
				if(this.hasPort)
				{
					var ipPrefix = id.substring(0,id.lastIndexOf("_mask_")+1);
					nextField = document.getElementById(ipPrefix+"port");
				}else
				{
					nextField = document.getElementById(idPrefix+ 4);
				}
			}
		}
		return nextField;
	}
	Component.IPMask.prototype.getPrevField = function(index,obj) {
		var id=obj.id;
		var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
		var retField = null;
		if (index == 1) {
			if( id.indexOf("_mask_")!=-1)
		    {
		    	var ipPrefix = id.substring(0,id.lastIndexOf("_mask_")+1);
		    	retField = document.getElementById(ipPrefix + 4);
		    }else{
				retField = obj;
			}
		} else if (index == 2) {
			retField = document.getElementById(idPrefix + 1);
		} else if (index == 3){
			retField = document.getElementById(idPrefix + 2);
		}else if (index == 4){
			retField = document.getElementById(idPrefix + 3);
		}
		return retField;
	}
	Component.IPMask.doKeyDown = function(event) {
		var self = event.data.self;
		var srcObj = event.target;
		var keyCode = event.keyCode;
		var index = event.data.index;
		switch(keyCode)
		{
			case 190:
			case 110:
			{
				var curPos = getCaret(srcObj);
				if (curPos == srcObj.value.length&& srcObj.value != "") {
					var field = self.getNextField(srcObj);
					setCaret(field, 'end');
					self.CanJump=false;
					return event.returnValue = false;
				}
			}
			break;
			case 39:
			{
			}
				break;
			case 40:
			break;
			case 37:
			{
			}
				break;
			case 38:
			break;
			case 8: 
			{
				var curPos = getCaret(srcObj);
				if (curPos == 0) {
					var field = self.getPrevField(index,srcObj);
					setCaret(field, 'end');
					self.CanJump=false;
					return event.returnValue = false;
				}
			}				

			break;
			case 13:
			break;
			case 9:
			break;
			default:
			return event.returnValue = true;
			
			
		}
	}	
	
	Component.IPMask.doMaskBlur = function(event)
	{
		var self = event.data.self;
		var _expr = event.data.expr;
		var idPrefix = event.data.idPrefix;
		var value = $(this).val();
		var val = parseInt($(this).val());
		var index = event.data.index;
		var keyCode = event.keyCode;
		if (_expr.test(value)) {
			$(this).val(this.value.replace(_expr, ""));
		}
		if(!isNaN(val))
		{
			if(val<0)
			{
				$(this).val("");
			}else
			{
				$(this).val(val);
			}
		}else
		{
			$(this).val("");
		}
		val = parseInt($(this).val());
     	if(!isNaN(val)&&$.inArray(val, Component.IPMask.VALID_MASK)==-1)
		{
			switch(index)
			{
				case 1:
					$(idPrefix+"1").val(255);
				break;
				case 2:
				   var preVal = $.trim($(idPrefix+"1").val());
				   if(preVal!="")
				   {
				   		$(this).val("0");
				   }else
				   {
				   		$(this).val("");
				   }
				   
				break;
				case 3:
					var preVal = $.trim($(idPrefix+"2").val());
				   if(preVal!=""&&preVal=="255")
				   {
				   		$(this).val("0");
				   }
				   if(preVal!=""&&preVal!="255")
				   {
				   		$(this).val("0");
				   }
				break;
				case 4:
					var preVal = $.trim($(idPrefix+"3").val());
				    if(preVal!="")
				    {
				   		$(this).val("0");
				    }
				break;
				default:
				
			}
			$(this).focus();
	    }
		if(!isNaN(val)&&$.inArray(val, Component.IPMask.VALID_MASK)!=-1)
		{
			switch(index)
			{
				case 1:
				break;
				case 2:
				   var preVal = $.trim($(idPrefix+"1").val());
				   if(preVal!=""&&preVal=="255")
				   {
				   }
				   if(preVal!=""&&preVal!="255")
				   {
				   		$(this).val("0");
				   }
				break;
				case 3:
					var preVal = $.trim($(idPrefix+"2").val());
				   if(preVal!=""&&preVal!="255")
				   {
				   		$(this).val("0");
				   }
				break;
				case 4:
					var preVal = $.trim($(idPrefix+"3").val());
				    if(preVal!=""&&preVal!="255")
				    {
				   		$(this).val("0");
				    }
				break;
				default:
				
			}
			
		}
		var val = self.getValue();
		if(val!=null)
		{
			if(null!=self.parent)
			{
				self.parent.triggerChange();
			}
		}
	}
	Component.IPMask.VALID_MASK=[255,254,252,248,240,224,192,128,0];
	Component.IPMask.prototype.bindIpEvents=function(ipMaskId)
	{
	    var self = this;
		ipMaskId=(ipMaskId === null||ipMaskId === undefined)?this.id:ipMaskId
		
		$("#"+ipMaskId+"_ul_ip").mouseover(function(){
	      $(this).addClass('ireport-ui-text-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-text-mouseover'); 
	    }); 
	    $("#"+ipMaskId+"_ul_mask").mouseover(function(){
	      $(this).addClass('ireport-ui-text-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-text-mouseover'); 
	    }); 
		
		var _expr = /\D/g;
		for(var i=1,len=4;i<=len;i++)
		{
			var ip = ipMaskId+"_"+i;
			var jip="#"+ip;
			var jmask = "#"+ipMaskId+"_mask_"+i;
			var maskPrefix=	"#"+ipMaskId+"_mask_";		
			var index = i;
		  $(jip).bind("blur",{self:this,expr:_expr,index:index}, Component.IPMask.doBlur);
		  $(jmask).bind("blur",{self:this,expr:_expr,index:index,idPrefix:maskPrefix}, Component.IPMask.doMaskBlur);
		  
		  $(jmask).bind("keydown",{self:this,expr:_expr,index:index},Component.IPMask.doKeyDown);	
		  $(jmask).bind("keyup paste",{expr:_expr,index:index}, function(event) {						
						var keyCode = event.keyCode;
						var val =$(this).val();
						var index = event.data.index;
						if (event.data.expr.test(val)) {
							$(this).val(val.replace(_expr, ""));
						}
												
						var value = parseInt($(this).val());
						if(!isNaN(value))
						{
							if(value<0)
							{
								$(this).val("");
							}else
							{
								$(this).val(value);
							}
						}else
						{
							$(this).val("");
						}
						if(value>255)
						{
							$(this).val(255);
							$(this).focus();
						}
						if(self.CanJump&&val>=100)
						{
							var nextField = self.getNextField(this);
							nextField.focus();
						}
						self.CanJump=true;
					});					
			$(jip).bind("keydown",{self:this,expr:_expr,index:index},Component.IPMask.doKeyDown);	
			$(jip).bind("keyup paste",{expr:_expr,index:index}, function(event) {
						var keyCode = event.keyCode;
						var val = $(this).val();
						var index = event.data.index;
						if (event.data.expr.test(val)) {
							$(this).val(val.replace(_expr, ""));
						}
						var value = parseInt($(this).val());
						if(!isNaN(value))
						{
							if(value<0)
							{
								$(this).val("");
							}else
							{
								$(this).val(value);
							}
						}else
						{
							$(this).val("");
						}
						if(index==1)
						{
							if(value>233)
							{
								$(this).val(223);
					        	$(this).focus();
							}
							if(value==127)
							{
								$(this).select();
							}
							if(value==0)
							{
								$(this).val("");
							}
							if(self.CanJump&&val>=100)
							{
								var nextField = self.getNextField(this);
								nextField.focus();
							}
						}else
						{
							if(value>255)
							{
								$(this).val(255);
					        	$(this).focus();
							}
							if(value==0)
							{
								$(this).val("0");
							}
							if(self.CanJump&&val>=100)
							{
								var nextField = self.getNextField(this);
								nextField.focus();
							}
						}
						self.CanJump=true;
					});	
		}
		
		this.log("ipAddressMask.bindIpEvents");
	}
	
	Component.IPMask.doPortKeyDown = function(event) {
		
		var self = event.data.self;
		var srcObj = event.target;
		var keyCode = event.keyCode;
		switch(keyCode)
		{
			case 190:
			case 110:
			break;
			case 39:
				break;
			case 40:
			break;
			case 37:
			{
			}
				break;
			case 38:
			break;
			case 8: 
			{
				var curPos = getCaret(srcObj);
				if (curPos == 0) {
					var id=srcObj.id;
					var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
					var lastMaskId = idPrefix+"mask_"+4;
					var field = document.getElementById(lastMaskId);					
					setCaret(field, 'end');
					self.CanJump=false;
					return event.returnValue = false;
				}
			}				

			break;
			case 13:
			break;
			case 9:
			break;
			default:
			return event.returnValue = true;
			
			
		}
	}
	Component.IPMask.doBlur = function(event)
	{
		var self = event.data.self;
		var _expr = event.data.expr;
		var value = $(this).val();
		var val = parseInt($(this).val());
		var index = event.data.index;
		var keyCode = event.keyCode;
		if (_expr.test(value)) {
			$(this).val(this.value.replace(_expr, ""));
		}
		
		if(!isNaN(val))
		{
			if(val<0)
			{
				$(this).val("");
			}else
			{
				if(index==1&val==0)
			    {
			    	$(this).val("");
			    }else{
					$(this).val(val);
				}
			}
		}else
		{
			$(this).val("");
		}
		
		var val = self.getValue();
		if(val!=null)
		{
			if(null!=self.parent)
			{
				self.parent.triggerChange();
			}
		}
		
	}
	Component.IPMask.prototype.bindPortEvent=function(portId)
	{
		var idPrefix = id.substring(0,id.lastIndexOf("_")+1);
		var jPortId = "#"+portId;
		var _expr = /\D/g;
		$(jPortId).bind("keydown keyup paste",{expr:_expr, max:65535, min:1}, function(event) {
						if (event.data.expr.test(this.value)) {
							this.value = this.value.replace(_expr, "");
						}
						var val = parseInt($(this).val());
						if(!isNaN(val))
						{
							if(val<0)
							{
								$(this).val("");
							}else
							{
								$(this).val(val);
							}
						}else
						{
							$(this).val("");
						}
						if (this.value>event.data.max){
							this.value = event.data.max;
						}
						if (this.value != '' && this.value < event.data.min){
							this.value = event.data.min;
						}
					});
		
		$(jPortId).mouseover(function(){
	      $(this).addClass('ireport-ui-text-mouseover'); 
	    }).mouseout(function(){ 
	      $(this).removeClass('ireport-ui-text-mouseover'); 
	    }); 
	    $(jPortId).bind("keydown",{self:this}, Component.IPMask.doPortKeyDown);
	    $(jPortId).bind("blur",{self:this,expr:_expr}, Component.IPMask.doBlur);				
	}
	Component.IPMask.prototype.createIPMask=function()
	{
		var str="<td class='ireport-ui-control-title'>&nbsp;</td><td class='ireport-ui-control-content'>"+ this.createIPMaskString() +"</td>";
		var strTR ="<tr nowrap='true'>"+str+"</tr>";	
		var tr = $(strTR);	
				
		tr.appendTo($("#"+this.tableId));
		
		this.ipCount++;
		this.MAX_INDEX++;
		var self =this;
		var newId=this.id+this.MAX_INDEX;
		var maskId=newId+"_mask_";
		var delButton = "#" + newId+"_del";
		var portPanel = "#" + newId+"_PanelAppendix";
		var fieldPort = newId+"_port";
		this.bindIpEvents(newId);
		this.log("绑定删除时间");
		$(delButton).bind("click",function()
		{
				if (tr.index() > 0){
					tr.remove();
					self.ipCount--;
				}
				self.log("ipAddressMask.delButton.EVT.click");
		});
		this.bindPortEvent(fieldPort);	
		this.log("ipAddressMask.createIPMask");
		
	}
	
	Component.IPMask.prototype.createIPMaskString = function()
	{
	   var strObj = new StringBuffer();
	   var curIndex=(this.MAX_INDEX+1);
	   var newId = this.id+curIndex;
	   var ulIPId=newId+"_ul_ip";
	   var ulMaskId=newId+"_ul_mask";
	   
	   var field1 = newId+"_1";
	   var field2 = newId+"_2";
	   var field3 = newId+"_3";
	   var field4 = newId+"_4";
	   var mask1= newId+"_mask_1";
	   var mask2= newId+"_mask_2";
	   var mask3= newId+"_mask_3";
	   var mask4= newId+"_mask_4";
	   var fieldPort = newId+"_port";
	   var hiddenField = newId+"-hidden";
	   var container=newId+"_container";
	   var delButton = newId+"_del";
	   var portPanel= newId + "_PanelAppendix";
	    strObj.append("<div class='ireport-ui-text-ip-mask-wrap'>");
		strObj.append("					  <div class='ireport-ui-text-ip-mask-panel'>");
		strObj.append("						<ul class='ireport-ui-text-ip-mask' id='"+ulIPId+"'>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("									<input type='text' id='"+field1+"' class='ireport-ui-text-ip-mask-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("								<input type='text' id='"+field2+"' class='ireport-ui-text-ip-mask-input' maxlength='3' />");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("								<input type='text' id='"+field3+"' class='ireport-ui-text-ip-mask-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("								<input type='text' id='"+field4+"' class='ireport-ui-text-ip-mask-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("						</ul>");
		strObj.append("						</div>");
		
		strObj.append("<div  class='ireport-ui-text-ip-mask-slash-splitter'>/</div>");
						
		strObj.append("					  <div class='ireport-ui-text-ip-mask-panel'>");
		strObj.append("						<ul class='ireport-ui-text-ip-mask' id='"+ulMaskId+"'>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("								<input type='text' id='"+mask1+"' class='ireport-ui-text-ip-mask-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("								<input type='text' id='"+mask2+"' class='ireport-ui-text-ip-mask-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("									<input type='text' id='"+mask3+"' class='ireport-ui-text-ip-mask-input' maxlength='3' />");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-splitter'>");
		strObj.append("								.");
		strObj.append("							</li>");
		strObj.append("							<li class='ireport-ui-text-ip-mask-field'>");
		strObj.append("									<input type='text' id='"+mask4+"' value='' class='ireport-ui-text-ip-mask-input' maxlength='3'/>");
		strObj.append("							</li>");
		strObj.append("						</ul>");
		strObj.append("						</div>");
		if(this.hasPort)
		{
			strObj.append("						<div class='ireport-ui-text-ip-mask-panel'>");
			strObj.append("						    	&nbsp;:");
			strObj.append("							    <input type='text' id='"+fieldPort+"' class='ireport-ui-text-ip-mask-port' value='' maxlength='5'/>");
			strObj.append("							    <span style='vertical-align:middle'>[1-65535]</span>");		
			strObj.append("						</div>");
		}
		strObj.append("						<div class='ireport-ui-text-ip-mask-panel'>");
		strObj.append("        <a title='删除' style='cursor: pointer;height:20px' id='"+delButton+"'><img style='vertical-align:middle' height='16' width='16' src='"+Component._PATH_+"images/delete.png'/>");
  	    strObj.append("						</div>");
		
		strObj.append("					</div>");
		this.log("ipAddressMask.createIPMaskString");
		return strObj;
	}
    Component.IPMask.prototype.addEvent=function(event)
    {
    	var that = event.data.target;
	   	try {
		   	var tbl = $("#" + that.tableId);
		   	
			var i = tbl.find(">tbody>tr").size();
			if (that.maxNum && !isNaN(that.maxNum) && (i + 1) > that.maxNum){
				alert($RRs.ip_alert_before+" "+ that.maxNum +" "+$RRs.ip_alert_after);
				return false;
			}
			
			that.createIPMask();		
		 }
		 catch(e) {
		   alert("IPMask create failed: " + e);
		 }
		 finally {
		   that.log("ipAddressMask.addEvent");
		 }   	   	
    }
    
	Component.IPMask.prototype.getValue=function()
	{
	    var self =this;
		var retVals=new Array(this.ipCount);
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
		$.each(rows, function(j, _row){
		     var inputList = $(_row).find(":input");
		     retVals[j]=inputList[0].value+"."+inputList[1].value+"."+inputList[2].value+"."+inputList[3].value+"/";
		     retVals[j]+=inputList[4].value+"."+inputList[5].value+"."+inputList[6].value+"."+inputList[7].value;
		     if(inputList.length==9)
		     {
		     	retVals[j]+=":"+inputList[8].value;
		     }
		});
		return retVals;
	}
    Component.IPMask.prototype.isFullIPMask=function(fields)
    {
      var self = this;
      var isCorrect=true;
    	$.each(fields, function(j, field){
	   		if($.trim($(field).val())=="")
	    	{
	    		isCorrect= false;
	    	}
    	});
    	return isCorrect;
    }
	Component.IPMask.prototype.getValues=function()
	{
	 	var self =this;
		var retVals=new Array();
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");		
		$.each(rows, function(j, _row){
		     var inputList = $(_row).find(":input");
		     var retVal=self.isFullIPMask(inputList);
		     if(retVal)
		     {
			     var tmpStr=inputList[0].value+"."+inputList[1].value+"."+inputList[2].value+"."+inputList[3].value+"/";
			     tmpStr+=inputList[4].value+"."+inputList[5].value+"."+inputList[6].value+"."+inputList[7].value;
			     if(inputList.length==9)
			     {
			     	tmpStr+=":"+inputList[8].value;
			     }
			     retVals[j] = {value:tmpStr,text:tmpStr};
		     }
		});
		return retVals;
	}
	
	Component.IPMask.prototype.adjustControlNums=function(num)
	{
		if(this.ipCount<num)
		{
			for(var i=0,len=num-this.ipCount;i<len;i++)
			{
				$("#" + this.addLinkId).trigger("click");
			}
		}
	}
	
	Component.IPMask.prototype.setValue=function(values)
	{
	    var self = this;
	    if(values === "undefined" || values === null)return;
	    this.adjustControlNums(values.length);
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");
		$.each(rows, function(j, _row){
		     var ipStr = values[j].value;
			 var arr = ipStr.split(/[\/\:]/);
			
		     var inputList = $(_row).find(":input");
		     $.each(inputList,function(i,input)
		     {
		        var ip=arr[0];
		        var mask=arr[1];
		        var aryIP = ip.split(".");
		        var aryMask=mask.split(".");
		        if(i<4){
		     	inputList[i%4].value=aryIP[i%4];
		     	}
		     	if(i>=4 && i<8)
		     	{
		     		inputList[i%8].value =aryMask[i%4];
		     		
		     	}
		     	if(i==8)
		     	{
		     	   $(input).val(arr[2]);
		     	 
		     	}
		      
		     	
		     });
		});

		this.log("ipAddressMask.setValue");
	}
	
	Component.IPMask.prototype.reset=function()
	{
		$("#" + this.tableId + " :text").val("");
		this.removeOthers();
		if(this.disabled){
			this.disable(this.disabled)
		}
	}
	Component.IPMask.prototype.disable = function(b)
	{
	   if(b)
	   {
	   	 this.enable(false)
	   }else
	   {
	   	 this.enable(true);
	   }
	}
	
	
	
	
	
	Component.IPMask.prototype.enable = function(b)
	{
		var rows = jQuery("#" + this.tableId).find(">tbody>tr");
		if(b){
			$.each(rows, function(i, _row){
			     var inputList = $(_row).find(":input");
			     $.each(inputList,function(i,input)
			     {
			     	$(input).removeAttr("disabled");
			     });
			});
			$("#" + this.addLinkId).bind("click",{target:this}, this.addEvent);
			$("#" + this.addLinkId).css("cursor", "pointer");
		}else
		{
			var rows = jQuery("#" + this.tableId).find(">tbody>tr");
			$.each(rows, function(i, _row){
			     var inputList = $(_row).find(":input");
			     $.each(inputList,function(i,input)
			     {			     	
			     	$(input).attr("disabled","true");
			     });			     
			});
			$("#" + this.addLinkId).unbind("click");
			$("#" + this.addLinkId).css("cursor", "default");
		}
		
		
		this.disabled=!b;
	}

	Component.IPMask.prototype._getFields=function() {
		var ctrlIP=this.id;
		var fieldArr = new Array(4);
		for (var i = 0; i < 4; i++) {
			fieldArr[i] = $(ctrlIP + (i + 1));
	
		}
		return fieldArr;
	}
	

	Component.IPMask.prototype.removeOthers=function()
	{
		$("#" + this.tableId).find("a>img").parent().trigger("click");
	}	
	Component.IPMask.prototype.clear = function()
	{
		$("#" + this.container).empty();
		this._init();
	
	} 
	
	ConditionMgr.functions["natureDate"] = function(configParams){
ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.fieldId = "txt_" + this.id;							
		this.fieldName = this.id + "_n";						
		this.containerId = this.id + "_container";				
		this.descId = "lbl_" + this.id;
		this.startTimeLong = 0;                                
		this.endTimeLong = 0;									
		this.dayType = this.dayType?this.dayType:"RANGE";		 			
		this.date_type = dateType;								
		this.date_quarter = dateQuarter;						
		this.date_month =  dateMonth;							
		this.data_week = data52Week; 							
		this.dateConfig = getDateConfig(this);					
		if(this.dateConfig === "")
		{
			this.dateConfig = "dateFmt:'"+Date_const.defaultDateFmt+"'";
			this.dateFmt = Date_const.defaultDateFmt;
		}
		this.date = new Date();
	},
	
	initDoms : function() {
		this.container = $("#" + this.containerId);
		var that = this;
		
		var tab = $("<table>",{cellspacing:'0',cellpadding:'0'}).appendTo(that.container);  
		var tr =$("<tr id='time_dateRange_tr_"+ this.id+"'></tr>").appendTo(tab);	
		var td = $("<td height='25'></td>").appendTo(tr);
		
		var tabInner=$("<table>",{cellspacing:'0',cellpadding:'0'}).appendTo(td);
		var trInner =$("<tr></tr>").appendTo(tabInner);
		var td1= $("<td></td>").appendTo(trInner);
		var td2= $("<td></td>").appendTo(trInner);
		var td3= $("<td></td>").appendTo(trInner);
		var td4= $("<td></td>").appendTo(trInner);
		var td5= $("<td></td>").appendTo(trInner);	
		var td6= $("<td></td>").appendTo(trInner);
		
		that.dateSelectType_div =$("<div id='dateSelectType_div_"+ this.id+"'></div>").appendTo(td1);
		that.dateText_div =$("<div id='dateText_div_"+ this.id +"' ></div>").appendTo(td2);
		that.year_div =$("<div id='year_div_"+ this.id +"'  ></div>").appendTo(td3);
		that.month_div =$("<div id='month_div_"+ this.id +"'  ></div>").appendTo(td4);
		that.quarter_div =$("<div id='quarter_div_"+ this.id +"'  ></div>").appendTo(td5);
		that.week_div =$("<div id='week_div_"+ this.id +"' ></div>").appendTo(td6);
		that.week_div.hide();
		that.month_div.hide();
		that.quarter_div.hide();
		that.year_div.hide();
		
		if('POINT'==this.dayType.toUpperCase())
		{
			that.dateText = $("<input class='Wdate' type='text' onClick=\"WdatePicker({"+that.dateConfig+"})\"/>")
			.attr({
				name:that.fieldName
			});
			that.dateText.val(toStringByPattern(that.date,that.dateFmt)).appendTo(that.dateText_div);   								
		}
		if('RANGE'==this.dayType.toUpperCase())
		{
			that.day1 = jQuery("<input id='txt_start_day_"+this.id+"' class='Wdate' type='text' onClick=\"WdatePicker({"+this.dateConfig+"})\"/>")
			.bind('focus',function(){
			    jQuery(this).css("border","1px solid #7EADD9");
			})
			.bind('blur',function(){
			    if(this.value==''||this.value==null){
			       jQuery(this).css("border","1px solid #DD7870");
			    }else{
			    	jQuery(this).css("border","1px solid #B5B8C8");
			    }
			 })
			.appendTo(that.dateText_div);
			that.label2 = jQuery("<label>"+$RRs.cbd_to+"</label>").appendTo(that.dateText_div);
			that.day2 = jQuery("<input id='txt_end_day_"+this.id+"' class='Wdate' type='text'  onClick=\"WdatePicker({"+this.dateConfig+"})\"/>")
			.bind('focus',function(){
			    jQuery(this).css("border","1px solid #7EADD9");
			})
			.bind('blur',function(){
			    if(this.value==''||this.value==null){
			       jQuery(this).css("border","1px solid #DD7870");
			    }else{
			    	jQuery(this).css("border","1px solid #B5B8C8");
			    }
			 })
			.appendTo(that.dateText_div);
			
			that.day1.val(toStringByPattern(new Date(that.date.getTime()-86400000),that.dateFmt));
			that.day2.val(toStringByPattern(that.date,that.dateFmt));
			that.day1Change();
			that.day2Change();
		}
		
		that.dateSelectType_sel = createSelectDoms("dateSelectType_div_"+ this.id,"dateSelectType_id_"+this.id,"dateSelectType_n"+this.id,that.date_type,'1');   
		that.week_sel = createSelectDoms("week_div_"+ that.id,"week_select_id_"+that.id,"week_select_name"+that.id,that.data_week,that.initWeek());  				
		that.month_sel = createSelectDoms("month_div_"+ that.id,"month_select_id_"+that.id,"month_select_name"+that.id,that.date_month,that.initMonth());			
		that.quarter_sel = createSelectDoms("quarter_div_"+ that.id,"quarter_select_id_"+that.id,"quarter_select_name"+that.id,that.date_quarter,that.initQuarter());	
		that.year_sel = createSelectDoms("year_div_"+ that.id,"year_select_id_"+that.id,"year_select_name"+that.id,that.initYears(),that.date.getFullYear()+'');				
		that.dateSelectType_div.append(that.dateSelectType_sel);
		that.week_div.append(that.week_sel);
		that.month_div.append(that.month_sel);
		that.quarter_div.append(that.quarter_sel);
		that.year_div.append(that.year_sel);
	},
	
	initEvents : function() {
		var that = this;
		that.dateSelectType_sel.bind('change',function(){
			that.dateSelectTypeChange();
		});
		that.week_sel.bind('change',function(){
			that.weekChange();
		});
		that.month_sel.bind('change',function(){
			that.monthChange();
		});
		that.quarter_sel.bind('change',function(){
			that.quarterChange();
		});
		that.year_sel.bind('change',function(){
			that.yearChange();
		});
	},

	beforeShowData : function() {
		this.clear();
	},

	showData : function() {},

	afterShowData : function() {
		var that = this;
		$("#" + that.fieldId).bind("change", function(event){
			var target = event.target;
			if (target.value !== ""){
				$("#" + that.descId).text(target.value).attr("title", target.value);
			}
		});
		this.checkItems();
	},
	checkItems : function() {
		this.disable(this.disabled);
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		$("#" + this.containerId).empty();
	},

	getValueWithText : function() {
		if(!this.isTrue(this.required))
		{
			this.setTimeByText();
		}
		return this.getSimpleValue();
	},
	getSimpleValue : function() {
		var that = this;
		var startTime = toStringByPattern(new Date(this.startTimeLong*1000),"yyyy-MM-dd HH:mm:ss");
		var endTime = toStringByPattern(new Date(this.endTimeLong*1000),"yyyy-MM-dd HH:mm:ss");
		
		var type = that.dateSelectType_sel.val();
		var timeVal="";
		switch (type)
		{
			case "1":
			{
				if('POINT'==this.dayType.toUpperCase())
				{
					timeVal = that.dateText.val();
				}
				if('RANGE'==this.dayType.toUpperCase())
				{
					timeVal = that.day1.val()+"&"+that.day2.val();
				}
				break;
			}
			case "2":
			{
				timeVal = that.year_sel.val()+"-"+that.week_sel.val();
				break;
			}
			case "3":
			{
				timeVal = that.year_sel.val()+"-"+that.month_sel.val();
				break;
			}
			case "4":
			{
				timeVal = that.year_sel.val()+"-"+that.quarter_sel.val();
				break;
			}
		}
		return [{value: ""+this.startTimeLong , text: startTime},{value: ""+this.endTimeLong ,text:endTime},{value:type,text:timeVal}];
	},

	setValue : function(v) {
		if (null != v && v != undefined){
			var that = this;
			var type=v[2].value;
			var timeVal = v[2].text.split("-");
				that.year_div.hide();
				that.quarter_div.hide();
				that.month_div.hide();
				that.week_div.hide();
				that.dateText_div.hide();
			switch (type)
			{
				case "1":
				{
					timeVal = v[2].text.split("&");
					if('POINT'==this.dayType.toUpperCase())
					{
						that.dateText.val(timeVal);
					}
					if('RANGE'==this.dayType.toUpperCase())
					{
						that.day1.val(timeVal[0]);
						that.day2.val(timeVal[1]);
					}					
					that.dateSelectType_sel.val("1");
					that.dateText_div.show();
					break;
				}
				case "2":
				{
					that.dateSelectType_sel.val("2");
					that.year_sel.val(timeVal[0]);
					that.week_sel.val(timeVal[1]);
					that.year_div.show();
					that.week_div.show();
					break;
				}
				case "3":
				{
					that.dateSelectType_sel.val("3");
					that.year_sel.val(timeVal[0]);
					that.month_sel.val(timeVal[1]);
					that.year_div.show();
					that.month_div.show();
					break;
				}
				case "4":
				{
					that.dateSelectType_sel.val("4");
					that.year_sel.val(timeVal[0]);
					that.quarter_sel.val(timeVal[1]);
					that.year_div.show();
					that.quarter_div.show();
					break;
				}
			}
		}
	},
	disable : function(b) {
		var bn = b ? true : false;
		if(b)
		{
			this.dateSelectType_sel.attr("disabled", true);
			this.week_sel.attr("disabled", true);
			this.month_sel.attr("disabled", true);
			this.quarter_sel.attr("disabled", true);
			this.year_sel.attr("disabled", true);
			if('POINT'==this.dayType.toUpperCase())
			{
				this.dateText.attr("disabled","disabled");
			}
			if('RANGE'==this.dayType.toUpperCase())
			{
				this.day1.attr("disabled","disabled");
				this.day2.attr("disabled","disabled");
			}
		}
		else
		{
			this.dateSelectType_sel.removeAttr("disabled");
			this.week_sel.removeAttr("disabled");
			this.month_sel.removeAttr("disabled");
			this.quarter_sel.removeAttr("disabled");
			this.year_sel.removeAttr("disabled");
			if('POINT'==this.dayType.toUpperCase())
			{
				this.dateText.removeAttr("disabled");
			}
			if('RANGE'==this.dayType.toUpperCase())
			{
				this.day1.removeAttr("disabled");
				this.day2.removeAttr("disabled");
			}
		}
		this.isEnable=!bn;
	},
	checkData : function() {
		this.setTimeByText();
		var rstObj = {success : true,msg : ''};
		if (this.isTrue(this.required) && ("1"==this.dateSelectType_sel.val()&&((this.day1.val()===''|| this.day2.val()==='')))) 
		{
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date;
		}else if(!isCorrectFormat(this.dateFmt,this.day1.val())){
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
		}else if(!isCorrectFormat(this.dateFmt,this.day2.val())){
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
		}else if(this.startTimeLong>this.endTimeLong)
		{
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_error;
		}
		return rstObj;
	},
	
	dateSelectTypeChange:function(){
		var that = this;
		var type = that.dateSelectType_sel.val();
		switch (type)
		{
			case "1":
			{
				that.year_div.hide();
				that.quarter_div.hide();
				that.month_div.hide();
				that.week_div.hide();
				that.dateText_div.show();
				break;
			}
			case "2":
			{
				that.dateText_div.hide();
				that.quarter_div.hide();
				that.month_div.hide();
				that.year_div.show();
				that.week_div.show();
				that.weekChange();
				break;
			}
			case "3":
			{
				that.dateText_div.hide();
				that.quarter_div.hide();
				that.week_div.hide();
				that.year_div.show();
				that.month_div.show();
				that.monthChange();
				break;
			}
			case "4":
			{
				that.dateText_div.hide();
				that.month_div.hide();
				that.week_div.hide();
				that.year_div.show();
				that.quarter_div.show();
				that.quarterChange();
				break;
			}
		}
	},
	dayChange:function(){
		var that = this;
		var date_txt = that.dateText.val();
		if(date_txt==undefined||date_txt.length<10)
		{
			return;
		}
		var yearVal = date_txt.substr(0,4);
		var monthVal = date_txt.substr(5,2);
		var dayVal = date_txt.substr(8,2);
		that.startTimeLong = new Date(yearVal,monthVal-1,dayVal).getTime()/1000;
		that.endTimeLong = that.startTimeLong+86400-1;
	},
	
	day1Change:function(){
		var that = this;
		var date_txt = that.day1.val();
		if(date_txt==undefined||date_txt.length<10)
		{
			return;
		}
		var yearVal = date_txt.substr(0,4);
		var monthVal = date_txt.substr(5,2);
		var dayVal = date_txt.substr(8,2);
		that.startTimeLong = new Date(yearVal,monthVal-1,dayVal).getTime()/1000;
	},
	
	day2Change:function(){
		var that = this;
		var date_txt = that.day2.val();
		if(date_txt==undefined||date_txt.length<10)
		{
			return;
		}
		var yearVal = date_txt.substr(0,4);
		var monthVal = date_txt.substr(5,2);
		var dayVal = date_txt.substr(8,2);
		that.endTimeLong = new Date(yearVal,monthVal-1,dayVal).getTime()/1000+86400-1;
	},
	
	weekChange:function(){
		var that = this;
		var yearVal = new Number(that.year_sel.val());
		var weekVal = that.week_sel.val();
		var date = new Date(yearVal,0,1,0,0,0);
		var weekOfYear = getWeekOfYear(date);
		var dayOfWeek = date.getDay();
		if(1!=weekOfYear)
		{
			date = new Date(yearVal,0,(8-dayOfWeek));
		}
		else
		{
			date = new Date(date.getTime() - 86400000 * dayOfWeek);
		}
		var secondsOfWeek = 604800;
		that.startTimeLong = date.getTime()/1000 + (weekVal-1)*secondsOfWeek;
		that.endTimeLong = that.startTimeLong + (secondsOfWeek-1);
	},
	
	monthChange:function(){
		var that = this;
		var yearVal = new Number(that.year_sel.val());
		var monthVal = that.month_sel.val();
		that.startTimeLong = new Date(yearVal,monthVal-1,1,0,0,0).getTime()/1000;
		that.endTimeLong = new Date(monthVal==12?1+yearVal:yearVal,monthVal==12?0:monthVal).getTime()/1000-1;
	},
	
	quarterChange:function(){
		var that = this;
		var yearVal = new Number(that.year_sel.val());
		var quarterVal = that.quarter_sel.val();
		var startMonth = (quarterVal-1)*3;
		var endMonth = quarterVal*3;
		that.startTimeLong = new Date(yearVal,startMonth,1,0,0,0).getTime()/1000;
		that.endTimeLong = new Date(endMonth==12?1+yearVal:yearVal,endMonth==12?0:endMonth).getTime()/1000-1;
	},
	
	yearChange:function(){
	    var that = this;
		var type = that.dateSelectType_sel.val();
		switch (type)
		{
			case "2":
			{
				that.weekChange();
				break;
			}
			case "3":
			{
				that.monthChange();
				break;
			}
			case "4":
			{
				that.quarterChange();
				break;
			}
		}
	},
	
	initYears:function(){
		if(this.minDate===undefined || new Number(this.minDate)<Date_const.minDate)
		{
			this.minDate = Date_const.minDate;
		}
		if(this.maxDate===undefined || new Number(this.maxDate)<Date_const.maxDate)
		{
			this.maxDate = Date_const.maxDate;
		}
		minDate = new Number(this.minDate);
		maxDate = new Number(this.maxDate);
		var lengths = maxDate-minDate+1;
		var date_year = new Array(lengths);
		for(var i=0;i<lengths;i++)
		{
			var temp_Array = new Array(2);
			temp_Array[0] = minDate+i+'';
			temp_Array[1] = minDate+i+'';
			date_year[i] = temp_Array;
		}
		return date_year;
	},
	initQuarter:function(){
		switch(this.date.getMonth())
		{
			case 0 :
			case 1 :
			case 2 :
			{
				return '1';
				break;
			}
			case 3 :
			case 4 :
			case 5 :
			{
				return '2';
				break;
			}
			case 6 :
			case 7 :
			case 8 :
			{
				return '3';
				break;
			}
			case 9 :
			case 10 :
			case 11 :
			{
				return '4';
				break;
			}
		}
	},
	
	initMonth:function(){
		return (this.date.getMonth()+1)+'';
	},
	
	initWeek:function(){
	    var week = getWeekOfYear(this.date);
		if(week>52)
		{
			return 52;
		}
		else
		{
			return ''+week;
		}
	},
	setTimeByText:function()
	{
		var type = this.dateSelectType_sel.val();
		if(type == 1)
		{
			if('POINT'==this.dayType.toUpperCase())
			{
				this.dayChange();
			}
			if('RANGE'==this.dayType.toUpperCase())
			{
				this.day1Change();
				this.day2Change();
			}
		}
	}
})));
};ConditionMgr.functions["radioGroup"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    
    initProperties : function() {
        this.labelContainerId = this.id + "_label";
        this.displayField = ((this.displayField == 'key')||(this.displayField == 'value')) ? this.displayField : "value";
        this.valueField = ((this.valueField == 'key') || (this.valueField == 'value')) ? this.valueField : "key";
        this.columns = ConditionUtils.df(this.columns, 4);
        this.rdName = this.id + "_rds";
        this.containerId = this.id + "_container";
        this.cutNum = this.cutNum;
    },
    _init : function(_data){
        var that = this;
        ConditionUtils.createChooseObjGroup({
            containerId : this.containerId,
            name : this.rdName,
            data : _data,
            cutNum : this.cutNum,
            valueField : this.valueField,
            displayField : this.displayField,
            columns : this.columns,
            type : "radio"
        });
        this._addEvent();
    },
    _addEvent : function(){
        var that = this;
        var radioContain = jQuery("#" + this.containerId + ">table");
        var rdName = this.rdName;
        jQuery.each(this.getRadios().find(".x-form-radio-wrap-inner"),function(index,n){
           jQuery(this).bind('click',function(){
               var currentRadioId = rdName + "_" + index;
               that.clickHandle(jQuery(this), radioContain, currentRadioId);
           });
        });
    },
    changeOptions : function(_data){
        this.clear();
        this._init(_data);
        this.checkItems();
    },
    isLoaded : function(){
        return true;
    },
    initDoms : function() {
        if (!this.container){
            this.container = jQuery("#" + this.containerId);
        }
        var h = this.groupHeight;
        h = parseInt(h);
        h = isNaN(h)?false:h;
        if(h) {
            this.container.addClass("cbb-cbgroup-ct");
            this.container.css({ 
                overflowX: "hidden",
                overflowY:"scroll"
            });
            this.container.css("height", h + "px");
        }
        this._addEvent();
    },

    initEvents : function() {
        this.events.push("itemClick");
    },

    beforeShowData : function() {
        this.clear();
        jQuery("#" + this.containerId).hide();
    },

    showData : function() {
        this._init(this.resultData.data);
    },

    afterShowData : function() {
        delete this.defaultValue;
        this.checkItems();
        jQuery("#" + this.containerId).show();
    },
    checkItems : function() {
        if (this.getRadios().size() > 0) {
            if (this.isTrue(this.disabled)){
                this.disable(true);
            }
 
            if (this.checkedItems) {
                this.selectRadio(this.checkedItems);
            } else {
                this.getRadios().first().find(".x-form-radio-wrap-inner").trigger('click');;
            }
            
            this.disableItems(this.disabledItems, true);
        }
    },

    beforeInitComplete : function() {
        this.checkItems();
    },
    reset:function(){
        this.checkItems();
        this.publishEvent("onValueChange");
    },
    clear : function() {
        jQuery("#" + this.containerId).empty();
    },
    getRadios : function(param) {
        var allRadio = jQuery("#" + this.containerId + ">table>tbody>tr>td").find('.x-form-radio-wrap');
        if (param){
            if (param.flag && param.flag == 'checked'){
                return allRadio.filter(".x-form-check-checked");
            }else if (param.flag && param.flag == 'enabled'){
                return allRadio.not(jQuery(".x-item-disabled"));
            }
        }
        return allRadio;
    },
    getValueWithText : function() {
        return this.getRadios({flag:'checked'}).map(function() {
            var inputElt = jQuery(this).find(":input[type='radio']");
            var title = inputElt.next().attr('title');
            var v = inputElt.attr('value');
            var t = inputElt.data("text");
            if(!t){
                t = jQuery.trim(inputElt.next().attr('title'));
            }
            
            return {
                value : v,
                text : t
            };
        }).get();
    },
    getSimpleValue : function() {
        return this.getRadios({flag:'checked'}).map(function(){
            return jQuery(this).find(":input[type='radio']").attr("value");
        }).get().join(",");
    },
    setValue : function(values){
        this.getRadios({flag:'checked'}).removeClass('x-form-check-checked');
        
        var that = this;
        jQuery.each(values, function(i, obj){
            that.selectRadio(obj["value"]);
        });
    },
     selectRadio: function(v) {
        this.getRadios({flag:'checked'}).removeClass('x-form-check-checked');
        var that = this;
        if (v) {
            that.getObjByValue(v).parent('div').parent('div').addClass('x-form-check-checked');
            that.getObjByValue(v).parent('div').trigger('click');
        }
    },
    getObjByValue : function(v){
        return jQuery("#" + this.containerId).find(":radio:[name=" + this.rdName
                    + "][value=" + v + "]");
        
        
    },
   	disableItems : function(ids, b) {
        var that = this;
        var arrIds;
        if (!ids) {
            return;
        }
        else if (ids == "all")
        {
            if (b){
                jQuery.each(this.getRadios(), function(index){
                var rd = jQuery(this).find(".x-form-radio-wrap-inner").unbind()
                                     .addClass('x-item-disabled');
                });
            }else{
                var radioContain = jQuery("#" + this.containerId + ">table");
                jQuery.each(this.getRadios({flag:'enabled'}).find(".x-form-radio-wrap-inner"), function(){
                   jQuery(this).bind('click',function(){
		               var currentRadioId = jQuery(this).find(":input[type='radio']").attr("id");
		               that.clickHandle(jQuery(this), radioContain, currentRadioId);		               
                   }).removeClass('x-item-disabled');
                });
            }
        }
        else
        {
            arrIds = ids.split(",");
            if (b){
                jQuery.each(arrIds, function(i, _id){
	                that.getObjByValue(_id).parent('div').unbind()
	                             .parent('div').addClass('x-item-disabled');
                });
            }else{
                var radioContain = jQuery("#" + that.containerId + ">table");
                jQuery.each(arrIds, function(i, _id){
	                   that.getObjByValue(_id).parent('div').bind('click',function(){
			               var currentRadioId = that.getObjByValue(_id).attr("id");
			               that.clickHandle(jQuery(this), radioContain, currentRadioId);
	                }).parent('div').removeClass('x-item-disabled');
                });
            }
        }
    },
    clickHandle : function(curObj, containObj, curRadioId){
        var that = this;
	    var otherRadioId = containObj.find(":input[id!='" + curRadioId + "']").parent('div').parent('div');
	    
        jQuery.each(otherRadioId,function(){
           jQuery(this).removeClass("x-form-check-checked");
        })
        if (!curObj.parent("div").hasClass("x-form-check-checked")){
           curObj.parent("div").addClass("x-form-check-checked");
        }
        that.publishEvent("onValueChange");      
    },
    disable : function(b){
       this.disableItems("all", b);
       this.isEnable=!b;
    },
    checkData : function() {
        if (this.required != undefined && this.isTrue(this.required)
                && this.getSimpleValue().length == 0) {
            return {
                success : false,
                msg : this.blankValidateText
            };
        } else {
            return {
                success : true,
                msg : ""
            };
        }
    },
    afterComplete : function(){
        this.checkItems();
    }
})));
};ConditionMgr.functions["select"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.labelContainerId = this.id + "_label";
		this.containerId = this.id + "_container";
		this.cmbObj = null;
		this._keyF = ((this.valueField == 'key') || (this.valueField == 'value')) ? this.valueField : "key";
		this._valueF = ((this.displayField == 'key')||(this.displayField == 'value')) ? this.displayField : "value";
		this.initV;
        this.starLabelId ="starlbl_" + this.id;
		this.containerHelpId = this.id + "_help";		
		this.descId = "lbl_" + this.id;
	},
	isLoaded : function(){
		return this.cmbObj ? true : false;
	},
	changeOptions : function(_data){
        var that = this;
		this.clear();
		this.cmbObj = this._createCmbobox(_data);
		this.initV = this.getValueWithText().text;
		this.cmbObj.bind("change", function(event){
			that.publishEvent("onValueChange");
		});
		this.publishEvent("onValueChange");
	},
	initDoms : function(){
	    var that = this;
	    var starLabel = jQuery("<label/>").attr({
				id : that.starLabelId
			});
		$("#" + this.containerHelpId).append(starLabel);
		if(this.required){
		    starLabel.text("*").css("color","#D60606").css("padding-left","3px").css("vertical-align","middle");  
		}
		var descLabel = jQuery("<label/>").attr({
				id : that.descId
			});
		$("#" + this.containerHelpId).append(descLabel);
		
		if (that.desc){
		    var desc = $C.truncationStr(that.desc, labelLength);
            descLabel.text(desc).attr('title',that.desc).css("padding-left","3px"); 
		}
		
		this._init();
	},
	_createCmbobox: function(_data){
		var that = this;
		
        if (_data){
			return ConditionUtils.createSimpleSelect({
				id : that.id,
				container : "#" + that.containerId,
				name : that.id,
				data : _data,
				triggerSelected : true,
				emptyText : that.blankValidateText,
				key : that._keyF,
				value : that._valueF
			});
        }else{
            return jQuery("#"+this.id);
        }
	},
	_init : function(_data){
		var that = this;
		var container = jQuery("#" + this.containerId);
		if (_data){
			that.resultData.data = _data;
        }
        if (that.blankOption) {
	            var obj = {};
	            obj[that._keyF] = "";
	            obj[that._valueF] = that.blankOption;
	            that.resultData.data.unshift(obj);
        }
        this.cmbObj = this._createCmbobox(this.resultData.data);
		this.cmbObj.bind("change", function(event){
			that.publishEvent("onValueChange");
		});
		this.initV = this.getValueWithText().value;

		this.checkItems();
	},
	showData : function() {
		this.clear();
		this._init();
		this.publishEvent("onValueChange");
	},
	checkItems : function(){
		var that = this;
		this.disable(this.isTrue(this.disabled));
		if (this.defaultValue){
			this.cmbObj.val(this.defaultValue);
		}
	},
	afterShowData : function() {
		this.checkItems();
	},
	getValueWithText : function() {
		var tv = jQuery("#" + this.id + ">option:selected").text();
		var hv = this.cmbObj.val();
		if (tv != this.blankOption) {
			hv = hv == '' ? tv : hv;
		}
		return {
			value : hv,
			text : tv
		};
	},

	clear : function() {
		jQuery("#" + this.containerId).empty();
	},
	reset : function() {
		this.setValue(this.initV);
		this.checkItems();
		this.publishEvent("onValueChange");
	},
	getSimpleValue : function() {
		var tv = jQuery("#" + this.id + ">option:selected").text();
		var hv = this.cmbObj.val();
		if (tv != this.blankOption) {
			hv = hv == '' ? tv : hv;
		}
		return hv;
	},
	setValue : function(obj) {
		this.cmbObj.val(obj["value"]);
	},
	disable : function(b) {
		var that = this;
		jQuery("#" + that.id).attr("disabled", b);
		this.isEnable=!b;
	},
	checkData : function() {
		var resObj = {
			success : true,
			msg : ''
		};
		var v = this.getSimpleValue();
		if (!this.cmbObj || (this.cmbObj
				&& (this.isTrue(this.required) && (v == ''
						|| v == this.blankOption)))) {
			resObj.success = false;
			resObj.msg = this.blankValidateText;
		}
		return resObj;
	}
})));
};
ConditionMgr.functions["simpleDate"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.fieldId = this.id;						
		this.fieldName = this.id + "_n";						
		this.containerId = this.id + "_container";				
		this.descId = "lbl_" + this.id;
		this.dateConfig = getDateConfig(this);
		if(this.dateConfig === "")
		{
			this.dateConfig = "dateFmt:'"+Date_const.defaultDateFmt+"'";
			this.dateFmt = Date_const.defaultDateFmt;
		}
		
		this.containerHelpId = this.id + "_help";				
		this.descId = "lbl_" + this.id;
	},

	initDoms : function() {
		this.container = jQuery("#" + this.id);
		var that = this;

		this.container.val(toStringByPattern(new Date(),that.dateFmt));
		
		var descLabel = jQuery("<label/>").attr({
				id : this.descId
			});
		$("#"+this.containerHelpId).append(descLabel);
		
		if (this.desc){
		if(that.required){
			descLabel.text($C.truncationStr(that.desc, labelLength)).addClass("ireport-ui-label").css("padding-left","10px");
		}else{
		    descLabel.text($C.truncationStr(that.desc, labelLength)).addClass("ireport-ui-label");
		}	
		}
	},

	initEvents : function() {
	},

	beforeShowData : function() {
		this.clear();
	},

	showData : function() {
	},

	afterShowData : function() {
		var that = this;
		jQuery("#" + that.fieldId).bind("change", function(event){
			var target = event.target;
			if (target.value !== ""){
				jQuery("#" + that.descId).text(target.value).attr("title", target.value);
			}
		});
		this.checkItems();
	},
	checkItems : function() {
		this.disable(this.isTrue(this.disabled));
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		jQuery("#" + this.containerId).empty();
	},

	getValueWithText : function() {
		var v = jQuery("#"+this.fieldId).val();
		return {value:getLongTimeByFmt(v),text:v};
	},
	getSimpleValue : function() {
		var v = jQuery("#"+this.fieldId).val();
		return {value:getLongTimeByFmt(v),text:v};
	},

	setValue : function(v) {
		if (null !== v && v !== undefined){
			jQuery("#" + this.fieldId).val(v.text);
		}
	},
	disable : function(b) {
		var bn = b ? true : false;
		jQuery("#" + this.fieldId).attr("disabled", b);
		this.isEnable=!bn;
	},
	checkData : function() {
		var rstObj = {
			success : true,
			msg : ''
		};
		var v = jQuery("#"+this.fieldId).val();
		if (this.isTrue(this.required) && v == '') {
				rstObj.success = false;
				rstObj.msg = $RRs.comm_vail_date;
		} 
		else if(!isCorrectFormat(this.dateFmt,v))
		{
			rstObj.success = false;
			rstObj.msg = $RRs.comm_vail_date_format;
		}
		else 
		{
				success = true;
				msg = "";
		}
		return rstObj;
	}
})));
};ConditionMgr.functions["textArea"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.labelContainerId = this.id + "_label";
		this.fieldName = this.id + "_n";
		this.containerId = this.id + "_container";
		this.descId = "lbl_" + this.id;
	},

	initDoms : function() {
		this.jContainer = jQuery("#" + this.containerId);

		var that = this;
		var jTextArea = jQuery("#"+this.id);
		
		
		var len;
		if(this.textLength) {
			len = parseInt(this.textLength);
			len = isNaN (len)?false:len;
		}
		if(len) {
			jTextArea.keydown(function(e){
				if(this.value.length <= len) 
					this.oldText = this.value;
			}).bind("keyup blur", function(){
				if(this.value.length > len) {
					this.value = this.oldText;
				}
			})
		}
		
		var jDesLabel = jQuery("<label/>").addClass("cbb-textarea-destext").attr("id", this.descId).appendTo(this.jContainer);
		if(this.desc) {
            jDesLabel.text($C.truncationStr(this.desc, 10)).attr("title", this.desc);
		}
	},

	initEvents : function() {
	},

	beforeShowData : function() {
		this.clear();
	},

	showData : function() {
	},

	afterShowData : function() {
		this.checkItems();
	},
	checkItems : function() {
		if (this.disabled){
			this.disable(this.isTrue(this.disabled));
		}
		if(this.initValue) {
			jQuery("#"+this.id).val(this.initValue);
		}
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		jQuery("#" + this.containerId).empty();
	},
	reset : function(){
		jQuery("#"+this.id).val("");
		this.checkItems();
	},
	getValueWithText : function() {
		var v = jQuery("#"+this.id).val();
		return {value:v,text:v};
	},
	getSimpleValue : function() {
		return jQuery("#" + this.id).val();
	},

	setValue : function(obj) {
		if (obj != undefined){
			jQuery("#" + this.id).val(obj["value"]);
		}
	},
	disable : function(bn) {
		jQuery("#" + this.id).attr("disabled", bn);
		this.isEnable=!bn;
	},
	checkData : function() {
		if (this.required != undefined && this.isTrue(this.required) && this.getSimpleValue() == '') {
			return {
				success : false,
				msg : this.blankValidateText
			};
		} else {
			return {
				success : true,
				msg : ""
			};
		}
	}
})));
};ConditionMgr.functions["textField"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.labelContainerId = this.id + "_label";
		this.fieldName = this.id + "_n";
		this.containerId = this.id + "_container";
		this.descId = "lbl_" + this.id;
		this.starLabelId ="starlbl_" + this.id;
		this.flag = true;
		this.invalidText = "";
		this.size = this.size ? this.size : '';
		this.initValue = this.initValue ?this.initValue:'';
	},

	initDoms : function() {
		var that = this;
		this.container = jQuery("#" + this.containerId);
		var that = this;
		var _input = jQuery("#"+this.id);
		that.container.append(_input);
		if (that.size && !isNaN(that.size)){
			_input.attr("size", that.size);
		}

        var starLabel = jQuery("<label/>").attr({
				id : that.starLabelId
			});
		that.container.append(starLabel);
		var wrapId = "lbl_" + this.id;
		if(this.required && this.required=='true'){
		    starLabel.text("*").css("color","#D60606").css("padding-left","5px").css("vertical-align","middle");  
		}
		
		var descLabel = jQuery("<label/>").attr({
				id : that.descId
			});
		that.container.append(descLabel);
		if (that.desc){
			descLabel.text($C.truncationStr(that.desc, labelLength)).addClass("ireport-ui-label").attr("title", that.desc );
		}
		
	},
	_check : function(that){
		var jField = jQuery("#" + that.id);
			if (that.regex || that.minNum || that.maxNum) {
				jField.attr("title", "").css({
							"border-color":"",
							"border-style":""});
				var _expr = new RegExp(that.regex);
				if (!_expr.test(jField.val())) {
					that.flag = false;
					that.invalidText = that.regexText;
					jField.attr("regex", that.regex);
					jField.attr("regexText", that.regexText)
					.css({
							"border-color":"#D60606",
							"border-style":"solid"
							});
					return false;
				}
				if (that.minNum && !isNaN(that.minNum)) {
					var min = parseInt(that.minNum);
					if (min > parseInt(jField.val())) {
						that.flag = false;
						that.invalidText = that.regexText;
						jField.attr("regex", that.regex);
						jField.attr("regexText", that.regexText)
						.css({
							"border-color":"#D60606",
							"border-style":"solid"
							});
						return false;
					}
				}
				if (that.maxNum && !isNaN(that.maxNum)) {
					var max = parseInt(that.maxNum);
					if (max < parseInt(jField.val())) {
						that.flag = false;
						that.invalidText = that.regexText;
						jField.attr("regex", that.regex);
						jField.attr("regexText", that.regexText)
						.css({
							"border-color":"#D60606",
							"border-style":"solid"
							});
						return false;
					}
				}
				if(that.minNum && !isNaN(that.minNum) && that.maxNum && !isNaN(that.maxNum)){
					var max = parseInt(that.maxNum);
					var min = parseInt(that.minNum);
					if(min <=parseInt(jField.val()) && max >= parseInt(jField.val()))
					{
						that.flag = true;
						that.invalidText = that.regexText;
						jField.attr("regex", that.regex);
						jField.attr("regexText", "");
						jField.css({
								"border-color":""});
						return true;
					}	
				}
			}
			that.flag = true;
			return true;
	},
	_checkEvent : function(event) {
		var that = event.data.target;
		that._check(that);
	},
	initEvents : function() {
		var that = this;
		jQuery("#" + that.id).bind("change blur",{target:that}, this._checkEvent);
		
		if (that.filterReg) {
			var _expr = new RegExp(that.filterReg);
			jQuery("#" + that.id).bind({
				keydown : function(event) {
					if (_expr.test(this.value)) {
						this.value = this.value.replace(_expr, "");
					}
				},
				keyup : function(event) {
					if (_expr.test(this.value)) {
						this.value = this.value.replace(_expr, "");
					}
				},
				paste : function(event) {
					var text = ConditionUtils.getClipboardText();
					if (_expr.test(text)) {
						return false;
					}
				}
			});
		}
	},

	beforeShowData : function() {
		this.clear();
	},

	showData : function() {
	},

	afterShowData : function() {
		var that = this;
		this.checkItems();
	},
	checkItems : function() {
		if (this.isTrue(this.disabled)){
			this.disable(this.isTrue(this.disabled));
		}
	},

	beforeInitComplete : function() {
		this.checkItems();
	},

	clear : function() {
		jQuery("#" + this.containerId).empty();
	},
	reset : function(){
		jQuery("#" + this.id).val("");
	},
	getValueWithText : function() {
		var v = jQuery("#" + this.id).val();
		return {
			value : v,
			text : v
		};
	},
	getSimpleValue : function() {
		return jQuery("#" + this.id).val();
	},

	setValue : function(obj) {
		if (obj != undefined) {
			jQuery("#" + this.id).val(obj["value"]);
		}
	},
	disable : function(bn) {
		jQuery("#" + this.id).attr("disabled", bn);
		this.isEnable=!bn;
	},
	checkData : function() {
		var rstObj = {
			success : true,
			msg : ''
		};
		if (this.isTrue(this.required)
				&& this.getSimpleValue() == '') {
			rstObj.success = false;
			rstObj.msg = this.blankValidateText;
		} else if (!this._check(this)) {
			rstObj.success = false;
			rstObj.msg = this.invalidText ? this.invalidText : this.blankValidateText;
		}
		return rstObj;
	}
})));
};ConditionMgr.functions["tree"] = function(configParams){
	ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {

	initProperties : function() {
		this.labelContainerId = this.id + "_label";
		this.containerId = this.id + "_container";
		this.jTreeObj = null;
		this.data;
	},
	showData : function(){
		if (!this.data){
			this.data = this.resultData.data;
		}
		this._create(this.data);
	},
	selectAllNodes : function(b){
		if (this.jTreeObj){
			jQuery.each(this.jTreeObj.getSelectedNodes(), function(i, _nd){
				_nd.select(b);
			});
		}
	},
	_create : function(_data){
		var that = this;
		ConditionUtils.createTree({
			treeId : that.containerId,
			doc : document,
			minExpandLevel : ConditionUtils.df(that.minExpandLevel, 1),
			data : _data,
			selectMode : that.selectMode == undefined ? "multi-hier" : that.selectMode,
			checkbox : that.showCheckbox == undefined ? true : that.showCheckbox
		});
		this.jTreeObj = jQuery("#" + that.containerId).dynatree("getTree");
	},
	checkItems : function(){
		this.expandAllNode(this.isTrue(this.expandAll));
		if(this.isLoaded()){
			if (this.defaultValue){
				this.selectNodes(this.defaultValue, true);
			}
		}
		this.disable(this.isTrue(this.disabled));
	},
	afterShowData : function(){
		this.checkItems();
	},
	getValueWithText : function() {
		var that = this;
		if (this.jTreeObj){
			return jQuery(this.jTreeObj.getSelectedNodes()).map(function(){
				if (that.isTrue(that.leafNodeValueOnly)){
					if (this.childList === null)
					return {
						value : this.data.key,
						text : this.data.title
					};
				}else{
					return {
						value : this.data.key,
						text : this.data.title
					};
				}
			}).get();
		}else{
			return [];
		}
	},
	getSimpleValue : function() {
		if (this.jTreeObj){
			return jQuery(this.jTreeObj.getSelectedNodes()).map(function(){
				if (that.isTrue(that.leafNodeValueOnly)){
					if (this.childList === null){
						return this.data.key;
					}
				}else{
					return this.data.key;
				}
			}).get().join(",");
		}else{
			return "";
		}
		
	},
	clear : function() {
		jQuery("#"+this.containerId).empty();
	},
	reset : function() {
		this.selectAllNodes(false);
		this.checkItems();
	},
	expandAllNode : function(b){
		if (this.jTreeObj){
			this.jTreeObj.getRoot().visit(function(dtnode){
			    dtnode.expand(b);
			});
		}
	},
	setValue : function(values){
		var that = this;
		this.selectAllNodes(false);
		jQuery.each(values, function(i, obj){
			that.selectNodes(obj["value"], true);
		});
	},
	selectNodes : function(values, flag) {
		flag = flag==undefined ? true : flag;
		var that = this;
		if (this.jTreeObj && values){
			var arrIds = values.split(",");
			jQuery.each(arrIds, function(i, v){
				var _node = that.jTreeObj.selectKey(v, flag);
				if (_node){
					if (flag)_node.activate();
					else _node.deactivate();
				}
			});
		}
	},
	removeAllNodes : function(){
		if (this.jTreeObj){
			this.jTreeObj.getRoot().removeChildren();
		}
	},
	isLoaded : function(){
		return this.jTreeObj?true:false;
	},
	addNodes : function(_data){
		if (this.jTreeObj){
			this.jTreeObj.getRoot().addChild(node);
		}
	},
	getNodeByKey : function(key){
		if (this.jTreeObj){
			return this.jTreeObj.getNodeByKey(key);
		}
		return null;
	},
	removeNodeByKey : function(key){
		if (this.jTreeObj){
			this.jTreeObj.getNodeByKey(key).remove();
		}
	},
	disable : function(b) {
		if (b){
			jQuery("#" + this.containerId).dynatree("disable");
			this.expandAllNode(false);
		}
		else{
			jQuery("#" + this.containerId).dynatree("enable");
			this.expandAllNode(this.isTrue(this.expandAll));
		}
			
		this.isEnable=!b;
	},
	checkData : function() {
		var that = this;
		var len = that.getValueWithText().length;
		var resultObj = {
			success : true,
			msg : len
		};
		
		if (this.isTrue(that.required) && len === 0){
				resultObj.success = false;
				resultObj.msg = that.blankValidateText;
		}else if (that.maxNum && len > that.maxNum){
			resultObj.success = false;
			resultObj.msg = $RRs.tree_alert_before+" "+ that.maxNum +" "+$RRs.tree_alert_after;
		}
		return resultObj;
	}
})));
};
ConditionMgr.functions["trigger"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
        this.fieldName = this.id + "_n";
        this.containerId = this.id + "_container";
        this.selectInfoId = "winGridSelectBtn_" + this.id;
        this.descId = "lbl_" + this.id;
        this.activesId = null;
        this.activesObj = null;
        this.relationIds = [];
        this.prevId = null;
        var trigger = this;
        this.OptionMgr = {
            options : {
                add : {active:true, button:jQuery("#winGridSelectBtn_" + trigger.id + "-img")},
                remove:{active:true, button:jQuery("#winGridDeleteBtn_" + trigger.id)},
                clean:{active:true, button:jQuery("#winGridClearBtn_" + trigger.id)},
                all:{active:true, button:jQuery("#winGridAllBtn_" + trigger.id)}
            },
            enable : function(name, b){
               var op = this.options[name];
               if (op){
                    if (b){
                        this.options[name].button.removeClass("a-grid-disable").addClass("a-grid-enable");
                    }else{
                        this.options[name].button.removeClass("a-grid-enable").addClass("a-grid-disable");
                   }
                  this.options[name].active = b;
               }
            },
            isEnabled : function(name){
                return this.options[name].active;
            },
            getButton : function(name){
                return this.options[name].button;
            },
            initEvent : function(){
                var that = this;
                var select = trigger.getJSelect();
                this.getButton("remove").bind("click", function(event){
                    if (that.isEnabled("remove")){
                        jQuery.each(select.children(":selected"), function(k, op){
                            trigger.remove(jQuery(op).data("value"));
                        });
                        trigger.change("remove");
                    }
                });
                this.getButton("add").bind("click", function() {
                   if ( that.isEnabled("add") && trigger.getActivesObject() &&  trigger.getActivesObject().show){
                        trigger.getActivesObject().show();
                    }
                });
                this.getButton("clean").bind("click", function(event){
                    if (that.isEnabled("clean")){
                        trigger.cleanSelected();
                        that.enable("add", true);
                        that.enable("remove", true);
                         trigger.change("clean");
                    }
                });
                this.getButton("all").bind("click", function(event){
                     if (that.isEnabled("all")){
                        that.enable("add", false);
                        that.enable("remove", false);
                        trigger.cleanSelected();
                        trigger.change("all");
                        if (trigger.getActivesObject()){
                            var vf = trigger.getActivesObject()["valueField"];
                            var df = trigger.getActivesObject()["displayField"];
                            var d = {};
                            jQuery.each(vf.split(","), function(i, f){
                                d[f] = "-1";
                            });
                            jQuery.each(df.split(","), function(i, f){
                                d[f] = iReport_Resources.comm_all;
                            });
                            trigger.addData([d], df);
                            if (trigger.getActivesObject().addData){
                                trigger.getActivesObject().addData(d);
                            }
                        }
                     }
                });
                if (!trigger.isTrue(trigger.showAllButton)){
                    this.getButton("all").hide();
                }
            }
        };
    },
    showRequired : function(flag){
        flag = flag == undefined ? true : false
        var f = jQuery("#" + this.selectInfoId+"_required");
        if (f.size() > 0){
            if (flag === true){
                f.show();
            }else{
                f.hide();
            }
        }else {
            if (flag === true){
	            jQuery("#" + this.selectInfoId + "-div").append("<font id='"+this.selectInfoId+"_required' color='#D60606' style='position:relative;left:-18px;top:-3px;'>*</font>");
	        }
        }
    },
    change : function(type){
        this.optionType = type;
        this.publishEvent("onValueChange");
    },
    length : function(){
        return this.getValueWithText().length;
    },
    addRelationId:function(id){
        if (jQuery.inArray(id, this.relationIds) == -1){
            this.relationIds.push(id);
        }
    },
    remove:function(_obj){
        var select = this.getJSelect();
        var that = this;
        jQuery.each(select.children(), function(i, op){
            if (JSON.stringify(jQuery(op).data("value")) == JSON.stringify(_obj)){
                jQuery(op).remove();
            }
        });
        if (this.getActivesObject()){
             this.getActivesObject().removeData(_obj);
        }
    },
    cleanSelected:function(){
        var that = this;
        var prevObj = ConditionMgr.get(that.prevId);
        jQuery.each(jQuery("#"+this.selectInfoId).children(), function(i, op){
             that.remove(jQuery(op).data("value"));
             if (prevObj){
                prevObj.removeData(jQuery(op).data("value"));
             }
        });
        jQuery("#"+this.selectInfoId).children().remove();
    },
    getValueWithText:function(){
        if (this.getActivesObject() && this.getActivesObject().getValueWithText){
            return this.getActivesObject().getValueWithText();
        }
        return [];
    },
    getSimpleValue:function(){
         if (this.getActivesObject() && this.getActivesObject().getSimpleValue){
            return this.getActivesObject().getSimpleValue();
        }
        return "";
    },
    getActivesObject:function(){
        if (this.activesObj){
            return this.activesObj;
        }else{
            if (this.activesId){
                return ConditionMgr.get(this.activesId);
            }else if (this.relationIds.length > 0){
                return ConditionMgr.get(this.relationIds[0]);
            }
            this.activesObj = ConditionMgr.get(this.activesId)
            return this.activesObj;
        }
    },
    setActivesId:function(id){
        this.prevId = this.activesId;
        this.activesId = id;
        var obj = ConditionMgr.get(id);
        if (obj && obj.active){
            obj.active();
        }
        this.activesObj = obj;
    },
    initDoms : function() {
        this.OptionMgr.initEvent();
        var select = this.getJSelect();
        $("#" + this.selectInfoId).attr("readonly", true);
    },
    initEvents : function() {},
    beforeShowData : function() {},
    getJSelect : function(){
        return jQuery("#" + this.selectInfoId);
    },
    addData:function(arr, displayField, separator){
       separator = separator?separator:";";
       var dataArr = this.getJSelect().children().map(function(){
            return $(this).data("value");
       }).get();
       var that = this;
       if (arr && arr.length > 0){
            var buffer = [];
            var titleBuffer = [];
            var tmpStrArr = [];
           for(var i = 0; i < arr.length;i ++){
                var d = arr[i];
                if (d && displayField && ConditionUtils.inArray(d, dataArr) == -1){
                    buffer.push(d[displayField]);
                    var str = tmpStrArr.join(";");
                    if (str.length > 120){
                        titleBuffer.push(str);
                        tmpStrArr = [];
                    }else{
                        tmpStrArr.push(d[displayField]);
                    }
                }
            }
            titleBuffer.push(tmpStrArr.join(";"));
            var str = buffer.join(separator);
            that.getJSelect().val(str).attr("title", titleBuffer.join("; "));
       }
    },
    showData : function() {},
    afterShowData : function() {},
    checkItems : function() {},
    beforeInitComplete : function() {},
    clear : function() {
        jQuery("#" + this.containerId).empty();
    },
    reset : function(){
        if(this.getActivesObject()){
            this.getActivesObject().reset();
        }
    },
    getValueWithText : function() {
        if(this.getActivesObject()){
            return this.getActivesObject().getValueWithText();
        }
        return [];
    },
    getSimpleValue : function() {
        if(this.getActivesObject()){
            return this.getActivesObject().getValueWithText();
        }
        return "";
    },
    setValue : function(obj) {},
    disable : function(bn){
       this.getJSelect().attr("disabled", bn);
       for (var name in this.OptionMgr.options){
            this.OptionMgr.enable(name, !bn);
       }
        this.isEnable=!b;
    },
    checkData : function() {
        if (this.getActivesObject()){
            return this.getActivesObject().checkData();
        }else{
            return {success:true};
        }
    }

})));
};
ConditionMgr.functions["winGrid"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
        
        initProperties : function() {
            this.searchPrefix = "x-combo-list-inner-";
            var thisObj = this;
            this.descId = "lbl_" + this.id;
            this.__gValue = [];
            this.path = WEB_ROOT_ABS_PATH + "/showWinGrid.do";
            this.searchComboId = "serchFieldName";
            this.searchValueInputId = "serchFiledValue";
            this.queryLblId = "lbl_query";
            this.okBtnId = "btn_ok";
            this.cancelBtnId = "btn_cancel";
            this.searchBtnId = "btn_query";
            this.resetBtnId = "btn_reset";
            this.jGridTab = null;
            this.jTabBody = null;
            this.columnConfig = null;
            this.size = 0;
            this.windowIdPrefix = this.groupId + "_" + this.id;
            this.windowId = this.windowIdPrefix + "_Frame";
            this.valueMap = {};
            this.emptyOption = {
		        key: "",
		        value: $RRs.grid_empty_option
		    };
        },
        _getTrigger:function(){
            return ConditionMgr.get(this.triggerID);
        },
        removeData : function(d){
            var that = this;
            jQuery.each(this.__gValue, function(i, v){
                if (JSON.stringify(v) == JSON.stringify(d)){
                    that.__gValue.splice(i, 1);
                }
            });
        },
        addData:function(obj){
          this. __gValue.push(obj);
        },
        changeOptions : function(param){
            if (this.grid && this.grid.columnModels){
                this.grid.columnModels = null;
            }
            if (param["interfaceClass"]){
                $.ajax({
                    url : WEB_ROOT_ABS_PATH+"/conditionAjaxAction!changeGridDataSource.do",
                    type : "POST",
                    data : param,
                    dataType : "json",
                    success : function(result, textStatus) {
                    },
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                    },
                    complete : function(XMLHttpRequest, textStatus) {
                    },
                    async : false
                });
            }
        },
        show:function(){
            
            LegoTag.frameWindow(this.path,
                this.windowIdPrefix,
                "title='" + this.dialogTitle + "',height=550,width=500",
                false, function() {
            });
             this.createGrid();
        },
        getDisplayField : function(){
            var df = this.displayField;
            if(!df) {
                $(this.grid.columnModels, function(i,cm) {
                    if(cm.name) df = cm.name;
                    return false;
                })
            }
            return df;
        },
        showSelectedInfo: function() {
        },
        initDoms: function() {
            var thisObj = this;
            this.disable(this.isTrue(this.disabled));
            this.showRequired();
        },
        getValueWithText : function() {
            if(!this.grid && !this.__gValue) return [];
            var vs = [];
            if(this.valueField) {
                var fs = this.valueField.split(",");
                var vo;
                var df = this.getDisplayField();
                $.each(this.__gValue, function(i,v){
                    if(v){
                        vo = {};
                        $.each(fs, function(j,f){
                            vo[f] = v[f];
                        });
                        vo[df] = v[df];
                        vs.push(vo);
                    }
                })
            } else {
                vs = this.__gValue;
            }
            return vs;
        },
        setValue : function(values){
            this.__gValue = [].concat(values);
            if (this._getTrigger()){
                this._getTrigger().addData(this.__gValue, this.getDisplayField());
            }
            this.showSelectedInfo();
            this.publishEvent("onValueChange");
        },
        getSimpleValue : function() {
            if (this.grid){
                return this.getValueWithText();
            }else{
                return [];
            }
        },
        getColumnModels : function() {
            if(this.gridConfig.columnModels && this.gridConfig.columnModels.length > 0) {       
                return this.gridConfig.columnModels;
            } else {        
                var params = this.getParams(); 
                params["interfaceClassMethod"] = "getGirdColumnModels";     
                params["interfaceClassMethodParamTypes"] = "map";
                params['invokerParamString'] = JSON.stringify([{}]);
                var ops = this.getOtherParams();
                $.extend(params, ops);
                var thisObj = this;
                $.ajax({
                    url : this.loadUrl,
                    type : "POST",
                    data : params,
                    dataType : "json",
                    success : function(result, textStatus) {
                        thisObj.gridConfig["columnModels"] = result.data;
                    },
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                    },
                    complete : function(XMLHttpRequest, textStatus) {
                    },
                    async : false
                });
                
                return thisObj.gridConfig["columnModels"];
            }
        },
        getSearchParams: function(){
            var win = this.getLegoFrameWindow();
            var searchName = win.LegoTag.getCombValue(this.searchComboId);
            var searchValue = $("#" + this.searchValueInputId, win.document).val();
            var result =  {
	            searchName:searchName,  
	            searchValue: searchValue 
	        }
            return result;
        },
        getOtherParams : function(){},
        getGridConfig : function() {
            var thisObj = this;
            var cfg = $.extend({},this.gridConfig);
            
            if(!cfg.columnModels || cfg.columnModels.length == 0) {
                cfg.columnModels = this.getColumnModels();
            }
            cfg.url = this.loadUrl;
            cfg.autoLoad = true;
            cfg.getParams = function() {            
                var params = thisObj.getCommonParams();
                params["interfaceClassMethod"] = "getGridData";
                params["interfaceClassMethodParamTypes"] = "map";
                var invokParams = {};
                $.extend(invokParams, thisObj.getSearchParams());
                var ops = thisObj.getOtherParams();
                $.extend(invokParams, ops);
                params['invokerParamString'] = JSON.stringify([invokParams]);
                
                return params;
            }
            
            return cfg;
        },
        getLegoFrameWindow : function(){
            var win = window.parent.parent.document.getElementById(this.windowId).contentWindow;
	        return win;
        },
        buildGridHead : function(_cfg){
        	var that = this;
            if (_cfg && _cfg.columnModels && _cfg.columnModels.length > 0)
            {
                var _spIco = "<span class='spliter-icon'></span>";
                var _head = new StringBuffer();
                _head.append('<tr class="x-grid3-hd-row">')
                .append('<td style="width: 20px; padding: 0px 0px 0px 2px;">')
                .append('<div id="'+this.id+'_allCk" onclick="LegoTag.gridSelect(this,event)" onmousedown="LegoTag.gridSelectAll(this)" class="x-grid3-hd-checker">&nbsp;</div></td>')
                for (var i = 0; i < _cfg.columnModels.length; i++)
                {
                    var _column = _cfg.columnModels[i];
                    _head.append('<td class="cell-spliter" align="center" id="' + _column.name +'"');
                    if(this.isTrue(_column.sortable)){
                        _head.append(" style='cursor:pointer' onclick=sortTable('tab_gridList'," + (i+1) + ")");
                    }
                    _head.append('>').append(_spIco).append(_column.text).append('</td>');
                }
                
                _head.append('</tr>');
                 this.jTabBody.append(_head.toString());
                 this.setSelectedNum();
                 this.getLegoFrameWindow().$("#" + this.id + "_allCk").bind("mousedown", function(){
                 	var rows = that.getSelectedRows();
		        	if (rows){
		        		var num = rows.size();
		        		that.getLegoFrameWindow().$("#selectedNum").text(num);
		        	}
                 });
            }
        },
        buildGridRows : function(rowDatas){
            this.valueMap = {};
        	var that = this;
            var _cfg = this.columnConfig;
            var $ = this.getLegoFrameWindow().$;
            if (this.gridConfig.selector == "radio"){
                 this.jGridTab.addClass("x-grid-radio-tag");
                 this.jTabBody.find("tr:first>td:first").empty();
            }
            this.size = rowDatas.length;
            if (rowDatas && rowDatas.length > 0)
            {
                var _tbody =  this.jTabBody;
                var cbxStr = '<td width="20px" class="x-grid3-td-checker"><div name="div_checker" onmousedown="LegoTag.gridSelectCheck(this,event)" class="x-grid3-row-checker"> &nbsp;</div></td>';
                var trs = new StringBuffer();
                for (var i = 0; i < rowDatas.length; i++)
                {
                    var r = rowDatas[i];
                    var id = "tr_" + r[this.valueField];
                    trs.append('<tr class="x-grid3-row" id="' +id+ '" onmousedown="LegoTag.gridDown(this,event)" onmouseout="LegoTag.gridOut(this)" onmouseover="LegoTag.gridOver(this)">');
                    trs.append(cbxStr);
                    for (var j = 0; j < _cfg.columnModels.length; j++)
                    {
                        var cfg = _cfg.columnModels[j];
                        var text = r[cfg["name"]];
                        trs.append('<td align="center" title="')
                        .append(text).append('" class="x-grid3-table-cell">')
                        .append(text).append('</td>')
                    }
                    trs.append("</tr>");
                    this.valueMap[id] = r;
                }
                
                var eventFn = function(){
                       var rows = that.getSelectedRows();
                       if (rows){
                           var num = rows.size();
                           that.getLegoFrameWindow().$("#selectedNum").text(num);
                       }
                };
                
                _tbody.append(trs.toString());
                _tbody.find("div[name=div_checker]").bind("mousedown", eventFn);
                _tbody.find("tr:gt(0)").bind("mousedown", eventFn);
            }
            $("#totalNum").text(rowDatas.length);
        },
        createGrid : function() {
            var that = this;
            var win = this.getLegoFrameWindow(); 
            $(win).load(function(){
	            var _tab = this.$("#tab_gridList");
                that.jGridTab = _tab;
                that.jTabBody = _tab.find("#tb_gridDataList");
                that.columnConfig = that.getGridConfig();
                that.buildGridHead(that.columnConfig);
                that.buildGridRows(that.getAjaxData());
                that.loadSearchComboData();
                that.initSearchComboEvent();
                that.initCommitBtnEvent();
                that.initSearchBtnEvent();
                that.initResetBtnEvent();
                that.fillBack();
                that.i18N();
                this.$("#div_gridTitle").parent().css("overflow","hidden");
            });
        },
        showRequired : function(){
            if (this.isTrue(this.required)){
                if (this._getTrigger()){
                    this._getTrigger().showRequired();
                }
            }
        },
        i18N : function(){
            var $ = this.getLegoFrameWindow().$;
            if($("#" + this.queryLblId))
            {
              $("#" + this.queryLblId).text(ResourceMgr.get("elog.common.condition.title"));
            }
            $("#totalNumTitle").text(ResourceMgr.get("elog.device.stat.totle"));
            $("#selectedNumTitle").text(ResourceMgr.get("elog.device.stat.selected"));
        },
        setSelectedNum : function(){
        	var rows = this.getSelectedRows();
    		var num = rows.size();
    		this.getLegoFrameWindow().$("#selectedNum").text(num);
        },
        fillBack : function(){
            if (this.__gValue.length > 0){
                var win = this.getLegoFrameWindow(); 
                if (this.__gValue.length == 1 && this.__gValue[0][this.valueField] == -1){
                    this.jTabBody.find("tr:gt(0)").addClass("x-grid3-row-selected");
                    this.jTabBody.find("tr:first>td").addClass("x-grid3-hd-checker-on");
	            }else{
                    for (var i = 0; i < this.__gValue.length; i++){
	                    var r = this.__gValue[i];
	                    var v = r[this.valueField];
	                    win.$("#tr_" + v).addClass("x-grid3-row-selected");
	                }
	                if (this.__gValue.length == this.size){
	                	this.jTabBody.find("tr:first>td").addClass("x-grid3-hd-checker-on");
	                }
                }
            }
            this.setSelectedNum();
        },
        initResetBtnEvent : function(){
        	var $ = this.getLegoFrameWindow().$;
        	var that = this;
        	var resetBtn = $("#" + this.resetBtnId);
        	resetBtn.bind("click", function(event){
        		$("#" + that.searchValueInputId).val("");
        		that.jTabBody.empty();
                that.buildGridHead(that.columnConfig);
                that.buildGridRows(that.getAjaxData());
                that.fillBack();
        	});
        },
        initSearchBtnEvent : function(){
            var win = this.getLegoFrameWindow(); 
            var searchBtn = win.$("#" + this.searchBtnId);
            var that = this;
            searchBtn.click(function(event){
                that.jTabBody.empty();
                that.buildGridHead(that.columnConfig);
                that.buildGridRows(that.getAjaxData());
            });
        },
        getSelectedRows : function(){
    		return this.jTabBody.find(">tr.x-grid3-row-selected");
        },
        initCommitBtnEvent : function(){
            var that = this;
            var win = this.getLegoFrameWindow(); 
            var $ = win.$;
            $("#" + that.okBtnId).click(function(event){
               var selectedRows = that.getSelectedRows();
               if (selectedRows.size() > 0){
                    if (!isNaN(that.maxNum) && selectedRows.size() > parseInt(that.maxNum))
                    {
                        win.LegoTag.Msg.alert(ResourceMgr.get("elog.common.info"), that.maxNumText);
                    }else{
                        var values = selectedRows.map(function(){
                          return that.valueMap[this.id];
	                    }).get();
	                   
	                    that.setValue(values);
	                    win.LegoTag.getSelfWindow().close();
                    }
               }else{
                   win.LegoTag.Msg.alert(ResourceMgr.get("elog.common.info"), that.blankValidateText);
               }
            });
        },
        initSearchComboEvent : function(){
            var that = this;
            var win = this.getLegoFrameWindow();
            var $ = win.$;
            var div = $("#" + this.searchPrefix + this.searchComboId);
	        this._beforeValue = win.LegoTag.getCombValue(this.searchComboId);
	        div.bind("click", function(event){
	            var t = event.target;
	            var _curValue = win.LegoTag.getCombValue(that.searchComboId);
	            if (t.tagName.toUpperCase() == "DIV" && $(t).hasClass("x-combo-list-item")){
	                if (_curValue != that._beforeValue){
                        $("#" + that.searchValueInputId).val("");
	                   that._beforeValue = _curValue;
	                }
	            }
	        });
        },
         refreshCombHeight: function(id, optionSize, simpledata)
	    {
            var $ = this.getLegoFrameWindow().$;
            var _h = 18 * optionSize;
            if($.browser.msie){
                _h = 22 * optionSize;
            }
            if(_h > 150)
            {
                _h = 150;
            }
            $('#x-combo-list-'+id).css('height', _h);
            $('#x-combo-list-inner-'+id).css('height', ""); 
            
            if(simpledata != undefined)
            {
                $('#'+id).attr('simpledata', simpledata);
            }
	    },
        loadSearchComboData : function()
        {
            var cfg = this.columnConfig;
            var searchField = cfg.searcher;
            if (searchField)
            {
            	var defaultKey = null;
            	var defaultValue = null;
                var simpleData = [];
                var fieldArr = searchField.split(",");
                for (var i = 0; i < fieldArr.length; i++)
                {
                    var f = fieldArr[i];
                    for (var j = 0; j < cfg.columnModels.length; j++)
                    {
                        if (cfg.columnModels[j]["name"] == f)
                        {
                            var text = cfg.columnModels[j]["text"];
                             this.getLegoFrameWindow().LegoTag.addCombItem(this.searchComboId, f, text); 
                             simpleData.push("[" + f, text + "]");
                             if (defaultKey == null){
                        		defaultKey = f;
                        	 }
                        	 if (defaultValue == null){
                        	 	defaultValue = text;
                        	 }
                             break;
                        }
                    }
                }
                this.getLegoFrameWindow().LegoTag.setCombValue(this.searchComboId, defaultKey, defaultValue);
                this.getLegoFrameWindow().LegoTag.setCombDisplay(this.searchComboId, defaultValue);
                this.refreshCombHeight(this.searchComboId, fieldArr.length, "[" + simpleData + "]");
            }
        },
        getAjaxData : function(){
            var thisObj = this;
            var datas = null;
            $(this).trigger("onBeforeLoadData",[thisObj]);
            
            if(!this.url) return ;
            $.ajax({
                url : this.loadUrl,
                type : "POST",
                async : false,
                data : this.getGridConfig().getParams(),
                dataType : "json",
                success : function(result, textStatus) {
                    if(!result || !result.data) {
                        result = {data:  {total : 0, rows: []}
                    }
                }
                    datas = result.data.rows;
                    $(thisObj).trigger("onAfterLoadData", {result:true, grid: thisObj});
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    $(thisObj).trigger("onAfterLoadData", {result:false, grid: thisObj});
                },
                complete : function(XMLHttpRequest, textStatus) {
                }
            });
            
            return datas;
        },
        checkData : function(){
            if (this.isTrue(this.required) && ( this.__gValue.length == 0)) {
                return {
                    success : false,
                    msg : this.blankValidateText
                };
            } else {
                return {
                    success : true,
                    msg : ""
                };
            }
        },
        reset : function(){
            var that = this;
            if (that.grid){
                this.grid.reset();
            }
        },
        disable : function(b){
            this.isEnable=!b;
        },
        destory : function() {
            if(this.grid && this.grid.destory)
                this.grid.destory();
            if(this.dialog && this.dialog.destory) {
                this.dialog.destory();
            }
        }
    })));
};
ConditionMgr.functions["winTree"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
        var that = this;
        this.clickerBtnId = this.type + "_btn_" + this.id;
        this.containerId;
        this.jTreeObj;
        this.data;
        this.autoLoad = false;
        this.valueField = "value";
        this.displayField = "text";
        this.backFillValue = [];
        this._values = [];
        this.okBtnId = "btn_ok";
        this.cancelBtnId = "btn_cancel";
        this.autoLoad = false;
        this.isCheckLevel = (this.checkLevel == undefined ? false : true);
        this.checkLevelInfo = (this.checkLevelInfo == undefined ? $RRs.winTree_checkLevelInfo : this.checkLevelInfo);
        
        this.path = WEB_ROOT_ABS_PATH + "/showWinTree.do"
        this.windowIdPrefix = this.groupId + "_" + this.id;
        this.windowId = this.windowIdPrefix + "_Frame";
        this.treeContainerId = "div_tree";
        
        
        this.descId = "lbl_" + this.id;
    },
    _getTrigger:function(){
        return ConditionMgr.get(this.triggerID);
    },
     addWinTreeDataInterface: function(selectValue)
    {
    },
    removeData : function(d){
        var that = this;
        jQuery.each(this._values, function(i, v){
            if (JSON.stringify(v) == JSON.stringify(d)){
                that._values.splice(i, 1);
                jQuery.each(that.backFillValue, function(j, e){
                    if (e == d[that.valueField]){
                        that.backFillValue.splice(j, 1);
                    }
                });
                that.selectNodes(d[that.valueField], false);
            }
        });
    },
    show:function(){
            LegoTag.frameWindow(this.path,
                this.windowIdPrefix,
                "title='" + this.dialogTitle + "',height=400,width=600",
                false, function() {
            });
            
            this.createTree();
    },
    createTree : function(){
        var that = this;
        var win = this.getLegoFrameWindow();
        $(win).load(function(){
            that.loadAjaxData({async:false});
            var sel = that.selectMode == undefined ? "multi-hier" : that.selectMode;
	        var selMode = {
	            "single" : 1,
	            "multi" : 2,
	            "multi-hier" : 3};
	        win.$("#" + that.treeContainerId).dynatree({
	            checkbox: ConditionUtils.isTrue(that.showCheckbox == undefined ? true : that.showCheckbox),
	            selectMode: selMode[sel],
	            children: that.data,
	            minExpandLevel : ConditionUtils.df(that.minExpandLevel, 1),
	            rootVisible: false,
	            onActivate: function(dtnode){
	            },
	            onSelect: function(flag, dtnode) {
	                if (flag)
	                {
	                    dtnode.activate();
	                }
	            },
	            onClick: function(dtnode, event) {
	                if( dtnode.getEventTargetType(event) == "title" )
	                    dtnode.toggleSelect(); 
	            },
	            onKeydown: function(dtnode, event) {
	                if( event.which == 32 ) {
	                    dtnode.toggleSelect();
	                    return false;
	                }
	            },
	            cookieId: "ui-dynatree-Cb2",
	            idPrefix: "ui-dynatree-Cb2-"
	        });
	        that.jTreeObj = win.$("#"+that.treeContainerId).dynatree("getTree");
	        
	        that.initCommitBtnEvent();
            
            that.selectNodes(that.getSimpleValue());
            that.i18N();
        });
    },
    showRequired : function(){
        if (this.isTrue(this.required)){
            if (this._getTrigger()){
                this._getTrigger().showRequired();
            }
        }
    },
    i18N : function(){
        var win = this.getLegoFrameWindow();
        win.$("#" + this.cancelBtnId + "_input").attr("title", ResourceMgr.get("elog.common.cancel")).text(ResourceMgr.get("elog.common.cancel"));
        win.$("#" + this.okBtnId + "_input").attr("title", ResourceMgr.get("elog.common.cofirm")).text(ResourceMgr.get("elog.common.cofirm"));
        
    },
    getLegoFrameWindow : function(){
        var win = window.parent.parent.document.getElementById(this.windowId).contentWindow;
        return win;
    },
    addData:function(obj){
      this. _values.push(obj);
    },
    showWinTree:function(){
        this.show();
    },
    clearSelectedValue : function(){
        this.backFillValue = [];
    },
    initDoms: function() {
        this.showRequired();
    },
    checkItems : function(){
        this.expandAllNode(this.isTrue(this.expandAll));
    },
    showData : function() {
        if (!this.data){
            this.data = this.resultData.data;
        }
    },
    initCommitBtnEvent: function(){
        var that = this;
        var win = this.getLegoFrameWindow();
        win.$("#" + this.okBtnId).click(function(){
            var nodes = that.getSelectValues();
            if (nodes.length > 0){
	            if (!isNaN(that.maxNum) && nodes.length > parseInt(that.maxNum)){
	                win.LegoTag.Msg.alert(ResourceMgr.get("elog.common.info"), $RRs.tree_alert_before+" "+ that.maxNum +" "+$RRs.tree_alert_after);
	            }else{
	                that.setValue(nodes);
	                win.LegoTag.getSelfWindow().close();
	            }
            }else{
                win.LegoTag.Msg.alert(ResourceMgr.get("elog.common.info"), that.blankValidateText);
            }
        });
    },
    afterShowData : function(){
        this.disable(this.isTrue(this.disabled));
        this.checkItems();
    },
    removeAllNodes : function(){
        if (this.jTreeObj){
            this.jTreeObj.getRoot().removeChildren();
        }
    },
    setValue : function(values){
        this._values = [].concat(values);
        if (this._getTrigger()){
            this._getTrigger().addData(this._values, this.displayField);
        }
         this.publishEvent("onValueChange");
    },
    selectNodes : function(values, flag) {
        flag = flag==undefined ? true : flag;
        var that = this;
        if (this.isLoaded() && values){
            var arrIds = values.split(",");
            that.jTreeObj.getRoot().visit(function(dtnode){
	            if (jQuery.inArray(dtnode.data.key, arrIds) != -1 && !dtnode.hasChildren()){
	                dtnode.select(true);
	                dtnode.activate();
	            }
	        });
        }
    },
    isLoaded : function(){
        if (this.jTreeObj) return true;
        return false;
    },
    addNodes : function(node){
        if (this.jTreeObj){
            this.jTreeObj.getRoot().addChild(node);
        }
    },
    getNodeByKey : function(key){
        if (this.jTreeObj){
            return this.jTreeObj.getNodeByKey(key);
        }
        return null;
    },
    removeNodeByKey : function(key){
        if (this.jTreeObj){
            this.jTreeObj.getNodeByKey(key).remove();
        }
    },
    checkData : function(){
        var that = this;
		var len = this._values.length;
		var resultObj = {
			success : true,
			msg : len
	    };
		
		if (this.isTrue(that.required) && len === 0){
				resultObj.success = false;
				resultObj.msg = that.blankValidateText;
		}else if (that.maxNum && len > parseInt(that.maxNum)){
			resultObj.success = false;
			resultObj.msg = $RRs.tree_alert_before+" "+ that.maxNum +" "+$RRs.tree_alert_after;
		}
		return resultObj;
    },
    clear : function() {
        if (this.dialog){
            this.dialog.jBody.empty();
        }
    },
    selectAllNodes : function(b){
        if (this.jTreeObj){
            jQuery.each(this.jTreeObj.getSelectedNodes(), function(i, _nd){
                _nd.select(b);
            });
        }
    },
    reset : function(){
        var that = this;
        this.selectAllNodes(false);
        this.clearSelectedValue();
        this.checkItems();
    },
    expandAllNode : function(b){
        if (this.jTreeObj){
            this.jTreeObj.getRoot().visit(function(dtnode){
                dtnode.expand(b);
            });
        }
    },
    getValueWithText: function(){
        var arr = [];
        jQuery.each(this._values, function(i, v){
            if(v){
                arr.push(v);
            }
        });
        return arr;
    },
    getSelectValues : function() {
        var that = this;
        if (this.jTreeObj){
            return jQuery(this.removeNodeTypeIsAll(this.jTreeObj.getSelectedNodes())).map(function(){
                if (that.isTrue(that.leafNodeValueOnly)){
                    if (this.childList === null)
                    return {
                        value : this.data.key,
                        text : this.data.title,
                        type : this.data.type == null ? "" : this.data.type,
                        toString:function(){return JSON.stringify(this)}
                    };
                }else{
                    return {
                        value : this.data.key,
                        text : this.data.title,
                        type : this.data.type == null ? "" : this.data.type,
                        toString:function(){return JSON.stringify(this)}
                    };
                }
            }).get();
        }else if (this._values){
            return this._values;
        }
        else{
            return [];
        }
    },
    
    removeNodeTypeIsAll:function(array)
    {
        var returnArr = new Array();
        for(var i=0;i<array.length;i++)
        {
            if(array[i].data.type != "all")
            {
                returnArr.push(array[i]);
            }
        }
        return returnArr;
    },
    
    checkOptionLevel:function(array)
    {
        var returnArr = true;
        var level = 0;
        var length = array.length;
        if(length>0)
        {
            level = array[0].data.level;
        }
        else
        {
            return returnArr;
        }
        for(var i=0;i<length;i++)
        {
            if(level != array[i].data.level)
            {
                returnArr = false;
                return returnArr;
            }
        }
        return returnArr;
    },
    
    getSimpleValue : function() {
        var that = this;
         if (this._values){
            return jQuery(this._values).map(function(){
                return this[that.valueField];
            }).get().join(",");
        }else{
            return "";
        }
    },
    disable : function(b){
        this.isEnable=!b;
    },
    destory : function(){
    }
})));
};
ConditionMgr.functions["ComboButton"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
    this.jid="#"+this.id;
    this.containerId = this.id + "_container";
    this.initialized=false;
	},
    onInitComplete:function()
    {
    	this.initialized=true;
    },
	initDoms : function() {
	 var params={value:"item1", text:"item1"};
	 if(this.defaultValue)
     {
     	var kv=this.defaultValue.split(",");
     	if(kv.length==2)
     	{
     		params={value:kv[0], text:kv[1]};
     	}else
     	{
     		params={value:kv[0], text:kv[0]};
     	}
     }
     this.setValue(params);
	},
	beforeShowData : function() {
	},
	showData : function() {
	},
	afterShowData : function() {
		var that = this;
		this.checkItems();
	},
	checkItems : function() {
		if (this.disabled=="true"||this.disabled==true){
			this.disable(this.isTrue(this.disabled));
		}
	},
	beforeInitComplete : function() {
		this.checkItems();
	},
	clear : function() {
	},
	reset : function(){
	},
	getValueWithText : function() {
		var retVals=new Array();
		var text = $(this.jid).val().trim();
		var value = $(this.jid+"-hidden").val().trim();
		if(text!='')
		{
			retVals[0]={value : value,text : text};
		}
		return retVals;
	},
	getSimpleValue : function() {
		var text = $(this.jid).val().trim();
		var value = $(this.jid+"-hidden").val().trim();
		return {value : value,text : text};
	},
	setValue : function(values) {
		if (values != undefined) {
			$(this.jid).val(values["text"]);
			$(this.jid+"-hidden").val(values["value"]);
			if(this.initialized)
			{
				$(this).trigger("onValueChange", this);
			}
		}
	},
	disable : function(bn) {
	},
	_check:function(obj)
	{
		var text = $(this.jid).val().trim();
		var value = $(this.jid+"-hidden").val().trim();
		if(text==''&& value=='')
		{
			return false;
		}
		return true;
	},
	checkData : function() {
			var rstObj = {
					success : true,
					msg : ''
				};
			var items=this.getValueWithText();
			if (this.required&& items.length==0) {
				rstObj.success = false;
				rstObj.msg = this.blankValidateText;
			} else if (!this._check(this)) {
				rstObj.success = false;
				rstObj.msg = this.invalidText ? this.invalidText : this.blankValidateText;
			}
			return rstObj;
	}
	
	
    })));
};
ConditionMgr.functions["SelectList"] = function(configParams){
    ConditionMgr.add(new ConditionEntity(ConditionUtils.override(configParams, {
    initProperties : function() {
    	this.jid="#"+this.id;
    	this.containerId = this.id + "_container";
    	this.required = this.isTrue(this.required);
    	this.autoLoad = this.isTrue(this.autoLoad);
    	this.disabled = this.isTrue(this.disabled)
    	this.ctrlOptions = {
                add : {active:true, button:"btnAdd_"+this.id},
                remove:{active:true, button:"btnRemove_"+this.id},
                clean:{active:true, button:"btnClean_"+this.id},
                all:{active:true, button:"btnAll_"+this.id}
            };
            this._enable("remove", false);
            this._enable("clean", false);
            
	},
	_getButton : function(name){
                return $("#"+this.ctrlOptions[name].button);
            },
    _getJSelect : function(){
        return $("#" + this.id);
    },
    _enable : function(name, b){
               var oButton = this._getButton(name);
               LegoTag.setDisableds([this.ctrlOptions[name].button],!b);
            },
     _isEnabled : function(name){
         return this.ctrlOptions[name].active;
     },  
    _cleanSelected:function(){
        var self = this;
		LegoTag.removeListBoxSelectedItems(this.id);
		SelectList.buttonsStatus(this.id);
    }, 
    _cleanAll:function(){
        LegoTag.removeListBoxAllItems(this.id)
        SelectList.buttonsStatus(this.id);
    }, 
	initDoms : function() {
		this._initRequest();
		this.initRequired();
	},
	initRequired: function()
	{
	},
	
	_initRequest:function()
	{
		var itemsData = this.data;
		if(!this.autoLoad)
	  	{
			if(typeof itemsData=="undefined" ||itemsData==null)
			{
				var items = this.defaultValue.split(",");
				itemsData=[];
				if(items.length%2==0)
				{
						for (var index=0,len=items.length,i=0;index<len;index=index+2,i++)   
						{
							itemsData[i]={};
							itemsData[i].value=items[index];
							itemsData[i].text=items[index+1];
						}		
				}
			}else
			{
				var items=itemsData;
				itemsData=[];
				if(items.length%2==0)
					{
							for (var index=0,len=items.length,i=0;index<len;index=index+2,i++)   
							{
								itemsData[i]={};
								itemsData[i].value=items[index];
								itemsData[i].text=items[index+1];
							}
					}
			}
			this.fillListData(itemsData);
		}
	},
	_existItem:function(optVal)
	{
        var self = this;
        var bExisted=false;
        var rows = LegoTag.getListBoxAllItems(this.id);
        $.each(rows, function(i, opt){
        	if(opt.value==optVal)
        	{
        		bExisted=true;
        	}
        	
        });
		return bExisted;
	},
	selectNodes:function(itemsData,singleAllowed)
	{
		if(singleAllowed)
		{
			this._cleanAll();
		}
		for (var index=0,len=itemsData.length;index<len;index++)   
		{
			    var value=$.trim(itemsData[index].value);
			    var text=$.trim(itemsData[index].text);
			    if(!this._existItem(value))
			    {
			    	this.fillItemData(value,text);
			    }
			}
			SelectList.buttonsStatus(this.id);
	}
	,
	initEvents : function() {
				var self = this;
                this._getButton("remove").bind("click", function(event){
                    if (self._isEnabled("remove")){
                        self._cleanSelected();
                        self._enable("remove", false);
                    }
                });
                this._getButton("clean").bind("click", function(event){
                    if (self._isEnabled("clean")){
                        self._cleanAll();
                        self._enable("add", true);
                        self._enable("remove", false);
                        self._enable("clean", false);
                    }
                });
                this._getButton("all").bind("click", function(event){
                     if (self._isEnabled("all")){
                        self._enable("add", false);
                        self._enable("remove", false);
                        self._cleanSelected();
                     }
                });
                    this._getButton("all").hide();
	},
	beforeShowData : function() {
	},
	
	onShowData : function() {
		_log("debug",'showData');
		this.clear();
        this._init();
	},
	_init : function(){
	  _log("debug",'_init');
	  if(this.autoLoad)
	  {
	  		_log("debug",'设置了从Ajax数据源初始化数据');
			var itemsData = this.resultData.data;
			this.fillListData(itemsData);
		}
	        
    },
    fillListData : function(itemsData){
    		for (var index=0,len=itemsData.length;index<len;index++)   {
			    var value=$.trim(itemsData[index].text);
			    var text=$.trim(itemsData[index].value);
			    LegoTag.addListBoxItem(this.id,text,value,"SelectList.buttonsStatus('"+this.id+"');")
			}
    },
    fillItemData : function(value,text){
		LegoTag.addListBoxItem(this.id,text,value,"SelectList.buttonsStatus('"+this.id+"');");
    },
    reload:function(_data)
    {
    	this._cleanAll();
    	var itemsData =_data;
    	this.fillListData(itemsData);
    },
	afterShowData : function() {
		var self = this;
		this.checkItems();
	},
	checkItems : function() {
		if (this.disabled){
			this.disable(this.disabled);
		}
	},
	beforeInitComplete : function() {
		this.checkItems();
	},
	clear : function() {
		this._cleanAll();
		
	},
	reset : function(){
		this.checkItems();
	},
	getValueWithText : function() {
	   var retVals=[];      
       var rows = LegoTag.getListBoxAllItems(this.id);
        $.each(rows, function(i, opt){
        	var tmpVal=opt.value;
			var tmpText=opt.label;
			retVals.push({value:tmpVal,text:tmpText});
        });
		return retVals;
	},
	setValue : function(itemsData,singleAllowed) {
		if(singleAllowed)
		{
			this._cleanAll();
		}
		for (var index=0,len=itemsData.length;index<len;index++)   
		{
			    var value=$.trim(itemsData[index].value);
			    var text=$.trim(itemsData[index].text);
			    if(!this._existItem(value))
			    {
			    	this.fillItemData(value,text);
			    }
			}
			SelectList.buttonsStatus(this.id);
	},
	disable : function(b) {
		$(this.jid).attr("disabled", b);
		this.isEnable=!b;
	},
	checkData : function() {
			var resObj = {
				success : true,
				msg : '' ,
				isRequiredFailed : false
			};
			var v = this.getValueWithText();
			var len=v.length;
			if ((this.required && (len == 0))) {
				resObj.success = false;
				resObj.msg = this.blankValidateText;
				resObj.isRequiredFailed = true;
			}
		return resObj;
	}
    })));
};
