			var showHelpTip = "显示帮助信息";
			var hideHelpTip = "隐藏帮助信息";
			var cookieName_Hlep = "";
			
			function showHelp(b) {
					if (b) {
						jQuery('#tipTB').show();
						setCookie(cookieName_Hlep,'show');
						
					} else {
						jQuery('#tipTB').hide();
						setCookie(cookieName_Hlep,'hide');
				try{
					refreshHeight();
				} catch(e){}
			}
			}
			function weaveLink(str,aArr)
			{
				if(aArr == "" || aArr == null) 
				{
					return str;
				}
				 
				var aHeadArr = new Array();
				var isFirstConfig = "${isFirstConfig}";
				if(isFirstConfig == "true")
				{
					for(var i = 0 ; i < aArr.length ; i++)
					{
						aHeadArr[i] = "";
					}
				}
				else
				{
					for(var i = 0 ; i < aArr.length ; i++)
					{
						aHeadArr[i] = '<a onclick="javascript:{showMenuNode(\''+aArr[i]+ '\');}" class="a_noLink">';
					}
				}
				var aTail = '</a>';
				var newStr = "";
				var tempArr = str.split("[");
				for(var i = 0 ; i < tempArr.length - 1 ; i++)
				{
					newStr += tempArr[i] + aHeadArr[i];
				}
				newStr += tempArr[tempArr.length-1];
				
				var regs = /[]]/g;
				newStr = newStr.replace(regs,aTail);
				return newStr;
			}
			
			function unloadHandler()
			{
				
				var status = jQuery('#tipTB').css('display');
				
				alert('status'+status);
			}
			

function checkTimeOut(freshRequest){

		if(freshRequest == 'undefined'){
			freshRequest = false;
		}
		
		var retObj ;
		
		jQuery.ajax({
				   url : 'chekTimeOut!checkTimeOut.action',
		   	 	type : 'POST',
		   	 	data : 'freshRequest='+freshRequest,
		dataType : 'json',
			  async : false,
			  
		 success : function(data){
		 	if(data['msg'] == '0'){
		 		retObj = false;
		 	}else{
		 		if(data['msg'] == '1' || data['returnMsg'] == '2'){
		 			retObj = true;
		 		}
		 	}
		 },
		 	   error : function(data){
		 	   		alert('checkTimeOut'+data);
		 	   }
		});
	
		return retObj;
}


function setCookie(cookieName,value){
		if(cookieName == 'undefined'){
			return '';
		}
		
		var retObj;
		jQuery.ajax({
				   url : 'cookieProcess!setCookie'+_JS_IREPORT_EXT_,
		   	 	type : 'POST',
		   	 	data : 'cookieName='+cookieName+'&value='+value,
		dataType : 'json',
			  async : false,
			  
		 success : function(data){
		 	retObj	= data['success'];
		 },
		 	   error : function(data){
		 	   		alert(data['msg']);
		 	   }
		});
		
		return retObj;
}


function readCookie(cookieName){
	
		if(cookieName == 'undefined' || cookieName == null){
			return '';
		}
		
		var retObj;
		jQuery.ajax({
				   url : 'cookieProcess!readCookie'+_JS_IREPORT_EXT_,
		   	 	type : 'POST',
		   	 	data : 'cookieName='+cookieName,
		dataType : 'json',
			  async : false,
			  
		 success : function(data){
		 	retObj	= data['data'];
		 },
		 	   error : function(data){
		 	   		alert('@@'+data['msg']);
		 	   }
		});
		
		return retObj;
}

	getWeekOfYear = function(date) {
        var ms1d = 864e5;     
        var ms7d = 7 * ms1d;     
        var DC3 = Date.UTC(date.getFullYear(), date.getMonth(), date.getDate() + 3) / ms1d;     
        var AWN = Math.floor(DC3 / 7);     
        var Wyr = new Date(AWN * ms7d).getUTCFullYear();
    return AWN - Math.floor(Date.UTC(Wyr, 0, 7) / ms7d) + 1;
	};
	
	toStringByPattern = function(date,pattern) 
	{   
        var month = date.getMonth()+1;
        var day = date.getDate();
        var hour = date.getHours();
        var minute = date.getMinutes();
        var second = date.getSeconds();
        patternpattern = pattern.replace(/yyyy/g, date.getFullYear());   
        patternpattern = patternpattern.replace(/MM/g, month>9?month:'0'+month); 
        patternpattern = patternpattern.replace(/dd/g, day>9?day:'0'+day);   
        patternpattern = patternpattern.replace(/HH/g, hour>9?hour:'0'+hour);   
        patternpattern = patternpattern.replace(/mm/g, minute>9?minute:'0'+minute);   
        patternpattern = patternpattern.replace(/ss/g, second>9?second:'0'+second);   
        return patternpattern;   
    }   ;
    
    getDateConfig = function(source)
    {
    	var returnVal = "";
    	var array = [];
    	if(source.dateFmt!==undefined)
		{
			array.push("dateFmt:\'"+source.dateFmt+"\'");
		}
		if(source.autoUpdate!==undefined)
		{
			array.push("autoUpdateOnChanged:"+source.autoUpdate);
		}
		if(source.readOnly!==undefined)
		{
			array.push("readOnly:"+source.readOnly);
		}
		if(source.isShowWeek!==undefined)
		{
			array.push("isShowWeek:"+source.isShowWeek);
		}
		if(source.qsEnabled!==undefined)
		{
			array.push("qsEnabled:"+source.qsEnabled);
		}
		if(source.minDate!==undefined && new Number(source.minDate)>=Date_const.minDate)
		{
			array.push("minDate:'"+source.minDate+"-01-01 00:00:00'");
		}
		if(source.maxDate!==undefined  && new Number(source.maxDate)<=Date_const.maxDate)
		{
			array.push("maxDate:'"+source.maxDate+"-12-31 23:59:59'");
		}
		for(var i=0;i<array.length;i++)
		{
			returnVal = returnVal+array[i];
			if(i!=array.length-1)
			{
				returnVal = returnVal + ",";
			}
		}
		return returnVal;
    };
    
    getLongTimeByFmt = function(dateStr)
    {
    	var str = removeAllSpace(dateStr);
    	var lengths = str.length;
    	var returnVal = 0;
    	var year = 0;
    	var month = 1;
    	var day = 1;
    	var hour = 0;
    	var minute = 0;
    	var mm = 0;
    	if(lengths>=4)
    	{
    		year =  str.substr(0,4);
    	}
    	if(lengths>=6)
    	{
    		if(str.charAt(5)==="0")
    		{
    			month = new Number(str.substr(6,1))-1;
    		}
    		else
    		{
    			month = new Number(str.substr(5,2))-1;
    		}
    		
    	}
		if(lengths >= 10)
		{
			day = str.substr(8,2);
		}  
		if(lengths >= 12)
		{
			hour = str.substr(10,2);
		}  
		if(lengths >= 15)
		{
			minute = str.substr(13,2);
		}  
		if(lengths >= 18)
		{
			mm = str.substr(16,2);
		}
		return new Date(year,month,day,hour,minute,mm).getTime()/1000;
    };
    
    function removeAllSpace(str){   
        var localString = '';   
        for(var index = 0; index<str.length; index++)   
            if(str.charCodeAt(index)!= 32){   
                localString += str.charAt(index);   
            };   
    	return localString;   
    } 
    
    function isCorrectFormat(format,context)
    {
    	var reg = "";
    	var returnVal = true;
    	
    	if(format.toUpperCase()=="YYYY-MM-DD HH:MM:SS")
    	{
    		reg = /^(\d{4})-([0][0-9]|10|11|12)-([0-2][0-9]|30|31) ([0-1][0-9]|20|21|22|23):([0-5][0-9]):([0-5][0-9])$/;
    	}else if(format.toUpperCase()=="YYYY-MM-DD HH:MM")
    	{
    		reg = /^(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2})$/; 
    	}else if(format.toUpperCase()=="YYYY-MM-DD HH")
    	{
    		reg = /^(\d{4})-(\d{2})-(\d{2}) (\d{2})$/; 
    	}else if(format.toUpperCase()=="YYYY-MM-DD")
    	{
    		reg = /^(\d{4})-(\d{2})-(\d{2})$/; 
    	}else if(format.toUpperCase()=="YYYY-MM")
    	{
    		reg = /^(\d{4})-(\d{2})$/; 
    	}
    	
    	if(!reg.test(context))
    	{
    		returnVal = false;
    		return returnVal;
    	}
    	
    	var v = getLongTimeByFmt(context);
    	var numReg = /^-?[1-9]\d*$/; 
    	if(!numReg.test(v))
    	{
    		returnVal = false;
    	}
    	
        return returnVal;   
    }

	createSelectDoms = function(containerId,domId,domName,domDate,initOption,readonly){
		var json =[];
		for(var i=0;i<domDate.length;i++)
		{
			var map = {};
		    map["key"] = domDate[i][0];
		    map["value"] = domDate[i][1];
		   	json.push(map);
		}
		
		var selectDom = ConditionUtils.createCombobox({
			id : domId,
			container : "#" + containerId,
			name : domName,
			data : json,
			triggerSelected: true,
			key : "key",
			value :"value",
			textChangeCallback : function() {
			}
		})
		
		if (readonly == 'false'){
		    readonly = false;
		}else{
		    readonly = true;
		}
		
		var inputName = domName + "__sexyCombo";
		jQuery("#" + containerId).find(":text[name="
                + inputName + "]")
                .attr("readOnly", readonly).bind("focus click", function(event) {
                    this.select();
                });
		
		if(initOption!=undefined&&initOption.length>0)
		{
			selectDom.setComboxHiddenValue(initOption);
		}
		return selectDom;
	}

function createIPCom(param) {
		var len = 4;
		var tr = $("<tr></tr>");
		tr.data("ids", {
			ipName : param.ipName,
			portId : param.ipName + '_port'
		});
		createIpField(tr, param.ipName, "ip",param.isRequired);
		if (param.hasPort){
			createPort(tr, param.ipName + '_port');
		}
		if (param.add && param.index > 0){
			var _a_del = $('<a id="' + param.ipName + param.count+ '" style="cursor: pointer;" title="删除">&nbsp;<img src="'+param.imgPath+'/images/delete.png" width="16" height="16"></a>');
			_a_del.bind("click", function(){
				if (tr.index() > 0){
					tr.remove();
				}
			});
			tr.append($('<td width="100%" valign="bottom"></td>').append(_a_del));
		}
		return tr;
}

function createIPDouble(param) {
		var tr = $("<tr></tr>");
		tr.data("ids", {
			firstName : param.firstName,
			secondName : param.secondName,
			portId : param.firstName + '_port'
		});
		createIpField(tr, param.firstName, "ip");
		tr.append("<td class='ip_fldDot'>/</td>");
		if (param.type === "IPMASK"){
			createIpField(tr, param.secondName, "mask");
		}
		if (param.hasPort){
			createPort(tr, param.firstName + "_port");
		}
		
		if (param.add && param.index > 0){
			var _a_del = $('<a id="' + param.firstName + param.count+ '" style="cursor: pointer;"><img src="'+param.imgPath+'/images/delete.png" width="16" height="16"></a>');
			_a_del.bind("click", function(){
				if (tr.index() > 0){
					tr.remove();
				}
			});
			tr.append($('<td width="100%" valign="bottom"></td>').append(_a_del));
		}
		return tr;
}

function createPort(tr, _id){
	tr.append("<td style='padding-left:5px;padding-right:2px'>:</td>");
	var _row = jQuery("<tr/>");
	var _td = jQuery("<td/>");
	var tab = jQuery("<table/>", {
		align : 'left',
		cellspacing : '0',
		cellpadding : '0'
	}).addClass("x-ip-default");
	
	var td = $("<td nowrap></td>");
	var _portInput = $('<input/>',{
		id:_id,
	 	maxlength:5
	}).addClass("x-form-text x-form-field x-form-num-field")
	  .css({border:"0px solid rgb(102, 102, 102)",padding:"0pt",width:"45px"});
	var _expr = /\D/g;
	_portInput.bind("keydown keyup paste",{expr:_expr, max:65535, min:1}, function(event) {
					if (event.data.expr.test(this.value)) {
						this.value = this.value.replace(_expr, "");
					}
					if (this.value>event.data.max){
						this.value = event.data.max;
					}
					if (this.value != '' && this.value < event.data.min){
						this.value = event.data.min;
					}
				});
	td.append(_portInput);
	_row.append(td);
	tab.append(_row);
	_td.append(tab);
	tr.append(_td);
	
	var _labelTD = jQuery("<td/>");
	_labelTD.append('<label class="cbb-port-tip" style="white-space:nowrap;">[1-65535]</label>');
	tr.append(_labelTD);
}

function createIpField(tr, name, type,required){
	var len = 4;
	var _row = jQuery("<tr/>");
	for (var i = 0; i < len; ++i) {
		var _td = $("<td class='x-form-ff'></td>");
		var _text = $("<input/>", {
					size : 22,
					maxlength : 3,
					name : name,
					id : name + (i + 1)
				}).addClass("x-form-text x-form-field x-form-num-field")
				  .css({border:"0px solid rgb(102, 102, 102)",padding:"0pt",width:"27px"});
		_text.bind("paste", {appType:type}, doPaste);		
		_text.bind("keydown", {appType:type}, onIpFieldKeyDown);
		_text.bind("keyup", {appType:type}, onIpFieldKeyUp);
		_text.bind("blur", {appType:type,flag:required}, doOnblur);
		_text.bind("focus", {appType:type,flag:required}, onIpFieldFocus);
		_text.data("name", name);
		_text.appendTo(_td);
		_td.appendTo(_row);
		if (i < (len - 1)) {
			$("<td class='x-form-text' style='border:0px solid rgb(102, 102, 102);'>.</td>").appendTo(_row);
		}
	}
	
	var td = jQuery("<td/>");
	var tab = jQuery("<table/>", {
		align : 'left',
		cellspacing : '0',
		cellpadding : '0'
	}).addClass("ip-input-area x-ip-default");
	td.append(tab.append(_row)).appendTo(tr);
}


var IPCOM_Constant = {
	appType:{
	    IP:'ip',			
	    MASK:'mask',		
        IP_EXP:'ip_exp'		
	},
    eventType:{
    	BLUREV:'blurEvent',		
    	KEYUPEV:'keyUpEvent',	
    	TABEV:'tabEvent'		
    },
    returnType:{
    	NOTINPUT:null,						
    	NOTCOMPLETE:'',						
    	FORMATERROR:'formatError',			
    	FORMATERROR_EXP:'formatError_exp'	
    }
}

function doOnblur(event) {
	var appType = event.data.appType;
    var srcObj = event.target;
    
    var tableElt = jQuery(event.target).parents("table").first();
    
    var isPass = true;
    jQuery.each(tableElt.find("input"),function(){
        if (jQuery(this).val() == ""){
            isPass = false;
            return false;
        }
    });
    
    if (event.data.flag == 'true'){
        if (isPass){
            tableElt.removeClass("x-form-focus").removeClass("x-form-invalid").addClass("x-ip-default");
            tableElt.attr("title","");
        }else{
            tableElt.removeClass("x-form-focus").removeClass("x-ip-default").addClass("x-form-invalid");
            tableElt.attr("title","IP地址格式不正确,请输入正确的IP地址");
        }
    }else{
        tableElt.removeClass("x-form-focus").removeClass("x-form-invalid").addClass("x-ip-default");
    }
    
	if(srcObj.pasteStrOld != null) {
		window.clipboardData.setData('text', srcObj.pasteStrOld);
		srcObj.pasteStrOld = null;
	}
	feildValue_CheckObj(srcObj,IPCOM_Constant.eventType.BLUREV, appType);
}

function onIpFieldFocus(event){
   var tableElt = jQuery(event.target).parents("table").first();
   var index = 0;
   
   jQuery.each(tableElt.find("input"),function(){
        if (jQuery(this).val() == ""){
            index++;
        }
   });
   
   if (event.data.flag == 'true'){
	   if (index > 0){
	      if (index == 4){
	         tableElt.removeClass("x-ip-default").removeClass("x-form-invalid").addClass("x-form-focus");
	         tableElt.attr("title","");
	      }else{
	         tableElt.removeClass("x-ip-default").addClass("x-form-invalid");
	         tableElt.attr("title","IP地址格式不正确,请输入正确的IP地址");
	      }
	   }
	}
}


function doPaste (event) {
	var tr = $(event.target).parentsUntil("tr").parent();
	var name = $(event.target).data("name");
	var fieldArr = tr.find(":text[name="+name+"]");
	
    var valueArr = [];
    $.each(fieldArr, function(i, _f){
    	valueArr.push(_f.value);
        _f.value = "";
    });
	var data = ConditionUtils.getClipboardText();
	if(data){
		var ipDataArr =  data.split(".");
		var reg = /\D/g;
		
		var flag = true;
		$.each(ipDataArr, function(i, v){
			if(reg.test(v)){
				flag = false;
				return false;
			}
		});
		
		if (!flag){
			$.each(fieldArr, function(i, _f){
				$(_f).val(valueArr[i]);
			});
			alert("Format Error:xxx.xxx.xxx.xxx");
			return false;
		}
		
		$.each(fieldArr, function(i, _f){
			$(_f).val(ipDataArr[i]);
		});	
	}
	return false;
}

function fieldObj(preObj,value) {
    this.preObj = preObj;
    this.value = value;
    
    this.valueOfInt = function () {
        if(this.value.charAt(0) == '0') {
            if(this.value.charAt(1) == '0'){
                return parseInt(this.value);
            } else {
                if(this.value.length > 1)
                    return parseInt(this.value.substring(1));
                else return 0;
            }
        } else {
            return parseInt(this.value);
        }
    };
    
    this.validateMask = function () {
        var value_int = this.valueOfInt();
        var preObj = this.preObj;
        
        if(preObj != null) {
            if(preObj.valueOfInt() == 255) {            
                if(this.checkV() || value_int == 0 || value_int == 255)  return true;  
                    else return false;
            } else if(preObj.checkV()) {                                
                if(value_int == 0) return true;      
                    else return false;
            } else if(preObj.valueOfInt() == 0) {     
                if(value_int == 0) return true;     
                    else return false;
            } else {
                return false;
            }
        } else {
            if(value_int == 255 || this.checkV()) return true;
                else return false;
        }
        return false;
    };
    this.validateIp = function () {
    };
    this.checkV = function () {
        var v = this.valueOfInt();
        if((v == 254) || (v == 252) || (v == 248) || (v == 240) || (v == 224) || (v == 192) || (v == 128)) return true;
            else return false;
        
    };
}


function getIpStr(ipComId, type, valueOnly) {
	var fieldArr = getFieldArr(ipComId);
	var field_1 = fieldArr[0].value;
	var field_2 = fieldArr[1].value;
	var field_3 = fieldArr[2].value;
	var field_4 = fieldArr[3].value;

	if (field_1 == "" && field_2 == "" && field_3 == "" && field_4 == "") {
		return IPCOM_Constant.returnType.NOTINPUT;
	}
	else if (field_1 == "" || field_2 == "" || field_3 == "" || field_4 == "") {
		var objTemp = null;
		if(field_1 == '') objTemp = fieldArr[0];
		else if(field_2 == '') objTemp = fieldArr[1];
		else if(field_3 == '') objTemp = fieldArr[2];
		else if(field_4 == '') objTemp = fieldArr[3];
		if(valueOnly != 'valueOnly') {
			objTemp.select();
		}
		return IPCOM_Constant.returnType.NOTCOMPLETE;
	}

	var fieldObj_1 = new fieldObj(null,field_1);
	var fieldObj_2 = new fieldObj(fieldObj_1,field_2);
	var fieldObj_3 = new fieldObj(fieldObj_2,field_3);
	var fieldObj_4 = new fieldObj(fieldObj_3,field_4);
	
	if (type == IPCOM_Constant.appType.MASK) {
		if(!(fieldObj_1.validateMask() && fieldObj_2.validateMask() && fieldObj_3.validateMask() && fieldObj_4.validateMask())) {
		    var objTemp = null;
		    
		    if(!fieldObj_1.validateMask()) objTemp = fieldArr[0];
		    else if(!fieldObj_2.validateMask()) objTemp = fieldArr[1];
		    else if(!fieldObj_3.validateMask()) objTemp = fieldArr[2];
		    else if(!fieldObj_4.validateMask()) objTemp = fieldArr[3];
		    
		    if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
		    return IPCOM_Constant.returnType.FORMATERROR;
		}
	} else if(type == IPCOM_Constant.appType.IP_EXP) {
		var objTemp = null;
		if(fieldObj_1.valueOfInt() == 0) {
			if(fieldObj_2.valueOfInt() != 0 || fieldObj_3.valueOfInt() != 0 || fieldObj_4.valueOfInt() != 0) {
				if(valueOnly != 'valueOnly') {
					fieldArr[0].select();
				}
				return IPCOM_Constant.returnType.FORMATERROR_EXP;
			}
		} else if(fieldObj_1.valueOfInt() > 223) {
			objTemp = fieldArr[0];
		} else if(fieldObj_2.valueOfInt() > 255) {
            objTemp = fieldArr[1];
        } else if(fieldObj_3.valueOfInt() > 255) {
            objTemp = fieldArr[2];
        } else if(fieldObj_4.valueOfInt() > 255) {
            objTemp = fieldArr[3];
        } 
        if (objTemp != null) {
        	if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
        	return IPCOM_Constant.returnType.FORMATERROR_EXP;
        }
	} else{
		var objTemp = null;
		if (fieldObj_1.valueOfInt() == 0 || fieldObj_1.valueOfInt() > 223) {
			objTemp = fieldArr[0];
			if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
			return IPCOM_Constant.returnType.FORMATERROR;
		}
		else if (fieldObj_2.valueOfInt() > 255)
			objTemp = fieldArr[1];
		else if (fieldObj_3.valueOfInt() > 255)
			objTemp = fieldArr[2];
		else if (fieldObj_4.valueOfInt() > 255)
			objTemp = fieldArr[3];
		if (objTemp != null) {
			if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
			return IPCOM_Constant.returnType.FORMATERROR;
		}
	}
	var ipString = fieldObj_1.valueOfInt() + "." + fieldObj_2.valueOfInt() + "." + fieldObj_3.valueOfInt() + "." + fieldObj_4.valueOfInt();
	return ipString;
}


function setIpValue(ipStr, ipComId) {
	if (!isIpStr(ipStr)) {
		return false;
	}

	var fieldArr = getFieldArr(ipComId);

	var ipStrArr = ipStr.split(".");

	fieldArr[0].value = ipStrArr[0];
	fieldArr[1].value = ipStrArr[1];
	fieldArr[2].value = ipStrArr[2];
	fieldArr[3].value = ipStrArr[3];
}

function feildValue_CheckObj(srcObj,eventType, appType) {
	if(eventType != IPCOM_Constant.eventType.TABEV && eventType != IPCOM_Constant.eventType.KEYUPEV && eventType !=IPCOM_Constant.eventType.BLUREV) return false;
    var index = getFieldIndex(srcObj);
    var type = appType;
    var intV = parseInt(srcObj.value,10);
    var preObj = $(srcObj).parent().prev().prev().children();
    var isLegal = true; 
    if (type == IPCOM_Constant.appType.MASK) {
        if(index != 1) {
        	    if(intV > 254 && index == 4) 
				{
			        if (srcObj.value)
                	{
                		srcObj.value = 0;
			            srcObj.select();
			            isLegal =  false;
                	}
    			} 
    			else
    			{
		            if(preObj.val() == 255)
		            { 
		                if((intV == 254) || (intV == 252) || (intV == 248) || (intV == 240) || (intV == 224) || (intV == 192) || (intV == 128) || intV == 0 || intV == 255)
		                {
		                	isLegal = true;  
		                	srcObj.value=intV;
		                }
		                else
		                {
		                	if (srcObj.value)
		                	{
			                	srcObj.value = 255;
			                	srcObj.select();
					            isLegal =  false;
		                	}
				            
		                }
		            } 
		            else if((preObj.val() == 254) || (preObj.val() == 252) || (preObj.val() == 248) || (preObj.val() == 240) || (preObj.val() == 224) || (preObj.val() == 192) || (preObj.val() == 128))
		            { 
		                if(intV == 0)
		                {
		                	isLegal = true;   
		                	srcObj.value=intV;
		                }
		                else
		                {
		                	if (srcObj.value)
		                	{
		                		srcObj.value = 0;
					            srcObj.select();
					            isLegal =  false;
		                	}
		                	
		                }
		            } 
		            else if(preObj.val() == 0) 
		        	{     
		                if(intV == 0)
		                {
		                	isLegal = true;  
		                	srcObj.value=intV;
		                }
		                else
		                {
		                	if (srcObj.value)
		                	{
		                		srcObj.value = 0;
					            srcObj.select();
					            isLegal =  false;
		                	}
		                }
		            } 
		            else 
		        	{
		                if (srcObj.value)
	                	{
	                		srcObj.value = 0;
				            srcObj.select();
				            isLegal =  false;
	                	}
		            }
    			}
        } 
        else 
    	{
            if(intV == 255 || (intV == 254) || (intV == 252) || (intV == 248) || (intV == 240) || (intV == 224) || (intV == 192) || (intV == 128)) 
            {
            	isLegal = true;   
            	srcObj.value=intV;
            }
            else
            {
            	if (srcObj.value)
	        	{
	            	srcObj.value = 255;
	            	srcObj.select();
		            isLegal =  false;
	        	}
            }
        }
    } 
    else if((intV > 223 || intV == 0) && index == 1) 
	{
        srcObj.value = 223;
        srcObj.select();
        isLegal = false;
    } 
    else if((intV >= 255 || intV == 0) && index==4) 
	{
        srcObj.value = 254;
        srcObj.select();
        isLegal = false;
    } 
    else if (index == 2 || index == 3)
    {
    	if (intV > 255)
    	{
    		srcObj.value = 255;
    		srcObj.select();
        	isLegal = false;
    	}
    	else if (intV<=255 && intV>=0)
		{
    		srcObj.value = intV;
        	isLegal = true;
    	}
        
    }
    else if (index == 1 && parseInt(srcObj.value) == 0) 
	{
    	if(type == IPCOM_Constant.appType.IP_EXP) {
    	}
    	else {
    		srcObj.value = 1;
            srcObj.select();
            isLegal = false;
    	}
        
    }
    return isLegal;
}

function onIpFieldKeyUp(event) {
	var appType = event.data.appType;
    var srcObj = event.target;
    
	var keyCode = event.keyCode;
	
	if ((keyCode >= 48 && keyCode <= 57) || (keyCode >= 96 && keyCode <= 105)) {
		if (srcObj.value.length >= 3) {
			var goNext = feildValue_CheckObj(srcObj,IPCOM_Constant.eventType.KEYUPEV, appType);
			if (getFieldIndex(srcObj) != 4 && goNext) {
				var nextField = getNextField(srcObj);
				nextField.select();
			}
		}
	}
	
	if(srcObj.pasteStrOld != null) {
		window.clipboardData.setData('text', srcObj.pasteStrOld);
		srcObj.pasteStrOld = null;
	}
}

function onIpFieldKeyDown(event) {
    var appType = event.data.appType;
	var srcObj = event.target;
	var keyCode = event.keyCode;
    
	if (keyCode == 190 || keyCode == 110) {
		if (srcObj.value != "" && !hasSelectArea(srcObj)) {
			var nextField = getNextField(srcObj);
			nextField.select();
		}
		return event.returnValue = false;
	}

	else if (keyCode == 39 || keyCode == 40) {
		var curPos = getCaret(srcObj);
		var index = getFieldIndex(srcObj);
		if (curPos == srcObj.value.length && index != 4) {
			var nextField = getNextField(srcObj);
			setCaret(nextField, 'start');
			return event.returnValue = false;
		}
	}

	else if (keyCode == 37 || keyCode == 38) {
		var curPos = getCaret(srcObj);
		var index = getFieldIndex(srcObj);
		if (curPos == 0 && index != 1) {
			var preField = getPreField(srcObj);
			setCaret(preField, 'end');
			return event.returnValue = false;
		}
	}

	else if (keyCode == 8) {
		var curPos = getCaret(srcObj);
		if (curPos == 0) {
			var preField = getPreField(srcObj);
			setCaret(preField, 'end');
			return event.returnValue = false;
		}
	}

    else if(event.keyCode == 13) {
    }
    
    else if(event.keyCode == 9) {
        if(!feildValue_CheckObj(event.target,IPCOM_Constant.eventType.TABEV, appType)) return event.returnValue = false;
    }
    
	else if ((!event.shiftKey && keyCode >= 48 && keyCode <= 57)
			|| (keyCode >= 96 && keyCode <= 105) || keyCode == 46
			|| keyCode == 8) {
		if (document.selection
				&& ((!event.shiftKey && keyCode >= 48 && keyCode <= 57) || (keyCode >= 96 && keyCode <= 105))) {
			if (document.selection.type.toLowerCase() != "text"
					|| document.selection.createRange().parentElement() != srcObj) {
				if (srcObj.value.length == 3) {
					return event.returnValue = false;
				}
			}
		}
	}

	else if (event.ctrlKey && (keyCode == 67 || keyCode == 86 || keyCode == 88)) {
		return event.returnValue = true;
	}

	else {
		return event.returnValue = false;
	}
}

function hasSelectArea(srcObj) {
	if (document.selection != undefined) {
		if (document.selection.type.toLowerCase() != "text"
				|| document.selection.createRange().parentElement() != srcObj) {
			return false;
		} else
			return true;
	} else
		return false;
}

function getNextField(obj) {
	var idPrefix = obj.name;
	var index = getFieldIndex(obj);
	var nextField = null;

	if (index == 1) {
		nextField = document.getElementById(idPrefix + 2);
	} else if (index == 2) {
		nextField = document.getElementById(idPrefix + 3);
	} else {
		nextField = document.getElementById(idPrefix + 4);
	}
	return nextField;
}

function getPreField(obj) {
	var idPrefix = obj.name;
	var index = getFieldIndex(obj);
	var preField = null;

	if (index == 4) {
		preField = document.getElementById(idPrefix + 3);
	} else if (index == 3) {
		preField = document.getElementById(idPrefix + 2);
	} else {
		preField = document.getElementById(idPrefix + 1);
	}
	return preField;
}

function getFieldIndex(obj) {
	var objId = obj.id;
	var len = objId.length;
	return objId.charAt(len - 1);
}

function isIpStr(ipStr) {
	var strArr = ipStr.split(".");

	if (strArr.length != 4) {
		return false;
	}
	for (var i = 0; i < 4; i++) {
		if (strArr[i].length > 3)
			return false;

		if (parseInt(strArr[i]) < 0 || parseInt(strArr[i]) > 255) {
			return false;
		}
	}
	return true;
}

function clearIpCom(ipComId) {
	var fieldArr = getFieldArr(ipComId);
	fieldArr[0].value = "";
	fieldArr[1].value = "";
	fieldArr[2].value = "";
	fieldArr[3].value = "";
}

function disableIpCom(ipComId, b) {
	function disableField_Ext(srcObjId,b) {
        var srcObj = document.getElementById(srcObjId);
        srcObj.disabled = b;
        if(!b) {
            srcObj.className = 'ip_input';
        } else {
            srcObj.className = 'ip_input_disabled';
        }
    }
    disableField_Ext(ipComId + '1',b);
    disableField_Ext(ipComId + '2',b);
    disableField_Ext(ipComId + '3',b);
    disableField_Ext(ipComId + '4',b);
}

function getFieldArr(ipComId) {
	var fieldArr = new Array(4);
	for (var i = 0; i < 4; i++) {
		fieldArr[i] = document.getElementById(ipComId + (i + 1));

	}
	return fieldArr;
}

function getType(ipComId) {
	return document.getElementById("H_" + ipComId).value;
}

function $Name(name) {
	return document.getElementsByName(name);
}
function setCaret(textbox, pos) {
    if (textbox.createTextRange) { 
		var r = textbox.createTextRange();
		if (pos == "start") {
			r.collapse(true);
		}
		else {
			r.collapse(false);
		}
		r.select();
	}
    else if(textbox.setSelectionRange)         
    {
        textbox.focus();
        if (pos == "start") {
            textbox.setSelectionRange(0,0);
        }
        else {
            textbox.setSelectionRange(textbox.value.length,textbox.value.length);
        }
    }
    return true;
}

function getCaret(textbox) {
    if (document.selection != undefined) {               
    	textbox.focus();
    	var range = document.selection.createRange();
    	range.setEndPoint('StartToStart', textbox.createTextRange());
    	return range.text.length;
    }
    else if (textbox.selectionStart || textbox.selectionStart == '0') {   
        return textbox.selectionStart;
    }
    return 0;
}

function numberOnly(event) {
	var srcObj = event.target;
	var maxnum = event.data.maxnum;
	var holdChars = event.data.holdChars;
	if(srcObj.onkeyup == null || srcObj.onkeyup == 'undefined'){ 
	    keyupHandler_num(event)
	}
	if (srcObj.oldValue == null) {
		srcObj.oldValue = srcObj.value;
	}
	srcObj.holdChars = holdChars;
	srcObj.maxnum = maxnum;
	if (srcObj.curPos == null || srcObj.curPos == -1) {
		srcObj.curPos = getCaret(srcObj);
	}
	if (event.ctrlKey && event.keyCode == 86) {
		srcObj.paste = true;
	}
	if (document.selection != undefined && srcObj.selectArea == null) {
		if (document.selection.type.toLowerCase() != "text"
				|| document.selection.createRange().parentElement() != srcObj) {
			srcObj.selectArea = false;
		} else
			srcObj.selectArea = true; 
	}
}

function keyupHandler_num(event) {
	
	var srcObj = event.target;
	var _value = srcObj.value;
	var holdChars = srcObj.holdChars; 
	var maxnum = srcObj.maxnum; 
	var curPos = srcObj.curPos; 
	var keyCode = event.keyCode;

	if (srcObj.oldValue.length <= _value.length || srcObj.paste
			|| srcObj.selectArea) {
		if (holdChars == null || holdChars == "") {
			index = _value.search(/\D/g);
			if (index != -1) {
				if(event.keyCode != 13) {
				    srcObj.value = srcObj.oldValue;
				    setCaret(srcObj, curPos);
				} else {
					srcObj.select();
				}
			}
			else if (_value.length > 1 && _value.charAt(0) == '0') {
				if(event.keyCode != 13) {
					srcObj.value = 0;
                    srcObj.select();
				} else {
					srcObj.select();
				}
			} else if (parseInt(_value) > maxnum) {
				if(event.keyCode != 13) {
					srcObj.value = maxnum;
                    srcObj.select();
				} else {
					srcObj.select();
				}
			}
		}
		else {

			var reg = new RegExp("[^" + holdChars + "0-9]", 'g');
			var result = reg.exec(_value);
			if (result != null) {
				if(event.keyCode != 13) {
					srcObj.value = srcObj.oldValue;
                    setCaret(srcObj, curPos);
				} else {
					srcObj.select();
				}
			}
		}
	}
	if(event.keyCode != 13) {
	    srcObj.oldValue = srcObj.value;
	} else {
		srcObj.oldValue = '';
	}
	srcObj.curPos = -1;
	srcObj.selectArea = null;
}


(function (a) {
	a.fn.sexyCombo = function (d) {
		return this.each(function () {
			if ("SELECT" != this.tagName.toUpperCase()) {
				return;
			}
			new b(this, d);
		});
	};
	var c = {skin:"sexy", suffix:"__sexyCombo", hiddenSuffix:"__sexyComboHidden", renameOriginal:false, initialHiddenValue:"", emptyText:"", autoFill:false, triggerSelected:true, filterFn:null, dropUp:false, separator:",", key:"value", value:"text", showListCallback:null, hideListCallback:null, initCallback:null, initEventsCallback:null, changeCallback:null, textChangeCallback:null, checkWidth:true,inputFocusback:null};
	a.sexyCombo = function (e, h) {
		if (e.tagName.toUpperCase() != "SELECT") {
			return;
		}
		this.config = a.extend({}, c, h || {});
		this.selectbox = a(e);
		this.options = this.selectbox.children().filter("option");
		this.wrapper = this.selectbox.wrap("<div>").hide().parent().addClass("combo").addClass(this.config.skin);
		this.input = a("<input type='text' />").appendTo(this.wrapper).attr("autocomplete", "off").attr("id", this.selectbox.attr("name") + this.config.suffix).attr("value", "").attr("name", this.selectbox.attr("name") + this.config.suffix);
		var g = this.selectbox.attr("name");
		var d = g + this.config.hiddenSuffix;
		if (this.config.renameOriginal) {
			this.selectbox.attr("name", d);
		}
		this.hidden = a("<input type='hidden' />").appendTo(this.wrapper).attr("autocomplete", "off").attr("value", this.config.initialHiddenValue).attr("name", this.config.renameOriginal ? g : d);
		this.icon = a("<div />").appendTo(this.wrapper).addClass("icon");
		this.listWrapper = a("<div />").appendTo(this.wrapper).addClass("list-wrapper");
		this.updateDrop();
		this.list = a("<ul />").appendTo(this.listWrapper);
		var f = this;
		var i = [];
		this.options.each(function () {
			var k = a.trim(a(this).text());
			if (f.config.checkWidth) {
				i.push(a("<li />").appendTo(f.list).html("<span title='" + k + "'>" + k + "</span>").addClass("visible").find("span").outerWidth());
			} else {
				a("<li />").appendTo(f.list).html("<span title='" + k + "'>" + k + "</span>").addClass("visible");
			}
		});
		this.listItems = this.list.children();
		if (i.length) {
			i = i.sort(function (l, k) {
				return l - k;
			});
			var j = i[i.length - 1];
		}
		this.singleItemHeight = this.listItems.outerHeight() == 0 ? 20 : this.listItems.outerHeight();
		this.listWrapper.addClass("invisible");
		if (a.browser.opera) {
			this.wrapper.css({position:"relative", left:"0", top:"0"});
		}
		this.filterFn = ("function" == typeof (this.config.filterFn)) ? this.config.filterFn : this.filterFn;
		this.lastKey = null;
		this.multiple = this.selectbox.attr("multiple");
		var f = this;
		this.wrapper.data("sc:lastEvent", "click");
		this.overflowCSS = "overflowY";
		if ((this.config.checkWidth) && (this.listWrapper.innerWidth() < j)) {
			this.overflowCSS = "overflow";
		}
		this.notify("init");
		this.initEvents();
	};
	var b = a.sexyCombo;
	b.fn = b.prototype = {};
	b.fn.extend = b.extend = a.extend;
	b.fn.extend({initEvents:function () {
		var d = this;
		this.icon.bind("click", function (f) {
			if (!d.wrapper.data("sc:positionY")) {
				d.wrapper.data("sc:positionY", f.pageY);
			}
		});
		this.input.bind("click", function (f) {
			if (!d.wrapper.data("sc:positionY")) {
				d.wrapper.data("sc:positionY", f.pageY);
			}
			if(a.isFunction(d.config["inputFocusback"]))
			{
				d.config["inputFocusback"].call(this);
			}
		});
		this.wrapper.bind("click", function (f) {
			if (!d.wrapper.data("sc:positionY")) {
				d.wrapper.data("sc:positionY", f.pageY);
			}
		});
		this.icon.bind("click", {self:d}, d.iconEventFn);
		this.listItems.bind("mouseover", function (f) {
			if ("LI" == f.target.nodeName.toUpperCase()) {
				d.highlight(f.target);
			} else {
				d.highlight(a(f.target).parent());
			}
		});
		this.listItems.bind("click", function (f) {
			d.listItemClick(a(f.target));
		});
		this.input.bind("keyup", function (f) {
			d.wrapper.data("sc:lastEvent", "key");
			d.keyUp(f);
		});
		this.input.bind("keypress", function (f) {
			if (b.KEY.RETURN == f.keyCode) {
				f.preventDefault();
			}
			if (b.KEY.TAB == f.keyCode) {
				f.preventDefault();
			}
		});
		a(document).bind("click", function (f) {
			if ((d.icon.get(0) == f.target) || (d.input.get(0) == f.target)) {
				return;
			}
			d.hideList();
		});
		this.triggerSelected();
		this.applyEmptyText();
		this.input.bind("click", function (f) {
			d.wrapper.data("sc:lastEvent", "click");
			d.icon.trigger("click");
		});
		this.wrapper.bind("click", function () {
			d.wrapper.data("sc:lastEvent", "click");
		});
		this.input.bind("keydown", function (f) {
			if (9 == f.keyCode) {
				f.preventDefault();
			}
		});
		this.wrapper.bind("keyup", function (g) {
			var f = g.keyCode;
			for (key in b.KEY) {
				if (b.KEY[key] == f) {
					return;
				}
			}
			d.wrapper.data("sc:lastEvent", "key");
		});
		this.input.bind("click", function () {
			d.wrapper.data("sc:lastEvent", "click");
		});
		this.icon.bind("click", function (f) {
			if (!d.wrapper.data("sc:positionY")) {
				d.wrapper.data("sc:positionY", f.pageY);
			}
		});
		this.input.bind("click", function (f) {
			if (!d.wrapper.data("sc:positionY")) {
				d.wrapper.data("sc:positionY", f.pageY);
			}
		});
		this.wrapper.bind("click", function (f) {
			if (!d.wrapper.data("sc:positionY")) {
				d.wrapper.data("sc:positionY", f.pageY);
			}
		});
		this.notify("initEvents");
	}, iconEventFn:function (e) {
		var d = e.data.self;
		if (d.input.attr("disabled")) {
			d.input.attr("disabled", false);
		}
		d.wrapper.data("sc:lastEvent", "click");
		d.filter();
		d.iconClick();
	}, getTextValue:function () {
		return this.__getValue("input");
	}, getCurrentTextValue:function () {
		return this.__getCurrentValue("input");
	}, getHiddenValue:function () {
		return this.__getValue("hidden");
	}, getCurrentHiddenValue:function () {
		return this.__getCurrentValue("hidden");
	}, __getValue:function (h) {
		h = this[h];
		if (!this.multiple) {
			return a.trim(h.val());
		}
		var f = h.val().split(this.config.separator);
		var g = [];
		for (var e = 0, d = f.length; e < d; ++e) {
			g.push(a.trim(f[e]));
		}
		g = b.normalizeArray(g);
		return g;
	}, __getCurrentValue:function (d) {
		d = this[d];
		if (!this.multiple) {
			return a.trim(d.val());
		}
		return a.trim(d.val().split(this.config.separator).pop());
	}, iconClick:function () {
		if (this.listVisible()) {
			this.hideList();
			this.input.blur();
		} else {
			this.showList();
			this.input.focus();
			if (this.input.val().length) {
				this.selection(this.input.get(0), 0, this.input.val().length);
			}
		}
	}, listVisible:function () {
		return this.listWrapper.hasClass("visible");
	}, showList:function () {
		if (!this.listItems.filter(".visible").length) {
			return;
		}
		this.listWrapper.removeClass("invisible").addClass("visible");
		this.wrapper.css("zIndex", "99999");
		this.listWrapper.css("zIndex", "99999");
		this.setListHeight();
		var e = this.listWrapper.height();
		var f = this.wrapper.height();
		var d = parseInt(this.wrapper.data("sc:positionY")) + f + e;
		var g = a(window).height() + a(document).scrollTop();
		if (d > g) {
			this.setDropUp(true);
		} else {
			this.setDropUp(false);
		}
		if ("" == a.trim(this.input.val())) {
			this.highlightFirst();
			this.listWrapper.scrollTop(0);
		} else {
			this.highlightSelected();
		}
		this.notify("showList");
	}, hideList:function () {
		if (this.listWrapper.hasClass("invisible")) {
			return;
		}
		this.listWrapper.removeClass("visible").addClass("invisible");
		this.wrapper.css("zIndex", "0");
		this.listWrapper.css("zIndex", "99999");
		this.notify("hideList");
	}, getListItemsHeight:function () {
		var d = this.singleItemHeight;
		return d * this.liLen();
	}, setOverflow:function () {
		var d = this.getListMaxHeight();
		if (this.getListItemsHeight() > d) {
			this.listWrapper.css(this.overflowCSS, "scroll");
		} else {
			this.listWrapper.css(this.overflowCSS, "hidden");
		}
	}, highlight:function (d) {
		if ((b.KEY.DOWN == this.lastKey) || (b.KEY.UP == this.lastKey)) {
			return;
		}
		this.listItems.removeClass("active");
		a(d).addClass("active");
	}, setComboValue:function (h, g, d) {
		var f = this.input.val();
		var e = "";
		if (this.multiple) {
			e = this.getTextValue();
			if (g) {
				e.pop();
			}
			e.push(a.trim(h));
			e = b.normalizeArray(e);
			e = e.join(this.config.separator) + this.config.separator;
		} else {
			e = a.trim(h);
		}
		this.input.val(e);
		this.input.attr("title", e);
		this.setHiddenValue(h);
		this.filter();
		if (d) {
			this.hideList();
		}
		this.input.removeClass("empty");
		if (this.multiple) {
			this.input.focus();
		}
		if (this.input.val() != f) {
			this.notify("textChange");
		}
	},setComboxdiable:function(flag){
	   if(flag)
	   {
	   		this.input.attr("disabled","disabled");
	   		this.icon.unbind("click");
	   }
	   else
	   {
	   		this.input.removeAttr("disabled");
	   		this.icon.bind("click", {
				self : this
			}, this.iconEventFn);
	   }
	}, setComboxHiddenValue:function(v){
	    v = a.trim(v);
		for (var g = 0, h = this.options.length; g < h; ++g) {
				if (v == this.options.eq(g).val()) {
					this.setComboValue(this.options.eq(g).text());
					break;
				}else if(g==this.options.length-1){
					this.setComboValue(this.options.eq(0).text());
				}
			}
	}, 
	setHiddenValue:function (d) {
		var l = false;
		d = a.trim(d);
		var n = this.hidden.val();
		if (!this.multiple) {
			for (var g = 0, h = this.options.length; g < h; ++g) {
				if (d == this.options.eq(g).text()) {
					this.hidden.val(this.options.eq(g).val());
					l = true;
					break;
				}
			}
		} else {
			var k = this.getTextValue();
			var m = [];
			for (var g = 0, h = k.length; g < h; ++g) {
				for (var f = 0, e = this.options.length; f < e; ++f) {
					if (k[g] == this.options.eq(f).text()) {
						m.push(this.options.eq(f).val());
					}
				}
			}
			if (m.length) {
				l = true;
				this.hidden.val(m.join(this.config.separator));
			}
		}
		if (!l) {
			this.hidden.val(this.config.initialHiddenValue);
		}
		if (n != this.hidden.val()) {
			this.notify("change");
		}
		this.selectbox.val(this.hidden.val());
		this.selectbox.trigger("change");
	}, listItemClick:function (d) {
		this.setComboValue(d.text(), true, true);
		this.inputFocus();
	}, filter:function () {
		if ("yes" == this.wrapper.data("sc:optionsChanged")) {
			var e = this;
			this.listItems.remove();
			this.options = this.selectbox.children().filter("option");
			this.options.each(function () {
				var f = a.trim(a(this).text());
				a("<li />").appendTo(e.list).text(f).addClass("visible");
			});
			this.listItems = this.list.children();
			this.listItems.bind("mouseover", function (f) {
				e.highlight(f.target);
			});
			this.listItems.bind("click", function (f) {
				e.listItemClick(a(f.target));
			});
			e.wrapper.data("sc:optionsChanged", "");
		}
		var d = this.input.val();
		var e = this;
		this.listItems.each(function () {
			var f = a(this);
			var g = f.text();
			if (e.filterFn.call(e, e.getCurrentTextValue(), g, e.getTextValue())) {
				f.removeClass("invisible").addClass("visible");
			} else {
				f.removeClass("visible").addClass("invisible");
			}
		});
		this.setOverflow();
		this.setListHeight();
	}, filterFn:function (g, h, e) {
		if ("click" == this.wrapper.data("sc:lastEvent")) {
			return true;
		}
		if (!this.multiple) {
			return h.toLowerCase().indexOf(g.toLowerCase()) == 0;
		} else {
			for (var f = 0, d = e.length; f < d; ++f) {
				if (h == e[f]) {
					return false;
				}
			}
			return h.toLowerCase().search(g.toLowerCase()) == 0;
		}
	}, getListMaxHeight:function () {
		var d = parseInt(this.listWrapper.css("maxHeight"), 10);
		if (isNaN(d)) {
			d = this.singleItemHeight * 10;
		}
		return d;
	}, setListHeight:function () {
		var d = this.getListItemsHeight();
		var f = this.getListMaxHeight();
		var e = this.listWrapper.height();
		if (d < e) {
			this.listWrapper.height(d);
			return d;
		} else {
			if (d > e) {
				this.listWrapper.height(Math.min(f, d));
				return Math.min(f, d);
			}
		}
	}, getActive:function () {
		return this.listItems.filter(".active");
	}, keyUp:function (f) {
		this.lastKey = f.keyCode;
		var d = b.KEY;
		switch (f.keyCode) {
		  case d.RETURN:
		  case d.TAB:
			this.setComboValue(this.getActive().text(), true, true);
			if (!this.multiple) {
				break;
			}
		  case d.DOWN:
			this.highlightNext();
			break;
		  case d.UP:
			this.highlightPrev();
			break;
		  case d.ESC:
			this.hideList();
			break;
		  default:
			this.inputChanged();
			break;
		}
	}, liLen:function () {
		return this.listItems.filter(".visible").length;
	}, inputChanged:function () {
		this.filter();
		if (this.liLen()) {
			this.showList();
			this.setOverflow();
			this.setListHeight();
		} else {
			this.hideList();
		}
		this.setHiddenValue(this.input.val());
		this.notify("textChange");
	}, highlightFirst:function () {
		this.listItems.removeClass("active").filter(".visible:eq(0)").addClass("active");
		this.autoFill();
	}, highlightSelected:function () {
		this.listItems.removeClass("active");
		var f = a.trim(this.input.val());
		try {
			this.listItems.each(function () {
				var e = a(this);
				if (e.text() == f) {
					e.addClass("active");
					self.listWrapper.scrollTop(0);
					self.scrollDown();
				}
			});
			this.highlightFirst();
		}
		catch (d) {
		}
	}, highlightNext:function () {
		var d = this.getActive().next();
		while (d.hasClass("invisible") && d.length) {
			d = d.next();
		}
		if (d.length) {
			this.listItems.removeClass("active");
			d.addClass("active");
			this.scrollDown();
		}
	}, scrollDown:function () {
		if ("scroll" != this.listWrapper.css(this.overflowCSS)) {
			return;
		}
		var d = this.getActiveIndex() + 1;
		var e = this.listItems.outerHeight() * d - this.listWrapper.height();
		if (a.browser.msie) {
			e += d;
		}
		if (this.listWrapper.scrollTop() < e) {
			this.listWrapper.scrollTop(e);
		}
	}, highlightPrev:function () {
		var d = this.getActive().prev();
		while (d.length && d.hasClass("invisible")) {
			d = d.prev();
		}
		if (d.length) {
			this.getActive().removeClass("active");
			d.addClass("active");
			this.scrollUp();
		}
	}, getActiveIndex:function () {
		return a.inArray(this.getActive().get(0), this.listItems.filter(".visible").get());
	}, scrollUp:function () {
		if ("scroll" != this.listWrapper.css(this.overflowCSS)) {
			return;
		}
		var d = this.getActiveIndex() * this.listItems.outerHeight();
		if (this.listWrapper.scrollTop() > d) {
			this.listWrapper.scrollTop(d);
		}
	}, applyEmptyText:function () {
		if (!this.config.emptyText.length) {
			return;
		}
		var d = this;
		this.input.bind("focus", function () {
			d.inputFocus();
		}).bind("blur", function () {
			d.inputBlur();
		});
		if ("" == this.input.val()) {
			this.input.addClass("empty").val(this.config.emptyText);
			this.input.attr("title", this.config.emptyText);
		}
	}, inputFocus:function () {
		if (this.input.hasClass("empty")) {
			this.input.removeClass("empty").val("");
		}
	}, inputBlur:function () {
		if ("" == this.input.val()) {
			this.input.addClass("empty").val(this.config.emptyText);
		}
	}, triggerSelected:function () {
		if (!this.config.triggerSelected) {
			return;
		}
		var d = this;
		try {
			this.options.each(function () {
				if (a(this).attr("selected")) {
					d.setComboValue(a(this).text(), false, true);
					throw new Error();
				}
			});
		}
		catch (f) {
			return;
		}
		d.setComboValue(this.options.eq(0).text(), false, false);
	}, autoFill:function () {
		if (!this.config.autoFill || (b.KEY.BACKSPACE == this.lastKey) || this.multiple) {
			return;
		}
		var e = this.input.val();
		var d = this.getActive().text();
		this.input.val(d);
		this.selection(this.input.get(0), e.length, d.length);
	}, selection:function (f, g, e) {
		if (f.createTextRange) {
			var d = f.createTextRange();
			d.collapse(true);
			d.moveStart("character", g);
			d.moveEnd("character", e);
			d.select();
		} else {
			if (f.setSelectionRange) {
				f.setSelectionRange(g, e);
			} else {
				if (f.selectionStart) {
					f.selectionStart = g;
					f.selectionEnd = e;
				}
			}
		}
	}, updateDrop:function () {
		if (this.config.dropUp) {
			this.listWrapper.addClass("list-wrapper-up");
		} else {
			this.listWrapper.removeClass("list-wrapper-up");
		}
	}, setDropUp:function (d) {
		this.config.dropUp = d;
		this.updateDrop();
	}, notify:function (d) {
		if (!a.isFunction(this.config[d + "Callback"])) {
			return;
		}
		this.config[d + "Callback"].call(this);
	}});
	b.extend({KEY:{UP:38, DOWN:40, DEL:46, TAB:9, RETURN:13, ESC:27, COMMA:188, PAGEUP:33, PAGEDOWN:34, BACKSPACE:8}, log:function (e) {
		var d = a("#log");
		d.html(d.html() + e + "<br />");
	}, createSelectbox:function (e) {
		var j = a("<select />").appendTo(e.container).attr({name:e.name, id:e.id, size:"1"}).addClass("notExistClass");
		if (e.multiple) {
			j.attr("multiple", true);
		}
		var h = e.data;
		var g = false;
		for (var f = 0, d = h.length; f < d; ++f) {
			g = h[f].selected || false;
			a("<option />").appendTo(j).attr("value", h[f][e.key]).text(h[f][e.value]).attr("selected", g);
		}
		return j.get(0);
	}, create:function (e) {
		var f = {name:"", id:"", data:[], multiple:false, key:"value", value:"text", container:a(document), url:"", ajaxData:{}};
		e = a.extend({}, f, e || {});
		if (e.url) {
			return a.getJSON(e.url, e.ajaxData, function (g) {
				delete e.url;
				delete e.ajaxData;
				e.data = g;
				return b.create(e);
			});
		}
		e.container = a(e.container);
		var d = b.createSelectbox(e);
		return new b(d, e);
	}, deactivate:function (d) {
		d = a(d);
		d.each(function () {
			if ("SELECT" != this.tagName.toUpperCase()) {
				return;
			}
			var e = a(this);
			if (!e.parent().is(".combo")) {
				return;
			}
		});
	}, activate:function (d) {
		d = a(d);
		d.each(function () {
			if ("SELECT" != this.tagName.toUpperCase()) {
				return;
			}
			var e = a(this);
			if (!e.parent().is(".combo")) {
				return;
			}
			e.parent().find("input[type='text']").attr("disabled", false);
		});
	}, changeOptions:function (d) {
		d = a(d);
		d.each(function () {
			if ("SELECT" != this.tagName.toUpperCase()) {
				return;
			}
			var h = a(this);
			var g = h.parent();
			var i = g.find("input[type='text']");
			var f = g.find("ul").parent();
			f.removeClass("visible").addClass("invisible");
			g.css("zIndex", "0");
			f.css("zIndex", "99999");
			i.val("");
			g.data("sc:optionsChanged", "yes");
			var e = h;
			e.parent().find("input[type='text']").val(e.find("option:eq(0)").text());
			e.parent().data("sc:lastEvent", "click");
			e.find("option:eq(0)").attr("selected", "selected");
		});
	}, normalizeArray:function (f) {
		var e = [];
		for (var g = 0, d = f.length; g < d; ++g) {
			if ("" == f[g]) {
				continue;
			}
			e.push(f[g]);
		}
		return e;
	}});
})(jQuery);


var CBB_Shim = CBB_Shim;
if (typeof CBB_Shim == "undefined") {
	CBB_Shim = function(t) {
		this._doc;
		this.target;
		this.jShim = null;
		var ie = $.browser.msie && /6.0/.test(navigator.userAgent);
		this.init = function() {
			if(typeof t == "string") {
				this.target = $("#" + c.target);
			} else  if(typeof t == "object"){
				this.target = t.css && t.attr?t:$(t);
			}
			
			var tel = this.target.get(0);
			this._doc = tel.ownerDocument;
			this.jShim = $("<iframe frameborder='' class='cbb_shim'/>", this._doc).addClass("cbb_shim").css({
				zIndex : tel.style.zIndex - 1
			}).appendTo(tel.parentNode);
			var width = this.target.outerWidth();
			
			this.jShim.css({
				position : "absolute",
				top : this.target.attr("offsetTop"),
				left : this.target.attr("offsetLeft"),
				right : this.target.css("right"),
				bottom : this.target.css("bottom"),
				display: "none",
				width : width = width > 0 ? width : "",
				height: this.target.outerHeight()
			});
		}
		
		this.show = function() {
			if(ie) this.jShim.show();
		}
		
		this.hide = function() {
			if(ie) this.jShim.hide();
		}
		
		this.destory = function() {
			if(ie) this.jShim.remove();
		}
		
		if (ie) { 
			this.init(t);
		}
	}
}

var CBB_Mask = CBB_Mask;
if (typeof CBB_Mask == "undefined") {
	CBB_Mask = function(config) {
		this._doc = document;
		this.jMaskMsg;
		this.jMask;
		this.target;
		this.shim;
		
		var self = this;

		_defaults = {
			id : null,
			loadingClass : null,
			zIndex : 800,
			loadingMode: false,
			msg: ""
		};

		this.hide = function() {
			this.jMask.css("display", "none");
			if(this.jMaskMsg) {
				this.jMaskMsg.fadeOut(0);
			}
			this.shim.hide();
		}

		this.show = function() {
			if ($.browser.msie && /6.0/.test(navigator.userAgent)) {
				this.jMask.css({
					width : this.target.outerWidth(),
					height : this.target.outerHeight()
				});
			}
			this.jMask.css("display", "block");
			
			if(this.jMaskMsg) {
				this.jMaskMsg.css("display", "block");
				this.jMaskMsg.css({
					top:(this.jMask.height()/2 - this.jMaskMsg.height()/2) + "px",
					left:(this.jMask.width()/2 - this.jMaskMsg.innerWidth()/2) + "px"
				});
			}
			
			if(!this.shim) {
				this.shim = new CBB_Shim(this.jMask);
			}
			this.shim.show();
		}

		this.destory = function() {
			this.jMask.remove();
			if (this.shim)
			{
				this.shim.destory();
			}
			this.shim = null;
		}
		
		this.init = function(c) {
			c = $.extend({}, _defaults, c);
			this.c = c;
			
			if(typeof c.target == "string") {
				this.target = $("#" + c.target);
			} else  if(typeof c.target == "object"){
				if(c.target.css && c.target.attr) {
					this.target = c.target;
				} else {
					this.target = $(c.target)
				}
			}
			
			var tel = this.target.get(0);
			
			this._doc = this.target.get(0).ownerDocument;
			this.jMask = $("<div class='cbb_mask'/>", this._doc).css({
				zIndex : this.c.zIndex
			}).appendTo(tel.parentNode);
			
			var width = this.target.outerWidth();
			
			this.jMask.css({
				position : "absolute",
				top : this.target.attr("offsetTop"),
				left : this.target.attr("offsetLeft"),
				right : this.target.css("right"),
				bottom : this.target.css("bottom"),
				display: "none",
				width : width = width > 0 ? width : "",
				height: this.target.outerHeight()
			});
			
			if(this.c.loadingMode) {
				this.jMaskMsg = $('<div class="cbb_mask_msg cbb_mask_loading"></div>', this._doc).css("z-index", this.c.zIndex + 1).appendTo(this.jMask);
				$("<div/>", this._doc).appendTo(this.jMaskMsg).text(this.c.msg).css("z-index", this.c.zIndex + 2);
				if(this.c.imgClass) {
					this.jMaskMsg.addClass(this.c.imgClass);
				}
			}
			
			if(this.c.maskClass) {
				this.jMask.addClass(this.c.maskClass);
			}
		}

		this.init(config);
	}
}

				

var Date_const = {
	maxDate:2020,															
	minDate:2000,															
	defaultDateFmt:"yyyy-MM-dd"												
};


var ConditionUtils = {
    getPath :function(){
      var appName = location.pathname.substring(0, location.pathname.indexOf("/", 1));
      var _path = location.protocol + "//" + location.host + appName; 
      return _path;
    },
    inArray : function(a, arr){
        if (a && arr && arr.constructor == Array){
             for (var i  = 0; i < arr.length; i++){
                   if(JSON.stringify(a) == JSON.stringify(arr[i])){
                        return i;
                   }
             }
        }
        return -1;
    },
    buildResourse : function(text, ar){
        if(text){
	        var rst = text;
	        for (var i = 0; i<ar.length; i++){
	            rst = rst.replace("{" + i + "}", ar[i]);
	        }
            return rst;
        }
        return "";
    },
	override : function(o, oo) {
		for (var m in oo) {
			o[m] = oo[m];
		}
		return o;
	},

	isTrue: function(v) { return v===true||v==="true"}	,
	isFalse: function(v) { return v===false||v==="false"}	,
	
	createSimpleSelect : function(param){
        var sel = jQuery(param.container).find("#"+param.id);
        if (sel.size() == 0){
            sel = jQuery("<select/>", {
                id : param.id,
                name : param.name
            }).addClass("simpleSelect");
            jQuery(param.container).append(sel);
        }else{
            sel.empty();
        }
        
        if (param.data){
            jQuery.each(param.data, function(i, obj){
                jQuery("<option value="+obj[param.key]+">"+obj[param.value]+"</option>")
                    .appendTo(sel);
            });
        }
        return sel;
    },
	
	createCombobox : function(param) {
		return jQuery.sexyCombo.create(param);
	},
	
	createChooseObjGroup : function(param) {
		param.columns = this.df(param.columns, 4);
		param.type = this.df(param.type, "checkbox");
        
		var container = jQuery("#" + param.containerId);
		var tab = jQuery("<table border='0' cellspacing='0' cellpadding='0'></tr>");
		var tr = jQuery("<tr></tr>").attr("valign", "top");
		var rows = [];
		jQuery.each(param.data, function(i, _obj) {
			if (i > 0 && (i % param.columns) === 0) {
				rows.push(tr);
				tr = jQuery("<tr></tr>").attr("valign", "top");
			}
			
			var _t = _obj[param.displayField];
			if (_t.length > param.cutNum) {
				_t = _t.substring(0, param.cutNum) + "...";
			}
			if(param.type == 'checkbox') {
				var td = jQuery("<td width='200px'></td>").css("valign", "top");
			}
			else {
				var td = jQuery("<td width='120px'></td>").css("valign", "top");
			}
			var _firstDiv;
			var _secondDiv;
			var _img;
			var _input;
			var _label;
			var lableId;
			
			if (param.type == 'radio'){
				_firstDiv = jQuery("<div class='x-form-radio-wrap'></div>");
				_secondDiv = jQuery("<div class='x-form-radio-wrap-inner'></div>");
				var imgSrc = WEB_ROOT_ABS_PATH + "/iReport/resources/ext/images/default/s.gif";
				_img = jQuery("<img src= '"+imgSrc+"' class='x-form-radio'/>");
				_input = jQuery("<input type='" + param.type + "' value='"
						+ _obj[param.valueField] + "' name='" + param.name + "' id='" + param.name + "_" + i +"'/>")
						.data("text", _obj[param.displayField]).addClass("x-form-radio x-form-field x-hidden");
			}else{
			    _firstDiv = jQuery("<div class='x-form-check-wrap'></div>");
				_secondDiv = jQuery("<div class='x-form-check-wrap-inner'></div>");
                var imgSrc = WEB_ROOT_ABS_PATH + "/iReport/resources/ext/images/default/s.gif";
                _img = jQuery("<img src= '"+imgSrc+"' class='x-form-check'/>");
				_input = jQuery("<input type='" + param.type + "' value='"
						+ _obj[param.valueField] + "' name='" + param.name + "' id='" + param.name + "_" + i +"'/>")
						.data("text", _obj[param.displayField]).addClass("x-form-checkbox x-form-field x-hidden");
			}
			_secondDiv.bind({
				"mousemove" : function(){jQuery(this).addClass("x-form-check-over");},
				"mouseout" : function(){jQuery(this).removeClass("x-form-check-over");}
		    });
			if (param.type == 'radio'){
				_label = jQuery("<label title='" + _obj[param.displayField] + "' style='cursor:pointer;padding-left:11px;color:black;'>" + _t
							+ "</label>").addClass("x-checkboxlabel");
			}else{
				if(window.navigator.userAgent.toLowerCase().indexOf("msie") >= 1) {  
				   _label = jQuery("<label title='" + _obj[param.displayField] + "' style='cursor:pointer;padding-left:8px;color:black;'>" + _t
								+ "</label>").addClass("x-checkboxlabel");
				}
				else if($.browser.version == '1.9.1'){
					_label = jQuery("<label title='" + _obj[param.displayField] + "' style='cursor:pointer;padding-left:11px;color:black;'>" + _t
								+ "</label>").addClass("x-checkboxlabel");
				}
				else {
					_label = jQuery("<span>&nbsp;<label title='" + _obj[param.displayField] + "' style='cursor:pointer;color:black;'>" + _t
								+ "</label></span>").addClass("x-checkboxlabel");
				}
			}
			lableId = "lbl" + param.name + "_" + i;
            _label.attr("id", lableId);
            
            _secondDiv.append(_img).append(_input).append(_label);
            _secondDiv.appendTo(_firstDiv);
            _firstDiv.appendTo(td);
			td.appendTo(tr);

			if (i == param.data.length - 1) {
				rows.push(tr);
			}
		})

		jQuery.each(rows, function(i, _row) {
			_row.appendTo(tab);
		});
		tab.appendTo(container);
	},
	df : function(v, defv) {
		if (v)
			return v;
		return defv;
	},
	isArray : function(arr) {
		return Object.prototype.toString.call(arr) == '[object Array]';
	},
	el : function(el, doc) {
		if (typeof el == 'string') {
			doc = doc?doc: document;
			return doc.getElementById(el);
		}
		return el;
	},
	sel: function(el) {
		el = this.el(el);
		if(el) {
			el.style.display = "block";
		}
	},
	hel: function(el) {
		el = this.el(el);
		if(el) {
			el.style.display = "none";
		}
	},
	getTopDocument : function() {
		var pw = this.getTopWindow();
		if(this.isFrame(pw)) {
			pw = this.getTopWindowNotFrame(window)
		}
		return pw.document;
	},
	isFrame : function(win){
		return win.document.body.tagName == "FRAMESET";
	},
	getTopWindowNotFrame : function(win){
		var cur = win;
		var par = win.parent;
		if (cur == win || par.document.body.tagName == "FRAMESET"){
			return cur;
		}else{
			this.getTopWindowNotFrame(win);
		}
	},
	getTopWindow : function() {
		var pw = window;
		while (pw != pw.parent) {
			pw = pw.parent;
		}
		return pw;
	},
	showBodySrollbar : function(b,doc) {
		doc = doc?doc:document;
		var temp_h1 = doc.body.clientHeight;
		var temp_h2 = doc.documentElement.clientHeight;
		var isXhtml = (temp_h2<=temp_h1&&temp_h2!=0)?true:false; 
		var htmlbody = isXhtml?doc.documentElement:doc.body;
		
		if(b === false) {
			htmlbody.style.overflow = "hidden";
		}
		else 
			htmlbody.style.overflow = "auto";
	},
	createIPAddress : function(param) {
		var ip = createIPCom({
			imgPath : param.imgPath,
			ipName : param.ipName,
			hasPort : param.hasPort,
			add : param.add,
			index : param.container.children().length,
			count : param.count,
			isRequired:param.isRequired
		});
		param.container.append(ip);
	},
	createIPDouble : function(param) {
		var cp = createIPDouble({
			imgPath : param.imgPath,
			firstName : param.firstName,
			secondName : param.secondName,
			hasPort : param.hasPort,
			add : param.add,
			index : param.container.children().length,
			type : param.type,
			count : param.count
		});
		param.container.append(cp);
	},
	addAllNode:function(node)
	{
		if(!node.leaf && node.children!=null)
		{
			var allNode = {
				title: "All",
				tooltip: "This folder and all child nodes were added programmatically.",
				type : "all",
				level : 1+node.level	
			};
			var strArr = new Array();
			strArr.push(allNode);
			for(var i=0;i<node.children.length;i++)
			{
				strArr.push(node.children[i]);
				this.addAllNode(strArr[i+1]);
			}
			node.children = strArr;
		}
	},
	
	createTree : function(param){
		var selMode = {
			"single" : 1,
			"multi" : 2,
			"multi-hier" : 3,
			"multi-hier-all" : 2};
		var m = param.minExpandLevel;
		if("multi-hier-all" == param.selectMode)
		{
			var strArr = new Array();
			for(var i=0;i<param.data.length;i++)
			{
				this.addAllNode(param.data[i]);
			}
		}
		if (isNaN(m)){
			m = "";
		}
		jQuery("#" + param.treeId, param.doc).dynatree({
			checkbox: ConditionUtils.isTrue(param.checkbox),
			selectMode: selMode[param.selectMode],
			children: param.data,
			minExpandLevel : m,
			rootVisible: false,
			onActivate: function(dtnode){
			},
			onSelect: function(flag, dtnode) {
				if (flag)
				{
					dtnode.activate();
				}
				if(dtnode.data.type=="all")
				{
					for(var i=0;i<dtnode.parent.childList.length;i++)
					{
						dtnode.parent.childList[i].select(flag);
					}
				}
			},
			onClick: function(dtnode, event) {
				if( dtnode.getEventTargetType(event) == "title" )
				    dtnode.toggleSelect(); 
			},
			onKeydown: function(dtnode, event) {
				if( event.which == 32 ) {
					dtnode.toggleSelect();
					return false;
				}
			},
			cookieId: "ui-dynatree-Cb2",
			idPrefix: "ui-dynatree-Cb2-"
		});
	},
	getClipboardText : function (){
	    if (window.clipboardData) 
	    {
	        return (window.clipboardData.getData('text'));
	    } 
	    else 
	    {
	        if (window.netscape) 
	        {
	            try 
	            {
	                netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
	                var clip = Components.classes["@mozilla.org/widget/clipboard;1"].createInstance(Components.interfaces.nsIClipboard);
	                if (!clip) 
	                {
	                    return;
	                }
	                var trans = Components.classes["@mozilla.org/widget/transferable;1"].createInstance(Components.interfaces.nsITransferable);
	                if (!trans) 
	                {
	                    return;
	                }
	                trans.addDataFlavor("text/unicode");
	                clip.getData(trans, clip.kGlobalClipboard);
	                var str = new Object();
	                var len = new Object();
	                trans.getTransferData("text/unicode", str, len);
	            }
	            catch (e) 
	            {
	                alert("您的firefox安全限制限制您进行剪贴板操作，请打开'about:config'将 signed.applets.codebase_principal_support'设置为true'之后重试，相对路径为firefox根目录 /greprefs/all.js");
	                return null;
	            }
	            if (str) 
	            {
	                if (Components.interfaces.nsISupportsWString) 
	                {
	                    str = str.value.QueryInterface(Components.interfaces.nsISupportsWString);
	                } 
	                else 
	                {
	                    if (Components.interfaces.nsISupportsString) 
	                    {
	                        str = str.value.QueryInterface(Components.interfaces.nsISupportsString);
	                    } 
	                    else 
	                    {
	                        str = null;
	                    }
	                }
	            }
	            if (str) 
	            {
	                return (str.data.substring(0, len.value / 2));
	            }
	        }
	    }
    	return null;
	},
	truncationStr : function(strValue, maxLen){
		if(strValue)
		{
			var num = strValue.length; 
			if(num > maxLen)
			{
				strValue = strValue.substr(0, maxLen) + '...';
			}
		}
		return strValue;
	}
}
$C = $CUtils = ConditionUtils;

var StringBuffer = function() {
	this._strings = [];
	if (arguments && arguments.length > 0){
		for (var i = 0; i < arguments.length; ++i){
			this._strings.push(arguments[i]);
		}
	}
}
StringBuffer.prototype.append = function(str) {
	this._strings.push(str);
	return this;
}
StringBuffer.prototype.toString = function() {
	return this._strings.join("");
}

Array.prototype.remove = function(s) {
	for (var i = 0; i < this.length; i++) {
		if (s == this[i]) {
			this.splice(i, 1);
		}
	}
}



var DragHandler = {
	
	init : function(h, ds, doc) {
		doc = doc?doc:document;
		h = typeof h=='string'?jQuery("#" + h, doc):jQuery(h, doc);
		ds = typeof ds=='string'?jQuery("#" + ds, doc):jQuery(ds, doc)
		h.dragSource = ds;
		if (isNaN(ds.css("left"))) ds.css("left", "0px");
		if (isNaN(ds.css("top"))) ds.css("top", "0px");
		h.bind("mousedown", h,  this.start);
	},
	
	start : function(e) {
		var h = e.data;
		var ds = h.dragSource;
		var _div = jQuery(ds).find(".cbb-dialog-body");
		_div.css("background-color", "#D7E3F2");
		_div.find(">div:first").hide();
		
		var top = ds.position().top;
		var left = ds.position().left;

		h.lastMouseX = e.pageX;
		h.lastMouseY = e.pageY;
		
		jQuery(h.context).bind("mousemove", h, DragHandler.drag);
		jQuery(h.context).bind("mouseup", h, DragHandler.end);
		return false;
	},
	
	drag : function(e) {
		var h = e.data;
		var ds = h.dragSource;
		
		var mouseY = e.pageY;
		var mouseX = e.pageX;
		
		var top = ds.position().top;
		var left = ds.position().left;

		if (jQuery.browser.msie) {	
			ds.get(0).setCapture();
		} else {
			e.preventDefault();
		};
		
		ds.css("left", left + mouseX - h.lastMouseX);
		ds.css("top", top + mouseY - h.lastMouseY);
		h.lastMouseX = mouseX;
		h.lastMouseY = mouseY;

		return false;
	},
	end : function(e) {
		var h = e.data;
		if (jQuery.browser.msie) {	
			h.dragSource.get(0).releaseCapture();
		} else {
			e.preventDefault();
		};
		jQuery(h.context).unbind("mousemove");
		jQuery(h.context).unbind("mouseup");
		var ds = h.dragSource;
		var _div = jQuery(ds).find(".cbb-dialog-body");
		_div.css("background-color", "#FFFFFF");
		_div.find(">div:first").show();
	}
};


var CBB_Dialog = CBB_Dialog;
if(CBB_Dialog == undefined) {

	CBB_Dialog = function (c) {
		
		this.$RRS = c.RRS;

		this.jContainer = null;
		this._doc = null;
		this.jContentFrame = null;
		this.isRendered = false;			
		
		this.isShow = false;
		this.jBody = null;
		this.jBtnBar = null;
		this.jBtnOk = null;
		this.jBtnClose = null;
		
		if(!CBB_Dialog.prototype._initialized) {
			var p =  CBB_Dialog.prototype;
			p.ID_SEED = new Date().getTime();
			
			p.initProperties = function(config) {
				var cfg = jQuery.extend({
					id: "cbb-dialog-" + p.ID_SEED ++,
					title: "iReport CBB Dialog",
					width: 400,
					height: 300,
					url:"",
					contentHtml:"&nbsp;",
					iconClass: "", 
					top:0,
					left: 0
				}, config?config:{});
				jQuery.extend(this, cfg);
				this.c = cfg;
				
				var w = parseInt(this.width);
				var h = parseInt(this.height);
				this.width = isNaN(w)?400:w;
				this.height = isNaN(h)?300:h;
			}
			
			p.show = function() {
				
				if(this.isRendered == true) {			
					this.showMask();
					this.jContainer.show();
					this.isShow = true;
					return ;
				}
				
				var thisObj = this;
				this._doc = $CUtils.getTopDocument();
				
				this.getContainer().html(this.createDialogHtml());	
				
				this.initDialogObjs(); 
				this.setDialogContent();	
                jQuery("#close_"+this.id, this._doc).bind("click", function(event){
                    thisObj.close();
                });
			
				DragHandler.init("cbb-dialog-title-" + this.id , "dialogContainer_" + this.id, this._doc);
				
				this.setPosition();
				
				this.showMask();
				
				this.jContainer.show();
				
				this.jBtnOk.focus();	
				
				this.isRendered = true;
				
				$CUtils.showBodySrollbar(false, this._doc);
				
				this.isShow = true;
			}
			
			p.initDialogObjs = function() {
				this.jTitle = jQuery("#cbb-dialog-title-" + this.id, this._doc).css({
					width: this.width + "px"
				});
				this.jBody = jQuery("#dialogBody_" + this.id, this._doc);
				this.jBody.css({
					height: this.height + "px",
					width: (this.width) + "px"
				});
				this.jBottom = jQuery("#cbb-dialog-bottom-" + this.id, this._doc).css("width", this.width + "px");
				
				this.jBtnBar = jQuery("#btnBar_" + this.id, this._doc).css({
					width: "auto"
				});
				
				this.jBtnOk = jQuery("#btnOk_" + this.id, this._doc);
				this.jBtnClose = jQuery("#btnCancel_" + this.id, this._doc)
				
				this.jBtnClose.bind("click", {dialog:this,btn:"CLOSE"}, this._btnHandler);
				this.jBtnOk.bind("click", {dialog:this,btn:"OK"}, this._btnHandler);
			}
			
			p._btnHandler = function(event) {
				var dialog = event.data.dialog;
				var btn = event.data.btn;
				if(dialog.beforeClose) {
					if(dialog.beforeClose(btn, dialog)) {				
						dialog.close();
						if(dialog.afterClose) dialog.afterClose(btn, dialog)	
					} 
				}
				else {
					dialog.close();
					if(dialog.afterClose) dialog.afterClose(btn, dialog)	
				}
			}
	
			p.setDialogContent = function() {
				if (this.contentHtml) {
					this.jBody.html(this.contentHtml);
				} 
				else if (this.url) {	
					this.jContentFrame = jQuery("<iframe src='" + this.url + "' id='contentIframe_" + this.id + "' allowTransparency='true'  width='100%' height='100%' frameborder='0' style='background-color: #transparent; border:none;'></iframe>", this._doc);
					this.jBody.append(this.jContentFrame);
					this.jContentFrame.dialogInstance = this;
				}
			}
			
			p.createDialogHtml = function() {
					
				var arr = [];
				arr.push("<div class='cbb-dialog-wrap'>");
                arr.push('<div class="x-window-tl" style="text-align:left"><div class="x-window-tr"><div class="x-window-tc"><div class="x-window-header x-unselectable x-window-draggable" id="cbb-dialog-title-' +this.id+ '" style="-moz-user-select: none;"><div style="float:right;width:15px;">&nbsp;</div><div class="x-tool x-tool-close" id="close_' +this.id+ '">&nbsp;</div><div class="x-tool x-tool-help" style="margin-top:0px" id="help'+this.id+'">&nbsp;</div><span class="x-window-header-text">' +this.title+'</span></div></div></div></div>');
				arr.push("  	<div id='bodyWrap_" +this.id+"' class='cbb-dialog-bwrap' style='border-left:1px solid;border-right:1px solid;border-bottom:1px solid'>");
                arr.push("          <div>");
                arr.push("          <div>");
                arr.push("                   <div>");
                arr.push("              <div>");
                arr.push("                      <div>");
				arr.push("    					<div class='cbb-dialog-body' id='dialogBody_" + this.id + "' >");
				arr.push("        				</div>");
				arr.push("        			</div>");
				arr.push("        		</div>");
				arr.push("        	</div>");
				arr.push("		</div>");
                arr.push("    <div>");
                arr.push("      <div>");
                arr.push("          <div>");
                arr.push("          <div>");
				arr.push("        		<div class='cbb-dialog-bc' id='cbb-dialog-bottom-" + this.id + "'>");
				arr.push("            		<div id='btnBar_" + this.id + "'  class='cbb-dialog-btnbar'>");
                arr.push('<div style="float:right;width:15px;">&nbsp;</div>');
                arr.push('<div style="float:right"><table cellspacing="0" cellpadding="0" border="0" class="x-btn-wrap x-btn " id="btn_values_gridTrigger"><tbody><tr><td class="x-btn-left" style="padding: 0pt;"><i> </i></td><td class="x-btn-center" style="padding: 2px 8px; min-width: 40px;"><em unselectable="on"><button onclick="return false;" value="OK" id="btnCancel_'+this.id+'" type="button" class="x-btn-text x-button-click">取消</button> </em></td><td class="x-btn-right" style="padding: 0pt;"><i> </i></td></tr></tbody></table></div>');
                arr.push('<div style="float:right"><table cellspacing="0" cellpadding="0" border="0" class="x-btn-wrap x-btn " id="btn_values_gridTrigger"><tbody><tr><td class="x-btn-left" style="padding: 0pt;"><i> </i></td><td class="x-btn-center" style="padding: 2px 8px; min-width: 40px;"><em unselectable="on"><button onclick="return false;" value="OK" id="btnOk_'+this.id+'" type="button" class="x-btn-text x-button-click">确定</button> </em></td><td class="x-btn-right" style="padding: 0pt;"><i> </i></td></tr></tbody></table></div>');
				arr.push("            		</div>");
				arr.push("        		</div>");
				arr.push("    		</div>");
				arr.push("		</div>");
				arr.push("		<a href='#' onfocus='$CUtils.el(\"_forTab_" + this.id + "\").focus();'></a>");
				arr.push("	</div>");
				
				return arr.join("\n");
			}
			
			p.getContainer = function() {
				if(this.jContainer == null){
					var containerId="dialogContainer_" + this.id;
					$("#"+containerId,this._doc).remove();
					
					this.jContainer = jQuery("<div />", this._doc.body).attr("id", containerId).addClass("cbb-dialog-container").hide().appendTo(this._doc.body);
					this.jContainer.dialogInstance = this;	
					this.jContainer.css("width", (this.width + 12) + "px");
				}
				return this.jContainer;
			}
			
			p.close = function() {
	
				this.getContainer().hide(); 
				this.closeMask();
				
				$CUtils.showBodySrollbar(true, this._doc);
				
				this.isShow = false;
				
			}
			
			p.getOwnerDoc = function() {
				if(this._doc) return this._doc;
				this._doc = $CUtils.getTopDocument();
				return this._doc;
			}
			
			p.setPosition = function() {
				var doc = this._doc;
				var cw = doc.compatMode == "BackCompat"
						? doc.body.clientWidth
						: doc.documentElement.clientWidth;
				var ch = doc.compatMode == "BackCompat"
						? doc.body.clientHeight
						: doc.documentElement.clientHeight;
						
				var sl = Math.max(doc.documentElement.scrollLeft, doc.body.scrollLeft);
				var st = Math.max(doc.documentElement.scrollTop, doc.body.scrollTop);
				var sw = Math.max(doc.documentElement.scrollWidth, doc.body.scrollWidth);
				var sh = Math.max(doc.documentElement.scrollHeight, doc.body.scrollHeight);
				
				sw = Math.max(sw, cw);
				sh = Math.max(sh, ch);
                this.top = 70;
				this.left = (cw - this.width - 12) / 2 + sl;
				if (this.showBtuttons) {
					this.top -= 18;
				}
				
				this.getContainer().css({
					top:this.top + "px",
					left:this.left + "px"
				});
			}
			
			p.setSize = function(w,h) {
				if(w) {
					this.jContainer.css("width", (w+2) + "px");
					this.jTitle.css("width", (w - 10) + "px");
                    var tw = jQuery("div.cbb-dialog-wrap").find("div:first").width();
                    this.jBody.css("width", (w)+"px");
					this.jBottom.css("width", (w) + "px");
					this.width = w;
				}
				if(h) {
					this.jBody.css("height", h + "px");
					this.height = h;
				}
				if(w | h) 
					this.setPosition();
			}
			p.addButton = function(id, txt, func) {
			}
	
			p.destory = function() {
				if(this.jContainer) {
					this.jContainer.remove();
				}
				var el = $CUtils.el("mask_"+ this.id, this._doc);
				if(el) {
					$(el).remove();
				}
			}
	
			p.showMask = function() {
				var pdoc = this._doc;
				var el = $CUtils.el("mask_"+ this.id, this._doc);
				if(!el) {
					var maskId="mask_" + this.id;
					$("#"+maskId,this._doc).remove();
					var maskBox = jQuery("<div class='cbb-dialog-mask' id='"+ maskId +"' onselectstart='return false;'></div>", pdoc);
					maskBox.html('<div  style="position:absolute; filter:alpha(opacity=1);width:100%;height:100%;"></div><iframe src="about:blank" style="filter:alpha(opacity=1);" width="100%" height="100%" frameborder="0"></iframe>');
					jQuery(pdoc.body).append(maskBox);
					el = $CUtils.el("mask_"+ this.id, pdoc);
				}
				var h = jQuery(pdoc).height();
				var w = jQuery(pdoc).width();
				
				el.style.height =  h + "px";
				el.style.width = w + "px";
				$CUtils.sel(el);
			}
			
			p.closeMask = function() {
				var el = $CUtils.el("mask_"+ this.id, this._doc);
				if(el) {
					$CUtils.hel(el)
				}
			}
			
			CBB_Dialog.prototype._initialized = true;
		}
		
		this.initProperties(c);
		CBB_DialogMgr.add(this);
	}
}
var CBB_DialogMgr = CBB_DialogMgr;
if(CBB_DialogMgr == undefined) {
	var CBB_DialogMgr = {
		idSeed: 1000,
		dialogArr: [],
		dialogMap: {},
		close: function() {
			for(var i = 0 ; i < this.dialogArr.length ; i++) {
				if(this.dialogArr[i]) {
					this.dialogArr[i].close();
				}
			}
		},
		get: function(dialogId) {
			return this.dialogMap[dialogId];
		},
		add: function(dialog) {
			this.dialogArr.push(dialog);
			this.dialogMap[dialog.ID] = dialog;
		},
		alert : function(msg, title, w, h) {
			var dialog = new IReport_CBB_Dialog({
				contentHtml: msg,
				title: title?title: "系统提示",
				width: w ? w : 300,
				height: h ? h : 120
			});
			dialog.AlertFlag = true;
			dialog.show();
			dialog.okBtn.hide();
			dialog.closeBtn.value = "确 定";
			dialog.closeBtn.focus();
			dialog.btnBar.css("textAlign","center");
		},
		confirm: function(msg, title, fn, w, h){
			var dialog = new IReport_CBB_Dialog({
				contentHtml: msg,
				title: title?title: "信息确认",
				width: w ? w : 300,
				height: h ? h : 120,
				afterClose : fn
			});
			dialog.show();
			dialog.okBtn.focus();
			dialog.btnBar.css("textAlign","center");
		},
		setPosition: function(event) {
			var thisObj = event.data;
			for(var i = 0 ; i < thisObj.dialogArr.length ; i++) {
				if(thisObj.dialogArr[i] && thisObj.dialogArr[i].isShow) {
					thisObj.dialogArr[i].setPosition();
				}
			}
		},
		onKeyDown : function(event) {
			var CBB_DialogMgr = event.data;
			if (event.shiftKey && event.keyCode == 9) {
				var len = CBB_DialogMgr.dialogArr.length;
				if(len > 0) {
					CBB_DialogMgr.dialogArr[len - 1].close();
					return false;
				}
			}
			if (event.keyCode == 27) {
				jQuery.each(CBB_DialogMgr.dialogArr, function(i, d) {
					if(d.isShow == true) {
						d.close();
					}
				})
			}
		},
		destory : function(dialogId) {
			if(dialogId) {
				this.dialogArr.remove(this.dialogMap[dialogId]);
				this.dialogMap[dialogId].destory();
				delete this.dialogMap[dialogId];
			} else {
				for(var i = 0 ; i < this.dialogArr.length ; i++) {
					this.destory(this.dialogArr[i].id)
				}
			}
		}
	}
	
	jQuery($CUtils.getTopDocument()).bind("keydown",CBB_DialogMgr,CBB_DialogMgr.onKeyDown);
	jQuery($CUtils.getTopWindow()).bind("resize", CBB_DialogMgr, CBB_DialogMgr.setPosition);
}




 function loadResource(resourceMgr)
 {
     jQuery.ajax({
        url : WEB_ROOT_ABS_PATH+"/atic/ireport/resourceProcessAction.do",
        type : "POST",
        async : false,
        dataType : "json",
        data : "cfNameHF="+cfNameHF,
        success : function(result, textStatus) {
            if (resourceMgr && resourceMgr.resourceMap)
            {
                jQuery.extend(resourceMgr.resourceMap, result.data); 
                window.top["_IREPORT_RESOURCEMGR"]=JSON.stringify(resourceMgr.resourceMap);
            }
        },
        error : function(XMLHttpRequest, textStatus, errorThrown) {
        },
        complete : function(XMLHttpRequest, textStatus) {
        }
    });
 }

var ResourceMgr = {
    resourceMap : {},
    add: function(key, value) {
        this.resourceMap[key] = value;
    },
    get : function(key) {
       var str = this.resourceMap[key];
       if (str){
        return str;
       }else{
        loadResource(this);
        str = this.resourceMap[key];
        if (str)
        {
            return str;
        }
       }
       return  key;
    }
}

if (window.top["_IREPORT_RESOURCEMGR"])
{
    jQuery.extend(ResourceMgr.resourceMap, JSON.parse(window.top["_IREPORT_RESOURCEMGR"]));
}else {
    loadResource(ResourceMgr);
}