	getWeekOfYear = function(date) {
        var ms1d = 864e5;     
        var ms7d = 7 * ms1d;     
        var DC3 = Date.UTC(date.getFullYear(), date.getMonth(), date.getDate() + 3) / ms1d;     
        var AWN = Math.floor(DC3 / 7);     
        var Wyr = new Date(AWN * ms7d).getUTCFullYear();
    return AWN - Math.floor(Date.UTC(Wyr, 0, 7) / ms7d) + 1;
	};
	
	toStringByPattern = function(date,pattern) 
	{   
        var month = date.getMonth()+1;
        var day = date.getDate();
        var hour = date.getHours();
        var minute = date.getMinutes();
        var second = date.getSeconds();
        patternpattern = pattern.replace(/yyyy/g, date.getFullYear());   
        patternpattern = patternpattern.replace(/MM/g, month>9?month:'0'+month); 
        patternpattern = patternpattern.replace(/dd/g, day>9?day:'0'+day);   
        patternpattern = patternpattern.replace(/HH/g, hour>9?hour:'0'+hour);   
        patternpattern = patternpattern.replace(/mm/g, minute>9?minute:'0'+minute);   
        patternpattern = patternpattern.replace(/ss/g, second>9?second:'0'+second);   
        return patternpattern;   
    }   ;
    
    getDateConfig = function(source)
    {
    	var returnVal = "";
    	var array = [];
    	if(source.dateFmt!==undefined)
		{
			array.push("dateFmt:\'"+source.dateFmt+"\'");
		}
		if(source.autoUpdate!==undefined)
		{
			array.push("autoUpdateOnChanged:"+source.autoUpdate);
		}
		if(source.readOnly!==undefined)
		{
			array.push("readOnly:"+source.readOnly);
		}
		if(source.isShowWeek!==undefined)
		{
			array.push("isShowWeek:"+source.isShowWeek);
		}
		if(source.qsEnabled!==undefined)
		{
			array.push("qsEnabled:"+source.qsEnabled);
		}
		if(source.minDate!==undefined && new Number(source.minDate)>=Date_const.minDate)
		{
			array.push("minDate:'"+source.minDate+"-01-01 00:00:00'");
		}
		if(source.maxDate!==undefined  && new Number(source.maxDate)<=Date_const.maxDate)
		{
			array.push("maxDate:'"+source.maxDate+"-12-31 23:59:59'");
		}
		for(var i=0;i<array.length;i++)
		{
			returnVal = returnVal+array[i];
			if(i!=array.length-1)
			{
				returnVal = returnVal + ",";
			}
		}
		return returnVal;
    };
    
    getLongTimeByFmt = function(dateStr)
    {
    	var str = removeAllSpace(dateStr);
    	var lengths = str.length;
    	var returnVal = 0;
    	var year = 0;
    	var month = 1;
    	var day = 1;
    	var hour = 0;
    	var minute = 0;
    	var mm = 0;
    	if(lengths>=4)
    	{
    		year =  str.substr(0,4);
    	}
    	if(lengths>=6)
    	{
    		if(str.charAt(5)==="0")
    		{
    			month = new Number(str.substr(6,1))-1;
    		}
    		else
    		{
    			month = new Number(str.substr(5,2))-1;
    		}
    		
    	}
		if(lengths >= 10)
		{
			day = str.substr(8,2);
		}  
		if(lengths >= 12)
		{
			hour = str.substr(10,2);
		}  
		if(lengths >= 15)
		{
			minute = str.substr(13,2);
		}  
		if(lengths >= 18)
		{
			mm = str.substr(16,2);
		}
		return new Date(year,month,day,hour,minute,mm).getTime()/1000;
    };
    
    function removeAllSpace(str){   
        var localString = '';   
        for(var index = 0; index<str.length; index++)   
            if(str.charCodeAt(index)!= 32){   
                localString += str.charAt(index);   
            };   
    	return localString;   
    } 
    
    function isCorrectFormat(format,context)
    {
    	var reg = "";
    	var returnVal = true;
    	
    	if(format.toUpperCase()=="YYYY-MM-DD HH:MM:SS")
    	{
    		reg = /^(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2}):(\d{2})$/;
    	}else if(format.toUpperCase()=="YYYY-MM-DD HH:MM")
    	{
    		reg = /^(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2})$/; 
    	}else if(format.toUpperCase()=="YYYY-MM-DD HH")
    	{
    		reg = /^(\d{4})-(\d{2})-(\d{2}) (\d{2})$/; 
    	}else if(format.toUpperCase()=="YYYY-MM-DD")
    	{
    		reg = /^(\d{4})-(\d{2})-(\d{2})$/; 
    	}else if(format.toUpperCase()=="YYYY-MM")
    	{
    		reg = /^(\d{4})-(\d{2})$/; 
    	}
    	
    	if(!reg.test(context))
    	{
    		returnVal = false;
    		return returnVal;
    	}
    	
    	var v = getLongTimeByFmt(context);
    	var numReg = /^[\d]+$/ 
    	if(!numReg.test(v))
    	{
    		returnVal = false;
    	}
    	
        return returnVal;   
    }

