function createIPCom(param) {
		var len = 4;
		var tr = $("<tr></tr>");
		tr.data("ids", {
			ipName : param.ipName,
			portId : param.ipName + '_port'
		});
		createIpField(tr, param.ipName, "ip");
		if (param.hasPort){
			createPort(tr, param.ipName + '_port');
		}
		if (param.add && param.index > 0){
			var _a_del = $('<a id="' + param.ipName + param.count+ '" style="cursor: pointer;" title="删除">&nbsp;<img src="'+param.imgPath+'/images/delete.png" width="16" height="16"></a>');
			_a_del.bind("click", function(){
				if (tr.index() > 0){
					tr.remove();
				}
			});
			tr.append($('<td width="100%" valign="bottom"></td>').append(_a_del));
		}
		return tr;
}

function createIPDouble(param) {
		var tr = $("<tr></tr>");
		tr.data("ids", {
			firstName : param.firstName,
			secondName : param.secondName,
			portId : param.firstName + '_port'
		});
		createIpField(tr, param.firstName, "ip");
		tr.append("<td class='ip_fldDot'>/</td>");
		if (param.type === "IPMASK"){
			createIpField(tr, param.secondName, "mask");
		}
		if (param.hasPort){
			createPort(tr, param.firstName + "_port");
		}
		
		if (param.add && param.index > 0){
			var _a_del = $('<a id="' + param.firstName + param.count+ '" style="cursor: pointer;"><img src="'+param.imgPath+'/images/delete.png" width="16" height="16"></a>');
			_a_del.bind("click", function(){
				if (tr.index() > 0){
					tr.remove();
				}
			});
			tr.append($('<td width="100%" valign="bottom"></td>').append(_a_del));
		}
		return tr;
}

function createPort(tr, _id){
	tr.append("<td style='padding-left:5px;padding-right:2px'>:</td>");
	var td = $("<td nowrap></td>");
	var _portInput = $('<input/>',{
		id:_id,
	 	maxlength:5
	}).addClass("input_text").css("width", "45px");
	
	var _expr = /\D/g;
	_portInput.bind("keydown keyup paste",{expr:_expr, max:65535, min:1}, function(event) {
					if (event.data.expr.test(this.value)) {
						this.value = this.value.replace(_expr, "");
					}
					if (this.value>event.data.max){
						this.value = event.data.max;
					}
					if (this.value != '' && this.value < event.data.min){
						this.value = event.data.min;
					}
				});
	td.append(_portInput);
	td.append('<label class="cbb-port-tip">[1-65535]</label>');
	tr.append(td);
}

function createIpField(tr, name, type){
	var len = 4;
	var _row = jQuery("<tr/>");
	for (var i = 0; i < len; ++i) {
		var _td = $("<td class='ip_fld'></td>");
		var _text = $("<input/>", {
					size : 3,
					maxlength : 3,
					name : name,
					id : name + (i + 1)
				}).addClass("cbb-ip-input");
		_text.bind("paste", {appType:type}, doPaste);		
		_text.bind("keydown", {appType:type}, onIpFieldKeyDown);
		_text.bind("keyup", {appType:type}, onIpFieldKeyUp);
		_text.bind("blur", {appType:type}, doOnblur);
		_text.data("name", name);
		_text.appendTo(_td);
		_td.appendTo(_row);
		if (i < (len - 1)) {
			$("<td class='ip_fldDot'>.</td>").appendTo(_row);
		}
	}
	
	var td = jQuery("<td/>");
	var tab = jQuery("<table/>", {
		align : 'left',
		cellspacing : '0',
		cellpadding : '0'
	}).addClass("cbb-ip-table");
	td.append(tab.append(_row)).appendTo(tr);
}


var IPCOM_Constant = {
	appType:{
	    IP:'ip',			
	    MASK:'mask',		
        IP_EXP:'ip_exp'		
	},
    eventType:{
    	BLUREV:'blurEvent',		
    	KEYUPEV:'keyUpEvent',	
    	TABEV:'tabEvent'		
    },
    returnType:{
    	NOTINPUT:null,						
    	NOTCOMPLETE:'',						
    	FORMATERROR:'formatError',			
    	FORMATERROR_EXP:'formatError_exp'	
    }
}


function doOnblur(event) {
	var appType = event.data.appType;
    var srcObj = event.target;
    
	if(srcObj.pasteStrOld != null) {
		window.clipboardData.setData('text', srcObj.pasteStrOld);
		srcObj.pasteStrOld = null;
	}
	feildValue_CheckObj(srcObj,IPCOM_Constant.eventType.BLUREV, appType);
}


function doPaste (event) {
	var tr = $(event.target).parentsUntil("tr").parent();
	var name = $(event.target).data("name");
	var fieldArr = tr.find(":text[name="+name+"]");
	
    var valueArr = [];
    $.each(fieldArr, function(i, _f){
    	valueArr.push(_f.value);
        _f.value = "";
    });
	var data = ConditionUtils.getClipboardText();
	if(data){
		var ipDataArr =  data.split(".");
		var reg = /\D/g;
		
		var flag = true;
		$.each(ipDataArr, function(i, v){
			if(reg.test(v)){
				flag = false;
				return false;
			}
		});
		
		if (!flag){
			$.each(fieldArr, function(i, _f){
				$(_f).val(valueArr[i]);
			});
			alert("Format Error:xxx.xxx.xxx.xxx");
			return false;
		}
		
		$.each(fieldArr, function(i, _f){
			$(_f).val(ipDataArr[i]);
		});	
	}
	return false;
}

function fieldObj(preObj,value) {
    this.preObj = preObj;
    this.value = value;
    
    this.valueOfInt = function () {
        if(this.value.charAt(0) == '0') {
            if(this.value.charAt(1) == '0'){
                return parseInt(this.value);
            } else {
                if(this.value.length > 1)
                    return parseInt(this.value.substring(1));
                else return 0;
            }
        } else {
            return parseInt(this.value);
        }
    };
    
    this.validateMask = function () {
        var value_int = this.valueOfInt();
        var preObj = this.preObj;
        
        if(preObj != null) {
            if(preObj.valueOfInt() == 255) {            
                if(this.checkV() || value_int == 0 || value_int == 255)  return true;  
                    else return false;
            } else if(preObj.checkV()) {                               
                if(value_int == 0) return true;      
                    else return false;
            } else if(preObj.valueOfInt() == 0) {     
                if(value_int == 0) return true;      
                    else return false;
            } else {
                return false;
            }
        } else {
            if(value_int == 255 || this.checkV()) return true;
                else return false;
        }
        return false;
    };
    this.validateIp = function () {
    };
    this.checkV = function () {
        var v = this.valueOfInt();
        if((v == 254) || (v == 252) || (v == 248) || (v == 240) || (v == 224) || (v == 192) || (v == 128)) return true;
            else return false;
        
    };
}


function getIpStr(ipComId, type, valueOnly) {
	var fieldArr = getFieldArr(ipComId);

	var field_1 = fieldArr[0].value;
	var field_2 = fieldArr[1].value;
	var field_3 = fieldArr[2].value;
	var field_4 = fieldArr[3].value;

	if (field_1 == "" && field_2 == "" && field_3 == "" && field_4 == "") {
		return IPCOM_Constant.returnType.NOTINPUT;
	}
	else if (field_1 == "" || field_2 == "" || field_3 == "" || field_4 == "") {
		var objTemp = null;
		if(field_1 == '') objTemp = fieldArr[0];
		else if(field_2 == '') objTemp = fieldArr[1];
		else if(field_3 == '') objTemp = fieldArr[2];
		else if(field_4 == '') objTemp = fieldArr[3];
		if(valueOnly != 'valueOnly') {
			objTemp.select();
		}
		return IPCOM_Constant.returnType.NOTCOMPLETE;
	}

	var fieldObj_1 = new fieldObj(null,field_1);
	var fieldObj_2 = new fieldObj(fieldObj_1,field_2);
	var fieldObj_3 = new fieldObj(fieldObj_2,field_3);
	var fieldObj_4 = new fieldObj(fieldObj_3,field_4);
	
	if (type == IPCOM_Constant.appType.MASK) {
		if(!(fieldObj_1.validateMask() && fieldObj_2.validateMask() && fieldObj_3.validateMask() && fieldObj_4.validateMask())) {
		    var objTemp = null;
		    
		    if(!fieldObj_1.validateMask()) objTemp = fieldArr[0];
		    else if(!fieldObj_2.validateMask()) objTemp = fieldArr[1];
		    else if(!fieldObj_3.validateMask()) objTemp = fieldArr[2];
		    else if(!fieldObj_4.validateMask()) objTemp = fieldArr[3];
		    
		    if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
		    return IPCOM_Constant.returnType.FORMATERROR;
		}
	} else if(type == IPCOM_Constant.appType.IP_EXP) {
		var objTemp = null;
		if(fieldObj_1.valueOfInt() == 0) {
			if(fieldObj_2.valueOfInt() != 0 || fieldObj_3.valueOfInt() != 0 || fieldObj_4.valueOfInt() != 0) {
				if(valueOnly != 'valueOnly') {
					fieldArr[0].select();
				}
				return IPCOM_Constant.returnType.FORMATERROR_EXP;
			}
		} else if(fieldObj_1.valueOfInt() > 223) {
			objTemp = fieldArr[0];
		} else if(fieldObj_2.valueOfInt() > 255) {
            objTemp = fieldArr[1];
        } else if(fieldObj_3.valueOfInt() > 255) {
            objTemp = fieldArr[2];
        } else if(fieldObj_4.valueOfInt() > 255) {
            objTemp = fieldArr[3];
        } 
        if (objTemp != null) {
        	if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
        	return IPCOM_Constant.returnType.FORMATERROR_EXP;
        }
	} else{
		var objTemp = null;
		if (fieldObj_1.valueOfInt() == 0 || fieldObj_1.valueOfInt() > 223) {
			objTemp = fieldArr[0];
			if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
			return IPCOM_Constant.returnType.FORMATERROR;
		}
		else if (fieldObj_2.valueOfInt() > 255)
			objTemp = fieldArr[1];
		else if (fieldObj_3.valueOfInt() > 255)
			objTemp = fieldArr[2];
		else if (fieldObj_4.valueOfInt() > 255)
			objTemp = fieldArr[3];
		if (objTemp != null) {
			if(valueOnly != 'valueOnly') {
				objTemp.select();
			}
			return IPCOM_Constant.returnType.FORMATERROR;
		}
	}
	var ipString = fieldObj_1.valueOfInt() + "." + fieldObj_2.valueOfInt() + "." + fieldObj_3.valueOfInt() + "." + fieldObj_4.valueOfInt();
	return ipString;
}


function setIpValue(ipStr, ipComId) {
	if (!isIpStr(ipStr)) {
		return false;
	}

	var fieldArr = getFieldArr(ipComId);

	var ipStrArr = ipStr.split(".");

	fieldArr[0].value = ipStrArr[0];
	fieldArr[1].value = ipStrArr[1];
	fieldArr[2].value = ipStrArr[2];
	fieldArr[3].value = ipStrArr[3];
}

function feildValue_CheckObj(srcObj,eventType, appType) {
	if(eventType != IPCOM_Constant.eventType.TABEV && eventType != IPCOM_Constant.eventType.KEYUPEV) return false;
    var index = getFieldIndex(srcObj);
    var type = appType;
    var intV = parseInt(srcObj.value);
    var isLegal = true;      
    
    if (type == IPCOM_Constant.appType.MASK) {
        if(intV > 255) {
            srcObj.value = 255;
            srcObj.select();
            isLegal =  false;
        }
    } else if(intV > 223 && index == 1) {
        srcObj.value = 223;
        srcObj.select();
        isLegal = false;
    } else if(intV > 255) {
        srcObj.value = 255;
        srcObj.select();
        isLegal = false;
    } else if (index == 1 && parseInt(srcObj.value) == 0) {
    	if(type == IPCOM_Constant.appType.IP_EXP) {
    	}
    	else {
    		srcObj.value = 1;
            srcObj.select();
            isLegal = false;
    	}
        
    } 
    
    return isLegal;
}

function onIpFieldKeyUp(event) {
	var appType = event.data.appType;
    var srcObj = event.target;
    
	var keyCode = event.keyCode;
	
	if ((keyCode >= 48 && keyCode <= 57) || (keyCode >= 96 && keyCode <= 105)) {
		if (srcObj.value.length >= 3) {
			var goNext = feildValue_CheckObj(srcObj,IPCOM_Constant.eventType.KEYUPEV, appType);
			if (getFieldIndex(srcObj) != 4 && goNext) {
				var nextField = getNextField(srcObj);
				nextField.select();
			}
		}
	}
	
	if(srcObj.pasteStrOld != null) {
		window.clipboardData.setData('text', srcObj.pasteStrOld);
		srcObj.pasteStrOld = null;
	}
}

function onIpFieldKeyDown(event) {
    var appType = event.data.appType;
	var srcObj = event.target;
	var keyCode = event.keyCode;
    
	if (keyCode == 190 || keyCode == 110) {
		if (srcObj.value != "" && !hasSelectArea(srcObj)) {
			var nextField = getNextField(srcObj);
			nextField.select();
		}
		return event.returnValue = false;
	}

	else if (keyCode == 39 || keyCode == 40) {
		var curPos = getCaret(srcObj);
		var index = getFieldIndex(srcObj);
		if (curPos == srcObj.value.length && index != 4) {
			var nextField = getNextField(srcObj);
			setCaret(nextField, 'start');
			return event.returnValue = false;
		}
	}

	else if (keyCode == 37 || keyCode == 38) {
		var curPos = getCaret(srcObj);
		var index = getFieldIndex(srcObj);
		if (curPos == 0 && index != 1) {
			var preField = getPreField(srcObj);
			setCaret(preField, 'end');
			return event.returnValue = false;
		}
	}

	else if (keyCode == 8) {
		var curPos = getCaret(srcObj);
		if (curPos == 0) {
			var preField = getPreField(srcObj);
			setCaret(preField, 'end');
			return event.returnValue = false;
		}
	}

    else if(event.keyCode == 13) {
    }
    
    else if(event.keyCode == 9) {
        if(!feildValue_CheckObj(event.target,IPCOM_Constant.eventType.TABEV, appType)) return event.returnValue = false;
    }
    
	else if ((!event.shiftKey && keyCode >= 48 && keyCode <= 57)
			|| (keyCode >= 96 && keyCode <= 105) || keyCode == 46
			|| keyCode == 8) {
		if (document.selection
				&& ((!event.shiftKey && keyCode >= 48 && keyCode <= 57) || (keyCode >= 96 && keyCode <= 105))) {
			if (document.selection.type.toLowerCase() != "text"
					|| document.selection.createRange().parentElement() != srcObj) {
				if (srcObj.value.length == 3) {
					return event.returnValue = false;
				}
			}
		}
	}

	else if (event.ctrlKey && (keyCode == 67 || keyCode == 86 || keyCode == 88)) {
		return event.returnValue = true;
	}

	else {
		return event.returnValue = false;
	}
}

function hasSelectArea(srcObj) {
	if (document.selection != undefined) {
		if (document.selection.type.toLowerCase() != "text"
				|| document.selection.createRange().parentElement() != srcObj) {
			return false;
		} else
			return true;
	} else
		return false;
}

function getNextField(obj) {
	var idPrefix = obj.name;
	var index = getFieldIndex(obj);
	var nextField = null;

	if (index == 1) {
		nextField = document.getElementById(idPrefix + 2);
	} else if (index == 2) {
		nextField = document.getElementById(idPrefix + 3);
	} else {
		nextField = document.getElementById(idPrefix + 4);
	}
	return nextField;
}

function getPreField(obj) {
	var idPrefix = obj.name;
	var index = getFieldIndex(obj);
	var preField = null;

	if (index == 4) {
		preField = document.getElementById(idPrefix + 3);
	} else if (index == 3) {
		preField = document.getElementById(idPrefix + 2);
	} else {
		preField = document.getElementById(idPrefix + 1);
	}
	return preField;
}

function getFieldIndex(obj) {
	var objId = obj.id;
	var len = objId.length;
	return objId.charAt(len - 1);
}

function isIpStr(ipStr) {
	var strArr = ipStr.split(".");

	if (strArr.length != 4) {
		return false;
	}
	for (var i = 0; i < 4; i++) {
		if (strArr[i].length > 3)
			return false;

		if (parseInt(strArr[i]) < 0 || parseInt(strArr[i]) > 255) {
			return false;
		}
	}
	return true;
}

function clearIpCom(ipComId) {
	var fieldArr = getFieldArr(ipComId);
	fieldArr[0].value = "";
	fieldArr[1].value = "";
	fieldArr[2].value = "";
	fieldArr[3].value = "";
}

function disableIpCom(ipComId, b) {
	function disableField_Ext(srcObjId,b) {
        var srcObj = document.getElementById(srcObjId);
        srcObj.disabled = b;
        if(!b) {
            srcObj.className = 'ip_input';
        } else {
            srcObj.className = 'ip_input_disabled';
        }
    }
    disableField_Ext(ipComId + '1',b);
    disableField_Ext(ipComId + '2',b);
    disableField_Ext(ipComId + '3',b);
    disableField_Ext(ipComId + '4',b);
}

function getFieldArr(ipComId) {
	var fieldArr = new Array(4);
	for (var i = 0; i < 4; i++) {
		fieldArr[i] = document.getElementById(ipComId + (i + 1));

	}
	return fieldArr;
}

function getType(ipComId) {
	return document.getElementById("H_" + ipComId).value;
}

function $Name(name) {
	return document.getElementsByName(name);
}
function setCaret(textbox, pos) {
    if (textbox.createTextRange) { 
		var r = textbox.createTextRange();
		if (pos == "start") {
			r.collapse(true);
		}
		else {
			r.collapse(false);
		}
		r.select();
	}
    else if(textbox.setSelectionRange)         
    {
        textbox.focus();
        if (pos == "start") {
            textbox.setSelectionRange(0,0);
        }
        else {
            textbox.setSelectionRange(textbox.value.length,textbox.value.length);
        }
    }
    return true;
}

function getCaret(textbox) {
    if (document.selection != undefined) {              
    	textbox.focus();
    	var range = document.selection.createRange();
    	range.setEndPoint('StartToStart', textbox.createTextRange());
    	return range.text.length;
    }
    else if (textbox.selectionStart || textbox.selectionStart == '0') {   
        return textbox.selectionStart;
    }
    return 0;
}

function numberOnly(event) {
	var srcObj = event.target;
	var maxnum = event.data.maxnum;
	var holdChars = event.data.holdChars;
	if(srcObj.onkeyup == null || srcObj.onkeyup == 'undefined'){ 
	    keyupHandler_num(event)
	}
	if (srcObj.oldValue == null) {
		srcObj.oldValue = srcObj.value;
	}
	srcObj.holdChars = holdChars;
	srcObj.maxnum = maxnum;
	if (srcObj.curPos == null || srcObj.curPos == -1) {
		srcObj.curPos = getCaret(srcObj);
	}
	if (event.ctrlKey && event.keyCode == 86) {
		srcObj.paste = true;
	}
	if (document.selection != undefined && srcObj.selectArea == null) {
		if (document.selection.type.toLowerCase() != "text"
				|| document.selection.createRange().parentElement() != srcObj) {
			srcObj.selectArea = false;
		} else
			srcObj.selectArea = true; 
	}
}

function keyupHandler_num(event) {
	
	var srcObj = event.target;
	var _value = srcObj.value;
	var holdChars = srcObj.holdChars; 
	var maxnum = srcObj.maxnum; 
	var curPos = srcObj.curPos; 
	var keyCode = event.keyCode;

	if (srcObj.oldValue.length <= _value.length || srcObj.paste
			|| srcObj.selectArea) {
		if (holdChars == null || holdChars == "") {
			index = _value.search(/\D/g);
			if (index != -1) {
				if(event.keyCode != 13) {
				    srcObj.value = srcObj.oldValue;
				    setCaret(srcObj, curPos);
				} else {
					srcObj.select();
				}
			}
			else if (_value.length > 1 && _value.charAt(0) == '0') {
				if(event.keyCode != 13) {
					srcObj.value = 0;
                    srcObj.select();
				} else {
					srcObj.select();
				}
			} else if (parseInt(_value) > maxnum) {
				if(event.keyCode != 13) {
					srcObj.value = maxnum;
                    srcObj.select();
				} else {
					srcObj.select();
				}
			}
		}
		else {

			var reg = new RegExp("[^" + holdChars + "0-9]", 'g');
			var result = reg.exec(_value);
			if (result != null) {
				if(event.keyCode != 13) {
					srcObj.value = srcObj.oldValue;
                    setCaret(srcObj, curPos);
				} else {
					srcObj.select();
				}
			}
		}
	}
	if(event.keyCode != 13) {
	    srcObj.oldValue = srcObj.value;
	} else {
		srcObj.oldValue = '';
	}
	srcObj.curPos = -1;
	srcObj.selectArea = null;
}