DROP TABLE IF EXISTS T_licenseconsumepolicy;
DROP TABLE IF EXISTS T_licenseconsume;
CREATE TABLE T_licenseconsume (consumeid int(11) NOT NULL auto_increment,feature varchar(256) NOT NULL,res_item varchar(256) NOT NULL,total_consume varchar(255) NOT NULL,PRIMARY KEY  (consumeid)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE T_licenseconsumepolicy (policyid int(11) NOT NULL auto_increment,res_main_type varchar(256) NOT NULL,res_sub_type varchar(255) NOT NULL,unitnum int(11) NOT NULL,unitconsume float NOT NULL,consumeid int(11) default NULL,PRIMARY KEY  (policyid)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
INSERT INTO T_licenseconsume VALUES (1,'VSMDRM','LVP2DRM05','%f9%34%27%d0%1d%c8%8c%d5');
INSERT INTO T_licenseconsumepolicy VALUES (1,'VSM','VSM',1,1,1);

DROP TABLE IF EXISTS `t_fault_severity_rule`;
CREATE TABLE `t_fault_severity_rule` (  `id` bigint(20) NOT NULL AUTO_INCREMENT, `zone_id` bigint(20) DEFAULT 0,  `severity` int(11) DEFAULT NULL,  `in_traffic_pps_status` int(11) DEFAULT NULL,  `in_traffic_pps` int(11) DEFAULT NULL,  `in_traffic_mbps_status` int(11) DEFAULT NULL,  `in_traffic_mbps` int(11) DEFAULT NULL,  `current_conn_status` int(11) DEFAULT NULL,  `current_connection` int(11) DEFAULT NULL,  `new_conn_status` int(11) DEFAULT NULL,  `new_connection` int(11) DEFAULT NULL,  `duration_status` int(11) DEFAULT NULL,  `duration` int(11) DEFAULT NULL,  `diversion_action` int(11) DEFAULT NULL,  PRIMARY KEY (`id`)) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT  INTO `t_fault_severity_rule`(`id`,`zone_id`,`severity`,`in_traffic_pps_status`,`in_traffic_pps`,`in_traffic_mbps_status`,`in_traffic_mbps`,`current_conn_status`,`current_connection`,`new_conn_status`,`new_connection`,`duration_status`,`duration`,`diversion_action`) VALUES (1,0,4,1,200000,1,500,0,10000,0,500,0,1800,1),(2,0,3,1,20000,1,50,0,5000,0,300,0,600,1),(3,0,2,1,2000,1,5,0,1000,0,100,0,360,1),(4,0,1,1,1,1,1,0,1,0,1,0,1,1);
ALTER TABLE `t_fault_severity_rule` ADD COLUMN `direction` INT(1) DEFAULT 1 AFTER `zone_id`;
INSERT INTO `t_fault_severity_rule`(`id`,`zone_id`,`direction`,`severity`,`in_traffic_pps_status`,`in_traffic_pps`,`in_traffic_mbps_status`,`in_traffic_mbps`,`current_conn_status`,`current_connection`,`new_conn_status`,`new_connection`,`duration_status`,`duration`,`diversion_action`)VALUES(5,0,2,4,1,200000,1,500,0,10000,0,500,0,1800,0),(6,0,2,3,1,20000,1,50,0,5000,0,300,0,600,0),(7,0,2,2,1,2000,1,5,0,1000,0,100,0,360,0),(8,0,2,1,1,1,1,1,0,1,0,1,0,1,0);

DROP TABLE IF EXISTS t_vsm_filter;
CREATE TABLE `t_vsm_filter` (`pkid` bigint(20) NOT NULL AUTO_INCREMENT,`filter_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,`filter_type` varchar(255) COLLATE utf8_bin DEFAULT NULL,`filter_action` int(11) DEFAULT NULL,`filter_alert` int(11) DEFAULT NULL,`filter_Id` int(11) DEFAULT NULL,PRIMARY KEY (`pkid`),`device_type` varchar(255) COLLATE utf8_bin DEFAULT NULL,`filter_mode` int(11) DEFAULT NULL) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('DNS_Amplification','UDP','5','500','1','All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('Chargen_Amplification','UDP','3',NULL,'2','All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('SNMP_Amplification','UDP','3',NULL,'3','All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('TFTP_Amplification','UDP','3',NULL,'4','All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('NTP_Amplification','UDP','3',NULL,'5','All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('NetBIOS_Amplification','UDP','3',NULL,'6','All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('SSDP_Amplification_Attack','UDP','3',NULL,'7','All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('QOTD_Amplification','UDP','3',NULL,'8','All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('Quake_Network_Protocol','UDP','3',NULL,'9','All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('Steam_Protocol_Amplification','UDP','3',NULL,'10','All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('Portmapper_Amplification','UDP','3',NULL,'11','All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('Wordpress_Amplification','HTTP','3',NULL,'12','AntiDDoS','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('Microsoft_SQL_Resolution_Service_Amplification','UDP','3',NULL,13,'All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('RIPV1_Amplification_Attack','UDP','3',NULL,14,'All','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('Sentinel_Amplification_Attack','UDP','3',NULL,15,'AntiDDoS','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('LDAP_Amplification_Attack','UDP','3',NULL,16,'AntiDDoS','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('QUIC','UDP','3',NULL,17,'AntiDDoS','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('mDNS_Amplification','UDP','3',NULL,18,'AntiDDoS','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('Memcached_Amplification','UDP','3',NULL,19,'AntiDDoS','0');
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('IPMI_Amplification_Attack','UDP','3',NULL,20,'All','0');

-- NP过滤器预置模板
CREATE TABLE `t_vsm_np_filter` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `protocol_type` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `protocol_number` int(11) DEFAULT NULL,
  `filter_action` int(11) DEFAULT NULL,
  `filter_alert` bigint(20) DEFAULT NULL,
  `filter_index` int(11) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_bin; 
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(1,'Chargen_Amplification_Attack','UDP',NULL,1,10000,1);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(2,'SNMP_Amplification_Attack','UDP',NULL,1,10000,2);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(3,'TFTP_Amplification_Attack','UDP',NULL,1,10000,3);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(4,'NTP_Amplification_Attack','UDP',NULL,1,10000,4);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(5,'NetBIOS_Amplification_Attack','UDP',NULL,1,10000,5);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(6,'SSDP_Amplification_Attack','UDP',NULL,1,10000,6);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(7,'QOTD_Amplification_Attack','UDP',NULL,1,10000,7);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(8,'Quake_Network_Protocol_Amplification_Attack','UDP',NULL,1,10000,8);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(9,'Steam_Protocol_Amplification_Attack','UDP',NULL,1,10000,9);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(10,'Portmapper_Amplification_Attack','UDP',NULL,1,10000,10);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(11,'Microsoft_SQL_Resolution_Service_Amplification_Attack','UDP',NULL,1,10000,11);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(12,'RIPV1_Amplification_Attack','UDP',NULL,1,10000,12);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(13,'Sentinel_Amplification_Attack','UDP',NULL,1,10000,13);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(14,'LDAP_Amplification_Attack','UDP',NULL,1,10000,14);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(15,'QUIC_Amplification_Attack','UDP',NULL,1,10000,15);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(16,'mDNS_Amplification_Attack','UDP',NULL,1,10000,16);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(17,'Memcached_Amplification_Attack','UDP',NULL,1,10000,17);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(18,'SYN_ACK_Attack','TCP',NULL,1,10000,18);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(19,'SYN_Large_Attack','TCP',NULL,1,10000,19);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(20,'SYN_Short_Attack','TCP',NULL,1,10000,20);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(21,'IPMI_Amplification_Attack','UDP',NULL,1,10000,21);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(22,'CoAP_Amplification_Attack','UDP',NULL,1,10000,22);

CREATE TABLE `t_vsm_np_filter_rule` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_id` bigint(20) DEFAULT NULL,
  `destination_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `destination_mask` int(11) DEFAULT NULL,
  `destination_port` varchar(255) DEFAULT NULL,
  `source_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `source_mask` int(11) DEFAULT NULL,
  `source_port` varchar(255) DEFAULT NULL,
  `packet_start_len` int(11) DEFAULT NULL,
  `packet_end_len` int(11) DEFAULT NULL,
  `tcp_flag` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_bin; 
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(1,1,NULL,NULL,NULL,19,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(2,2,NULL,NULL,NULL,161,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(3,3,NULL,NULL,NULL,69,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(4,4,NULL,NULL,NULL,123,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(5,5,NULL,NULL,NULL,137,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(6,6,NULL,NULL,NULL,1900,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(7,7,NULL,NULL,NULL,17,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(8,8,NULL,NULL,NULL,27960,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(9,9,NULL,NULL,NULL,27015,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(10,10,NULL,NULL,NULL,111,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(11,11,NULL,NULL,NULL,1434,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(12,12,NULL,NULL,NULL,520,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(13,13,NULL,NULL,NULL,5093,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(14,14,NULL,NULL,NULL,389,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(15,15,NULL,80,NULL,NULL,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(16,16,NULL,NULL,NULL,5353,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(17,17,NULL,NULL,NULL,11211,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(18,18,NULL,NULL,NULL,NULL,NULL,NULL,'syn-ack');
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(19,19,NULL,NULL,NULL,NULL,68,1500,'syn');
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(20,20,NULL,NULL,NULL,NULL,0,40,'syn');
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(21,21,NULL,NULL,NULL,623,58,65535,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(22,22,NULL,NULL,NULL,5683,256,65535,NULL);



DROP TABLE IF EXISTS t_atic_logholdtime;
CREATE TABLE `t_atic_logholdtime` (`pkid` int(11) NOT NULL,`hold_time` int(11) default NULL,`tacticsLog_time` int(11) default NULL,`holdOriginal_time` int(11) default NULL,`holdHour_time` int(11) default NULL,`holdDay_time` int(11) default NULL,`dayReport_time` int(11) default NULL,`weekReport_time` int(11) default NULL,`monthReport_time` int(11) default NULL,`yearReport_time` int(11) default NULL,`divertDelay_Time` int(11) default NULL,`devsyslog_Time` int(11) default NULL,`pageSize_num` int(11) DEFAULT NULL,PRIMARY KEY  (`pkid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT INTO `lego`.`t_atic_logholdtime`  VALUES ('1','0','90','30','12','1','60','6','1','5','300','30','10');

DROP TABLE IF EXISTS t_atic_pageconfig;
CREATE TABLE `t_atic_pageconfig` (`pkid` bigint(20) NOT NULL AUTO_INCREMENT,`sys_var` varchar(16) COLLATE utf8_bin DEFAULT NULL,`sys_value` varchar(128) COLLATE utf8_bin DEFAULT NULL,`remark` varchar(128) COLLATE utf8_bin DEFAULT NULL,PRIMARY KEY (`pkid`)) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT INTO `lego`.`t_atic_pageconfig`  VALUES ('1','pageSize','10','The number of pageSize');
INSERT INTO `lego`.`t_atic_pageconfig`  VALUES ('2','notifyTime','600','The number of notifyTime');
INSERT INTO `lego`.`t_atic_pageconfig`  VALUES ('3','unblockTime','30','The number of blackHoleTimeOut');
INSERT INTO `lego`.`t_atic_pageconfig`  VALUES ('4','packetFile','90','The number of packetFileDelayTime');
INSERT INTO `lego`.`t_atic_pageconfig`  VALUES ('5','whiteTime','30','The number of blackHoleWhiteTime');

DROP TABLE IF EXISTS t_vsm_filter_http;
CREATE TABLE `t_vsm_filter_http` (`pkid` bigint(20) NOT NULL AUTO_INCREMENT,`filter_id` bigint(20) DEFAULT NULL,`filter_key` varchar(255) COLLATE utf8_bin DEFAULT NULL,`filter_content` varchar(600) COLLATE utf8_bin DEFAULT NULL,PRIMARY KEY (`pkid`)) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'DNS_Amplification'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'DNS_Amplification'),'source-port','53~53');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Chargen_Amplification'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Chargen_Amplification'),'source-port','19~19');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'SNMP_Amplification'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'SNMP_Amplification'),'source-port','161~161');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'TFTP_Amplification'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'TFTP_Amplification'),'source-port','69~69');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'NTP_Amplification'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'NTP_Amplification'),'source-port','123~123');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'NetBIOS_Amplification'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'NetBIOS_Amplification'),'source-port','137~137');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'SSDP_Amplification_Attack'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'SSDP_Amplification_Attack'),'source-port','1900~1900');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'QOTD_Amplification'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'QOTD_Amplification'),'source-port','17~17');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Quake_Network_Protocol'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Quake_Network_Protocol'),'source-port','27960~27960');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Steam_Protocol_Amplification'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Steam_Protocol_Amplification'),'source-port','27015~27015');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Portmapper_Amplification'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Portmapper_Amplification'),'source-port','111~111');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Wordpress_Amplification'),'user-agent','include    wordpress');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Wordpress_Amplification'),'user-agent','include    WordPress');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Microsoft_SQL_Resolution_Service_Amplification'),'source-port','1434~1434');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Microsoft_SQL_Resolution_Service_Amplification'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'RIPV1_Amplification_Attack'),'source-port','520~520');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'RIPV1_Amplification_Attack'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Sentinel_Amplification_Attack'),'source-port','5093~5093');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Sentinel_Amplification_Attack'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'LDAP_Amplification_Attack'),'source-port','389~389');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'LDAP_Amplification_Attack'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'QUIC'),'destination-port','80~80');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'mDNS_Amplification'),'source-port','5353~5353');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'mDNS_Amplification'),'packet-length','256~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Memcached_Amplification'),'source-port','11211~11211');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'IPMI_Amplification_Attack'),'packet-length','58~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'IPMI_Amplification_Attack'),'source-port','623~623');


/* 误防漏防 添加默认指标信息 */
DROP TABLE IF EXISTS `t_atic_streamonitor_measurename`;
CREATE TABLE `t_atic_streamonitor_measurename` (  `pkid` INT(11) NOT NULL AUTO_INCREMENT,  `name` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,  `description` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,  `type` INT(11) DEFAULT NULL,  PRIMARY KEY (`pkid`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;
insert  into `t_atic_streamonitor_measurename`(`pkid`,`name`,`description`,`type`) values (1,'synPps','基于目的IP的SYN pps',0),(2,'srcSynPps','基于源的IP的SYN pps',0),(3,'ackPps','基于目的IP的ACK pps',0),(4,'srcAckKbps','基于源的IP的ACK Kbps',0),(5,'synAckRatio','基于目的IP的SYN/ACK比例',0),(6,'tcpIncreaseCon','基于目的IP的TCP新建连接数',0),(7,'tcpConcurCon','基于目的IP的TCP并发连接数',0),(8,'srcIncreaseCon','基于源的IP的新建连接数',0),(9,'srcConcurCon','基于源的IP的并发连接数',0),(10,'httpQps','HTTP基于目的IP的HTTP qps',0),(11,'udpKbps','基于目的IP的UDP Kbps',0),(12,'dnsRequestPps','基于目的IP的DNS pps',0),(13,'attackTypeSet_11','ACK攻击',1),(14,'attackTypeSet_45','DNS攻击',1),(15,'attackTypeSet_27','HTTP攻击',1),(16,'httpQps','HTTP基于目的IP的HTTP qps',1),(17,'attackTypeSet_10','SYN攻击',1),(18,'attackTypeSet_19','UDP攻击',1),(19,'blackTypeSet_15','慢速攻击黑名单',1),(20,'ackPps','基于目的IP的ACK pps',1),(21,'dnsRequestPps','基于目的IP的DNS pps',1),(22,'synPps','基于目的IP的SYN pps',1),(23,'tcpConcurCon','基于目的IP的TCP并发连接数',1),(24,'tcpIncreaseCon','基于目的IP的TCP新建连接数',1),(25,'udpKbps','基于目的IP的UDP Kbps',1),(26,'srcIncreaseCon','基于源的IP的新建连接数',1),(27,'blackTypeSet_23','SYN黑名单',1),(28,'blackTypeSet_24','ACK黑名单',1),(29,'blackTypeSet_5','TCP连接异常黑名单',1), (30,'ackPpsRatio','基于目的IP的出流量/入流量的 ACK pps比例',1);

DROP TABLE IF EXISTS `t_atic_streamonitor_rule`;
CREATE TABLE `t_atic_streamonitor_rule` (
	`pkid` INT(11) NOT NULL AUTO_INCREMENT,
	`ruleName` VARCHAR (255),
	`description` VARCHAR (255),
	PRIMARY KEY  (`pkid`) 
);
/* 插入数据到误防漏防规则表 */
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('1','ACK False Negative Check','Checks the configuration and application of ACK defense');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('2','SYN False Negative Check','Checks the configuration and application of SYN defense');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('3','TCP NewCurCon False Negative Check','Checks the configuration and application of TCP connection defense');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('4','HTTP False Negative Check','Checks the configuration and application of HTTP defense');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('5','UDP False Negative Check','Checks the configuration and application of UDP defense');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('6','DNS False Negative Check','Checks the configuration and application of DNS defense');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('7','SYN False Positive Check','Checks the application of SYN defense');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('8','ACK False Positive Check','Checks the application of ACK defense');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('9','TCP NewCurCon False Positive Check','Checks the application of TCP connection defense');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('10','HTTP False Positive Check','Checks the application of HTTP defense');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('11','UDP False Positive Check','Checks the application of UDP defense');
INSERT INTO `t_atic_streamonitor_rule` (`pkid`, `ruleName`, `description`) VALUES('12','DNS Request False Positive Check','Checks the application of DNS defense');

DROP TABLE IF EXISTS `t_atic_streamonitor_ruleconditionrelationship`;
CREATE TABLE `t_atic_streamonitor_ruleconditionrelationship` (
	`pkid` INT(11) NOT NULL AUTO_INCREMENT ,
	`ruleId` INT ,
	`measureName` VARCHAR (255),
	`operator` INT ,
	`targetValue` VARCHAR (255),
	`groupId` INT ,
	`conditionInGroupId` INT ,
	`logicOperator` INT ,
	`type` INT,
	PRIMARY KEY  (`pkid`)
);
/* 插入数据到误防漏防规则 条件关系表 */
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('1','1','ackPps','0','5000','1','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('2','1','tcpConcurCon','0','1000','2','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('3','1','synAckRatio','1','20','2','2','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('4','1','srcAckKbps','0','5000','2','3','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('5','2','synPps','0','10000','1','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('6','2','synAckRatio','0','40','2','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('7','2','tcpConcurCon','0','5000','2','2','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('8','2','srcSynPps','0','5000','2','3','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('9','3','srcIncreaseCon','0','5000','1','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('10','3','srcConcurCon','0','2000','1','2','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('11','3','tcpIncreaseCon','0','1000','2','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('12','3','tcpConcurCon','0','1000','2','2','1','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('13','4','httpQps','0','5000','1','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('14','5','udpKbps','0','10000','1','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('15','6','dnsRequestPps','0','5000','1','1','0','0');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('16','7','srcIncreaseCon','1','80','1','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('17','7','synPps','1','80','1','2','1','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('18','7','tcpIncreaseCon','1','80','2','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('19','7','attackTypeSet_10','0','1','3','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('20','7','blackTypeSet_23','0','1','3','2','1','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('21','8','ackPps','1','90','1','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('22','8','attackTypeSet_11','0','1','2','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('23','8','blackTypeSet_24','0','1','2','2','1','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('24','8','ackPpsRatio','1','50','3','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('25','9','tcpIncreaseCon','1','80','1','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('26','9','tcpConcurCon','1','80','1','2','1','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('27','9','blackTypeSet_5','0','1','3','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('28','10','httpQps','1','80','1','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('29','10','attackTypeSet_27','0','1','2','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('30','10','blackTypeSet_15','0','1','2','2','1','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('31','11','udpKbps','1','80','1','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('32','11','attackTypeSet_19','0','1','2','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('33','12','dnsRequestPps','1','80','1','1','0','1');
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`pkid`, `ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('34','12','attackTypeSet_45','0','1','2','1','0','1');

