USE `lego`$$

DROP PROCEDURE IF EXISTS `currentFaultDump`$$

CREATE PROCEDURE `currentFaultDump`(
IN v_count_dump INT
)
BEGIN

DECLARE	v_confirm_and_clear INT;
DECLARE	v_confirm INT;

IF v_count_dump = NULL THEN 
	SET v_count_dump = 10000;
END IF;

SET v_confirm_and_clear = (SELECT COUNT(tmp.fault_id) FROM (SELECT t.fault_id,t.clear_status,t.confirm_status FROM t_fault t WHERE t.clear_status IS NOT TRUE OR t.confirm_status IS NOT TRUE ORDER BY t.mod_time ASC LIMIT v_count_dump) tmp WHERE tmp.clear_status IS NOT TRUE AND tmp.confirm_status IS NOT true);

UPDATE  t_fault t SET t.clear_status=TRUE,t.confirm_status=TRUE,t.clear_user='--',t.confirm_user='--',t.clear_time=now(),t.confirm_time=now()
WHERE EXISTS
  (
    SELECT 1 FROM  
    (
      SELECT fault_id,clear_status,confirm_status 
      FROM t_fault 
      WHERE 
      clear_status IS NOT TRUE 
      OR confirm_status IS NOT TRUE 
      ORDER BY mod_time ASC
      LIMIT v_count_dump
    ) tmp
    WHERE 
      tmp.clear_status IS NOT TRUE 
      AND tmp.confirm_status IS NOT TRUE 
      AND tmp.fault_id=t.fault_id
  );
  
SET v_count_dump = v_count_dump - v_confirm_and_clear;

SET v_confirm = (SELECT COUNT(tmp.fault_id) FROM (SELECT t.fault_id,t.clear_status,t.confirm_status FROM t_fault t WHERE t.clear_status IS NOT TRUE OR t.confirm_status IS NOT TRUE ORDER BY t.mod_time ASC LIMIT v_count_dump) tmp WHERE tmp.clear_status IS NOT TRUE AND tmp.confirm_status IS true);

UPDATE  t_fault t SET t.clear_status=TRUE,t.clear_user='--',t.clear_time=now()
WHERE EXISTS
  (
    SELECT 1 FROM  
    (
      SELECT fault_id,clear_status,confirm_status 
      FROM t_fault 
      WHERE 
      clear_status IS NOT TRUE 
      OR confirm_status IS NOT TRUE 
      ORDER BY mod_time ASC
      LIMIT v_count_dump
    ) tmp
    WHERE
      tmp.clear_status IS NOT TRUE
      AND tmp.confirm_status IS TRUE
      AND tmp.fault_id=t.fault_id
  );

SET v_count_dump = v_count_dump - v_confirm;

UPDATE  t_fault t SET t.confirm_status=TRUE,t.confirm_user='--',t.confirm_time=now()
WHERE EXISTS
  (
    SELECT 1 FROM  
    (
      SELECT fault_id,clear_status,confirm_status 
      FROM t_fault 
      WHERE 
      clear_status IS NOT TRUE 
      OR confirm_status IS NOT TRUE 
      ORDER BY mod_time ASC
      LIMIT v_count_dump
    ) tmp
    WHERE
      tmp.clear_status IS TRUE
      AND tmp.confirm_status IS NOT TRUE
      AND tmp.fault_id=t.fault_id
  );


	SELECT 'end';
END$$